/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.memory;

import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlock;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlock;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IMemorySpaces;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.gdb.internal.memory.Messages;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.MemoryByte;

public class GdbMemoryBlock
extends DsfMemoryBlock
implements IMemorySpaceAwareMemoryBlock {
    private final String fMemorySpaceID;

    GdbMemoryBlock(DsfMemoryBlockRetrieval retrieval, IMemory.IMemoryDMContext context, String modelId, String expression, BigInteger address, int word_size, long length, String memorySpaceID) {
        super(retrieval, context, modelId, expression, address, word_size, length);
        String string = this.fMemorySpaceID = memorySpaceID != null && memorySpaceID.length() > 0 ? memorySpaceID : null;
        assert (memorySpaceID == null || memorySpaceID.length() > 0);
    }

    protected MemoryByte[] fetchMemoryBlock(BigInteger bigAddress, final long length) throws DebugException {
        final Addr64 address = new Addr64(bigAddress);
        Query<MemoryByte[]> query = new Query<MemoryByte[]>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(final DataRequestMonitor<MemoryByte[]> drm) {
                IMemorySpaces memoryService;
                GdbMemoryBlockRetrieval retrieval = (GdbMemoryBlockRetrieval)GdbMemoryBlock.this.getMemoryBlockRetrieval();
                int addressableSize = 1;
                try {
                    addressableSize = GdbMemoryBlock.this.getAddressableSize();
                }
                catch (DebugException debugException) {}
                Object var4_4 = null;
                if (GdbMemoryBlock.this.fMemorySpaceID != null) {
                    memoryService = (IMemorySpaces)retrieval.getMemorySpaceServiceTracker().getService();
                    if (memoryService == null) {
                        drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, Messages.Err_MemoryServiceNotAvailable, null));
                        drm.done();
                        return;
                    }
                    MemorySpaceDMContext memorySpaceDMContext = new MemorySpaceDMContext(memoryService.getSession().getId(), GdbMemoryBlock.this.fMemorySpaceID, (IDMContext)GdbMemoryBlock.this.getContext());
                } else {
                    IMemory.IMemoryDMContext iMemoryDMContext = GdbMemoryBlock.this.getContext();
                }
                memoryService = (IMemory)retrieval.getServiceTracker().getService();
                if (memoryService != null) {
                    void var4_7;
                    memoryService.getMemory((IMemory.IMemoryDMContext)var4_7, (IAddress)address, 0L, addressableSize, (int)length, (DataRequestMonitor)new DataRequestMonitor<MemoryByte[]>((Executor)retrieval.getExecutor(), drm){

                        protected void handleSuccess() {
                            drm.setData((Object)((MemoryByte[])this.getData()));
                            drm.done();
                        }
                    });
                    return;
                }
                drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, Messages.Err_MemoryServiceNotAvailable, null));
                drm.done();
            }
        };
        GdbMemoryBlockRetrieval retrieval = (GdbMemoryBlockRetrieval)this.getMemoryBlockRetrieval();
        retrieval.getExecutor().execute((Runnable)query);
        try {
            return (MemoryByte[])query.get();
        }
        catch (InterruptedException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, Messages.Err_MemoryReadFailed, (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, Messages.Err_MemoryReadFailed, (Throwable)e));
        }
    }

    protected void writeMemoryBlock(final long offset, final byte[] bytes) throws DebugException {
        final Addr64 address = new Addr64(this.getBigBaseAddress());
        Query<MemoryByte[]> query = new Query<MemoryByte[]>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            protected void execute(DataRequestMonitor<MemoryByte[]> drm) {
                IMemorySpaces memoryService;
                GdbMemoryBlockRetrieval retrieval = (GdbMemoryBlockRetrieval)GdbMemoryBlock.this.getMemoryBlockRetrieval();
                int addressableSize = 1;
                Object var4_4 = null;
                if (GdbMemoryBlock.this.fMemorySpaceID != null) {
                    memoryService = (IMemorySpaces)retrieval.getMemorySpaceServiceTracker().getService();
                    if (memoryService == null) {
                        drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, Messages.Err_MemoryServiceNotAvailable, null));
                        drm.done();
                        return;
                    }
                    MemorySpaceDMContext memorySpaceDMContext = new MemorySpaceDMContext(memoryService.getSession().getId(), GdbMemoryBlock.this.fMemorySpaceID, (IDMContext)GdbMemoryBlock.this.getContext());
                } else {
                    IMemory.IMemoryDMContext iMemoryDMContext = GdbMemoryBlock.this.getContext();
                }
                memoryService = (IMemory)retrieval.getServiceTracker().getService();
                if (memoryService != null) {
                    void var4_7;
                    memoryService.setMemory((IMemory.IMemoryDMContext)var4_7, (IAddress)address, offset, addressableSize, bytes.length, bytes, new RequestMonitor((Executor)retrieval.getExecutor(), drm));
                    return;
                }
                drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, Messages.Err_MemoryServiceNotAvailable, null));
                drm.done();
            }
        };
        GdbMemoryBlockRetrieval retrieval = (GdbMemoryBlockRetrieval)this.getMemoryBlockRetrieval();
        retrieval.getExecutor().execute((Runnable)query);
        try {
            query.get();
        }
        catch (InterruptedException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, Messages.Err_MemoryWriteFailed, (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, Messages.Err_MemoryWriteFailed, (Throwable)e));
        }
    }

    public String getMemorySpaceID() {
        return this.fMemorySpaceID;
    }

    public String getExpression() {
        if (this.fMemorySpaceID != null) {
            assert (this.fMemorySpaceID.length() > 0);
            GdbMemoryBlockRetrieval retrieval = (GdbMemoryBlockRetrieval)this.getMemoryBlockRetrieval();
            return retrieval.encodeAddress(super.getExpression(), this.fMemorySpaceID);
        }
        return super.getExpression();
    }

    public int getAddressSize() throws DebugException {
        IGDBMemory memoryService;
        GdbMemoryBlockRetrieval retrieval = (GdbMemoryBlockRetrieval)this.getMemoryBlockRetrieval();
        Object context = null;
        if (this.fMemorySpaceID != null) {
            IMemorySpaces memorySpacesService = (IMemorySpaces)retrieval.getMemorySpaceServiceTracker().getService();
            if (memorySpacesService != null) {
                context = new MemorySpaceDMContext(memorySpacesService.getSession().getId(), this.fMemorySpaceID, (IDMContext)this.getContext());
            }
        } else {
            context = this.getContext();
        }
        if ((memoryService = (IGDBMemory)retrieval.getServiceTracker().getService()) != null) {
            return memoryService.getAddressSize((IMemory.IMemoryDMContext)context);
        }
        throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, Messages.Err_MemoryServiceNotAvailable, null));
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        super.eventDispatched(e);
        if (e.getReason() == IRunControl.StateChangeReason.BREAKPOINT || e.getReason() == IRunControl.StateChangeReason.EVENT_BREAKPOINT || e.getReason() == IRunControl.StateChangeReason.WATCHPOINT) {
            DebugEvent debugEvent = new DebugEvent((Object)this, 2, 16);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
        }
    }

    public static class MemorySpaceDMContext
    extends AbstractDMContext
    implements IMemorySpaces.IMemorySpaceDMContext {
        private final String fMemorySpaceId;

        public MemorySpaceDMContext(String sessionId, String memorySpaceId, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.fMemorySpaceId = memorySpaceId;
        }

        public String getMemorySpaceId() {
            return this.fMemorySpaceId;
        }

        public boolean equals(Object other) {
            if (other instanceof MemorySpaceDMContext) {
                MemorySpaceDMContext dmc = (MemorySpaceDMContext)((Object)other);
                return super.baseEquals(other) && dmc.fMemorySpaceId.equals(this.fMemorySpaceId);
            }
            return false;
        }

        public int hashCode() {
            return super.baseHashCode() + this.fMemorySpaceId.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".memoryspace[" + this.fMemorySpaceId + ']';
        }
    }
}

