/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CPPASTNamespaceAlias
extends ASTNode
implements ICPPASTNamespaceAlias {
    private IASTName alias;
    private IASTName qualifiedName;

    public CPPASTNamespaceAlias(IASTName alias, IASTName qualifiedName) {
        this.setAlias(alias);
        this.setMappingName(qualifiedName);
    }

    @Override
    public CPPASTNamespaceAlias copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTNamespaceAlias copy(IASTNode.CopyStyle style) {
        CPPASTNamespaceAlias copy = new CPPASTNamespaceAlias(this.alias == null ? null : this.alias.copy(style), this.qualifiedName == null ? null : this.qualifiedName.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IASTName getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(IASTName name) {
        this.assertNotFrozen();
        this.alias = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ALIAS_NAME);
        }
    }

    @Override
    public IASTName getMappingName() {
        return this.qualifiedName;
    }

    @Override
    public void setMappingName(IASTName qualifiedName) {
        this.assertNotFrozen();
        this.qualifiedName = qualifiedName;
        if (qualifiedName != null) {
            qualifiedName.setParent(this);
            qualifiedName.setPropertyInParent(MAPPING_NAME);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.alias != null && !this.alias.accept(action)) {
            return false;
        }
        if (this.qualifiedName != null && !this.qualifiedName.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (this.alias == n) {
            return 2;
        }
        if (this.qualifiedName == n) {
            return 1;
        }
        return 3;
    }
}

