/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.utils.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatureExtensionManager<E> {
    protected final String extensionPoint;
    protected final String classAttr = "class";
    private final String universalNatureId;
    private final Class<?> elementType;
    private Map<String, Object> extensions;

    public NatureExtensionManager(String extensionPoint, Class<E> elementType) {
        this(extensionPoint, elementType, null);
    }

    public NatureExtensionManager(String extensionPoint, Class<?> elementType, String universalNatureId) {
        this.extensionPoint = extensionPoint;
        this.elementType = elementType;
        this.universalNatureId = universalNatureId;
    }

    private synchronized void initialize() {
        if (this.extensions != null) {
            return;
        }
        this.extensions = new HashMap<String, Object>(5);
        this.registerConfigurationElements();
        for (List list : this.extensions.values()) {
            this.initializeDescriptors(list);
        }
    }

    protected void registerConfigurationElements() {
        this.registerConfigurationElements(Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPoint), this.getCategoryAttributeName());
    }

    protected void registerConfigurationElements(IConfigurationElement[] confElements, String categoryAttr) {
        int i = 0;
        while (i < confElements.length) {
            IConfigurationElement confElement = confElements[i];
            if (this.isValidElement(confElement)) {
                String category = confElement.getAttribute(categoryAttr);
                if (category != null) {
                    ArrayList<Object> elements = (ArrayList<Object>)this.extensions.get(category);
                    if (elements == null) {
                        elements = new ArrayList<Object>();
                        this.extensions.put(category, elements);
                    }
                    elements.add(this.createDescriptor(confElement));
                } else {
                    Object[] bindings = new String[]{categoryAttr, this.extensionPoint, confElement.getContributor().getName()};
                    String msg = NLS.bind((String)Messages.NatureExtensionManager_missingCategoryAttribute, (Object[])bindings);
                    DLTKCore.warn(msg);
                }
            }
            ++i;
        }
    }

    protected boolean isValidElement(IConfigurationElement element) {
        return true;
    }

    protected String getCategoryAttributeName() {
        return "nature";
    }

    protected void initializeDescriptors(List<Object> descriptors) {
    }

    public E[] getInstances(String natureId) {
        E[] all;
        this.initialize();
        E[] nature = this.filter(this.getByNature(natureId), natureId);
        E[] EArray = all = this.universalNatureId != null ? this.filter(this.getByNature(this.universalNatureId), natureId) : null;
        if (nature != null) {
            if (all != null) {
                return this.merge(all, nature);
            }
            return nature;
        }
        if (all != null) {
            return all;
        }
        return this.createEmptyResult();
    }

    protected E[] merge(E[] all, E[] nature) {
        E[] result = this.createArray(all.length + nature.length);
        System.arraycopy(all, 0, result, 0, all.length);
        System.arraycopy(nature, 0, result, all.length, nature.length);
        return result;
    }

    protected E[] filter(E[] objects, String natureId) {
        return objects;
    }

    public E[] getAllInstances() {
        this.initialize();
        ArrayList<E> result = new ArrayList<E>();
        Iterator<String> i = this.extensions.keySet().iterator();
        while (i.hasNext()) {
            E[] natureInstances = this.getByNature(i.next());
            if (natureInstances == null) continue;
            int j = 0;
            while (j < natureInstances.length) {
                result.add(natureInstances[j]);
                ++j;
            }
        }
        E[] resultArray = this.createArray(result.size());
        result.toArray(resultArray);
        return resultArray;
    }

    protected E[] createEmptyResult() {
        return null;
    }

    protected E[] createArray(int length) {
        return (Object[])Array.newInstance(this.elementType, length);
    }

    protected boolean isInstance(Object e) {
        return this.elementType.isAssignableFrom(e.getClass());
    }

    protected boolean isValidInstance(Object e) {
        return this.isInstance(e);
    }

    private E[] getByNature(String natureId) {
        Object ext = this.extensions.get(natureId);
        if (ext != null) {
            if (ext instanceof Object[]) {
                return (Object[])ext;
            }
            if (ext instanceof List) {
                List elements = (List)ext;
                ArrayList<Object> result = new ArrayList<Object>(elements.size());
                int i = 0;
                while (i < elements.size()) {
                    Object element = elements.get(i);
                    if (this.isInstance(element)) {
                        result.add(element);
                    } else {
                        try {
                            Object instance = this.createInstanceByDescriptor(element);
                            if (instance != null && this.isValidInstance(instance)) {
                                result.add(instance);
                            }
                        }
                        catch (Exception e) {
                            String msg = NLS.bind((String)Messages.NatureExtensionManager_instantiantionError, (Object)this.elementType.getName());
                            DLTKCore.error(msg, e);
                        }
                    }
                    ++i;
                }
                E[] resultArray = this.createArray(result.size());
                result.toArray(resultArray);
                this.saveInstances(natureId, resultArray);
                return resultArray;
            }
        }
        return null;
    }

    protected void saveInstances(String natureId, E[] resultArray) {
        this.extensions.put(natureId, resultArray);
    }

    protected Object createDescriptor(IConfigurationElement confElement) {
        return confElement;
    }

    protected Object createInstanceByDescriptor(Object descriptor) throws CoreException {
        IConfigurationElement cfg = (IConfigurationElement)descriptor;
        return cfg.createExecutableExtension("class");
    }
}

