/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui;

import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.rpm.ui.BuildType;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.RpmConsole;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.osgi.framework.FrameworkUtil;

public class RPMExportOperation
extends Job {
    private RPMProject rpmProject;
    private BuildType exportType;

    public RPMExportOperation(RPMProject rpmProject, BuildType exportType) {
        super(Messages.getString("RPMExportWizard.0"));
        this.rpmProject = rpmProject;
        this.exportType = exportType;
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus result = null;
        IOConsole myConsole = this.findConsole();
        IOConsoleOutputStream out = myConsole.newOutputStream();
        myConsole.clearConsole();
        myConsole.activate();
        switch (this.exportType) {
            case ALL: {
                try {
                    monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_RPM_Export"));
                    result = this.rpmProject.buildAll((OutputStream)out);
                }
                catch (CoreException e) {
                    result = new Status(4, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                }
                break;
            }
            case BINARY: {
                monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_RPM_Export"));
                try {
                    result = this.rpmProject.buildBinaryRPM((OutputStream)out);
                }
                catch (CoreException e) {
                    result = new Status(4, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                }
                break;
            }
            case SOURCE: {
                monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_SRPM_Export"));
                try {
                    result = this.rpmProject.buildSourceRPM((OutputStream)out);
                    break;
                }
                catch (CoreException e) {
                    result = new Status(4, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    private IOConsole findConsole() {
        IConsole[] existingConsoles;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] iConsoleArray = existingConsoles = conMan.getConsoles();
        int n = existingConsoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (("rpmbuild(" + this.rpmProject.getSpecFile().getProject().getName() + ')').equals(console.getName())) {
                RpmConsole myConsole = (RpmConsole)console;
                myConsole.clearConsole();
                return myConsole;
            }
            ++n2;
        }
        RpmConsole myConsole = new RpmConsole(this.rpmProject);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

