/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.wizards.NewContainerWizardPage;
import org.eclipse.dltk.ui.wizards.NewSourceModulePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class NewSourceModuleInPackagePage
extends NewSourceModulePage {
    protected static final String PACKAGE = "NewPackagedSourceModulePage.package";
    protected IStatus packageStatus;
    private boolean sourceIsModifiable = true;
    private boolean autoCreateMissingPackages = false;
    private StringButtonDialogField fPackageDialogField;
    private IPath currentPackagePath = null;

    public NewSourceModuleInPackagePage() {
        PackageFieldAdapter packageFieldAdapter = new PackageFieldAdapter();
        this.fPackageDialogField = new StringButtonDialogField(packageFieldAdapter);
        this.fPackageDialogField.setDialogFieldListener(packageFieldAdapter);
        this.fPackageDialogField.setButtonLabel(NewWizardMessages.NewSourceModuleInPackagePage_package_button);
        this.fPackageDialogField.setLabelText(this.getPackageLabel());
        this.packageStatus = new StatusInfo();
    }

    public boolean isAutoCreateMissingPackages() {
        return this.autoCreateMissingPackages;
    }

    public void setAutoCreateMissingPackages(boolean autoCreateMissingPackages) {
        this.autoCreateMissingPackages = autoCreateMissingPackages;
    }

    public void setSource(IProjectFragment src, boolean canBeModified) {
        this.sourceIsModifiable = canBeModified;
        if (src == null) {
            super.setScriptFolder(null, this.sourceIsModifiable);
        } else {
            super.setScriptFolder(src.getScriptFolder(""), this.sourceIsModifiable);
        }
    }

    public IProjectFragment getSource() {
        return this.getProjectFragment();
    }

    public void setPackage(IPath srcRelativePath, boolean canBeModified) {
        this.currentPackagePath = srcRelativePath;
        if (this.currentPackagePath == null) {
            this.fPackageDialogField.setText("");
        } else {
            String str = this.currentPackagePath.toString();
            this.fPackageDialogField.setText(str);
        }
        this.fPackageDialogField.setEnabled(canBeModified);
    }

    public IPath getPackage() {
        return this.currentPackagePath;
    }

    public void setScriptFolder(IScriptFolder root, boolean canBeModified) {
        IProjectFragment src = null;
        IPath packPath = null;
        if (root != null && (src = (IProjectFragment)root.getAncestor(3)) != null) {
            IPath srcPath = src.getPath();
            packPath = root.getPath().makeRelativeTo(srcPath);
        }
        this.setSource(src, canBeModified);
        this.setPackage(packPath, canBeModified);
    }

    public IScriptFolder getScriptFolder() {
        IProjectFragment src = this.getSource();
        if (src != null) {
            if (this.currentPackagePath == null) {
                return src.getScriptFolder("");
            }
            return src.getScriptFolder(this.currentPackagePath);
        }
        return null;
    }

    protected String getPackageLabel() {
        return NewWizardMessages.NewSourceModuleInPackagePage_package_label;
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public void setPackageText(String str, boolean canBeModified) {
        this.fPackageDialogField.setText(str);
        this.fPackageDialogField.setEnabled(canBeModified);
    }

    void containerChangeControlPressed(DialogField field) {
        IScriptFolder root = this.chooseContainer();
        if (root != null) {
            this.setSource((IProjectFragment)root.getAncestor(3), this.sourceIsModifiable);
        }
    }

    protected IScriptFolder chooseContainer() {
        IProjectFragment initElement = this.getProjectFragment();
        Class[] shownTypes = new Class[]{IScriptModel.class, IScriptProject.class, IProjectFragment.class};
        NewContainerWizardPage.ContainerViewerFilter filter = new NewContainerWizardPage.ContainerViewerFilter(shownTypes);
        Class[] acceptedTypes = new Class[]{IProjectFragment.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedTypes, false);
        IScriptFolder scriptFolder = this.doChooseContainer((IModelElement)initElement, filter, validator);
        return scriptFolder;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        if (status.isOK()) {
            try {
                if (this.getSource().getKind() == 1 && !this.getSource().isExternal()) {
                    return status;
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setError(NewWizardMessages.NewSourceModuleInPackagePage_error_ContainerIsNoSourceFolder);
            status = statusInfo;
        }
        return status;
    }

    private void packageChangeControlPressed() {
        IScriptFolder packageFolder = this.choosePackage();
        if (packageFolder == null) {
            return;
        }
        IProjectFragment projectFragment = (IProjectFragment)packageFolder.getAncestor(3);
        if (projectFragment != null) {
            IPath path = packageFolder.getPath().makeRelativeTo(projectFragment.getPath());
            this.setPackage(path, true);
        } else {
            DLTKUIPlugin.logErrorMessage("Illegal state, chosen package is not contained in a project fragment");
        }
    }

    protected IScriptFolder choosePackage() {
        Object[] packages = this.getAllPackages();
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewSourceModuleInPackagePage_ChoosePackageDialog_title);
        dialog.setMessage(NewWizardMessages.NewSourceModuleInPackagePage_ChoosePackageDialog_description);
        dialog.setEmptyListMessage(NewWizardMessages.NewSourceModuleInPackagePage_ChoosePackageDialog_empty);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        IScriptFolder packFolder = this.getScriptFolder();
        if (packFolder != null) {
            dialog.setInitialSelections(new Object[]{packFolder});
        }
        if (dialog.open() == 0) {
            return (IScriptFolder)dialog.getFirstResult();
        }
        return null;
    }

    protected IScriptFolder[] getAllPackages() {
        ArrayList<IScriptFolder> packages = new ArrayList<IScriptFolder>();
        IProjectFragment sourceFolder = this.getProjectFragment();
        if (sourceFolder != null) {
            try {
                IModelElement[] iModelElementArray = sourceFolder.getChildren();
                int n = iModelElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement e = iModelElementArray[n2];
                    if (e instanceof IScriptFolder) {
                        packages.add((IScriptFolder)e);
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return packages.toArray(new IScriptFolder[packages.size()]);
    }

    private void packageDialogFieldChanged() {
        this.packageStatus = this.packageChanged();
        this.handleFieldChanged(PACKAGE);
    }

    protected IStatus packageChanged() {
        StatusInfo status = new StatusInfo();
        String packName = this.getPackageText();
        if (packName.length() == 0) {
            status.setError(NewWizardMessages.NewPackageWizardPage_error_EnterName);
            return status;
        }
        IProjectFragment root = this.getProjectFragment();
        if (root != null && root.getScriptProject().exists()) {
            IScriptFolder pack = root.getScriptFolder(packName);
            IPath srcPath = root.getPath();
            this.currentPackagePath = pack.getPath().makeRelativeTo(srcPath);
            try {
                if (!pack.exists()) {
                    IFileStore store;
                    URI location = pack.getResource().getLocationURI();
                    if (location != null && (store = EFS.getStore((URI)location)).fetchInfo().exists()) {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExistsDifferentCase);
                    }
                    if (!status.isError() && !this.autoCreateMissingPackages) {
                        status.setError(NewWizardMessages.NewSourceModuleInPackagePage_error_PackageDoesNotExist);
                    }
                }
            }
            catch (CoreException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (PACKAGE.equals(fieldName)) {
            super.handleFieldChanged("NewContainerWizardPage.container");
        }
        if ("NewContainerWizardPage.container".equals(fieldName)) {
            this.packageStatus = this.packageChanged();
        }
        this.updateStatus(new IStatus[]{this.containerStatus, this.packageStatus, this.sourceModuleStatus});
    }

    public ISourceModule createFile(IProgressMonitor monitor) throws CoreException {
        if (this.autoCreateMissingPackages) {
            String packageName = this.getPackage().toString();
            this.getProjectFragment().createScriptFolder(packageName, true, monitor);
        }
        return super.createFile(monitor);
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        super.createContainerControls(parent, nColumns);
        this.createPackageControls(parent, nColumns);
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fPackageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace(composite);
        TextFieldNavigationHandler.install(text);
    }

    private class PackageFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private PackageFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewSourceModuleInPackagePage.this.packageDialogFieldChanged();
        }

        public void changeControlPressed(DialogField field) {
            NewSourceModuleInPackagePage.this.packageChangeControlPressed();
        }
    }
}

