/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class NewPackageWizardPage
extends NewContainerWizardPage {
    private static final String PAGE_NAME = "NewPackageWizardPage";
    protected static final String PACKAGE = "NewPackageWizardPage.package";
    private StringDialogField fPackageDialogField;
    private IStatus fPackageStatus;
    protected IScriptFolder fCreatedScriptFolder;

    public NewPackageWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewPackageWizardPage_title);
        this.setDescription(NewWizardMessages.NewPackageWizardPage_description);
        this.fCreatedScriptFolder = null;
        this.fPackageDialogField = new StringDialogField();
        this.fPackageDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NewPackageWizardPage.this.fPackageStatus = NewPackageWizardPage.this.packageChanged();
                NewPackageWizardPage.this.handleFieldChanged(NewPackageWizardPage.PACKAGE);
            }
        });
        this.fPackageDialogField.setLabelText(NewWizardMessages.NewPackageWizardPage_package_label);
        this.fPackageStatus = new StatusInfo();
    }

    public void init(IStructuredSelection selection) {
        IScriptFolder sf;
        IModelElement element = this.getInitialScriptElement(selection);
        this.initContainerPage(element);
        String name = "";
        if (element != null && (sf = (IScriptFolder)element.getAncestor(4)) != null && !sf.isRootFolder()) {
            name = sf.getElementName();
        }
        this.setPackageText(name, true);
        this.updateStatus(new IStatus[]{this.containerStatus, this.fPackageStatus});
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(NewWizardMessages.NewPackageWizardPage_info);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.createContainerControls(composite, 3);
        this.createPackageControls(composite, 3);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fPackageDialogField.setFocus();
    }

    private void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns - 1);
        Text text = this.fPackageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace(composite);
        TextFieldNavigationHandler.install(text);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.packageChanged();
        }
        this.updateStatus(new IStatus[]{this.containerStatus, this.fPackageStatus});
    }

    protected IStatus packageChanged() {
        StatusInfo status = new StatusInfo();
        String packName = this.getPackageText();
        if (packName.length() > 0) {
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add correct package name checking here...");
            }
        } else {
            status.setError(NewWizardMessages.NewPackageWizardPage_error_EnterName);
            return status;
        }
        IProjectFragment root = this.getProjectFragment();
        if (root != null && root.getScriptProject().exists()) {
            IScriptFolder pack = root.getScriptFolder(packName);
            try {
                if (pack.exists()) {
                    if (pack.containsScriptResources() || !pack.hasSubfolders()) {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExists);
                    } else {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageNotShown);
                    }
                } else {
                    IFileStore store;
                    URI location = pack.getResource().getLocationURI();
                    if (location != null && (store = EFS.getStore((URI)location)).fetchInfo().exists()) {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExistsDifferentCase);
                    }
                }
            }
            catch (CoreException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return status;
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public void setPackageText(String str, boolean canBeModified) {
        this.fPackageDialogField.setText(str);
        this.fPackageDialogField.setEnabled(canBeModified);
    }

    public IResource getModifiedResource() {
        IProjectFragment root = this.getProjectFragment();
        if (root != null) {
            return root.getScriptFolder(this.getPackageText()).getResource();
        }
        return null;
    }

    public IScriptFolder getNewScriptFolder() {
        return this.fCreatedScriptFolder;
    }

    public void createPackage(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProjectFragment root = this.getProjectFragment();
        String packName = this.getPackageText();
        this.fCreatedScriptFolder = root.createScriptFolder(packName, true, monitor);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }
}

