/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import com.sun.javafx.scene.text.HitInfo;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.util.Duration;

public class TextFieldBehavior
extends TextInputControlBehavior<TextField> {
    public static final int SCROLL_RATE = 15;
    private TextFieldSkin skin;
    private HorizontalDirection scrollDirection = null;
    private Timeline scrollSelectionTimeline = new Timeline();
    private EventHandler<ActionEvent> scrollSelectionHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent actionEvent) {
            TextField textField = (TextField)TextFieldBehavior.this.getControl();
            IndexRange indexRange = textField.getSelection();
            int n = indexRange.getStart();
            int n2 = indexRange.getEnd();
            switch (TextFieldBehavior.this.scrollDirection) {
                case RIGHT: {
                    if (n2 >= textField.getLength()) break;
                    textField.selectRange(n, ++n2);
                    break;
                }
                case LEFT: {
                    if (n <= 0) break;
                    textField.selectRange(--n, n2);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    };
    private ContextMenu contextMenu = new ContextMenu();
    private boolean focusGainedByMouseClick = false;
    private boolean shiftDown = false;
    private boolean deferClick = false;

    public TextFieldBehavior(TextField textField) {
        super(textField);
        if (PlatformUtil.isEmbedded()) {
            this.contextMenu.getStyleClass().add("text-input-context-menu");
        }
        this.scrollSelectionTimeline.setCycleCount(-1);
        ObservableList<KeyFrame> observableList = this.scrollSelectionTimeline.getKeyFrames();
        observableList.add(new KeyFrame(Duration.millis(15.0), this.scrollSelectionHandler, new KeyValue[0]));
        this.handleFocusChange();
        textField.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                TextFieldBehavior.this.handleFocusChange();
            }
        });
    }

    private void handleFocusChange() {
        TextField textField = (TextField)this.getControl();
        if (textField.isFocused()) {
            if (!this.focusGainedByMouseClick) {
                textField.selectRange(textField.getLength(), 0);
                this.setCaretAnimating(true);
            }
        } else {
            textField.selectRange(0, 0);
            this.focusGainedByMouseClick = false;
            this.setCaretAnimating(false);
        }
    }

    public void setTextFieldSkin(TextFieldSkin textFieldSkin) {
        this.skin = textFieldSkin;
    }

    @Override
    protected void fire(KeyEvent keyEvent) {
        TextField textField = (TextField)this.getControl();
        if (textField.getOnAction() != null) {
            textField.fireEvent(new ActionEvent(textField, null));
        } else {
            this.forwardToParent(keyEvent);
        }
    }

    @Override
    protected void deleteChar(boolean bl) {
        this.skin.deleteChar(bl);
    }

    @Override
    protected void replaceText(int n, int n2, String string) {
        this.skin.replaceText(n, n2, string);
    }

    @Override
    protected void setCaretAnimating(boolean bl) {
        if (this.skin != null) {
            this.skin.setCaretAnimating(bl);
        }
    }

    private void beep() {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TextField textField = (TextField)this.getControl();
        super.mousePressed(mouseEvent);
        if (!textField.isDisabled()) {
            if (!textField.isFocused()) {
                this.focusGainedByMouseClick = true;
                textField.requestFocus();
            }
            this.setCaretAnimating(false);
            if (mouseEvent.isPrimaryButtonDown() && !mouseEvent.isMiddleButtonDown() && !mouseEvent.isSecondaryButtonDown()) {
                HitInfo hitInfo = this.skin.getIndex(mouseEvent);
                int n = hitInfo.getInsertionIndex();
                int n2 = textField.getAnchor();
                int n3 = textField.getCaretPosition();
                if (mouseEvent.getClickCount() < 2 && (PlatformUtil.isEmbedded() || n2 != n3 && (n > n2 && n < n3 || n < n2 && n > n3))) {
                    this.deferClick = true;
                } else if (!(mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown())) {
                    switch (mouseEvent.getClickCount()) {
                        case 1: {
                            this.mouseSingleClick(hitInfo);
                            break;
                        }
                        case 2: {
                            this.mouseDoubleClick(hitInfo);
                            break;
                        }
                        case 3: {
                            this.mouseTripleClick(hitInfo);
                        }
                    }
                } else if (mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown() && mouseEvent.getClickCount() == 1) {
                    this.shiftDown = true;
                    if (PlatformUtil.isMac()) {
                        textField.extendSelection(n);
                    } else {
                        this.skin.positionCaret(hitInfo, true);
                    }
                }
                this.skin.setForwardBias(hitInfo.isLeading());
            }
        }
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        TextField textField = (TextField)this.getControl();
        if (!(textField.isDisabled() || this.deferClick || !mouseEvent.isPrimaryButtonDown() || mouseEvent.isMiddleButtonDown() || mouseEvent.isSecondaryButtonDown() || mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown())) {
            this.skin.positionCaret(this.skin.getIndex(mouseEvent), true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        TextField textField = (TextField)this.getControl();
        super.mouseReleased(mouseEvent);
        if (!textField.isDisabled()) {
            this.setCaretAnimating(false);
            if (this.deferClick) {
                this.deferClick = false;
                this.skin.positionCaret(this.skin.getIndex(mouseEvent), this.shiftDown);
                this.shiftDown = false;
            }
            this.setCaretAnimating(true);
        }
        if (mouseEvent.getButton() == MouseButton.SECONDARY) {
            if (this.contextMenu.isShowing()) {
                this.contextMenu.hide();
            } else {
                Object object;
                double d = mouseEvent.getScreenX();
                double d2 = mouseEvent.getScreenY();
                double d3 = mouseEvent.getSceneX();
                if (PlatformUtil.isEmbedded()) {
                    Point2D point2D;
                    if (textField.getSelection().getLength() == 0) {
                        this.skin.positionCaret(this.skin.getIndex(mouseEvent), false);
                        point2D = this.skin.getMenuPosition();
                    } else {
                        point2D = this.skin.getMenuPosition();
                        if (point2D != null && (point2D.getX() <= 0.0 || point2D.getY() <= 0.0)) {
                            this.skin.positionCaret(this.skin.getIndex(mouseEvent), false);
                            point2D = this.skin.getMenuPosition();
                        }
                    }
                    if (point2D != null) {
                        Point2D point2D2 = this.skin.localToScene(point2D);
                        Scene scene = this.skin.getScene();
                        Window window = scene.getWindow();
                        object = new Point2D(window.getX() + scene.getX() + point2D2.getX(), window.getY() + scene.getY() + point2D2.getY());
                        d = ((Point2D)object).getX();
                        d3 = point2D2.getX();
                        d2 = ((Point2D)object).getY();
                    }
                }
                this.skin.populateContextMenu(this.contextMenu);
                double d4 = this.contextMenu.prefWidth(-1.0);
                double d5 = d - (PlatformUtil.isEmbedded() ? d4 / 2.0 : 0.0);
                object = Utils.getScreenForPoint(d, 0.0);
                Rectangle2D rectangle2D = ((Screen)object).getBounds();
                if (d5 < rectangle2D.getMinX()) {
                    this.skin.getProperties().put("CONTEXT_MENU_SCREEN_X", d);
                    this.skin.getProperties().put("CONTEXT_MENU_SCENE_X", d3);
                    this.contextMenu.show((Node)this.getControl(), rectangle2D.getMinX(), d2);
                } else if (d + d4 > rectangle2D.getMaxX()) {
                    double d6 = d4 - (rectangle2D.getMaxX() - d);
                    this.skin.getProperties().put("CONTEXT_MENU_SCREEN_X", d);
                    this.skin.getProperties().put("CONTEXT_MENU_SCENE_X", d3);
                    this.contextMenu.show((Node)this.getControl(), d - d6, d2);
                } else {
                    this.skin.getProperties().put("CONTEXT_MENU_SCREEN_X", 0);
                    this.skin.getProperties().put("CONTEXT_MENU_SCENE_X", 0);
                    this.contextMenu.show((Node)this.getControl(), d5, d2);
                }
            }
        }
    }

    protected void mouseSingleClick(HitInfo hitInfo) {
        this.skin.positionCaret(hitInfo, false);
    }

    protected void mouseDoubleClick(HitInfo hitInfo) {
        TextField textField = (TextField)this.getControl();
        textField.previousWord();
        if (PlatformUtil.isWindows()) {
            textField.selectNextWord();
        } else {
            textField.selectEndOfNextWord();
        }
    }

    protected void mouseTripleClick(HitInfo hitInfo) {
        ((TextField)this.getControl()).selectAll();
    }
}

