/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.libhover.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BuildFunctionInfos {
    private Document document;
    private LibHoverInfo hoverInfo = new LibHoverInfo();

    public BuildFunctionInfos(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    protected FunctionInfo getFunctionInfoFromNode(String name, Node function_node, Document document) {
        FunctionInfo f = new FunctionInfo(name);
        NamedNodeMap function_node_map = function_node.getAttributes();
        Node function_node_returntype_node = function_node_map.item(0);
        String function_node_rt_name = function_node_returntype_node.getNodeName();
        if (function_node_rt_name.equals("returntype")) {
            String function_node_rt_value = function_node_returntype_node.getNodeValue();
            f.setReturnType(function_node_rt_value);
        }
        NodeList function_node_kids = function_node.getChildNodes();
        int fnk = 0;
        while (fnk < function_node_kids.getLength()) {
            Node function_node_kid = function_node_kids.item(fnk);
            String function_node_kid_name = function_node_kid.getNodeName();
            if (function_node_kid_name.equals("prototype")) {
                String prototype = null;
                NodeList function_node_parms = function_node_kid.getChildNodes();
                int fnp = 0;
                while (fnp < function_node_parms.getLength()) {
                    Node function_node_parm = function_node_parms.item(fnp);
                    String function_node_parm_name = function_node_parm.getNodeName();
                    if (function_node_parm_name.equals("parameter")) {
                        NamedNodeMap function_node_parm_map = function_node_parm.getAttributes();
                        Node function_node_parm_node = function_node_parm_map.item(0);
                        String parameter = function_node_parm_node.getNodeValue();
                        prototype = prototype == null ? parameter : String.valueOf(prototype) + ", " + parameter;
                    }
                    ++fnp;
                }
                f.setPrototype(prototype);
            } else if (function_node_kid_name.equals("headers")) {
                NodeList function_node_headers = function_node_kid.getChildNodes();
                int fnh = 0;
                while (fnh < function_node_headers.getLength()) {
                    Node function_node_header = function_node_headers.item(fnh);
                    String function_node_header_name = function_node_header.getNodeName();
                    if (function_node_header_name.equals("header")) {
                        NamedNodeMap function_node_header_map = function_node_header.getAttributes();
                        Node function_node_header_node = function_node_header_map.item(0);
                        f.addHeader(function_node_header_node.getNodeValue());
                    }
                    ++fnh;
                }
            } else if (function_node_kid_name.equals("groupsynopsis")) {
                NodeList synopsisNode;
                Element elem2;
                NamedNodeMap attr = function_node_kid.getAttributes();
                Node idnode = attr.getNamedItem("id");
                String id = idnode.getNodeValue();
                if (id != null && (elem2 = document.getElementById(id)) != null && (synopsisNode = elem2.getElementsByTagName("synopsis")) != null && synopsisNode.getLength() > 0) {
                    Node synopsis = synopsisNode.item(0);
                    Node textNode = synopsis.getLastChild();
                    f.setDescription(textNode.getNodeValue());
                }
            } else if (function_node_kid_name.equals("synopsis")) {
                Node textNode = function_node_kid.getLastChild();
                f.setDescription(textNode.getNodeValue());
            }
            ++fnk;
        }
        return f;
    }

    public void buildCPPInfo(String fileName) {
        Document document = this.getDocument();
        NodeList nl = document.getElementsByTagName("construct");
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            NamedNodeMap m = n.getAttributes();
            Node id = m.getNamedItem("id");
            if (id != null && id.getNodeValue().startsWith("function-")) {
                String name = id.getNodeValue().substring(9);
                NodeList nl2 = n.getChildNodes();
                int j = 0;
                while (j < nl2.getLength()) {
                    Node n2 = nl2.item(j);
                    if (n2.getNodeName().equals("function")) {
                        FunctionInfo f = this.getFunctionInfoFromNode(name, n2, document);
                        this.hoverInfo.functions.put(name, f);
                    }
                    ++j;
                }
            }
            ++i;
        }
        try {
            FileOutputStream f = new FileOutputStream(fileName);
            ObjectOutputStream out = new ObjectOutputStream(f);
            out.writeObject(this.hoverInfo);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            URI acDoc = new URI(args[0]);
            IPath p = URIUtil.toPath((URI)acDoc);
            InputStream docStream = null;
            if (p == null) {
                URL url = acDoc.toURL();
                docStream = url.openStream();
            } else {
                docStream = new FileInputStream(p.toFile());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(docStream);
            if (doc != null) {
                BuildFunctionInfos d = new BuildFunctionInfos(doc);
                d.buildCPPInfo(args[1]);
            }
            System.out.println("Built " + args[1] + " from " + args[0]);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

