/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelEvent;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;
import org.xml.sax.Attributes;

public class SessionsProcessor
extends XMLProcessor {
    public static final String SESSION_TAG = "session";
    private static final String SESSION_NAME_ATTR = "name";
    public static final String SAMPLE_COUNT_TAG = "count";
    public static final String EVENT_TAG = "event";
    private static final String EVENT_NAME_ATTR = "name";
    private OpModelSession currentSession;
    private OpModelEvent currentEvent;
    private ArrayList<OpModelSession> sessionList;

    public void startElement(String name, Attributes attrs, Object callData) {
        if (name.equals(SESSION_TAG)) {
            String sessionName = this.valid_string(attrs.getValue("name"));
            this.currentSession = new OpModelSession(this.currentEvent, sessionName);
        } else if (name.equals(EVENT_TAG)) {
            String eventName = attrs.getValue("name");
            this.currentEvent = new OpModelEvent(eventName);
            this.sessionList = new ArrayList();
        } else {
            super.startElement(name, attrs, callData);
        }
    }

    public void endElement(String name, Object callData) {
        if (name.equals(SESSION_TAG)) {
            this.sessionList.add(this.currentSession);
            this.currentSession = null;
        } else if (name.equals(EVENT_TAG)) {
            OpModelSession[] s = new OpModelSession[this.sessionList.size()];
            this.sessionList.toArray(s);
            this.currentEvent.setSessions(s);
            SessionInfo info = (SessionInfo)callData;
            info.list.add(this.currentEvent);
            this.currentEvent = null;
            this.sessionList = null;
        } else {
            super.endElement(name, callData);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SessionInfo {
        public ArrayList<OpModelEvent> list;

        public SessionInfo(ArrayList<OpModelEvent> list) {
            this.list = list;
        }
    }
}

