/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public abstract class AbstractDataAdapter {
    public abstract Document getDocument();

    public abstract void process();

    public InputStream getInputStream() {
        ByteArrayInputStream inp = null;
        DOMSource source = new DOMSource(this.getDocument());
        StringWriter stw = new StringWriter();
        StreamResult result = new StreamResult(stw);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
            inp = new ByteArrayInputStream(stw.toString().getBytes("UTF-8"));
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return inp;
    }

    public String toString() {
        String ret = null;
        DOMSource source = new DOMSource(this.getDocument());
        StringWriter stw = new StringWriter();
        StreamResult result = new StreamResult(stw);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
            ret = stw.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

