/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.model;

import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelEvent;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;

public class OpModelSession {
    private static final String DEFAULT_SESSION_STRING = "current";
    private OpModelEvent parentEvent;
    private OpModelImage image;
    private String name;
    private String printTabs = "";

    public OpModelSession(OpModelEvent event, String name) {
        this.parentEvent = event;
        this.name = name;
        this.image = null;
    }

    public OpModelImage getImage() {
        return this.image;
    }

    public OpModelEvent getEvent() {
        return this.parentEvent;
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        if (this.image == null) {
            return 0;
        }
        return this.image.getCount();
    }

    public boolean isDefaultSession() {
        return this.name.equals(DEFAULT_SESSION_STRING);
    }

    public void refreshModel() {
        this.image = this.getNewImage();
    }

    protected OpModelImage getNewImage() {
        return Oprofile.getModelData(this.parentEvent.getName(), this.name);
    }

    public String toString(String tabs) {
        this.printTabs = tabs;
        String s = this.toString();
        this.printTabs = "";
        return s;
    }

    public String toString() {
        String s = String.valueOf(this.name) + "\n";
        if (this.image != null) {
            s = String.valueOf(s) + this.printTabs + "Image: ";
            s = String.valueOf(s) + this.image.toString(String.valueOf(this.printTabs) + "\t");
        }
        return s;
    }
}

