/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.linuxtools.internal.oprofile.core.IOpcontrolProvider;
import org.eclipse.linuxtools.internal.oprofile.core.IOpxmlProvider;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileProperties;
import org.eclipse.linuxtools.internal.oprofile.core.linux.LinuxOpxmlProvider;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OprofileCorePlugin
extends Plugin {
    private static final String PLUGIN_ID = "org.eclipse.linuxtools.oprofile.core";
    private static OprofileCorePlugin plugin;
    private IOpxmlProvider opxmlProvider;
    public static final String DEBUG_PRINT_PREFIX = "DEBUG: ";

    public OprofileCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static OprofileCorePlugin getDefault() {
        return plugin;
    }

    public static String getId() {
        return PLUGIN_ID;
    }

    public IOpxmlProvider getOpxmlProvider() {
        this.opxmlProvider = new LinuxOpxmlProvider();
        return this.opxmlProvider;
    }

    public IOpcontrolProvider getOpcontrolProvider() throws OpcontrolException {
        IOpcontrolProvider opcontrolProvider = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.linuxtools.oprofile.core.OpcontrolProvider");
        if (extPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                if (configElements.length != 0) {
                    try {
                        String scheme = configElements[0].getAttribute("scheme");
                        if (Oprofile.OprofileProject.getProject() == null && scheme.equals("file")) {
                            opcontrolProvider = (IOpcontrolProvider)configElements[0].createExecutableExtension("class");
                            break;
                        }
                        if (Oprofile.OprofileProject.getProject().getLocationURI().getScheme().equals(scheme)) {
                            opcontrolProvider = (IOpcontrolProvider)configElements[0].createExecutableExtension("class");
                        }
                    }
                    catch (CoreException ce) {
                        ce.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        if (opcontrolProvider == null) {
            throw new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolProvider", null));
        }
        return opcontrolProvider;
    }

    public static IStatus createErrorStatus(String errorClassString, Exception e) {
        String statusMessage = OprofileProperties.getString(String.valueOf(errorClassString) + ".error.statusMessage");
        if (e == null) {
            return new Status(4, OprofileCorePlugin.getId(), 0, statusMessage, null);
        }
        return new Status(4, OprofileCorePlugin.getId(), 0, statusMessage, (Throwable)e);
    }

    public static void showErrorDialog(String errorClassString, CoreException ex) {
        final String dialogTitle = OprofileProperties.getString(String.valueOf(errorClassString) + ".error.dialog.title");
        final String errorMessage = OprofileProperties.getString(String.valueOf(errorClassString) + ".error.dialog.message");
        final IStatus status = ex == null ? OprofileCorePlugin.createErrorStatus(errorClassString, null) : ex.getStatus();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)dialogTitle, (String)errorMessage, (IStatus)status);
            }
        });
    }

    public static boolean isDebugMode() {
        return Platform.inDebugMode() && Platform.getDebugOption((String)(String.valueOf(OprofileCorePlugin.getId()) + "/debug")) != null;
    }

    public static void log(int severity, String msg) {
        plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, msg, null));
    }

    public static void log(int severity, String msg, Throwable cause) {
        plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, msg, cause));
    }

    public String getPluginLocation() {
        Bundle bundle = this.getBundle();
        URL locationUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("/"), null);
        URL fileUrl = null;
        try {
            fileUrl = FileLocator.toFileURL((URL)locationUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileUrl.getFile();
    }
}

