/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.preferences.IncludeCategoriesBlock;
import org.eclipse.cdt.internal.ui.preferences.IncludeOrderBlock;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.TabConfigurationBlock;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IncludeStyleBlock
extends TabConfigurationBlock {
    static final OptionsConfigurationBlock.Key KEY_STYLE_RELATED = IncludeStyleBlock.getCDTUIKey("includeStyle.related");
    static final OptionsConfigurationBlock.Key KEY_STYLE_PARTNER = IncludeStyleBlock.getCDTUIKey("includeStyle.partner");
    static final OptionsConfigurationBlock.Key KEY_STYLE_SAME_FOLDER = IncludeStyleBlock.getCDTUIKey("includeStyle.sameFolder");
    static final OptionsConfigurationBlock.Key KEY_STYLE_SUBFOLDER = IncludeStyleBlock.getCDTUIKey("includeStyle.subfolder");
    static final OptionsConfigurationBlock.Key KEY_STYLE_SYSTEM = IncludeStyleBlock.getCDTUIKey("includeStyle.system");
    static final OptionsConfigurationBlock.Key KEY_STYLE_SYSTEM_WITH_EXTENSION = IncludeStyleBlock.getCDTUIKey("includeStyle.systemWithExtension");
    static final OptionsConfigurationBlock.Key KEY_STYLE_SYSTEM_WITHOUT_EXTENSION = IncludeStyleBlock.getCDTUIKey("includeStyle.systemWithoutExtension");
    static final OptionsConfigurationBlock.Key KEY_STYLE_OTHER = IncludeStyleBlock.getCDTUIKey("includeStyle.other");
    static final OptionsConfigurationBlock.Key KEY_STYLE_SAME_PROJECT = IncludeStyleBlock.getCDTUIKey("includeStyle.inSameProject");
    static final OptionsConfigurationBlock.Key KEY_STYLE_OTHER_PROJECT = IncludeStyleBlock.getCDTUIKey("includeStyle.inOtherProject");
    static final OptionsConfigurationBlock.Key KEY_STYLE_EXTERNAL = IncludeStyleBlock.getCDTUIKey("includeStyle.external");
    static final OptionsConfigurationBlock.Key KEY_STYLE_MATCHING_PATTERN = IncludeStyleBlock.getCDTUIKey("includeStyle.matchingPattern");
    static final Map<IncludeGroupStyle.IncludeKind, OptionsConfigurationBlock.Key> KEY_MAP = IncludeStyleBlock.createKeyMap();
    static final OptionsConfigurationBlock.Key[] STYLE_KEYS = KEY_MAP.values().toArray(new OptionsConfigurationBlock.Key[KEY_MAP.size()]);
    private static final String[] TAB_LABELS = new String[]{PreferencesMessages.IncludeStyleBlock_categories_tab, PreferencesMessages.IncludeStyleBlock_order_tab};
    private final List<IncludeGroupStyle> styles;

    public IncludeStyleBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        this(context, project, container, new ArrayList<IncludeGroupStyle>());
    }

    private IncludeStyleBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, List<IncludeGroupStyle> styles) {
        super(context, project, IncludeStyleBlock.createTabs(context, project, container, styles), TAB_LABELS, container);
        this.styles = styles;
        this.settingsUpdated();
    }

    private static OptionsConfigurationBlock[] createTabs(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, List<IncludeGroupStyle> styles) {
        IncludeCategoriesBlock includeCategoriesBlock = new IncludeCategoriesBlock(context, project, container, styles);
        IncludeOrderBlock includeOrderBlock = new IncludeOrderBlock(context, project, container, styles);
        return new OptionsConfigurationBlock[]{includeCategoriesBlock, includeOrderBlock};
    }

    private static Map<IncludeGroupStyle.IncludeKind, OptionsConfigurationBlock.Key> createKeyMap() {
        HashMap<IncludeGroupStyle.IncludeKind, OptionsConfigurationBlock.Key> map = new HashMap<IncludeGroupStyle.IncludeKind, OptionsConfigurationBlock.Key>();
        map.put(IncludeGroupStyle.IncludeKind.RELATED, KEY_STYLE_RELATED);
        map.put(IncludeGroupStyle.IncludeKind.PARTNER, KEY_STYLE_PARTNER);
        map.put(IncludeGroupStyle.IncludeKind.IN_SAME_FOLDER, KEY_STYLE_SAME_FOLDER);
        map.put(IncludeGroupStyle.IncludeKind.IN_SUBFOLDER, KEY_STYLE_SUBFOLDER);
        map.put(IncludeGroupStyle.IncludeKind.SYSTEM, KEY_STYLE_SYSTEM);
        map.put(IncludeGroupStyle.IncludeKind.SYSTEM_WITH_EXTENSION, KEY_STYLE_SYSTEM_WITH_EXTENSION);
        map.put(IncludeGroupStyle.IncludeKind.SYSTEM_WITHOUT_EXTENSION, KEY_STYLE_SYSTEM_WITHOUT_EXTENSION);
        map.put(IncludeGroupStyle.IncludeKind.OTHER, KEY_STYLE_OTHER);
        map.put(IncludeGroupStyle.IncludeKind.IN_SAME_PROJECT, KEY_STYLE_SAME_PROJECT);
        map.put(IncludeGroupStyle.IncludeKind.IN_OTHER_PROJECT, KEY_STYLE_OTHER_PROJECT);
        map.put(IncludeGroupStyle.IncludeKind.EXTERNAL, KEY_STYLE_EXTERNAL);
        return Collections.unmodifiableMap(map);
    }

    @Override
    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        boolean result = super.processChanges(container);
        for (IncludeGroupStyle style : this.styles) {
            IncludeGroupStyle.IncludeKind includeKind = style.getIncludeKind();
            OptionsConfigurationBlock.Key key = KEY_MAP.get((Object)includeKind);
            if (includeKind == IncludeGroupStyle.IncludeKind.MATCHING_PATTERN) continue;
            this.setValue(key, style.toString());
        }
        return result;
    }

    @Override
    protected void settingsUpdated() {
        if (this.styles != null) {
            this.styles.clear();
            for (Map.Entry<IncludeGroupStyle.IncludeKind, OptionsConfigurationBlock.Key> entry : KEY_MAP.entrySet()) {
                IncludeGroupStyle.IncludeKind includeKind = entry.getKey();
                IncludeGroupStyle style = null;
                String str = this.getValue(entry.getValue());
                if (str != null) {
                    style = IncludeGroupStyle.fromString(str, includeKind);
                }
                if (style == null) {
                    style = new IncludeGroupStyle(includeKind);
                }
                this.styles.add(style);
            }
        }
        super.settingsUpdated();
    }
}

