/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.koneki.ldt.ui.internal.Activator;

public class LuaDocumentorCommentAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private Pattern linePortionToDuplicatePattern = Pattern.compile("(\\s*).*--(\\s*)");

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)c.text) != -1) {
            try {
                IRegion line = d.getLineInformationOfOffset(c.offset);
                String lineContent = d.get(line.getOffset(), line.getLength());
                Matcher m = this.linePortionToDuplicatePattern.matcher(lineContent);
                if (m.find()) {
                    String toAppend = String.valueOf(m.group(1)) + "--" + m.group(2);
                    int start = c.offset - line.getOffset();
                    toAppend = toAppend.substring(0, Math.min(start, toAppend.length()));
                    c.text = String.valueOf(c.text) + toAppend;
                }
            }
            catch (BadLocationException e) {
                Activator.logWarning("Auto-edit failed", e);
            }
        }
    }
}

