/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.model;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.perf.model.PMDso;
import org.eclipse.linuxtools.internal.perf.model.PMFile;
import org.eclipse.linuxtools.internal.perf.model.PMLineRef;

public class TreeParent {
    private String name;
    private TreeParent parent;
    private ArrayList<TreeParent> children;
    private float percent = -1.0f;
    private double samples = -1.0;

    public TreeParent(String name, float percent) {
        this.name = name;
        this.percent = percent;
        this.children = new ArrayList();
    }

    public TreeParent(String name, float percent, double samples) {
        this(name, percent);
        this.samples = samples;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(TreeParent parent) {
        this.parent = parent;
    }

    public TreeParent getParent() {
        return this.parent;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (" + this.getFormattedSamples() + " samples)";
    }

    public Boolean equals(String s) {
        return this.getName().equals(s);
    }

    public float getPercent() {
        return this.percent;
    }

    public void setPercent(float percent) {
        this.percent = percent;
    }

    public double getSamples() {
        if (this instanceof PMLineRef) {
            if (this.samples == -1.0) {
                this.samples = (int)(this.getParent().getSamples() * (double)(this.getPercent() / 100.0f));
            }
        } else if (this.samples == -1.0) {
            int sampleSum = 0;
            TreeParent[] treeParentArray = this.getChildren();
            int n = treeParentArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeParent child = treeParentArray[n2];
                sampleSum = (int)((double)sampleSum + child.getSamples());
                ++n2;
            }
            this.samples = sampleSum;
        }
        return this.samples;
    }

    public String getFormattedSamples() {
        double samples = this.getSamples();
        return samples <= 2.147483647E9 ? String.format("%.0f", samples) : String.format("%.4G", samples);
    }

    public TreeParent(String name) {
        this.name = name;
        this.children = new ArrayList();
    }

    public void addChild(TreeParent child) {
        this.children.add(child);
        child.setParent(this);
        this.recalculatePercentage();
    }

    public TreeParent getChild(String name) {
        for (TreeParent t : this.children) {
            if (!t.equals(name).booleanValue()) continue;
            return t;
        }
        return null;
    }

    public void removeChild(TreeParent child) {
        this.children.remove(child);
        child.setParent(null);
        this.recalculatePercentage();
    }

    public TreeParent[] getChildren() {
        return this.children.toArray(new TreeParent[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void clear() {
        this.children.clear();
    }

    public void recalculatePercentage() {
        if (this.getPercent() != -1.0f && (this instanceof PMDso || this instanceof PMFile)) {
            this.percent = 0.0f;
            TreeParent[] treeParentArray = this.getChildren();
            int n = treeParentArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeParent c = treeParentArray[n2];
                this.percent += c.getPercent();
                ++n2;
            }
            if (this.getParent().getPercent() != -1.0f) {
                this.getParent().recalculatePercentage();
            }
        }
    }
}

