/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PerfOptionsTab
extends AbstractLaunchConfigurationTab {
    protected Text txtKernelLocation;
    protected Button chkRecordRealtime;
    protected Button chkRecordVerbose;
    protected Button chkSourceLineNumbers;
    protected Button chkKernelSourceLineNumbers;
    protected Button chkMultiplexEvents;
    protected Button chkModuleSymbols;
    protected Button chkHideUnresolvedSymbols;
    protected Button chkShowSourceDisassembly;
    protected Button chkShowStat;
    protected Spinner statRunCount;
    protected Composite top;
    protected ScrolledComposite scrollTop;

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public boolean isValid(ILaunchConfiguration config) {
        String filename;
        if (this.txtKernelLocation != null && (filename = this.txtKernelLocation.getText()).length() > 0) {
            File file = new File(filename);
            return file.exists() && file.isFile();
        }
        return true;
    }

    public void createControl(Composite parent) {
        this.scrollTop = new ScrolledComposite(parent, 768);
        this.scrollTop.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrollTop.setExpandVertical(true);
        this.scrollTop.setExpandHorizontal(true);
        this.setControl((Control)this.scrollTop);
        this.top = new Composite((Composite)this.scrollTop, 0);
        this.top.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(this.top, 1);
        Composite kernelComp = new Composite(this.top, 0);
        GridLayout parallelLayout = new GridLayout(2, false);
        GridData data = new GridData(768);
        parallelLayout.marginHeight = 0;
        parallelLayout.marginWidth = 0;
        kernelComp.setLayout((Layout)parallelLayout);
        kernelComp.setLayoutData((Object)data);
        Label kernelLabel = new Label(kernelComp, 0);
        kernelLabel.setText("Location of kernel image file (optional): ");
        data = new GridData();
        data.horizontalSpan = 2;
        kernelLabel.setLayoutData((Object)data);
        this.txtKernelLocation = new Text(kernelComp, 2052);
        data = new GridData(768);
        this.txtKernelLocation.setLayoutData((Object)data);
        this.txtKernelLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent mev) {
                PerfOptionsTab.this.handleKernelImageFileTextModify(PerfOptionsTab.this.txtKernelLocation);
            }
        });
        Button button = this.createPushButton(kernelComp, "Browse", null);
        final Shell shell = this.top.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                PerfOptionsTab.this.showFileDialog(shell);
            }
        });
        this.createVerticalSpacer(this.top, 1);
        Composite chkBoxComp = new Composite(this.top, 0);
        GridLayout chkBoxLayout = new GridLayout();
        chkBoxLayout.marginHeight = 0;
        chkBoxLayout.marginWidth = 0;
        chkBoxComp.setLayout((Layout)chkBoxLayout);
        this.chkRecordVerbose = this.createCheckButtonHelper(chkBoxComp, "Record with verbose output");
        this.chkModuleSymbols = this.createCheckButtonHelper(chkBoxComp, "Load Module Symbols");
        this.chkHideUnresolvedSymbols = this.createCheckButtonHelper(chkBoxComp, "Hide Unresolved Symbols");
        this.chkSourceLineNumbers = this.createCheckButtonHelper(chkBoxComp, "Obtain source line numbers from profile data");
        this.chkShowSourceDisassembly = this.createCheckButtonHelper(chkBoxComp, "Show Source Disassembly View");
        Composite showStatComp = new Composite(this.top, 0);
        showStatComp.setLayout((Layout)parallelLayout);
        this.chkShowStat = this.createCheckButtonHelper(showStatComp, "Show Stat View");
        this.chkShowStat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PerfOptionsTab.this.handleShowStatSelection();
            }
        });
        this.statRunCount = new Spinner(showStatComp, 2048);
        this.statRunCount.setEnabled(false);
        this.statRunCount.setMinimum(1);
        this.statRunCount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PerfOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.chkSourceLineNumbers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (PerfOptionsTab.this.chkKernelSourceLineNumbers != null && !PerfOptionsTab.this.chkSourceLineNumbers.getSelection()) {
                    PerfOptionsTab.this.chkKernelSourceLineNumbers.setEnabled(false);
                } else {
                    PerfOptionsTab.this.chkKernelSourceLineNumbers.setEnabled(true);
                }
            }
        });
        this.chkKernelSourceLineNumbers = this.createCheckButtonHelper(chkBoxComp, "Obtain kernel source line numbers from profile data (Warning: May be very slow)");
        this.chkRecordRealtime = this.createCheckButtonHelper(chkBoxComp, "Record with realtime priority (RT SCHED_FIFO)");
        this.chkMultiplexEvents = this.createCheckButtonHelper(chkBoxComp, "Multiplex counter output in a single channel");
        this.scrollTop.setContent((Control)this.top);
        this.recomputeSize();
        this.updateLaunchConfigurationDialog();
    }

    protected void recomputeSize() {
        Point point = this.top.computeSize(-1, -1);
        this.top.setSize(point);
        this.scrollTop.setMinSize(point);
    }

    private Button createCheckButtonHelper(Composite parent, String label) {
        Button b = new Button(parent, 32);
        b.setText(label);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PerfOptionsTab.this.setDirty(true);
                PerfOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        return b;
    }

    private void handleKernelImageFileTextModify(Text text) {
        File file;
        String errorMessage = null;
        String filename = text.getText();
        if (!(filename.length() <= 0 || (file = new File(filename)).exists() && file.isFile())) {
            errorMessage = "The entered location does not exist.";
        }
        this.setErrorMessage(errorMessage);
        this.updateLaunchConfigurationDialog();
    }

    private void handleShowStatSelection() {
        if (this.chkShowStat.getSelection()) {
            this.statRunCount.setEnabled(true);
            this.toggleButtonsEnablement(false);
        } else {
            this.statRunCount.setEnabled(false);
            this.toggleButtonsEnablement(true);
        }
    }

    private void showFileDialog(Shell shell) {
        FileDialog fDialog = new FileDialog(shell, 4096);
        File kernel = new File(this.txtKernelLocation.getText());
        if (!kernel.exists() && !(kernel = new File("/boot")).exists()) {
            kernel = new File("/");
        }
        fDialog.setFileName(kernel.toString());
        fDialog.setText("Select location of kernel image file");
        String newKernel = fDialog.open();
        if (newKernel != null) {
            kernel = new File(newKernel);
            if (!kernel.exists()) {
                MessageBox mb = new MessageBox(shell, 1281);
                mb.setMessage("File does not exist");
                switch (mb.open()) {
                    case 1024: {
                        this.showFileDialog(shell);
                    }
                }
            } else {
                this.txtKernelLocation.setText(newKernel);
            }
        }
    }

    public void toggleButtonsEnablement(boolean enable) {
        this.txtKernelLocation.setEnabled(enable);
        this.chkRecordRealtime.setEnabled(enable);
        this.chkRecordVerbose.setEnabled(enable);
        this.chkSourceLineNumbers.setEnabled(enable);
        this.chkKernelSourceLineNumbers.setEnabled(enable);
        this.chkMultiplexEvents.setEnabled(enable);
        this.chkModuleSymbols.setEnabled(enable);
        this.chkHideUnresolvedSymbols.setEnabled(enable);
        this.chkShowSourceDisassembly.setEnabled(enable);
    }

    public String getName() {
        return "Perf Options";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.txtKernelLocation.setText(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", ""));
            this.chkRecordRealtime.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Realtime", false));
            this.chkRecordVerbose.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Verbose", false));
            this.chkSourceLineNumbers.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SourceLineNumbers", true));
            this.chkKernelSourceLineNumbers.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.SourceLineNumbers", false));
            this.chkMultiplexEvents.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Multiplex", false));
            this.chkModuleSymbols.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", false));
            this.chkHideUnresolvedSymbols.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.HideUnresolvedSymbols", true));
            this.chkShowSourceDisassembly.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowSourceDisassembly", false));
            this.chkShowStat.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowStat", false));
            int runCount = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.StatRunCount", 1);
            this.statRunCount.setSelection(runCount);
            this.handleShowStatSelection();
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy wconfig) {
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", this.txtKernelLocation.getText());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Realtime", this.chkRecordRealtime.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Verbose", this.chkRecordVerbose.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SourceLineNumbers", this.chkSourceLineNumbers.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.SourceLineNumbers", this.chkKernelSourceLineNumbers.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Multiplex", this.chkMultiplexEvents.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", this.chkModuleSymbols.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.HideUnresolvedSymbols", this.chkHideUnresolvedSymbols.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowSourceDisassembly", this.chkShowSourceDisassembly.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowStat", this.chkShowStat.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.StatRunCount", this.statRunCount.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wconfig) {
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", "");
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Realtime", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Verbose", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SourceLineNumbers", true);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.SourceLineNumbers", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.Multiplex", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.HideUnresolvedSymbols", true);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowSourceDisassembly", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowStat", false);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.StatRunCount", 1);
    }
}

