/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.AbstractSaveDataHandler;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;

public class PerfSaveSessionHandler
extends AbstractSaveDataHandler {
    public static final String DATA_EXT = "data";

    @Override
    public File saveData(String filename) {
        IPath newDataLoc = this.getNewDataLocation(filename, DATA_EXT);
        IPath defaultDataLoc = PerfPlugin.getDefault().getPerfProfileData();
        File newDataFile = new File(newDataLoc.toOSString());
        File defaultDataFile = defaultDataLoc.toFile();
        if (this.canSave(newDataFile)) {
            try {
                newDataFile.createNewFile();
                this.copyFile(defaultDataFile, newDataFile);
                PerfPlugin.getDefault().setPerfProfileData(newDataLoc);
                PerfPlugin.getDefault().getProfileView().setContentDescription(newDataLoc.toOSString());
                return newDataFile;
            }
            catch (IOException iOException) {
                this.openErroDialog(Messages.PerfSaveSession_failure_title, Messages.PerfSaveSession_failure_msg, newDataLoc.lastSegment());
            }
        }
        return null;
    }

    @Override
    public boolean verifyData() {
        IPath defaultDataLoc = PerfPlugin.getDefault().getPerfProfileData();
        return defaultDataLoc != null && !defaultDataLoc.isEmpty();
    }

    private void copyFile(File src, File dest) {
        FileInputStream destInput = null;
        FileOutputStream srcOutput = null;
        try {
            try {
                int length;
                destInput = new FileInputStream(src);
                srcOutput = new FileOutputStream(dest);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)destInput).read(buffer)) != -1) {
                    ((OutputStream)srcOutput).write(buffer, 0, length);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.openErroDialog(Messages.PerfSaveSession_failure_title, Messages.PerfSaveSession_failure_msg, dest.toString());
                this.closeResource(destInput, dest.getName());
                this.closeResource(srcOutput, src.getName());
            }
            catch (IOException iOException) {
                this.openErroDialog(Messages.PerfSaveSession_failure_title, Messages.PerfSaveSession_failure_msg, dest.toString());
                this.closeResource(destInput, dest.getName());
                this.closeResource(srcOutput, src.getName());
            }
        }
        finally {
            this.closeResource(destInput, dest.getName());
            this.closeResource(srcOutput, src.getName());
        }
    }
}

