/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.ReportComparisonData;
import org.eclipse.linuxtools.internal.perf.handlers.AbstractComparisonHandler;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.internal.perf.ui.ReportComparisonView;

public class PerfComparisonHandler
extends AbstractComparisonHandler {
    @Override
    protected boolean isValidFile(IFile file) {
        if (file != null) {
            return "data".equals(file.getFileExtension()) || "old".equals(file.getFileExtension());
        }
        return false;
    }

    @Override
    protected void handleComparison(IFile oldData, IFile newData) {
        String title = MessageFormat.format(Messages.ContentDescription_0, oldData.getName(), newData.getName());
        File oldDatum = oldData.getLocation().toFile();
        File newDatum = newData.getLocation().toFile();
        ReportComparisonData diffData = new ReportComparisonData(title, oldDatum, newDatum);
        diffData.parse();
        PerfPlugin.getDefault().setReportDiffData(diffData);
        ReportComparisonView.refreshView();
    }
}

