/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.actions;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.changelog.core.IFormatterChangeLogContrib;
import org.eclipse.linuxtools.changelog.core.IParserChangeLogContrib;
import org.eclipse.linuxtools.internal.changelog.core.ChangeLogWriter;
import org.eclipse.linuxtools.internal.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.internal.changelog.core.LineComparator;
import org.eclipse.linuxtools.internal.changelog.core.Messages;
import org.eclipse.linuxtools.internal.changelog.core.actions.ChangeLogAction;
import org.eclipse.linuxtools.internal.changelog.core.actions.PatchFile;
import org.eclipse.linuxtools.internal.changelog.core.actions.PatchFileComparator;
import org.eclipse.linuxtools.internal.changelog.core.actions.PatchRangeElement;
import org.eclipse.linuxtools.internal.changelog.core.actions.SourceEditorInput;
import org.eclipse.linuxtools.internal.changelog.core.editors.ChangeLogEditor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepareChangeLogAction
extends ChangeLogAction {
    protected IProject currentProject;
    protected boolean changeLogModified = false;
    protected boolean newEntryWritten = false;
    protected boolean createChangeLog = true;
    private IStructuredSelection selected;
    protected IEditorPart changelog;

    protected void setSelection(IStructuredSelection selection) {
        this.selected = selection;
    }

    private String parseCurrentFunctionAtOffset(String editorName, IEditorInput input, int offset) {
        IParserChangeLogContrib parser = this.extensionManager.getParserContributor(editorName);
        if (parser == null) {
            return "";
        }
        try {
            return parser.parseCurrentFunction(input, offset);
        }
        catch (CoreException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
            return "";
        }
    }

    protected void doRun() {
        IRunnableWithProgress code = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.getString("ChangeLog.PrepareChangeLog"), 1000);
                PrepareChangeLogAction.this.prepareChangeLog(monitor);
                monitor.done();
            }
        };
        ProgressMonitorDialog pd = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            pd.run(false, false, code);
        }
        catch (InvocationTargetException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
            return;
        }
        catch (InterruptedException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
        }
    }

    private void extractSynchronizeModelInfo(ISynchronizeModelElement d, IPath path, Vector<PatchFile> newList, Vector<PatchFile> removeList, Vector<PatchFile> changeList) {
        if (d.hasChildren()) {
            IPath newPath = path.append(d.getName());
            IDiffElement[] iDiffElementArray = d.getChildren();
            int n = iDiffElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement element = iDiffElementArray[n2];
                if (element instanceof ISynchronizeModelElement) {
                    this.extractSynchronizeModelInfo((ISynchronizeModelElement)element, newPath, newList, removeList, changeList);
                } else if (!d.getName().equals("ChangeLog")) {
                    PatchFile p = new PatchFile(d.getResource());
                    int kind = d.getKind() & 3;
                    if (kind == 3) {
                        changeList.add(p);
                    } else if (kind == 1) {
                        p.setNewfile(true);
                        newList.add(p);
                    } else if (kind == 2) {
                        p.setRemovedFile(true);
                        removeList.add(p);
                    }
                } else {
                    this.changeLogModified = true;
                }
                ++n2;
            }
        } else if (!d.getName().equals("ChangeLog")) {
            PatchFile p = new PatchFile(d.getResource());
            int kind = d.getKind() & 3;
            if (kind == 3) {
                changeList.add(p);
            } else if (kind == 1) {
                p.setNewfile(true);
                newList.add(p);
            } else if (kind == 2) {
                p.setRemovedFile(true);
                removeList.add(p);
            }
        } else {
            this.changeLogModified = true;
        }
    }

    private void getChangedLines(Subscriber s, PatchFile p, IProgressMonitor monitor) {
        block9: {
            try {
                IDiff d = s.getDiff(p.getResource());
                if (!(d instanceof IThreeWayDiff) || ((IThreeWayDiff)d).getDirection() != 256) break block9;
                IThreeWayDiff diff = (IThreeWayDiff)d;
                monitor.beginTask(null, 100);
                IResourceDiff localDiff = (IResourceDiff)diff.getLocalChange();
                IResource resource = localDiff.getResource();
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    monitor.subTask(Messages.getString("ChangeLog.MergingDiffs"));
                    String osEncoding = file.getCharset();
                    IFileRevision ancestorState = localDiff.getBeforeState();
                    if (ancestorState == null) {
                        Object ancestorStorage = null;
                        return;
                    }
                    IStorage ancestorStorage = ancestorState.getStorage(monitor);
                    p.setStorage(ancestorStorage);
                    try {
                        LineComparator left = new LineComparator(ancestorStorage.getContents(), osEncoding);
                        LineComparator right = new LineComparator(file.getContents(), osEncoding);
                        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences((IRangeComparator)left, (IRangeComparator)right);
                        int n = rangeDifferenceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RangeDifference tmp = rangeDifferenceArray[n2];
                            if (tmp.kind() == 2) {
                                int leftLength;
                                int rightLength = tmp.rightLength() > 0 ? tmp.rightLength() : tmp.rightLength() + 1;
                                int n3 = leftLength = tmp.leftLength() > 0 ? tmp.leftLength() : tmp.leftLength() + 1;
                                if (p.getStorage() != null) {
                                    p.addLineRange(tmp.leftStart(), tmp.leftStart() + leftLength, false);
                                }
                                p.addLineRange(tmp.rightStart(), tmp.rightStart() + rightLength, true);
                            }
                            ++n2;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                monitor.done();
            }
            catch (CoreException coreException) {}
        }
    }

    private void prepareChangeLog(IProgressMonitor monitor) {
        int i;
        int size;
        Subscriber s;
        int totalChanges;
        Vector<PatchFile> changeList;
        Vector<PatchFile> removeList;
        Vector<PatchFile> newList;
        block27: {
            SyncInfoSet set;
            IProject project;
            block26: {
                Object element = this.selected.getFirstElement();
                IResource resource = null;
                newList = new Vector<PatchFile>();
                removeList = new Vector<PatchFile>();
                changeList = new Vector<PatchFile>();
                totalChanges = 0;
                if (element instanceof IResource) {
                    resource = (IResource)element;
                } else if (element instanceof ISynchronizeModelElement) {
                    ISynchronizeModelElement sme = (ISynchronizeModelElement)element;
                    resource = sme.getResource();
                } else if (element instanceof IAdaptable) {
                    resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                }
                if (resource == null) {
                    return;
                }
                project = resource.getProject();
                RepositoryProvider r = RepositoryProvider.getProvider((IProject)project);
                if (r == null) {
                    return;
                }
                set = new SyncInfoSet();
                s = r.getSubscriber();
                if (s == null) {
                    return;
                }
                if (!(element instanceof ISynchronizeModelElement)) break block26;
                ISynchronizeModelElement d = (ISynchronizeModelElement)element;
                while (d.getParent() != null) {
                    d = (ISynchronizeModelElement)d.getParent();
                }
                this.extractSynchronizeModelInfo(d, (IPath)new Path(""), newList, removeList, changeList);
                totalChanges = newList.size() + removeList.size() + changeList.size();
                break block27;
            }
            s.collectOutOfSync(new IResource[]{project}, 2, set, monitor);
            SyncInfo[] infos = set.getSyncInfos();
            totalChanges = infos.length;
            SyncInfo[] syncInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                block29: {
                    block28: {
                        SyncInfo info = syncInfoArray[n2];
                        int kind = SyncInfo.getChange((int)info.getKind());
                        PatchFile p = new PatchFile(info.getLocal());
                        if (p.getPath().lastSegment().equals("ChangeLog")) break block28;
                        switch (kind) {
                            case 1: {
                                p.setNewfile(true);
                                newList.add(p);
                                break;
                            }
                            case 2: {
                                p.setRemovedFile(true);
                                removeList.add(p);
                                break;
                            }
                            case 3: {
                                if (info.getLocal().getType() != 1) break block29;
                                changeList.add(p);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block29;
                    }
                    this.changeLogModified = true;
                }
                ++n2;
            }
        }
        if (totalChanges == 0) {
            return;
        }
        PatchFile[] patchFileInfoList = new PatchFile[totalChanges];
        int index = 0;
        if (changeList.size() > 0) {
            Collections.sort(changeList, new PatchFileComparator());
            size = changeList.size();
            i = 0;
            while (i < size) {
                PatchFile p = changeList.get(i);
                this.getChangedLines(s, p, monitor);
                patchFileInfoList[index + (size - i - 1)] = p;
                ++i;
            }
            index += size;
        }
        if (newList.size() > 0) {
            Collections.sort(newList, new PatchFileComparator());
            size = newList.size();
            i = 0;
            while (i < size) {
                patchFileInfoList[index + (size - i - 1)] = newList.get(i);
                ++i;
            }
            index += size;
        }
        if (removeList.size() > 0) {
            Collections.sort(removeList, new PatchFileComparator());
            size = removeList.size();
            i = 0;
            while (i < size) {
                patchFileInfoList[index + (size - i - 1)] = removeList.get(i);
                ++i;
            }
        }
        monitor.subTask(Messages.getString("ChangeLog.WritingMessage"));
        int unitwork = 250 / patchFileInfoList.length;
        PatchFile[] patchFileArray = patchFileInfoList;
        int n = patchFileInfoList.length;
        int n3 = 0;
        while (n3 < n) {
            PatchFile pf = patchFileArray[n3];
            if (pf != null) {
                String[] funcGuessList = this.guessFunctionNames(pf);
                this.outputMultipleEntryChangeLog(pf, funcGuessList);
            }
            monitor.worked(unitwork);
            ++n3;
        }
    }

    public void outputMultipleEntryChangeLog(PatchFile pf, String[] functionGuess) {
        String defaultContent = null;
        if (pf.isNewfile()) {
            defaultContent = Messages.getString("ChangeLog.NewFile");
        } else if (pf.isRemovedFile()) {
            defaultContent = Messages.getString("ChangeLog.RemovedFile");
        }
        IPath entryPath = pf.getPath();
        String entryFileName = entryPath.toOSString();
        ChangeLogWriter clw = new ChangeLogWriter();
        this.loadPreferences();
        clw.setEntryFilePath(entryPath.toOSString());
        if (defaultContent != null) {
            clw.setDefaultContent(defaultContent);
        }
        if (clw.getEntryFilePath() == "") {
            return;
        }
        IEditorPart changelog = null;
        this.extensionManager.getFormatterContributor(clw.getEntryFilePath(), this.pref_Formatter);
        IConfigurationElement formatterConfigElement = this.extensionManager.getFormatterConfigElement();
        if (formatterConfigElement.getAttribute("inFile").toLowerCase().equals("true")) {
            try {
                changelog = this.openEditor((IFile)pf.getResource());
                clw.setFormatter(this.extensionManager.getFormatterContributor(clw.getEntryFilePath(), this.pref_Formatter));
            }
            catch (Exception exception) {}
        } else {
            clw.setFormatter(this.extensionManager.getFormatterContributor(entryFileName, this.pref_Formatter));
            changelog = pf.isRemovedFile() ? this.getChangelogForRemovePath(entryPath) : this.getChangelog(entryFileName);
            if (this.createChangeLog && changelog == null) {
                changelog = this.askChangeLogLocation(entryPath.toOSString());
            }
            if (changelog == null) {
                this.createChangeLog = false;
                return;
            }
        }
        if (changelog instanceof ChangeLogEditor && !this.newEntryWritten) {
            ChangeLogEditor editor = (ChangeLogEditor)changelog;
            if (editor.isDirty()) {
                this.changeLogModified = true;
            }
            editor.setForceNewLogEntry(!this.changeLogModified);
            this.newEntryWritten = true;
        }
        clw.setChangelog(changelog);
        IFormatterChangeLogContrib formatter = clw.getFormatter();
        clw.setDateLine(formatter.formatDateLine(this.pref_AuthorName, this.pref_AuthorEmail));
        clw.setChangelogLocation(this.getDocumentLocation(clw.getChangelog(), true));
        int numFuncs = 0;
        clw.setGuessedFName("");
        if (functionGuess.length > 0) {
            String[] stringArray = functionGuess;
            int n = functionGuess.length;
            int n2 = 0;
            while (n2 < n) {
                String guess = stringArray[n2];
                if (!guess.trim().equals("")) {
                    ++numFuncs;
                    clw.setGuessedFName(guess);
                    clw.writeChangeLog();
                }
                ++n2;
            }
        }
        if (numFuncs == 0) {
            clw.writeChangeLog();
        }
    }

    private String[] guessFunctionNames(PatchFile patchFileInfo) {
        if (patchFileInfo.isNewfile() || patchFileInfo.isRemovedFile()) {
            return new String[]{""};
        }
        String[] fnames = new String[]{};
        String editorName = "";
        try {
            IEditorDescriptor ed = IDE.getEditorDescriptor((String)patchFileInfo.getPath().toOSString());
            editorName = ed.getId().substring(ed.getId().lastIndexOf(".") + 1);
        }
        catch (PartInitException e1) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e1.getMessage(), (Throwable)e1));
            return new String[0];
        }
        FileEditorInput fei = new FileEditorInput((IFile)patchFileInfo.getResource());
        SourceEditorInput sei = new SourceEditorInput(patchFileInfo.getStorage());
        MyDocumentProvider mdp = new MyDocumentProvider();
        MyStorageDocumentProvider msdp = new MyStorageDocumentProvider();
        try {
            IDocument doc = mdp.createDocument(fei);
            IDocument olddoc = msdp.createDocument(sei);
            HashMap<String, String> functionNamesMap = new HashMap<String, String>();
            ArrayList<String> nameList = new ArrayList<String>();
            PatchRangeElement[] patchRangeElementArray = patchFileInfo.getRanges();
            int n = patchRangeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PatchRangeElement tpre = patchRangeElementArray[n2];
                int j = tpre.ffromLine;
                while (j <= tpre.ftoLine) {
                    block14: {
                        String functionGuess;
                        block15: {
                            block13: {
                                functionGuess = "";
                                if (!tpre.isLocalChange()) break block13;
                                if (j < 0 || j > doc.getNumberOfLines() - 1) break block14;
                                functionGuess = this.parseCurrentFunctionAtOffset(editorName, (IEditorInput)fei, doc.getLineOffset(j));
                                break block15;
                            }
                            if (j < 0 || j > olddoc.getNumberOfLines() - 1) break block14;
                            functionGuess = this.parseCurrentFunctionAtOffset(editorName, (IEditorInput)sei, olddoc.getLineOffset(j));
                        }
                        if (functionNamesMap.get(functionGuess) == null) {
                            nameList.add(functionGuess);
                        }
                        functionNamesMap.put(functionGuess, functionGuess);
                    }
                    ++j;
                }
                ++n2;
            }
            fnames = new String[nameList.size()];
            fnames = nameList.toArray(fnames);
        }
        catch (CoreException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
        }
        catch (BadLocationException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
            e.printStackTrace();
        }
        return fnames;
    }

    private static class MyDocumentProvider
    extends FileDocumentProvider {
        private MyDocumentProvider() {
        }

        public IDocument createDocument(Object element) throws CoreException {
            return super.createDocument(element);
        }
    }

    private static class MyStorageDocumentProvider
    extends StorageDocumentProvider {
        private MyStorageDocumentProvider() {
        }

        public IDocument createDocument(Object element) throws CoreException {
            return super.createDocument(element);
        }
    }
}

