/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.IUDetailsGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionStatusPage;
import org.eclipse.equinox.internal.p2.ui.model.AvailableUpdateElement;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SelectableIUsPage
extends ResolutionStatusPage
implements IResolutionErrorReportingPage {
    private static final String DIALOG_SETTINGS_SECTION = "SelectableIUsPage";
    IUElementListRoot root;
    Object[] initialSelections;
    ProfileChangeOperation resolvedOperation;
    CheckboxTableViewer tableViewer;
    IUDetailsGroup iuDetailsGroup;
    ProvElementContentProvider contentProvider;
    IUDetailsLabelProvider labelProvider;
    protected Display display;
    protected Policy policy;
    SashForm sashForm;

    public SelectableIUsPage(ProvisioningUI ui, ProvisioningOperationWizard wizard, IUElementListRoot root, Object[] initialSelections) {
        super("IUSelectionPage", ui, wizard);
        this.root = root;
        if (root == null) {
            root = new IUElementListRoot();
        }
        this.initialSelections = initialSelections == null ? new IInstallableUnit[0] : initialSelections;
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        this.sashForm = new SashForm(parent, 512);
        FillLayout layout = new FillLayout();
        this.sashForm.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.sashForm.setLayoutData((Object)data);
        this.initializeDialogUnits((Control)this.sashForm);
        Composite composite = new Composite((Composite)this.sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.tableViewer = this.createTableViewer(composite);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        this.activateCopy((Control)table);
        IUColumnConfig[] columns = this.getColumnConfig();
        int i = 0;
        while (i < columns.length) {
            TableColumn tc = new TableColumn(table, 16384, i);
            tc.setResizable(true);
            tc.setText(columns[i].getColumnTitle());
            tc.setWidth(columns[i].getWidthInPixels((Control)table));
            ++i;
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectableIUsPage.this.setDetailText(SelectableIUsPage.this.resolvedOperation);
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AvailableUpdateElement checkedElement;
                if (event.getElement() instanceof AvailableUpdateElement && (checkedElement = (AvailableUpdateElement)event.getElement()).isLockedForUpdate()) {
                    event.getCheckable().setChecked((Object)checkedElement, false);
                    CheckboxTableViewer viewer = (CheckboxTableViewer)event.getSource();
                    int itemCount = viewer.getTable().getItemCount();
                    int i = 0;
                    while (i < itemCount) {
                        if (viewer.getElementAt(i).equals(checkedElement)) {
                            viewer.getTable().deselectAll();
                            viewer.getTable().select(i);
                            SelectableIUsPage.this.setDetailText(SelectableIUsPage.this.resolvedOperation);
                            break;
                        }
                        ++i;
                    }
                }
                SelectableIUsPage.this.updateSelection();
            }
        });
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(ProvUI.getIUColumnConfig());
        this.tableViewer.setComparator((ViewerComparator)comparator);
        this.tableViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.contentProvider = new ProvElementContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new IUDetailsLabelProvider(null, ProvUI.getIUColumnConfig(), this.getShell());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setInput((Object)this.root);
        this.setInitialCheckState();
        this.createSelectButtons(composite);
        Composite controlsComposite = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        controlsComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        controlsComposite.setLayoutData((Object)gd);
        this.iuDetailsGroup = new IUDetailsGroup((Composite)this.sashForm, (ISelectionProvider)this.tableViewer, this.convertWidthInCharsToPixels(80), true);
        this.updateStatus(this.root, this.resolvedOperation);
        this.setControl((Control)this.sashForm);
        this.sashForm.setWeights(this.getSashWeights());
        Dialog.applyDialogFont((Control)this.sashForm);
    }

    private void createSelectButtons(Composite parent) {
        Composite buttonParent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonParent.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, -1, true, false);
        buttonParent.setLayoutData((Object)data);
        Button selectAll = new Button(buttonParent, 8);
        selectAll.setText(ProvUIMessages.SelectableIUsPage_Select_All);
        this.setButtonLayoutData(selectAll);
        selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectableIUsPage.this.tableViewer.setAllChecked(true);
                SelectableIUsPage.this.updateSelection();
            }
        });
        Button deselectAll = new Button(buttonParent, 8);
        deselectAll.setText(ProvUIMessages.SelectableIUsPage_Deselect_All);
        this.setButtonLayoutData(deselectAll);
        deselectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectableIUsPage.this.tableViewer.setAllChecked(false);
                SelectableIUsPage.this.updateSelection();
            }
        });
        Label dummy = new Label(buttonParent, 0);
        data = new GridData(4, 4, true, true);
        dummy.setLayoutData((Object)data);
        Label sep = new Label(buttonParent, 258);
        data = new GridData(4, -1, true, false);
        data.horizontalSpan = 3;
        sep.setLayoutData((Object)data);
    }

    protected CheckboxTableViewer createTableViewer(Composite parent) {
        CheckboxTableViewer v = CheckboxTableViewer.newCheckList((Composite)parent, (int)67586);
        return v;
    }

    public Object[] getCheckedIUElements() {
        if (this.tableViewer == null) {
            return this.initialSelections;
        }
        return this.tableViewer.getCheckedElements();
    }

    public Object[] getSelectedIUElements() {
        return ((IStructuredSelection)this.tableViewer.getSelection()).toArray();
    }

    protected Object[] getSelectedElements() {
        return ((IStructuredSelection)this.tableViewer.getSelection()).toArray();
    }

    protected IInstallableUnit[] elementsToIUs(Object[] elements) {
        IInstallableUnit[] theIUs = new IInstallableUnit[elements.length];
        int i = 0;
        while (i < elements.length) {
            theIUs[i] = ProvUI.getAdapter(elements[i], IInstallableUnit.class);
            ++i;
        }
        return theIUs;
    }

    protected void setInitialCheckState() {
        if (this.initialSelections == null) {
            return;
        }
        ArrayList<Object> selections = new ArrayList<Object>(this.initialSelections.length);
        int i = 0;
        while (i < this.initialSelections.length) {
            AvailableUpdateElement element;
            if (!(this.initialSelections[i] instanceof AvailableUpdateElement) || !(element = (AvailableUpdateElement)this.initialSelections[i]).isLockedForUpdate()) {
                selections.add(this.initialSelections[i]);
            }
            ++i;
        }
        this.tableViewer.setCheckedElements(selections.toArray(new Object[selections.size()]));
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getPreviousPage() {
        this.setPreviousPage(null);
        return super.getPreviousPage();
    }

    protected String getClipboardText(Control control) {
        StringBuffer buffer = new StringBuffer();
        Object[] elements = this.getSelectedElements();
        int i = 0;
        while (i < elements.length) {
            if (i > 0) {
                buffer.append(CopyUtils.NEWLINE);
            }
            buffer.append(this.labelProvider.getClipboardText(elements[i], "\t"));
            ++i;
        }
        return buffer.toString();
    }

    protected IInstallableUnit getSelectedIU() {
        List<IInstallableUnit> units = ElementUtils.elementsToIUs(this.getSelectedElements());
        if (units.size() == 0) {
            return null;
        }
        return units.get(0);
    }

    protected IUDetailsGroup getDetailsGroup() {
        return this.iuDetailsGroup;
    }

    protected boolean isCreated() {
        return this.tableViewer != null;
    }

    protected void updateCaches(IUElementListRoot newRoot, ProfileChangeOperation op) {
        this.resolvedOperation = op;
        if (newRoot != null && this.root != newRoot) {
            this.root = newRoot;
            if (this.tableViewer != null) {
                this.tableViewer.setInput((Object)newRoot);
            }
        }
    }

    public void setCheckedElements(Object[] elements) {
        if (this.tableViewer == null) {
            this.initialSelections = elements;
        } else {
            this.tableViewer.setCheckedElements(elements);
        }
    }

    protected SashForm getSashForm() {
        return this.sashForm;
    }

    protected String getDialogSettingsName() {
        return String.valueOf(this.getWizard().getClass().getName()) + "." + DIALOG_SETTINGS_SECTION;
    }

    protected int getColumnWidth(int index) {
        return this.tableViewer.getTable().getColumn(index).getWidth();
    }

    void updateSelection() {
        this.setPageComplete(this.tableViewer.getCheckedElements().length > 0);
        this.getProvisioningWizard().operationSelectionsChanged(this);
    }
}

