/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : sysc.h
*  
*	File Description : This file declares prototypes of system controller API funcions.
*
*	Author : Joonsoo Jeon
*	Dept. : AP Development Team
*	Created Date : 2009/03/08
*	Version : 0.1 
* 
*	History
*	- Created(Joonsoo Jeon, 2009/03/08)
*  
**************************************************************************************/

#ifndef __SYSC_H__
#define __SYSC_H__

#ifndef FIN
#define	FIN			(24000000)
#endif

#ifndef CLK27M
#define CLK27M		(27000000)
#endif


#include "def.h"

//=========== user setting ===========//
//#define DBG_SYSC
//==============================//


/////// CMU ////////

typedef enum 
{
	eAPLL,	eMPLL,	eEPLL,	eVPLL
} PLL_TYPE;

typedef enum 
{
	// CLK_SRC0
	eCLKMUX_OND_HCLKPSYS, eCLKMUX_OND_HCLKDSYS,
	eCLKMUX_PSYS_SCLKMPLL, eCLKMUX_PSYS_SCLKA2M,
	eCLKMUX_DSYS_SCLKMPLL, eCLKMUX_DSYS_SCLKA2M,
	eCLKMUX_MSYS_SCLKAPLL, eCLKMUX_MSYS_SCLKMPLL,
	eCLKMUX_VPLL_FINVPLL, eCLKMUX_VPLL_FOUTVPLL,
	eCLKMUX_EPLL_FINPLL, eCLKMUX_EPLL_FOUTEPLL,
	eCLKMUX_MPLL_FINPLL, eCLKMUX_MPLL_FOUTMPLL,
	eCLKMUX_APLL_FINPLL, eCLKMUX_APLL_FOUTAPLL,
	// CLK_SRC1
	eCLKMUX_VPLLSRC_FINPLL, eCLKMUX_VPLLSRC_SHDMI27M,
	eCLKMUX_CSIS_XXTI, eCLKMUX_CSIS_XUSBXTI, eCLKMUX_CSIS_SHDMI27M, eCLKMUX_CSIS_SUSBPHY0, eCLKMUX_CSIS_SUSBPHY1, eCLKMUX_CSIS_SHDMIPHY, eCLKMUX_CSIS_SMPLL, eCLKMUX_CSIS_SEPLL, eCLKMUX_CSIS_SVPLL,
	eCLKMUX_FIMD_XXTI, eCLKMUX_FIMD_XUSBXTI, eCLKMUX_FIMD_SHDMI27M, eCLKMUX_FIMD_SUSBPHY0, eCLKMUX_FIMD_SUSBPHY1, eCLKMUX_FIMD_SHDMIPHY, eCLKMUX_FIMD_SMPLL, eCLKMUX_FIMD_SEPLL, eCLKMUX_FIMD_SVPLL,
	eCLKMUX_CAM1_XXTI, eCLKMUX_CAM1_XUSBXTI, eCLKMUX_CAM1_SHDMI27M, eCLKMUX_CAM1_SUSBPHY0, eCLKMUX_CAM1_SUSBPHY1, eCLKMUX_CAM1_SHDMIPHY, eCLKMUX_CAM1_SMPLL, eCLKMUX_CAM1_SEPLL, eCLKMUX_CAM1_SVPLL,
	eCLKMUX_CAM0_XXTI, eCLKMUX_CAM0_XUSBXTI, eCLKMUX_CAM0_SHDMI27M, eCLKMUX_CAM0_SUSBPHY0, eCLKMUX_CAM0_SUSBPHY1, eCLKMUX_CAM0_SHDMIPHY, eCLKMUX_CAM0_SMPLL, eCLKMUX_CAM0_SEPLL, eCLKMUX_CAM0_SVPLL,
	eCLKMUX_DAC_SVPLL, eCLKMUX_DAC_SHDMIPHY, 
	eCLKMUX_MIXER_SDAC, eCLKMUX_MIXER_SHDMI,
	eCLKMUX_HDMI_SPIXEL, eCLKMUX_HDMI_SHDMIPHY,
	// CLK_SRC2
	eCLKMUX_MFC_SCLKA2M, eCLKMUX_MFC_SCLKMPLL, eCLKMUX_MFC_SCLKEPLL, eCLKMUX_MFC_SCLKVPLL,
	eCLKMUX_G3D_SCLKA2M, eCLKMUX_G3D_SCLKMPLL, eCLKMUX_G3D_SCLKEPLL, eCLKMUX_G3D_SCLKVPLL,
	// CLK_SRC3
	eCLKMUX_FIMC2LCLK_XXTI, eCLKMUX_FIMC2LCLK_XUSBXTI, eCLKMUX_FIMC2LCLK_SHDMI27M, eCLKMUX_FIMC2LCLK_SUSBPHY0, eCLKMUX_FIMC2LCLK_SUSBPHY1, eCLKMUX_FIMC2LCLK_SHDMIPHY, eCLKMUX_FIMC2LCLK_SMPLL, eCLKMUX_FIMC2LCLK_SEPLL, eCLKMUX_FIMC2LCLK_SVPLL,
	eCLKMUX_FIMC1LCLK_XXTI, eCLKMUX_FIMC1LCLK_XUSBXTI, eCLKMUX_FIMC1LCLK_SHDMI27M, eCLKMUX_FIMC1LCLK_SUSBPHY0, eCLKMUX_FIMC1LCLK_SUSBPHY1, eCLKMUX_FIMC1LCLK_SHDMIPHY, eCLKMUX_FIMC1LCLK_SMPLL, eCLKMUX_FIMC1LCLK_SEPLL, eCLKMUX_FIMC1LCLK_SVPLL,
	eCLKMUX_FIMC0LCLK_XXTI, eCLKMUX_FIMC0LCLK_XUSBXTI, eCLKMUX_FIMC0LCLK_SHDMI27M, eCLKMUX_FIMC0LCLK_SUSBPHY0, eCLKMUX_FIMC0LCLK_SUSBPHY1, eCLKMUX_FIMC0LCLK_SHDMIPHY, eCLKMUX_FIMC0LCLK_SMPLL, eCLKMUX_FIMC0LCLK_SEPLL, eCLKMUX_FIMC0LCLK_SVPLL,
	eCLKMUX_MDNIEPWM_XXTI, eCLKMUX_MDNIEPWM_XUSBXTI, eCLKMUX_MDNIEPWM_SHDMI27M, eCLKMUX_MDNIEPWM_SUSBPHY0, eCLKMUX_MDNIEPWM_SUSBPHY1, eCLKMUX_MDNIEPWM_SHDMIPHY, eCLKMUX_MDNIEPWM_SMPLL, eCLKMUX_MDNIEPWM_SEPLL, eCLKMUX_MDNIEPWM_SVPLL,
	eCLKMUX_MDNIE_XXTI, eCLKMUX_MDNIE_XUSBXTI, eCLKMUX_MDNIE_SHDMI27M, eCLKMUX_MDNIE_SUSBPHY0, eCLKMUX_MDNIE_SUSBPHY1, eCLKMUX_MDNIE_SHDMIPHY, eCLKMUX_MDNIE_SMPLL, eCLKMUX_MDNIE_SEPLL, eCLKMUX_MDNIE_SVPLL,
	// CLK_SRC4
	eCLKMUX_UART3_XXTI, eCLKMUX_UART3_XUSBXTI, eCLKMUX_UART3_SHDMI27M, eCLKMUX_UART3_SUSBPHY0, eCLKMUX_UART3_SUSBPHY1, eCLKMUX_UART3_SHDMIPHY, eCLKMUX_UART3_SMPLL, eCLKMUX_UART3_SEPLL, eCLKMUX_UART3_SVPLL,
	eCLKMUX_UART2_XXTI, eCLKMUX_UART2_XUSBXTI, eCLKMUX_UART2_SHDMI27M, eCLKMUX_UART2_SUSBPHY0, eCLKMUX_UART2_SUSBPHY1, eCLKMUX_UART2_SHDMIPHY, eCLKMUX_UART2_SMPLL, eCLKMUX_UART2_SEPLL, eCLKMUX_UART2_SVPLL,
	eCLKMUX_UART1_XXTI, eCLKMUX_UART1_XUSBXTI, eCLKMUX_UART1_SHDMI27M, eCLKMUX_UART1_SUSBPHY0, eCLKMUX_UART1_SUSBPHY1, eCLKMUX_UART1_SHDMIPHY, eCLKMUX_UART1_SMPLL, eCLKMUX_UART1_SEPLL, eCLKMUX_UART1_SVPLL,
	eCLKMUX_UART0_XXTI, eCLKMUX_UART0_XUSBXTI, eCLKMUX_UART0_SHDMI27M, eCLKMUX_UART0_SUSBPHY0, eCLKMUX_UART0_SUSBPHY1, eCLKMUX_UART0_SHDMIPHY, eCLKMUX_UART0_SMPLL, eCLKMUX_UART0_SEPLL, eCLKMUX_UART0_SVPLL,
	eCLKMUX_MMC3_XXTI, eCLKMUX_MMC3_XUSBXTI, eCLKMUX_MMC3_SHDMI27M, eCLKMUX_MMC3_SUSBPHY0, eCLKMUX_MMC3_SUSBPHY1, eCLKMUX_MMC3_SHDMIPHY, eCLKMUX_MMC3_SMPLL, eCLKMUX_MMC3_SEPLL, eCLKMUX_MMC3_SVPLL,
	eCLKMUX_MMC2_XXTI, eCLKMUX_MMC2_XUSBXTI, eCLKMUX_MMC2_SHDMI27M, eCLKMUX_MMC2_SUSBPHY0, eCLKMUX_MMC2_SUSBPHY1, eCLKMUX_MMC2_SHDMIPHY, eCLKMUX_MMC2_SMPLL, eCLKMUX_MMC2_SEPLL, eCLKMUX_MMC2_SVPLL,
	eCLKMUX_MMC1_XXTI, eCLKMUX_MMC1_XUSBXTI, eCLKMUX_MMC1_SHDMI27M, eCLKMUX_MMC1_SUSBPHY0, eCLKMUX_MMC1_SUSBPHY1, eCLKMUX_MMC1_SHDMIPHY, eCLKMUX_MMC1_SMPLL, eCLKMUX_MMC1_SEPLL, eCLKMUX_MMC1_SVPLL,
	eCLKMUX_MMC0_XXTI, eCLKMUX_MMC0_XUSBXTI, eCLKMUX_MMC0_SHDMI27M, eCLKMUX_MMC0_SUSBPHY0, eCLKMUX_MMC0_SUSBPHY1, eCLKMUX_MMC0_SHDMIPHY, eCLKMUX_MMC0_SMPLL, eCLKMUX_MMC0_SEPLL, eCLKMUX_MMC0_SVPLL,
	// CLK_SRC5
	eCLKMUX_PWM_XXTI, eCLKMUX_PWM_XUSBXTI, eCLKMUX_PWM_SHDMI27M, eCLKMUX_PWM_SUSBPHY0, eCLKMUX_PWM_SUSBPHY1, eCLKMUX_PWM_SHDMIPHY, eCLKMUX_PWM_SMPLL, eCLKMUX_PWM_SEPLL, eCLKMUX_PWM_SVPLL,
	eCLKMUX_SPI2_XXTI, eCLKMUX_SPI2_XUSBXTI, eCLKMUX_SPI2_SHDMI27M, eCLKMUX_SPI2_SUSBPHY0, eCLKMUX_SPI2_SUSBPHY1, eCLKMUX_SPI2_SHDMIPHY, eCLKMUX_SPI2_SMPLL, eCLKMUX_SPI2_SEPLL, eCLKMUX_SPI2_SVPLL,
	eCLKMUX_SPI1_XXTI, eCLKMUX_SPI1_XUSBXTI, eCLKMUX_SPI1_SHDMI27M, eCLKMUX_SPI1_SUSBPHY0, eCLKMUX_SPI1_SUSBPHY1, eCLKMUX_SPI1_SHDMIPHY, eCLKMUX_SPI1_SMPLL, eCLKMUX_SPI1_SEPLL, eCLKMUX_SPI1_SVPLL,
	eCLKMUX_SPI0_XXTI, eCLKMUX_SPI0_XUSBXTI, eCLKMUX_SPI0_SHDMI27M, eCLKMUX_SPI0_SUSBPHY0, eCLKMUX_SPI0_SUSBPHY1, eCLKMUX_SPI0_SHDMIPHY, eCLKMUX_SPI0_SMPLL, eCLKMUX_SPI0_SEPLL, eCLKMUX_SPI0_SVPLL,
	// CLK_SRC6
	eCLKMUX_ONEDRAM_SCLKA2M, eCLKMUX_ONEDRAM_SCLKMPLL, eCLKMUX_ONEDRAM_SCLKEPLL, eCLKMUX_ONEDRAM_SCLKVPLL,
	eCLKMUX_PWI_XXTI, eCLKMUX_PWI_XUSBXTI, eCLKMUX_PWI_SHDMI27M, eCLKMUX_PWI_SUSBPHY0, eCLKMUX_PWI_SUSBPHY1, eCLKMUX_PWI_SHDMIPHY, eCLKMUX_PWI_SMPLL, eCLKMUX_PWI_SEPLL, eCLKMUX_PWI_SVPLL,
	eCLKMUX_HPM_SCLKAPLL, eCLKMUX_HPM_SCLKMPLL, 
	eCLKMUX_SPDIF_SAUDIO0, eCLKMUX_SPDIF_SAUDIO1, eCLKMUX_SPDIF_SAUDIO2, 
	eCLKMUX_AUDIO2_XXTI, eCLKMUX_AUDIO2_PCMCDCLK0, eCLKMUX_AUDIO2_SHDMI27M, eCLKMUX_AUDIO2_SUSBPHY0, eCLKMUX_AUDIO2_SUSBPHY1, eCLKMUX_AUDIO2_SHDMIPHY, eCLKMUX_AUDIO2_SMPLL, eCLKMUX_AUDIO2_SEPLL, eCLKMUX_AUDIO2_SVPLL,
	eCLKMUX_AUDIO1_I2SCDCLK1, eCLKMUX_AUDIO1_PCMCDCLK1, eCLKMUX_AUDIO1_SHDMI27M, eCLKMUX_AUDIO1_SUSBPHY0, eCLKMUX_AUDIO1_SUSBPHY1, eCLKMUX_AUDIO1_SHDMIPHY, eCLKMUX_AUDIO1_SMPLL, eCLKMUX_AUDIO1_SEPLL, eCLKMUX_AUDIO1_SVPLL,
	eCLKMUX_AUDIO0_XXTI, eCLKMUX_AUDIO0_XUSBXTI, eCLKMUX_AUDIO0_SHDMI27M, eCLKMUX_AUDIO0_SUSBPHY0, eCLKMUX_AUDIO0_SUSBPHY1, eCLKMUX_AUDIO0_SHDMIPHY, eCLKMUX_AUDIO0_SMPLL, eCLKMUX_AUDIO0_SEPLL, eCLKMUX_AUDIO0_SVPLL
} CLKMUX_STATE_ID;

typedef enum 
{
	// CLK_SRC_MASK0
	eCLKMASK_PWI, 
	eCLKMASK_SPDIF, 
	eCLKMASK_AUDIO2, 
	eCLKMASK_AUDIO1, 
	eCLKMASK_AUDIO0,
	eCLKMASK_PWM, 
	eCLKMASK_SPI2, 
	eCLKMASK_SPI1, 
	eCLKMASK_SPI0, 
	eCLKMASK_UART3, 
	eCLKMASK_UART2, 
	eCLKMASK_UART1, 
	eCLKMASK_UART0,
	eCLKMASK_MMC3, 
	eCLKMASK_MMC2, 
	eCLKMASK_MMC1, 
	eCLKMASK_MMC0,
	eCLKMASK_FINVPLL, 
	eCLKMASK_CSIS, 
	eCLKMASK_FIMD, 
	eCLKMASK_CAM1, 
	eCLKMASK_CAM0,
	eCLKMASK_DAC, 
	eCLKMASK_MIXER, 
	eCLKMASK_HDMI,
	// CLK_SRC_MASK1
	eCLKMASK_FIMC2LCLK, 
	eCLKMASK_FIMC1LCLK, 
	eCLKMASK_FIMC0LCLK,
	eCLKMASK_MDNIEPWM, 
	eCLKMASK_MDNIE
}CLKMASK_ID;

typedef enum
{
	// CLK_MUX_STAT0
	eCLKMUX_STATUS_ONENAND, 
	eCLKMUX_STATUS_PSYS, 
	eCLKMUX_STATUS_DSYS, 
	eCLKMUX_STATUS_MSYS, 
	eCLKMUX_STATUS_VPLL, 
	eCLKMUX_STATUS_EPLL, 
	eCLKMUX_STATUS_MPLL, 
	eCLKMUX_STATUS_APLL, 
	// CLK_MUX_STAT1
	eCLKMUX_STATUS_HPM, 
	eCLKMUX_STATUS_ONEDRAM, 
	eCLKMUX_STATUS_MFC, 
	eCLKMUX_STATUS_G3D
}CLKMUX_STATUS;

typedef enum 
{
	// CLK_DIV0
	eCLKDIV_PCLKPSYS, 
	eCLKDIV_HCLKPSYS, 
	eCLKDIV_PCLKDSYS, 
	eCLKDIV_HCLKDSYS, 
	eCLKDIV_PCLKMSYS, 
	eCLKDIV_HCLKMSYS,
	eCLKDIV_A2M, 
	eCLKDIV_APLL,
	// CLK_DIV1
	eCLKDIV_CSIS, 
	eCLKDIV_FIMD, 
	eCLKDIV_CAM1, 
	eCLKDIV_CAM0, 
	eCLKDIV_FIMC, 
	eCLKDIV_TBLK,
	// CLK_DIV2
	eCLKDIV_MFC, 
	eCLKDIV_G3D,
	// CLK_DIV3
	eCLKDIV_FIMC2, 
	eCLKDIV_FIMC1, 
	eCLKDIV_FIMC0, 
	eCLKDIV_MDNIEPWM, 
	eCLKDIV_MDNIE, 
	// CLK_DIV4
	eCLKDIV_UART3, 
	eCLKDIV_UART2, 
	eCLKDIV_UART1, 
	eCLKDIV_UART0, 
	eCLKDIV_MMC3, 
	eCLKDIV_MMC2, 
	eCLKDIV_MMC1, 
	eCLKDIV_MMC0,
	// CLK_DIV5
	eCLKDIV_PWM, 
	eCLKDIV_SPI2, 
	eCLKDIV_SPI1, 
	eCLKDIV_SPI0,
	// CLK_DIV6
	eCLKDIV_ONEDRAM, 
	eCLKDIV_PWI, 
	eCLKDIV_HPM, 
	eCLKDIV_COPY, 
	eCLKDIV_ONENAND, 
	eCLKDIV_AUDIO2, 
	eCLKDIV_AUDIO1, 
	eCLKDIV_AUDIO0, 
	// CLK_DIV7
	eCLKDIV_DPM, 
	eCLKDIV_DVSEM
}CLKDIV_ID;

typedef enum 
{
	// CLK_GATE_IP0
	eCLKGATE_IP_CSIS = 31, 
	eCLKGATE_IP_IPC = 30, 
	eCLKGATE_IP_ROTATOR = 29,
	eCLKGATE_IP_JPEG = 28, 
	eCLKGATE_IP_FIMC2 = 26, 
	eCLKGATE_IP_FIMC1 = 25, 
	eCLKGATE_IP_FIMC0 = 24,  
	eCLKGATE_IP_MFC = 16, 
	eCLKGATE_IP_G3D = 8, 
	eCLKGATE_IP_IMEM = 5, 
	eCLKGATE_IP_PDMA1 = 4, 
	eCLKGATE_IP_PDMA0 = 3, 
	eCLKGATE_IP_MDMA = 2,
	eCLKGATE_IP_DMC1 = 1, 
	eCLKGATE_IP_DMC0 = 0, 
	// CLK_GATE_IP1
	eCLKGATE_IP_NFCON = 128, 
	eCLKGATE_IP_SROMC = 126, 
	eCLKGATE_IP_CFCON = 125, 
	eCLKGATE_IP_NANDXL = 124, 	
	eCLKGATE_IP_USBHOST = 117, 
	eCLKGATE_IP_USBOTG = 116, 
	eCLKGATE_IP_HDMI = 111, 
	eCLKGATE_IP_TVENC = 110, 
	eCLKGATE_IP_MIXER = 109, 
	eCLKGATE_IP_VP = 108,
	eCLKGATE_IP_DSIM = 102, 
	eCLKGATE_IP_MIE = 101, 
	eCLKGATE_IP_FIMD = 100,
	// CLK_GATE_IP2
	eCLKGATE_IP_TZIC3 = 231, 
	eCLKGATE_IP_TZIC2 = 230, 
	eCLKGATE_IP_TZIC1 = 229, 
	eCLKGATE_IP_TZIC0 = 228, 
	eCLKGATE_IP_VIC3 = 227, 
	eCLKGATE_IP_VIC2 = 226, 
	eCLKGATE_IP_VIC1 = 225, 
	eCLKGATE_IP_VIC0 = 224, 
	eCLKGATE_IP_TSI = 220, 
	eCLKGATE_IP_MMC3 = 219, 
	eCLKGATE_IP_MMC2 = 218, 
	eCLKGATE_IP_MMC1 = 217, 
	eCLKGATE_IP_MMC0 = 216, 
	eCLKGATE_IP_SECJTAG = 211,
	eCLKGATE_IP_HOSTIF = 210, 
	eCLKGATE_IP_MODEM = 209, 
	eCLKGATE_IP_CORESIGHT = 208, 
	eCLKGATE_IP_SDM = 201, 
	eCLKGATE_IP_SECSS = 200,
	// CLK_GATE_IP3
	eCLKGATE_IP_PCM2 = 330, 
	eCLKGATE_IP_PCM1 = 329, 
	eCLKGATE_IP_PCM0 = 328, 	
	eCLKGATE_IP_SYSCON = 327, 
	eCLKGATE_IP_GPIO = 326, 
	eCLKGATE_IP_TSADC = 324, 
	eCLKGATE_IP_PWM = 323, 
	eCLKGATE_IP_WDT = 322, 
	eCLKGATE_IP_KEYIF = 321, 
	eCLKGATE_IP_UART3 = 320,
	eCLKGATE_IP_UART2 = 319, 
	eCLKGATE_IP_UART1 = 318, 
	eCLKGATE_IP_UART0 = 317, 
	eCLKGATE_IP_SYSTIMER = 316, 
	eCLKGATE_IP_RTC = 315,
	eCLKGATE_IP_SPI2 = 314, 
	eCLKGATE_IP_SPI1 = 313, 
	eCLKGATE_IP_SPI0 = 312, 
	eCLKGATE_IP_I2CHDMIPHY = 311, 
	eCLKGATE_IP_I2CHDMIDDC = 310, 
	eCLKGATE_IP_I2C2 = 309, 
	eCLKGATE_IP_I2C1 = 308, 
	eCLKGATE_IP_I2C0 = 307,
	eCLKGATE_IP_I2S2 = 306, 
	eCLKGATE_IP_I2S1 = 305, 
	eCLKGATE_IP_I2S0 = 304,
	eCLKGATE_IP_AC94 = 301, 
	eCLKGATE_IP_SPDIF = 300,	
	// CLK_GATE_IP4
	eCLKGATE_IP_TZPC3 = 408, 
	eCLKGATE_IP_TZPC2 = 407, 
	eCLKGATE_IP_TZPC1 = 406, 
	eCLKGATE_IP_TZPC0 = 405, 
	eCLKGATE_IP_SECKEY = 403, 
	eCLKGATE_IP_IEM_APC = 402, 
	eCLKGATE_IP_IEM_IEC = 401, 
	eCLKGATE_IP_CHIP_ID = 400, 
	// ALL
	eCLKGATE_IP_ALL = 500	
}CLKGATE_IP_TYPE;

typedef enum 
{
	eCLKGATE_BLOCK_INTC = 10, 
	eCLKGATE_BLOCK_MMC = 9, 
	eCLKGATE_BLOCK_DEBUG = 8,
	eCLKGATE_BLOCK_SECURITY = 7,
	eCLKGATE_BLOCK_MEMORY = 6, 
	eCLKGATE_BLOCK_USB = 5, 
	eCLKGATE_BLOCK_TV = 4, 
	eCLKGATE_BLOCK_LCD = 3, 
	eCLKGATE_BLOCK_IMG = 2, 
	eCLKGATE_BLOCK_MFC = 1, 
	eCLKGATE_BLOCK_G3D = 0,
	eCLKGATE_BLOCK_ALL = 11
}CLKGATE_BLOCK_TYPE;

typedef enum 
{
	eCLKOUT_FOUTAPLL_DIV4	= (u32)0,
	eCLKOUT_FOUTMPLL_DIV2	= (u32)1, 		
	eCLKOUT_FOUTEPLL		= (u32)2,
	eCLKOUT_FOUTVPLL		= (u32)3, 
	eCLKOUT_SCLKUSBPHY0		= (u32)4,
	eCLKOUT_SCLKUSBPHY1		= (u32)5,
	eCLKOUT_SCLKHDMIPHY		= (u32)6,
	eCLKOUT_RTC				= (u32)7,
	eCLKOUT_TICK			= (u32)8,
	eCLKOUT_HCLKMSYS		= (u32)9,
	eCLKOUT_PCLKMSYS		= (u32)10,
	eCLKOUT_HCLKDSYS		= (u32)11,
	eCLKOUT_PCLKDSYS		= (u32)12,
	eCLKOUT_HCLKPSYS		= (u32)13,
	eCLKOUT_PCLKPSYS		= (u32)14,
	eCLKOUT_ARMCLK_DIV4		= (u32)15,
	eCLKOUT_SCLKHPM			= (u32)16,
	eCLKOUT_XXTI			= (u32)17,
	eCLKOUT_XUSBXTI			= (u32)18,
	eCLKOUT_DOUT			= (u32)19,
	eCLKOUT_XXTI_PD		= (u32)102,
	eCLKOUT_XUSBXTI_PD	= (u32)103
} CLKOUT_TYPE;

typedef enum 
{
	eEBI_CIRCULAR, 
	eEBI_FIX0, // SROMC - OneNANDC - NFCON - CFCON
	eEBI_FIX1, // OneNANDC - SROMC - NFCON - CFCON
	eEBI_FIX2, // NFCON - SROMC - OneNANDC - CFCON
	eEBI_FIX3  // CFCON - SROMC - OneNANDC - NFCON
}EBI_PRIORITY;

typedef enum 
{
	eAHB_LASTGRANTLOWEST,
	eAHB_ROTATION,
	eAHB_FIX0, // (highest)0-1-2-3-4-5-6-7(lowest)
	eAHB_FIX1, // (highest)1-2-3-4-5-6-0-7(lowest) 
	eAHB_FIX2, // (highest)2-3-4-5-6-0-1-7(lowest)
	eAHB_FIX3, // (highest)3-4-5-6-9-1-2-7(lowest)
	eAHB_FIX4, // (highest)4-5-6-0-1-2-3-7(lowest)
	eAHB_FIX5, // (highest)5-6-0-1-2-3-4-7(lowest)
	eAHB_FIX6, // (highest)5-6-0-1-2-3-4-7(lowest) 
	eAHB_FIX7  // (highest)6-0-1-2-3-4-5-7(lowest)
}AHB_PRIORITY;

typedef enum 
{
	eCAM_MUX0, 
	eCAM_MUX1, 
	eCAM_MUX2, 
	eCAM_MUX3
}CAM_MUX_ID;

typedef enum 
{
	eMIXEROUT_SDOUT, 
	eMIXEROUT_HDMI
}MIXEROUT_ID;

typedef enum 
{
	eMDNIE_MIE,	
	eMDNIE_MDNIE
}MDNIE_ID;

typedef enum 
{
	eEMA_CON0, 
	eEMA_CON1, 
	eEMA_CON2, 
	eEMA_CON3, 
	eEMA_CON4, 
	eEMA_CON5, 
	eEMA_CON6		
}EMA_ID;


/////// PMU ////////

typedef enum 
{
	eOSC_USB	= (u32)1, 
	eOSC_MAIN	= (u32)0
}OSC_CON;

typedef enum 
{
	eRST_STAT_DEEPIDLE_WU	= (u32)(1<<19),
	eRST_STAT_DEEPSTOP_WU	= (u32)(1<<18),
	eRST_STAT_SLEEP_WU 		= (u32)(1<<16),
	eRST_STAT_SW_RST 		= (u32)(1<<3),
	eRST_STAT_WDT_RST 		= (u32)(1<<2),
	eRST_STAT_WARM_RST 		= (u32)(1<<1),
	eRST_STAT_HW_RST 		= (u32)(1<<0)
}RESET_STATUS;

typedef enum 
{
	eWFI_IGNORE	= (u32)0, 
	eWFI_IDLE		= (u32)1, 
	eWFI_STOP		= (u32)2, 
	eWFI_SLEEP		= (u32)3
}CFG_WFI;

typedef enum 
{
	eWAKEUP_EINT		= (u32)0,
	eWAKEUP_EINT0		= (u32)100,
	eWAKEUP_EINT1		= (u32)101,
	eWAKEUP_EINT2		= (u32)102,
	eWAKEUP_EINT3		= (u32)103,
	eWAKEUP_EINT4		= (u32)104,
	eWAKEUP_EINT5		= (u32)105,
	eWAKEUP_EINT6		= (u32)106,
	eWAKEUP_EINT7		= (u32)107,
	eWAKEUP_EINT8		= (u32)108,
	eWAKEUP_EINT9		= (u32)109,
	eWAKEUP_EINT10	= (u32)110,
	eWAKEUP_EINT11	= (u32)111,
	eWAKEUP_EINT12	= (u32)112,
	eWAKEUP_EINT13	= (u32)113,
	eWAKEUP_EINT14	= (u32)114,
	eWAKEUP_EINT15	= (u32)115,
	eWAKEUP_EINT16	= (u32)116,
	eWAKEUP_EINT17	= (u32)117,
	eWAKEUP_EINT18	= (u32)118,
	eWAKEUP_EINT19	= (u32)119,	
	eWAKEUP_EINT20	= (u32)120,
	eWAKEUP_EINT21	= (u32)121,
	eWAKEUP_EINT22	= (u32)122,
	eWAKEUP_EINT23	= (u32)123,
	eWAKEUP_EINT24	= (u32)124,
	eWAKEUP_EINT25	= (u32)125,
	eWAKEUP_EINT26	= (u32)126,
	eWAKEUP_EINT27	= (u32)127,
	eWAKEUP_EINT28	= (u32)128,
	eWAKEUP_EINT29	= (u32)129,	
	eWAKEUP_EINT30	= (u32)130,
	eWAKEUP_EINT31	= (u32)131,	
	eWAKEUP_CEC		= (u32)15,
	eWAKEUP_ST		= (u32)14,
	eWAKEUP_I2S		= (u32)13,
	eWAKEUP_MMC3		= (u32)12,
	eWAKEUP_MMC2		= (u32)11,
	eWAKEUP_MMC1		= (u32)10,
	eWAKEUP_MMC0		= (u32)9,
	eWAKEUP_KEY		= (u32)5,
	eWAKEUP_TS1		= (u32)4,
	eWAKEUP_TS0		= (u32)3,
	eWAKEUP_RTCTICK	= (u32)2,
	eWAKEUP_RTCALARM	= (u32)1,
	eWAKEUP_OTHERS	= (u32)31,
	eWAKEUP_ALL		= (u32)99
}WAKEUP_ID;

typedef enum 
{
	eMODE_NORMAL		=(u32)0, 
	eMODE_IDLE			=(u32)1, 
	eMODE_DEEPIDLE	=(u32)2, 
	eMODE_STOP		=(u32)3, 
	eMODE_DEEPSTOP	=(u32)4, 
	eMODE_SLEEP		=(u32)5
}POWER_MODE;

typedef enum 
{
	eCFG_RET 		= (u8)1,
	eCFG_ON 		= (u8)2,
	eCFG_OFF 		= (u8)0,
	eCFG_NODEEP 	= (u8)0,
	eCFG_DEEP 		= (u8)1
}PWRMODE_CFG_ID;

typedef enum 
{
	eMEMCFG_ONENAND	= (u32)8, 
	eMEMCFG_MODEMIF	= (u32)7, 
	eMEMCFG_HOSTIF	= (u32)6, 
	eMEMCFG_USBOTG	= (u32)5, 
	eMEMCFG_MMC		= (u32)4, 
	eMEMCFG_CSSYS	= (u32)3, 
	eMEMCFG_SECSS	= (u32)2, 
	eMEMCFG_IRAM	= (u32)1,
	eMEMCFG_ALL		= (u32)9
}CFG_STOP_MEM;

typedef enum 
{
	eSUB_BLOCK_IROM = 7, 
	eSUB_BLOCK_AUDIO = 6, 
	eSUB_BLOCK_CAM = 5, 
	eSUB_BLOCK_TV = 4, 
	eSUB_BLOCK_LCD = 3, 
	eSUB_BLOCK_G3D = 2, 
	eSUB_BLOCK_MFC = 1, 
	eSUB_BLOCK_TOP = 0,
	eSUB_BLOCK_ALL = 8	
}SUB_BLOCK;

typedef enum 
{
	eRET_BLOCK_GPIO = (u32)31, 
	eRET_BLOCK_CFIO = (u32)30, 
	eRET_BLOCK_MMCIO = (u32)29, 
	eRET_BLOCK_UARTIO = (u32)28, 
	eRET_BLOCK_ALL	 = (u32)32
}RET_BLOCK;

typedef enum 
{
	// PWR_ON: Power On, PWR_OFF: Power Off, EXT_PWR_OFF: Externally Power Off, RET: Retention, KEEP_NORMAL_STATE: Keep Normal Power State
	ePWR_ON, 
	ePWR_OFF, 
	eEXT_PWR_OFF, 
	eRET, 
	eKEEP_NORMAL_STATE
}POWER_TYPE; 

typedef enum 
{
	eRSTOUT_LOW, 
	eRSTOUT_HIGH, 
	eRSTOUT_AUTO_nRESET
}RSTOUT_TYPE;

typedef enum 
{
	eFIMC_L2_MEM, 
	eAUDIO_L2_MEM
}L2_MEMORY;

typedef enum
{
	eINIT_SYSCLK_NORMAL,
	eINIT_SYSCLK_MUX, 
	eINIT_SYSCLK_DIV,
	eINIT_SYSCLK_HIGH,
	eINIT_SYSCLK_MID,
	eINIT_SYSCLK_LOW,
	eINIT_SYSCLK_VERYLOW,
	eINIT_SYSCLK_NB_NORM,
	eINIT_SYSCLK_NB_HIGH,
	eINIT_SYSCLK_NB_LOW	
}INIT_SYSCLK;

typedef enum
{
	eDVFS_LV0,
	eDVFS_LV1, 
	eDVFS_LV2,
	eDVFS_LV3,
	eDVFS_LV4,
	eDVFS_LV5,
	eDVFS_LV6
}DVFS_LV;

typedef enum 
{
	eFIMD, 
	eMDNIE, 
	eMIE, 
	eFIMC0,
	eFIMC1,
	eFIMC2,
	eIPC,
	eJPEG,
	eMFC,
	eVP,
	eMIXER,
	eHDMI,
	eTVENC,
	eROTATOR,
	eCRYPTO,
	eSGX540,
	eHDTV,
	eSDTV,
	eBLKLCD,
	eBLKCAM,
	eMM_ALL

}IP_eID;

typedef enum 
{
	eDISP_MIE,
	eDISP_MDNIE,
	eDISP_BYPASS

}ePath_Disp;

typedef enum
{
	DPHY_HW = 1,
	DPHY_Slave = 2,
	DPHY_Master = 4,	
}DPHY_Block;

#define HW_WFI	TRUE
#define SW_WFI	FALSE

#define USER_CONFIG		TRUE
#define BASIC_CONFIG	FALSE

// Define Inform 5 register data for Aging test 
// [15:8] Wakeup reset type, [7:0] Test type
#define INFORM_GENERAL		0x1
#define INFORM_AGING		0xA
#define INFORM_AGING_R		0xB
#define INFORM_AGING_E		0xC
#define INFORM_IDLE			0x10
#define INFORM_DIDLE		0x20
#define INFORM_STOP			0x30
#define INFORM_DSTOP		0x40
#define INFORM_SLEEP		0x50
#define INFORM_SWRST		0x60
#define INFORM_WDTRST		0x70
#define INFORM_WARMRST		0x80

#define DVFS_MAX_LV	8


//////////////////////////////////////////////
// Chip ID
//////////////////////////////////////////////
void SYSC_ReadSystemID(void);

//////////////////////////////////////////////
// Clock Management Unit (CMU - SYS OFF region)
//////////////////////////////////////////////
void SYSC_UpdateClkInform(void);
u32	SYSC_GetARMClock(void);
bool SYSC_IsLockDetected(PLL_TYPE  ePLL);

void SYSC_SetLockTime(PLL_TYPE  ePLL, u32 uLockTime);
u32 SYSC_GetLockTime(PLL_TYPE  ePLL);
u32 SYSC_GetPLLReg(PLL_TYPE ePLL);
void SYSC_SetPLLReg(PLL_TYPE ePLL, u32 uRegValue);
void SYSC_StartPLLbyMPS(PLL_TYPE  ePLL, u32 uMdiv, u32 uPdiv, u32 uSdiv);
void SYSC_StartPLLbyFout(PLL_TYPE ePLL, u32 uFout);
void SYSC_StartPLL(PLL_TYPE ePLL);
void SYSC_StopPLL(PLL_TYPE  ePLL);
u32 SYSC_CalPllFout(PLL_TYPE uPLL_TYPE, u32 uMdiv, u32 uPdiv, u32 uSdiv);
void SYSC_SetClkMuxState(CLKMUX_STATE_ID eId);
u32 SYSC_GetClkMuxReg(u32 uRegNum);
u32 SYSC_GetClkMuxStatusReg(u32 uRegNum);
void SYSC_SetClkDiv(CLKDIV_ID eId, u32 uRatio);
void SYSC_SetClkDivReg(u32 uRegNum, u32 uRegVal);
u32 SYSC_GetClkDiv(CLKDIV_ID eId);
u32 SYSC_GetClkDivReg(u32 uRegNum);
u32 SYSC_GetClkDivStatusReg(u32 uRegNum);

void SYSC_SetClkGatebyIP(CLKGATE_IP_TYPE eType, bool bPass); 
void SYSC_SetClkGatebyBlock(CLKGATE_BLOCK_TYPE eType, bool bPass); 
u32 SYSC_GetClkGateIPReg(u32 uIPRegNum);
u32 SYSC_GetClkGateBlockReg(void);

void SYSC_SetClkOut(CLKOUT_TYPE eType, u32 uDivVal);
void SYSC_SetDclkOut(u32 uDclkCmp, u32 uDclkDiv, u32 uDclkSrcClk);
void SYSC_SetDclkOnOff(bool bEnable);

// MISC
void SYSC_SwReset(void);
void SYSC_SetOneDramConfig(u8 ucAsync, u8 ucSclk); 
//void SYSC_SetDisplayControl(bool bMdnie); 
//void SYSC_SetAudioEndian(u32 uCh, u32 uEndian);

// IEM
void SYSC_SetDcgIdxMapReg(u32 uRegIdx, u32 uRegValue);
u32 SYSC_GetDcgIdxMapReg(u32 uRegIdx); 
void SYSC_SetDcgPerformaceMapReg(u32 uRegIdx, u32 uRegValue);
u32 SYSC_GetDcgPerformanceMapReg(u32 uRegIdx); 
void SYSC_SetDvcIdxMap(u32 uRegValue);
u32 SYSC_GetDvcIdxMap(void); 
void SYSC_SetCpuMaxFreq(u32 uRegValue);
u32 SYSC_GetCpuMaxFreq(void); 
void SYSC_SetDpmAccFreq(u32 uRegValue);
u32 SYSC_GetDpmAccFreq(void); 
void SYSC_SetDpmClkEn(bool bEnable);
void SYSC_SetDvsEmulClkEn(bool bEnable);
void SYSC_SetApllConIemPerfLevel(u32 uPerfLevel, u32 uMdiv, u32 uPdiv, u32 uSdiv);
void SYSC_SetIemCtrl(bool bIemFuncEn, u32 uPrevTargetPerformanceLevel);
void SYSC_SetClkDivIemPerfLevel(u32 uPerfLevel, u32 uApllDiv, u32 uHpmClkDiv, u32 uArmClkDiv, u32 uHclkD0Div);
u32 SYSC_GetIemHpmClkDiv(void); 


  
//////////////////////////////////////////////
// Power Management Unit (PMU - ALIVE region)
//////////////////////////////////////////////

u32 SYSC_GetOperatingMode(void);
u32 SYSC_GetResetStatusReg(void);  

void SYSC_SetConfigStandbyWFI(POWER_MODE ePwrMode);
void SYSC_DisableSyscInt(void);
u32 SYSC_GetSyscIntStatus(void);

void SYSC_SetOscPadOnOff(POWER_MODE ePwrMode, OSC_CON eOscType, bool bEnable); // include sleep mode config
void SYSC_SetPowerMode(POWER_MODE ePwrMode);
void SYSC_SetIdleModeConfig(bool bTopLogicOn, bool bTopMemOn, bool bArmL2CacheRet, bool bDeepMode); 
void SYSC_SetStopModeConfig(u8 usTopLogicOn, u8 usTopMemOn, u8 usArmL2CacheRet, u8 usDeepMode); 
void SYSC_SetStopMemConfig(CFG_STOP_MEM eStopMem, bool bRetentionEn);
void SYSC_SetAllStopMemConfig(bool bOn);
u32 SYSC_GetNormalModeConfigReg(void);
u32 SYSC_GetIdleModeConfigReg(void);
u32 SYSC_GetStopModeConfigReg(void);
u32 SYSC_GetStopMemConfigReg(void);

void SYSC_SetWakeupMask(WAKEUP_ID eWakeupMask, bool bSrcMask);
u32 SYSC_GetWakeupStatus(bool bRegValue); 
bool SYSC_ClearWakeupStatus(WAKEUP_ID eWakeup); 

void SYSC_SetBlockPowerGating(SUB_BLOCK eBlock, bool bOn); 
u32 SYSC_GetBlockPowerStatus(SUB_BLOCK eBlock);  
u32 SYSC_GetBlockPowerStatusReg(void);

void SYSC_SetOscFreq(u32 uFreqValue);
void SYSC_SetOscStableCounter(u32 uCntValue);
void SYSC_SetPowerStableCounter(u32 uCntValue);
void SYSC_SetMtcStableCounter(SUB_BLOCK eMtcStable, u32 uCntValue);
void SYSC_SetClampStableCounter(bool bClampOn, u32 uCntValue);

// MISC
void SYSC_ReleaseRetentionIO(RET_BLOCK eRET); 
void SYSC_SetUSBPHYControl(bool bEnable);

void SYSC_SetPSHold(bool bOn);
void SYSC_SetInformReg(u32 uRegIdx, u32 uRegValue);
u32 SYSC_GetInformReg(u32 uRegIdx); 


//************** Syscon Library for Users **************
void SYSC_InitSysClk(INIT_SYSCLK uNum);
void SYSC_ChangePllnDiv(PLL_TYPE eSelPllType, u32 uSelM, u32 uSelP, u32 uSelS, u32 uSelLockTime,
	u32 uSelDivAPLL, u32 uSelDivA2M, u32 uSelDivHclkMsys, u32 uSelDivPclkMsys,
	u32 uSelDivHclkDsys, u32 uSelDivPclkDsys, u32 uSelDivHclkPsys, u32 uSelDivPclkPsys);
void SYSC_SetBusDiv(u32 uSelDivAPLL, u32 uSelDivA2M, u32 uSelDivHclkMsys, u32 uSelDivPclkMsys,
					u32 uSelDivHclkDsys, u32 uSelDivPclkDsys, u32 uSelDivHclkPsys, u32 uSelDivPclkPsys);
void SYSC_ChangeDvfsLv(DVFS_LV eDvfs_Lv);
void SYSC_StartPowerMode(POWER_MODE ePwrMode, bool bEnterMethod, bool bUserConfig);
void SYSC_EnteringPowerMode(POWER_MODE ePwrMode, PWRMODE_CFG_ID ucSelTop, u32 uSelMethod, u32 uSelAging);
void SYSC_SetSleepGPIO(void);


u32 SYSC_RdRSTSTAT(u32 uPRINT);

#if 1	// MM Part
void SYSC_SetBlockPowerON_IP(IP_eID eIP); 
void SYSC_SetBlockPowerOFF_IP(IP_eID eIP);
void SYSC_SetClkON_IP(IP_eID eIP);
void SYSC_SetClkOFF_IP(IP_eID eIP) ;
void SYSC_EnHDMIPHY (void);
void SYSC_DisHDMIPHY (void);	
void SYSC_EnDAC (void);
void SYSC_DisDAC (void);
void SYSC_EnADC (void);
void SYSC_DisADC (void);
void SYSC_SetDivHDMI(u32 uDiv);
void SYSC_InitClkForMM(void);

void SYSC_SetSleepMIE (u32 uSleep);
void SYSC_SetDispMIE (u32 uDisp);
void SYSC_SetDispPath(ePath_Disp eSel);
void SYSC_EnDPHY(DPHY_Block ePhyBlock, u8 bEn);
	
#endif


#endif // __SYSC_H__


