/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : Sys_timer_test.c
*  
*	File Description : This file implements the API functons for System Timer test.
*
*	Author : chansik.Jeon
*	Dept. : AP Development Team
*	Created Date : 2009/02/11
*	Version : 0.0
* 
*	History
*	- Created(Chansik.Jeon 2009/02/11)
*   
*  
**************************************************************************************/


/* Include Files */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "sys_timer.h"
#include "def.h"
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "intc.h"
#include "gpio.h"
#include "dma.h"


/*
extern volatile u32 g_uIntCounter = 0;
extern volatile u32 g_uTICNTB = 0;
extern volatile u32 g_uTFCNTB = 0;
extern volatile u32 g_uICNTB = 0;
extern volatile u32 g_uTCON = 0;
*/

	
void SYSTIMER_Test(void);
void SysTimer_SetUp(void);
void SFR_Int_Check(void);
void SysTimer_Polling(void);




const testFuncMenu g_aSYSTIMERTestFunc[] =
{	

	SFR_Int_Check,			"SFR Int test",
	SysTimer_Polling,		"Check Observation count register",
       SysTimer_SetUp,			"System Timer Normal test",
	
	0,0
};


void SYSTIMER_Test(void)
{
	u32 uCountFunc=0;
	s32 iSel=0;

	while(1)
	{

	UART_Printf("\n\n================== System Timer Function Test =====================\n\n");

		for (uCountFunc=0; (u32)(g_aSYSTIMERTestFunc[uCountFunc].desc)!=0; uCountFunc++)
			UART_Printf("%2d: %s\n", uCountFunc, g_aSYSTIMERTestFunc[uCountFunc].desc);

		UART_Printf("\nSelect the function to test : ");
		iSel =UART_GetIntNum();
		UART_Printf("\n");
		if(iSel == -1) 
			break;

		if (iSel>=0 && iSel<(sizeof(g_aSYSTIMERTestFunc)/8-1))
			(g_aSYSTIMERTestFunc[iSel].func) ();
	}
}	



//////////
// Function Name : SysTimer_SetUp
// Function Description : This function set up Timers by User's Inputs and change interval interrupt
// Input :   NONE
// Output : NONE
// Version : v0.0

void SysTimer_SetUp(void)
{

		s32  sContinue;
		u32 uTmrStrtStp;
		u32 uIntrrptStrtStp;
		
 		SysTimer_UserSelect();

		while(1)
		{
			UART_Printf("If you want to change timer setting Enter any key\n\n");	
			UART_Getc();
			
			UART_Printf("Do you want to stop timer or change timer setting?\n");
			UART_Printf("0: Stop timer (Interrupt disable -> Timer stop)\n");
			UART_Printf("1: Change timer setting\n");
			UART_Printf("2: Change Interval Interrupt At run time, Manual update\n");
			UART_Printf("3: Change Interval Interrupt At run time, Auto-reload\n");
			UART_Printf("4: Timer start/stop\n");
			UART_Printf("5: Interrupt enable/disable\n");
			sContinue = UART_GetIntNum();

			switch (sContinue) {
				case 1 :
					SysTimer_UserSelect();
					break;
				case 2 :
					SysTimer_ChangeIntervalINT();
					break;
				case 3 :
					SysTimer_ChangeIntervalINT_autoreload();
					break;
				case 4 :
					uTmrStrtStp = Inp32(rSYS_TCON);
					if (uTmrStrtStp&0x1) {
						UART_Printf("Timer Stop\n");
						Outp32(rSYS_TCON,uTmrStrtStp&~0x1);
						Check_Status(eTCON);
						}
					else {
						UART_Printf("Timer Start\n");
						Outp32(rSYS_TCON,uTmrStrtStp|0x1);
						Check_Status(eTCON);
						}
					break;
				case 5 :
					uIntrrptStrtStp = Inp32(rSYS_TCON);
					if (uIntrrptStrtStp&0x8) {
						UART_Printf("Interrupt Stop\n");
						Outp32(rSYS_TCON,uIntrrptStrtStp&~(0x1<<3));
						Check_Status(eTCON);
						}
					else {
						UART_Printf("Interrupt Start\n");
						Outp32(rSYS_TCON,uIntrrptStrtStp|(0x1<<3));
						Check_Status(eTCON);
						}
					break;
				case 0 :
				default :
					INTC_Disable(NUM_SYSTIMER);
					Int_Control(eICNTEIE, eDisable);
					Int_Stop();
					SysTimer_Stop();
				}

		}
	
}
					

void SFR_Int_Check(void)
{
	u32 uGetMenu;
	u32 uloop=1;
	u32 urTCON;
	u32 uCntICNTB;
	u32 uCntTFCNTB;
	u32 uCntTICNTB;

	INTC_SetVectAddr(NUM_SYSTIMER,Isr_SysTimer);
	INTC_Enable(NUM_SYSTIMER);

	Outp32(rSYS_INT_CSTAT,0x781);

	UART_Printf("Check whether interrupt occur, when access SRF\n");
	UART_Printf("1 : Write rTCON\n");
	UART_Printf("2 : Write rICNTB\n");
	UART_Printf("3 : Write rTFCNTB\n");
	UART_Printf("4 : Write rTICNTB\n");
	UART_Printf("5 : Exit\n");

	while(uloop) {
		uGetMenu = UART_GetIntNum();
		switch (uGetMenu) {
			case 1 :
				Outp32(rSYS_TCON,0);
				break;
			case 2 :
				Outp32(rSYS_ICNTB,0);
				break;
			case 3 :
				Outp32(rSYS_TFCNTB,0);
				break;
			case 4 :
				Outp32(rSYS_TICNTB,0);
				break;
			case 5 :
				uloop=0;
				break;
		}
	}

	Outp32(rSYS_INT_CSTAT,0x0);
	INTC_Disable(NUM_SYSTIMER);
}


void SysTimer_Polling(void)
{
	u32 uTemp;
	u32 uFDIV_sel=0;
	u32 uTickGen_sel=0;
	u32 uClock=0;
	u32 uDivider=0;
	u32 uPrescaler=1;
	u32 uTICNTB=11999999;
	u32 uTFCNTB=0;
	u32 uICNTB=9;

	u32 uTICNTO;
	u32 uICNTO;

	SysTimer_Reset();
	
	uTemp = Inp32(rSYS_TCFG);
	uTemp = (uTemp & ~(0xffffffff)) |((uFDIV_sel<<15)|(uTickGen_sel<<14)|(uClock<<12)|(uDivider<<8)|(uPrescaler<<0));
	Outp32(rSYS_TCFG,uTemp);

	uTemp = Inp32(rSYS_TICNTB);
	uTemp = (uTemp & ~(0xffffffff)) |(uTICNTB);
	Outp32(rSYS_TICNTB,uTemp);
	Check_Status(eTICNTB);
	
	uTemp = Inp32(rSYS_TFCNTB);
	uTemp = (uTemp & ~(0xffffffff)) |(uTFCNTB);
	Outp32(rSYS_TFCNTB,uTemp);
	Check_Status(eTFCNTB);

	uTemp = Inp32(rSYS_ICNTB);
	uTemp = (uTemp & ~(0xffffffff)) |(uICNTB);
	Outp32(rSYS_ICNTB,uTemp);
	Check_Status(eICNTB);

	Int_Manual_Update();
	Check_Status(eTCON);
		
	uTICNTO = Inp32(rSYS_TICNTO);
	uICNTO = Inp32(rSYS_ICNTB);
	
	UART_Printf("TICNTO = %d\n",uTICNTO);
	UART_Printf("ICNTO = %d\n",uICNTO);
		
	uTemp = Inp32(rSYS_TCON);	//Start Timer
	uTemp = uTemp|0x9;
	Outp32(rSYS_TCON,uTemp);
	Check_Status(eTCON);

	while(1) {
		uTICNTO = Inp32(rSYS_TICNTO);
		uICNTO = Inp32(rSYS_ICNTO);
		UART_Printf("uICNTO %08x  |  uTICNTO %08x\n",uICNTO,uTICNTO);

		if (uICNTO==0) {
			Outp32(rSYS_TCON,0);
			Check_Status(eTCON);
			break;
			}
		}

	UART_Printf("TICNTO = %d\n",uTICNTO);
	UART_Printf("ICNTO = %d\n",uICNTO);
}



