/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : Sys_timer.h
*  
*	File Description : This file implements the API functons for System Timer.
*
*	Author : chansik.Jeon
*	Dept. : AP Development Team
*	Created Date : 2009/02/11
*	Version : 0.0 
* 
*	History
*	- Created(chansik.Jeon 2009/02/11)
*  
**************************************************************************************/

#include "def.h"
#include "v210_sfr.h"

#ifndef __TIMER_H__
#define __TIMER_H__

#ifdef __cplusplus
extern "C" {
#endif


#include "def.h"
#include "v210_sfr.h"


typedef enum SYS_TIMER_REG
{
	rSYS_TCFG   = SYSTIMER_BASE+0x00,
	rSYS_TCON    = SYSTIMER_BASE+0x04,
	rSYS_TICNTB  = SYSTIMER_BASE+0x08,
	rSYS_TICNTO  = SYSTIMER_BASE+0x0C,
	rSYS_TFCNTB  = SYSTIMER_BASE+0x10,
	
	rSYS_ICNTB  = SYSTIMER_BASE+0x18,
	rSYS_ICNTO  = SYSTIMER_BASE+0x1C,
	rSYS_INT_CSTAT  = SYSTIMER_BASE+0x20,
		
}eSYS_TIMER_REG;

typedef enum Stimer_Status
{
	eINTCNT	= (u32)(1),	
	eTICNTB		= (u32)(2),	
	eTFCNTB	= (u32)(3),	
	eICNTB		= (u32)(4),	
	eTCON	= (u32)(5),	
} Stimer_eStatus;

typedef enum Stimer_Int
{
	eEnInt = (u32)(0),
	eICNTEIE	= (u32)(6),	
	eTIWIE	= (u32)(7),	
	eTFWIE	= (u32)(8),	
	eIWIE	= (u32)(9),	
	eTWIE	= (u32)(10),	
} Stimer_eInt;


typedef enum Int_OnOff
{
	eDisable= (u32)(0),
	eEnable	= (u32)(1),	
} Int_eOnOff;






void SysTimer_UserSelect(void);
void SysTimer_Config(u32 uFDIV_sel, u32 uTickGen_sel, u32 uClock, u32 uDivider, u32 uPrescaler, 
	                                 u32 uTICNTB, u32 uTFCNTB, u32 uICNTB, u32 uAutoreload);
void SysTimer_Start(void);
void SysTimer_Stop(void);
void SysTimer_Reset(void);
void Int_Start(void);
void Int_Stop(void);
void Int_Manual_Update(void);
void Check_Status(Stimer_eStatus eBitPos);
void Int_Control(Stimer_eInt eBitPos, Int_eOnOff eOnOff );
u32 SysTimer_ReadCount(void);
u32 SysTimer_ChangeIntervalINT(void);
u32 SysTimer_ChangeIntervalINT_autoreload(void);






u32 SysTimer_ReadrTCMPB(u32 uNum);

void __irq Isr_SysTimer(void);





#ifdef __cplusplus
}
#endif


#endif //__TIMER_H__
