/**************************************************************************************
* 
*	Project Name : S3C6410 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6410.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : RTC_test.c
*  
*	File Description : This file implements the API functons for RTC test.
*
*	Author : DAEDOO
*	Dept. : AP Development Team
*	Created Date : 2008/03/17
*	Version : 0.1 
* 
*	History
*	- Created(DAEDOO 2008/03/17)
*  
**************************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "rtc.h"
#include "def.h"
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "intc.h"
//#include "gpio.h"
//#include "timer.h"

u32 uCntTick=false; 
u32 uAlarm=false;
u8 *aDay[8] = {" ","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"};


void __irq Isr_RTC_Tick(void)
{
	RTC_ClearPending(TimeTic);
	//RTC_ClearPending(0);
	
	uCntTick = true;
	
	INTC_ClearVectAddr();
}


//////////
// Function Name : Isr_RTC_InspectTick
// Function Description : This function is Interrupt Service Routine of RTC Tick Timer for checking CURTICKCNT
// Input : NONE
// Output : NONE
// Version : v0.1

void __irq Isr_RTC_InspectTick(void)
{
	INTC_Disable(NUM_RTC_TICK);
	RTC_ClearPending(TimeTic);
	
	uCntTick = 1;
	UART_Printf("Tick INT Occured!!\n");
	
	INTC_ClearVectAddr();
}

//////////
// Function Name : Isr_RTC_Alm
// Function Description : This function is Interrupt Service Routine of RTC Alarm
// Input : NONE
// Output : NONE
// Version : v0.1

void __irq Isr_RTC_Alm(void)
{
	INTC_Disable(NUM_RTC_ALARM);
	RTC_ClearPending(ALARM);
	
	uAlarm=true;
	UART_Printf("\nRTC Alarm Occur!!!\n");	

	INTC_ClearVectAddr();
}

void RTC_RealTimeDisplay(void)
{
	u32 i;
	RTC_Enable(true);
	RTC_TickTimeEnable(true);
	
   	while(!UART_GetKey())
	{
		if ( !(i == Inp32(rBCDSEC)))
		{		RTC_Print();
				i = Inp32(rBCDSEC);
			}
	}
	
	RTC_TickTimeEnable(false);
	RTC_Enable(false);
}


void RTC_DisplayAndClkOut(void)
{

	uCntTick = false;

	RTC_TimeInit(8,5,9,6,10,48,55);	// 9 -> 0X10	
	
	RTC_TickClkSelect(CLK_16384Hz);	
	RTC_TickCnt((0x8000>>CLK_16384Hz));

	SYSC_SetClkOut(eCLKOUT_RTC,0);    	

	INTC_SetVectAddr(NUM_RTC_TICK,Isr_RTC_Tick);
	INTC_Enable(NUM_RTC_TICK);

	RTC_Enable(true);
	RTC_TickTimeEnable(true);

   	while(!UART_GetKey())
	{
		while(!uCntTick);	// Wait Tick Interrupt
		RTC_Print();
		uCntTick = 0;
	}

	RTC_TickTimeEnable(false);
	INTC_Disable(NUM_RTC_TICK);
	RTC_Enable(false);	
	
}

void RTC_TimeTick(void)
{
	u32 uSelect;
	uCntTick = false;

	RTC_TimeInit(8,03,31,2,23,59,55);

	UART_Printf("[0]1/32768\t [1]:1/16384\t[2]1/8192\t[3]1/4096\n[4]1/2048\t [5]1/1024\t[6]1/512\t[7]1/256\n[8]1/128\t [9]1/64\t[10]1/32\t[11]1/16\n[12]1/8\t\t [13]1/4\t[14]1/2\t\t[15]1/1\n\n");
	UART_Printf("Select Tick Source Clock [0~15] : ");

	uSelect=UART_GetIntNum();

	if (uSelect == -1)
	Assert(0);
		
	UART_Printf("\n");

	RTC_TickClkSelect(uSelect);	
	RTC_TickCnt((0x8000>>uSelect));

	SYSC_SetClkOut(eCLKOUT_TICK,0);
//	SYSC_CtrlCLKOUT(eCLKOUT_TICK,0);    

	INTC_SetVectAddr(NUM_RTC_TICK,Isr_RTC_Tick);
	INTC_Enable(NUM_RTC_TICK);

	RTC_TickTimeEnable(true);
	RTC_Enable(true);

   	while(!UART_GetKey())
	{
		while(!uCntTick);	// Wait Tick Interrupt
		RTC_Print();
		uCntTick = 0;
	}


	UART_Printf("\n1st Tick Count : 0x%x\n",*(volatile u32 *)rCURTICCNT);

	RTC_TickTimeEnable(false);


	///////
	RTC_TickTimeEnable(true);
	UART_Printf("\n1st Tick Count : 0x%x\n",*(volatile u32 *)rCURTICCNT);


	RTC_TickTimeEnable(false);
	
	RTC_TickTimeEnable(true);
	UART_Printf("\n2nd Tick Count : 0x%x\n",*(volatile u32 *)rCURTICCNT);



	RTC_TickTimeEnable(false);
	Delay(1);
	RTC_TickTimeEnable(true);
	UART_Printf("\n2nd Tick Count : 0x%x\n",*(volatile u32 *)rCURTICCNT);


	RTC_TickTimeEnable(false);
	Delay(10);
	RTC_TickTimeEnable(true);
	UART_Printf("\n2nd Tick Count : 0x%x\n",*(volatile u32 *)rCURTICCNT);

	RTC_TickTimeEnable(false);
	Delay(100);
	RTC_TickTimeEnable(true);
	UART_Printf("\nlast Tick Count : 0x%x\n",*(volatile u32 *)rCURTICCNT);

	////////////


	
	RTC_Enable(false);
	INTC_Disable(NUM_RTC_TICK);
	
}

void RTC_Alarm(void)
{
	uAlarm = false;
	
	RTC_TimeInit(InitYEAR, InitMONTH, InitDATE, InitDAY, InitHOUR, InitMIN, InitSEC);
	RTC_AlarmTimeInit(AlmYear, AlmMon, AlmDate, AlmHour, AlmMin, AlmSec);
	RTC_AlarmEnable(true, true, true, true, true, true, true);
	
	INTC_SetVectAddr(NUM_RTC_ALARM,Isr_RTC_Alm);
	INTC_Enable(NUM_RTC_ALARM);

	RTC_Print();
	UART_Printf("After 5sec, Alarm Interrupt Occur\n");
	
	while(uAlarm==false);

	RTC_Print();
	UART_Printf("\nRTC alarm test OK\n");
	
	INTC_Disable(NUM_RTC_ALARM);
}
//////////
// Function Name : RTC_SetTime
// Function Description : This function set up RTC time
// Input :	uYear [99:1999	00:2000	2digit dec number]
//			uMon [01~12]
//			uDate [01~31]
//			uDay [SUN:01 MON:02 TUE:03 WED:04 THU:05 FRI:06 SAT:07]
//			uHour [00~23]
//			uMin [00~59]
//			uSec [00~59]
// Output : NONE
// Version : v0.1
//Woojin code
void RTC_SetTime(u32 uYear, u32 uMon, u32 uDate, u32 uDay, u32 uHour, u32 uMin, u32 uSec)
{

	u32 Year,Mon,Date,Day,Hour,Min,Sec;
	
    	Year =( ((uYear/10)<<4) + (uYear%10) );
    	Mon  =( ((uMon/10)<<4)+ (uMon%10));
    	Date =( ((uDate/10)<<4) + (uDate%10) );     	
    	Day	 = (uDay%10);	//SUN:1 MON:2 TUE:3 WED:4 THU:5 FRI:6 SAT:7
   	Hour =( ((uHour/10)<<4) + (uHour%10) );
    	Min  =( ((uMin/10)<<4)  + (uMin%10)  );
    	Sec  =( ((uSec/10)<<4)  + (uSec%10)  );     	
		
	Outp32(rBCDSEC  , Sec); 
	Outp32(rBCDMIN  , Min); 
	Outp32(rBCDHOUR , Hour);
	Outp32(rBCDDATE , Date);
	Outp32(rBCDDAY  , Day); 
	Outp32(rBCDMON  ,Mon); 
	Outp32(rBCDYEAR , Year);
	
}

void RTC_SetTimer(void)
{

	u32 year,month,date,hour,min,sec,weekday;

   	//rRTCCON  = rRTCCON  | 0x1;		//RTC Control enable
   	UART_Printf("\nYear(00~999):");
	year = UART_GetIntNum();
	
	UART_Printf("\nMonth(1~12):");
	month = UART_GetIntNum();
		
	UART_Printf("\nDate(1~31):");
	date = UART_GetIntNum();
	
	UART_Printf("\nweekday(1~7):");
	weekday = UART_GetIntNum();

	UART_Printf("\nHour(0~23):");
	hour = UART_GetIntNum();

	UART_Printf("\nMin(0~59):");
	min = UART_GetIntNum();

	UART_Printf("\nSec(0~59):");
	sec = UART_GetIntNum();
	UART_Printf("\n");



	RTC_TimeInit(year,month,date,weekday,hour,min,sec);

}

const testFuncMenu g_aRTCTestFunc[] =
{
	RTC_RealTimeDisplay,		"RTC Display		",
	RTC_DisplayAndClkOut,	"RTC Time Display and Clock Out		",
	RTC_TimeTick,			"RTC Time Tick Int Test        ",	
	RTC_Alarm,				"RTC Alarm Test	",
	RTC_SetTimer,			"RTC Set Time	",
//	RTC_inspect_tick,			"RTC Tick Count check",
	0,0
};



void RTC_Test(void)
{
	u32 uCountFunc=0;
	s32 iSel=0;

	while(1)
	{
	UART_Printf("\n\n================== RTC Function Test =====================\n\n");
	
		for (uCountFunc=0; (u32)(g_aRTCTestFunc[uCountFunc].desc)!=0; uCountFunc++)
			UART_Printf("%2d: %s\n", uCountFunc, g_aRTCTestFunc[uCountFunc].desc);

		UART_Printf("\nSelect the function to test : ");
		iSel =UART_GetIntNum();
		UART_Printf("\n");
		if(iSel == -1) 
			break;

		if (iSel>=0 && iSel<(sizeof(g_aRTCTestFunc)/8-1))
			(g_aRTCTestFunc[iSel].func) ();
	}
}	

//////////
// Function Name : RTC_SetCon
// Function Description : This function set up RTC
// Input :	uEnTic [0:Disable		1:Enable	]
//			uTicsel [0:2^15hz   ~   15:2^0hz]
//			uRstCLK [0:No Reset	1:Reset]
//			uSelCNT [0:Merge BCD counter	1:Reserved]
//			uSelCLK [0:XTAL divided clock	1:Reserved]
//			uEnRTC [0:Disable		1:Enbalde]
// Output : NONE
// Version : v0.1
void RTC_SetCON(u32 uEnTic,u32 uTicsel,u32 uRstCLK,u32 uSelCNT,u32 uSelCLK,u32 uEnRTC )			//need modify at 6400
{
	u32 uTemp;

	uTemp = (uEnTic<<8) | (uTicsel<<4) |(uRstCLK<<3)|(uSelCNT<<2)|(uSelCLK<<1)|(uEnRTC<<0);
	Outp32(rRTCCON,uTemp);

}


u8 RTC_initialize_autotest(void)
{
 u32 sec, min;

    int old_sec = 0x50, i=0;

    

    int seccount=0;

    int errorcount=0;

    

    RTC_SetCON(0,0,0,0,0,1);

    RTC_SetTime(8,12,31,3,23,59,50);

    

    while (1)

    {   

        sec  = (Inp32(rBCDSEC) & 0x7F);

                    

        if(sec==old_sec)

        {

            if(i++ == 2000000)

            {       

                i = 0;

                UART_Printf("[]");

            }

        }

        

        else

        {

            if( sec ==  old_sec+1)

            {

                if((sec & 0xF)<10 ||((sec>>4) & 0xF)<6)

                {

                    if(i++ == 2000000)

                    {

                        i = 0;

                        UART_Printf("[2]");                  

                    }                       

                    

                    //2 log at every 10min

                    min = Inp32(rBCDMIN);

                    if( (min&0xF) == 0 && (sec==0x0))

                    {

                        AUTO_msginfo_printf("1111%2x:%2x:%2x  %10s,  %2x.%2x.20%02x",

                                            Inp32(rBCDHOUR),Inp32(rBCDMIN),Inp32(rBCDSEC),aDay[Inp32(rBCDDAY)],

                                            Inp32(rBCDMON),Inp32(rBCDDATE),Inp32(rBCDYEAR));

                    }

            

                }

            else

            {

                AUTO_errinfo_printf("i:%d sec : 0x%2x  -- old_sec : 0x%2x", i, sec, old_sec); 

                errorcount++;

            }

                

            seccount++;

            if(seccount == 5) break;

            

            }

            

            else

            {

                if((old_sec == 0x9 && sec == 0x10) ||(old_sec == 0x19 && sec == 0x20) ||(old_sec == 0x29 && sec == 0x30) ||

                   (old_sec == 0x39 && sec == 0x40) ||(old_sec == 0x49 && sec == 0x50) ||(old_sec == 0x59 && sec == 0x0))

                {

                    if(i++ == 2000000)

                    {

                        i = 0;

                        UART_Printf("[3]");                  

                    }  

                }

                else

                {

                    AUTO_errinfo_printf("i:%d sec : 0x%2x  -- old_sec : 0x%2x", i, sec, old_sec); 

                    errorcount++;

                }               

            }

        }

        old_sec = sec;

        

    }   

    

    if(errorcount==0) return true;

    else return false;


}

u8 RTC_TimeTick_autotest(void)
{
	u32 uSelect;
	u32	uReturn=0;
	u8 i;
	u32 sec;

	uCntTick = false;



	RTC_TimeInit(8,03,31,2,00,00,00);

//	UART_Printf("[0]1/32768\t [1]:1/16384\t[2]1/8192\t[3]1/4096\n[4]1/2048\t [5]1/1024\t[6]1/512\t[7]1/256\n[8]1/128\t [9]1/64\t[10]1/32\t[11]1/16\n[12]1/8\t\t [13]1/4\t[14]1/2\t\t[15]1/1\n\n");
//	UART_Printf("Select Tick Source Clock [0~15] : ");

    for(i=0;i<10;i++)
    	{
	uSelect=i;

	if (uSelect == -1)
	Assert(0);
		
	UART_Printf("\n");

	RTC_TickClkSelect(uSelect);	
	RTC_TickCnt((0x8000>>uSelect));

	SYSC_SetClkOut(eCLKOUT_TICK,0);

	INTC_SetVectAddr(NUM_RTC_TICK,Isr_RTC_Tick);
	INTC_Enable(NUM_RTC_TICK);

	RTC_TickTimeEnable(true);
	RTC_Enable(true);

	while(!uCntTick);	// Wait Tick Interrupt
//	RTC_Print();
	uCntTick = false;
	sec  = (Inp32(rBCDSEC) & 0x7F);
//	UART_Printf("RTC Tic Count :: %d \n", sec);
//	if(sec == i+1)
	uReturn +=1;
//	UART_Printf("uReturn :: %d \n", uReturn);
	}
	////////////
			
	RTC_SetCON(0,uSelect,0,0,0,0);	// Tick Time Interrupt Disable	
	INTC_Disable(NUM_RTC_TICK);

	if(uReturn ==10)return true;
	else return false;
}







