
/**************************************************************************************
* 
*	Project Name : S3C6410 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6410.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : rtc.c
*  
*	File Description : This file implements the API functons for RTC(Real Time Clock)
*
*	Author : DAEDOO
*	Dept. : AP Development Team
*	Created Date : 2008/03/17
*	Version : 0.1 
* 
*	History"
*	- Created(DAEDOO, 2008/03/17)
*  
**************************************************************************************/

#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "rtc.h"
#include "gpio.h"
#include "intc.h"
//#include "timer.h"


char *Day[8] = {" ","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"};


//extern u32 uCntTick; 
//extern u32 uCntAlarm;
/*
void __irq Isr_RTC_Tick(void)
{
	RTC_ClearPending(TimeTic);
	//RTC_ClearPending(0);
	
	uCntTick = true;
	
	INTC_ClearVectAddr();
}



//////////
// Function Name : Isr_RTC_InspectTick
// Function Description : This function is Interrupt Service Routine of RTC Tick Timer for checking CURTICKCNT
// Input : NONE
// Output : NONE
// Version : v0.1

void __irq Isr_RTC_InspectTick(void)
{
	INTC_Disable(NUM_RTC_TIC);
	RTC_ClearPending(TimeTic);
	
	uCntTick = 1;
	UART_Printf("Tick INT Occured!!\n");
	
	INTC_ClearVectAddr();
}

//////////
// Function Name : Isr_RTC_Alm
// Function Description : This function is Interrupt Service Routine of RTC Alarm
// Input : NONE
// Output : NONE
// Version : v0.1

void __irq Isr_RTC_Alm(void)
{
	INTC_Disable(NUM_RTC_ALARM);
	RTC_ClearPending(ALARM);
	
	uCntAlarm=1;
	UART_Printf(" RTC alarm test OK\n");

	INTC_ClearVectAddr();
}
*/

void RTC_ClearPending(u32 uPending)
{
	u32 uTemp;
	//uTemp = uTemp & ~(0x3) |(1<<uPending);	// uSelectP = 0 :Time TIC,		1: ALARM
	uTemp = uTemp & ~(0x3) |(uPending);	// uSelectP = 0 :Time TIC,		1: ALARM
	Outp32(rINTP,uTemp);

}


void RTC_TimeInit(u32 uYear, u32 uMon, u32 uDate, u32 uDay, u32 uHour, u32 uMin, u32 uSec)
{
	u32 Year,Mon,Date,Day,Hour,Min,Sec;

	Year =(((uYear/100)<<8) +(((uYear/10)%10)<<4) + (uYear%10) );
	UART_Printf("((uYear/100)) : %d, ((uYear/10)): %d, (uYear%10): %d \n", ((uYear/100)),((uYear/10)%10), (uYear%10));
	Mon  =(((uMon/10)<<4)+ (uMon%10));
	Date =(((uDate/10)<<4) + (uDate%10) );     	
	Day	 = (uDay%10);	//SUN:1 MON:2 TUE:3 WED:4 THU:5 FRI:6 SAT:7
	Hour =(((uHour/10)<<4) + (uHour%10) );
	Min  =(((uMin/10)<<4)  + (uMin%10)  );
	Sec  =(((uSec/10)<<4)  + (uSec%10)  );     	

	RTC_Enable(true);		

	Outp32(rBCDSEC  ,Sec); 
	Outp32(rBCDMIN  ,Min); 
	Outp32(rBCDHOUR ,Hour);
	Outp32(rBCDDATE ,Date);
	Outp32(rBCDDAY  ,Day); 
	Outp32(rBCDMON  ,Mon); 
	Outp32(rBCDYEAR ,Year);

	RTC_Enable(false);	

}

void RTC_Enable(u8 bData)
{
	u32 uRead;

	uRead = Inp32(rRTCCON);
	Outp32(rRTCCON, uRead&~(1<<0)|(bData));
}

void RTC_TickTimeEnable(u8 bData)
{
	u32 uRead;

	uRead = Inp32(rRTCCON);
	Outp32(rRTCCON, uRead&~(1<<8)|(bData<<8));
}


#if 0
void RTC_TickClkSelect(u ticktimer_clk)
{
	u32 uTickClkSel;

	switch (ticktimer_clk)
	{
		case	CLK_32768Hz:
				uTickClkSel = TICKCLKSEL_32768Hz;
				break;
		case	CLK_16384Hz:				
				uTickClkSel = TICKCLKSEL_32768Hz;
				break;
		case	CLK_16384Hz:
				uTickClkSel = TICKCLKSEL_16384Hz;
				break;
		case	CLK_8192Hz:
				uTickClkSel = TICKCLKSEL_8192Hz;
				break;
		case	CLK_4096Hz:
				uTickClkSel = TICKCLKSEL_4096Hz; 
				break;
		case	CLK_2048Hz:
				uTickClkSel = TICKCLKSEL_2048Hz; 
				break;
		case	CLK_1024Hz:
				uTickClkSel = TICKCLKSEL_1024Hz; 
				break;
		case	CLK_512Hz:
				uTickClkSel = TICKCLKSEL_512Hz;  
				break;
		case	CLK_256Hz:
				uTickClkSel = TICKCLKSEL_256Hz;  
				break;
		case	CLK_128Hz:
				uTickClkSel = TICKCLKSEL_128Hz;  
				break;
		case	CLK_64Hz:
				uTickClkSel = TICKCLKSEL_64Hz;  
				break;
		case	CLK_32Hz:
				uTickClkSel = TICKCLKSEL_32Hz;  
				break;
		case	CLK_16Hz:
				uTickClkSel = TICKCLKSEL_16Hz;   
				break;
		case	CLK_8Hz:
				uTickClkSel = TICKCLKSEL_8Hz;    
				break;				
		case	CLK_4Hz:
				uTickClkSel = TICKCLKSEL_4Hz;    
				break;				
		case	CLK_2Hz:
				uTickClkSel = TICKCLKSEL_2Hz;    
				break;				
		case	CLK_1Hz:
				uTickClkSel = TICKCLKSEL_1Hz;    
				break;
	}

	Outp32(rWTCON, PREVAL(uPreVal) | div_clk);
	//Outp32(rWTDAT, uWdtDat);
	//Outp32(rWTCNT, uWdtDat);
}
#else

void RTC_TickClkSelect(TickTimerClk TICKCLKSEL)
{
	Outp32(rRTCCON, (TICKCLKSEL<<4));
 }

#endif

void RTC_ClkReset(u8 bData)
{
	u32 uRead;

	RTC_Enable(true);
	uRead = Inp32(rRTCCON);
	Outp32(rRTCCON, uRead&~(1<<3)|(bData<<3));
	RTC_Enable(false);
}

void RTC_ClkSelect(u8 bClk)
{
	u32 uRead;

	RTC_Enable(true);		
	uRead = Inp32(rRTCCON);
	Outp32(rRTCCON, uRead&~(1<<2)|(bClk<<2));
	RTC_Enable(false);		
}

void RTC_TickCnt(u32 uTickCnt)
{
	Outp32(rTICCNT, uTickCnt);
}

void RTC_AlarmTimeInit(u32 uYear, u32 uMon, u32 uDate, u32 uHour, u32 uMin, u32 uSec)
{
	u32 Year, Mon, Date, Hour, Min, Sec;
	
    	Year =(((uYear/100)<<8)+(((uYear/10)%10)<<4) + (uYear%10));
    	Mon  =(((uMon/10)<<4)+ (uMon%10));
    	Date =(((uDate/10)<<4) + (uDate%10));     	
   		Hour =(((uHour/10)<<4) + (uHour%10));
    	Min  =(((uMin/10)<<4)  + (uMin%10));
    	Sec  =(((uSec/10)<<4)  + (uSec%10));     	

	RTC_Enable(true);		
		
	Outp32(rALMSEC  , Sec); 
	Outp32(rALMMIN  , Min); 
	Outp32(rALMHOUR , Hour);
	Outp32(rALMDATE , Date);
	Outp32(rALMMON  ,Mon); 
	Outp32(rALMYEAR , Year);

	RTC_Enable(false);
	
}

void RTC_AlarmEnable(u8 bAll, u8 bYear, u8 bMon, u8 bDate, u8 bHour, u8 bMin, u8 bSec)
{
	u32 uRead;

	uRead = Inp32(rRTCALM);
	Outp32(rRTCALM , uRead & ~(0x7f)|(bAll<<6)|(bYear<<5)|(bMon<<4)|(bDate<<3)|(bHour<<2)|(bMin<<1)|(bSec<<0));
}

void RTC_Print(void)
{
	u32 uYear,uMonth,uDate,uDay,uHour,uMin,uSec;

	// Check RTC Enable 
	RTC_Enable(true);

	uYear =  Inp32(rBCDYEAR);
	uYear = 0x2000 + uYear;
	uMonth= Inp32(rBCDMON);
	uDate = Inp32(rBCDDATE);
	uHour = Inp32(rBCDHOUR);
	uMin  = Inp32(rBCDMIN);
	uSec  = Inp32(rBCDSEC);
	uDay= Inp32(rBCDDAY);

	RTC_Enable(false);

	UART_Printf("%2x : %2x : %2x  %10s,  %2x/%2x/%4x\n", uHour, uMin, uSec, Day[uDay], uMonth, uDate, uYear);

}

void RTC_StartTickTime(u32 uClkSel, u32 uTickCnt)
{
	RTC_TickTimeEnable(FALSE);
	RTC_ClkReset(1);
	RTC_ClkReset(0);
	RTC_TickClkSelect(uClkSel);
	RTC_TickCnt(uTickCnt);
	RTC_TickTimeEnable(TRUE);
}

