/**************************************************************************************
* 
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : gpio.c
*  
*	File Description : This file declares prototypes of GPIO API funcions.
*
*	Author : chansik.Jeon
*	Dept. : AP Development Team
*	Created Date : 2009/02/07
*	Version : 0.1 
* 
*	History
*	- Created(chansik.Jeon 2009/02/07)

*  
**************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "intc.h"
#include "gpio.h"

#define GPIO 		( ( volatile oGPIO_REGS * ) (GPIO_pBase) )


typedef struct tag_GPIO_REGS
{
	u32 rGPIOA0CON;			//0xE0200000
	u32 rGPIOA0DAT;
	u32 rGPIOA0PUD;
	u32 rGPIOA0DRV_SR;
	u32 rGPIOA0CONPDN;
	u32 rGPIOA0PUDPDN;
	u32 reservedA0[2];

	u32 rGPIOA1CON;			//0xE0200020
	u32 rGPIOA1DAT;
	u32 rGPIOA1PUD;
	u32 rGPIOA1DRV_SR;
	u32 rGPIOA1CONPDN;
	u32 rGPIOA1PUDPDN;
	u32 reservedA1[2];
	
	u32 rGPIOBCON;			//0xE0200040
	u32 rGPIOBDAT;
	u32 rGPIOBPUD;
	u32 rGPIOBDRV_SR;
	u32 rGPIOBCONPDN;
	u32 rGPIOBPUDPDN;	
	u32 reservedB[2];

	u32 rGPIOC0CON;			//0xE0200060
	u32 rGPIOC0DAT;
	u32 rGPIOC0PUD;
	u32 rGPIOC0DRV_SR;
	u32 rGPIOC0CONPDN;
	u32 rGPIOC0PUDPDN;
	u32 reservedC0[2];

	u32 rGPIOC1CON;			//0xE0200080
	u32 rGPIOC1DAT;
	u32 rGPIOC1PUD;
	u32 rGPIOC1DRV_SR;
	u32 rGPIOC1CONPDN;
	u32 rGPIOC1PUDPDN;
	u32 reservedC1[2];

	u32 rGPIOD0CON;			//0xE02000A0
	u32 rGPIOD0DAT;
	u32 rGPIOD0PUD;
	u32 rGPIOD0DRV_SR;
	u32 rGPIOD0CONPDN;
	u32 rGPIOD0PUDPDN;
	u32 reservedD0[2];

	u32 rGPIOD1CON;			//0xE02000C0
	u32 rGPIOD1DAT;
	u32 rGPIOD1PUD;
	u32 rGPIOD1DRV_SR;
	u32 rGPIOD1CONPDN;
	u32 rGPIOD1PUDPDN;
	u32 reservedD1[2];

	u32 rGPIOE0CON;			//0xE02000E0
	u32 rGPIOE0DAT;
	u32 rGPIOE0PUD;
	u32 rGPIOE0DRV_SR;
	u32 rGPIOE0CONPDN;
	u32 rGPIOE0PUDPDN;
	u32 reservedE0[2];

	u32 rGPIOE1CON;			//0xE0200100
	u32 rGPIOE1DAT;
	u32 rGPIOE1PUD;
	u32 rGPIOE1DRV_SR;
	u32 rGPIOE1CONPDN;
	u32 rGPIOE1PUDPDN;
	u32 reservedE1[2];

	u32 rGPIOF0CON;			//0xE0200120
	u32 rGPIOF0DAT;
	u32 rGPIOF0PUD;
	u32 rGPIOF0DRV_SR;
	u32 rGPIOF0CONPDN;
	u32 rGPIOF0PUDPDN;
	u32 reservedF0[2];

	u32 rGPIOF1CON;			//0xE0200140
	u32 rGPIOF1DAT;
	u32 rGPIOF1PUD;
	u32 rGPIOF1DRV_SR;
	u32 rGPIOF1CONPDN;
	u32 rGPIOF1PUDPDN;
	u32 reservedF1[2];

	u32 rGPIOF2CON;			//0xE0200160
	u32 rGPIOF2DAT;
	u32 rGPIOF2PUD;
	u32 rGPIOF2DRV_SR;
	u32 rGPIOF2CONPDN;
	u32 rGPIOF2PUDPDN;
	u32 reservedF2[2];

	u32 rGPIOF3CON;			//0xE0200180
	u32 rGPIOF3DAT;
	u32 rGPIOF3PUD;
	u32 rGPIOF3DRV_SR;
	u32 rGPIOF3CONPDN;
	u32 rGPIOF3PUDPDN;
	u32 reservedF3[2];

	u32 rGPIOG0CON;			//0xE02001A0
	u32 rGPIOG0DAT;
	u32 rGPIOG0PUD;
	u32 rGPIOG0DRV_SR;
	u32 rGPIOG0CONPDN;
	u32 rGPIOG0PUDPDN;
	u32 reservedG0[2];

	u32 rGPIOG1CON;			//0xE02001C0
	u32 rGPIOG1DAT;
	u32 rGPIOG1PUD;
	u32 rGPIOG1DRV_SR;
	u32 rGPIOG1CONPDN;
	u32 rGPIOG1PUDPDN;
	u32 reservedG1[2];

	u32 rGPIOG2CON;			//0xE02001E0
	u32 rGPIOG2DAT;
	u32 rGPIOG2PUD;
	u32 rGPIOG2DRV_SR;
	u32 rGPIOG2CONPDN;
	u32 rGPIOG2PUDPDN;
	u32 reservedG2[2];

	u32 rGPIOG3CON;			//0xE0200200
	u32 rGPIOG3DAT;
	u32 rGPIOG3PUD;
	u32 rGPIOG3DRV_SR;
	u32 rGPIOG3CONPDN;
	u32 rGPIOG3PUDPDN;
	u32 reservedG3[2];
	
	u32 rGPIOICON;			//0xE0200220
	u32 rGPIOIDAT;
	u32 rGPIOIPUD;
	u32 rGPIOIDRV_SR;
	u32 rGPIOICONPDN;
	u32 rGPIOIPUDPDN;
	u32 reservedI[2];

	u32 rGPIOJ0CON;			//0xE0200240
	u32 rGPIOJ0DAT;
	u32 rGPIOJ0PUD;
	u32 rGPIOJ0DRV_SR;
	u32 rGPIOJ0CONPDN;
	u32 rGPIOJ0PUDPDN;
	u32 reservedJ0[2];

	u32 rGPIOJ1CON;			//0xE0200260
	u32 rGPIOJ1DAT;
	u32 rGPIOJ1PUD;
	u32 rGPIOJ1DRV_SR;
	u32 rGPIOJ1CONPDN;
	u32 rGPIOJ1PUDPDN;
	u32 reservedJ1[2];

	u32 rGPIOJ2CON;			//0xE0200280
	u32 rGPIOJ2DAT;
	u32 rGPIOJ2PUD;
	u32 rGPIOJ2DRV_SR;
	u32 rGPIOJ2CONPDN;
	u32 rGPIOJ2PUDPDN;
	u32 reservedJ2[2];

	u32 rGPIOJ3CON;			//0xE02002A0
	u32 rGPIOJ3DAT;
	u32 rGPIOJ3PUD;
	u32 rGPIOJ3DRV_SR;
	u32 rGPIOJ3CONPDN;
	u32 rGPIOJ3PUDPDN;
	u32 reservedJ3[2];

	u32 rGPIOJ4CON;			//0xE02002C0
	u32 rGPIOJ4DAT;
	u32 rGPIOJ4PUD;
	u32 rGPIOJ4DRV_SR;
	u32 rGPIOJ4CONPDN;
	u32 rGPIOJ4PUDPDN;
	u32 reservedJ4[2];

		
       u32 rGPIOMP0_1CON;			//0xE02002E0
	u32 rGPIOMP0_1DAT;
	u32 rGPIOMP0_1PUD;
	u32 rGPIOMP0_1DRV_SR;
	u32 rGPIOMP0_1CONPDN;
	u32 rGPIOMP0_1PUDPDN;
	u32 reservedMP0_1[2];

	u32 rGPIOMP0_2CON;			//0xE0200300
	u32 rGPIOMP0_2DAT;
	u32 rGPIOMP0_2PUD;
	u32 rGPIOMP0_2DRV_SR;
	u32 rGPIOMP0_2CONPDN;
	u32 rGPIOMP0_2PUDPDN;
	u32 reservedMP0_2[2];

	u32 rGPIOMP0_3CON;			//0xE0200320
	u32 rGPIOMP0_3DAT;
	u32 rGPIOMP0_3PUD;
	u32 rGPIOMP0_3DRV_SR;
	u32 rGPIOMP0_3CONPDN;
	u32 rGPIOMP0_3PUDPDN;
	u32 reservedMP0_3[2];

	u32 rGPIOMP0_4CON;			//0xE0200340
	u32 rGPIOMP0_4DAT;
	u32 rGPIOMP0_4PUD;
	u32 rGPIOMP0_4DRV_SR;
	u32 rGPIOMP0_4CONPDN;
	u32 rGPIOMP0_4PUDPDN;
	u32 reservedMP0_4[2];

	u32 rGPIOMP0_5CON;			//0xE0200360
	u32 rGPIOMP0_5DAT;
	u32 rGPIOMP0_5PUD;
	u32 rGPIOMP0_5DRV_SR;
	u32 rGPIOMP0_5CONPDN;
	u32 rGPIOMP0_5PUDPDN;
	u32 reservedMP0_5[2];

	u32 rGPIOMP0_6CON;			//0xE0200380
	u32 rGPIOMP0_6DAT;
	u32 rGPIOMP0_6PUD;
	u32 rGPIOMP0_6DRV_SR;
	u32 rGPIOMP0_6CONPDN;
	u32 rGPIOMP0_6PUDPDN;
	u32 reservedMP0_6[2];

	u32 rGPIOMP0_7CON;			//0xE02003A0
	u32 rGPIOMP0_7DAT;
	u32 rGPIOMP0_7PUD;
	u32 rGPIOMP0_7DRV_SR;
	u32 rGPIOMP0_7CONPDN;
	u32 rGPIOMP0_7PUDPDN;
	u32 reservedMP0_7[2];

	u32 rGPIOMP1_0CON;			//0xE02003C0
	u32 rGPIOMP1_0DAT;
	u32 rGPIOMP1_0PUD;
	u32 rGPIOMP1_0DRV_SR;
	u32 rGPIOMP1_0CONPDN;
	u32 rGPIOMP1_0PUDPDN;
	u32 reservedMP1_0[2];

	u32 rGPIOMP1_1CON;			//0xE02003E0
	u32 rGPIOMP1_1DAT;
	u32 rGPIOMP1_1PUD;
	u32 rGPIOMP1_1DRV_SR;
	u32 rGPIOMP1_1CONPDN;
	u32 rGPIOMP1_1PUDPDN;
	u32 reservedMP1_1[2];

	u32 rGPIOMP1_2CON;			//0xE0200400
	u32 rGPIOMP1_2DAT;
	u32 rGPIOMP1_2PUD;
	u32 rGPIOMP1_2DRV_SR;
	u32 rGPIOMP1_2CONPDN;
	u32 rGPIOMP1_2PUDPDN;
	u32 reservedMP1_2[2];

	u32 rGPIOMP1_3CON;			//0xE0200420
	u32 rGPIOMP1_3DAT;
	u32 rGPIOMP1_3PUD;
	u32 rGPIOMP1_3DRV_SR;
	u32 rGPIOMP1_3CONPDN;
	u32 rGPIOMP1_3PUDPDN;
	u32 reservedMP1_3[2];

	u32 rGPIOMP1_4CON;			//0xE0200440
	u32 rGPIOMP1_4DAT;
	u32 rGPIOMP1_4PUD;
	u32 rGPIOMP1_4DRV_SR;
	u32 rGPIOMP1_4CONPDN;
	u32 rGPIOMP1_4PUDPDN;
	u32 reservedMP1_4[2];

	u32 rGPIOMP1_5CON;			//0xE0200460
	u32 rGPIOMP1_5DAT;
	u32 rGPIOMP1_5PUD;
	u32 rGPIOMP1_5DRV_SR;
	u32 rGPIOMP1_5CONPDN;
	u32 rGPIOMP1_5PUDPDN;
	u32 reservedMP1_5[2];

	u32 rGPIOMP1_6CON;			//0xE0200480
	u32 rGPIOMP1_6DAT;
	u32 rGPIOMP1_6PUD;
	u32 rGPIOMP1_6DRV_SR;
	u32 rGPIOMP1_6CONPDN;
	u32 rGPIOMP1_6PUDPDN;
	u32 reservedMP1_6[2];

	u32 rGPIOMP1_7CON;			//0xE02004A0
	u32 rGPIOMP1_7DAT;
	u32 rGPIOMP1_7PUD;
	u32 rGPIOMP1_7DRV_SR;
	u32 rGPIOMP1_7CONPDN;
	u32 rGPIOMP1_7PUDPDN;
	u32 reservedMP1_7[2];

	u32 rGPIOMP1_8CON;			//0xE02004C0
	u32 rGPIOMP1_8DAT;
	u32 rGPIOMP1_8PUD;
	u32 rGPIOMP1_8DRV_SR;
	u32 rGPIOMP1_8CONPDN;
	u32 rGPIOMP1_8PUDPDN;
	u32 reservedMP1_8[2];

	u32 rGPIOMP2_0CON;			//0xE02004E0
	u32 rGPIOMP2_0DAT;
	u32 rGPIOMP2_0PUD;
	u32 rGPIOMP2_0DRV_SR;
	u32 rGPIOMP2_0CONPDN;
	u32 rGPIOMP2_0PUDPDN;
	u32 reservedMP2_0[2];

	u32 rGPIOMP2_1CON;			//0xE0200500
	u32 rGPIOMP2_1DAT;
	u32 rGPIOMP2_1PUD;
	u32 rGPIOMP2_1DRV_SR;
	u32 rGPIOMP2_1CONPDN;
	u32 rGPIOMP2_1PUDPDN;
	u32 reservedMP2_1[2];

	u32 rGPIOMP2_2CON;			//0xE0200520
	u32 rGPIOMP2_2DAT;
	u32 rGPIOMP2_2PUD;
	u32 rGPIOMP2_2DRV_SR;
	u32 rGPIOMP2_2CONPDN;
	u32 rGPIOMP2_2PUDPDN;
	u32 reservedMP2_2[2];

	u32 rGPIOMP2_3CON;			//0xE0200540
	u32 rGPIOMP2_3DAT;
	u32 rGPIOMP2_3PUD;
	u32 rGPIOMP2_3DRV_SR;
	u32 rGPIOMP2_3CONPDN;
	u32 rGPIOMP2_3PUDPDN;
	u32 reservedMP2_3[2];

	u32 rGPIOMP2_4CON;			//0xE0200560
	u32 rGPIOMP2_4DAT;
	u32 rGPIOMP2_4PUD;
	u32 rGPIOMP2_4DRV_SR;
	u32 rGPIOMP2_4CONPDN;
	u32 rGPIOMP2_4PUDPDN;
	u32 reservedMP2_4[2];

	u32 rGPIOMP2_5CON;			//0xE0200580
	u32 rGPIOMP2_5DAT;
	u32 rGPIOMP2_5PUD;
	u32 rGPIOMP2_5DRV_SR;
	u32 rGPIOMP2_5CONPDN;
	u32 rGPIOMP2_5PUDPDN;
	u32 reservedMP2_5[2];

	u32 rGPIOMP2_6CON;			//0xE02005A0
	u32 rGPIOMP2_6DAT;
	u32 rGPIOMP2_6PUD;
	u32 rGPIOMP2_6DRV_SR;
	u32 rGPIOMP2_6CONPDN;
	u32 rGPIOMP2_6PUDPDN;
	u32 reservedMP2_6[2];

	u32 rGPIOMP2_7CON;			//0xE02005C0
	u32 rGPIOMP2_7DAT;
	u32 rGPIOMP2_7PUD;
	u32 rGPIOMP2_7DRV_SR;
	u32 rGPIOMP2_7CONPDN;
	u32 rGPIOMP2_7PUDPDN;
	u32 reservedMP2_7[2];

	u32 rGPIOMP2_8CON;			//0xE02005E0
	u32 rGPIOMP2_8DAT;
	u32 rGPIOMP2_8PUD;
	u32 rGPIOMP2_8DRV_SR;
	u32 rGPIOMP2_8CONPDN;
	u32 rGPIOMP2_8PUDPDN;
	u32 reservedMP2_8[2];
	
	u32 reservedETC0_1[2];
	u32 rGPIOETC0PUD;			//0xE0200608
	u32 rGPIOETC0DRV_SR;
	u32 reservedETC0_2[4];

	u32 reservedETC1_1[2];
	u32 rGPIOETC1PUD;			//0xE0200628
	u32 rGPIOETC1DRV_SR;
	u32 reservedETC1_2[4];

	u32 reservedETC2_1[2];
	u32 rGPIOETC2PUD;			//0xE0200648
	u32 rGPIOETC2DRV_SR;
	u32 reservedETC2_2[4];

	u32 reservedETC3_1[2];
	u32 rGPIOETC3PUD;			//0xE0200668
	u32 rGPIOETC3DRV_SR;
	u32 reservedETC3_2[4];

	u32 reserved1[32];

	u32 rEINT1CON;				//0xE0200700
	u32 rEINT2CON;	
	u32 rEINT3CON;	
	u32 rEINT4CON;	
	u32 rEINT5CON;	
	u32 rEINT6CON;	
	u32 rEINT7CON;	
	u32 rEINT8CON;	
	u32 rEINT9CON;	
	u32 rEINT10CON;	
	u32 rEINT11CON;	
	u32 rEINT12CON;	
	u32 rEINT13CON;	
	u32 rEINT14CON;	
	u32 rEINT15CON;	
	u32 rEINT16CON;	
	u32 rEINT17CON;	
	u32 rEINT18CON;	
	u32 rEINT19CON;	
	u32 rEINT20CON;	
	u32 rEINT21CON;	
	u32 rEINT22CON;	
	u32 rEINT23CON;	

	u32 reserved2[41];

	u32 rEINT1FLTCON0;			//0xE0200800
	u32 rEINT1FLTCON1;
	u32 rEINT2FLTCON0;
	u32 rEINT2FLTCON1;
	u32 rEINT3FLTCON0;
	u32 rEINT3FLTCON1;
	u32 rEINT4FLTCON0;
	u32 rEINT4FLTCON1;
	u32 rEINT5FLTCON0;
	u32 rEINT5FLTCON1;
	u32 rEINT6FLTCON0;
	u32 rEINT6FLTCON1;
	u32 rEINT7FLTCON0;
	u32 rEINT7FLTCON1;
	u32 rEINT8FLTCON0;
	u32 rEINT8FLTCON1;
	u32 rEINT9FLTCON0;
	u32 rEINT9FLTCON1;
	u32 rEINT10FLTCON0;
	u32 rEINT10FLTCON1;
	u32 rEINT11FLTCON0;
	u32 rEINT11FLTCON1;
	u32 rEINT12FLTCON0;
	u32 rEINT12FLTCON1;
	u32 rEINT13FLTCON0;
	u32 rEINT13FLTCON1;
	u32 rEINT14FLTCON0;
	u32 rEINT14FLTCON1;
	u32 rEINT15FLTCON0;
	u32 rEINT15FLTCON1;
	u32 rEINT16FLTCON0;
	u32 rEINT16FLTCON1;
	u32 rEINT17FLTCON0;
	u32 rEINT17FLTCON1;
	u32 rEINT18FLTCON0;
	u32 rEINT18FLTCON1;
	u32 rEINT19FLTCON0;
	u32 rEINT19FLTCON1;
	u32 rEINT20FLTCON0;
	u32 rEINT20FLTCON1;
	u32 rEINT21FLTCON0;
	u32 rEINT21FLTCON1;
	u32 rEINT22FLTCON0;
	u32 rEINT22FLTCON1;
	u32 rEINT23FLTCON0;
	u32 rEINT23FLTCON1;

	u32 reserved3[18];

	u32 rEINT1MASK;			//0xE0200900
	u32 rEINT2MASK;
	u32 rEINT3MASK;
	u32 rEINT4MASK;
	u32 rEINT5MASK;
	u32 rEINT6MASK;
	u32 rEINT7MASK;
	u32 rEINT8MASK;
	u32 rEINT9MASK;
	u32 rEINT10MASK;
	u32 rEINT11MASK;
	u32 rEINT12MASK;
	u32 rEINT13MASK;
	u32 rEINT14MASK;
	u32 rEINT15MASK;
	u32 rEINT16MASK;
	u32 rEINT17MASK;
	u32 rEINT18MASK;
	u32 rEINT19MASK;
	u32 rEINT20MASK;
	u32 rEINT21MASK;
	u32 rEINT22MASK;
	u32 rEINT23MASK;

	u32 reserved4[41];

	u32 rEINT1PEND;			//0xE0200A00
	u32 rEINT2PEND;
	u32 rEINT3PEND;
	u32 rEINT4PEND;
	u32 rEINT5PEND;
	u32 rEINT6PEND;
	u32 rEINT7PEND;
	u32 rEINT8PEND;
	u32 rEINT9PEND;
	u32 rEINT10PEND;
	u32 rEINT11PEND;
	u32 rEINT12PEND;
	u32 rEINT13PEND;
	u32 rEINT14PEND;
	u32 rEINT15PEND;
	u32 rEINT16PEND;
	u32 rEINT17PEND;
	u32 rEINT18PEND;
	u32 rEINT19PEND;
	u32 rEINT20PEND;
	u32 rEINT21PEND;
	u32 rEINT22PEND;
	u32 rEINT23PEND;	

	u32 reserved5[41];

	u32 rEINTGRPPRI;			//0xE0200B00
	u32 rEINTPRIORITY;
	u32 rEINTSERVICE;
	u32 rEINTSERVICEPEND;
	u32 rEINTGRPFIXPRI;
	
	u32 rEINT1FIXPRI;			//0xE0200B14
	u32 rEINT2FIXPRI;
	u32 rEINT3FIXPRI;
	u32 rEINT4FIXPRI;
	u32 rEINT5FIXPRI;
	u32 rEINT6FIXPRI;
	u32 rEINT7FIXPRI;
	u32 rEINT8FIXPRI;
	u32 rEINT9FIXPRI;
	u32 rEINT10FIXPRI;
	u32 rEINT11FIXPRI;
	u32 rEINT12FIXPRI;
	u32 rEINT13FIXPRI;
	u32 rEINT14FIXPRI;
	u32 rEINT15FIXPRI;
	u32 rEINT16FIXPRI;
	u32 rEINT17FIXPRI;
	u32 rEINT18FIXPRI;
	u32 rEINT19FIXPRI;
	u32 rEINT20FIXPRI;
	u32 rEINT21FIXPRI;
	u32 rEINT22FIXPRI;
	u32 rEINT23FIXPRI;

	u32 reserved6[36];
	
	u32 rGPIOH0CON;			//0xE0200C00
	u32 rGPIOH0DAT;
	u32 rGPIOH0PUD;
	u32 rGPIOH0DRV_SR;
	u32 rGPIOH0CONPDN;
	u32 rGPIOH0PUDPDN;
	u32 reservedH0[2];

	u32 rGPIOH1CON;			//0xE0200C20
	u32 rGPIOH1DAT;
	u32 rGPIOH1PUD;
	u32 rGPIOH1DRV_SR;
	u32 rGPIOH1CONPDN;
	u32 rGPIOH1PUDPDN;
	u32 reservedH1[2];

	u32 rGPIOH2CON;			//0xE0200C40
	u32 rGPIOH2DAT;
	u32 rGPIOH2PUD;
	u32 rGPIOH2DRV_SR;
	u32 rGPIOH2CONPDN;
	u32 rGPIOH2PUDPDN;
	u32 reservedH2[2];

	u32 rGPIOH3CON;			//0xE0200C60
	u32 rGPIOH3DAT;
	u32 rGPIOH3PUD;
	u32 rGPIOH3DRV_SR;
	u32 rGPIOH3CONPDN;
	u32 rGPIOH3PUDPDN;
	u32 reservedH3[2];

	u32 reserved7[96];

	u32 rEINT30CON;			//0xE0200E00
	u32 rEINT31CON;
	u32 rEINT32CON;
	u32 rEINT33CON;

	u32 reserved8[28];

	u32 rEINT30FLTCON0;			//0xE0200E80
	u32 rEINT30FLTCON1;
	u32 rEINT31FLTCON0;
	u32 rEINT31FLTCON1;
	u32 rEINT32FLTCON0;
	u32 rEINT32FLTCON1;
	u32 rEINT33FLTCON0;
	u32 rEINT33FLTCON1;

	u32 reserved9[24];

	u32 rEINT30MASK;			//0xE0200F00
	u32 rEINT31MASK;
	u32 rEINT32MASK;
	u32 rEINT33MASK;

	u32 reserved10[12];

	u32 rEINT30PEND;			//0xE0200F40
	u32 rEINT31PEND;
	u32 rEINT32PEND;
	u32 rEINT33PEND;

	u32 reserved11[12];

	u32 rPDEN;					//0xE0200F80
	

} 
oGPIO_REGS;

static volatile void *GPIO_pBase;

volatile u32  g_IntCnt;



//////////
// Function Name : GPIO_Init
// Function Desctiption : This function initializes gpio sfr base address
// Input : NONE
// Output : NONE
// Version :
//
// Version : v0.1
void GPIO_Init(void)
{
	GPIO_pBase = (void *)GPIO_BASE;
}


//////////
// Function Name : GPIO_SetFunctionEach
// Function Desctiption : This function set each GPIO function
// Input : 	Id : GPIO port
//			eBitPos : GPIO bit
//			uFunction : Select the function
// Output : NONE
//
// Version : v0.0
void GPIO_SetFunctionEach(GPIO_eId Id, GPIO_eBitPos eBitPos, u32 uFunction)
{
	volatile u32 *pGPIOx_Reg0;
	volatile u32 *pGPIO_Base_Addr;
	u32 uMuxBit,  uOffset;
	u32 uConValue;

	uMuxBit = 4; // 4bit
	uOffset = Id&0xFFF;  

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_Reg0 = pGPIO_Base_Addr + uOffset/4;
	uConValue = *pGPIOx_Reg0;
	uConValue = (uConValue & ~(0xF<<(uMuxBit*eBitPos))) | (uFunction<<(uMuxBit*eBitPos));
	*pGPIOx_Reg0 = uConValue;
	
}



//////////
// Function Name : GPIO_SetFunctionAll
// Function Desctiption : This function set all GPIO function selection
// Input : 	Id : GPIO port
//			uValue0 : Write value(control register 0)
// Output : NONE
//
// Version : v0.0
void GPIO_SetFunctionAll(GPIO_eId Id, u32 uValue0)
{
	volatile u32 *pGPIOx_Reg0;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uOffset;


	uOffset = Id&0xFFF;

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_Reg0 = pGPIO_Base_Addr + uOffset/4;
	*pGPIOx_Reg0 = uValue0;

}



//////////
// Function Name : GPIO_SetDataEach
// Function Desctiption : This function set each GPIO data bit
// Input : 	Id : GPIO port
//			eBitPos : GPIO bit
//			uValue : value
// Output : NONE
//
// Version : v0.0
void GPIO_SetDataEach(GPIO_eId Id, GPIO_eBitPos eBitPos, u32 uValue)
{
	volatile u32 *pGPIOx_DataReg;
	volatile u32 *pGPIO_Base_Addr;
	u32  uOffset, uConRegNum;
	u32 uDataValue;

	uOffset = Id&0xFFF;
	uConRegNum = 1;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_DataReg = pGPIO_Base_Addr + (uOffset/4) +uConRegNum;
	uDataValue = *pGPIOx_DataReg;
	uDataValue = (uDataValue & ~(0x1<<eBitPos)) | (uValue<<eBitPos);
	*pGPIOx_DataReg = uDataValue;
}



//////////
// Function Name : GPIO_SetDataAll
// Function Desctiption : This function set all GPIO data bit
// Input : 	Id : GPIO port
//			uValue : value
// Output : NONE
//
// Version : v0.0
void GPIO_SetDataAll(GPIO_eId Id, u32 uValue)
{
	volatile u32 *pGPIOx_DataReg;
	volatile u32 *pGPIO_Base_Addr;
	u32  uOffset, uConRegNum;

	uOffset = Id&0xFFF;
	uConRegNum = 1;

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_DataReg = pGPIO_Base_Addr + (uOffset/4) +uConRegNum;
	*pGPIOx_DataReg = uValue;
}


//////////
// Function Name : GPIO_GetDataAll
// Function Desctiption : This function get all GPIO data bit
// Input : 	Id : GPIO port
//			uValue : value
// Output : 	Data register value
//
// Version : v0.0
u32 GPIO_GetDataAll(GPIO_eId Id)
{
	volatile u32 *pGPIOx_DataReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uOffset;


	uOffset = Id&0xFFF;
	uConRegNum = 1;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_DataReg = pGPIO_Base_Addr + (uOffset/4)+ uConRegNum;
	return (*pGPIOx_DataReg);
}


//////////
// Function Name : GPIO_SetPullUpDownEach
// Function Desctiption : This function set each GPIO Pull-up/Down bits
// Input : 	Id : GPIO port
//			eBitPos : GPIO bit
//			uValue : value(2bit)
// Output : NONE
//
// Version : v0.0
void GPIO_SetPullUpDownEach(GPIO_eId Id, GPIO_eBitPos eBitPos, u32 uValue)
{
	volatile u32 *pGPIOx_PullUDReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uDataRegNum,  uOffset;
	u32 uPullValue;

	
	uOffset = Id&0xFFF;
	uConRegNum = 1;
	uDataRegNum = 1;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_PullUDReg = pGPIO_Base_Addr + (uOffset/4) + uConRegNum+uDataRegNum;
	uPullValue = *pGPIOx_PullUDReg;
	uPullValue = (uPullValue & ~(0x3<<(0x02*eBitPos))) | (uValue<<(0x02*eBitPos));
	*pGPIOx_PullUDReg = uPullValue;
}



//////////
// Function Name : GPIO_SetPullUpDownAll
// Function Desctiption : This function set all GPIO Pull-up/Down bits
// Input : 	Id : GPIO port
//			uValue : value(32bit)
// Output : NONE
//
// Version : v0.0
void GPIO_SetPullUpDownAll(GPIO_eId Id, u32 uValue)
{
	volatile u32 *pGPIOx_PullUDReg;
	volatile u32 *pGPIO_Base_Addr;
	u32  uConRegNum, uDataRegNum, uOffset;

	uOffset = Id&0xFFF;
	uConRegNum = 1;
	uDataRegNum = 1;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_PullUDReg = pGPIO_Base_Addr + (uOffset/4) + uConRegNum+uDataRegNum;
	*pGPIOx_PullUDReg = uValue;
}


//////////
// Function Name : ETC_SetPullUpDownEach
// Function Desctiption : This function set each ETC Pull-up/Down bits
// Input : 	Id : ETC port
//			eBitPos : ETC bit
//			uValue : value(2bit)
// Output : NONE
//
// Version : v0.0
void ETC_SetPullUpDownEach(GPIO_eId Id, GPIO_eBitPos eBitPos, u32 uValue)
{
	volatile u32 *pETCx_PullUDReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uOffset;
	u32 uPullValue;

	
	uOffset = Id&0xFFF;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pETCx_PullUDReg = pGPIO_Base_Addr + (uOffset/4) ;
	uPullValue = *pETCx_PullUDReg;
	uPullValue = (uPullValue & ~(0x3<<(0x02*eBitPos))) | (uValue<<(0x02*eBitPos));
	*pETCx_PullUDReg = uPullValue;
}


//////////
// Function Name : ETC_SetPullUpDownAll
// Function Desctiption : This function set all ETC Pull-up/Down bits
// Input : 	Id : ETC port
//			uValue : value(16bit)
// Output : NONE
//
// Version : v0.0
void ETC_SetPullUpDownAll(GPIO_eId Id, u32 uValue)
{
	volatile u32 *pETCx_PullUDReg;
	volatile u32 *pGPIO_Base_Addr;
	u32  uOffset;

	uOffset = Id&0xFFF;
	
	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pETCx_PullUDReg = pGPIO_Base_Addr + (uOffset/4);
	*pETCx_PullUDReg = uValue;
}



//////////
// Function Name : GPIO_SetDSEach
// Function Desctiption : This function set each GPIO Driving Strength bits
// Input : 	Id : GPIO port
//			eBitPos : GPIO bit
//			uValue : value(2bit)
// Output : NONE
//
// Version : v0.0
void GPIO_SetDSEach(GPIO_eId Id, GPIO_eBitPos eBitPos, u32 uValue)
{
	volatile u32 *pGPIOx_DSReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uDataRegNum,  uPullUDRegNum, uOffset;
	u32 uDSValue;

	
	uOffset = Id&0xFFF;
	uConRegNum = 1;
	uDataRegNum = 1;
	uPullUDRegNum = 1;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_DSReg = pGPIO_Base_Addr + (uOffset/4) + uConRegNum+uDataRegNum+uPullUDRegNum;
	uDSValue = *pGPIOx_DSReg;
	uDSValue = (uDSValue & ~(0x3<<(0x02*eBitPos))) | (uValue<<(0x02*eBitPos));
	*pGPIOx_DSReg = uDSValue;
}


//////////
// Function Name : GPIO_SetDSAll
// Function Desctiption : This function set All GPIO Driving Strength bits
// Input : 	Id : GPIO port
//			uValue : value(16bit)
// Output : NONE
//
// Version : v0.0
void GPIO_SetDSAll(GPIO_eId Id, u32 uValue)
{
	volatile u32 *pGPIOx_DSReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uDataRegNum,  uPullUDRegNum, uOffset;
	u32 uDSValue;

	
	uOffset = Id&0xFFF;
	uConRegNum = 1;
	uDataRegNum = 1;
	uPullUDRegNum = 1;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_DSReg = pGPIO_Base_Addr + (uOffset/4) + uConRegNum+uDataRegNum+uPullUDRegNum;
	uDSValue = *pGPIOx_DSReg;
	uDSValue = (uDSValue & ~(0xffff)) | uValue;
	*pGPIOx_DSReg = uDSValue;
}


//////////
// Function Name : GPIO_SetSREach
// Function Desctiption : This function set each GPIO Slew Rate bits
// Input : 	Id : GPIO port
//			eBitPos : GPIO bit
//			uValue : value(2bit)
// Output : NONE
//
// Version : v0.0
void GPIO_SetSREach(GPIO_eId Id, GPIO_eBitPos eBitPos, u32 uValue)
{
	volatile u32 *pGPIOx_SRReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uDataRegNum,  uPullUDRegNum, uOffset;
	u32 uSRValue;

	
	uOffset = Id&0xFFF;
	uConRegNum = 1;
	uDataRegNum = 1;
	uPullUDRegNum = 1;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_SRReg = pGPIO_Base_Addr + (uOffset/4) + uConRegNum+uDataRegNum+uPullUDRegNum;
	uSRValue = *pGPIOx_SRReg;
	uSRValue = (uSRValue & ~(0x1<<(eBitPos+16))) | (uValue<<(eBitPos+16));
	*pGPIOx_SRReg = uSRValue;
}


//////////
// Function Name : GPIO_SetSRAll
// Function Desctiption : This function set All GPIO Slew Rate bits
// Input : 	Id : GPIO port
//			uValue : value(16bit)
// Output : NONE
//
// Version : v0.0
void GPIO_SetSRAll(GPIO_eId Id, u32 uValue)
{
	volatile u32 *pGPIOx_SRReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uDataRegNum,  uPullUDRegNum, uOffset;
	u32 uSRValue;

	
	uOffset = Id&0xFFF;
	uConRegNum = 1;
	uDataRegNum = 1;
	uPullUDRegNum = 1;
	

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_SRReg = pGPIO_Base_Addr + (uOffset/4) + uConRegNum+uDataRegNum+uPullUDRegNum;
	uSRValue = *pGPIOx_SRReg;
	uSRValue = (uSRValue & ~(0xffff0000)) | (uValue<<16);
	*pGPIOx_SRReg = uSRValue;
}




//////////
// Function Name : GPIO_SetConRegPDNAll
// Function Desctiption : This function set all GPIO function when system enter to Power Down mode
// Input : 	Id : GPIO port
//			uValue : value(16bit)
// Output : NONE
//
// Version : v0.0
void GPIO_SetConRegPDNAll(GPIO_eId Id, u32 uValue)
{
	volatile u32 *pGPIOx_ConPDNReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uDataRegNum, uPullUDRegNum, uConDSRegNum, uOffset;

	uOffset = Id&0xFFF;
	uConRegNum = 1;	
	uDataRegNum = 1;
	uPullUDRegNum = 1;
	uConDSRegNum =1;

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_ConPDNReg = pGPIO_Base_Addr + (uOffset/4) + (uConRegNum + uDataRegNum + uPullUDRegNum+uConDSRegNum);
	*pGPIOx_ConPDNReg = uValue;
}


//////////
// Function Name : GPIO_SetPullUDPDNAll
// Function Desctiption : This function set all GPIO Pull-up/down when system enter to Power Down mode
// Input : 	Id : GPIO port
//			uValue : value(16bit)
// Output : NONE
//
// Version : v0.1
void GPIO_SetPullUDPDNAll(GPIO_eId Id, u32 uValue)
{
	volatile u32 *pGPIOx_PullUDPDNReg;
	volatile u32 *pGPIO_Base_Addr;
	u32 uConRegNum, uDataRegNum, uPullUDRegNum, uConDSRegNum, uConPDNRegNum, uOffset;

       uOffset = Id&0xFFF;
	uConRegNum = 1;
	uDataRegNum = 1;
	uPullUDRegNum = 1;
	uConDSRegNum =1;
	uConPDNRegNum = 1;

	pGPIO_Base_Addr = &(GPIO->rGPIOA0CON);
	
	pGPIOx_PullUDPDNReg = pGPIO_Base_Addr + (uOffset/4) + (uConRegNum+uDataRegNum+uPullUDRegNum+uConDSRegNum+uConPDNRegNum);
	*pGPIOx_PullUDPDNReg = uValue;
}



//////////
// Function Name : GPIO_SetEint1
// Function Desctiption : This function setup Eint1[7:0]=> GPA0[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint1(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT1CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
	uType =uEINT_No;
	pEINTx_Reg = pGPIO_EINT_Addr ; 	
	uConValue = *pEINTx_Reg;
	uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
	*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
	uGpioPort = uEINT_No;
	uFunc = 0xf;  					// EINT Function 
	GPIO_SetFunctionEach(eGPIO_A0, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
	// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT1FLTCON0) ; 	    // EINT1FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT1FLTCON1); 	    // EINT1FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT1ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint1[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT1ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT1PEND;
	u32 uConValue;

	pEINT1PEND = &(GPIO->rEINT1PEND);

	uConValue = (1<<uEINT_No);
	*pEINT1PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT1UnMask
// Function Desctiption : UnMask the Eint1[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT1UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT1MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT1Mask
// Function Desctiption : Mask the Eint1[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT1Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT1MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}


//////////
// Function Name : GPIO_SetEint2
// Function Desctiption : This function setup Eint2[3:0]=> GPA1[3:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint2(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT2CON);

	
	if (uEINT_No >3)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	

	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}
	

	//  Interrupt Type 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 3)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_A1, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT2FLTCON0) ; 	    // EINT2FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
	
}



//////////
// Function Name : GPIO_EINT2ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint2[3:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT2ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT2PEND;
	u32 uConValue;

	pEINT2PEND = &(GPIO->rEINT2PEND);

	uConValue = (1<<uEINT_No);
	*pEINT2PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT2UnMask
// Function Desctiption : UnMask the Eint2[3:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT2UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT2MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT2Mask
// Function Desctiption : Mask the Eint2[3:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT2Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT2MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint3
// Function Desctiption : This function setup Eint3[7:0]=> GPB[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint3(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT3CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_B, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT3FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT3FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT3ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint3[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT3ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT3PEND;
	u32 uConValue;

	pEINT3PEND = &(GPIO->rEINT3PEND);

	uConValue = (1<<uEINT_No);
	*pEINT3PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT3UnMask
// Function Desctiption : UnMask the Eint3[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT3UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT3MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT3Mask
// Function Desctiption : Mask the Eint3[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT3Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT3MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}




//////////
// Function Name : GPIO_SetEint4
// Function Desctiption : This function setup Eint4[4:0]=> GPC0[4:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint4(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT4CON);

	if (uEINT_No > 4)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 4)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 4)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_C0, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT4FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No = 4)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT4FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT4ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint4[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT4ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT4PEND;
	u32 uConValue;

	pEINT4PEND = &(GPIO->rEINT4PEND);

	uConValue = (1<<uEINT_No);
	*pEINT4PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT4UnMask
// Function Desctiption : UnMask the Eint4[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT4UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT4MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT4Mask
// Function Desctiption : Mask the Eint4[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT4Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT4MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint5
// Function Desctiption : This function setup Eint5[4:0]=> GPC1[4:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint5(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT5CON);

	if (uEINT_No > 4)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 4)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 4)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_C1, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT5FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No = 4)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT5FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT5ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint5[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT5ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT5PEND;
	u32 uConValue;

	pEINT5PEND = &(GPIO->rEINT5PEND);

	uConValue = (1<<uEINT_No);
	*pEINT5PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT5UnMask
// Function Desctiption : UnMask the Eint5[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT5UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT5MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT5Mask
// Function Desctiption : Mask the Eint5[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT5Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT5MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint6
// Function Desctiption : This function setup Eint6[3:0]=> GPD0[3:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint6(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT6CON);

	if (uEINT_No > 3)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 3)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_D0, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT6FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	
	
}



//////////
// Function Name : GPIO_EINT6ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint6[3:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT6ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT6PEND;
	u32 uConValue;

	pEINT6PEND = &(GPIO->rEINT6PEND);

	uConValue = (1<<uEINT_No);
	*pEINT6PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT6UnMask
// Function Desctiption : UnMask the Eint6[3:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT6UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT6MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT6Mask
// Function Desctiption : Mask the Eint6[3:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT6Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT6MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint7
// Function Desctiption : This function setup Eint7[5:0]=> GPD1[5:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint7(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT7CON);

	if (uEINT_No > 5)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 5)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 5)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_D1, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT7FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 5)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT7FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT7ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint7[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT7ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT7PEND;
	u32 uConValue;

	pEINT7PEND = &(GPIO->rEINT7PEND);

	uConValue = (1<<uEINT_No);
	*pEINT7PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT7UnMask
// Function Desctiption : UnMask the Eint7[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT7UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT7MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT7Mask
// Function Desctiption : Mask the Eint7[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT7Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT7MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}




//////////
// Function Name : GPIO_SetEint8
// Function Desctiption : This function setup Eint8[7:0]=> GPE0[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint8(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT8CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_E0, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT8FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT8FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT8ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint8[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT8ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT8PEND;
	u32 uConValue;

	pEINT8PEND = &(GPIO->rEINT8PEND);

	uConValue = (1<<uEINT_No);
	*pEINT8PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT8UnMask
// Function Desctiption : UnMask the Eint8[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT8UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT8MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT8Mask
// Function Desctiption : Mask the Eint8[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT8Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT8MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}


//////////
// Function Name : GPIO_SetEint9
// Function Desctiption : This function setup Eint9[4:0]=> GPE1[4:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint9(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT9CON);

	if (uEINT_No > 4)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 4)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 4)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_E1, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT9FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No = 4)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT9FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT9ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint9[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT9ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT9PEND;
	u32 uConValue;

	pEINT9PEND = &(GPIO->rEINT9PEND);

	uConValue = (1<<uEINT_No);
	*pEINT9PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT9UnMask
// Function Desctiption : UnMask the Eint9[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT9UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT9MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT9Mask
// Function Desctiption : Mask the Eint9[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT9Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT9MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint10
// Function Desctiption : This function setup Eint10[7:0]=> GPF0[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint10(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT10CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_F0, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT10FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <=7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT10FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT10ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint10[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT10ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT10PEND;
	u32 uConValue;

	pEINT10PEND = &(GPIO->rEINT10PEND);

	uConValue = (1<<uEINT_No);
	*pEINT10PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT10UnMask
// Function Desctiption : UnMask the Eint10[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT10UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT10MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT10Mask
// Function Desctiption : Mask the Eint10[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT10Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT10MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}





//////////
// Function Name : GPIO_SetEint11
// Function Desctiption : This function setup Eint11[7:0]=> GPF1[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint11(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT11CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_F1, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT11FLTCON0) ; 	    // EINT11FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT11FLTCON1); 	    // EINT11FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT11ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint11[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT11ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT11PEND;
	u32 uConValue;

	pEINT11PEND = &(GPIO->rEINT11PEND);

	uConValue = (1<<uEINT_No);
	*pEINT11PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT11UnMask
// Function Desctiption : UnMask the Eint11[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT11UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT11MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT11Mask
// Function Desctiption : Mask the Eint11[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT11Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT11MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}




//////////
// Function Name : GPIO_SetEint12
// Function Desctiption : This function setup Eint12[7:0]=> GPF2[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint12(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT12CON);

	
	if (uEINT_No >7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	

	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}
	

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_F2, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT12FLTCON0) ; 	    // EINT12FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT12FLTCON1); 	    // EINT12FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
	
}



//////////
// Function Name : GPIO_EINT12ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint12[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT12ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT12PEND;
	u32 uConValue;

	pEINT12PEND = &(GPIO->rEINT12PEND);

	uConValue = (1<<uEINT_No);
	*pEINT12PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT12UnMask
// Function Desctiption : UnMask the Eint12[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT12UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT12MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT12Mask
// Function Desctiption : Mask the Eint12[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT12Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT12MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint13
// Function Desctiption : This function setup Eint13[5:0]=> GPF3[5:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint13(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT13CON);

	if (uEINT_No > 5)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 5)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 5)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_F3, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT13FLTCON0) ; 	    // EINT13FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <= 5)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT13FLTCON1); 	    // EINT13FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT13ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint13[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT13ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT13PEND;
	u32 uConValue;

	pEINT13PEND = &(GPIO->rEINT13PEND);

	uConValue = (1<<uEINT_No);
	*pEINT13PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT13UnMask
// Function Desctiption : UnMask the Eint13[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT13UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT13MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT13Mask
// Function Desctiption : Mask the Eint13[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT13Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT13MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}




//////////
// Function Name : GPIO_SetEint14
// Function Desctiption : This function setup Eint14[6:0]=> GPG0[6:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint14(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT14CON);

	if (uEINT_No > 6)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 6)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 6)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_G0, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT14FLTCON0) ; 	    // EINT14FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <= 6)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT14FLTCON1); 	    // EINT14FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT14ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint14[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT14ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT14PEND;
	u32 uConValue;

	pEINT14PEND = &(GPIO->rEINT14PEND);

	uConValue = (1<<uEINT_No);
	*pEINT14PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT14UnMask
// Function Desctiption : UnMask the Eint14[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT14UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT14MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT14Mask
// Function Desctiption : Mask the Eint14[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT14Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT14MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint15
// Function Desctiption : This function setup Eint15[6:0]=> GPG1[6:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint15(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT15CON);

	if (uEINT_No > 6)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 6)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 6)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_G1, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT15FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <= 6)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT15FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT15ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint15[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT15ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT15PEND;
	u32 uConValue;

	pEINT15PEND = &(GPIO->rEINT15PEND);

	uConValue = (1<<uEINT_No);
	*pEINT15PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT15UnMask
// Function Desctiption : UnMask the Eint15[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT15UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT15MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT15Mask
// Function Desctiption : Mask the Eint15[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT15Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT15MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint16
// Function Desctiption : This function setup Eint16[6:0]=> GPG2[6:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint16(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT16CON);

	if (uEINT_No > 6)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 6)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 6)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_G2, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT16FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <= 6)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT16FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
	
}



//////////
// Function Name : GPIO_EINT16ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint16[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT16ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT16PEND;
	u32 uConValue;

	pEINT16PEND = &(GPIO->rEINT16PEND);

	uConValue = (1<<uEINT_No);
	*pEINT16PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT16UnMask
// Function Desctiption : UnMask the Eint16[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT16UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT16MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT16Mask
// Function Desctiption : Mask the Eint16[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT16Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT16MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint17
// Function Desctiption : This function setup Eint17[6:0]=> GPG3[6:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint17(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT17CON);

	if (uEINT_No > 6)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 6)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 6)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_G3, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT17FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 6)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT17FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT17ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint17[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT17ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT17PEND;
	u32 uConValue;

	pEINT17PEND = &(GPIO->rEINT17PEND);

	uConValue = (1<<uEINT_No);
	*pEINT17PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT17UnMask
// Function Desctiption : UnMask the Eint17[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT17UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT17MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT17Mask
// Function Desctiption : Mask the Eint17[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT17Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT17MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}




//////////
// Function Name : GPIO_SetEint18
// Function Desctiption : This function setup Eint18[7:0]=> GPJ0[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint18(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT18CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_J0, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT18FLTCON0) ; 	    // EINT18FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT18FLTCON1); 	    // EINT18FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT18ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint18[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT18ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT18PEND;
	u32 uConValue;

	pEINT18PEND = &(GPIO->rEINT18PEND);

	uConValue = (1<<uEINT_No);
	*pEINT18PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT18UnMask
// Function Desctiption : UnMask the Eint18[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT18UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT18MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT18Mask
// Function Desctiption : Mask the Eint18[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT18Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT18MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}


//////////
// Function Name : GPIO_SetEint19
// Function Desctiption : This function setup Eint19[5:0]=> GPJ1[5:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint19(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT19CON);

	if (uEINT_No > 5)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 5)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 5)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_J1, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT19FLTCON0) ; 	    // EINT3FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 5)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT19FLTCON1); 	    // EINT3FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT19ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint19[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT19ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT19PEND;
	u32 uConValue;

	pEINT19PEND = &(GPIO->rEINT19PEND);

	uConValue = (1<<uEINT_No);
	*pEINT19PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT19UnMask
// Function Desctiption : UnMask the Eint19[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT19UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT19MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT19Mask
// Function Desctiption : Mask the Eint19[5:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT19Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT19MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint20
// Function Desctiption : This function setup Eint20[7:0]=> GPJ2[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint20(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT20CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_J2, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT20FLTCON0) ; 	    // EINT20FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <=7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT20FLTCON1); 	    // EINT20FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT20ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint20[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT20ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT20PEND;
	u32 uConValue;

	pEINT20PEND = &(GPIO->rEINT20PEND);

	uConValue = (1<<uEINT_No);
	*pEINT20PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT20UnMask
// Function Desctiption : UnMask the Eint20[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT20UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT20MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT20Mask
// Function Desctiption : Mask the Eint20[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT20Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT20MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint21
// Function Desctiption : This function setup Eint21[7:0]=> GPJ3[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint21(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT21CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_J3, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT21FLTCON0) ; 	    // EINT21FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT21FLTCON1); 	    // EINT21FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT21ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint21[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT21ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT21PEND;
	u32 uConValue;

	pEINT21PEND = &(GPIO->rEINT21PEND);

	uConValue = (1<<uEINT_No);
	*pEINT21PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT21UnMask
// Function Desctiption : UnMask the Eint21[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT21UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT21MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT21Mask
// Function Desctiption : Mask the Eint21[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT21Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT21MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}




//////////
// Function Name : GPIO_SetEint22
// Function Desctiption : This function setup Eint22[4:0]=> GPJ4[4:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint22(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT22CON);

	
	if (uEINT_No >4)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	

	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}
	

	//  Interrupt Type 
	if( uEINT_No <= 4)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 4)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_J4, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT22FLTCON0) ; 	    // EINT12FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No = 4)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT22FLTCON1); 	    // EINT12FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
	
}



//////////
// Function Name : GPIO_EINT22ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint22[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT22ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT22PEND;
	u32 uConValue;

	pEINT22PEND = &(GPIO->rEINT22PEND);

	uConValue = (1<<uEINT_No);
	*pEINT22PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT22UnMask
// Function Desctiption : UnMask the Eint22[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT22UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT22MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT22Mask
// Function Desctiption : Mask the Eint22[4:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT22Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT22MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint23
// Function Desctiption : This function setup Eint23[6:0]=> GPI[6:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint23(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT23CON);

	if (uEINT_No > 6)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth >0x7f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 6)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 6)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_I, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT23FLTCON0) ; 	    // EINT13FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <= 6)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT23FLTCON1); 	    // EINT13FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+7)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT23ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint23[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT23ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT23PEND;
	u32 uConValue;

	pEINT23PEND = &(GPIO->rEINT23PEND);

	uConValue = (1<<uEINT_No);
	*pEINT23PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT23UnMask
// Function Desctiption : UnMask the Eint23[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT23UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT23MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT23Mask
// Function Desctiption : Mask the Eint23[6:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT23Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT23MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}






//////////
// Function Name : GPIO_SetEint30
// Function Desctiption : This function setup Eint30[7:0]=> GPH0[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint30(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT30CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth > 0x3f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_H0, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT30FLTCON0) ; 	    // EINT20FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <=7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT30FLTCON1); 	    // EINT20FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT30ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint30[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT30ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT30PEND;
	u32 uConValue;

	pEINT30PEND = &(GPIO->rEINT30PEND);

	uConValue = (1<<uEINT_No);
	*pEINT30PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT30UnMask
// Function Desctiption : UnMask the Eint30[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT30UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT30MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT30Mask
// Function Desctiption : Mask the Eint30[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT30Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT30MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint31
// Function Desctiption : This function setup Eint31[7:0]=> GPH1[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint31(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT31CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth >0x3f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_H1, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT31FLTCON0) ; 	    // EINT31FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT31FLTCON1); 	    // EINT31FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT31ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint31[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT31ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT31PEND;
	u32 uConValue;

	pEINT31PEND = &(GPIO->rEINT31PEND);

	uConValue = (1<<uEINT_No);
	*pEINT31PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT31UnMask
// Function Desctiption : UnMask the Eint31[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT31UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT31MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT31Mask
// Function Desctiption : Mask the Eint31[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT31Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT31MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}




//////////
// Function Name : GPIO_SetEint32
// Function Desctiption : This function setup Eint32[7:0]=> GPH2[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x3F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint32(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT32CON);

	
	if (uEINT_No >7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	

	// Check Filter Width 
	if(uFltWidth >0x3f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}
	

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_H2, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT32FLTCON0) ; 	    // EINT12FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No > 3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT32FLTCON1); 	    // EINT12FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	
	
}



//////////
// Function Name : GPIO_EINT32ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint32[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT32ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT32PEND;
	u32 uConValue;

	pEINT32PEND = &(GPIO->rEINT32PEND);

	uConValue = (1<<uEINT_No);
	*pEINT32PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT32UnMask
// Function Desctiption : UnMask the Eint32[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT32UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT32MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT32Mask
// Function Desctiption : Mask the Eint32[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT32Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT32MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : GPIO_SetEint33
// Function Desctiption : This function setup Eint33[7:0]=> GPH3[7:0]
// Input : 			uEINT_No: EINT No.
//					uINTType: Select EINT Type. 
//								Low, High, Falling, Rising, Both
//					uFltType :  Select Filter Type
//								DisFLT(Disable Filter), DLYFLT(Delay Filter), DIGFLT(Digital Filter)
//					uFltWidth : Digital Filter Width ( 1~0x7F)
// Output : NONE
//
// Version : v0.0
void GPIO_SetEint33(u32 uEINT_No , u32 uIntType, FLT_eTYPE eFltType,  u32 uFltWidth)
{

	volatile u32 *pEINTx_Reg, *pFLTx_Reg;
	volatile u32 *pGPIO_EINT_Addr;
	u32 uGpioPort, uFunc, uType ;	
	u32 uConValue;

	GPIO_pBase = (void *)GPIO_BASE;

	pGPIO_EINT_Addr = &(GPIO->rEINT33CON);

	if (uEINT_No > 7)
	{
		printf("Error Eint No. \n");
		Assert(0);
	}
	
	// Check Filter Width 
	if(uFltWidth >0x3f)
	{
		printf("Error Filter Width. \n");
		Assert(0);
	}

	//  Interrupt Type 
	if( uEINT_No <= 7)
	{
		uType =uEINT_No;
		pEINTx_Reg = pGPIO_EINT_Addr ; 	
		uConValue = *pEINTx_Reg;
		uConValue = (uConValue & ~(0xF<<(uType*4))) | (uIntType<<(uType*4));
		*pEINTx_Reg = uConValue;
	}


	// EINT Port
	if( uEINT_No <= 7)
	{
		uGpioPort = uEINT_No;
		uFunc = 0xf;  					// EINT Function 
		GPIO_SetFunctionEach(eGPIO_H3, (GPIO_eBitPos)uGpioPort, uFunc);		// ??
		// GPIO_SetPullUpDownEach(eGPIO_N,(GPIO_eBitPos) uGpioPort, 0x0);		// disable Pull-up/dn
	}
		

	// Fliter Type & Filter Width 
	if( uEINT_No <= 3)
	{
		uType =uEINT_No;
		pFLTx_Reg = &(GPIO->rEINT33FLTCON0) ; 	    // EINT13FLTCON0
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	else if(uEINT_No >3 && uEINT_No <= 7)
	{
		uType =uEINT_No-4;
		pFLTx_Reg =&(GPIO->rEINT33FLTCON1); 	    // EINT13FLTCON1
		uConValue = *pFLTx_Reg;
		uConValue = (uConValue & ~(0xFF<<(uType*8))) |((uFltWidth<<(uType*8))|(eFltType<<(uType*8+6)));
		*pFLTx_Reg = uConValue;	
	}
	
}



//////////
// Function Name : GPIO_EINT33ClrPend
// Function Desctiption : Clear Eint pending bit of the Eint33[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT33ClrPend(u32 uEINT_No )
{

	volatile u32 *pEINT33PEND;
	u32 uConValue;

	pEINT33PEND = &(GPIO->rEINT33PEND);

	uConValue = (1<<uEINT_No);
	*pEINT33PEND = uConValue;

}

//////////
// Function Name : GPIO_EINT33UnMask
// Function Desctiption : UnMask the Eint33[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT33UnMask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT33MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)));
	*pMASK_Reg = uConValue;

}

//////////
// Function Name : GPIO_EINT33Mask
// Function Desctiption : Mask the Eint33[7:0]
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void GPIO_EINT33Mask(u32 uEINT_No )
{

	volatile u32 *pMASK_Reg;
	u32 uConValue;

	pMASK_Reg = &(GPIO->rEINT33MASK);
	
	uConValue = *pMASK_Reg;
       uConValue = (uConValue & ~(0x1<<(uEINT_No)))|(1<<uEINT_No);
	*pMASK_Reg = uConValue;

}



//////////
// Function Name : EINT_GRPPRI
// Function Desctiption : EINT Group priority rotate enable/diable (Fixed)
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void EINT_GRPPRI(PRI_eTYPE uPriType )
{

	volatile u32 *pEINT_GrpPri;
	u32 uConValue;

	pEINT_GrpPri = &(GPIO->rEINTGRPPRI);
	
	uConValue = *pEINT_GrpPri;
       uConValue = (uConValue & ~(0x1))|(uPriType);
	*pEINT_GrpPri = uConValue;

}


//////////
// Function Name : EINT_PRIORITY
// Function Desctiption : Every EINT group priority rotate enable/diable (Fixed)
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void EINT_PRIORITY(u32 uEINT_No )
{

	volatile u32 *pEINT_Priority;
	u32 uConValue;

	pEINT_Priority = &(GPIO->rEINTPRIORITY);
	
	uConValue = *pEINT_Priority;
       uConValue = (uConValue & ~(0x1<<(uEINT_No-1)))|(1<<uEINT_No-1);
	*pEINT_Priority = uConValue;

}



//////////
// Function Name : Get_EINTSVC
// Function Desctiption : This function get EINT service group and interrupt number
// Input : 	None
// Output : 	Data register value
//
// Version : v0.0

u32 Get_EINTSVC(void)
{
	volatile u32 *pEINT_Service;
	volatile u32 *pGPIO_Base_Addr;

	pEINT_Service = &(GPIO->rEINTSERVICE);	
	return (*pEINT_Service);
}


//////////
// Function Name : Get_EINTSVCPND
// Function Desctiption : This function get pending EINT service group and interrupt number
// Input : 	None
// Output : 	Data register value
//
// Version : v0.0

u32 Get_EINTSVCPEND(void)
{
	volatile u32 *pEINT_ServicePnd;
	volatile u32 *pGPIO_Base_Addr;

	pEINT_ServicePnd = &(GPIO->rEINTSERVICEPEND);	
	return (*pEINT_ServicePnd);
}



//////////
// Function Name : EINT_GRPFIXPRI
// Function Desctiption : Group number of the highest priority when fixed group priority mode (EINT1 ~ 22)
// Input : 			uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void EINT_GRPFIXPRI(u32 uEINT_No )
{

	volatile u32 *pEINT_GrpFixPri;
	u32 uConValue;

	pEINT_GrpFixPri = &(GPIO->rEINTGRPFIXPRI);
	
	uConValue = *pEINT_GrpFixPri;
       uConValue = (uConValue & ~(0x1))|(uEINT_No);
	*pEINT_GrpFixPri = uConValue;

}


//////////
// Function Name : EINT_FIXPRI
// Function Desctiption : interrupt number of the highest priority when fixed group priority mode (0 ~ 7)
// Input :                uEINT_Grp_No			
//                           uEINT_No: EINT No.
// Output : NONE
//
// Version : v0.0
void EINT_FIXPRI(u32 uEINT_Grp_No, u32 uEINT_No  )
{

	volatile u32 *pEINT_Grpx_FixPri, *pEINT_Grp1_FixPri;
	u32 uConValue;

	pEINT_Grp1_FixPri = &(GPIO->rEINT1FIXPRI);
	pEINT_Grpx_FixPri = pEINT_Grp1_FixPri  + (uEINT_Grp_No-1);
	
	uConValue = *pEINT_Grpx_FixPri;
       uConValue = (uConValue & ~(0x1))|(uEINT_No);
	*pEINT_Grpx_FixPri = uConValue;

}


void GPIO_SetFunctionForLts222QLdi(void)
{
	GPIO_SetFunctionEach(eGPIO_B, eGPIO_5, 0x1); // CS
	GPIO_SetFunctionEach(eGPIO_B, eGPIO_4, 0x1);	// CLK
	GPIO_SetFunctionEach(eGPIO_B, eGPIO_7, 0x1);	// DATA 
}

void GPIO_SetDataForLts222QLdi(u8 cData)
{
	volatile int i, j;

	GPIO_SetDataEach(eGPIO_B, eGPIO_5, 0x1); // CS high
	GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x1); // CLK high

	for (j=0; j<4; j++);

	GPIO_SetDataEach(eGPIO_B, eGPIO_5, 0x0); // CS low

//	for (j=0; j<2; j++);
									
	for (i=7; i>=0; i--)
	{                                                               
		if (cData &  (1<<i))
		{      
			GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x0); // CLK low
			GPIO_SetDataEach(eGPIO_B, eGPIO_7, 0x1); // DATA high

			for (j=0; j<2; j++);

			GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x1); // CLK high
			//GPIO_SetDataEach(eGPIO_B, eGPIO_7, 0x1); // DATA high	

			for (j=0; j<2; j++);
		}           

		else
		{                                                       
			GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x0); // CLK low
			GPIO_SetDataEach(eGPIO_B, eGPIO_7, 0x0); // DATA low

			for (j=0; j<2; j++);

			GPIO_SetDataEach(eGPIO_B, eGPIO_4, 0x1); // CLK high
			//GPIO_SetDataEach(eGPIO_N, eGPIO_3, 0x0); // DATA low	

			for (j=0; j<2; j++);
		}
	}

	GPIO_SetDataEach(eGPIO_B, eGPIO_5, 0x0); // CS low

}

