/********************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for verifying functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------
* 
*	File Name : Dma_test.c
*  
*	File Description :
*
*	Author			: gyu hwan Cha
*	Dept. 			: AP Development Team
*	Created Date 	: 2009/04/16 -> Reference Code is S5PV210 Micro Code
*	Version 		: 0.1 
* 
*	History 
*	
*	
*  
********************************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "option.h"
#include "library.h"
#include "def.h"
#include "dma.h"
#include "intc.h"
#include "timer.h"


static DMA_CH eCh;
static DMA_CH eCh2;

static eIntDmac;                           
static u8 bTestByInt;
static BURST_MODE eBurst;
static volatile u8 bDmaDone;
static DATA_SIZE eDataSize;
static u32 uTrCnt;
static u8 bDmaTestAll;
static u32 uErrCnt;
static volatile u32 uDmaIntStatus;

static DMAC pDmac;
static DMAC pDmac_chs[MAX_DMA_CH];
static DMAC pDmac0;
static DMAC pDmac1;
static DMAC pDmac2;

static volatile u8 bDmaDone;
static volatile u8 bDmaDone_chs[MAX_DMA_CH];
static volatile u8 bDmac0Done;
static volatile u8 bDmac1Done;
static volatile u8 bDmac2Done;

static u32 eAgingTest = false;
static u32 eRegtoMemTest = false;
static u32 ePerformanceTest = false;


#define Align(x, alignbyte) (((x)+(alignbyte)-1)/(alignbyte)*(alignbyte))

static void __irq Isr_Dmac(void)
{	
	u32 uInt;

	INTC_Disable(NUM_MDMA);

	DMA_GetIntrSrc(&uInt, &pDmac_chs[0]);
	
	if (uInt==32)
	{
		Disp("[DMA FAULT & STOP]");
		DMA_StopDmac(&pDmac_chs[0]);
	}
	else
	{
		DMA_ClearIntPending(uInt, &pDmac_chs[0]);	
		bDmaDone_chs[uInt] = true;
		DMA_StopCh(&pDmac_chs[uInt]);
		Disp("Ch NO %d DMA Transfer Done Interrupt !! \n",uInt);
	}
	INTC_ClearVectAddr();

	INTC_Enable(NUM_MDMA);
}

static void __irq Isr_PDma0c(void)
{	
	u32 uInt;

	INTC_Disable(NUM_PDMA0);

	DMA_GetIntrSrc(&uInt, &pDmac_chs[0]);
	
	if (uInt==32)
	{
		Disp("[DMA FAULT & STOP]");
		DMA_StopDmac(&pDmac_chs[0]);
	}
	else
	{
		DMA_ClearIntPending(uInt, &pDmac_chs[0]);	
		bDmaDone_chs[uInt] = true;
		DMA_StopCh(&pDmac_chs[uInt]);
		Disp("Ch NO %d DMA Transfer Done Interrupt !! \n",uInt);
	}
	INTC_ClearVectAddr();

	INTC_Enable(NUM_PDMA0);
}


static void SelectChannel(void)
{
	u32 x;
	
	Disp("0.DMA_CH_00, 1.DMA_CH_01, 2.DMA_CH_02, 3.DMA_CH_03, \n");
	Disp("4.DMA_CH_04, 5.DMA_CH_05, 6.DMA_CH_06, 7.DMA_CH_07, \n");
	x = UART_GetIntNum();
	eCh  = (x==0) ? DMA_00 :
			(x==1) ? DMA_01 :
			 (x==2) ? DMA_02 :
			  (x==3) ? DMA_03 : 
			   (x==4) ? DMA_04 : 
				(x==5) ? DMA_05 : 
				 (x==6) ? DMA_06 : 
				  (x==7) ? DMA_07 : DMA_00;
}

static void SelectTransferMode(void)
{
	u32 x;
	
	Disp("1.Test By Interrupt, 2.Test By Pollingt\n");
	x = UART_GetIntNum();
	bTestByInt = (x==1) ? true : false;
}

static void SelectTransferLength(void)
{
	u32 x;

	if(eDataSize!=WORD)
	{
		Disp("1.SINGLE , 2.BURST4, 3.BURST8, 4.BURST16 \n");
		x = UART_GetIntNum();		
		eBurst = (x==1) ? SINGLE : 
				  (x==2) ? BURST4 :
				   (x==3) ? BURST8 : 
					(x==4) ? BURST16 : SINGLE;
	}
	else	// DMAC SPEC : Page 6.1-3 --> word transfer :  Up to 8 burst.
	{
		Disp("1.SINGLE , 2.BURST4, 3.BURST8, 4.BURST16\n");		
		x = UART_GetIntNum();
		eBurst = (x==1) ? SINGLE : 
				  (x==2) ? BURST4 :
				   (x==3) ? BURST8 :
				    (x==4) ? BURST16 : SINGLE;
	}
	
}

static void SelectTransferWidth(void)
{
	u32 x;

	Disp("1.BYTE, 2.HWORD, 3.WORD,  4.DWORD \n");
	x = UART_GetIntNum();
	eDataSize = (x==1) ? BYTE : 
				 (x==2) ? HWORD : 
				  (x==3) ? WORD : 
				   (x==4) ? DWORD : BYTE;
		
}

static void SelectMaster(void)		
{
	u32 x;
	Disp("0.PDMA_0, 1.PDMA_1, 2.MDMA\n");
	Disp("Choose One: ");
	x = UART_GetIntNum();
	eCh  = (x==0) ? DMA_00 :
			(x==1) ? DMA_10 : DMA_20;
	eCh2 = (x==0) ? DMA_01 :
			(x==1) ? DMA_11 : DMA_21;

	eIntDmac = (x==0) ? NUM_PDMA0 :
			(x==1) ? NUM_PDMA1 : NUM_MDMA;
}

#if 1
static void SetNonSecure(void)	// S3C24C0 is no secure area.
{
	Outp32(0xF1500804,0xff );
	Outp32(0xF1500810,0xff );
	Outp32(0xF150081C,0xff );
	Outp32(0xFAD00804,0xff );
	Outp32(0xFAD00810,0xff );
	Outp32(0xFAD0081C,0xff );
	Outp32(0xFAD00828,0xff );
	Outp32(0xE0600804,0xff );
	Outp32(0xE0600810,0xff );
	Outp32(0xE060081C,0xff );
	Outp32(0xE0600828,0xff );
	//Outp32(0xE1C00804,0xff );
	//Outp32(0xE1C00810,0xff );
	//Outp32(0xE1C0081C,0xff );
	//Outp32(0xE1C00828,0xff );

}
#endif

static void TestMemToMemWithMultiCh(void)
{
	u32 uCh,uNoCh, uT;
	u32 i=0,j=0;
	u32 count;
	u32 uCnt = uTrCnt;
	u32 uBurstSz;
	u32 uDataSz;
	u32 uTrBytes;
	u8 temp=0;
	u8 bIsOK;
	
	u32 uSrcAddr;
	u32 uDstAddr;	
	
	u32 uSrcAddr_ch[MAX_DMA_CH]={0};	// Hardward Define
	u32 uDstAddr_ch[MAX_DMA_CH]={0};	// Hardward Define

	u32 offset=0x20;					// User Define Variable Value 

	u32 uStartTime[MAX_DMA_CH]={0};
	u32 uEndTime[MAX_DMA_CH]={0};
	u32 uUseTime[MAX_DMA_CH]={0};

	uDataSz =( (eDataSize==BYTE) ? 1 :
			   (eDataSize==HWORD) ? 2 : 
			   (eDataSize==WORD) ? 4 :
			   (eDataSize==DWORD) ? 8 : 1) ;


	
    if(ePerformanceTest ==1) 					// for the aging test 
	{
		uNoCh =1;
		uTrBytes = 32*1000000;		
    }
	else if(eAgingTest >0)
	{
		Disp("Input Numbers of channel : ");
		uNoCh = MAX_DMA_CH;//uNoCh = 8;	

		Disp("Input Dma Trasfer Count : ");
		uCnt = DMAC_TRUNIT_SZ;//uCnt = 1024;

		uTrBytes = uCnt * uDataSz;
	
	}
	else
	{
		Disp("Input Numbers of channel : ");
		uNoCh = UART_GetIntNum();
		if(uNoCh>MAX_DMA_CH)
		{
			uNoCh = MAX_DMA_CH;
			Disp("Has exceeded the input value. --> Set Maximum channels = %d\n", uNoCh);			
		}
		
		Disp("Input Dma Trasfer Count : ");
		uCnt = UART_GetIntNum();
		if(uCnt>DMAC_TRUNIT_SZ)
		{
		//	uCnt = DMAC_TRUNIT_SZ;
			Disp("Has exceeded the input value. --> Set Maximum DMA Trasfer Count = %d\n", uCnt);			
		}
		
		uTrBytes = uCnt * uDataSz;
	}

    



	Disp("TransferBytes = %d\n", uTrBytes);
	Disp("DATA_SIZE = %s, TransferCount = %d\n", (eDataSize==WORD) ? "WORD" :
		(eDataSize==HWORD) ? "HWORD" : (eDataSize==DWORD) ? "DWORD" :"BYTE", uCnt);


	if(eAgingTest ==0) 					// for the aging test 
	{
		uSrcAddr = 0x20000000;//uSrcAddr = 0x40000000+0x01000000;
//		uSrcAddr = CODEC_MEM_ST;//uSrcAddr = 0x40000000+0x01000000;
		uDstAddr = uSrcAddr + uTrBytes + offset;//uDstAddr = uSrcAddr + uTrBytes + 0x20;
		uDstAddr = CODEC_MEM_ST + uTrBytes + offset;//uDstAddr = uSrcAddr + uTrBytes + 0x20;
	}
	else
	{
		uSrcAddr = CODEC_MEM_ST;//uSrcAddr = 0x40000000+0x01000000;
		uDstAddr = uSrcAddr + uTrBytes + offset;//uDstAddr = uSrcAddr + uTrBytes + 0x20;
	}

	if(eRegtoMemTest==true)
	{
		uSrcAddr = DMC0_BASE;//uSrcAddr = 0x40000000+0x01000000;
		uDstAddr = CODEC_MEM_ST ;
	}
	
//	uSrcAddr = 0x41000000;
//	uDstAddr = 0x21000000; 


	for(j=0; j<uNoCh ; j++)
	{
		uSrcAddr_ch[j] = (uSrcAddr+i)+ ( j*(uTrBytes+offset) );
		uDstAddr_ch[j] = (uDstAddr+i)+ ( j*(uTrBytes+offset) );

		Disp("uSrcAddr_ch[%d] = 0x%x\n", j,uSrcAddr_ch[j]);
		Disp("uDstAddr_ch[%d] = 0x%x\n", j,uDstAddr_ch[j]);
		
		//for(i=0; i<uTrBytes ; i++)
		//{
		//	*(u8*)(uSrcAddr_ch[j]+i) = i%255+1;
		//	*(u8*)(uDstAddr_ch[j]+i) = 0;
		//}
	}

	
	if(bTestByInt==1)
	{
		INTC_Init();
		INTC_SetVectAddr(NUM_MDMA, Isr_Dmac);
		INTC_Enable(NUM_MDMA);
	}

	
	for (uCh=0;uCh<uNoCh;uCh++)	// channel set 0,1,2 ~ 13,14,15
	{				
       
		bDmaDone_chs[uCh] = false;
				
		DMA_SetCh(eCh+(uCh), &pDmac_chs[uCh]); // MDMA ch 0
		DMA_InitCh(eDataSize, SOFTWARE, DMA_M2M, eBurst, &pDmac_chs[uCh]);  
		DMA_StartCh(uSrcAddr_ch[uCh],uDstAddr_ch[uCh], uTrBytes, &pDmac_chs[uCh]);	// transfer size by word
		
		
	}    
	StartTimer(0);
	while(!(temp==uNoCh)) // & bDmaDone[1] & bDmaDone[2]
	{	
		temp=0;
		for (uCh=0;uCh<uNoCh;uCh++)	// channel set 0,1,2 ~ 13,14,15
		{
			if(bTestByInt==1)
				temp+= bDmaDone_chs[uCh]; // when all transfer done, then bDmaDone[uCh]'s value be '1'. unless it would be '0'
			else 
				temp+=DMA_WaitForTrDone(&pDmac_chs[uCh]);	
		}
	}
	
	uEndTime[0] =StopTimer(0);	
	for (uCh=0;uCh<uNoCh;uCh++)	// channel set 0,1,2 ~ 13,14,15
	{				
		bIsOK = memcmp( (void*)uSrcAddr_ch[uCh], (void*)uDstAddr_ch[uCh], uTrBytes );
		if( bIsOK != 0 )
		{
			Disp("\nCh%d : 0x%x --> 0x%x : %dByte DMA transfer Fail\n",uCh,uSrcAddr_ch[uCh],uDstAddr_ch[uCh],uTrBytes);	
			eAgingTest =0;
		}
		else
			Disp("\nCh%d : 0x%x --> 0x%x : %dByte DMA transfer OK\n",uCh,uSrcAddr_ch[uCh],uDstAddr_ch[uCh],uTrBytes);				
		
	}
	Disp(" %d Byte %8d usec, Performance :                                  %6.2f MByte/sec \n", uTrBytes, uEndTime[0], (float)(uTrBytes/(float)uEndTime[0]));
	
	if(bTestByInt==1)
	{
		INTC_ClearVectAddr();
		INTC_Disable(NUM_MDMA);
	}	
	
}

static void TestRegToMemWithMultiCh(void)
{
	eRegtoMemTest =true;
	SetNonSecure();
	TestMemToMemWithMultiCh();
	eRegtoMemTest =false;
}


static void TestMemToMemUseLLI(void)
{
	int i, count;

	u32 uCodeAddr = CODEC_MEM_ST;
	u32 uSrcAddr = CODEC_MEM_ST+0x100000;

	u32 uTransferSz = 0x100*3;
	u32 uSrc0 = uSrcAddr+0x3000;
	u32 uSrc1 = uSrc0+0x1000;
	u32 uSrc2 = uSrc1+0x1000;
	u32 uDstAddr = uSrc2+0x1000;

	u32 uSize0 = uTransferSz/3;
	u32 uSize1 = uTransferSz/3;
	u32 uSize2 = uTransferSz/3;	

	u8 *p0 = (u8*)(uSrcAddr+uTransferSz-1);
	u8 *p1 = (u8*)(uDstAddr+uTransferSz-1);

	for(i=0; i< uTransferSz ; i++)
	{
		*(u8*)(uSrcAddr+i) = rand()%255;
		*(u8*)(uDstAddr+i) = 0x0;
	}

	bTestByInt = false;
	eDataSize = WORD;

    DMA_SetCh(DMA_20,&pDmac);
    DMA_AddTrCode(WORD, SOFTWARE, DMA_M2M, BURST4, uSrcAddr, uDstAddr, uSize0/4,&pDmac);
	Disp("1. src=0x%x, dst=0x%x\n", uSrcAddr, uDstAddr);
	DMA_AddTrCode(WORD, SOFTWARE, DMA_M2M, BURST4, uSrcAddr+uSize0, uDstAddr+uSize0, uSize1/4,&pDmac);
	Disp("2. src=0x%x, dst=0x%x\n", uSrcAddr+uSize0, uDstAddr+uSize0);
	DMA_AddTrCode(WORD, SOFTWARE, DMA_M2M, BURST4, uSrcAddr+uSize0+uSize1, uDstAddr+uSize0+uSize1, uSize2/4,&pDmac);
	Disp("3. src=0x%x, dst=0x%x\n", uSrcAddr+uSize0+uSize1, uDstAddr+uSize0+uSize1);
	DMA_EncodeDmaEnd(&pDmac);
	DMA_Go(&pDmac);

	while( !DMA_IsTransferDone(&pDmac) ) ;


	Disp("Dma Transfer is completed!!\n");
	Disp("(0x%x=%d) != (0x%x=%d)\n",p0,*p0,p1,*p1);

	p0 = (u8*)(uSrcAddr);
	p1 = (u8*)(uDstAddr);
	for(i=0,count=0 ; i < uTransferSz ; i++)
	{
		if( *p0 != *p1 )
		{
			count++;
			Disp("Last Data : (0x%x=%d) != (0x%x=%d)\n",p0,*p0,p1,*p1);
			if (count>10)
				break;
		}
		p0++;
		p1++;
	}
	if (count == 0)
		Disp("Dma MtoM Transfer is Success!\n");
	else
		Disp("Dma MtoM Transfer is Fail!\n");
} 


static void TestMemToMemWithMultiCh_PDMA(void)
{
	u32 uCh,uNoCh, uT;
	u32 i=0,j=0;
	u32 count;
	u32 uCnt = uTrCnt;
	u32 uBurstSz;
	u32 uTrBytes;
	u8 temp=0;
	u8 bIsOK;
	
	u32 uSrcAddr;
	u32 uDstAddr;	
	
	u32 uSrcAddr_ch[MAX_DMA_CH]={0};	// Hardward Define
	u32 uDstAddr_ch[MAX_DMA_CH]={0};	// Hardward Define

	u32 offset=0x20;					// User Define Variable Value 

	u32 uEndTime[MAX_DMA_CH]={0};


	eCh = DMA_00;	//eCh = DMA_20;
//	eCh2 = DMA_01;	//eCh2 = DMA_21;
	eIntDmac = NUM_PDMA0;	
	bTestByInt = true;
	eBurst = SINGLE;
	eDataSize = BYTE;
	bDmaTestAll = false;

	eAgingTest = 1;
	
	SetNonSecure();
	
    if(eAgingTest ==0) 					// for the aging test 
	{
		Disp("Input Numbers of channel : ");
		uNoCh = UART_GetIntNum();
		if(uNoCh>MAX_DMA_CH)
		{
			uNoCh = MAX_DMA_CH;
			Disp("Has exceeded the input value. --> Set Maximum channels = %d\n", uNoCh);			
		}
		
		Disp("Input Dma Trasfer Count : ");
		uCnt = UART_GetIntNum();
		if(uCnt>DMAC_TRUNIT_SZ)
		{
			uCnt = DMAC_TRUNIT_SZ;
			Disp("Has exceeded the input value. --> Set Maximum DMA Trasfer Count = %d\n", uCnt);			
		}
		
		uTrBytes = uCnt * ( (eDataSize==BYTE) ? 1 :
						  (eDataSize==HWORD) ? 2 : 
						  (eDataSize==WORD) ? 4 : 8) ;
    }
	else
	{
		Disp("Input Numbers of channel : ");
		uNoCh = 1;//MAX_DMA_CH;//uNoCh = 8;	

		Disp("Input Dma Trasfer Count : ");
		uCnt = DMAC_TRUNIT_SZ;//uCnt = 1024;

		uTrBytes = uCnt * ( (eDataSize==BYTE) ? 1 :
						  (eDataSize==HWORD) ? 2 : 
						  (eDataSize==WORD) ? 4 : 8) ;
	}

	Disp("TransferBytes = 0x%x\n", uTrBytes);
	Disp("DATA_SIZE = %s, TransferCount = %d\n", (eDataSize==WORD) ? "WORD" :
		(eDataSize==HWORD) ? "HWORD" : "BYTE", uCnt);


	if(eAgingTest ==0) 					// for the aging test 
	{
		uSrcAddr = CODEC_MEM_ST;//uSrcAddr = 0x40000000+0x01000000;
		uDstAddr = uSrcAddr + uTrBytes + offset;//uDstAddr = uSrcAddr + uTrBytes + 0x20;
	}
	else
	{
		uSrcAddr = CODEC_MEM_ST;//uSrcAddr = 0x40000000+0x01000000;
		uDstAddr = 0x20000000; //uDstAddr = uSrcAddr + uTrBytes + 0x20;
	}

	uSrcAddr = 0x41000000;
	uDstAddr = 0x21000000; 


	for(j=0; j<uNoCh ; j++)
	{
		uSrcAddr_ch[j] = (uSrcAddr+i)+ ( j*(uTrBytes+offset) );
		uDstAddr_ch[j] = (uDstAddr+i)+ ( j*(uTrBytes+offset) );

		Disp("uSrcAddr_ch[%d] = 0x%x\n", j,uSrcAddr_ch[j]);
		Disp("uDstAddr_ch[%d] = 0x%x\n", j,uDstAddr_ch[j]);
		
		for(i=0; i<uTrBytes ; i++)
		{
			*(u8*)(uSrcAddr_ch[j]+i) = i%255+1;
			*(u8*)(uDstAddr_ch[j]+i) = 0;
		}
	}

	
	if(bTestByInt==1)
	{
		INTC_Init();
		INTC_SetVectAddr(NUM_PDMA0, Isr_PDma0c);
		INTC_Enable(NUM_PDMA0);
	}
    
	for (uCh=0;uCh<uNoCh;uCh++)	// channel set 0,1,2 ~ 13,14,15
	{				
       
		bDmaDone_chs[uCh] = false;
				
		DMA_SetCh(eCh+(uCh), &pDmac_chs[uCh]); // MDMA ch 0
		DMA_InitCh(eDataSize, SOFTWARE, DMA_M2P, eBurst, &pDmac_chs[uCh]);  
		DMA_StartCh(uSrcAddr_ch[uCh],uDstAddr_ch[uCh], uCnt, &pDmac_chs[uCh]);	// transfer size by word
	}    

	StartTimer(0);

	while(!(temp==uNoCh)) // & bDmaDone[1] & bDmaDone[2]
	{	
		temp=0;
		for (uCh=0;uCh<uNoCh;uCh++)	// channel set 0,1,2 ~ 13,14,15
		{
			if(bTestByInt==1)
				temp+= bDmaDone_chs[uCh]; // when all transfer done, then bDmaDone[uCh]'s value be '1'. unless it would be '0'
			else 
				temp+=DMA_WaitForTrDone(&pDmac_chs[uCh]);	
		}
	}
	
	uEndTime[0] =StopTimer(0);
	
	for (uCh=0;uCh<uNoCh;uCh++)	// channel set 0,1,2 ~ 13,14,15
	{				
		bIsOK = memcmp( (void*)uSrcAddr_ch[uCh], (void*)uDstAddr_ch[uCh], uTrBytes );
		if( bIsOK != 0 )
		{
			Disp("\nCh%d : 0x%x --> 0x%x : %dByte DMA transfer Fail\n",uCh,uSrcAddr_ch[uCh],uDstAddr_ch[uCh],uTrBytes);	
			eAgingTest =0;
		}
		else
			Disp("\nCh%d : 0x%x --> 0x%x : %dByte DMA transfer OK\n",uCh,uSrcAddr_ch[uCh],uDstAddr_ch[uCh],uTrBytes);				
		
	}
	Disp(" %d Byte %8d usec, Performance :                                  %6.2f MByte/sec \n", uTrBytes, uEndTime[0], (float)(uTrBytes/(float)uEndTime[0]));
	
	if(bTestByInt==1)
	{
		INTC_ClearVectAddr();
		INTC_Disable(NUM_PDMA0);
	}	
	
}


void TestM2MAging(void)
{
	eAgingTest =true;
	
	while(eAgingTest!=false)
	{
		eAgingTest ++;
		TestMemToMemWithMultiCh();
		Disp("eAgingTest = %d\n",eAgingTest);
	}
	Disp("eAgingTest Fail !!!!! \n");	
	
	eAgingTest =false;
}

void TestM2M_PDMA_Aging(void)
{
	eAgingTest =true;
	
	while(eAgingTest!=false)
	{
		eAgingTest ++;
		TestMemToMemWithMultiCh_PDMA();
		Disp("eAgingTest = %d\n",eAgingTest);
	}
	Disp("eAgingTest Fail !!!!! \n");	
	
	eAgingTest =false;
}

void TestM2MPerformance(void)
{
	u32 i,j=0;

	ePerformanceTest =true;
	for(i=SINGLE;i<=BURST16;i++)
	{
		for(j=BYTE;j<=DWORD;j++)
		{
			eBurst = i;
			eDataSize = j;
			Disp("- DATA_SIZE           : %s\n",   (eDataSize==DWORD)   ? "DWORD" :
				(eDataSize==WORD)  ? "WORD" :
				(eDataSize==HWORD) ? "HWORD" : "BYTE");		
			Disp("- TR MODE             : %s\n", 
				(eBurst==SINGLE)   ? "SINGLE" : 
				(eBurst==BURST4)   ? "BURST4" : 
				(eBurst==BURST8)   ? "BURST8" :
				(eBurst==BURST16)  ? "BURST16" : 	"SINGLE");
			Disp("\nSelect the function to test : ");
			TestMemToMemWithMultiCh();
		}
	}	
	
	ePerformanceTest =false;
}


bool DMA_FullFunction_autotest(void)
{
	eAgingTest =true;

	eCh = DMA_20;	//eCh = DMA_20;
//	eCh2 = DMA_01;	//eCh2 = DMA_21;
	eIntDmac = NUM_MDMA;	
	bTestByInt = true;
	eBurst = BURST16;
	eDataSize = WORD;
	bDmaTestAll = false;

	
	
	TestMemToMemWithMultiCh();
	if(eAgingTest==0)
		return false;
	else 
		return true;
}

const testFuncMenu dma_menu[] =
{
	0,               		   		"Exit",
	TestMemToMemWithMultiCh,		"TestMemToMem or MultiCh",
	TestMemToMemUseLLI,     	    "TestMemToMem Using LLI",	
	TestM2MAging,					"TestM2MAging ",
	TestM2M_PDMA_Aging,				"TestM2MAging by PDMA",
	TestMemToMemWithMultiCh_PDMA,   "TestMemToMem or MultiCh by PDMA",
	TestRegToMemWithMultiCh,        "TestRegToMemWithMultiCh",
	TestM2MPerformance,        		"TestM2MPerformance ",
	
	
	SelectMaster,					"SelectMaster",
	SelectChannel,					"SelectChannel",
	SelectTransferMode,				"SelectTransferMode",
	SelectTransferLength,			"SelectTransferLength = Burst Mode",
	SelectTransferWidth,			"SelectTransferWidth = Byte Size ",

	DMA_FullFunction_autotest,      "Auto test",
	0, 0
};
	


void Test_DMAC(void)
{
	int i;
	int sel;

	eCh = DMA_20;	//eCh = DMA_20;
//	eCh2 = DMA_01;	//eCh2 = DMA_21;
	eIntDmac = NUM_MDMA;	
	bTestByInt = true;
	//eBurst = SINGLE;
	//eDataSize = BYTE;
	eBurst = BURST16;
	eDataSize = WORD;
	
	bDmaTestAll = false;

	//SelectMaster();
	//SelectChannel();
	//SelectTransferMode();      
	//SelectTransferLength();
	//SelectTransferWidth();
	
	while(1)
	{
		for (i=0; (int)(dma_menu[i].desc)!=0; i++)
			Disp("%2d: %s\n", i, dma_menu[i].desc);

		Disp("- Current Dma Unit	: %s\n",   (eIntDmac==NUM_MDMA) ? "NUM_MDMA" :
			(eCh==NUM_PDMA0)   ? "NUM_PDMA0" : (eCh==NUM_PDMA1)     ? "NUM_PDMA0" : "NUM_MDMA");
		Disp("- Test Mode           : %s\n",   (bTestByInt)         ? "Interrupt" : "Polling");
		Disp("- DATA_SIZE           : %s\n",   (eDataSize==DWORD)   ? "DWORD" :
			(eDataSize==WORD)  ? "WORD" :
			(eDataSize==HWORD) ? "HWORD" : "BYTE");		
		Disp("- TR MODE             : %s\n", 
			(eBurst==SINGLE)   ? "SINGLE" : 
			(eBurst==BURST4)   ? "BURST4" : 
			(eBurst==BURST8)   ? "BURST8" :
			(eBurst==BURST16)  ? "BURST16" : 	"SINGLE");
		Disp("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");

		if (sel == 0)
			break;
		if (sel>0 && sel<(sizeof(dma_menu)/8-1))
			(dma_menu[sel].func) ();
 	}
}

