/********************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for verifying functions of the S5PC100.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------
* 
*	File Name : dma.c
*  
*	File Description :
*
*	Author	: cha gyu hwan
*	Dept. : AP Development Team
*	Created Date : 2008/10/17
*	Version : 0.1 
* 
*	History 
*	
*	
*  
********************************************************************************/


#ifndef __DMA_H__
#define __DMA_H__


#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include "v210_sfr.h"

#include "def.h"
#include "option.h"

#ifndef S5PC100
//#define INT_MDMA INT_DMA_C
#endif

// Transfer Loop limit
#define DMAC_TRUNIT_SZ (256*256+240) // 2^12 number of data
//#define DISP_DMA_REG
//#define DMAC_CODE_BASE 0x47e00000
#define DMAC_CODE_SIZE 0x1000

#define MAX_DMA_CH 8

/*enum DMA_FLOW_CONTROL
{
	CTR_DMAC, CTR_SRCPERI, CTR_DSTPERI
};
*/

typedef enum 
{
	DMA_00, DMA_01, DMA_02, DMA_03, DMA_04, DMA_05, DMA_06, DMA_07,
	DMA_10, DMA_11, DMA_12, DMA_13, DMA_14, DMA_15, DMA_16, DMA_17,
	DMA_20, DMA_21, DMA_22, DMA_23, DMA_24, DMA_25, DMA_26, DMA_27 
}DMA_CH;

typedef enum 
{
// Peri DMA 0,1
	UART0_RX	 = 0x0,
	UART0_TX	 = 0x1,
	UART1_RX	 = 0x2,
	UART1_TX	 = 0x3,
	UART2_RX	 = 0x4,
	UART2_TX	 = 0x5,
	UART3_RX	 = 0x6,
	UART3_TX	 = 0x7,
	Reserved0      = 0x8,
	I2S0_RX	 	= 0x9,
	I2S0_TX	 	= 0xa,
	I2S0S_TX	 = 0xb,
	I2S1_RX	 	= 0xc,
	I2S1_TX	 	= 0xd,
	I2S2_RX	 = 0xe,
	I2S2_TX	 = 0xf,
	SPI0_RX     = 0x10,
	SPI0_TX     = 0x11,
	SPI1_RX     = 0x12,
	SPI1_TX     = 0x13,
	SPI2_RX     = 0x14,
	SPI2_TX     = 0x15,
// Peri DMA 0	
	AC_MICin	 = 0x16,
	AC_PCMin	 = 0x17,
	AC_PCMout	 = 0x18,	
	Reserved3	= 0x19,
	PWM		 = 0x1a,
	SPDIF		= 0x1b,
	Reserved4	 = 0x1c,
	Reserved5	 = 0x1d,
	Reserved6	 = 0x1e,
	Reserved7	 = 0x1f,
// Peri DMA 1
	PCM0_RX	 = 0x16,
	PCM0_TX	 = 0x17,
	PCM1_RX	 = 0x18,
	PCM1_TX	 = 0x19,
	MSM_REQ0	 = 0x1a,
	MSM_REQ1	 = 0x1b,
	MSM_REQ2	 = 0x1c,
	MSM_REQ3	 = 0x1d,
	PCM2_RX  	= 0x1e,
	PCM2_TX  	= 0x1f,

// Mem DMA	
	//SEC_RX	 	 = 0x0,	
	//SEC_TX	 	 = 0x1,
	SOFTWARE     = 0xff
}DREQ_SRC;


typedef enum 
{
	DMA_M2M = 0x0, 
	DMA_M2P = 0x1, 
	DMA_P2M	= 0x2, 
	DMA_P2P = 0x3
}DMA_TR_DIR;

///////////////////////////////////
//DMASELECT_ID added by jspark for code merge (09.04.27)
typedef enum DMASELECT_ID
{
	eSEL_UART0_0		=	0,
	eSEL_UART0_1		=	1, 		
	eSEL_UART1_0		=	2,
	eSEL_UART1_1		=	3,
	eSEL_UART2_0		=	4,
	eSEL_UART2_1		=	5,
	eSEL_UART3_0		=	6,
	eSEL_UART3_1		=	7,
	eSEL_PCM0_TX		=	8,
	eSEL_PCM0_RX		=	9,
	eSEL_I2S0_TX		=	10,
	eSEL_I2S0_RX		=	11,
	eSEL_SPI0_TX		=	12,
	eSEL_SPI0_RX		=	13,
	eSEL_HSI_TX		=	14,
	eSEL_HSI_RX		=	15,
	eSEL_PCM1_TX		=	16,
	eSEL_PCM1_RX		=	17,
	eSEL_I2S1_TX		=	18,
	eSEL_I2S1_RX		=	19,
	eSEL_SPI1_TX		=	20,
	eSEL_SPI1_RX		=	21,
	eSEL_AC_PCMOUT	=	22,
	eSEL_AC_PCMIN		=	23,
	eSEL_AC_MICIN		=	24,
	eSEL_PWM			=	25,
	eSEL_IRDA			=	26,
	eSEL_EXTERNAL		=	27,
	eSEL_SECU_RX		=	30,
	eSEL_SECU_TX		=	31
}DMASELECT_eID;
///////////////////////////////////


typedef struct
{
	//u32 m_uChAddr;
	//u32 m_uBaseAddr;
	volatile u32 m_uBaseAddr;
	volatile u32 m_uChAddr;
	volatile u32 m_uIntSrc;
	volatile u32 m_uChNum;
	volatile u32 m_uCodeStAddr;
	volatile u8*  m_pCodeBuf;
	volatile u32 m_uCodeOffset;
	volatile u32 m_uSecondLoopEndOffset;
	volatile u32 m_uSrcOffsetAddr;
	volatile u32 m_uDstOffsetAddr;
	volatile u32 m_uLoopCntPtr0,m_uLoopCntPtr1,m_uLoopCntPtr2;
	volatile u32 m_uFirstLoopEndOffset;
	
	volatile u8 m_bFiniteLoop;
	volatile u32 m_uLoopStOffset[2];

	//DMA_CTR_REG m_oCtrReg;

	DREQ_SRC m_eDreqSrc;
	DATA_SIZE m_eDataSz;
	DMA_TR_DIR m_eDir;
    volatile u32 m_uBurstSz;
	volatile u8 m_uDreqSrc; // 0~31
	volatile u32 m_uProtectionBit;
} DMAC;

	void Test_DMAC(void);


	void DMA_SetCh(DMA_CH eCh ,DMAC *sCh);
	void DMA_InitCh(DATA_SIZE eDataSz, DREQ_SRC eSrc, DMA_TR_DIR eDir, BURST_MODE eBurst,DMAC *sCh);
//	void DMA_StartCh(u32 uSrcAddr, u32 uDstAddr, u32 uDataCnt, DMAC *sCh);
	void DMA_StartCh(u32 uSrcAddr, u32 uDstAddr, u32 uTrByte, DMAC *sCh);
	void DMA_GenerateTransferOp(DMAC *sCh);
	void DMA_SetLoopCnt(u32 uCnt, DMAC *sCh);
	
	
	void DMA_AddTrCode(DATA_SIZE eDataSz, DREQ_SRC eSrc, DMA_TR_DIR eDir, BURST_MODE eTrMode, 
		u32 uSrcAddr,  u32 uDstAddr, u32 uDataCnt,DMAC *sCh);
//	void StartCh(void);
	void DMA_StopCh(DMAC *sCh);
	void DMA_StopDmac(DMAC *sCh);
	void DMA_Go(DMAC *sCh);
 
	//void GetCodeStAddr(u32& uCodeAddr);
	void DMA_GetCodeStAddr(u32 uCodeAddr, DMAC *sCh);
	//void DMA_GenerateTransferOp(void);
	
	

	u8 DMA_IsTransferDone(DMAC *sCh);
	u8 DMA_WaitForTrDone(DMAC *sCh);
	void DMA_ClearIntPending(u32 uIntNum,DMAC *sCh);
	void DMA_GetIntrSrc(u32 *uIntNum, DMAC *sCh);
	void DMA_GetCurSrcAddr(u32 uAddr,DMAC *sCh);
	void DMA_GetCurDstAddr(u32 uAddr, DMAC *sCh);
	void DMA_ReadPC(u32 uPc, DMAC *sCh);
	void DMA_EncodeDmaMoveChCtrl(DMAC *sCh);
	void DMA_EncodeDmaMove(u8 bSrcDir, u32 uStAddr, DMAC *sCh);
	void DMA_EncodeDmaLoad(DMAC *sCh);
	void DMA_EncodeDmaLoadPeri(DMAC *sChd);
	void DMA_EncodeDmaStore(DMAC *sCh);
	void DMA_EncodeDmaStorePeri(DMAC *sCh);
	void DMA_EncodeDmaStoreZero(DMAC *sCh);
	void DMA_EncodeDmaLoop(u8 uLoopCnt, u8 uIteration, DMAC *sCh);
	void DMA_EncodeDmaLoopForever(u8 uLoopCnt, DMAC *sCh);
	void DMA_EncodeDmaLoopEnd(u8 uLoopCnt,DMAC *sCh);
	void DMA_EncodeDmaWaitForPeri(DMAC *sCh);
	void DMA_EncodeDmaWaitForEvent(u8 uEventNum, DMAC *sCh) ;
	void DMA_EncodeDmaFlushPeri(DMAC *sCh);
	void DMA_EncodeDmaEnd(DMAC *sCh);
	void DMA_EncodeDmaAddHalfword(u8 bSrcDir, u16 uStAddr, DMAC *sCh);
	void DMA_EncodeDmaKill(DMAC *sCh);
	void DMA_EncodeDmaNop(DMAC *sCh);
	void DMA_EncodeDmaReadMemBarrier(DMAC *sCh);
	void DMA_EncodeDmaSendEvent(u8 uEventNum, DMAC *sCh) ;
	void DMA_EncodeDmaWriteMemBarrier(DMAC *sCh);
	void DMA_AddTrCode(	DATA_SIZE eDataSz, DREQ_SRC eSrc, DMA_TR_DIR eDir, BURST_MODE eTrMode,u32 uSrcAddr, u32 uDstAddr, u32 uDataCnt,DMAC *sCh);
	void DMA_AddEventCode(u8 uEventNum, DMAC *sCh);
	void DMA_AddTr_StartCh(DMAC *sCh);
	void DMA_CopyMem(DATA_SIZE eDataSz, BURST_MODE eTrMode, u32 uSrcAddr, u32 uDstAddr, u32 uDataCnt, DMAC *sCh);
	void DMA_GetCodeStAddr(u32 uCodeAddr, DMAC *sCh);
	
	
	extern u32 m_uBaseAddr;
	extern u32 m_uIntSrc;
	extern u32 m_uChAddr;
	extern u32 m_uChNum;
	extern u32 m_uCodeStAddr;
	extern u8*  m_pCodeBuf;
	extern u32 m_uCodeOffset;
	extern u32 m_uSecondLoopEndOffset;
	extern u32 m_uSrcOffsetAddr;
	extern u32 m_uDstOffsetAddr;
	extern u32 m_uLoopCntPtr0,m_uLoopCntPtr1,m_uLoopCntPtr2;
	extern u32 m_uFirstLoopEndOffset;
	
	extern u8 m_bFiniteLoop;
	extern u32 m_uLoopStOffset[2];

	//DMA_CTR_REG m_oCtrReg;

	extern DREQ_SRC m_eDreqSrc;
	extern DATA_SIZE m_eDataSz;
	extern DMA_TR_DIR m_eDir;
	extern u32 m_uBurstSz;
	extern u8 m_uDreqSrc; // 0~31
	extern u32 m_uProtectionBit;

//};

#ifdef __cplusplus
}
#endif

#endif //__DMC_H__


