#ifndef __VP_H__
#define __VP_H__

#ifdef __cplusplus
extern "C" {
#endif

#define VP_MAX_FRM_BUF_NUM 32
#define VP_SD_H_SZ 720
#define VP_SD_V_SZ 480
#define VP_SD_PAL_H_SZ 720
#define VP_SD_PAL_V_SZ 576
#define VP_HD_H_SZ 1920
#define VP_HD_V_SZ 1080

#define ENDIAN_LITTLE	1
#define ENDIAN_BIG		0

//added by rb1004...090102
#define VP_SRCSIZE_MIN_H		(32)
#define VP_SRCSIZE_MIN_V		(4)
	
typedef enum VP_FILTER_H_PP {
	/* Don't change the order and the value */
	VP_PP_H_NORMAL = 0,
	VP_PP_H_8_9,		/* 720 to 640 */
	VP_PP_H_1_2,
	VP_PP_H_1_3,
	VP_PP_H_1_4
}VP_eFILTER_H_PP;

typedef enum VP_FILTER_V_PP {
	/* Don't change the order and the value */
	VP_PP_V_NORMAL = 0,
	VP_PP_V_5_6,		/* PAL to NTSC */
	VP_PP_V_3_4,
	VP_PP_V_1_2,
	VP_PP_V_1_3,
	VP_PP_V_1_4
}VP_eFILTER_V_PP;

typedef enum VP_SHARPNESS {
	NO_EFFECT, MIN_EDGE, MODERATE_EDGE, MAX_EDGE
}VP_eSHARPNESS;

typedef enum VP_PP_LINEEQ_VAL {
	VP_PP_LINEEQ_0 = 0,
	VP_PP_LINEEQ_1,
	VP_PP_LINEEQ_2,
	VP_PP_LINEEQ_3,
	VP_PP_LINEEQ_4,
	VP_PP_LINEEQ_5,
	VP_PP_LINEEQ_6,
	VP_PP_LINEEQ_7,
	VP_PP_LINEEQ_ALL
}VP_ePP_LINEEQ_VAL;

typedef enum VP_CSC_TYPE{
	SD_TO_HD, HD_TO_SD
}VP_eCSC_TYPE;

typedef enum VP_Y_OFFSET{ // Ref. to manual p.37-45
	MINUS16, ZERO
}VP_eY_OFFSET;

typedef enum VP_SRC_X_POS_FRACTION_STEP
{
	STEP0 = 0, // 0/16 = 0
	STEP1, // 1/16 = 0.0625
	STEP2, // 2/16 = 0.125
	STEP3, // 3/16 = 0.1875
	STEP4, // 4/16 = 0.25
	STEP5, // 5/16 = 0.3125
	STEP6, // 6/16 = 0.375
	STEP7, // 7/16 = 0.4375
	STEP8, // 8/16 = 0.5
	STEP9, // 9/16 = 0.5625
	STEP10, // 10/16 = 0.625
	STEP11, // 11/16 = 0.6875
	STEP12, // 12/16 = 0.75
	STEP13, // 13/16 = 0.8125
	STEP14, // 14/16 = 0.875
	STEP15 // 15/16 = 0.9375
}VP_eSRC_X_POS_FRACTION_STEP;

typedef enum VP_FIELD_TYPE
{
	VP_TOP_FIELD, VP_BOTTOM_FIELD
}VP_eFIELD_TYPE;

////////////////////////////////////////////////
// Source Image Processing Infomation
////////////////////////////////////////////////
typedef struct VP_xSource
{
	IMG_FMT 	eSrcBpp;
	u32 		uSrcStAddr;
	u32 		uTopYAddr[VP_MAX_FRM_BUF_NUM];
	u32 		uBotYAddr[VP_MAX_FRM_BUF_NUM];	
	u32 		uTopCAddr[VP_MAX_FRM_BUF_NUM];
	u32 		uBotCAddr[VP_MAX_FRM_BUF_NUM];		
	u32 		uImgHsz;
	u32 		uImgVsz;
	u32 		uSrcXPos;
	u32 		uSrcYPos;
	u32 		uSrcHsz;
	u32 		uSrcVsz; 
	u32 		uSrcNumOfFrm;	
	u32 		uLastFrmBufIdx;	
	VP_eSRC_X_POS_FRACTION_STEP eStep;	
}oVP_Source;

extern oVP_Source oVP_SrcInf;

////////////////////////////////////////////////
// Destination Image Processing Infomation
////////////////////////////////////////////////	
typedef struct VP_xDestination
{
	SCAN_MODE 	eScanMode;
	u32 			uOrgDstHsz;
	u32 			uOrgDstVsz;	
	u32 			uDstXPos;
	u32 			uDstYPos;
	u32 			uDstHsz;
	u32 			uDstVsz; 
	IMG_RESOLUTION 	eImgSz;
}oVP_Destination;

//extern oVP_Destination oVP_DstInf;

////////////////////////////////////////////////
// Variable Structure(Control, Source, Destination, Enhancing)
////////////////////////////////////////////////
typedef struct VP_xControlVariable
{
	u32 uModeVal;
	u32 uLineEqVal;
	u32 uScanConversionIdx;
}oVP_ControlVariable;

#if 0
typedef struct VP_xSourceVariable
{
	IMG_FMT 	eInImgBpp;
	u32 		uLastFrmBufIdx;
	u32 		uTopYAddr[VP_MAX_FRM_BUF_NUM];
	u32 		uBotYAddr[VP_MAX_FRM_BUF_NUM];	
	u32 		uTopCAddr[VP_MAX_FRM_BUF_NUM];
	u32 		uBotCAddr[VP_MAX_FRM_BUF_NUM];	
	u32 		uImgHsz;
	u32 		uImgVsz;
	u32 		uSrcHsz;
	u32 		uSrcVsz;
	u32		uSrcXPos;
	u32 		uSrcYPos;
}oVP_SourceVariable;

typedef struct VP_xDestinationVariable
{
	SCAN_MODE 	eOutScanMode;
	u32 			uOrgDstHsz;
	u32 			uOrgDstVsz;
	u32 			uDstHsz;
	u32 			uDstVsz;
	u32 			uDstXPos;
	u32 			uDstYPos;
	IMG_RESOLUTION 	eImgSz;
}oVP_DestinationVariable;
#endif

typedef struct VP_xEnhancingVariable
{
	u32 				aContrast[8];
	u32				aBrightness[8];
	u32				uSaturation;
	VP_eSHARPNESS	eSharpness;
	u32				uThHnoise;
	u32				uBrightOffset;
}oVP_EnhancingVariable;
//////////////////////////////////////////////////


void VP_InitIP(oVP_Source oVp_Src, oVP_Destination oVp_Dst);
void VP_CalcImageSize(oVP_Source oVp_Src, u32 *uYSize, u32 *uCSize);
void VP_SetModeAndImgSize(oVP_Source oVp_Src, oVP_Destination oVp_Dst, u32 uYSize, u32 uCSize);
void VP_SetCroppingSize(	u32 uXPos, u32 uYPos, u32 uCroppedHsz, u32 uCroppedVsz, VP_eSRC_X_POS_FRACTION_STEP eStep);
void VP_SetViewPosition(u32 uXPos, u32 uYPos, u32 uViewHsz, u32 uViewVsz);
void VP_StartProcessing(u32 uFrmBufIdx);
u8 	VP_IsProcessingDone(void);
void VP_SetActiveFrameBuf(u32 uFrmBufIdx);
void VP_SetPostProcessingOnOff(u32 uOnOff);
void VP_SetCscOnOff(VP_eCSC_TYPE eCscType, VP_eY_OFFSET eYOffset, u32 uOnOff);
void VP_SWReset(void);
void VP_EnableIP(u32 uOnOff);
void VP_SetEndianMode(u32 uLittleBig);
void VP_InitEnhancingParameter(void);
void VP_SetContrast(u32 *uContrast);
void VP_SetBrightness(u32 *uBrightness);
void VP_SetBrightOffset(u32 uOffset);
void VP_SetSaturation(u32 uSaturation);
void VP_SetSharpness(VP_eSHARPNESS eSharpness, u32 uThreshold);
void VP_SetFilter(void);
void VP_SetPolyPhaseFilterSet(VP_eFILTER_H_PP eHFilter, VP_eFILTER_V_PP eVFilter);
void VP_SetPolyPhaseFilter(volatile u32 uFilterReg, const s8* sFilterCoef, u16 usTapSz);
void VP_SetStartAddress(u32 uTopYAddr, u32 uTopCAddr, u32 uBotYAddr, u32 uBotCAddr);

#ifdef __cplusplus
}
#endif


#endif
