#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "system.h"
#include "library.h"
#include "sysc.h"
#include "util.h"
#include "mixer.h"
#include "sdout.h"
#include "vp_v210.h"
#include "fimc.h"
#include "timer.h"
#include "glib.h"
#include "tvout_common.h"
#include "hdmi.h"
#include "phy.h"
#include "intc.h"
#include "option.h"
#include "sdout_stream.h"
#include "sblock.h"

//static bool bUsbStorage;

static TV_STANDARDS eTvStd;
static SDOUT_VIDEO_SIGNAL eVideoSig;
static SCAN_MODE eScanMode;
static IMG_RESOLUTION eImgSz;

extern oVP_Source 		oVP_SrcInf;
extern oVP_Destination 		oVP_DstInf;
extern oMX_Source		oMx_SrcInf[2];
extern oMX_Destination		oMx_DstInf[2];

extern volatile int g_TVENC;

u32 uFreeMemBufStAddr=CODEC_MEM_ST;

static u32 gCC_Data_cnt =0;
static CMMFile_st gCC_data = {"../stream/sdout/ClosedCaption.dat", 3690};


typedef struct
{
	const char * pDesc;
	TV_STANDARDS eType;
} TV_TYPE;


#if 0
static void Isr_Sdout(void)
{
	SDOUT_INTR_SRC eSrc;
	TVENC_GetIntrSrc(eSrc);

	TVENC_ClearIntPending(eSrc);
//	oIntc.ClearPending(INT_TVENC);
}
#endif

void FIMC_CSC_Scaling_forSDTV(u32 srcAddr,u32 dstAddr,
	u32 srcFullWidth,u32 srcFullHeight,u32 dstFullWidth,u32 dstFullHeight,
	IMG_FMT srcColor, IMG_FMT dstColor)
{

	u32 udstHeight;
	CSC_EQUATION eCscEq;
	YCBCR_RANGE eYuvRange;
	//IMG_FMT	eSrcImgType_Temp;
	
	//CI_ColorSpaceConversion(	srcAddr, dstAddr,
	//							srcFullWidth, srcFullHeight, dstFullWidth, dstFullHeight,
	//							srcColor, dstColor);		
	
	eCscEq = CSC_ITU601;
	eYuvRange = YCBCR_NARROW;
#if 0
	eSrcImgType_Temp = dstColor;
   	if(dstColor == NV12_IW)
		eSrcImgType_Temp = NV12;
	else if(dstColor == TILE_NV12_IW)
		eSrcImgType_Temp = TILE_NV12;

	FIMC_ColorSpaceConversion(	srcAddr, dstAddr,
								srcFullWidth, srcFullHeight, dstFullWidth, dstFullHeight,
								srcColor, eSrcImgType_Temp, eCscEq, eYuvRange);		
#endif
#if 1
	if( (dstColor == NV12_IB) || (dstColor == TILE_NV12_IB) )
	{
		udstHeight = dstFullHeight/2;
	}
	else
	{
		udstHeight = dstFullHeight;
	}

	//FIMC_SetChA();

	FIMC_InitIpForDinDout(FIMC_A,
		srcFullWidth, srcFullHeight,0,
		0, 0, srcFullWidth, srcFullHeight,
		srcAddr, srcColor,
		dstFullWidth, dstFullHeight,
		0, 0, dstFullWidth, dstFullHeight,0, // Scaler	
		dstAddr, dstColor,		
		ROT_NO_FLIP_NO, eCscEq, eYuvRange, false);
	

	FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
	FIMC_WaitForProcessingDone(FIMC_A);	
	FIMC_StopProcessing(FIMC_A);
#endif
}

void FIMC_CSC_Scaling_forSDTV_709(u32 srcAddr,u32 dstAddr,
	u32 srcFullWidth,u32 srcFullHeight,u32 dstFullWidth,u32 dstFullHeight,
	IMG_FMT srcColor, IMG_FMT dstColor)
{

	CSC_EQUATION eCscEq;
	YCBCR_RANGE eYuvRange;
	u32 udstHeight;
	//CI_ColorSpaceConversion(	srcAddr, dstAddr,
	//							srcFullWidth, srcFullHeight, dstFullWidth, dstFullHeight,
	//							srcColor, dstColor);		
	
	eCscEq = CSC_ITU709;
	eYuvRange = YCBCR_WIDE;
	if( (dstColor == NV12_IB) || (dstColor == TILE_NV12_IB) )
	{
		udstHeight = dstFullHeight/2;
	}
	else
	{
		udstHeight = dstFullHeight;
	}

	//FIMC_SetChA();

	FIMC_InitIpForDinDout(FIMC_A,
		srcFullWidth, srcFullHeight,0,
		0, 0, srcFullWidth, srcFullHeight,
		srcAddr, srcColor,
		dstFullWidth, dstFullHeight,
		0, 0, dstFullWidth, dstFullHeight,0, // Scaler	
		dstAddr, dstColor,		
		ROT_NO_FLIP_NO, eCscEq, eYuvRange, false);
	

	FIMC_StartProcessing(FIMC_A, false, 0, 0, false, 0);
	FIMC_WaitForProcessingDone(FIMC_A);	
	FIMC_StopProcessing(FIMC_A);

}

// [InitBaseHWForSdout]
void InitBaseHWForSdout(void)
{
	u32 uTemp;

	#if 0
	// PMU Block : HDMI PHY Enable
	//uTemp = Inp32(0xE010E804);
	//uTemp |= (1<<0);
	//Outp32(0xE010E804, uTemp);
	
	// CMU Block : DAC_SEL(SCLK_DAC/TVENC) - 0 : SCLKVPLL,  1 : SCLK_HDMIPHY
	uTemp = Inp32(0xe0100204);
	uTemp &= ~(1<<8);
	Outp32(0xe0100204, uTemp);
	
	// CMU Block : MIXER_SEL(SCLK_MIXER) - 0 : SCLK_DAC/TVENC,  1 : SCLK_HDMI
	uTemp = Inp32(0xe0100204);
	uTemp &= ~(1<<4);
	Outp32(0xe0100204, uTemp);
	
	// Set DAC Enable
	uTemp = Inp32(0xe010e810);
	uTemp|= (1<<0);
	Outp32(0xe010e810, uTemp);
	#endif
	//Set VPLL to 54MHz
	SYSC_StartPLLbyFout(eVPLL, 54000000);
	
	// DAC_SEL : SCLKVPLL

	SYSC_SetClkMuxState(eCLKMUX_MIXER_SDAC);
	SYSC_SetClkON_IP(eTVENC);
	SYSC_EnDAC();

		// T-Block Power Off and On
	SYSC_SetBlockPowerOFF_IP(eTVENC);
	DelayfrTimer(milli, 500);
	SYSC_SetBlockPowerON_IP(eTVENC);
#if 1
	// IP Clock Off and On
	SYSC_SetClkOFF_IP(eVP);
	SYSC_SetClkOFF_IP(eMIXER);
	SYSC_SetClkOFF_IP(eTVENC);
	DelayfrTimer(milli, 100);
	SYSC_SetClkON_IP(eVP);
	SYSC_SetClkON_IP(eMIXER);
	SYSC_SetClkON_IP(eTVENC);	
#endif
	
}


void SDMXT_InitParaForTV(void)
{
	u32 i;

	for(i=0 ; i<2 ; i++)
	{
		oMx_SrcInf[i].eBpp = RGB16;
		oMx_SrcInf[i].uImgHsz = SD480_HSIZE;
		oMx_SrcInf[i].uSrcXPos = 0;
		oMx_SrcInf[i].uSrcYPos = 0;
		oMx_SrcInf[i].uSrcHsz = SD480_HSIZE;
		oMx_SrcInf[i].uSrcVsz = SD480_VSIZE;

		oMx_DstInf[i].uDstXPos = 0;
		oMx_DstInf[i].uDstYPos = 0;
		oMx_DstInf[i].uOutSel = 0;
	}
}

void SDVPT_InitParaForTV(IMG_FMT eImgType)
{
	u32 uImgSize_H, uImgSize_V;

	if(eImgSz == SD480)
	{
		uImgSize_H = SD480_HSIZE;
		uImgSize_V = SD480_VSIZE;
	}
	else
	{
		uImgSize_H = SD576_HSIZE;
		uImgSize_V = SD576_VSIZE;
	}
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eImgType;
	oVP_SrcInf.uImgHsz = uImgSize_H;
	oVP_SrcInf.uImgVsz = uImgSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uImgSize_H;
	oVP_SrcInf.uSrcVsz=uImgSize_V;
	oVP_SrcInf.uSrcNumOfFrm = 1;
	oVP_SrcInf.eStep = STEP0;

	oVP_DstInf.eScanMode = eScanMode;
	oVP_DstInf.uOrgDstHsz = uImgSize_H;
	oVP_DstInf.uOrgDstVsz = uImgSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImgSize_H;
	oVP_DstInf.uDstVsz = uImgSize_V;	
	oVP_DstInf.eImgSz = eImgSz;
}



static void SDVp_ChangeNV12toNV12IB(u32 uVpSrcAddr, u32 uSizeH, u32 uSizeV)
{
	u32 i,j;
	u8 *pBuffer, *pTempBuf, *pAllocBuf;
	u32 uYtopAddr, uCtopAddr, uYbotAddr, uCbotAddr;

	pAllocBuf = malloc(uSizeH*uSizeV+uSizeH*uSizeV/2);
	pTempBuf = pAllocBuf;
	
	pBuffer = (u8 *)uVpSrcAddr;

	uYtopAddr = uVpSrcAddr;
	uCtopAddr = uVpSrcAddr + uSizeH*uSizeV/2;
	uYbotAddr = uVpSrcAddr + uSizeH*uSizeV/2 + uSizeH*uSizeV/4;
	uCbotAddr = uVpSrcAddr + uSizeH*uSizeV/2 + uSizeH*uSizeV/4 + uSizeH*uSizeV/2;

	for(i=0 ; i<(uSizeH*uSizeV+uSizeH*uSizeV/2) ; i++)
		*pTempBuf++ = *pBuffer++;

	pTempBuf = pAllocBuf;

	pBuffer = (u8 *)uYtopAddr;
	for(i=0 ; i<uSizeV/2 ; i++)
		for(j=0 ; j<uSizeH ; j++)
			*(u8 *)(pBuffer+(uSizeH*i + j)) = *(u8 *)(pTempBuf + (uSizeH*2*i + j));

	pBuffer = (u8 *)uCtopAddr;
	for(i=0 ; i<uSizeV/4 ; i++)
		for(j=0 ; j<uSizeH ; j++)
			*(u8 *)(pBuffer+(uSizeH*i + j)) = *(u8 *)(pTempBuf + (uSizeH*uSizeV + uSizeH*2*i + j));

	pBuffer = (u8 *)uYbotAddr;
	for(i=0 ; i<uSizeV/2 ; i++)
		for(j=0 ; j<uSizeH ; j++)
			*(u8 *)(pBuffer+(uSizeH*i + j))= *(u8 *)(pTempBuf + (uSizeH*2*i + j + uSizeH ));	

	pBuffer = (u8 *)uCbotAddr;
	for(i=0 ; i<uSizeV/4 ; i++)
		for(j=0 ; j<uSizeH ; j++)
			*(u8 *)(pBuffer+(uSizeH*i + j)) = *(u8 *)(pTempBuf + (uSizeH*uSizeV + uSizeH*2*i + j + uSizeH));
}

static void SDVpMx_DownImageForVP(	IMG_RESOLUTION eImageSize, u32 uBMPSrcAddr, u32 uRGBSrcAddr, u32 uVpSrcAddr,
											IMG_FMT eSrcImgType, u32 *uImageSize_H, u32 *uImageSize_V, MX_RGB_FORMAT eMxOutRgb)
{
	oDownImage_Inform 	oDownImg;
	
	if(eImageSize == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		*uImageSize_H = SD480_HSIZE;
		*uImageSize_V = SD480_VSIZE;			
#if 1
		oDownImg.pImagePath = pTest_Image[BMP_720x480];

	if(eSrcImgType == NV12_IB)
		oDownImg.pImagePath =  pResol_NV12_IB[BMP_720x480];
	else	 if (eSrcImgType == TILE_NV12_IB)
		oDownImg.pImagePath = pResol_TILE_NV12_IB[BMP_720x480];	
#else
		if( (eSrcImgType == NV12) || (eSrcImgType== NV12_IW) )
			oDownImg.pImagePath = pResolution_Image[BMP_720x480];
		//	oDownImg.pImagePath = pTest_Image[BMP_720x480];
		else	 if (eSrcImgType == NV12_IB)
			oDownImg.pImagePath = pResol_NV12_IB[BMP_720x480];
		else if( (eSrcImgType == TILE_NV12) || (eSrcImgType== TILE_NV12_IW) )
			oDownImg.pImagePath = pResol_TILE_NV12[BMP_720x480];
		else	 if (eSrcImgType == TILE_NV12_IB)
			oDownImg.pImagePath = pResol_TILE_NV12_IB[BMP_720x480];	
		else
			Assert(0);
#endif
	}
	else if(eImageSize == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		*uImageSize_H = SD576_HSIZE;
		*uImageSize_V = SD576_VSIZE;			
#if 1		
		oDownImg.pImagePath = pTest_Image[BMP_720x576];

	if(eSrcImgType == NV12_IB)
		oDownImg.pImagePath =  pResol_NV12_IB[BMP_720x576];
	else	 if (eSrcImgType == TILE_NV12_IB)
		oDownImg.pImagePath = pResol_TILE_NV12_IB[BMP_720x576];	
#else
		if( (eSrcImgType == NV12) || (eSrcImgType== NV12_IW) )
			oDownImg.pImagePath = pResolution_Image[BMP_720x576];	//NV12
			//oDownImg.pImagePath = pTest_Image[BMP_720x576];	
		else	 if (eSrcImgType == NV12_IB)
			oDownImg.pImagePath = pResol_NV12_IB[BMP_720x576];
	///		oDownImg.pImagePath = pResol_NV12[BMP_720x576];
		else if( (eSrcImgType == TILE_NV12) || (eSrcImgType== TILE_NV12_IW) )
			oDownImg.pImagePath = pResol_TILE_NV12[BMP_720x576];
		else	 if (eSrcImgType == TILE_NV12_IB)
			oDownImg.pImagePath = pResol_TILE_NV12_IB[BMP_720x576];	
	///		oDownImg.pImagePath = pResol_TILE_NV12[BMP_720x576];
		else
			Assert(0);		
#endif
	}	
	else
	{
		UART_Printf("Not supported image size..\n");
		Assert(0);
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
#if 1
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, *uImageSize_H, *uImageSize_V);
		if (eMxOutRgb ==RGB601_16_235)
		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, *uImageSize_H,*uImageSize_V,*uImageSize_H,*uImageSize_V,
								RGB888, eSrcImgType);
		else if (eMxOutRgb == RGB709_0_255)
		FIMC_CSC_Scaling_forSDTV_709(uRGBSrcAddr, uVpSrcAddr, *uImageSize_H,*uImageSize_V,*uImageSize_H,*uImageSize_V,
								RGB888, eSrcImgType);		
	}
	else
	{
		UART_Printf("Fail to load image\n");	
		Assert(0);
	}
#endif

	if((eSrcImgType == NV12_IB)||(eSrcImgType == TILE_NV12_IB))
		LoadFromFile((const char *)oDownImg.pImagePath, uVpSrcAddr);	
#else
	//LoadFromFile((const char *)oDownImg.pImagePath, uVpSrcAddr);

///	if (eSrcImgType == NV12_IB)
///		SDVp_ChangeNV12toNV12IB(uVpSrcAddr, *uImageSize_H, *uImageSize_V);


#endif	
}


static void SDVpMx_DrawGraphicForMixer(u32 uWin0StAddr, u32 uWin1StAddr, IMG_FMT eSrcImgType)
{
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	//GLIB_DrawPattern_Blue(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_InitFont();
	GLIB_Printf(90,160, "Window 0");
	
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_Printf(90,160, "Window 1");
}

static void SDVpMx_VPSettingForTest(u32 uVpSrcAddr, IMG_FMT eImgType)
{
	SDVPT_InitParaForTV(eImgType);

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
}


static void SDVp_ChangeImageEndianMode(oVP_Source oVp_Src)
{
	u32 i, j, uYSize, uCSize;
	u8 pBuffer[8];
	u8 *pSrcBuf;
	
	VP_CalcImageSize(oVp_Src, &uYSize, &uCSize);
	pSrcBuf = (u8 *)oVp_Src.uSrcStAddr;
	
	for(i=0 ; i<uYSize+uCSize ; i+=8)
	{
		for(j=0 ; j<8 ; j++)
			pBuffer[j] =  *(pSrcBuf+j);
		for(j=0 ; j<8 ; j++)
			*(pSrcBuf+j) = pBuffer[7-j];
		pSrcBuf += 8;		
	}
}

static void SDMx_ChangeImageEndianMode(oMX_Source oMx_SrcInf)
{
	u32 i, j;
	u16 pBuffer16[4];
	u32 pBuffer32[2];
	u16 *pSrcBuf16;
	u32 *pSrcBuf32;

	if(oMx_SrcInf.eBpp == ARGB8888)
	{
		pSrcBuf32 = (u32 *)oMx_SrcInf.uFbStAddr;
		for(i=0 ; i<(oMx_SrcInf.uSrcHsz*oMx_SrcInf.uSrcVsz*4) ; i+=8)
		{
			for(j=0 ; j<2 ; j++)
				pBuffer32[j] =  *(pSrcBuf32+j);
			for(j=0 ; j<2 ; j++)
				*(pSrcBuf32+j) = pBuffer32[1-j];
			pSrcBuf32 += 2;		
		}
	}
	else if( (oMx_SrcInf.eBpp == ARGB4444) || (oMx_SrcInf.eBpp == ARGB1555) ||  (oMx_SrcInf.eBpp == RGB565) )
	{
		pSrcBuf16 = (u16 *)oMx_SrcInf.uFbStAddr;
		for(i=0 ; i<(oMx_SrcInf.uSrcHsz*oMx_SrcInf.uSrcVsz*2) ; i+=8)
		{
			for(j=0 ; j<4 ; j++)
				pBuffer16[j] =  *(pSrcBuf16+j);
			for(j=0 ; j<4 ; j++)
				*(pSrcBuf16+j) = pBuffer16[3-j];
			pSrcBuf16 += 4;		
		}
	}
	else
	{
		Assert(0);
	}
}


static void SDVpMx_MixerSettingForTest(u32 uWin0StAddr, u32 uWin1StAddr, IMG_FMT eSrcImgType)
{
	SDMXT_InitParaForTV();

	// Mixer setting
	UART_Printf("Video Layer Displayed\n");
	
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	
	UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
///	oMx_DstInf[0].uDstXPos = 0;
///	oMx_DstInf[0].uDstYPos = 0;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);

	MIXER_SetVideoLimiterOnOff(0xeb, 0x10, 0xf0, 0x10, 1);
	MIXER_SetRGBColorFormat(MX_YUV444, RGB601_16_235);
}


//
u32 SDMXT_SimpleDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[MXT_SimpleDisplay]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 		1 : ARGB1555,		2 : ARGB4444,		3 : ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>3)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : ARGB8888;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( (eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)||(eSrcImgType==ARGB8888) );
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;
	uWin1StAddr = uWin0StAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		return 0;
	}

#if 0

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	

#endif

	// Graphic layer
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_InitFont();
	GLIB_Printf(90,160, "Window 0");
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_Printf(90,160, "Window 1");
#if 0	
	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);


	// Mixer setting
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
#endif	

	// VP Setting
//	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
//	VP_InitIP(oVP_SrcInf, oVP_DstInf);



	// Mixer setting
//	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);

//	VP_EnableIP(1);
	MIXER_StartProcessing();

	UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);
	//MIXER_SetGrphWinOnOff(MX_WIN0, 0);

	UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);
	//MIXER_SetGrphWinOnOff(MX_WIN1, 0);
	
	// TV On
	TVENC_SetOnOff(1);

	// Waiting
	UART_Getc();

	//TV Off
	VP_EnableIP(0);
//	MIXER_SetVdWinOnOff(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


void SDMXT_PerPlaneBlending(void)
{
	u32 i;

	UART_Printf("[MXT_PerPlaneBlending]\n");	
	
	UART_Printf("Video Layer Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 50);
	}	
	MIXER_SetVdBlendingOnOff(0, 0);
	UART_Printf("\n\n");	
	INPUT_DELAY;

	UART_Printf("Graphic Layer 0 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	UART_Printf("\n\n");
	INPUT_DELAY;

	UART_Printf("Graphic Layer 1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	UART_Printf("\n\n");
	INPUT_DELAY;

	UART_Printf("Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	UART_Printf("\n\n");	
}


void SDMXT_PerPixelBlending(void)
{
	UART_Printf("[MXT_PerPixelBlending]\n");	

	UART_Printf("Graphic Layer 0 Pixel Blending\n");	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 1 Pixel Blending\n");	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 0/1 Pixel Blending\n");	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	
}


void SDMXT_PerPixelAndPremulBlending(void)
{
	UART_Printf("[MXT_PerPixelAndPremulBlending]\n");	

	UART_Printf("Graphic Layer 0 Pixel Blending\n");	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 1 Pixel Blending\n");	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 0/1 Pixel Blending\n");	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	
}


void SDMXT_PerPlaneAndPixelBlending(void)
{
	u32 i;
	
	UART_Printf("[MXT_PerPlaneAndPixelBlending]\n");	
	
	UART_Printf("Video Layer Alpha Value : (90~255)\n");	
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 100);
	}	
	MIXER_SetVdBlendingOnOff(0, 0);
	UART_Printf("\n");	
	INPUT_DELAY;

	UART_Printf("Graphic Layer 0 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 100);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	UART_Printf("\n");
	INPUT_DELAY;

	UART_Printf("Graphic Layer 1 Alpha Value : (0~255)\n");	
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 100);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");
	INPUT_DELAY;		

	UART_Printf("Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 100);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");
}


void SDMXT_PerPlaneAndPixelAndPremulBlending(void)
{
	u32 i;
	
	UART_Printf("[MXT_PerPlaneAndPixelAndPremulBlending]\n");	

	UART_Printf("Video Layer Alpha Value : (0~255)\n");	
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 100);
	}	
	MIXER_SetVdBlendingOnOff(0, 0);
	UART_Printf("\n");	
	INPUT_DELAY;

	UART_Printf("Graphic Layer 0 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 100);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	UART_Printf("\n");
	INPUT_DELAY;

	UART_Printf("Graphic Layer 1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 100);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");
	INPUT_DELAY;

	UART_Printf("Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 100);
	}
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	
	INPUT_DELAY;

	UART_Printf("Video Layer & Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i++)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 100);
	}
	MIXER_SetVdBlendingOnOff(i, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	
}


// Return		: 	1 - Condition is matched
//					0 - Condition is not matched
u32 SDMXT_CheckBlendingCondition(IMG_FMT eImgFmt, MX_BLD_TYPE eBlendType)
{
	if(eImgFmt == RGB16)
	{
		if(eBlendType == MX_PER_PLANE)
			return 1;
	}
	else if((eImgFmt == ARGB1555)||(eImgFmt == ARGB4444)||(eImgFmt == ARGB8888))
	{
		if((eBlendType == MX_PER_PLANE)||(eBlendType == MX_PER_PIX)||(eBlendType == MX_PER_PLANE_PIX))
			return 1;
	}
	else if(eImgFmt == PRE_ARGB8888)
	{
		if((eBlendType == MX_PER_PMUL_PIX)||(eBlendType == MX_PER_PLANE_PIX_PMUL))
			return 1;
	}
	else
	{}

	UART_Printf(">>Image Format is not matched with the blending Type\n");
	return 0;
}


u32 SDMXT_Blending(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp, uLayOrd_Temp, uBlend_Temp;
	IMG_FMT eSrcImgType;
	MIXER_WIN_ORDER eLayOrder;
	MX_BLD_TYPE eBlendType;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[MXT_Blending]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 	1 : ARGB1555,	2 : ARGB4444,	3 : ARGB8888, 	4 : PRE_ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>4)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : 
						(uSrcImgType_Temp == 3)? ARGB8888 : PRE_ARGB8888;

		UART_Printf("Select the Layer order\n");
		UART_Printf("0 : VDW0W1(D), 		1 : VDW1W0,		2 : W0VDW1,		3 : W0W1VD\n");
		UART_Printf("4 : W1VDW0, 		5 : W1W0VD\n");
		uLayOrd_Temp = UART_GetIntNum();
		if(uLayOrd_Temp>5)
			uLayOrd_Temp = 0;

		eLayOrder = 		(uLayOrd_Temp  == 0)? DN_VDW0W1_UP :
						(uLayOrd_Temp  == 1)? DN_VDW1W0_UP :
						(uLayOrd_Temp  == 2)? DN_W0VDW1_UP :
						(uLayOrd_Temp  == 3)? DN_W0W1VD_UP :
						(uLayOrd_Temp  == 4)? DN_W1VDW0_UP : DN_W1W0VD_UP;

		UART_Printf("Select the Blending Type\n");
		UART_Printf("0 : Per plane(D), 		1 : Per pixel,		2 : Per premul+pixel\n");
		UART_Printf("3 : Per plane+pixel,		4 : Per plane+pixel+premul\n");
		uBlend_Temp = UART_GetIntNum();
		if(uBlend_Temp>4)
			uBlend_Temp = 0;

		eBlendType = 	(uBlend_Temp  == 0)? MX_PER_PLANE :
						(uBlend_Temp  == 1)? MX_PER_PIX :
						(uBlend_Temp  == 2)? MX_PER_PMUL_PIX :
						(uBlend_Temp  == 3)? MX_PER_PLANE_PIX : MX_PER_PLANE_PIX_PMUL;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		eLayOrder = (MIXER_WIN_ORDER)oPara.Test_Parameter[1];
		eBlendType = (MX_BLD_TYPE)oPara.Test_Parameter[2];
		Assert( 	(eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)
				||(eSrcImgType==ARGB8888)||(eSrcImgType==PRE_ARGB8888) 	);
	}

	//Check the Blending condition
	if(!SDMXT_CheckBlendingCondition(eSrcImgType, eBlendType))
		return 1;
		
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;
	uWin1StAddr = uWin0StAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		return 0;
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_InitFont();
		GLIB_Printf(90,160, "Window 0");
	}
	else
		GLIB_DrawPattern_Alpha(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_Printf(90,160, "Window 1");
	}
	else
		GLIB_DrawPattern_Alpha(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);

	
	//UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	//UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(eLayOrder);	
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	//UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(eLayOrder);	
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);
	
	// TV On
	TVENC_SetOnOff(1);

	//Blending Test
	switch (eBlendType)
	{
		case	MX_PER_PLANE			:	SDMXT_PerPlaneBlending();
											break;
		case	MX_PER_PIX				:	SDMXT_PerPixelBlending();
											break;
		case	MX_PER_PMUL_PIX			:	SDMXT_PerPixelAndPremulBlending();
											break;
		case	MX_PER_PLANE_PIX		:	SDMXT_PerPlaneAndPixelBlending();
											break;
		case	MX_PER_PLANE_PIX_PMUL	:	SDMXT_PerPlaneAndPixelAndPremulBlending();
											break;
		default							: 	break;
	}	

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


u32 SDMXT_Blending_FullTest(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, j, k;
	u32 uImgCount, uLayerCount, uBlendCount;
	oFunctionT_AutoVar	oParameter;
	FullTestMenu oSrcImgType[]	 = 	{	{(u32)RGB16,	"RGB16"},
										{(u32)ARGB1555, "ARGB1555"},
										{(u32)ARGB4444, "ARGB4444"},
										{(u32)ARGB8888, "ARGB8888"},
										{(u32)PRE_ARGB8888, "PRE_ARGB8888"}	};
	FullTestMenu oLayOrder[] 		= 	{	{(u32)DN_VDW0W1_UP, "VD_W0_W1"},
										{(u32)DN_VDW1W0_UP, "VD_W1_W0"},
										{(u32)DN_W0VDW1_UP, "W0_VD_W1"},
										{(u32)DN_W0W1VD_UP, "W0_W1_VD"},
										{(u32)DN_W1VDW0_UP, "W1_VD_W0"},
										{(u32)DN_W1W0VD_UP, "W1_W0_VD"}	};
	FullTestMenu oBlendType[]		=	{	{(u32)MX_PER_PLANE, "Per Plane"},
										{(u32)MX_PER_PIX, "Per Pixel"},
										{(u32)MX_PER_PMUL_PIX, "Per Pixel & Pre_Mul"},
										{(u32)MX_PER_PLANE_PIX, "Per Pixel & Plane"},
										{(u32)MX_PER_PLANE_PIX_PMUL, "Per Pixel & Plane & Pre_Mul"}	};

	uImgCount = sizeof(oSrcImgType)/sizeof(oSrcImgType[0]);
	uLayerCount = sizeof(oLayOrder)/sizeof(oLayOrder[0]);
	uBlendCount = sizeof(oBlendType)/sizeof(oBlendType[0]);

	UART_Printf("\n\n");
	for(i=0 ; i<uImgCount ; i++)
	{
		for(j=0 ; j<uLayerCount ; j++)
		{
			for(k=0 ; k<uBlendCount ; k++)
			{
				UART_Printf(">>> Test Parameter <<<\n");
				UART_Printf("Source Image Type : %s\n", oSrcImgType[i].pString);
				UART_Printf("Window Layer Order : %s\n", oLayOrder[j].pString);
				UART_Printf("Blending Type : %s\n", oBlendType[k].pString);
				
				oParameter.Test_Parameter[0] = oSrcImgType[i].uType;
				oParameter.Test_Parameter[1] = oLayOrder[j].uType;	
				oParameter.Test_Parameter[2] = oBlendType[k].uType;
				SDMXT_Blending(eTest_Auto, oParameter);
				UART_Printf("\n");
			}
		}
	}

	return 1;

}


u32 SDMXT_Cropping(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXSize, uSrcYSize;
	u32 uWinTemp, uTempKey;
	MIXER_GRPH_WIN uWindow;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[MXT_Cropping]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Graphic Window to test\n");
		UART_Printf("0 : WIN0(D), 		1 : WIN1\n");
		uWinTemp = UART_GetIntNum();
		if(uWinTemp>1)
			uWinTemp = 0;

		uWindow = 	(uWinTemp == 0)? MX_WIN0 : MX_WIN1;
	}
	else
	{
		uWindow = (MIXER_GRPH_WIN)oPara.Test_Parameter[0];
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		return 0;
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, uImageSize_H, uImageSize_V, RGB16);
	if(uWindow == MX_WIN0)
		GLIB_DrawPattern(uImageSize_H, uImageSize_V);
	else
		GLIB_DrawPattern2(uImageSize_H, uImageSize_V);
	
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer %d is displayed\n", (u32)uWindow);
	oMx_SrcInf[uWindow].eBpp = RGB16;
	oMx_SrcInf[uWindow].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[uWindow].uImgHsz = uImageSize_H;
	oMx_SrcInf[uWindow].uSrcXPos = 0;
	oMx_SrcInf[uWindow].uSrcYPos = 0;
	oMx_SrcInf[uWindow].uSrcHsz = uImageSize_H;
	oMx_SrcInf[uWindow].uSrcVsz = uImageSize_V;

	oMx_DstInf[uWindow].uDstXPos = 0;
	oMx_DstInf[uWindow].uDstYPos = 0;
	
	MIXER_InitGrphWin(uWindow, oMx_SrcInf[uWindow], oMx_DstInf[uWindow]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(uWindow, 1);
	
	// TV On
	TVENC_SetOnOff(1);

	for(uSrcXSize=VP_SRCSIZE_MIN_H ; uSrcXSize<=uImageSize_H ; uSrcXSize+=4)
	{
		for(uSrcYSize=VP_SRCSIZE_MIN_V ; uSrcYSize<=uImageSize_V ; uSrcYSize+=4)
		{
			MIXER_SetCropping(uWindow, 0, 0, uSrcXSize, uSrcYSize, 0, 0);

			UART_Printf("Cropped Source Size : (%d,%d)\n", uSrcXSize, uSrcYSize);

			//Waiting
			//DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_SetVdWinOnOff(0);
				TVENC_SetOnOff(0);
				return 1;
			}
		}
	}

	INPUT_DELAY;
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


u32 SDMXT_SourceImgPositioning(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize;
	u32 uWinTemp, uTempKey;
	MIXER_GRPH_WIN uWindow;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[MXT_SourceImgPositioning]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Graphic Window to test\n");
		UART_Printf("0 : WIN0(D), 		1 : WIN1\n");
		uWinTemp = UART_GetIntNum();
		if(uWinTemp>1)
			uWinTemp = 0;

		uWindow = 	(uWinTemp == 0)? MX_WIN0 : MX_WIN1;
	}
	else
	{
		uWindow = (MIXER_GRPH_WIN)oPara.Test_Parameter[0];
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		return 0;
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, uImageSize_H, uImageSize_V, RGB16);
	if(uWindow == MX_WIN0)
		GLIB_DrawPattern(uImageSize_H, uImageSize_V);
	else
		GLIB_DrawPattern2(uImageSize_H, uImageSize_V);
	
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer %d is displayed\n", (u32)uWindow);
	uSrcXSize = 200;
	uSrcYSize = 150;
	oMx_SrcInf[uWindow].eBpp = RGB16;
	oMx_SrcInf[uWindow].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[uWindow].uImgHsz = uImageSize_H;
	oMx_SrcInf[uWindow].uSrcXPos = 0;
	oMx_SrcInf[uWindow].uSrcYPos = 0;
	oMx_SrcInf[uWindow].uSrcHsz = uSrcXSize;
	oMx_SrcInf[uWindow].uSrcVsz = uSrcYSize;

	oMx_DstInf[uWindow].uDstXPos = 0;
	oMx_DstInf[uWindow].uDstYPos = 0;
	
	MIXER_InitGrphWin(uWindow, oMx_SrcInf[uWindow], oMx_DstInf[uWindow]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(uWindow, 1);
	
	// TV On
	TVENC_SetOnOff(1);

	for(uSrcXPos=VP_SRCSIZE_MIN_H ; uSrcXPos<=uImageSize_H-uSrcXSize ; uSrcXPos+=2)
	{
		for(uSrcYPos=VP_SRCSIZE_MIN_V ; uSrcYPos<=uImageSize_V-uSrcYSize ; uSrcYPos+=2)
		{
			MIXER_SetCropping(uWindow, uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize, 100, 100);

			UART_Printf("Source Position : (%d,%d),  Source Size : (%d, %d)\n", uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize);

			//Waiting
			//DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_SetVdWinOnOff(0);
				TVENC_SetOnOff(0);
				return 1;
			}
		}
	}

	INPUT_DELAY;
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


u32 SDMXT_DestinationImgPositioning(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXSize, uSrcYSize;
	u32 uDstXPos, uDstYPos;
	u32 uWinTemp, uTempKey;
	MIXER_GRPH_WIN uWindow;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[MXT_DestinationImgPositioning]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Graphic Window to test\n");
		UART_Printf("0 : WIN0(D), 		1 : WIN1\n");
		uWinTemp = UART_GetIntNum();
		if(uWinTemp>1)
			uWinTemp = 0;

		uWindow = 	(uWinTemp == 0)? MX_WIN0 : MX_WIN1;
	}
	else
	{
		uWindow = (MIXER_GRPH_WIN)oPara.Test_Parameter[0];
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		return 0;
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, uImageSize_H, uImageSize_V, RGB16);
	if(uWindow == MX_WIN0)
		GLIB_DrawPattern(uImageSize_H, uImageSize_V);
	else
		GLIB_DrawPattern2(uImageSize_H, uImageSize_V);
	
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer %d is displayed\n", (u32)uWindow);
	uSrcXSize = 200;
	uSrcYSize = 150;
	oMx_SrcInf[uWindow].eBpp = RGB16;
	oMx_SrcInf[uWindow].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[uWindow].uImgHsz = uImageSize_H;
	oMx_SrcInf[uWindow].uSrcXPos = 0;
	oMx_SrcInf[uWindow].uSrcYPos = 0;
	oMx_SrcInf[uWindow].uSrcHsz = uSrcXSize;
	oMx_SrcInf[uWindow].uSrcVsz = uSrcYSize;

	oMx_DstInf[uWindow].uDstXPos = 0;
	oMx_DstInf[uWindow].uDstYPos = 0;
	
	MIXER_InitGrphWin(uWindow, oMx_SrcInf[uWindow], oMx_DstInf[uWindow]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(uWindow, 1);
	
	// TV On
	TVENC_SetOnOff(1);

	for(uDstXPos=VP_SRCSIZE_MIN_H ; uDstXPos<=uImageSize_H-uSrcXSize ; uDstXPos+=2)
	{
		for(uDstYPos=VP_SRCSIZE_MIN_V ; uDstYPos<=uImageSize_V-uSrcYSize ; uDstYPos+=2)
		{
			MIXER_SetPosition(uWindow, uDstXPos, uDstYPos);

			UART_Printf("Destination Position : (%d,%d),  Source Size : (%d, %d)\n", uDstXPos, uDstYPos, uSrcXSize, uSrcYSize);

			//Waiting
			//DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_SetVdWinOnOff(0);
				TVENC_SetOnOff(0);
				return 1;
			}
		}
	}

	INPUT_DELAY;
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


u32 SDMXT_ColorSpaceConversion(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[SDMXT_ColorSpaceConvertion]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 		1 : ARGB1555,		2 : ARGB4444,		3 : ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>3)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : ARGB8888;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( (eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)||(eSrcImgType==ARGB8888) );
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;
	uWin1StAddr = uWin0StAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		return 0;
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	
	// Graphic layer
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_InitFont();
	GLIB_Printf(90,160, "Window 0");
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_Printf(90,160, "Window 1");
	
	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);
	
	// TV On
	TVENC_SetOnOff(1);

	while(!UART_GetKey())
	{
		MIXER_SetCscVal(RGB_TO_YUV601_LR);
		DelayfrTimer(milli, 1000);
		MIXER_SetCscVal(RGB_TO_YUV601_FR);
		DelayfrTimer(milli, 1000);
		DelayfrTimer(milli, 1000); // Timer????	

		//the xvYCC CSC test must be added in HDTV
	}

	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


u32 SDMXT_Scaling(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXSize, uSrcYSize;
	u32 i, j, uWinTemp;
	MIXER_GRPH_WIN uWindow;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[MXT_Cropping]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Graphic Window to test\n");
		UART_Printf("0 : WIN0(D), 		1 : WIN1\n");
		uWinTemp = UART_GetIntNum();
		if(uWinTemp>1)
			uWinTemp = 0;

		uWindow = 	(uWinTemp == 0)? MX_WIN0 : MX_WIN1;
	}
	else
	{
		uWindow = (MIXER_GRPH_WIN)oPara.Test_Parameter[0];
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		return 0;
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	uSrcXSize = 88;
	uSrcYSize = 56;
	GLIB_InitInstance(uWin0StAddr, uSrcXSize, uSrcYSize, RGB16);
	if(uWindow == MX_WIN0)
		GLIB_DrawPattern(uSrcXSize, uSrcYSize);
	else
		GLIB_DrawPattern2(uSrcXSize, uSrcYSize);
	
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer %d is displayed\n", (u32)uWindow);
	oMx_SrcInf[uWindow].eBpp = RGB16;
	oMx_SrcInf[uWindow].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[uWindow].uImgHsz = uSrcXSize;
	oMx_SrcInf[uWindow].uSrcXPos = 0;
	oMx_SrcInf[uWindow].uSrcYPos = 0;
	oMx_SrcInf[uWindow].uSrcHsz = uSrcXSize;
	oMx_SrcInf[uWindow].uSrcVsz = uSrcYSize;

	oMx_DstInf[uWindow].uDstXPos = 0;
	oMx_DstInf[uWindow].uDstYPos = 0;
	
	MIXER_InitGrphWin(uWindow, oMx_SrcInf[uWindow], oMx_DstInf[uWindow]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(uWindow, 1);
	
	// TV On
	TVENC_SetOnOff(1);

	for(i=0 ; i<4 ; i++)
	{
		for(j=0 ; j<4 ; j++)
		{
			UART_Printf("Ratio : (X%d, X%d)\n", Pow(2, i), Pow(2, j));
			MIXER_SetScalingRatio(uWindow, (MX_SCALE_RATIO)(i), (MX_SCALE_RATIO)(j));
			INPUT_DELAY;	
		}
	}
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


u32 SDMXT_ColorKey(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V; 
	u32 uSrcImgType_Temp, uLayOrd_Temp;
	u32 aColorKey[2];
	IMG_FMT eSrcImgType;
	MIXER_WIN_ORDER eLayOrder;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[MXT_Blending]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 	1 : ARGB1555,	2 : ARGB4444,	3 : ARGB8888, 	4 : PRE_ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>4)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : 
						(uSrcImgType_Temp == 3)? ARGB8888 : PRE_ARGB8888;

		UART_Printf("Select the Layer order\n");
		UART_Printf("0 : VDW0W1(D), 		1 : VDW1W0,		2 : W0VDW1,		3 : W0W1VD\n");
		UART_Printf("4 : W1VDW0, 		5 : W0W1VD\n");
		uLayOrd_Temp = UART_GetIntNum();
		if(uLayOrd_Temp>5)
			uLayOrd_Temp = 0;

		eLayOrder = 		(uLayOrd_Temp  == 0)? DN_VDW0W1_UP :
						(uLayOrd_Temp  == 1)? DN_VDW1W0_UP :
						(uLayOrd_Temp  == 2)? DN_W0VDW1_UP :
						(uLayOrd_Temp  == 3)? DN_W0W1VD_UP :
						(uLayOrd_Temp  == 4)? DN_W1VDW0_UP : DN_W1W0VD_UP;


	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		eLayOrder = (MIXER_WIN_ORDER)oPara.Test_Parameter[1];
		Assert( (eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)||(eSrcImgType==ARGB8888) );
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;
	uWin1StAddr = uWin0StAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		return 0;
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{	
		if(eTest == eTest_Manual)
			UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_InitFont();
		GLIB_Printf(90,160, "Window 0");
	}
	else
		GLIB_DrawPattern_Alpha2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_Printf(90,160, "Window 1");
	}
	else
		GLIB_DrawPattern_Alpha2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);

	
	//UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	//UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(eLayOrder);	
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	//UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(eLayOrder);	
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);
	
	// TV On
	TVENC_SetOnOff(1);

	if(eSrcImgType == RGB16)
	{
		aColorKey[MX_WIN0] = 0xf800;		//Red
		aColorKey[MX_WIN1] = 0x07e0;		//Green
	}
	else if(eSrcImgType == ARGB1555)
	{
		//aColorKey[MX_WIN0] = 0x7c00;		//Red
		//aColorKey[MX_WIN1] = 0x03e0;		//Green
		aColorKey[MX_WIN0] = 0xfc00;		//A_Red
		aColorKey[MX_WIN1] = 0x83e0;		//A_Green		
	}
	else if(eSrcImgType == ARGB4444)
	{
		aColorKey[MX_WIN0] = 0x0f00;		//Red
		aColorKey[MX_WIN1] = 0x00f0;		//Green
	}
	else if(eSrcImgType == ARGB8888)
	{
		aColorKey[MX_WIN0] = 0xff0000;		//Red
		aColorKey[MX_WIN1] = 0x00ff00;		//Green
	}
	
	MIXER_SetColorKeyOnOff(MX_WIN0, aColorKey[MX_WIN0], 1);
	MIXER_SetColorKeyOnOff(MX_WIN1, aColorKey[MX_WIN1], 1);

	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


u32 SDMXT_ColorKey_FullTest(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, j;
	u32 uImgCount, uLayerCount;
	oFunctionT_AutoVar	oParameter;
	FullTestMenu oSrcImgType[]	 = 	{	{(u32)RGB16,	"RGB16"},
										{(u32)ARGB1555, "ARGB1555"},
										{(u32)ARGB4444, "ARGB4444"},
										{(u32)ARGB8888, "ARGB8888"}	};
	FullTestMenu oLayOrder[] 		= 	{	{(u32)DN_VDW0W1_UP, "VD_W0_W1"},
										{(u32)DN_VDW1W0_UP, "VD_W1_W0"},
										{(u32)DN_W0VDW1_UP, "W0_VD_W1"},
										{(u32)DN_W0W1VD_UP, "W0_W1_VD"},
										{(u32)DN_W1VDW0_UP, "W1_VD_W0"},
										{(u32)DN_W1W0VD_UP, "W1_W0_VD"}	};

	uImgCount = sizeof(oSrcImgType)/sizeof(oSrcImgType[0]);
	uLayerCount = sizeof(oLayOrder)/sizeof(oLayOrder[0]);

	UART_Printf("\n\n");
	for(i=0 ; i<uImgCount ; i++)
	{
		for(j=0 ; j<uLayerCount ; j++)
		{
			UART_Printf(">>> Test Parameter <<<\n");
			UART_Printf("Source Image Type : %s\n", oSrcImgType[i].pString);
			UART_Printf("Window Layer Order : %s\n", oLayOrder[j].pString);
			
			oParameter.Test_Parameter[0] = oSrcImgType[i].uType;
			oParameter.Test_Parameter[1] = oLayOrder[j].uType;	
			SDMXT_ColorKey(eTest_Auto, oParameter);
			UART_Printf("\n");
		}
	}

	return 1;
}


u32 SDMXT_BigEndianMode(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[SDMXT_BigEndianMode]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 		1 : ARGB1555,		2 : ARGB4444,		3 : ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>3)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : ARGB8888;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( (eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)||(eSrcImgType==ARGB8888) );
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
	{
		SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB601_16_235);
	}
	SDVpMx_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr, eSrcImgType);
	
	// VP Setting
	SDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
	//Mixer Setting
	SDVpMx_MixerSettingForTest(uWin0StAddr, uWin1StAddr, eSrcImgType);
	MIXER_SetEndianMode(MX_ENDIAN_BIG);
	
	// Change Image to Big Endian
	SDMx_ChangeImageEndianMode(oMx_SrcInf[0]);
	SDMx_ChangeImageEndianMode(oMx_SrcInf[1]);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	TVENC_SetOnOff(1);

	UART_Getc();
 
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);

	return 1;
}



void SDMXT_GetRanValueForMx(u32 *pRandom)
{
	u32 uDstFullSize_H, uDstFullSize_V;

	if (eImgSz == SD480)
	{
		uDstFullSize_H = SD480_HSIZE;
		uDstFullSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		uDstFullSize_H = SD576_HSIZE;
		uDstFullSize_V = SD576_VSIZE;
	}
	else
	{}

	/// Window 0
	//oMx_SrcInf.uSrcXPos
	pRandom[0] = rand()%(uDstFullSize_H-1);
	oMx_SrcInf[MX_WIN0].uSrcXPos = pRandom[0];

	//oMx_SrcInf.uSrcYPos
	pRandom[1] = rand()%(uDstFullSize_V-1);
	oMx_SrcInf[MX_WIN0].uSrcYPos = pRandom[1];

	//oVP_DstInf.uDstXPos
	pRandom[2] = rand()%(uDstFullSize_H-1);
	oMx_DstInf[MX_WIN0].uDstXPos = pRandom[2];

	//oVP_DstInf.uDstYPos
	pRandom[3] = rand()%(uDstFullSize_V-1);
	oMx_DstInf[MX_WIN0].uDstYPos = pRandom[3];
	
	//oMx_SrcInf.uSrcHsz 
	if(oMx_DstInf[MX_WIN0].uDstXPos > oMx_SrcInf[MX_WIN0].uSrcXPos)
	{
		pRandom[4] = (rand()%(uDstFullSize_H-oMx_DstInf[MX_WIN0].uDstXPos))+1;
		oMx_SrcInf[MX_WIN0].uSrcHsz = pRandom[4];
	}
	else
	{
		pRandom[4] = (rand()%(uDstFullSize_H-oMx_SrcInf[MX_WIN0].uSrcXPos))+1;
		oMx_SrcInf[MX_WIN0].uSrcHsz = pRandom[4];
	}		

	//oVP_SrcInf.uSrcVsz
	if(oMx_DstInf[MX_WIN0].uDstYPos > oMx_SrcInf[MX_WIN0].uSrcYPos)
	{	
		pRandom[5] = (rand()%(uDstFullSize_V-oMx_DstInf[MX_WIN0].uDstYPos))+1;
		oMx_SrcInf[MX_WIN0].uSrcVsz = pRandom[5];
	}
	else
	{
		pRandom[5] = (rand()%(uDstFullSize_V-oMx_SrcInf[MX_WIN0].uSrcYPos))+1;
		oMx_SrcInf[MX_WIN0].uSrcVsz = pRandom[5];
	}

	/// Window 1
	//oMx_SrcInf.uSrcXPos
	pRandom[6] = rand()%(uDstFullSize_H-1);
	oMx_SrcInf[MX_WIN1].uSrcXPos = pRandom[6];

	//oMx_SrcInf.uSrcYPos
	pRandom[7] = rand()%(uDstFullSize_V-1);
	oMx_SrcInf[MX_WIN1].uSrcYPos = pRandom[7];

	//oVP_DstInf.uDstXPos
	pRandom[8] = rand()%(uDstFullSize_H-1);
	oMx_DstInf[MX_WIN1].uDstXPos = pRandom[8];

	//oVP_DstInf.uDstYPos
	pRandom[9] = rand()%(uDstFullSize_V-1);
	oMx_DstInf[MX_WIN1].uDstYPos = pRandom[9];
	
	//oMx_SrcInf.uSrcHsz 
	if(oMx_DstInf[MX_WIN1].uDstXPos > oMx_SrcInf[MX_WIN1].uSrcXPos)
	{
		pRandom[10] = (rand()%(uDstFullSize_H-oMx_DstInf[MX_WIN1].uDstXPos))+1;
		oMx_SrcInf[MX_WIN1].uSrcHsz = pRandom[10];
	}
	else
	{
		pRandom[10] = (rand()%(uDstFullSize_H-oMx_SrcInf[MX_WIN1].uSrcXPos))+1;
		oMx_SrcInf[MX_WIN1].uSrcHsz = pRandom[10];
	}		

	//oVP_SrcInf.uSrcVsz
	if(oMx_DstInf[MX_WIN1].uDstYPos > oMx_SrcInf[MX_WIN1].uSrcYPos)
	{	
		pRandom[11] = (rand()%(uDstFullSize_V-oMx_DstInf[MX_WIN1].uDstYPos))+1;
		oMx_SrcInf[MX_WIN1].uSrcVsz = pRandom[11];
	}
	else
	{
		pRandom[11] = (rand()%(uDstFullSize_V-oMx_SrcInf[MX_WIN1].uSrcYPos))+1;
		oMx_SrcInf[MX_WIN1].uSrcVsz = pRandom[11];
	}

	UART_Printf("==============================================\n");
	UART_Printf(">> Window 0\n");
	UART_Printf("Src Position(%d, %d)\n", oMx_SrcInf[MX_WIN0].uSrcXPos, oMx_SrcInf[MX_WIN0].uSrcYPos);
	UART_Printf("Dst Position(%d, %d)\n", oMx_DstInf[MX_WIN0].uDstXPos, oMx_DstInf[MX_WIN0].uDstYPos);
	UART_Printf("Src Size(%d, %d)\n", oMx_SrcInf[MX_WIN0].uSrcHsz, oMx_SrcInf[MX_WIN0].uSrcVsz);

	UART_Printf(">> Window 1\n");
	UART_Printf("Src Position(%d, %d)\n", oMx_SrcInf[MX_WIN1].uSrcXPos, oMx_SrcInf[MX_WIN1].uSrcYPos);
	UART_Printf("Dst Position(%d, %d)\n", oMx_DstInf[MX_WIN1].uDstXPos, oMx_DstInf[MX_WIN1].uDstYPos);
	UART_Printf("Src Size(%d, %d)\n", oMx_SrcInf[MX_WIN1].uSrcHsz, oMx_SrcInf[MX_WIN1].uSrcVsz);	
	UART_Printf("==============================================\n");
	
	UART_Printf("\n");
}


u32 SDMXT_RandomDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uCount, uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uRandom_Temp[15];
	s32 uRanOffset, uFirst = 1;

	UART_Printf("[SDMXT_RandomDisplay]\n");

	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	//VP Image
	SDVpMx_DownImageForVP(	eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, 
								&uImageSize_H, &uImageSize_V, RGB709_16_235);
	// VP setting
	SDVpMx_VPSettingForTest(uVpSrcAddr, NV12);

	// Mixer Image
	GLIB_InitInstance(uWin0StAddr, uImageSize_H, uImageSize_V, RGB16);
	GLIB_DrawPattern(uImageSize_H, uImageSize_V);
	GLIB_InitInstance(uWin1StAddr, uImageSize_H, uImageSize_V, RGB16);	
	GLIB_DrawPattern2(uImageSize_H, uImageSize_V);

	//Mixer Setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	
	//Mixer Graphic0 Setting
	oMx_SrcInf[MX_WIN0].eBpp = RGB16;
	oMx_SrcInf[MX_WIN0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[MX_WIN0].uImgHsz = uImageSize_H;
	oMx_SrcInf[MX_WIN0].uSrcXPos = 0;
	oMx_SrcInf[MX_WIN0].uSrcYPos = 0;
	oMx_SrcInf[MX_WIN0].uSrcHsz = uImageSize_H;
	oMx_SrcInf[MX_WIN0].uSrcVsz = uImageSize_V;
	oMx_DstInf[MX_WIN0].uDstXPos = 0;
	oMx_DstInf[MX_WIN0].uDstYPos = 0;
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	//Mixer Graphic1 Setting
	oMx_SrcInf[MX_WIN1].eBpp = RGB16;
	oMx_SrcInf[MX_WIN1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[MX_WIN1].uImgHsz = uImageSize_H;
	oMx_SrcInf[MX_WIN1].uSrcXPos = 0;
	oMx_SrcInf[MX_WIN1].uSrcYPos = 0;
	oMx_SrcInf[MX_WIN1].uSrcHsz = uImageSize_H;
	oMx_SrcInf[MX_WIN1].uSrcVsz = uImageSize_V;
	oMx_DstInf[MX_WIN1].uDstXPos = 0;
	oMx_DstInf[MX_WIN1].uDstYPos = 0;
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);
	
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0x80, 1);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0x80, 1);

	UART_Printf("Input the random offset value\n");
	uRanOffset = UART_GetIntNum();
	srand(uRanOffset);

	uCount = 0;
	while(!UART_GetKey())
	{
		UART_Printf("Count : %d\n", uCount++);	
		SDMXT_GetRanValueForMx(uRandom_Temp);
				
		if(uFirst == 1)
		{
			// TV On
			VP_EnableIP(1);
			MIXER_StartProcessing();
			TVENC_SetOnOff(1);

			uFirst = 0;
		}
		
		MIXER_SetCropping(MX_WIN0, oMx_SrcInf[MX_WIN0].uSrcXPos, oMx_SrcInf[MX_WIN0].uSrcYPos, 
									oMx_SrcInf[MX_WIN0].uSrcHsz, oMx_SrcInf[MX_WIN0].uSrcVsz, 
									oMx_DstInf[MX_WIN0].uDstXPos, oMx_DstInf[MX_WIN0].uDstYPos);
		MIXER_SetCropping(MX_WIN1, oMx_SrcInf[MX_WIN1].uSrcXPos, oMx_SrcInf[MX_WIN1].uSrcYPos, 
									oMx_SrcInf[MX_WIN1].uSrcHsz, oMx_SrcInf[MX_WIN1].uSrcVsz, 
									oMx_DstInf[MX_WIN1].uDstXPos, oMx_DstInf[MX_WIN1].uDstYPos);		

		DelayfrTimer(milli, 1000);
	}

	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
		
	return 1;
}



#if 0
void SDVPT_InitParaForTV(void)
{
	u32 uImgSize_H, uImgSize_V;

	if(eImgSz == SD480)
	{
		uImgSize_H = SD480_HSIZE;
		uImgSize_V = SD480_VSIZE;
	}
	else
	{
		uImgSize_H = SD576_HSIZE;
		uImgSize_V = SD576_VSIZE;
	}
	
	// VP setting
	oVP_SrcInf.eSrcBpp = NV12;
	oVP_SrcInf.uImgHsz = uImgSize_H;
	oVP_SrcInf.uImgVsz = uImgSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uImgSize_H;
	oVP_SrcInf.uSrcVsz=uImgSize_V;
	oVP_SrcInf.uSrcNumOfFrm = 1;
	oVP_SrcInf.eStep = STEP0;

	oVP_DstInf.eScanMode = eScanMode;
	oVP_DstInf.uOrgDstHsz = uImgSize_H;
	oVP_DstInf.uOrgDstVsz = uImgSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImgSize_H;
	oVP_DstInf.uDstVsz = uImgSize_V;	
	oVP_DstInf.eImgSz = eImgSz;
}
#endif


u32 SDVPT_SimpleDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[SDVPT_SimpleDisplay]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	// Image download for VP
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB601_16_235);
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uImageSize_H;
	oVP_SrcInf.uSrcVsz=uImageSize_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImageSize_H;
	oVP_DstInf.uDstVsz = uImageSize_V;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	
	// TV On
	VP_EnableIP(1);	
	MIXER_StartProcessing();
	TVENC_SetOnOff(1);

	// Waiting
	UART_Printf("Press any key to exit!\n");
	UART_Getc();

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}

u32 SDVPT_SimpleDisplay_temp(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;
	u32 uSrcXSize, uSrcYSize;
	oDownImage_Inform 	oDownImg;

	u32 usel;

	UART_Printf("[SDVPT_SimpleDisplay]\n");

	#if 1
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}

	
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	// Image download for VP
	#if 1
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB601_16_235);
	#else if
	oDownImg.pImagePath = pResolution_Image[BMP_720x480];
	LoadFromFile((const char *)oDownImg.pImagePath, uVpSrcAddr);
	UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);

	uImageSize_H = SD480_HSIZE;
	uImageSize_V = SD480_VSIZE;
	
	#endif

	// VP setting
	uSrcXSize=720;
	uSrcYSize=200;
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos =100;
	oVP_SrcInf.uSrcHsz=uSrcXSize;
	oVP_SrcInf.uSrcVsz=uSrcYSize/2;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uSrcXSize;
	oVP_DstInf.uDstVsz = uSrcYSize*2;	


	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	oVP_SrcInf.uSrcVsz = (u32)(uSrcYSize/2);
	oVP_DstInf.uDstVsz = (u32)(uSrcYSize*2);
	
	VP_SetCroppingSize(0, 150, oVP_SrcInf.uSrcHsz,  oVP_SrcInf.uSrcVsz, STEP0);
	VP_SetViewPosition(0, 0, 	oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);	


	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);



	
	// TV On
	VP_EnableIP(1);	
	MIXER_StartProcessing();
	TVENC_SetOnOff(1);

#endif

	// Waiting
	UART_Printf("Press any key to exit!\n");
	UART_Getc();

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}
u32 SDVPT_Scaling(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 i, uScaleCount, uSrcImgType_Temp;
	IMG_FMT eSrcImgType;
	oDownImage_Inform 	oDownImg;
	float fScaleFactor[] = 	{ 	0.25, 0.33, 0.5, 
							1, 1.25, 1.5, 1.75, 
							2, 2.25, 2.5, 2.75, 
							3, 3.25, 3.5, 3.75, 
							4, 4.25, 4.5, 4.75, 
							5, 5.25, 5.5, 5.75, 
							6, 6.25, 6.5, 6.75, 
							7, 7.25, 7.5, 7.75, 
							8, 8.25, 8.5, 8.75, 
							9, 9.25, 9.5, 9.75, 
							10, 10.25, 10.5, 10.75, 
							11, 11.25, 11.5, 11.75, 
							12, 12.25, 12.5, 12.75, 
							13, 13.25, 13.5, 13.75, 
							14, 14.25, 14.5, 14.75, 
							15, 15.25, 15.5, 15.75, 
							16};

	UART_Printf("[SDVPT_Scaling]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	uScaleCount = sizeof(fScaleFactor)/sizeof(fScaleFactor[0]);
		
	// Image download for VP
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB601_16_235);
#if 0
	if(eImgSz== SD480)
	{
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;	
		oDownImg.eImageSize = BMP_720x480;
	}
	else if(eImgSz== SD576)
	{
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;			
		oDownImg.eImageSize = BMP_720x576;
	}
	oDownImg.pImagePath = pResolution_Image[oDownImg.eImageSize];
	LoadFromFile((const char *)oDownImg.pImagePath, uVpSrcAddr);
#endif
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;

	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	
	// TV On
	VP_EnableIP(1);	
	MIXER_StartProcessing();
	TVENC_SetOnOff(1);
		
	UART_Printf("1. X-axis Scaling Test\n");	
	for(i=0 ; i<uScaleCount ; i++)
	{
		oVP_SrcInf.uSrcHsz = (u32)((float)uImageSize_H/fScaleFactor[i]);
		if(oVP_SrcInf.uSrcHsz > uImageSize_H)
			oVP_SrcInf.uSrcHsz = uImageSize_H;
		oVP_SrcInf.uSrcVsz = uImageSize_V;

		oVP_DstInf.uDstHsz = (u32)((float)oVP_SrcInf.uSrcHsz*fScaleFactor[i]);
		oVP_DstInf.uDstVsz = uImageSize_V;

		UART_Printf("Src(%d,%d) -> Dst(%d,%d)  :  Scaling(%0.2f, 1)\n", 
					oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz, fScaleFactor[i] );

		VP_SetCroppingSize(0, 0, oVP_SrcInf.uSrcHsz,  oVP_SrcInf.uSrcVsz, STEP0);
		VP_SetViewPosition(0, 0, 	oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);
		
		//Waiting
		if(eTest == eTest_Manual)
			UART_Getc();
		else
			DelayfrTimer(milli, 1000);
	}

	UART_Printf("2. Y-axis Scaling Test\n");	
	for(i=0 ; i<uScaleCount ; i++)
	{
		oVP_SrcInf.uSrcHsz = uImageSize_H;
		oVP_SrcInf.uSrcVsz = (u32)((float)uImageSize_V/fScaleFactor[i]);
		if(oVP_SrcInf.uSrcVsz > uImageSize_V)
			oVP_SrcInf.uSrcVsz = uImageSize_V;		
		
		oVP_DstInf.uDstHsz = uImageSize_H;
		oVP_DstInf.uDstVsz = (u32)((float)oVP_SrcInf.uSrcVsz*fScaleFactor[i]);;

		UART_Printf("Src(%d,%d) -> Dst(%d,%d)  :  Scaling(1, %0.2f)\n", 
					oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz, fScaleFactor[i] );

		VP_SetCroppingSize(0, 0, oVP_SrcInf.uSrcHsz,  oVP_SrcInf.uSrcVsz, STEP0);
		VP_SetViewPosition(0, 0, 	oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);	
		
		//Waiting
		if(eTest == eTest_Manual)
			UART_Getc();
		else
			DelayfrTimer(milli, 1000);
	}

	UART_Printf("3. XY-axis Scaling Test\n");	
	for(i=0 ; i<uScaleCount ; i++)
	{
		oVP_SrcInf.uSrcHsz = (u32)((float)uImageSize_H/fScaleFactor[i]);
		if(oVP_SrcInf.uSrcHsz > uImageSize_H)
			oVP_SrcInf.uSrcHsz = uImageSize_H;
		oVP_SrcInf.uSrcVsz = (u32)((float)uImageSize_V/fScaleFactor[i]);
		if(oVP_SrcInf.uSrcVsz > uImageSize_V)
			oVP_SrcInf.uSrcVsz = uImageSize_V;		
		
		oVP_DstInf.uDstHsz = (u32)((float)oVP_SrcInf.uSrcHsz*fScaleFactor[i]);
		oVP_DstInf.uDstVsz = (u32)((float)oVP_SrcInf.uSrcVsz*fScaleFactor[i]);;

		UART_Printf("Src(%d,%d) -> Dst(%d,%d)  :  Scaling(%0.2f, %0.2f)\n", 
					oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz, fScaleFactor[i], fScaleFactor[i] );
		
		VP_SetCroppingSize(0, 0, oVP_SrcInf.uSrcHsz,  oVP_SrcInf.uSrcVsz, STEP0);
		VP_SetViewPosition(0, 0, 	oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);

		//Waiting
		if(eTest == eTest_Manual)
			UART_Getc();
		else
			DelayfrTimer(milli, 1000);
	}	

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);	
	return 1;
}


u32 SDVPT_SourceCropping(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXSize, uSrcYSize;
	u32 uSrcImgType_Temp;
	u32 uTempKey;
	IMG_FMT eSrcImgType;

	UART_Printf("[SDVPT_SourceCropping]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	// Image download for VP
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB601_16_235);
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=VP_SRCSIZE_MIN_H;
	oVP_SrcInf.uSrcVsz=VP_SRCSIZE_MIN_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = oVP_SrcInf.uSrcHsz;
	oVP_DstInf.uDstVsz = oVP_SrcInf.uSrcVsz;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	
	// TV On
	VP_EnableIP(1);	
	MIXER_StartProcessing();	
	TVENC_SetOnOff(1);
			
	for(uSrcXSize=VP_SRCSIZE_MIN_H ; uSrcXSize<=uImageSize_H ; uSrcXSize+=2)
	{
		for(uSrcYSize=VP_SRCSIZE_MIN_V ; uSrcYSize<=uImageSize_V ; uSrcYSize+=2)
		{
			// Set Image Positioning
			VP_SetCroppingSize(0, 0, uSrcXSize, uSrcYSize, STEP0);
			VP_SetViewPosition(0, 0, uSrcXSize, uSrcYSize);

			UART_Printf("Cropped Src(%d,%d) -> Dst(%d,%d)\n", 
						oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);

			//Waiting
			DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_StopProcessing();
				TVENC_SetOnOff(0);
				return 1;
			}
		}
	}

	UART_Getc();
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}



u32 SDVPT_SourceImgPositioning(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize;
	u32 uSrcImgType_Temp;
	u32 uTempKey;
	IMG_FMT eSrcImgType;

	UART_Printf("[SDVPT_SourceImgPositioning]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	// Image download for VP
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB601_16_235);
	
	// VP setting
	uSrcXSize=200;
	uSrcYSize=150;
	
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz = uSrcXSize;
	oVP_SrcInf.uSrcVsz = uSrcYSize;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 80;
	oVP_DstInf.uDstYPos = 60;
	oVP_DstInf.uDstHsz = uSrcXSize;
	oVP_DstInf.uDstVsz = uSrcYSize;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	TVENC_SetOnOff(1);
			
	for(uSrcXPos=0 ; uSrcXPos<=uImageSize_H-uSrcXSize ; uSrcXPos+=2)
	{
		for(uSrcYPos=0 ; uSrcYPos<=uImageSize_V-uSrcYSize ; uSrcYPos+=2)
		{
			UART_Printf("Src Positioning(%d,%d) -> Dst(%d,%d),    Image Size(%d, %d)\n", 
						uSrcXPos, uSrcYPos, oVP_DstInf.uDstXPos, oVP_DstInf.uDstYPos, uSrcXSize, uSrcYSize);

			// Set Image Positioning
			VP_SetCroppingSize(uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize, STEP0);
			
			//Waiting
			//DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{
				//TV Off
				VP_EnableIP(0);
				MIXER_StopProcessing();
				TVENC_SetOnOff(0);	
				return 1;
			}
		}
	}

	UART_Getc();
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}



u32 SDVPT_DestinationImgPositioning(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uDstXPos, uDstYPos, uDstXSize, uDstYSize;
	u32 uSrcImgType_Temp;
	u32 uTempKey;
	IMG_FMT eSrcImgType;

	UART_Printf("[SDVPT_DestinationImgPositioning]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	// Image download for VP
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB601_16_235);

	
	// VP setting
	uDstXSize = 200;
	uDstYSize = 150;
	
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz = uDstXSize;
	oVP_SrcInf.uSrcVsz = uDstYSize;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uDstXSize;
	oVP_DstInf.uDstVsz = uDstYSize;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();	
	TVENC_SetOnOff(1);
			
	for(uDstXPos=0 ; uDstXPos<=uImageSize_H-uDstXSize ; uDstXPos+=2)
	{
		for(uDstYPos=0 ; uDstYPos<=uImageSize_V-uDstYSize ; uDstYPos+=2)
		{
			// Set Desitionation Image Positioning
			VP_SetViewPosition(uDstXPos, uDstYPos, uDstXSize, uDstYSize);
			
			UART_Printf("Src Position(%d,%d) -> Dst Position(%d,%d),    Image Size(%d, %d)\n", 
						oVP_SrcInf.uSrcXPos, oVP_SrcInf.uSrcYPos, uDstXPos, uDstYPos, uDstXSize, uDstYSize);
			
			//Waiting
			//DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{
				//TV Off
				VP_EnableIP(0);
				MIXER_StopProcessing();
				TVENC_SetOnOff(0);	
				return 1;
			}
		}
	}

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}



u32 SDVPT_ColorSpaceConversion(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[SDVPT_ColorSpaceConversion] : BT.709 to BT.601\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	// Image download for VP
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);
		
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz = uImageSize_H;
	oVP_SrcInf.uSrcVsz = uImageSize_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImageSize_H;
	oVP_DstInf.uDstVsz = uImageSize_V;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
///	VP_SetCscOnOff(HD_TO_SD, MINUS16, 1);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();	
	TVENC_SetOnOff(1);

	while(1)
	{
		UART_Printf("HD_TO_SD, MINUS16\n");
///		FIMC_RunWith_CSC_YUVRange(RGB709_16_235);
		VP_SetCscOnOff(HD_TO_SD, MINUS16, 1);
		if(UART_Getc() == 'x')
			break;

		UART_Printf("HD_TO_SD, ZERO\n");
///		FIMC_RunWith_CSC_YUVRange(RGB709_0_255);
		VP_SetCscOnOff(HD_TO_SD, ZERO, 1);
		if(UART_Getc() == 'x')
			break;

		UART_Printf("SD_TO_HD, MINUS16\n");
///		FIMC_RunWith_CSC_YUVRange(RGB601_16_235);
		VP_SetCscOnOff(SD_TO_HD, MINUS16, 1);
		if(UART_Getc() == 'x')
			break;		

		UART_Printf("SD_TO_HD, ZERO\n");
///		FIMC_RunWith_CSC_YUVRange(RGB601_0_255);
		VP_SetCscOnOff(SD_TO_HD, ZERO, 1);
		if(UART_Getc() == 'x')
			break;
	}

	// TV Off
	VP_EnableIP(0);
	//MIXER_SetVdWinOnOff(0);	//jwj
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}



u32 SDVPT_Saturation(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{	
	u32 i;

	UART_Printf("[SDVPT_Saturation]\n");

	VP_SetPostProcessingOnOff(1);
	
	for(i=0 ; i<=0xFF ; i++)
	{
		VP_SetSaturation(i);
		DelayfrTimer(milli, 50);
	}

	// Reset to Default
	VP_SetSaturation(0x80);

	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 SDVPT_Sharpness(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;

	UART_Printf("[SDVPT_Sharpness]\n");
	
	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=3 ; i++)
	{
		VP_SetSharpness((VP_eSHARPNESS)i, 0x5);
		DelayfrTimer(milli, 2000);
	}

	// Reset to Default
	VP_SetSharpness(NO_EFFECT, 0x5);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 SDVPT_Brightness(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, j, aBrightness[8];

	UART_Printf("[SDVPT_Brightness]\n");

	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=0xFFFF ; i++)
	{
		for(j=0 ; j<8 ; j++)
			aBrightness[j] = i;		//chnage to resonable value
		
		VP_SetBrightness(aBrightness);
		DelayfrTimer(milli, 1);
	}

	// Reset to Default
	for(i=0 ; i<8 ; i++)
		aBrightness[i] = 0;
	VP_SetBrightness(aBrightness);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 SDVPT_Contrast(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, j, aContrast[8];

	UART_Printf("[SDVPT_Contrast]\n");

	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=0xFF ; i++)
	{
		for(j=0 ; j<8 ; j++)
			aContrast[j] = i;		//chnage to resonable value
		
		VP_SetContrast(aContrast);
		DelayfrTimer(milli, 50);
	}

	// Reset to Default
	for(i=0 ; i<8 ; i++)
		aContrast[i] = 0x80;
	VP_SetContrast(aContrast);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 SDVPT_Brightness_Offset(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;

	UART_Printf("[SDVPT_Brightness_Offset]\n");

	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=0x1FF ; i++)
	{
		VP_SetBrightOffset(i);
		DelayfrTimer(milli, 50);
	}

	// Reset to Default
	VP_SetBrightOffset(0);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 SDVPT_TH_HNoise(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;

	UART_Printf("[SDVPT_TH_HNoise]\n");

	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=0xFF ; i++)
	{
		VP_SetSharpness(NO_EFFECT, i);
		DelayfrTimer(milli, 50);
	}

	// Reset to Default
	VP_SetSharpness(NO_EFFECT, 0x5);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


const AutotestFuncMenu TV_VpEnc_menu[]=
{
	SDVPT_Saturation,				"VP Saturation",
	SDVPT_Sharpness,				"VP Sharpness",
	SDVPT_Brightness,				"VP Brightness",
	SDVPT_Contrast,					"VP Contrast",
	SDVPT_Brightness_Offset,		"VP Brightness Offset",
	SDVPT_TH_HNoise,				"VP TH HNoise",
	0,0
}; 


u32 SDVPT_Enhacement(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	s32 sSel;
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 i, uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[SDVPT_Enhacement]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	// Image download for VP
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB601_16_235);
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uImageSize_H;
	oVP_SrcInf.uSrcVsz=uImageSize_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImageSize_H;
	oVP_DstInf.uDstVsz = uImageSize_V;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();	
	TVENC_SetOnOff(1);	
	
	while (true)
	{
		for ( i=0; (int)(TV_VpEnc_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, TV_VpEnc_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(TV_VpEnc_menu)/8-1))
			(TV_VpEnc_menu[sSel].func) (eTest_Manual, oPara);
	}

	// TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);

	return 1;	
}

u32 SDVPT_PictureBigEndianMode(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[SHDVPT_PictureBigEndianMode]\n");
	
	UART_Printf("Select the Source Image Type\n");
	UART_Printf("0 : NV12(D), 		1 : TILE_NV12\n");
	uSrcImgType_Temp = UART_GetIntNum();
	if(uSrcImgType_Temp>1)
		uSrcImgType_Temp = 0;
	eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 : TILE_NV12;
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;

	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB601_16_235);
	SDVpMx_VPSettingForTest(uVpSrcAddr, eSrcImgType);
	SDVp_ChangeImageEndianMode(oVP_SrcInf); 	
	VP_SetEndianMode(ENDIAN_BIG);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1); 

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	TVENC_SetOnOff(1);

	// Waiting
	UART_Printf("Press any key to exit!\n");
	//INPUT_DELAY;
	UART_Getc();

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
	
	return 1;
}


void SDVPT_GetRanValueForVP(u32 *pRandom)
{
	u32 uDstFullSize_H, uDstFullSize_V;
	u32 uRepeatCount=0;

	if (oVP_DstInf.eImgSz == SD480)
	{
		uDstFullSize_H = SD480_HSIZE;
		uDstFullSize_V = SD480_VSIZE;
	}
	else if(oVP_DstInf.eImgSz == SD576)
	{
		uDstFullSize_H = SD576_HSIZE;
		uDstFullSize_V = SD576_VSIZE;
	}
	else
	{}
	
	//oVP_SrcInf.eSrcBpp
	pRandom[0] = rand()%6;
	//pRandom[0] = 3;

	//oVP_SrcInf.uSrcXPos
	pRandom[1] = rand()%(oVP_SrcInf.uImgHsz-VP_SRCSIZE_MIN_H+1);
	oVP_SrcInf.uSrcXPos = pRandom[1];

	//oVP_SrcInf.uSrcYPos
	pRandom[2] = rand()%(oVP_SrcInf.uImgVsz-VP_SRCSIZE_MIN_V+1);
	oVP_SrcInf.uSrcYPos = pRandom[2];

	//oVP_SrcInf.uSrcHsz 
	do
	{
		pRandom[3] = rand()%(oVP_SrcInf.uImgHsz-oVP_SrcInf.uSrcXPos+2);
		if(pRandom[3] < VP_SRCSIZE_MIN_H)
			pRandom[3] = VP_SRCSIZE_MIN_H;
	}while(oVP_SrcInf.uSrcXPos+pRandom[3] > oVP_SrcInf.uImgHsz);
	oVP_SrcInf.uSrcHsz = pRandom[3];

	//oVP_SrcInf.uSrcVsz
	do
	{
		pRandom[4] = rand()%(oVP_SrcInf.uImgVsz-oVP_SrcInf.uSrcYPos+2);
		if(pRandom[4] < VP_SRCSIZE_MIN_V)
			pRandom[4] = VP_SRCSIZE_MIN_V;
	}while(oVP_SrcInf.uSrcYPos+pRandom[4] > oVP_SrcInf.uImgVsz);
	oVP_SrcInf.uSrcVsz = pRandom[4];

	//oVP_DstInf.uDstXPos
	pRandom[5] = rand()%(uDstFullSize_H-VP_SRCSIZE_MIN_H+1);
	oVP_DstInf.uDstXPos = pRandom[5];

	//oVP_DstInf.uDstYPos
	pRandom[6] = rand()%(uDstFullSize_V-VP_SRCSIZE_MIN_V+1);
	oVP_DstInf.uDstYPos = pRandom[6];

	//oVP_DstInf.uDstHsz
	do
	{
		uRepeatCount++;
		if(uRepeatCount > 10)
		{
			uRepeatCount = 0;
			//oVP_DstInf.uDstXPos
			pRandom[5] = rand()%(uDstFullSize_H-VP_SRCSIZE_MIN_H+1);
			oVP_DstInf.uDstXPos = pRandom[5];			
		}
		
		pRandom[7] = rand()%(uDstFullSize_H-oVP_DstInf.uDstXPos+1);
		if(pRandom[7] < VP_SRCSIZE_MIN_H)
			pRandom[7] = VP_SRCSIZE_MIN_H;		
	}while( (pRandom[7]>(oVP_SrcInf.uSrcHsz*16)) || ((float)pRandom[7]<(float)((float)oVP_SrcInf.uSrcHsz*(float)0.25)) );
	oVP_DstInf.uDstHsz = pRandom[7];

	//oVP_DstInf.uDstVsz
	uRepeatCount = 0;
	do
	{
		uRepeatCount++;
		if(uRepeatCount > 10)
		{
			uRepeatCount = 0;
			//oVP_DstInf.uDstYPos
			pRandom[6] = rand()%(uDstFullSize_V-VP_SRCSIZE_MIN_V+1);
			oVP_DstInf.uDstYPos = pRandom[6];		
		}		

		pRandom[8] = rand()%(uDstFullSize_V-oVP_DstInf.uDstYPos+1);
		if(pRandom[8] < VP_SRCSIZE_MIN_V)
			pRandom[8] = VP_SRCSIZE_MIN_V;		
	}while( (pRandom[8]>(oVP_SrcInf.uSrcVsz*16)) || ((float)pRandom[8]<(float)((float)oVP_SrcInf.uSrcVsz*(float)0.25)) );
	oVP_DstInf.uDstVsz = pRandom[8];

	pRandom[9] = rand()%16;		// Step
	
	if(pRandom[0] == 0)
		UART_Printf("Src Image Format : NV12\n");
	else if(pRandom[0] == 1)
		UART_Printf("Src Image Format : NV12_IB\n");
	else if(pRandom[0] == 2)
		UART_Printf("Src Image Format : NV12_IW\n");
	else if(pRandom[0] == 3)
		UART_Printf("Src Image Format : TILE_NV12\n");
	else if(pRandom[0] == 4)
		UART_Printf("Src Image Format : TILE_NV12_IB\n");
	else
		UART_Printf("Src Image Format : TILE_NV12_IW\n");
						
	UART_Printf("Src Image : Pos(%d, %d), Size(%d, %d)\n",	oVP_SrcInf.uSrcXPos, oVP_SrcInf.uSrcYPos,
														oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz);
	UART_Printf("Dst Image : Pos(%d, %d), Size(%d, %d)\n",	oVP_DstInf.uDstXPos, oVP_DstInf.uDstYPos,
														oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);	
	UART_Printf("Horizontal Scaling = %0.2f\n", (float)oVP_DstInf.uDstHsz/(float)oVP_SrcInf.uSrcHsz);
	UART_Printf("Vertial Scaling = %0.2f\n", (float)oVP_DstInf.uDstVsz/(float)oVP_SrcInf.uSrcVsz);
	UART_Printf("Step = %d\n", pRandom[9]);
	UART_Printf("\n");
}

#if 1
u32 SDVPT_RandomDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uCount;
	u32 uImageSize_H, uImageSize_V;
	u32 uRandom_Temp[10];
	u32 uVpFrameBuffer[6];
	s32 uRanOffset, uFirst = 1;
	IMG_FMT eSrcImgType;
	oDownImage_Inform 	oDownImg;

	UART_Printf("[SDVPT_RandomDisplay]\n");

	uVpFrameBuffer[0] = CODEC_MEM_ST + 0x00200000;
	uVpFrameBuffer[1] = uVpFrameBuffer[0] + 0x00200000;
	uVpFrameBuffer[2] = uVpFrameBuffer[1] + 0x00200000;
	uVpFrameBuffer[3] = uVpFrameBuffer[2] + 0x00200000;
	
	// Image download for VP
	if(eImgSz== SD480)
	{
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;	
		oDownImg.eImageSize = BMP_720x480;
	}
	else if(eImgSz== SD576)
	{
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;			
		oDownImg.eImageSize = BMP_720x576;
	}
	else
		Assert(0);

	// NV12 & NV12_IW
	oDownImg.pImagePath = pResolution_Image[oDownImg.eImageSize];
	LoadFromFile((const char *)oDownImg.pImagePath, uVpFrameBuffer[0]);
	// NV12_IB
	oDownImg.pImagePath = pResol_NV12_IB[oDownImg.eImageSize];
	LoadFromFile((const char *)oDownImg.pImagePath, uVpFrameBuffer[1]);
	
	// TILE_NV12 & TILE_NV12_IW
	oDownImg.pImagePath = pResol_TILE_NV12[oDownImg.eImageSize];
	LoadFromFile((const char *)oDownImg.pImagePath, uVpFrameBuffer[2]);
	// TILE_NV12_IB
	oDownImg.pImagePath = pResol_TILE_NV12_IB[oDownImg.eImageSize];
	LoadFromFile((const char *)oDownImg.pImagePath, uVpFrameBuffer[3]);

	
	// VP setting
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	
	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;

	UART_Printf("Input the random offset value\n");
	uRanOffset = UART_GetIntNum();
	srand(uRanOffset);

	uCount = 0;
	while(!UART_GetKey())
	{
		u32 uYSize, uCSize;
		
		UART_Printf("Count : %d\n", uCount++);	
		SDVPT_GetRanValueForVP(uRandom_Temp);
		
		eSrcImgType = 	(uRandom_Temp[0] == 0)? NV12 :
						(uRandom_Temp[0] == 1)? NV12_IB :
						(uRandom_Temp[0] == 2)? NV12_IW :
						(uRandom_Temp[0] == 3)? TILE_NV12 :
						(uRandom_Temp[0] == 4)? TILE_NV12_IB : TILE_NV12_IW;
		oVP_SrcInf.eSrcBpp = eSrcImgType;

		if((eSrcImgType == NV12) || (eSrcImgType == NV12_IW))
			oVP_SrcInf.uSrcStAddr = uVpFrameBuffer[0];
		else if(eSrcImgType == NV12_IB)
			oVP_SrcInf.uSrcStAddr = uVpFrameBuffer[1];
		else if((eSrcImgType == TILE_NV12) || (eSrcImgType == TILE_NV12_IW))
			oVP_SrcInf.uSrcStAddr = uVpFrameBuffer[2];
		else
			oVP_SrcInf.uSrcStAddr = uVpFrameBuffer[3];
		
		if(uFirst == 1)
		{
			VP_InitIP(oVP_SrcInf, oVP_DstInf);

			// Mixer setting
			MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
			MIXER_SetVdWinOnOff(1);

			// TV On
			VP_EnableIP(1);
			MIXER_StartProcessing();
			TVENC_SetOnOff(1);

			uFirst = 0;
		}

#if 1
		VP_CalcImageSize(oVP_SrcInf, &uYSize, &uCSize);
		VP_SetModeAndImgSize(oVP_SrcInf, oVP_DstInf, uYSize, uCSize);
///		VP_EnableIP(1);
#else	
		VP_SetCroppingSize(oVP_SrcInf.uSrcXPos, oVP_SrcInf.uSrcYPos, oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, STEP0);
		VP_SetViewPosition(oVP_DstInf.uDstXPos, oVP_DstInf.uDstYPos, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);
#endif	

		DelayfrTimer(milli, 1000);
	}

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
		
	return 1;
}

#else
u32 SDVPT_RandomDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uCount, uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uRandom_Temp[10];
	s32 uRanOffset, uFirst = 1;
	IMG_FMT eSrcImgType;

	UART_Printf("[SDVPT_RandomDisplay]\n");

	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;

	
	// Image download for VP
	SDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB601_16_235);

	// VP setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	
	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;

	UART_Printf("Input the random offset value\n");
	uRanOffset = UART_GetIntNum();
	srand(uRanOffset);

	uCount = 0;
	while(!UART_GetKey())
	{
		u32 uYSize, uCSize;
		
		UART_Printf("Count : %d\n", uCount++);	
		SDVPT_GetRanValueForVP(uRandom_Temp);
		
		eSrcImgType = 	(uRandom_Temp[0] == 0)? NV12 :
						(uRandom_Temp[0] == 1)? NV12_IB :
						(uRandom_Temp[0] == 2)? NV12_IW :
						(uRandom_Temp[0] == 3)? TILE_NV12 :
						(uRandom_Temp[0] == 4)? TILE_NV12_IB : TILE_NV12_IW;
		oVP_SrcInf.eSrcBpp = eSrcImgType;
		
		//After Def.h
		//FIMC_CSC_Scaling_Temp(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
		//						RGB888, eSrcImgType, RGB601_16_235);
		
		if(uFirst == 1)
		{
			VP_InitIP(oVP_SrcInf, oVP_DstInf);

			// Mixer setting
			MIXER_InitForATv(eImgSz, eScanMode, RGB709_0_255);
			MIXER_SetVdWinOnOff(1);

			// TV On
			VP_EnableIP(1);
			MIXER_StartProcessing();
			TVENC_SetOnOff(1);

			uFirst = 0;
		}

#if 1
		VP_CalcImageSize(oVP_SrcInf, &uYSize, &uCSize);
		VP_SetModeAndImgSize(oVP_SrcInf, oVP_DstInf, uYSize, uCSize);
///		VP_EnableIP(1);
#else	
		VP_SetCroppingSize(oVP_SrcInf.uSrcXPos, oVP_SrcInf.uSrcYPos, oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, STEP0);
		VP_SetViewPosition(oVP_DstInf.uDstXPos, oVP_DstInf.uDstYPos, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);
#endif	

		DelayfrTimer(milli, 1000);
	}

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	TVENC_SetOnOff(0);
		
	return 1;
}
#endif

void SDTVENCT_InitForTest(TV_STANDARDS eTvStand, SDOUT_VIDEO_SIGNAL eVideoSignal)
{
	if(eVideoSignal == SDOUT_COMPONENT_SIG_PROG)
		eScanMode = PROGRESSIVE;
	else
		eScanMode = INTERLACED;
	
	if( (eTvStand == NTSC_M) || (eTvStand == NTSC_J) || (eTvStand == PAL_M) || (eTvStand == NTSC_443)||(eTvStand == PAL_60) )
		eImgSz = SD480;
	else
		eImgSz = SD576;

	TVENC_Reset(); 
	TVENC_InitIp( eTvStand, eScanMode, eVideoSignal );
	if ((eVideoSignal == SDOUT_COMPONENT_SIG)||(eVideoSignal == SDOUT_COMPONENT_SIG_PROG))
	{
		TVENC_SetComponentIf(SDOUT_YPBPR);
	}
}

void SDVPT_InitSimplePlay(u32 uVpSrcAddr, u32 uSrcHSize, u32 uSrcVSize,  
						IMG_RESOLUTION eOutImgRes, SCAN_MODE eOutScan,TV_STANDARDS eTvStand,
						SDOUT_VIDEO_SIGNAL eVideoSignal)
{
	IMG_FMT eSrcImgType;
	oDownImage_Inform 	oDownImg;

	eSrcImgType = NV12 ;
	
	eImgSz = eOutImgRes;

	SDTVENCT_InitForTest(eTvStand, eVideoSignal);
	SDVPT_InitParaForTV(eSrcImgType);
	SDMXT_InitParaForTV();
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uSrcHSize;
	oVP_SrcInf.uImgVsz = uSrcVSize;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uSrcHSize;
	oVP_SrcInf.uSrcVsz=uSrcVSize;

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eOutScan, eTvStand);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();

	// TV On
	TVENC_SetOnOff(1);

}

static void SDTV_VariableDrawGraphicForMixer(	u32 uWin0StAddr, u32 uWin1StAddr, 
													u32 uW0HSize, u32 uW0VSize, u32 uW1HSize, u32 uW1VSize, 
													IMG_FMT eImgFmt)
{
	GLIB_InitInstance(uWin0StAddr, uW0HSize, uW0VSize, eImgFmt);
	GLIB_DrawPattern(uW0HSize, uW0VSize);
	//GLIB_DrawPattern_Blue(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_InitFont();
	GLIB_Printf(uW0HSize/2-20,uW0VSize/2, "Window 0");
	
	GLIB_InitInstance(uWin1StAddr, uW1HSize, uW1VSize, eImgFmt);
	GLIB_DrawPattern2(uW1HSize, uW1VSize);
	GLIB_Printf(uW1HSize/2-20,uW1VSize/2, "Window 1");
}

static void SDTV_VariableMixerSettingForTest(	u32 uWin0StAddr, u32 uWin1StAddr, 
													u32 uWin0HSize, u32 uWin0VSize, u32 uWin1HSize, u32 uWin1VSize,
													u32 uWin0DstHPos, u32 uWin0DstVPos, u32 uWin1DstHPos, u32 uWin1DstVPos,
													IMG_FMT uSrcImgFmt)
{
	SDMXT_InitParaForTV();
	// Mixer setting
	UART_Printf("Video Layer Displayed\n");

	MIXER_InitForATv(eImgSz, eScanMode, NTSC_M);
	MIXER_SetVdWinOnOff(1);
	
	UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = uSrcImgFmt;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = uWin0HSize;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = uWin0HSize;
	oMx_SrcInf[0].uSrcVsz = uWin0VSize;

	oMx_DstInf[0].uDstXPos = uWin0DstHPos;
	oMx_DstInf[0].uDstYPos = uWin0DstVPos;
///	oMx_DstInf[0].uDstXPos = 0;
///	oMx_DstInf[0].uDstYPos = 0;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = uSrcImgFmt;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = uWin1HSize;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = uWin1HSize;
	oMx_SrcInf[1].uSrcVsz = uWin1VSize;

	oMx_DstInf[1].uDstXPos = uWin1DstHPos;
	oMx_DstInf[1].uDstYPos = uWin1DstVPos;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);

///	MIXER_StartProcessing();
}


static u32 *uMxsdWin0StAddr;
static u32 *uMxsdWin1StAddr;

#if 0
u32 SDTV_InitSimplePlay(u32 uVpSrcAddr, u32 uSrcHSize, u32 uSrcVSize, 
						IMG_FMT eImgFmt, IMG_RESOLUTION eOutImgRes, SCAN_MODE eOutScan, SDOUT_VIDEO_SIGNAL eVideoSignal)
{
	TV_STANDARDS eTvStand;
	oDownImage_Inform 	oDownImg;

	u32 uResolution, uScanMode, uHdmiMode, uColorFormat, uBitPerColor, uWideColor;
	u32 uMxWin0HSize, uMxWin0VSize, uMxWin1HSize, uMxWin1VSize;
	MX_RGB_FORMAT eMxOutRgb;

	eTvStand = NTSC_M;
	eImgSz = eOutImgRes;
	eScanMode = eOutScan;
	
	uMxWin0HSize = 720;
	uMxWin0VSize = 480;
	uMxWin1HSize = 720;
	uMxWin1VSize = 480;

	uMxsdWin0StAddr = malloc(uMxWin0HSize*uMxWin0VSize*4);
	uMxsdWin1StAddr = malloc(uMxWin1HSize*uMxWin1VSize*4);	

		// for Graphic Layer Image
	SDTV_VariableDrawGraphicForMixer((u32)uMxsdWin0StAddr, (u32)uMxsdWin1StAddr, 
										uMxWin0HSize, uMxWin0VSize, uMxWin1HSize, uMxWin1VSize,
										RGB24);
		
	SDTVENCT_InitForTest(eTvStand, eVideoSignal);
	SDVPT_InitParaForTV(eImgFmt);
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uSrcHSize;
	oVP_SrcInf.uImgVsz = uSrcVSize;
	oVP_SrcInf.uSrcHsz=uSrcHSize;
	oVP_SrcInf.uSrcVsz=uSrcVSize;		
	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	SDTV_VariableMixerSettingForTest( (u32)uMxsdWin0StAddr, (u32)uMxsdWin1StAddr, 
									   uMxWin0HSize, uMxWin0VSize, uMxWin1HSize, uMxWin1VSize,
									   0,0,0,0,  RGB24);

	return TRUE;

}
#endif
u32 SDTV_InitSimplePlay(u32 uVpSrcAddr, u32 uSrcHSize, u32 uSrcVSize, IMG_FMT eImgFmt,
						     u32 uMxWin0Addr, u32 uMxWin0HSize, u32 uMxWin0VSize, u32 uMxWin0On,
						     u32 uMxWin1Addr, u32 uMxWin1HSize, u32 uMxWin1VSize, u32 uMxWin1On, IMG_FMT eMxWin01ImgFmt,	
						     IMG_RESOLUTION eOutImgRes, SCAN_MODE eOutScan, SDOUT_VIDEO_SIGNAL eVideoSignal, TV_STANDARDS eTvStand)
{
	//TV_STANDARDS eTvStand;
	oDownImage_Inform 	oDownImg;

	u32 uResolution, uScanMode, uHdmiMode, uColorFormat, uBitPerColor, uWideColor;
	//u32 uMxWin0HSize, uMxWin0VSize, uMxWin1HSize, uMxWin1VSize;
	MX_RGB_FORMAT eMxOutRgb;

	//eTvStand = NTSC_M;
	eImgSz = eOutImgRes;
	eScanMode = eOutScan;
	

#if 0	// Memory Port 1
	uMxWin0StAddr = malloc(uMxWin0HSize*uMxWin0VSize*4);
	uMxWin1StAddr = malloc(uMxWin1HSize*uMxWin1VSize*4);	
#else	// Memory Port 0
	uMxsdWin0StAddr = (u32 *)uMxWin0Addr;
	uMxsdWin1StAddr = (u32 *)uMxWin1Addr;	
#endif

		// for Graphic Layer Image
	SDTV_VariableDrawGraphicForMixer((u32)uMxsdWin0StAddr, (u32)uMxsdWin1StAddr, 
										uMxWin0HSize, uMxWin0VSize, uMxWin1HSize, uMxWin1VSize,
										eMxWin01ImgFmt);
	InitBaseHWForSdout();	
	SDTVENCT_InitForTest(eTvStand, eVideoSignal);
	SDVPT_InitParaForTV(eImgFmt);
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uSrcHSize;
	oVP_SrcInf.uImgVsz = uSrcVSize;
	oVP_SrcInf.uSrcHsz=uSrcHSize;
	oVP_SrcInf.uSrcVsz=uSrcVSize;		
	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	SDTV_VariableMixerSettingForTest( (u32)uMxsdWin0StAddr, (u32)uMxsdWin1StAddr, 
									   uMxWin0HSize, uMxWin0VSize, uMxWin1HSize, uMxWin1VSize,
									   0,0,0,0,  RGB24);

	if(uMxWin0On == 1)
		MIXER_SetGrphWinOnOff(MX_WIN0, 1);
	else
		MIXER_SetGrphWinOnOff(MX_WIN0, 0);

	if(uMxWin1On == 1)
		MIXER_SetGrphWinOnOff(MX_WIN1, 1);
	else
		MIXER_SetGrphWinOnOff(MX_WIN1, 0);
	


	return TRUE;

}


// for Manual Test
u32 SDTV_SimplePlayOn(void)
{
	VP_EnableIP(1);
	MIXER_StartProcessing();
	// TV On
	TVENC_SetOnOff(1);
}

u32 SDTV_SimplePlayOff(void)
{
	VP_EnableIP(0);
	MIXER_StopProcessing();
	// TV On
	TVENC_SetOnOff(0);

	free(uMxsdWin0StAddr);
	free(uMxsdWin1StAddr);
}


// ing
void SDENCT_MakeIMG(void)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	oDownImage_Inform 	  oDownImg;

	IMG_FMT eSrcImgType;

	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;
	uWin1StAddr = uWin0StAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		//return 0;
	}


#if 1	

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	LoadFileSystem();
	u32 uVpFbStAddr = uFreeMemBufStAddr;
	if(pStorage->ReadFile(strFileName0, uVpFbStAddr0, uDataSize)) // Load NV12 img from sdhc
		UART_Printf("Success load image from sd(%s)\n",strFileName0);
	else
		UART_Printf("Fail to load image\n");	
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, YCBCR420_2P_CRCB_LE);
		//After Def.h
		//FIMC_CSC_Scaling_forSDTV(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
		//						FIMC_RGB888, eSrcImgType);
	}
	else
		UART_Printf("Fail to load image\n");	
#endif	

	// Graphic layer
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_InitFont();
	GLIB_Printf(90,160, "Window 0");
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_Printf(90,160, "Window 1");

	// VP setting
	oVP_SrcInf.eSrcBpp = NV12;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uImageSize_H;
	oVP_SrcInf.uSrcVsz=uImageSize_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImageSize_H;
	oVP_DstInf.uDstVsz = uImageSize_V;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_EnableIP(1);

	// Mixer setting
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);


	// Mixer setting (VP Only)
	//MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	//MIXER_SetVdWinOnOff(1);
	//MIXER_StartProcessing();
#else

	// Graphic layer
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_InitFont();
	GLIB_Printf(90,160, "Window 0");
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_Printf(90,160, "Window 1");
	
	// VP Setting
	//oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	//VP_InitIP(oVP_SrcInf, oVP_DstInf);
	//VP_EnableIP(1);

	// Mixer setting
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);
#endif



}

void SDENCT_SetVPMixer(void)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	oDownImage_Inform 	  oDownImg;

	IMG_FMT eSrcImgType;

	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00200000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00200000;
	uWin0StAddr = uBMPSrcAddr + 0x00200000;
	uWin1StAddr = uWin0StAddr + 0x00200000;

	if(eImgSz == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}
	else
	{
		UART_Printf("Not supported image size..\n");
		//return 0;
	}

	// VP setting
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	//VP_EnableIP(1);

	// Mixer setting
	MIXER_InitForATv(eImgSz, eScanMode, eTvStd);
	MIXER_SetVdWinOnOff(1);
	//MIXER_StartProcessing();
	
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	//UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);

}

void TestBreak(void)
{
	u32 uTempKey;

	uTempKey = UART_GetKey();				
	if(uTempKey == 's') 
		UART_Getc();
	else if(uTempKey == 'x')
	{
		VP_EnableIP(0);
		MIXER_SetVdWinOnOff(0);
	       TVENC_SetOnOff(0);
	}
}


u32 SDENCT_SWReset(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,  j,uGain0, uGain1, uOffset, utemp, uTempKey;
	//u32 uGain0_Max, uGain1_Max, uOffset_Max;
	
	oSDOUT_HueCtrl		  oYScaleVal, oCBScaleVal, oCRScaleVal;
	

	UART_Printf("[TVEncoder Reset Testl]\n");


	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Test Type\n");
		UART_Printf("0 : SFR reset value Check, 	1 : Aging Test \n");
		uTestType_Temp = UART_GetIntNum();
		if(uTestType_Temp>1)
			uTestType_Temp = 0;
	}
	else
	{
		uTestItem = (IMG_FMT)oPara.Test_Parameter[0];
	}

	SDENCT_MakeIMG();
	// TV On
	TVENC_SetOnOff(1);
	
	if(uTestType_Temp == 0)
	{
		TVENC_Reset();
		j= TVENC_RegResetValueVerify();
		if(j == true) UART_Printf("Reset test : PASS\n");
		else UART_Printf("Reset test: Fail \n");
	}
	else if (uTestType_Temp == 1)
	{
		//while(!UART_GetKey())
		for(i=0;i<1000;i++)
		{
		 #if 0 
			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_SetVdWinOnOff(0);
				TVENC_SetOnOff(0);
				return 1;
			}	
		#endif
		if(i%100 == 0) UART_Printf("Reset Test %d \n", i);
		TVENC_Reset();
		TVENC_RegResetValueVerify();
		SDTVENCT_InitForTest(eTvStd, eVideoSig);	
		TVENC_SetOnOff(1);
		INPUT_DELAY;	
		}
	}

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);
	
	return 1;
}




u32 SDENCT_IRQTest(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,  j,uGain0, uGain1, uOffset, utemp, uTempKey;
	//u32 uGain0_Max, uGain1_Max, uOffset_Max;
	
	oSDOUT_HueCtrl		  oYScaleVal, oCBScaleVal, oCRScaleVal;
	

	UART_Printf("[TVEncoder IRQ Test]\n");
	g_TVENC =0;
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Test Type\n");
		UART_Printf("0 :IRQ Enable \n");
		uTestType_Temp = UART_GetIntNum();
		if(uTestType_Temp>1)
			uTestType_Temp = 0;
	}
	else
	{
		uTestItem = (IMG_FMT)oPara.Test_Parameter[0];
	}

	SDENCT_MakeIMG();

	
	if(uTestType_Temp == 0)
	{
		INTC_SetVectAddr(NUM_TVENC, Isr_TVENC);
		INTC_Enable(NUM_TVENC);
		TVENC_ClearIntPending();
		TVENC_EnableIRQ();
				
		
	}
	// TV On
	TVENC_SetOnOff(1);

	UART_Printf("Press Enter to exit test code\n");
	UART_Getc();

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);
	TVENC_DisableIRQ();
	INTC_Disable(NUM_TVENC);
	
	return 1;
}


u32 SDENCT_HuenBrightCtrl(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,  j,uGain0, uGain1, uOffset, utemp;
	//u32 uGain0_Max, uGain1_Max, uOffset_Max;
	
	oSDOUT_HueCtrl		  oYScaleVal, oCBScaleVal, oCRScaleVal;
	

	UART_Printf("[TVEncoder Hue & Bright Control]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Test Type\n");
		UART_Printf("0 : Insert Value by Manually(D), 	1 : All of Value \n");
		uTestType_Temp = UART_GetIntNum();
		if(uTestType_Temp>1)
			uTestType_Temp = 0;
		if(uTestType_Temp == 1)
		{
			UART_Printf("Select the Test Items\n");
			UART_Printf("0 : Control for Y, 	1 : Control for CB, 2:Control for CR \n");
			uTestItem  =  UART_GetIntNum();
		}	
	}
	else
	{
		uTestItem = (IMG_FMT)oPara.Test_Parameter[0];
	}

	SDENCT_MakeIMG();

	// TV On
	TVENC_SetOnOff(1);
	
	if((eTest == eTest_Manual)&&(uTestType_Temp == 0))
	{

		i=0;
		while(i<3)
		{
		UART_Printf("Display Default Value \n");
		oYScaleVal.SDO_Gain0 = 0x80;		// Default Value
		oYScaleVal.SDO_Offset = 0; 			// Default Value
		oCBScaleVal.SDO_Gain0 = 0x80;		// Default Value
		oCBScaleVal.SDO_Gain1 = 0;		// Default Value
		oCBScaleVal.SDO_Offset = 0;		// Default Value
		oCRScaleVal.SDO_Gain0 = 0x00;		// Default Value
		oCRScaleVal.SDO_Gain1 = 0x80;		// Default Value
		oCRScaleVal.SDO_Offset = 0;		// Default Value	
		TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
	
		UART_Printf("Select Test Item : 0 - Y , 1 - CB, 2 - CR, 3- Test End\n");
		i  = UART_GetIntNum();

		if(i == 3) break;
		
	       UART_Printf("Insert Value of the Gain 0 : \n");
	     	uGain0  = UART_GetIntNum();
	     	if(i>0)
	     	{
	     	UART_Printf("Insert Value of the Gain 1 : \n");
	     	uGain1  = UART_GetIntNum();	     
	     	}
     	     	UART_Printf("Insert Value of the Offset : \n");
	     	uOffset  = UART_GetIntNum();	     

		switch(i)
		{
			case 0:
				oYScaleVal.SDO_Gain0 = uGain0;		
				oYScaleVal.SDO_Offset = uOffset; 
				break;
			case 1:
				oCBScaleVal.SDO_Gain0 = uGain0;	
				oCBScaleVal.SDO_Gain1 = uGain1;
				oCBScaleVal.SDO_Offset = uOffset; 
				break;
			case 2:
				oCRScaleVal.SDO_Gain0 = uGain0;	
				oCRScaleVal.SDO_Gain1 = uGain1;
				oCRScaleVal.SDO_Offset = uOffset; 
				break;				
		}
		
	     	TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);

		UART_Printf("Press anykey \n");
		UART_Getc();
	     	
		}
	
	}

	if(uTestType_Temp == 1)
	{

		// Set-up the Default Value & Set Max Value
		switch(uTestItem)
			{




			}
	
		UART_Printf("Hue&Brightness Control \n");
		UART_Printf(" Y - Gain Control  (0~255): ");
		for(i=0; i<=0xff; i++)
		{
 			TestBreak();
			oYScaleVal.SDO_Gain0 = i;
			oYScaleVal.SDO_Offset = 0; 			// Default Value
			oCBScaleVal.SDO_Gain0 = 0x80;		// Default Value
			oCBScaleVal.SDO_Gain1 = 0;		// Default Value
			oCBScaleVal.SDO_Offset = 0;		// Default Value
			oCRScaleVal.SDO_Gain0 = 0x0;		// Default Value
			oCRScaleVal.SDO_Gain1 = 0x80;		// Default Value
			oCRScaleVal.SDO_Offset = 0;		// Default Value		
			TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	
		UART_Printf("\n\n");
		UART_Printf(" Y - Offset Control  (0x100 ~ 0x1FF,0~0x0ff): ");
		for(j=0;j<2;j++)
		{
			utemp = (j==0) ? 0x100: 0;
			
			for(i=0; i<=0xff; i++)
			{
			TestBreak();		
			oYScaleVal.SDO_Gain0 = 0x80;
			oYScaleVal.SDO_Offset = i+utemp; 			// Default Value
			oCBScaleVal.SDO_Gain0 = 0x80;		// Default Value
			oCBScaleVal.SDO_Gain1 = 0;		// Default Value
			oCBScaleVal.SDO_Offset = 0;		// Default Value
			oCRScaleVal.SDO_Gain0 = 0x0;		// Default Value
			oCRScaleVal.SDO_Gain1 = 0x80;		// Default Value
			oCRScaleVal.SDO_Offset = 0;		// Default Value		
			TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
			}
		}
		
		UART_Printf("\n\n");
		UART_Printf(" CB - Gain0 Control  (0x100~0x1FF, 0~0xff): ");
		for(i=0; i<=0x1ff; i++)
		{
			TestBreak();
			oYScaleVal.SDO_Gain0 =0x80;
			oYScaleVal.SDO_Offset = 0; 			// Default Value
			oCBScaleVal.SDO_Gain0 = i;		// Default Value
			oCBScaleVal.SDO_Gain1 = 0;		// Default Value
			oCBScaleVal.SDO_Offset = 0;		// Default Value
			oCRScaleVal.SDO_Gain0 = 0x0;		// Default Value
			oCRScaleVal.SDO_Gain1 = 0x80;		// Default Value
			oCRScaleVal.SDO_Offset = 0;		// Default Value		
			TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	
		UART_Printf("\n\n");
		UART_Printf(" CB - Gain1 Control  (0x100~0x1FF, 0~0xff): ");
		for(i=0; i<=0x1ff; i++)
		{
			TestBreak();	
			oYScaleVal.SDO_Gain0 =0x80;
			oYScaleVal.SDO_Offset = 0; 			// Default Value
			oCBScaleVal.SDO_Gain0 =0x80;		// Default Value
			oCBScaleVal.SDO_Gain1 = i;		// 
			oCBScaleVal.SDO_Offset = 0;		// Default Value
			oCRScaleVal.SDO_Gain0 = 0x00;		// Default Value
			oCRScaleVal.SDO_Gain1 = 0x80;		// Default Value
			oCRScaleVal.SDO_Offset = 0;		// Default Value		
			TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}			
		UART_Printf("\n\n");
		UART_Printf(" CB- Offset Control  (0~255): ");
		for(i=0; i<=0x3ff; i++)
		{
			TestBreak();
			oYScaleVal.SDO_Gain0 = 0x80;
			oYScaleVal.SDO_Offset = 0; 			// Default Value
			oCBScaleVal.SDO_Gain0 = 0x80;		// Default Value
			oCBScaleVal.SDO_Gain1 = 0;		// Default Value
			oCBScaleVal.SDO_Offset = i;		// Default Value
			oCRScaleVal.SDO_Gain0 = 0x0;		// Default Value
			oCRScaleVal.SDO_Gain1 = 0x80;		// Default Value
			oCRScaleVal.SDO_Offset = 0;		// Default Value		
			TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	

		UART_Printf("\n\n");
		UART_Printf(" CR - Gain0 Control  (0x100~0x1FF, 0~0xff): ");
		for(i=0; i<=0x1ff; i++)
		{
			TestBreak();	
			oYScaleVal.SDO_Gain0 =0x80;
			oYScaleVal.SDO_Offset = 0; 			// Default Value
			oCBScaleVal.SDO_Gain0 = 0x80;		// Default Value
			oCBScaleVal.SDO_Gain1 = 0;		// Default Value
			oCBScaleVal.SDO_Offset = 0;		// Default Value
			oCRScaleVal.SDO_Gain0 = i;		// Default Value
			oCRScaleVal.SDO_Gain1 = 0x80;		// Default Value
			oCRScaleVal.SDO_Offset = 0;		// Default Value		
			TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	
		UART_Printf("\n\n");
		UART_Printf(" CR - Gain1 Control  (0x100~0x1FF, 0~0xff): ");
		for(i=0; i<=0x1ff; i++)
		{
			TestBreak();	
			oYScaleVal.SDO_Gain0 =0x80;
			oYScaleVal.SDO_Offset = 0; 			// Default Value
			oCBScaleVal.SDO_Gain0 = 0x80;		// Default Value
			oCBScaleVal.SDO_Gain1 = 0;		// Default Value
			oCBScaleVal.SDO_Offset = 0;		// Default Value
			oCRScaleVal.SDO_Gain0 = 0x0;		// Default Value
			oCRScaleVal.SDO_Gain1 = i;		// Default Value
			oCRScaleVal.SDO_Offset = 0;		// Default Value		
			TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}			
		UART_Printf("\n\n");
		UART_Printf(" CR- Offset Control  (0~255): ");
		for(i=0; i<=0x3ff; i++)
		{
			TestBreak();	
			oYScaleVal.SDO_Gain0 = 0x80;
			oYScaleVal.SDO_Offset = 0; 			// Default Value
			oCBScaleVal.SDO_Gain0 = 0x80;		// Default Value
			oCBScaleVal.SDO_Gain1 = 0;		// Default Value
			oCBScaleVal.SDO_Offset = 0;		// Default Value
			oCRScaleVal.SDO_Gain0 = 0x0;		// Default Value
			oCRScaleVal.SDO_Gain1 = 0x80;		// Default Value
			oCRScaleVal.SDO_Offset = i;		// Default Value		
			TVENC_SetHueBrightCtrl (0, oYScaleVal, oCBScaleVal , oCRScaleVal);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	
	}
	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);
	
	return 1;
}

u32 SDENCT_ColorCompensation(void)
{
	u32 uTestType_Temp, uTestItem;

	u32 i,uPara0, uPara1, uPara2, uPara3, uPara4;

	oSDOUT_YCnCVBS_CC   oCCVal;

	UART_Printf("[TVEncoder Color Compensation]\n");
	
	UART_Printf("Select the Test Type\n");
	UART_Printf("0 : Insert Value by Manually(D), 	1 : All of Value \n");
	uTestType_Temp = UART_GetIntNum();
	if(uTestType_Temp>1)
			uTestType_Temp = 0;

	SDENCT_MakeIMG();

	// TV On
	TVENC_SetOnOff(1);
	
	if(uTestType_Temp == 0)
	{
		uTestItem = 0;

		//Default
		TVENC_SetCVBSCC(1, oCCVal );
		TVENC_SetYCCC(1, oCCVal );
		TVENC_SetRGBCC(1, uPara0, uPara1 );
		TVENC_SetYPbPrCC(1);
		
		while(uTestItem<4)
		{
		UART_Printf("Select Test Item : 0 -CVBS , 1 - YC, 2 - RGB, 3 - YPbPr  4- Test End\n");
		uTestItem  = UART_GetIntNum();

		if((uTestItem == 0)||(uTestItem==1))
		{
			UART_Printf("Insert Value of the Top Y Boundary(0~0x3FF) : \n");
			uPara2 =  UART_GetIntNum();
			UART_Printf("Insert Value of the Bottom Y Boundary(0~0x3FF) : \n");
			uPara1 =  UART_GetIntNum();
			if(uTestItem ==0)					// CVBS
			{
				UART_Printf("Insert Value of the Lower Mid Y Boundary(0~0x3FF) : \n");
				uPara0 =  UART_GetIntNum();
				UART_Printf("Insert Value of the Upper Mid Y Boundary(0~0x3FF) : \n");
				uPara3 =  UART_GetIntNum();		
			}			
			UART_Printf("Insert Value of the Radius Boundary(0~0x1FF) : \n");
			uPara4 =  UART_GetIntNum();

	     	oCCVal.SDO_Y_Lower = uPara0;
	     	oCCVal.SDO_Y_Bottom = uPara1;
	     	oCCVal.SDO_Y_Top = uPara2;
	     	oCCVal.SDO_Y_Upper = uPara3;
	     	oCCVal.SDO_Y_Radius= uPara4;		
		}
		if(uTestItem ==3)
		{
			UART_Printf("Insert Value of the Max Cube(0~0xFF) : \n");
			uPara0 =  UART_GetIntNum();
			UART_Printf("Insert Value of the Min Cube(0~0xFF) : \n");
			uPara1 =  UART_GetIntNum();
			
		}   	

		switch(uTestItem)
		{
			case 0:
				TVENC_SetCVBSCC(0, oCCVal );
				break;
			case 1:
				TVENC_SetYCCC(0, oCCVal );
				break;
			case 2:
				TVENC_SetRGBCC(0, uPara0, uPara1 );
				break;		
			case 3:
				TVENC_SetYPbPrCC(0);
				break;						
		}
		
	     	
		}
	
	}

	if(uTestType_Temp == 1)
	{
		UART_Printf("Select Test Item : 0 -CVBS , 1 - YC, 2 - RGB, 3 - YPbPr  \n");
		uTestItem  = UART_GetIntNum();
if(uTestItem == 0)
		{
			UART_Printf("Y_Lower_Mid_CVBS_Corn(0~0x3FF) : \n");
			for(i=0;i<0x3ff; i++)
			{
			     	oCCVal.SDO_Y_Lower = i;
			     	oCCVal.SDO_Y_Bottom = 0;
	     			oCCVal.SDO_Y_Top = 0x3ff;	
		     		oCCVal.SDO_Y_Upper = 0x200;
			     	oCCVal.SDO_Y_Radius= 0x1FF;		
				TVENC_SetCVBSCC(0, oCCVal );
				UART_Printf("%d ", i);	
				DelayfrTimer(milli, 50);
			}
			INPUT_DELAY;
			
			UART_Printf("Y_Bottom_CVBS_Corn(0~0x3FF) : \n");
			for(i=0;i<0x3ff; i++)
			{
			     	oCCVal.SDO_Y_Lower = 0x200;
			     	oCCVal.SDO_Y_Bottom = i;
	     			oCCVal.SDO_Y_Top = 0x3ff;	//0x3ff
		     		oCCVal.SDO_Y_Upper = 0x200;
			     	oCCVal.SDO_Y_Radius= 0x1FF;		
				TVENC_SetCVBSCC(0, oCCVal );
				UART_Printf("%d ", i);	
				DelayfrTimer(milli, 50);
			}
			INPUT_DELAY;
			
			UART_Printf("Y_Top_CVBS_Corn(0~0x3FF) : \n");
			for(i=0;i<0x3ff; i++)
			{
			     	oCCVal.SDO_Y_Lower = 0x200;
			     	oCCVal.SDO_Y_Bottom = 0x0;
	     			oCCVal.SDO_Y_Top = i;	//0x3ff
		     		oCCVal.SDO_Y_Upper = 0x200;
			     	oCCVal.SDO_Y_Radius= 0x1FF;		
				TVENC_SetCVBSCC(0, oCCVal );
				UART_Printf("%d ", i);	
				DelayfrTimer(milli, 50);
			}
			INPUT_DELAY;
			
			UART_Printf("Y_Upper_CVBS_Corn(0~0x3FF) : \n");
			for(i=0;i<0x3ff; i++)
			{
			     	oCCVal.SDO_Y_Lower = 0x200;
			     	oCCVal.SDO_Y_Bottom = 0x0;
	     			oCCVal.SDO_Y_Top = 0x3ff;	//0x3ff
		     		oCCVal.SDO_Y_Upper = i;
			     	oCCVal.SDO_Y_Radius= 0x1FF;		
				TVENC_SetCVBSCC(0, oCCVal );
				UART_Printf("%d ", i);	
				DelayfrTimer(milli, 50);
			}
			INPUT_DELAY;

			UART_Printf("Y_Radius_CVBS_Corn(0~0x3FF) : \n");
			for(i=0;i<0x3ff; i++)
			{
			     	oCCVal.SDO_Y_Lower = 0x200;
			     	oCCVal.SDO_Y_Bottom = 0x0;
	     			oCCVal.SDO_Y_Top = 0x3ff;	//0x3ff
		     		oCCVal.SDO_Y_Upper = 0x200;
			     	oCCVal.SDO_Y_Radius= i;		
				TVENC_SetCVBSCC(0, oCCVal );
				UART_Printf("%d ", i);	
				DelayfrTimer(milli, 50);
			}
			INPUT_DELAY;			
			
		}
		else if(uTestItem == 1)			// YC Value
		{
			UART_Printf("YC Color Compensation \n");
			UART_Printf(" Top Y Boundary of Legal YC Cylinder  (0~0x3FF): ");
			for(i=0; i<=0x3ff; i++)
			{
	
	     			oCCVal.SDO_Y_Bottom = 0;
	     			oCCVal.SDO_Y_Top = i;	
	     			oCCVal.SDO_Y_Radius = 0x1FF;
				TVENC_SetYCCC(0, oCCVal );
				UART_Printf("%d ", i);	
				DelayfrTimer(milli, 50);
			}	
			UART_Printf("\n\n");
			UART_Printf(" Bottom Y Boundary of Legal YC Cylinder  (0~0x3FF): ");
			for(i=0; i<=0x3ff; i++)
			{
	
	     			oCCVal.SDO_Y_Bottom = i;
	     			oCCVal.SDO_Y_Top = 0x3FF;	
	     			oCCVal.SDO_Y_Radius = 0x1FF;
				TVENC_SetYCCC(0, oCCVal );
				UART_Printf("%d ", i);	
				DelayfrTimer(milli, 50);
			}	
			UART_Printf("\n\n");
			UART_Printf(" Radius of Legal YC Cylinder  (0~0x1FF): ");
			for(i=0; i<=0x1ff; i++)
			{
	
	     			oCCVal.SDO_Y_Bottom = 0;
	     			oCCVal.SDO_Y_Top = 0x3FF;	
	     			oCCVal.SDO_Y_Radius = i;
				TVENC_SetYCCC(0, oCCVal );
				UART_Printf("%d ", i);	
				DelayfrTimer(milli, 50);
			}	
			UART_Printf("\n\n");
		}

	}
	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);

	return 1;
	
}


//ing
u32 SDENCT_SignalScaling(void)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,uGain, uOffset;
	u32 eDAC;


	UART_Printf("[TVEncoder Signal Scaling Test]\n");
	
	UART_Printf("Select the Test Type\n");
	UART_Printf("0 : Insert Value by Manually(D), 	1 : All of Value \n");
	uTestType_Temp = UART_GetIntNum();
	if(uTestType_Temp>1)
			uTestType_Temp = 0;

	SDENCT_MakeIMG();

	// TV On
	TVENC_SetOnOff(1);
	
	if(uTestType_Temp == 0)
	{
		uTestItem = 0;

		//Default
		TVENC_SetChSignalScale (DAC0, 0x0, 0x800);		// Default Value
		TVENC_SetChSignalScale (DAC1, 0x0, 0x800);		// Default Value
		TVENC_SetChSignalScale (DAC2, 0x0, 0x800);		// Default Value

		
		while(uTestItem<3)
		{
			UART_Printf("Select Test Item : 0 -DAC0 , 1 - DAC1, 2 - DAC2, 3 -  Test End\n");
			uTestItem  = UART_GetIntNum();

			eDAC = 	(uTestItem == 0)? DAC0 :
						(uTestItem == 1)? DAC1 :
						(uTestItem == 2)? DAC2 : DAC_ALL;


			UART_Printf("Insert Value of the Offset(0~0x1FF(0~511), 0x200~0x3FF(-500~-1)) : \n");
			uOffset =  UART_GetIntNum();
			UART_Printf("Insert Value of the Gain(0(x0)~0x800(x1.0)~0xFFF(x2.0)) : \n");
			uGain =  UART_GetIntNum();

			TVENC_SetChSignalScale (eDAC, uOffset, uGain);
	     	
		}
	
	}

	if(uTestType_Temp == 1)
	{
		UART_Printf("Select Test Item : 0 -DAC0 , 1 - DAC1, 2 - DAC2, 3 -  Test End\n");
		uTestItem  = UART_GetIntNum();

		eDAC = 	(uTestItem == 0)? DAC0 :
				(uTestItem == 1)? DAC1 :
				(uTestItem == 2)? DAC2 : DAC_ALL;

	
		UART_Printf(" Offset Control  (0~0x3FF): ");
		for(i=0; i<=0x3ff; i++)
		{

			if(UART_GetKey()!=0x0)
			{
				UART_Printf("Value : %d/n", i);
				break;
			}
				
			TVENC_SetChSignalScale (eDAC, i, 0x800);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	
		UART_Printf("\n\n");
		UART_Printf(" Gain Control  (0~0xFFF): ");
		for(i=0; i<=0xfff; i++)
		{

			if(UART_GetKey()!=0x0)
			{
				UART_Printf("Value : %d/n", i);
				break;
			}
	
			TVENC_SetChSignalScale (eDAC,0, i);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	

	}
	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);

	return 1;

}


u32 SDENCT_PorchPositionCtrl(void)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,uBackPorch, uFrontForch;
	


	UART_Printf("[TVEncoder Porch Position Control]\n");
	
	UART_Printf("Select the Test Type\n");
	UART_Printf("0 : Insert Value by Manually(D), 	1 : All of Value \n");
	uTestType_Temp = UART_GetIntNum();
	if(uTestType_Temp>1)
			uTestType_Temp = 0;

	SDENCT_MakeIMG();

	// TV On
	TVENC_SetOnOff(1);
	
	if(uTestType_Temp == 0)
	{
		uTestItem = 0;

		//Default
		TVENC_Ctrl525Porch(0x8A, 0x359);		// Default Value
		TVENC_Ctrl625Porch(0x96, 0x35c);		// Default Value
		
		while(uTestItem<3)
		{
			UART_Printf("Select Test Item : 0 -525 Control , 1 - 625 Control,  3 -  Test End\n");
			uTestItem  = UART_GetIntNum();

			UART_Printf("Insert Value of the Back Porch(525:0x8A, 625:0x96)(0~0x3FF) : \n");
			uBackPorch =  UART_GetIntNum();
			UART_Printf("Insert Value of the Front Porch(525:0x359, 625:0x35C)(0~0x3FF) : \n");
			uFrontForch =  UART_GetIntNum();

			if(uTestItem == 0)
				TVENC_Ctrl525Porch(uBackPorch, uFrontForch);
			else 
				TVENC_Ctrl625Porch(uBackPorch, uFrontForch);
	     	
		}
	
	}

	if(uTestType_Temp == 1)
	{


		UART_Printf(" Back Porch Control  (0~0x3FF): ");
		for(i=0; i<=0x3ff; i++)
		{
	
			TVENC_Ctrl525Porch(i, 0x359);
			TVENC_Ctrl625Porch(i, 0x35c);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	
		UART_Printf("\n\n");
		UART_Printf(" Front Porch Control   (0~0x3FFF): ");
		for(i=0; i<=0x3ff; i++)
		{
			TVENC_Ctrl525Porch(0x8A, i);
			TVENC_Ctrl625Porch(0x96, i);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	

	}
	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);

	return 1;

}


u32 SDENCT_YCDelayCtrl(void)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,uYCDelay, uActStart, uActEnd;
	


	UART_Printf("[TVEncoder YC Delay Control]\n");
	
	UART_Printf("Select the Test Type\n");
	UART_Printf("0 : Insert Value by Manually(D), 	1 : All of Value \n");
	uTestType_Temp = UART_GetIntNum();
	if(uTestType_Temp>1)
			uTestType_Temp = 0;

	SDENCT_MakeIMG();

	// TV On
	TVENC_SetOnOff(1);
	
	if(uTestType_Temp == 0)
	{
		uTestItem = 0;

		//Default
		TVENC_SetYCDELAY(0x0, 0xfa, 0x0);		// Default Value
		
		while(uTestItem<3)
		{
			UART_Printf("Select Test Item : 3 -  Test End\n");
			uTestItem  = UART_GetIntNum();

			UART_Printf("Insert Value of the YC Delay(0x0)(0~0xf) : \n");
			uYCDelay =  UART_GetIntNum();
			UART_Printf("Insert Value of the Active Start(0xFA)(0~0xff) : \n");
			uActStart =  UART_GetIntNum();
			UART_Printf("Insert Value of the Active END(0xFA)(0~0xff) : \n");
			uActEnd =  UART_GetIntNum();

			TVENC_SetYCDELAY(uYCDelay, uActStart, uActEnd);
	     	
		}
	
	}

	if(uTestType_Temp == 1)
	{


		UART_Printf(" YC Delay Testl  (0~0xF): ");
		for(i=0; i<=0xf; i++)
		{
	
			TVENC_SetYCDELAY(i, 0x8a, 0x0);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	
		UART_Printf("\n\n");
		UART_Printf(" Active Start   (0~0xFF): ");
		for(i=0; i<=0xff; i++)
		{
			TVENC_SetYCDELAY(0, i, 0x0);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}	

		UART_Printf("\n\n");
		UART_Printf(" Active End   (0~0xFF): ");
		for(i=0; i<=0xff; i++)
		{
			TVENC_SetYCDELAY(0, 0x8a, i);
			UART_Printf("%d ", i);	
			DelayfrTimer(milli, 50);
		}			

	}
	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);

	return 1;

}


u32 SDENCT_SyncPulseConfig(void)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,uYCDelay, uActStart, uActEnd;
	


	UART_Printf("[TVEncoder Sync Pulse Insertion]\n");
	
	UART_Printf("Select the Test Type\n");
	UART_Printf("0 : Insert Value by Manually(D), 	1 : All of Value \n");
	uTestType_Temp = UART_GetIntNum();
	if(uTestType_Temp>1)
			uTestType_Temp = 0;

	SDENCT_MakeIMG();

		// TV On
	TVENC_SetOnOff(1);
		
	if(uTestType_Temp == 0)
	{
		uTestItem = 0;

		
		while(uTestItem<3)
		{
			UART_Printf("Select Test Item : 0: Absent Sync 1: One Channel 2: All Channel  Test End\n");
			uTestItem  = UART_GetIntNum();

			if(uTestItem == 0) TVENC_SetVidSync(SDOUT_SYNC_OFF);
			else if(uTestItem == 1) TVENC_SetVidSync(SDOUT_SYNC_ONE_CH);
			else if(uTestItem == 2) TVENC_SetVidSync(SDOUT_SYNC_ALL_CH);
	     			// TV On
			TVENC_SetOnOff(1);
		}
	
	}

	if(uTestType_Temp == 1)
	{
		TVENC_SetVidSync(SDOUT_SYNC_OFF);
		INPUT_DELAY;
		TVENC_SetVidSync(SDOUT_SYNC_ONE_CH);
		INPUT_DELAY;
		TVENC_SetVidSync(SDOUT_SYNC_ALL_CH);
		INPUT_DELAY;
	}


	
	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);

	return 1;

}

// ing
u32 SDENCT_WSSConfig(void)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,uYCDelay, uActStart, uActEnd;
	


	UART_Printf("[TVEncoder Wide Screen Signaling Test]\n");
	
	UART_Printf("Select the Test Type\n");
	UART_Printf("0 : Insert Value by Manually(D) \n");
	uTestType_Temp = UART_GetIntNum();
	if(uTestType_Temp>1)
			uTestType_Temp = 0;

	SDENCT_MakeIMG();

	// TV On
	TVENC_SetOnOff(1);
	
	if(uTestType_Temp == 0)
	{
		uTestItem = 0;

		
		UART_Printf("Select Test Item : 0: Off WSS  1: Insert WSS \n");
		uTestItem  = UART_GetIntNum();

		if(uTestItem == 0)
			TVENC_SetVBICfg (eVideoSig,  SDOUT_No_Insert, SDOUT_Type2_Insert, SDOUT_Type1_Insert );			
		else 
			TVENC_SetVBICfg (eVideoSig,  SDOUT_Type1_Insert, SDOUT_Type2_Insert, SDOUT_Type1_Insert );
	    	
	
	}
	if(uTestType_Temp == 1)
	{

	}

	while(!UART_GetKey())
	{
		if ( eTvStd == NTSC_M || eTvStd == NTSC_443 || eTvStd == PAL_M || eTvStd == PAL_60 )
		{
		TVENC_SetWss525CgmsRatio(SDOUT_WSS525_NORMAL);
		TVENC_SetWss525CciAndCopy(SDOUT_WSS525_CCI_ON,SDOUT_WSS525_COPY);
		TVENC_SetWss525AnalogAndPsp(SDOUT_WSS525_PSP_4LINE,SDOUT_WSS525_ANALOG_ON );
		}
		else if (eTvStd == PAL_N || eTvStd == PAL_NC || eTvStd == PAL_BGHID)
		{
		TVENC_SetWss625Ratio( SDOUT_WSS625_4_3_FULL );
		TVENC_SetWss625ModeAndColorAndHelper( SDOUT_WSS625_CAMERA, SDOUT_WSS625_PAL, SDOUT_WSS625_HELPER_OFF );
		TVENC_SetWss625TextAndSubtitle( SDOUT_WSS625_TELETEXT_OFF,   SDOUT_WSS625_SUBTITLE_OFF );
		TVENC_SetWss625SurroundAndCopyAndRestrict( SDOUT_WSS625_SURROUND_OFF, SDOUT_WSS625_COPYRIGHT_OFF, SDOUT_WSS625_COPY_RESTRICT_NOT );
		}

		if(TVENC_ShadowSFRVerify() == false) 
		{
			UART_Printf("Shadow test: Fail \n");
			UART_Getc();
		}	
		
	}

	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);

	return 1;

}



// ing
u32 SDENCT_CC_Config(void)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,j,uYCDelay, uActStart, uActEnd;

	u32 data;
	u16* pCC_data_short;
	u8 temp[2];
	u16 reset_cc[4] = {0x942c, 0x942c, 0x94ae, 0x94ae};

	UART_Printf("[TVEncoder Closed Caption Test]\n");
	
	UART_Printf("Select the Test Type\n");
	UART_Printf("0 : Insert Value by Manually(D) \n");
	uTestType_Temp = UART_GetIntNum();
	if(uTestType_Temp>1)
			uTestType_Temp = 0;

	SDENCT_MakeIMG();

	// TV On
	TVENC_SetOnOff(1);
	
	if(uTestType_Temp == 0)
	{
		uTestItem = 0;

		
		UART_Printf("Select Test Item : 0: Off CC  1:Null Data,  2: Max Toggle, 3: test stream \n");
		uTestItem  = UART_GetIntNum();

		if(uTestItem == 0)
			TVENC_SetVBICfg (eVideoSig,  SDOUT_Type1_Insert, SDOUT_No_Insert, SDOUT_Type1_Insert );			
		else 
			TVENC_SetVBICfg (eVideoSig,  SDOUT_Type2_Insert, SDOUT_Type2_Insert, SDOUT_Type2_Insert );    	

	if(uTestItem == 1)		// Null Data
	{
		while(!UART_GetKey())
		{
			if ( TVENC_GetFieldId() == SDOUT_BOTTOM )
			{
				TVENC_SetCCData(0x8080);
			}
		}
	
	}
	else if(uTestItem == 2)	//Max toggle
	{
		while(!UART_GetKey())
		{
			if ( TVENC_GetFieldId() == SDOUT_BOTTOM )
			{
				if (gCC_Data_cnt % 2)
				{
				data = 0x7F7F;
				gCC_Data_cnt = 0;
				}
				else
				{
				data = 0x8080;
				gCC_Data_cnt++;
				}
				TVENC_SetCCData(data);
			}
		}
		
	}
	else if(uTestItem == 3)	// teststream
	{
		while(!UART_GetKey())
		{
			pCC_data_short = (u16*)TestStream9;
		
			if ( TVENC_GetFieldId() == SDOUT_BOTTOM )
			{
				if (gCC_Data_cnt < gCC_data.file_size / 2 + 4) // 2byte per one closed caption data
				{
					if (gCC_Data_cnt < 4)                                    // header 4 byte
					{
					data = reset_cc[gCC_Data_cnt];
					}
				else
				{
					data = pCC_data_short[gCC_Data_cnt - 4]; //endian change
					temp[1] = ((u8*)&data)[0];
					temp[0] = ((u8*)&data)[1];
					data = ((u16*)temp)[0];
				}
			}
			else
			{
				gCC_Data_cnt = 0;
			}
				TVENC_SetCCData(data);
			gCC_Data_cnt++;
			}

			
		}
	}

	
	}
	if(uTestType_Temp == 1)
	{
		
	}

	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);

	return 1;

}


u32 SDENCT_BlackBurstXtalk(void)
{

	u32 uTestType_Temp, uTestItem;
	u32 i,j,uCoef2, uCoef1, uBBLvl;
	u32 eDAC;


	UART_Printf("[TVEncoder Porch Position Control]\n");
	
	UART_Printf("Select the Test Type\n");
	UART_Printf("0 : Insert Value by Manually(D), 	1 : All of Value \n");
	uTestType_Temp = UART_GetIntNum();
	if(uTestType_Temp>1)
			uTestType_Temp = 0;

	SDENCT_MakeIMG();

	// TV On
	TVENC_SetOnOff(1);
	
	if(uTestType_Temp == 0)
	{
		uTestItem = 0;

		//Default
		TVENC_SetXtalkCoef(DAC0, 0x0, 0x0);		// Default Value
		TVENC_SetXtalkCoef(DAC1, 0x0, 0x0);		// Default Value
		TVENC_SetXtalkCoef(DAC2, 0x0, 0x0);		// Default Value

		TVENC_DisBBMode();
		
		while(uTestItem<3)
		{
			UART_Printf("Select Test Item :0: DAC0 , 1 : DAC1, 2: DAC2  3 -  Test End\n");
			uTestItem  = UART_GetIntNum();

			eDAC = 	(uTestItem == 0)? DAC0 :
						(uTestItem == 1)? DAC1 :
						(uTestItem == 2)? DAC2 : DAC_ALL;

			UART_Printf("Xtalk cancellation Coefficient2 : (0~0xFF) : \n");
			uCoef2 =  UART_GetIntNum();
			UART_Printf("Xtalk cancellation Coefficient1 (0~0xFF) : \n");
			uCoef1 =  UART_GetIntNum();

			UART_Printf("Black Level Setting Value (NTSC:0x11A, PAL:0xFB) : \n");
			uBBLvl =  UART_GetIntNum();

			TVENC_SetXtalkCoef(eDAC, uCoef2, uCoef1);
	     		TVENC_EnBBMode(eDAC, uBBLvl);	
		}
	
	}

	if(uTestType_Temp == 1)
	{

		for(uTestItem=0; uTestItem<3; uTestItem++)
		{

		eDAC = 	(uTestItem == 0)? DAC0 :
				(uTestItem == 1)? DAC1 :
				(uTestItem == 2)? DAC2 : DAC_ALL;
		
		if( (eTvStd == NTSC_M) || (eTvStd == NTSC_J) || (eTvStd == PAL_M) || (eTvStd == NTSC_443) )
		TVENC_EnBBMode(eDAC, 0x11A);
		else
		TVENC_EnBBMode(eDAC, 0xFB);
			
		UART_Printf(" Back Porch Control  (0~0x3FF): ");

		for(j=0;j<=0xff;j++)
		{
			for(i=0; i<=0xff; i++)
			{
	
			TVENC_SetXtalkCoef(eDAC, i, j);
			UART_Printf("%d,%d ", i, j);	
			DelayfrTimer(milli, 50);
			}	
		}	
		}

	}
	// Waiting
	INPUT_DELAY;

	//TV Off
	VP_EnableIP(0);
	MIXER_SetVdWinOnOff(0);
	TVENC_SetOnOff(0);

	return 1;

}

u32 SDOUT_BlockPowerOnOff(void)
{
	s32 uRanOffset;
	u32 uCount=1;
	//u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	//u32 uImageSize_H, uImageSize_V;
	//u32 uSrcImgType_Temp;
	//IMG_FMT eSrcImgType;
	//IMG_FMT eSrcImgType_Temp;
		
	UART_Printf("[SDOUT_BlockPowerOnOff]\n");


	UART_Printf("Input the random offset value\n");
	//uRanOffset = UART_GetIntNum();
	//srand(uRanOffset);

	//INTC_SetVectAddr(NUM_TVENC, Isr_TVENC);
	//INTC_Enable(NUM_TVENC);
	//TVENC_ClearIntPending();
	//TVENC_DisableIRQ();
	
	SDENCT_MakeIMG();
	
	while(!UART_GetKey())
	{
		UART_Printf("Count : %d\n", uCount++);
		g_TVENC =0;
		// TV On
		SDTVENCT_InitForTest(eTvStd, eVideoSig);
		SDVPT_InitParaForTV(NV12);
		SDMXT_InitParaForTV();

		//TVENC_DisableIRQ();	

		SDENCT_SetVPMixer();
		VP_EnableIP(1);
		MIXER_StartProcessing();
		TVENC_SetOnOff(1);

		DelayfrTimer(milli, 5000);

		//TV Off
		VP_EnableIP(0);
		MIXER_StopProcessing();
//		DelayfrTimer(milli, 20);

		
		TVENC_SetOnOff(0);
#if 0
		TVENC_ClearIntPending();
		TVENC_EnableIRQ();


		while(g_TVENC <1);
		TVENC_DisableIRQ();
#endif		
		//DelayfrTimer(milli, 14);

		//For Debugging
		// 0 Delay : VP Under-run
		// 1ms      : VP Under-run
		// 10ms    : VP under-run
		// 14ms    : No Under-run
		// 100ms  : No Under-run

		
		// T-Block Power Off and On
		// case 0 : CLK OFF - BLK OFF - BLK ON - CLK ON  : fail
		// case 1 : BLK OFF - CLK OFF - CLK ON - BLK ON  : OK but VP under-Run Int.
		// case 2 : BLK OFF - CLK OFF - BLK ON - CLK ON  : fail
		// case 3 : CLK OFF - BLK OFF - CLK ON - BLK ON  : pass
		#if 0 // fail
		SYSC_SetClkOFF_IP(eVP);
		SYSC_SetClkOFF_IP(eMIXER);
		SYSC_SetClkOFF_IP(eTVENC);	
		SYSC_SetBlockPowerOFF_IP(eSDTV);

		DelayfrTimer(milli, SBLK_GetRand()%10);			// under 10ms
		//DelayfrTimer(milli, 5000);

		SYSC_SetBlockPowerON_IP(eSDTV);
		SYSC_SetClkON_IP(eVP);
		SYSC_SetClkON_IP(eMIXER);
		SYSC_SetClkON_IP(eTVENC);
		#endif
		#if 1 // Pass
		SYSC_SetBlockPowerOFF_IP(eSDTV);
		SYSC_SetClkOFF_IP(eVP);
		SYSC_SetClkOFF_IP(eMIXER);
		SYSC_SetClkOFF_IP(eTVENC);
		DelayfrTimer(milli, SBLK_GetRand()%10);			// under 10ms
		//DelayfrTimer(milli, 5000);
		SYSC_SetClkON_IP(eVP);
		SYSC_SetClkON_IP(eMIXER);
		SYSC_SetClkON_IP(eTVENC);
		SYSC_SetBlockPowerON_IP(eSDTV);
		#endif
		#if 0 //fail
		SYSC_SetBlockPowerOFF_IP(eSDTV);
		SYSC_SetClkOFF_IP(eVP);
		SYSC_SetClkOFF_IP(eMIXER);
		SYSC_SetClkOFF_IP(eTVENC);

		DelayfrTimer(milli, SBLK_GetRand()%10);			// under 10ms
		//DelayfrTimer(milli, 5000);

		SYSC_SetBlockPowerON_IP(eSDTV);
		SYSC_SetClkON_IP(eVP);
		SYSC_SetClkON_IP(eMIXER);
		SYSC_SetClkON_IP(eTVENC);
		#endif		
		#if 0 // OK
		SYSC_SetClkOFF_IP(eVP);
		SYSC_SetClkOFF_IP(eMIXER);
		SYSC_SetClkOFF_IP(eTVENC);	
		SYSC_SetBlockPowerOFF_IP(eSDTV);

		DelayfrTimer(milli, SBLK_GetRand()%10);			// under 10ms
		//DelayfrTimer(milli, 5000);
		SYSC_SetClkON_IP(eVP);
		SYSC_SetClkON_IP(eMIXER);
		SYSC_SetClkON_IP(eTVENC);
		SYSC_SetBlockPowerON_IP(eSDTV);

		#endif

	}
	
	return TRUE;
}

u32 SDOUT_ClockOnOff(void)
{
	s32 uRanOffset;
	u32 uCount=1;
	//u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	//u32 uImageSize_H, uImageSize_V;
	//u32 uSrcImgType_Temp;
	//IMG_FMT eSrcImgType;
	//IMG_FMT eSrcImgType_Temp;
		
	UART_Printf("[SDOUT_BlockPowerOnOff]\n");


	UART_Printf("Input the random offset value\n");
	uRanOffset = UART_GetIntNum();
	srand(uRanOffset);

	SDENCT_MakeIMG();
	
	while(!UART_GetKey())
	{
		UART_Printf("Count : %d\n", uCount++);
		
		// TV On
		SDENCT_SetVPMixer();

		// IP Clock Off and On Before IP Running.....
		SYSC_SetClkOFF_IP(eVP);
		SYSC_SetClkOFF_IP(eMIXER);
		SYSC_SetClkOFF_IP(eTVENC);
		DelayfrTimer(milli, rand()%10);			// under 10ms
		SYSC_SetClkON_IP(eVP);
		SYSC_SetClkON_IP(eMIXER);
		SYSC_SetClkON_IP(eTVENC);
		
		VP_EnableIP(1);
		MIXER_StartProcessing();
		TVENC_SetOnOff(1);

		DelayfrTimer(milli, 10000);

		//TV Off
		VP_EnableIP(0);
		MIXER_StopProcessing();
		TVENC_SetOnOff(0);	
		
	}
	
	return TRUE;
}

u32 SDOUT_PowerMode(void)
{
	s32 uRanOffset;
	u32 uCount=1;
	//u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	//u32 uImageSize_H, uImageSize_V;
	//u32 uSrcImgType_Temp;
	//IMG_FMT eSrcImgType;
	//IMG_FMT eSrcImgType_Temp;
		
	UART_Printf("[SDOUT_PowerMode]\n");


	UART_Printf("Input the random offset value\n");
	uRanOffset = UART_GetIntNum();
	srand(uRanOffset);

	SDENCT_MakeIMG();
	
	while(!UART_GetKey())
	{
		UART_Printf("Count : %d\n", uCount++);
		
		// TV On
		SDENCT_SetVPMixer();
		
		VP_EnableIP(1);
		MIXER_StartProcessing();
		TVENC_SetOnOff(1);

		DelayfrTimer(milli, rand()%1000);
		// Entering the random power mode(Idle, Deep Idle, Stop, Deep Stop, Sleep, & S/W reset)
		SYSCT_TestSimplePowerMode_Temp(rand()%6+1);	

		DelayfrTimer(milli, 10000);

		//TV Off
		VP_EnableIP(0);
		MIXER_StopProcessing();
		TVENC_SetOnOff(0);	
		
	}
	
	return TRUE;
}


const AutotestFuncMenu SDOUT_ETC_menu[]=
{
	SDOUT_BlockPowerOnOff,					"SDOUT Block Power On/Off",
	SDOUT_ClockOnOff,						"SDOUT Clock On/Off",
	SDOUT_PowerMode,						"SDOUT Power Mode",
	0,0
};

u32 SDOUT_ETCTest(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;
	s32 sSel;
	
	while (true)
	{
		UART_Printf("\n");
		UART_Printf("\n");
		for ( i=0; (int)(SDOUT_ETC_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, SDOUT_ETC_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(SDOUT_ETC_menu)/8-1))
			(SDOUT_ETC_menu[sSel].func) (eTest_Manual, oPara);
	}


	return OK;
}


const AutotestFuncMenu SDMXT_menu[]=
{
	
	//-- Mixer -- 
	SDMXT_SimpleDisplay,				"Mixer Simple Display",
	SDMXT_Blending,						"Mixer Blending",
	SDMXT_Blending_FullTest,			"Mixer Blending Full Test",
	SDMXT_Cropping,					"Mixer Cropping",
	SDMXT_SourceImgPositioning,		"Mixer Source Image Positioning",
	SDMXT_DestinationImgPositioning,	"Mixer Destination Image Positioning",
	SDMXT_ColorSpaceConversion,		"Mixer CSC",
	SDMXT_Scaling,						"Mixer Scaling",
	SDMXT_ColorKey,					"Mixer ColorKey",
	SDMXT_ColorKey_FullTest,			"Mixer ColorKey Full Test",
	SDMXT_BigEndianMode,				"Mixer Big Endian",	
	SDMXT_RandomDisplay,				"Mixer Random Display\n",	
	

	0,0
};

void SDMX_Test(void)
{
	u32 i;
	s32 uSel;
	oFunctionT_AutoVar oParameter;
	
	while(1)
	{
		for (i=0; (u32)(SDMXT_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, SDMXT_menu[i].desc);

		UART_Printf("\nSelect the function to test : \n");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if (uSel == -1)
			break;
		if (uSel>=0 && uSel<(sizeof(SDMXT_menu)/8-1))
			(SDMXT_menu[uSel].func) (eTest_Manual, oParameter);
	}

}


const AutotestFuncMenu SDVPT_menu[]=
{
	
	// -- VP --
	SDVPT_SimpleDisplay,				"VP Simple Display",
	SDVPT_SimpleDisplay_temp,			"temp",
	SDVPT_Scaling,						"VP Scaling Test",
	SDVPT_SourceCropping,				"VP Source Cropping Test",
	SDVPT_SourceImgPositioning,		"VP Source Image Positioning",
	SDVPT_DestinationImgPositioning,	"VP Destination Image Positioning",
	SDVPT_ColorSpaceConversion,		"VP CSC",
	SDVPT_Enhacement,					"VP Enhancement",
	SDVPT_PictureBigEndianMode,		"VP Endian Mode", 	
	SDVPT_RandomDisplay,				"VP Random Display\n",

	0,0
};
void SDVP_Test(void)
{
	u32 i;
	s32 uSel;
	oFunctionT_AutoVar oParameter;
	
	while(1)
	{
		for (i=0; (u32)(SDVPT_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, SDVPT_menu[i].desc);

		UART_Printf("\nSelect the function to test : \n");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if (uSel == -1)
			break;
		if (uSel>=0 && uSel<(sizeof(SDVPT_menu)/8-1))
			(SDVPT_menu[uSel].func) (eTest_Manual, oParameter);
	}

}


const AutotestFuncMenu SDENCT_menu[]=
{
	
	// -- TV Enc --
	TestTVENC_SFR,						"TVENC SFR Read/Write",
	SDENCT_SWReset,					"TVENC Reset Test",
	SDENCT_IRQTest,					"TVENC IRQ&FIFO Test",
	SDENCT_HuenBrightCtrl,				"Hue & Brightness Control",
	SDENCT_ColorCompensation,			"Color Compensation Test",
	SDENCT_SignalScaling,				"Channel Signal Scaling",
	SDENCT_WSSConfig,					"Wide Screen Signaling-Temp",
	SDENCT_CC_Config,					"Closed Caption Signaling",
	SDENCT_PorchPositionCtrl,			"Porch Position Controlling(Composite)",
	SDENCT_YCDelayCtrl,					"YC Delay Test(S-Video)",
	SDENCT_SyncPulseConfig,			"Sync Pulse insertion (Componenent)",
	SDENCT_BlackBurstXtalk,				"Black Burst Test Mode\n",	

	SDOUT_ETCTest,							"sdout ETC Test",
	0,0
};

void SDENC_Test(void)
{
	u32 i;
	s32 uSel;
	oFunctionT_AutoVar oParameter;
	
	while(1)
	{
		for (i=0; (u32)(SDENCT_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, SDENCT_menu[i].desc);

		UART_Printf("\nSelect the function to test : \n");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if (uSel == -1)
			break;
		if (uSel>=0 && uSel<(sizeof(SDENCT_menu)/8-1))
			(SDENCT_menu[uSel].func) (eTest_Manual, oParameter);
	}

}

const AutotestFuncMenu TVENC_menu[]=
{

	SDMX_Test,							"SD Mixer Test",
	SDVP_Test,							"SD VP Test",	
	SDENC_Test,							"TV Encoder Test",
	SDOUT_BlockPowerOnOff, 			"temp",
	#if 0
	//-- Mixer -- 
	SDMXT_SimpleDisplay,				"Mixer Simple Display",
	SDMXT_Blending,						"Mixer Blending",
	SDMXT_Blending_FullTest,			"Mixer Blending Full Test",
	SDMXT_Cropping,					"Mixer Cropping",
	SDMXT_SourceImgPositioning,		"Mixer Source Image Positioning",
	SDMXT_DestinationImgPositioning,	"Mixer Destination Image Positioning",
	SDMXT_ColorSpaceConversion,		"Mixer CSC",
	SDMXT_Scaling,						"Mixer Scaling",
	SDMXT_ColorKey,					"Mixer ColorKey",
	SDMXT_ColorKey_FullTest,			"Mixer ColorKey Full Test\n",
	
	// -- VP --
	SDVPT_SimpleDisplay,				"VP Simple Display",
	SDVPT_Scaling,						"VP Scaling Test",
	SDVPT_SourceCropping,				"VP Source Cropping Test",
	SDVPT_SourceImgPositioning,		"VP Source Image Positioning",
	SDVPT_DestinationImgPositioning,	"VP Destination Image Positioning",
	SDVPT_ColorSpaceConversion,		"VP CSC",
	SDVPT_Enhacement,					"VP Enhancement",
	SDVPT_RandomDisplay,				"VP Random Display\n",

	// -- TV Enc --
	TestTVENC_SFR,						"TVENC SFR Read/Write",
	SDENCT_SWReset,					"TVENC Reset Test",
	SDENCT_IRQTest,					"TVENC IRQ&FIFO Test",
	SDENCT_HuenBrightCtrl,				"Hue & Brightness Control",
	SDENCT_ColorCompensation,			"Color Compensation Test",
	SDENCT_SignalScaling,				"Channel Signal Scaling",
	SDENCT_WSSConfig,					"Wide Screen Signaling-Temp",
	SDENCT_CC_Config,					"Closed Caption Signaling",
	SDENCT_PorchPositionCtrl,			"Porch Position Controlling(Composite)",
	SDENCT_YCDelayCtrl,					"YC Delay Test(S-Video)",
	SDENCT_SyncPulseConfig,			"Sync Pulse insertion (Componenent)",
	SDENCT_BlackBurstXtalk,				"Black Burst Test Mode\n",	

	SDOUT_ETCTest,							"HDMI ETC Test",
	#endif
	0,0
};

	
void Test_SDOUT(void)
{
	s32 sSel;
	u32 i, uFormatNum;
	oFunctionT_AutoVar oPara;
	TV_TYPE aTvOutFormat[] =
	{
		"NTSC-M", 				NTSC_M,
		"PAL-M",  				PAL_M,
		"PAL-B/D/G/H/I", 		PAL_BGHID,
		"PAL-N",    				PAL_N,	
		"PAL-Nc", 				PAL_NC,
		"PAL-60",    				PAL_60,		
		"NTSC-443", 				NTSC_443,
	};
	
/// 	InitBaseHwForUsb();
///	FIMC_Init(0);
	InitBaseHWForSdout();
	//PHYConfig(ePHY_FREQ_27, HDMI_CD_24);

	UART_Printf("\n");
	UART_Printf("0. Composite Out(D)	1. S-Video Out 	2. Component(Interlaced)	3. Component(Progressive)\n");
	UART_Printf("Select the video output type : ");
	
	eVideoSig = (SDOUT_VIDEO_SIGNAL)UART_GetIntNum();

	uFormatNum = sizeof(aTvOutFormat)/sizeof(TV_TYPE);
	for (i = 0; i < uFormatNum; i++)
		UART_Printf("[%d] : %s\n", i, aTvOutFormat[i].pDesc);
	UART_Printf("\n");
	
	UART_Printf("Select the signal type : ");
	eTvStd = (TV_STANDARDS)UART_GetIntNum();
	UART_Printf("\n");

	SDTVENCT_InitForTest(eTvStd, eVideoSig);
	SDVPT_InitParaForTV(NV12);
	SDMXT_InitParaForTV();
	
///	oIntc.InitIp();
///	oIntc.SetHandlerAndUnmask(INT_TVENC, Isr_Sdout);
///	pStorage = (FILE_STORAGE*)&oUsb;
///	bUsbStorage = true;

///	u32 uUsbBufStAddr = CODEC_MEM_ST;
///	oUsb.InitIp(uUsbBufStAddr, USB_HIGH, USB_DMA, NotifyEnumDone);
///	oIntc.SetHandlerAndUnmask(INT_USB, Isr_Usb);
///	oUsb.GetBufEndAddr(uFreeMemBufStAddr);

	while (true)
	{
		for ( i=0; (int)(TVENC_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, TVENC_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(TVENC_menu)/8-1))
			(TVENC_menu[sSel].func) (eTest_Manual, oPara);
	}
		// Set DAC Disable
	#if 0
	uTemp = Inp32(0xe010e810);
	uTemp &= ~(1<<0);
	Outp32(0xe010e810, uTemp);
	#endif
	SYSC_DisDAC();
}

