#ifndef __SDOUT_H__
#define __SDOUT_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef enum 
{
	SDOUT_COMPOSITE_SIG,
	SDOUT_SVIDEO_SIG,
	SDOUT_COMPONENT_SIG,	//Interlaced
	//added by rb1004...090102
	SDOUT_COMPONENT_SIG_PROG,
	//added by jwj - 090209
	SDOUT_COMPONENT_RGB,
	SDOUT_COMPONENT_RGB_PROG
}SDOUT_VIDEO_SIGNAL;

typedef enum 
{
	SDOUT_RGB,
	SDOUT_YPBPR
}SDOUT_IF;

// jwj
typedef enum
{
	Y_SIG			= 0,
	Pb_SIG			= 1,
	Pr_SIG			= 2,
	R_SIG			= 0,
	G_SIG			= 1,
	B_SIG			= 2,
	CVBS_SIG		= 0,
	Y_SVD_SIG		= 1,
	C_SVD_SIG		= 2,
}DAC_SIG;

typedef enum 
{
	SDOUT_SLS_0_IRE,		
	SDOUT_SLS_7_5_IRE 		
}SDOUT_SETUP_LEVEL_SEL;

typedef enum 
{
	SDOUT_VTSRS_10_4,		
	SDOUT_VTSRS_7_3			
}SDOUT_VID_SYNC_RATIO;

typedef enum 
{
	SDOUT_SYNC_OFF			= 0,
	SDOUT_SYNC_ONE_CH		= 1,
	SDOUT_SYNC_RESERVED		= 2,
	SDOUT_SYNC_ALL_CH		= 3
}SDOUT_SYNC_CONFIG;


//jwj
typedef enum
{
	SDOUT_No_Insert		=0,
	SDOUT_Type1_Insert 	=1,			// WSS : 525 line (20H&283H), 625 line (23H)
										// CC  : 525 line (21H), 625 line (not Support)
										// CGMS-A: 43H
	SDOUT_Type2_Insert 	=2			// CC: 525 line (21H & 284H )
}SDOUT_InsertVBI;

//jwj
typedef enum
{
	DAC0, DAC1, DAC2, DAC_ALL
}SDOUT_DAC;

typedef enum 
{
	SDOUT_MV_OFF,
	SDOUT_MV_NTSC_AGC_ONLY,
	SDOUT_MV_NTSC_AGC_2L,
	SDOUT_MV_NTSC_AGC_4L,
	SDOUT_MV_PAL_AGC_ONLY,
	SDOUT_MV_PAL_AGC_2L,
	SDOUT_MV_PAL_AGC_4L
}SDOUT_MACROVISION_VAL;

//jwj
typedef struct
{
	u32 SDO_Offset;
	u32 SDO_Gain0;
	u32 SDO_Gain1;
}oSDOUT_HueCtrl;
//jwj
typedef struct
{
	u32 SDO_Y_Lower;
	u32 SDO_Y_Bottom;
	u32 SDO_Y_Top;
	u32 SDO_Y_Upper;
	u32 SDO_Y_Radius;
}oSDOUT_YCnCVBS_CC;

//jwj
typedef enum
{
	SDOUT_SYNC_COMPOSITE	=0,
	SDOUT_SYNC_SEPARATE=1
}SDOUT_VESA_SYNC;

typedef enum
{
	SDOUT_SYNC_LOW	= 0,
	SDOUT_SYNC_HIGH	= 1
}SDOUT_SYNC_POLARITY;


typedef enum 
{
	SDOUT_WSS525_NORMAL,
	SDOUT_WSS525_ANAMORPHIC,
	SDOUT_WSS525_LB
}SDOUT_WSS525_RATIO_T;

typedef enum 
{
	SDOUT_WSS525_CCI_ON,
	SDOUT_WSS525_CCI_OFF
}SDOUT_WSS525_CCI_T;

typedef enum 
{
	SDOUT_WSS525_COPY,
	SDOUT_WSS525_COPY_ONE,
	SDOUT_WSS525_COPY_RESERVED,
	SDOUT_WSS525_COPY_NO
}SDOUT_WSS525_COPY_T;

typedef enum 
{
	SDOUT_WSS525_PSP_OFF,
	SDOUT_WSS525_PSP_2LINE,
	SDOUT_WSS525_PSP_ONLY,
	SDOUT_WSS525_PSP_4LINE
}SDOUT_WSS525_PSP_T;

typedef enum 
{
	SDOUT_WSS525_ANALOG_OFF,
	SDOUT_WSS525_ANALOG_ON
}SDOUT_WSS525_ANALOG_T;

typedef enum 
{
	SDOUT_WSS625_4_3_FULL       = 0x8,
	SDOUT_WSS625_14_9_LB_C      = 0x1,
	SDOUT_WSS625_14_9_LB_T      = 0x2,
	SDOUT_WSS625_16_9_LB_C      = 0xB,
	SDOUT_WSS625_16_9_LB_T      = 0x4,
	SDOUT_WSS625_16_9_LB_C2     = 0xD,
	SDOUT_WSS625_14_9_FULL      = 0xE,
	SDOUT_WSS625_16_9_FULL      = 0x7
}SDOUT_WSS625_RATIO_T;

typedef enum 
{
	SDOUT_WSS625_CAMERA,
	SDOUT_WSS625_FILM
}SDOUT_WSS625_MODE_T;

typedef enum 
{
	SDOUT_WSS625_PAL,
	SDOUT_WSS625_MA
}SDOUT_WSS625_COLOR_T;

typedef enum 
{
	SDOUT_WSS625_HELPER_OFF,
	SDOUT_WSS625_HELPER_ON
}SDOUT_WSS625_HELPER_T;

typedef enum 
{
	SDOUT_WSS625_TELETEXT_OFF,
	SDOUT_WSS625_TELETEXT_ON
}SDOUT_WSS625_TELETEXT_T;

typedef enum 
{
	SDOUT_WSS625_SUBTITLE_OFF,
	SDOUT_WSS625_SUBTITLE_INSIDE,
	SDOUT_WSS625_SUBTITLE_OUTSIDE
}SDOUT_WSS625_SUBTITLE_T;

typedef enum 
{
	SDOUT_WSS625_SURROUND_OFF,
	SDOUT_WSS625_SURROUND_ON
}SDOUT_WSS625_SURROUND_T;

typedef enum 
{
	SDOUT_WSS625_COPYRIGHT_OFF,
	SDOUT_WSS625_COPYRIGHT_ON
}SDOUT_WSS625_COPYRIGHT_T;

typedef enum 
{
	SDOUT_WSS625_COPY_RESTRICT_NOT,
	SDOUT_WSS625_COPY_RESTRICT
}SDOUT_WSS625_RESTRICT_T;

typedef enum 
{
	SDOUT_VSYNC
}SDOUT_INTR_SRC;

typedef enum
{
	SDOUT_TOP,	/* SDOut Field ID is Top */
	SDOUT_BOTTOM	/* SDOut Field ID is Bottom */
} SD_FieldId;

typedef struct{
	u8   *file_name;
	u32    file_size;
}CMMFile_st;



void TestTVENC_SFR(void);
u32 TVENC_RegResetValueVerify(void);
void TVENC_InitIp( TV_STANDARDS eTvSys, SCAN_MODE eScanMode, SDOUT_VIDEO_SIGNAL eVidSignal );
void TVENC_InitIpAndSetOn( TV_STANDARDS    eTvSys, SCAN_MODE eScanMode, SDOUT_VIDEO_SIGNAL eVidSignal );
void TVENC_SetComponentIf( SDOUT_IF eIf );
//void TVENC_SetMacrovision( SDOUT_MACROVISION_VAL eMType, TV_STANDARDS eTvSys );
void TVENC_SetOnOff( u32 uOnOff );
void TVENC_GetIntrSrc(SDOUT_INTR_SRC eSrc);
void TVENC_ClearIntPending(void);
void TVENC_EnableIRQ(void);
void TVENC_DisableIRQ(void);

	// added by jang
void TVENC_Reset(void);
void TVENC_ClrReset(void);	

void TVENC_SetFilterValue(void);
void TVENC_SetCrc(void);
void TVENC_SetWss525CgmsRatio( SDOUT_WSS525_RATIO_T eAspectRatio );
void TVENC_SetWss525CciAndCopy( SDOUT_WSS525_CCI_T eCciOnOff, SDOUT_WSS525_COPY_T eCopyOnOff );
void TVENC_SetWss525AnalogAndPsp( SDOUT_WSS525_PSP_T psp, SDOUT_WSS525_ANALOG_T analog );
void TVENC_SetWss625Ratio( SDOUT_WSS625_RATIO_T ratio );
void TVENC_SetWss625ModeAndColorAndHelper( SDOUT_WSS625_MODE_T camera_film, SDOUT_WSS625_COLOR_T pal_ma, SDOUT_WSS625_HELPER_T helper);
void TVENC_SetWss625TextAndSubtitle( SDOUT_WSS625_TELETEXT_T teletext, SDOUT_WSS625_SUBTITLE_T subtitle );
void TVENC_SetWss625SurroundAndCopyAndRestrict( SDOUT_WSS625_SURROUND_T surround, SDOUT_WSS625_COPYRIGHT_T copyright, SDOUT_WSS625_RESTRICT_T restrict );

// added by jang
void TVENC_SetOverSamplingFilter(SCAN_MODE eScanMode);
//void InitBaseHWForSdout(void);

// added by jwj
void TVENC_SetCfgDAC (SDOUT_VIDEO_SIGNAL eVidSignal, DAC_SIG eDAC2, DAC_SIG eDAC1, DAC_SIG eDAC0  );
void TVENC_SetVidSync (SDOUT_SYNC_CONFIG eSyncIn );
void TVENC_SetVBICfg (SDOUT_VIDEO_SIGNAL eVidSignal,  SDOUT_InsertVBI eWSS, SDOUT_InsertVBI eCC, SDOUT_InsertVBI eCGMS );
void TVENC_SetChSignalScale (SDOUT_DAC eDAC, u32 uOffset, u32 uGain);
void TVENC_SetYCDELAY (u32 uYdelay, u32 uActStartDelay, u32 uActEndDelay);
void TVENC_SetPwrCtrlDAC (SDOUT_DAC eDAC, u32 uOnOff);
void TVENC_SetHueBrightCtrl (u32 uOnOff, oSDOUT_HueCtrl oYScale, oSDOUT_HueCtrl oCBScale, oSDOUT_HueCtrl oCRScale);
void TVENC_SetYPbPrCC(u32 uBypass);
void TVENC_SetRGBCC(u32 uBypass, u32 uMaxVal, u32 uMinVal);
void TVENC_SetYCCC(u32 uBypass, oSDOUT_YCnCVBS_CC oYCCC);
void TVENC_SetCVBSCC(u32 uBypass, oSDOUT_YCnCVBS_CC oCVBSCC);
void TVENC_Ctrl525Porch(u32 uBackPorch, u32 uFrontPorch);
void TVENC_Ctrl625Porch(u32 uBackPorch, u32 uFrontPorch);
void TVENC_CtrlVesaRgbSync(SDOUT_VESA_SYNC eSyncType, SDOUT_SYNC_POLARITY eVSYNC, SDOUT_SYNC_POLARITY eHSYNC);
void TVENC_SetXtalkCoef(SDOUT_DAC eDAC, u32 uCoef2, u32 uCoef1);
void TVENC_DisBBMode(void);
void TVENC_EnBBMode(SDOUT_DAC eDAC, u32 uBBLvl);
void __irq Isr_TVENC(void);
SD_FieldId TVENC_GetFieldId( void );
void TVENC_SetCCData(u32 udata);
u32 TVENC_ShadowSFRVerify(void);
#ifdef __cplusplus
}
#endif

#endif


