
#include "system.h"
#include "library.h"
#include "util.h"
#include "sdout.h"
#include "v210_sfr.h"
#include "intc.h"

#ifndef DISP_SDOUT_REG
#define sdoutOutp32(a, d) Outp32(a, d)
#define sdoutInp32(a, d)  Inp32_(a, d)
#else
#define sdoutOutp32(a, d) {u32 a2, d2; a2=a, d2=d; Disp("Outp32(\'h%08x, \'h%08x);\n", a2, d2), Outp32(a2, d2);}
#define sdoutInp32(a, d) {u32 a2, d2; a2=a; Inp32_(a2, d2); d=d2; Disp("Inp32(\'h%08x, d); // d=0x%08x\n", a2, d2);} 
#endif

volatile int g_TVENC;

enum SDOUT_SFR                    
{                                 
	rSDO_CLKCON 				= TVENC_BASE+0x000,
	rSDO_CONFIG				= TVENC_BASE+0x008,
	rSDO_SCALE					= TVENC_BASE+0x00C,
	rSDO_SYNC					= TVENC_BASE+0x010,
	rSDO_VBI					= TVENC_BASE+0x014,
	rSDO_SCALE_CH0			= TVENC_BASE+0x01C,
	rSDO_SCALE_CH1			= TVENC_BASE+0x020,
	rSDO_SCALE_CH2			= TVENC_BASE+0x024,
//	SDOUT_CVBS					= TVENC_BASE+0x028,
//	SDOUT_Y						= TVENC_BASE+0x02C,
//	SDOUT_C					= TVENC_BASE+0x030,
	rSDO_YCDELAY				= TVENC_BASE+0x034,
	rSDO_SCHLOCK				= TVENC_BASE+0x038,
	rSDO_DAC					= TVENC_BASE+0x03C,
	rSDO_FINFO					= TVENC_BASE+0x040,  // Read only
	rSDO_Y0					= TVENC_BASE+0x044,
	rSDO_Y1					= TVENC_BASE+0x048,
	rSDO_Y2					= TVENC_BASE+0x04C,
	rSDO_Y3					= TVENC_BASE+0x050,
	rSDO_Y4					= TVENC_BASE+0x054,
	rSDO_Y5					= TVENC_BASE+0x058,	
	rSDO_Y6					= TVENC_BASE+0x05C,	
	rSDO_Y7					= TVENC_BASE+0x060,
	rSDO_Y8					= TVENC_BASE+0x064,
	rSDO_Y9					= TVENC_BASE+0x068,
	rSDO_Y10					= TVENC_BASE+0x06C,
	rSDO_Y11					= TVENC_BASE+0x070,
	rSDO_CB0					= TVENC_BASE+0x080,
	rSDO_CB1					= TVENC_BASE+0x084,
	rSDO_CB2					= TVENC_BASE+0x088,
	rSDO_CB3					= TVENC_BASE+0x08C,
	rSDO_CB4					= TVENC_BASE+0x090,
	rSDO_CB5					= TVENC_BASE+0x094,
	rSDO_CB6					= TVENC_BASE+0x098,
	rSDO_CB7					= TVENC_BASE+0x09C,
	rSDO_CB8					= TVENC_BASE+0x0A0,
	rSDO_CB9					= TVENC_BASE+0x0A4,
	rSDO_CB10					= TVENC_BASE+0x0A8,
	rSDO_CB11					= TVENC_BASE+0x0AC,
	rSDO_CR0					= TVENC_BASE+0x0C0,
	rSDO_CR1					= TVENC_BASE+0x0C4,    
	rSDO_CR2					= TVENC_BASE+0x0C8,
	rSDO_CR3					= TVENC_BASE+0x0CC,
	rSDO_CR4					= TVENC_BASE+0x0D0,
	rSDO_CR5					= TVENC_BASE+0x0D4,
	rSDO_CR6					= TVENC_BASE+0x0D8,
	rSDO_CR7					= TVENC_BASE+0x0DC,
	rSDO_CR8					= TVENC_BASE+0x0E0,
	rSDO_CR9					= TVENC_BASE+0x0E4,    
	rSDO_CR10					= TVENC_BASE+0x0E8,
	rSDO_CR11					= TVENC_BASE+0x0EC,
	rSDO_MV_ON                         	= TVENC_BASE + 0x100,
	//SDOUT_MV_SLINE_FIRST_EVEN           = TVENC_BASE + 0x104,
	//SDOUT_MV_SLINE_FIRST_SPACE_EVEN     = TVENC_BASE + 0x108,
	//SDOUT_MV_SLINE_FIRST_ODD            = TVENC_BASE + 0x10C,
	//SDOUT_MV_SLINE_FIRST_SPACE_ODD      = TVENC_BASE + 0x110,
	//SDOUT_MV_SLINE_SPACING              = TVENC_BASE + 0x114,
	//SDOUT_MV_STRIPES_NUMBER             = TVENC_BASE + 0x118,
	//SDOUT_MV_STRIPES_THICKNESS          = TVENC_BASE + 0x11C,
	//SDOUT_MV_PSP_DURATION               = TVENC_BASE + 0x120,
	//SDOUT_MV_PSP_FIRST                  = TVENC_BASE + 0x124,
	//SDOUT_MV_PSP_SPACING                = TVENC_BASE + 0x128,
	//SDOUT_MV_SEL_LINE_PSP_AGC           = TVENC_BASE + 0x12C,
	//SDOUT_MV_SEL_FORMAT_PSP_AGC         = TVENC_BASE + 0x130,
	//SDOUT_MV_PSP_AGC_A_ON               = TVENC_BASE + 0x134,
	//SDOUT_MV_PSP_AGC_B_ON               = TVENC_BASE + 0x138,
	//SDOUT_MV_BACK_PORCH                 = TVENC_BASE + 0x13C,
	//SDOUT_MV_BURST_ADVANCED_ON          = TVENC_BASE + 0x140,
	//SDOUT_MV_BURST_DURATION_ZONE1       = TVENC_BASE + 0x144,
	//SDOUT_MV_BURST_DURATION_ZONE2       = TVENC_BASE + 0x148,
	//SDOUT_MV_BURST_DURATION_ZONE3       = TVENC_BASE + 0x14C,
	//SDOUT_MV_BURST_PHASE_ZONE           = TVENC_BASE + 0x150,
	//SDOUT_MV_SLICE_PHASE_LINE           = TVENC_BASE + 0x154,
	//SDOUT_MV_RGB_PROTECTION_ON          = TVENC_BASE + 0x158,
	rSDO_MV_480P      			= TVENC_BASE + 0x15C,
	rSDO_CCCON           	              = TVENC_BASE+0x180,
	rSDO_YSCALE           		       = TVENC_BASE+0x184,
	rSDO_CBSCALE           	       = TVENC_BASE+0x188,
	rSDO_CRSCALE          		       = TVENC_BASE+0x18C,
	
// ================================================================ 
	rSDO_CB_CR_OFFSET                = TVENC_BASE+0x190,
	rSDO_RGB_CC                            = TVENC_BASE+0x194,
	rSDO_CVBS_CC_Y1                    = TVENC_BASE+0x198,
	rSDO_CVBS_CC_Y2                    = TVENC_BASE+0x19C,
	rSDO_CVBS_CC_C                      = TVENC_BASE+0x1A0,
	rSDO_YC_CC_Y                          = TVENC_BASE+0x1A4,
	rSDO_YC_CC_C                          = TVENC_BASE+0x1A8,
	rSDO_CSC_525_PORCH             = TVENC_BASE+0x1B0,
	rSDO_CSC_625_PORCH             = TVENC_BASE+0x1B4,
// ================================================================ 

	rSDO_RGBSYNC                       = TVENC_BASE+0x1C0,

// ================================================================ 
	rSDO_OSFC00_0                      = TVENC_BASE+0x200,
	rSDO_OSFC01_0                      = TVENC_BASE+0x204,
	rSDO_OSFC02_0                      = TVENC_BASE+0x208,
	rSDO_OSFC03_0                      = TVENC_BASE+0x20C,
	rSDO_OSFC04_0                      = TVENC_BASE+0x210,
	rSDO_OSFC05_0                      = TVENC_BASE+0x214,
	rSDO_OSFC06_0                      = TVENC_BASE+0x218,
	rSDO_OSFC07_0                      = TVENC_BASE+0x21C,
	rSDO_OSFC08_0                      = TVENC_BASE+0x220,
	rSDO_OSFC09_0                      = TVENC_BASE+0x224,
	rSDO_OSFC10_0                      = TVENC_BASE+0x228,
	rSDO_OSFC11_0                      = TVENC_BASE+0x22C,
	rSDO_OSFC12_0                      = TVENC_BASE+0x230,
	rSDO_OSFC13_0                      = TVENC_BASE+0x234,
	rSDO_OSFC14_0                      = TVENC_BASE+0x238,
	rSDO_OSFC15_0                      = TVENC_BASE+0x23C,
	rSDO_OSFC16_0                      = TVENC_BASE+0x240,
	rSDO_OSFC17_0                      = TVENC_BASE+0x244,
	rSDO_OSFC18_0                      = TVENC_BASE+0x248,
	rSDO_OSFC19_0                      = TVENC_BASE+0x24C,
	rSDO_OSFC20_0                      = TVENC_BASE+0x250,
	rSDO_OSFC21_0                      = TVENC_BASE+0x254,
	rSDO_OSFC22_0                      = TVENC_BASE+0x258,
	rSDO_OSFC23_0                      = TVENC_BASE+0x25C,
	rSDO_XTALK0                        = TVENC_BASE+0x260,
	rSDO_XTALK1                        = TVENC_BASE+0x264,
	rSDO_XTALK2                        = TVENC_BASE+0x268,
	rSDO_BB_CTRL                       = TVENC_BASE+0x26C,
// ================================================================ 	

	rSDO_IRQ                               = TVENC_BASE+0x280,
	rSDO_IRQMASK                      = TVENC_BASE+0x284,

// ================================================================ 	
	rSDO_OSFC00_1                      = TVENC_BASE+0x2C0,
	rSDO_OSFC01_1                      = TVENC_BASE+0x2C4,
	rSDO_OSFC02_1                      = TVENC_BASE+0x2C8,
	rSDO_OSFC03_1                      = TVENC_BASE+0x2CC,
	rSDO_OSFC04_1                      = TVENC_BASE+0x2D0,
	rSDO_OSFC05_1                      = TVENC_BASE+0x2D4,
	rSDO_OSFC06_1                      = TVENC_BASE+0x2D8,
	rSDO_OSFC07_1                      = TVENC_BASE+0x2DC,
	rSDO_OSFC08_1                      = TVENC_BASE+0x2E0,
	rSDO_OSFC09_1                      = TVENC_BASE+0x2E4,
	rSDO_OSFC10_1                      = TVENC_BASE+0x2E8,
	rSDO_OSFC11_1                      = TVENC_BASE+0x2EC,
	rSDO_OSFC12_1                      = TVENC_BASE+0x2F0,
	rSDO_OSFC13_1                      = TVENC_BASE+0x2F4,
	rSDO_OSFC14_1                      = TVENC_BASE+0x2F8,
	rSDO_OSFC15_1                      = TVENC_BASE+0x2FC,
	rSDO_OSFC16_1                      = TVENC_BASE+0x300,
	rSDO_OSFC17_1                      = TVENC_BASE+0x304,
	rSDO_OSFC18_1                      = TVENC_BASE+0x308,
	rSDO_OSFC19_1                      = TVENC_BASE+0x30C,
	rSDO_OSFC20_1                      = TVENC_BASE+0x310,
	rSDO_OSFC21_1                      = TVENC_BASE+0x314,
	rSDO_OSFC22_1                      = TVENC_BASE+0x318,
	rSDO_OSFC23_1                      = TVENC_BASE+0x31C,
	rSDO_OSFC00_2                      = TVENC_BASE+0x320,
	rSDO_OSFC01_2                      = TVENC_BASE+0x324,
	rSDO_OSFC02_2                      = TVENC_BASE+0x328,
	rSDO_OSFC03_2                      = TVENC_BASE+0x32C,
	rSDO_OSFC04_2                      = TVENC_BASE+0x330,
	rSDO_OSFC05_2                      = TVENC_BASE+0x334,
	rSDO_OSFC06_2                      = TVENC_BASE+0x338,
	rSDO_OSFC07_2                      = TVENC_BASE+0x33C,
	rSDO_OSFC08_2                      = TVENC_BASE+0x340,
	rSDO_OSFC09_2                      = TVENC_BASE+0x344,
	rSDO_OSFC10_2                      = TVENC_BASE+0x348,
	rSDO_OSFC11_2                      = TVENC_BASE+0x34C,
	rSDO_OSFC12_2                      = TVENC_BASE+0x350,
	rSDO_OSFC13_2                      = TVENC_BASE+0x354,
	rSDO_OSFC14_2                      = TVENC_BASE+0x358,
	rSDO_OSFC15_2                      = TVENC_BASE+0x35C,
	rSDO_OSFC16_2                      = TVENC_BASE+0x360,
	rSDO_OSFC17_2                      = TVENC_BASE+0x364,
	rSDO_OSFC18_2                      = TVENC_BASE+0x368,
	rSDO_OSFC19_2                      = TVENC_BASE+0x36C,
	rSDO_OSFC20_2                      = TVENC_BASE+0x370,
	rSDO_OSFC21_2                      = TVENC_BASE+0x374,
	rSDO_OSFC22_2                      = TVENC_BASE+0x378,
	rSDO_OSFC23_2                      = TVENC_BASE+0x37C,	
 // ================================================================ 	
	rSDO_ARMCC                         = TVENC_BASE+0x3C0,
	rSDO_ARMWSS525  	                    = TVENC_BASE+0x3C4,
	rSDO_ARMWSS625  	                    = TVENC_BASE+0x3C8,
	rSDO_ARMCGMS525 	             = TVENC_BASE+0x3CC,
	rSDO_PAUSE                         = TVENC_BASE+0x3D0,		// It can't find datasheet
	rSDO_ARMCGMS625	                    = TVENC_BASE+0x3D4,
	rSDO_VERSION                         = TVENC_BASE+0x3D8,
// ================================================================
// Shadow SFR
	rSDO_CC				= TVENC_BASE + 0x380,
	rSDO_WSS525			= TVENC_BASE + 0x384,
	rSDO_WSS625			= TVENC_BASE + 0x388,
	rSDO_CGMS525			= TVENC_BASE + 0x38c,
	rSDO_CGMS625			= TVENC_BASE + 0x394
	
};

#define SDOUT_DAC2_Y_G       (0x0<<20)
#define SDOUT_DAC2_PB_B      (0x1<<20)
#define SDOUT_DAC2_PR_R      (0x2<<20)
#define SDOUT_DAC1_Y_G       (0x0<<18)
#define SDOUT_DAC1_PB_B      (0x1<<18)
#define SDOUT_DAC1_PR_R      (0x2<<18)
#define SDOUT_DAC0_Y_G       (0x0<<16)
#define SDOUT_DAC0_PB_B      (0x1<<16)
#define SDOUT_DAC0_PR_R      (0x2<<16)
#define SDOUT_DAC2_CVBS      (0x0<<12)
#define SDOUT_DAC2_Y         (0x1<<12)
#define SDOUT_DAC2_C         (0x2<<12)
#define SDOUT_DAC1_CVBS      (0x0<<10)
#define SDOUT_DAC1_Y         (0x1<<10)
#define SDOUT_DAC1_C         (0x2<<10)
#define SDOUT_DAC0_CVBS      (0x0<<8)
#define SDOUT_DAC0_Y         (0x1<<8)
#define SDOUT_DAC0_C         (0x2<<8)

#define SDOUT_COMPOSITE_PATH           (0x0<<6) // [13:8] is valid
#define SDOUT_COMPONENT_PATH           (0x1<<6) // [21:16] is valid

#if 0
#define SDOUT_525_NO_ANCIL_DATA        (0x0) 
#define SDOUT_US_CC_21H                (0x1) 
#define SDOUT_US_CC_284H               (0x2) 
#define SDOUT_US_CC_21H_284H           (0x3) 
#define SDOUT_525_WSS_20H_283H         (0x4) 
#define SDOUT_525_WSS_20H              (0x5) 
#define SDOUT_525_WSS_283H             (0x6) 
#define SDOUT_CC_21H_284H_WSS_20H_283H (0x2)
#define SDOUT_525_CGMS_NO              (0x0)
#define SDOUT_525_CGMS_41H             (0x1)
#endif

#define SDOUT_525_NO_ANCIL_DATA   (0x0)		// WSS: No Ancillary Data   CC: No Ancillary Data
#define SDOUT_US_CC_21H                	(0x1)		// WSS: No Ancillary Data   CC: US_21H
//#define SDOUT_US_CC_284H               	(0x2) 		// Not Defined in Datasheet
#define SDOUT_US_CC_21H_284H          (0x2) 		// WSS: No Ancillary Data	   CC: US_21H_284H. It is changed from C100 Test Code
#define SDOUT_525_WSS_20H_283H     (0x4) 		// WSS: WSS Insertion 20H_283H,  CC: No Ancillary Data
//#define SDOUT_525_WSS_20H               (0x5) 		// Not Defined in Datasheet
//#define SDOUT_525_WSS_283H             (0x6) 		// Not Defined in Datasheet
#define SDOUT_CC_21H_284H_WSS_20H_283H (0x6)	// WSS: WSS Insertion 20H_283H, CC: 21H_284H. It is changed from C100 Test Code
#define SDOUT_CC_21H_WSS_20H_283H (0x5)		// WSS: WSS Insertion 20H_283H, CC: 20H
#define SDOUT_525_CGMS_NO               (0x0)
#define SDOUT_525_CGMS_41H             (0x1)

#define SDOUT_NO_ADJUST_PHASE          (0x0)
#define SDOUT_ADJUST_PHASE             (0x1)

#define SDOUT_INTERNAL_BAND_GAP_REF (0x0<<16)
#define SDOUT_EXTERNAL_REF              (0x1<<16)

#define SDOUT_DAC012_NORMAL         (0x0<<11)
#define SDOUT_DAC012_SLEEP          (0x1<<11)
#define SDOUT_DAC_ON                (0x0)
#define SDOUT_DAC_OFF               (0x7)
#define SDOUT_DAC2_ON               (0x0)
#define SDOUT_DAC2_OFF              (0x1)
#define SDOUT_DAC1_ON               (0x0)
#define SDOUT_DAC1_OFF              (0x2)
#define SDOUT_DAC0_ON               (0x0)
#define SDOUT_DAC0_OFF              (0x4)

#define SDOUT_COLOR_COMPENSATION_BYPASS_ALL      (0x1f)

#define SDOUT_RGBSYNC_COMPOSITE   (0x0<<8)          
#define SDOUT_RGBSYNC_SEPERATE    (0x1<<8)          
#define SDOUT_RGB_VSYNC_LOW       (0x0<<4)          
#define SDOUT_RGB_VSYNC_HIGH      (0x1<<4)          
#define SDOUT_RGB_HSYNC_LOW       (0x0<<0)          
#define SDOUT_RGB_HSYNC_HIGH      (0x1<<0)          
                                                    
#define SDOUT_IRQ_NO_INT          (0x0)             
#define SDOUT_IRQ_PENDING         (0x1)             
#define SDOUT_INTMASK_ENABLE      (0x0)             
#define SDOUT_INTMASK_DISABLE     (0x1)             
                                                    
#define INTERLACE_REQ             (0x0)             
#define PROGRESSIVE_REQ           (0x1) 

volatile u32 g_FieldCounter, g_FieldId;

REGINFO		TVENCRegInfo[] = 
{

	// Rotator
	{"rSDO_CLKCON		", rSDO_CLKCON, 5, RW, DPPB, 0x1, 0x0},   	
	{"rSDO_CONFIG		", rSDO_CONFIG, 22, RW, DPPB, 0x3f3f7f, 0x242430},   	
	{"rSDO_SCALE		", rSDO_SCALE, 4, RW, DPDB, 0, 0x6},   	
	{"rSDO_SYNC			", rSDO_SCALE, 2, RW, DPDB, 0, 0x1},   	
	{"rSDO_VBI 			", rSDO_VBI, 15, RW, DPPB, 0x77ff, 0x777FF},   	
	{"rSDO_SCALE_CH0	", rSDO_SCALE_CH0, 26, RW, DPPB, 0x3ff0fff, 0x800},
	{"rSDO_SCALE_CH1	", rSDO_SCALE_CH1, 26, RW, DPPB, 0x3ff0fff, 0x800},   	
	{"rSDO_SCALE_CH2	", rSDO_SCALE_CH2, 26, RW, DPPB, 0x3ff0fff, 0x800},   	
	{"rSDO_YCDELAY		", rSDO_YCDELAY, 20, RW, DPDB, 0x0, 0xFA00},   	
	{"rSDO_SCHLOCK		", rSDO_SCHLOCK, 1, RW, DPDB, 0, 0x0}, 
	{"rSDO_DAC			", rSDO_DAC, 3, RW, DPDB, 0, 0x0}, 
	{"rSDO_FINFO		", rSDO_FINFO, 26, RO, DPPB, 0x3ff0003, 0x2}, 
	{"rSDO_Y0			", rSDO_Y0, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y1			", rSDO_Y1, 11, RW, DPDB, 0, 0x0},
	{"rSDO_Y2			", rSDO_Y2, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y3			", rSDO_Y3, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y4			", rSDO_Y4, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y5			", rSDO_Y5, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y6			", rSDO_Y6, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y7			", rSDO_Y7, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y8			", rSDO_Y8, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y9			", rSDO_Y9, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y10			", rSDO_Y10, 11, RW, DPDB, 0, 0x0}, 
	{"rSDO_Y11			", rSDO_Y11, 11, RW, DPDB, 0, 0x25d},
	{"rSDO_CB0			", rSDO_CB0, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CB1			", rSDO_CB1, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CB2			", rSDO_CB2, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CB3			", rSDO_CB3, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CB4			", rSDO_CB4, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CB5			", rSDO_CB5, 11, RW, DPDB, 0, 0x1},
	{"rSDO_CB6			", rSDO_CB6, 11, RW, DPDB, 0, 0x7},
	{"rSDO_CB7			", rSDO_CB7, 11, RW, DPDB, 0, 0x14},
	{"rSDO_CB8			", rSDO_CB8, 11, RW, DPDB, 0, 0x28},
	{"rSDO_CB9			", rSDO_CB9, 11, RW, DPDB, 0, 0x3f},
	{"rSDO_CB10			", rSDO_CB10, 11, RW, DPDB, 0, 0x52},
	{"rSDO_CB11			", rSDO_CB11, 11, RW, DPDB, 0, 0x5a},
	{"rSDO_CR0			", rSDO_CR0, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CR1			", rSDO_CR1, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CR2			", rSDO_CR2, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CR3			", rSDO_CR3, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CR4			", rSDO_CR4, 11, RW, DPDB, 0, 0x0},
	{"rSDO_CR5			", rSDO_CR5, 11, RW, DPDB, 0, 0x1},
	{"rSDO_CR6			", rSDO_CR6, 11, RW, DPDB, 0, 0x9},
	{"rSDO_CR7			", rSDO_CR7, 11, RW, DPDB, 0, 0x1c},
	{"rSDO_CR8			", rSDO_CR8, 11, RW, DPDB, 0, 0x39},
	{"rSDO_CR9			", rSDO_CR9, 11, RW, DPDB, 0, 0x5a},
	{"rSDO_CR10			", rSDO_CR10, 11, RW, DPDB, 0, 0x74},
	{"rSDO_CR11			", rSDO_CR11, 11, RW, DPDB, 0, 0x7e},
	{"rSDO_MV_ON		", rSDO_MV_ON, 8, RW, DPDB, 0, 0x0},
	{"rSDO_MV_480P		", rSDO_MV_480P, 1, RW, DPDB, 0, 0x0},
	{"rSDO_CCCON		", rSDO_CCCON, 5, RW, DPDB, 0, 0x0},
	{"rSDO_YSCALE		", rSDO_YSCALE, 24, RW, DPPB, 0xff01ff, 0x800000},
	{"rSDO_CBSCALE		", rSDO_CBSCALE, 25, RW, DPPB, 0x1ff01ff, 0x800000},
	{"rSDO_CRSCALE		", rSDO_CRSCALE, 25, RW, DPPB, 0x1ff01ff, 0x80},
	{"rSDO_CB_CR_OFFSET", rSDO_CB_CR_OFFSET, 26, RW, DPPB, 0x3ff03ff, 0x0},
	{"rSDO_RGB_CC		", rSDO_RGB_CC, 16, RW, DPPB, 0xffff, 0xeb10},
	{"rSDO_CVBS_CC_Y1	", rSDO_CVBS_CC_Y1, 26, RW, DPPB, 0x3ff03ff, 0x2000000},
	{"rSDO_CVBS_CC_Y2	", rSDO_CVBS_CC_Y2, 26, RW, DPPB, 0x3ff03ff, 0x3ff0200},
	{"rSDO_CVBS_CC_C	", rSDO_CVBS_CC_C, 9, RW, DPPB, 0x1ff, 0x1ff},
	{"rSDO_YC_CC_Y		", rSDO_YC_CC_Y, 26, RW, DPPB, 0x3ff03ff, 0x3ff0000},
	{"rSDO_YC_CC_C		", rSDO_YC_CC_C, 9, RW, DPPB, 0x1ff, 0x1ff},
	{"rSDO_CSC_525_PORCH", rSDO_CSC_525_PORCH, 26, RW, DPPB, 0x3ff03ff, 0x8a0359},
	{"rSDO_CSC_625_PORCH", rSDO_CSC_625_PORCH, 26, RW, DPPB, 0x3ff03ff, 0x96035c},
	{"rSDO_RGBSYNC		", rSDO_RGBSYNC, 9, RW, DPPB, 0x111, 0x0},
	{"rSDO_OSFC00_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0xfd00fe},
	{"rSDO_OSFC01_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x0},
	{"rSDO_OSFC02_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x50004},
	{"rSDO_OSFC03_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0xff},
	{"rSDO_OSFC04_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0xf700fa},
	{"rSDO_OSFC05_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x1},
	{"rSDO_OSFC06_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0xe000a},
	{"rSDO_OSFC07_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x1ff},
	{"rSDO_OSFC08_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x1ec01f2},
	{"rSDO_OSFC09_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x1},
	{"rSDO_OSFC10_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x1d0014},
	{"rSDO_OSFC11_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x1fe},
	{"rSDO_OSFC12_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x3d803e4},
	{"rSDO_OSFC13_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x2},
	{"rSDO_OSFC14_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x380028},
	{"rSDO_OSFC15_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x3fd},
	{"rSDO_OSFC16_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x3b003c7},
	{"rSDO_OSFC17_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x5},
	{"rSDO_OSFC18_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x790056},
	{"rSDO_OSFC19_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x3f6},
	{"rSDO_OSFC20_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x72c0766},
	{"rSDO_OSFC21_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x1b},
	{"rSDO_OSFC22_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x28b0265},
	{"rSDO_OSFC23_0		", rSDO_OSFC00_0, 28, RW, DPPB, 0x00ff00ff, 0x4000Ecc},
	{"rSDO_XTALK0		", rSDO_XTALK0, 24, RW, DPPB, 0x00ff00ff, 0x0},
	{"rSDO_XTALK1		", rSDO_XTALK1, 24, RW, DPPB, 0x00ff00ff, 0x0},
	{"rSDO_XTALK2		", rSDO_XTALK2, 24, RW, DPPB, 0x00ff00ff, 0x0},
	{"rSDO_BB_CTRL		", rSDO_BB_CTRL, 18, RW, DPPB, 0x0003f031, 0x11a00},
	{"rSDO_IRQ			", rSDO_IRQ, 1, RW, DPPB, 0x0, 0x0},
	{"rSDO_IRQMASK		", rSDO_IRQMASK, 1, RW, DPPB, 0x0, 0x0},
	{"rSDO_OSFC00_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0xfd00fe},
	{"rSDO_OSFC01_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x0},
	{"rSDO_OSFC02_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x50004},
	{"rSDO_OSFC03_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0xff},
	{"rSDO_OSFC04_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0xf700fa},
	{"rSDO_OSFC05_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x1},
	{"rSDO_OSFC06_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0xe000a},
	{"rSDO_OSFC07_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x1ff},
	{"rSDO_OSFC08_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x1ec01f2},
	{"rSDO_OSFC09_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x1},
	{"rSDO_OSFC10_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x1d0014},
	{"rSDO_OSFC11_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x1fe},
	{"rSDO_OSFC12_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x3d803e4},
	{"rSDO_OSFC13_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x2},
	{"rSDO_OSFC14_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x380028},
	{"rSDO_OSFC15_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x3fd},
	{"rSDO_OSFC16_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x3b003c7},
	{"rSDO_OSFC17_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x5},
	{"rSDO_OSFC18_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x790056},
	{"rSDO_OSFC19_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x3f6},
	{"rSDO_OSFC20_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x72c0766},
	{"rSDO_OSFC21_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x1b},
	{"rSDO_OSFC22_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x28b0265},
	{"rSDO_OSFC23_1		", rSDO_OSFC00_1, 28, RW, DPPB, 0x00ff00ff, 0x4000Ecc},
	{"rSDO_OSFC00_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0xfd00fe},
	{"rSDO_OSFC01_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x0},
	{"rSDO_OSFC02_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x50004},
	{"rSDO_OSFC03_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0xff},
	{"rSDO_OSFC04_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0xf700fa},
	{"rSDO_OSFC05_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x1},
	{"rSDO_OSFC06_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0xe000a},
	{"rSDO_OSFC07_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x1ff},
	{"rSDO_OSFC08_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x1ec01f2},
	{"rSDO_OSFC09_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x1},
	{"rSDO_OSFC10_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x1d0014},
	{"rSDO_OSFC11_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x1fe},
	{"rSDO_OSFC12_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x3d803e4},
	{"rSDO_OSFC13_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x2},
	{"rSDO_OSFC14_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x380028},
	{"rSDO_OSFC15_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x3fd},
	{"rSDO_OSFC16_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x3b003c7},
	{"rSDO_OSFC17_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x5},
	{"rSDO_OSFC18_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x790056},
	{"rSDO_OSFC19_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x3f6},
	{"rSDO_OSFC20_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x72c0766},
	{"rSDO_OSFC21_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x1b},
	{"rSDO_OSFC22_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x28b0265},
	{"rSDO_OSFC23_2		", rSDO_OSFC00_2, 28, RW, DPPB, 0x00ff00ff, 0x4000Ecc},
	{"rSDO_ARMCC		", rSDO_ARMCC, 16, RW, DPPB, 0xffff, 0x0},
	
	{"rSDO_ARMWSS525	", rSDO_ARMWSS525, 20, RW, DPPB, 0xfffff, 0x0},
	{"rSDO_ARMWSS625	", rSDO_ARMWSS625, 14, RW, DPPB, 0x3fff, 0x0},
	{"rSDO_ARMCGMS525	", rSDO_ARMCGMS525, 20, RW, DPPB, 0xfffff, 0x0},
	{"rSDO_PAUSE		", rSDO_PAUSE, 1, RW, DPPB, 0x1, 0x0},
	{"rSDO_ARMCGMS625	", rSDO_ARMCGMS625, 14, RW, DPPB, 0x3fff, 0x0},
	{"rSDO_VERSION		", rSDO_VERSION, 32, RO, DPDB, 0x0, 0xc},
	
	
};

void TestTVENC_SFR(void)
{
	volatile u32 *pAddr;	
	s32 i,j, count = sizeof(TVENCRegInfo)/sizeof(REGINFO), nPattern;
	u32 uRegStatus, uWritePatternWithMask, uReadWithMask;	
	
	
	
	u32 uPatternShitfOneBit[] = 
	{
		0x00000001,		0x00000002,		0x00000004,		0x00000008,		0x00000010,		0x00000020,		0x00000040,		0x00000080,
		0x00000100,		0x00000200,		0x00000400,		0x00000800,		0x00001000,		0x00002000,		0x00004000,		0x00008000,
		0x00010000,		0x00020000,		0x00040000,		0x00080000,		0x00100000,		0x00200000,		0x00400000,		0x00800000,
		0x01000000,		0x02000000,		0x04000000,		0x08000000,		0x10000000,		0x20000000,		0x40000000,		0x80000000,
	};
	
	u32 uDefaultBitMask[] =
	{
		0x00000001,		0x00000003,		0x00000007,		0x0000000F,		0x0000001F,		0x0000003F,		0x0000007F,		0x000000FF,
		0x000001FF,		0x000003FF,		0x000007FF,		0x00000FFF,		0x00001FFF,		0x00003FFF,		0x00007FFF,		0x0000FFFF,
		0x0001FFFF,		0x0003FFFF,		0x0007FFFF,		0x000FFFFF,		0x001FFFFF,		0x003FFFFF,		0x007FFFFF,		0x00FFFFFF,
		0x01FFFFFF,		0x03FFFFFF,		0x07FFFFFF,		0x0FFFFFFF,		0x1FFFFFFF,		0x3FFFFFFF,		0x7FFFFFFF,		0xFFFFFFFF,
	};

	
	for(i=0; i<count; i++)
	{		
		pAddr = (u32*)TVENCRegInfo[i].uAddr;		
		
		if(TVENCRegInfo[i].uFlag == DPDB)
		{		
			if(TVENCRegInfo[i].uRWType == RW)
			{
				for(j=0; j< TVENCRegInfo[i].uBitLen ; j++)
				{			
					uWritePatternWithMask = (uPatternShitfOneBit[j] &uDefaultBitMask[j]);
					*pAddr = uWritePatternWithMask;					
					
					uReadWithMask = (*pAddr & uDefaultBitMask[j]);	
					TVENCRegInfo[i].rValue = uReadWithMask;
					
					uRegStatus = (	uWritePatternWithMask !=uReadWithMask );					
					RPRINTF(TVENCRegInfo[i], uPatternShitfOneBit[j], uRegStatus, j, 1);
				}
			}
		}		
		else if(TVENCRegInfo[i].uFlag == DPPB)
		{		
			nPattern = (sizeof(uPatternShitfOneBit)/sizeof(uPatternShitfOneBit[0]));			
			if(TVENCRegInfo[i].uRWType == RW)
			{
				for(j=0; j<nPattern; j++)
				{
					if(uPatternShitfOneBit[j] & TVENCRegInfo[i].uPrivateBitMask)
					{
						uWritePatternWithMask = (uPatternShitfOneBit[j] & TVENCRegInfo[i].uPrivateBitMask);
						*pAddr = uWritePatternWithMask;
						
						uReadWithMask = (*pAddr & TVENCRegInfo[i].uPrivateBitMask);
						TVENCRegInfo[i].rValue = uReadWithMask;
						
						uRegStatus = (	uWritePatternWithMask != uReadWithMask );												
						RPRINTF(TVENCRegInfo[i], uPatternShitfOneBit[j], uRegStatus, j, 1);					
					}
				}
			}			
		}					
	}
	UART_Printf("\n\nTest Complete!\n\n");

	
	return ;
}

u32 TVENC_RegResetValueVerify(void)
{
	s32 i, count = sizeof(TVENCRegInfo)/sizeof(REGINFO);
	u32 uRegValue, uResetVal;	
	
	for(i=0; i<count; i++)
	{		
		
		//uRegValue = Inp32(TVENCRegInfo[i].uAddr);
		sdoutInp32(TVENCRegInfo[i].uAddr, uRegValue);
		uResetVal = TVENCRegInfo[i].rValue;

		if(uRegValue == uResetVal)
		{
			return true;
		}
		else 
		{
			UART_Printf("\n%20s (0x%08X): Read 0x%08X, Reset 0x%08X", TVENCRegInfo[i].name, TVENCRegInfo[i].uAddr, uRegValue,uResetVal);	
			return false;
		}			
	}
	
}




void TVENC_InitIp( TV_STANDARDS eTvSys, SCAN_MODE eScanMode, SDOUT_VIDEO_SIGNAL eVidSignal )
{
	u32 uSdencConfig = 0;
	u32 uScConfig = 0;
	u32 uVbi;
	u32 uYCDelay,uDac, uRgbSync;

	uDac = (1<<2) | (1<<1) | (1<<0);
	sdoutOutp32( rSDO_DAC, uDac );		// DAC Power ON
	
	if ((eVidSignal == SDOUT_COMPONENT_SIG ) || (eVidSignal == SDOUT_COMPONENT_SIG_PROG))
		uSdencConfig = SDOUT_DAC2_PR_R | SDOUT_DAC1_PB_B | SDOUT_DAC0_Y_G |1<<5| SDOUT_COMPONENT_PATH;
	else if ((eVidSignal == SDOUT_COMPONENT_RGB ) || (eVidSignal == SDOUT_COMPONENT_RGB_PROG))
		uSdencConfig = SDOUT_DAC2_PR_R | SDOUT_DAC1_PB_B | SDOUT_DAC0_Y_G |0<<5| SDOUT_COMPONENT_PATH;
	else if ( eVidSignal == SDOUT_COMPOSITE_SIG )
		uSdencConfig = SDOUT_DAC2_CVBS| SDOUT_DAC1_CVBS| SDOUT_DAC0_CVBS| SDOUT_COMPOSITE_PATH;
	else if ( eVidSignal == SDOUT_SVIDEO_SIG )
		uSdencConfig = SDOUT_DAC2_C | SDOUT_DAC1_Y | SDOUT_DAC0_CVBS | SDOUT_COMPOSITE_PATH;
	
	uSdencConfig |= (eScanMode==INTERLACED) ? (0x0<<4) : (0x1<<4);
	
	uSdencConfig |= 
		(eTvSys == NTSC_J)		? 0x0 :
		(eTvSys==NTSC_M) 		? 0x0 :
		(eTvSys==PAL_M) 		? 0x1 :		
		(eTvSys==PAL_BGHID) 	? 0x2 :
		(eTvSys==PAL_N) 		? 0x3 :
		(eTvSys==PAL_NC) 		? 0x4 :
		(eTvSys==NTSC_443) 		? 0x8 :
		(eTvSys==PAL_60)	? 0x9 : 0x0;
	sdoutOutp32( rSDO_CONFIG, uSdencConfig );

#if 0  // From C100 Test Code
	if ( eTvSys==NTSC_M || eTvSys==NTSC_443 )
		uScConfig = (SDOUT_SLS_0_IRE<<3) | (SDOUT_VTSRS_7_3<<2) | (SDOUT_SLS_7_5_IRE<<1) 
			| (SDOUT_VTSRS_10_4<<0);
	else if( (eTvSys==PAL_M) || (eTvSys==PAL_BGHID) || (eTvSys==PAL_N) 
		|| (eTvSys==PAL_NC) || (eTvSys==PAL_60) )
		uScConfig = (SDOUT_SLS_0_IRE<<3) | (SDOUT_VTSRS_7_3<<2) | (SDOUT_SLS_0_IRE<<1) 
			| (SDOUT_VTSRS_7_3<<0);
#endif
	if ( eTvSys==NTSC_M || eTvSys==NTSC_443  )
		uScConfig = (SDOUT_SLS_7_5_IRE<<3) | (SDOUT_VTSRS_10_4<<2) | (SDOUT_SLS_7_5_IRE<<1) 
			| (SDOUT_VTSRS_10_4<<0);
	else if (eTvSys == NTSC_J)
		uScConfig = (SDOUT_SLS_0_IRE<<3) | (SDOUT_VTSRS_10_4<<2) | (SDOUT_SLS_0_IRE<<1) 
			| (SDOUT_VTSRS_10_4<<0);
	else if ((eTvSys == PAL_M) || (eTvSys == PAL_N))
			uScConfig = (SDOUT_SLS_7_5_IRE<<3) | (SDOUT_VTSRS_7_3<<2) | (SDOUT_SLS_7_5_IRE<<1) 
			| (SDOUT_VTSRS_7_3<<0);	
	else if( (eTvSys==PAL_BGHID)	|| (eTvSys==PAL_NC) || (eTvSys==PAL_60) )
		uScConfig = (SDOUT_SLS_0_IRE<<3) | (SDOUT_VTSRS_7_3<<2) | (SDOUT_SLS_0_IRE<<1) 
			| (SDOUT_VTSRS_7_3<<0);
	sdoutOutp32( rSDO_SCALE, uScConfig);


	if( eVidSignal==SDOUT_COMPONENT_SIG || eVidSignal==SDOUT_COMPONENT_SIG_PROG )
			TVENC_SetVidSync(SDOUT_SYNC_ONE_CH);

	uVbi = 
		(SDOUT_CC_21H_284H_WSS_20H_283H<<12) | 
		(SDOUT_CC_21H_284H_WSS_20H_283H<<8) | 
		(SDOUT_525_CGMS_41H<<7) |
		(SDOUT_CC_21H_284H_WSS_20H_283H<<4) | 
		(SDOUT_525_CGMS_41H<<3) |
		(SDOUT_CC_21H_284H_WSS_20H_283H<<0);
	sdoutOutp32( rSDO_VBI, uVbi );			

	TVENC_SetChSignalScale (DAC0, 0x0, 0x800);	// Default Setting, Offset 0, Gain x1.0
	TVENC_SetChSignalScale (DAC1, 0x0, 0x800);	// Default Setting, Offset 0, Gain x1.0
	TVENC_SetChSignalScale (DAC2, 0x0, 0x800);	// Default Setting, Offset 0, Gain x1.0

#if 0
	sdoutOutp32( SDOUT_CVBS, uOffsetGain );
	sdoutOutp32( SDOUT_Y, uOffsetGain );
	sdoutOutp32( SDOUT_C, uOffsetGain );
#endif
 	TVENC_SetYCDELAY(0x0, 0xfa, 0x0);			// Defalut Setting,  Y Dealy 0usec, Active Start : -0.37usec, Active End : 0usec

	

	sdoutOutp32( rSDO_SCHLOCK, SDOUT_NO_ADJUST_PHASE );

	TVENC_SetFilterValue();

	//TVENC_SetMacrovision( SDOUT_MV_OFF, NTSC_M );

	sdoutOutp32( rSDO_CCCON, SDOUT_COLOR_COMPENSATION_BYPASS_ALL ); 

	sdoutOutp32( rSDO_YSCALE,  (0x80<<16) | (0x0<<0) );
	//sdoutOutp32( SDOUT_CBSCALE,  (0x80U<<24) | (0x0<<16) | (0x0<<0) );
	sdoutOutp32( rSDO_CBSCALE,  (0x80<<16) | (0x0<<0) );			// [31:25] are reserved
	//sdoutOutp32( SDOUT_CRSCALE,  (0x0<<24) | (0x80<<16) | (0x0<<0) );
	sdoutOutp32( rSDO_CRSCALE,  (0x0<<16) | (0x80<<0) ); 		// [31:25] are reserved

	uRgbSync = SDOUT_RGBSYNC_COMPOSITE | SDOUT_RGB_VSYNC_HIGH | SDOUT_RGB_HSYNC_HIGH;
	sdoutOutp32( rSDO_RGBSYNC,  uRgbSync );

	sdoutOutp32( rSDO_IRQ, SDOUT_IRQ_NO_INT );
	sdoutOutp32( rSDO_IRQMASK, SDOUT_INTMASK_ENABLE );

	TVENC_SetWss525CgmsRatio( SDOUT_WSS525_NORMAL);
	TVENC_SetWss525CciAndCopy( SDOUT_WSS525_CCI_ON, SDOUT_WSS525_COPY );
	TVENC_SetWss525AnalogAndPsp( SDOUT_WSS525_ANALOG_OFF, SDOUT_WSS525_PSP_OFF );
	
	TVENC_SetWss625Ratio( SDOUT_WSS625_4_3_FULL );
	TVENC_SetWss625ModeAndColorAndHelper( SDOUT_WSS625_CAMERA, SDOUT_WSS625_PAL, SDOUT_WSS625_HELPER_OFF );
	TVENC_SetWss625TextAndSubtitle( SDOUT_WSS625_TELETEXT_OFF,   SDOUT_WSS625_SUBTITLE_OFF );
	TVENC_SetWss625SurroundAndCopyAndRestrict( SDOUT_WSS625_SURROUND_OFF, SDOUT_WSS625_COPYRIGHT_OFF, SDOUT_WSS625_COPY_RESTRICT_NOT );
	
	sdoutOutp32( rSDO_PAUSE, PROGRESSIVE_REQ );

	// added by jang
	sdoutOutp32(rSDO_BB_CTRL, 0x0); // Disable black burst test mode
	TVENC_SetOverSamplingFilter(eScanMode);


	sdoutOutp32(rSDO_IRQMASK, 0x0);
}

#if 0 //C100
// [Init Sdout]
void TVENC_InitIp( TV_STANDARDS eTvSys, SCAN_MODE eScanMode, SDOUT_VIDEO_SIGNAL eVidSignal )
{
	u32 uSdencConfig = 0;
	u32 uScConfig = 0;
	u32 uVbi;
	u32 uOffsetGain;
	u32 uYCDelay,uDac, uRgbSync;
	
	
	if ((eVidSignal == SDOUT_COMPONENT_SIG ) || (eVidSignal == SDOUT_COMPONENT_SIG_PROG))
		uSdencConfig = SDOUT_DAC2_PR_R | SDOUT_DAC1_PB_B | SDOUT_DAC0_Y_G | SDOUT_COMPONENT_PATH;
	else if ( eVidSignal == SDOUT_COMPOSITE_SIG )
		uSdencConfig = SDOUT_DAC2_CVBS| SDOUT_DAC1_CVBS| SDOUT_DAC0_CVBS| SDOUT_COMPOSITE_PATH;
	else if ( eVidSignal == SDOUT_SVIDEO_SIG )
		uSdencConfig = SDOUT_DAC2_C | SDOUT_DAC1_Y | SDOUT_DAC0_CVBS | SDOUT_COMPOSITE_PATH;
	
	uSdencConfig |= (eScanMode==INTERLACED) ? (0x0<<4) : (0x1<<4);
	
	uSdencConfig |= 
		(eTvSys==NTSC_M) 		? 0x0 :
		(eTvSys==PAL_M) 		? 0x1 :		
		(eTvSys==PAL_BGHID) 	? 0x2 :
		(eTvSys==PAL_N) 		? 0x3 :
		(eTvSys==PAL_NC) 		? 0x4 :
		(eTvSys==NTSC_443) 		? 0x8 :
		(eTvSys==PAL_60)	? 0x9 : 0x0;
	sdoutOutp32( SDOUT_CONFIG, uSdencConfig );

	if ( eTvSys==NTSC_M || eTvSys==NTSC_443 )
		uScConfig = (SDOUT_SLS_0_IRE<<3) | (SDOUT_VTSRS_7_3<<2) | (SDOUT_SLS_7_5_IRE<<1) 
			| (SDOUT_VTSRS_10_4<<0);
	else if( (eTvSys==PAL_M) || (eTvSys==PAL_BGHID) || (eTvSys==PAL_N) 
		|| (eTvSys==PAL_NC) || (eTvSys==PAL_60) )
		uScConfig = (SDOUT_SLS_0_IRE<<3) | (SDOUT_VTSRS_7_3<<2) | (SDOUT_SLS_0_IRE<<1) 
			| (SDOUT_VTSRS_7_3<<0);
	sdoutOutp32( SDOUT_SCALE, uScConfig);

	sdoutOutp32( SDOUT_SYNC, SDOUT_SYNC_ONE_CH );

	uVbi = 
		(SDOUT_CC_21H_284H_WSS_20H_283H<<12) | 
		(SDOUT_CC_21H_284H_WSS_20H_283H<<8) | 
		(SDOUT_525_CGMS_41H<<7) |
		(SDOUT_CC_21H_284H_WSS_20H_283H<<4) | 
		(SDOUT_525_CGMS_41H<<3) |
		(SDOUT_CC_21H_284H_WSS_20H_283H<<0);
	sdoutOutp32( SDOUT_VBI, uVbi );

	uOffsetGain = (0x0<<16) | (0x800<<0);
	sdoutOutp32( SDOUT_SCALE_CH0, uOffsetGain );
	sdoutOutp32( SDOUT_SCALE_CH1, uOffsetGain );
	sdoutOutp32( SDOUT_SCALE_CH2, uOffsetGain );
#if 0
	sdoutOutp32( SDOUT_CVBS, uOffsetGain );
	sdoutOutp32( SDOUT_Y, uOffsetGain );
	sdoutOutp32( SDOUT_C, uOffsetGain );
#endif
 
	uYCDelay = (0x0<<16) | (0xfa<<8) | (0x0<<0);
	sdoutOutp32( SDOUT_YCDELAY, uYCDelay );

	sdoutOutp32( SDOUT_SCHLOCK, SDOUT_NO_ADJUST_PHASE );

//	u32 uDac = SDOUT_INTERNAL_BAND_GAP_REF | SDOUT_DAC012_NORMAL | 
//		(SDOUT_DAC_ON<<2) | (SDOUT_DAC_ON<<1) | SDOUT_DAC_ON<<0;

	uDac = (1<<2) | (1<<1) | (1<<0);

	sdoutOutp32( SDOUT_DAC, uDac );

	TVENC_SetFilterValue();

	TVENC_SetMacrovision( SDOUT_MV_OFF, NTSC_M );

	sdoutOutp32( SDOUT_CCCON, SDOUT_COLOR_COMPENSATION_BYPASS_ALL ); 

	sdoutOutp32( SDOUT_YSCALE,  (0x80<<16) | (0x0<<0) );
	sdoutOutp32( SDOUT_CBSCALE,  (0x80U<<24) | (0x0<<16) | (0x0<<0) );
	sdoutOutp32( SDOUT_CRSCALE,  (0x0<<24) | (0x80<<16) | (0x0<<0) );

	uRgbSync = SDOUT_RGBSYNC_COMPOSITE | SDOUT_RGB_VSYNC_HIGH | SDOUT_RGB_HSYNC_HIGH;
	sdoutOutp32( SDOUT_RGBSYNC,  uRgbSync );

	sdoutOutp32( SDOUT_IRQ, SDOUT_IRQ_NO_INT );
	sdoutOutp32( SDOUT_IRQMASK, SDOUT_INTMASK_ENABLE );

	TVENC_SetWss525CgmsRatio( SDOUT_WSS525_NORMAL);
	TVENC_SetWss525CciAndCopy( SDOUT_WSS525_CCI_ON, SDOUT_WSS525_COPY );
	TVENC_SetWss525AnalogAndPsp( SDOUT_WSS525_ANALOG_OFF, SDOUT_WSS525_PSP_OFF );
	
	TVENC_SetWss625Ratio( SDOUT_WSS625_4_3_FULL );
	TVENC_SetWss625ModeAndColorAndHelper( SDOUT_WSS625_CAMERA, SDOUT_WSS625_PAL, SDOUT_WSS625_HELPER_OFF );
	TVENC_SetWss625TextAndSubtitle( SDOUT_WSS625_TELETEXT_OFF,   SDOUT_WSS625_SUBTITLE_OFF );
	TVENC_SetWss625SurroundAndCopyAndRestrict( SDOUT_WSS625_SURROUND_OFF, SDOUT_WSS625_COPYRIGHT_OFF, SDOUT_WSS625_COPY_RESTRICT_NOT );
	
	sdoutOutp32( SDOUT_PAUSE, PROGRESSIVE_REQ );

	// added by jang
	sdoutOutp32(SDOUT_BB_CTRL, 0x0); // Disable black burst test mode
	TVENC_SetOverSamplingFilter(eScanMode);


	sdoutOutp32(SDOUT_IRQMASK, 0x0);
}
#endif

// [Set Component I/F]
void TVENC_SetComponentIf( SDOUT_IF eIf )
{
	u32 uSdencConfig;
	sdoutInp32( rSDO_CONFIG, uSdencConfig );
	if ( (eIf==SDOUT_RGB) && (uSdencConfig&SDOUT_COMPONENT_PATH) )
		uSdencConfig |= (0x0<<5);
	else if ( (eIf==SDOUT_YPBPR) && (uSdencConfig&SDOUT_COMPONENT_PATH) )
		uSdencConfig |= (0x1<<5);
	sdoutOutp32( rSDO_CONFIG, uSdencConfig );
}

// [Set on/off]
//////////
// Function Name 	: 	TVENC_SetOnOff
// Description		:	Clock On/Off fuction of the TV Encoder 
// Input 			:	uOnOff - ON : 1, OFF: 0
void TVENC_SetOnOff( u32 uOnOff )
{
	u32 uRegValue;
	
	#if 0		// C100 Test Code
	sdoutOutp32( rSDO_CLKCON, (uOnOff<<0) );
	//	sdoutOutp32( SDOUT_CLKCON+4, 0xf ); // Erase in manual
	#endif 

	#if 1

	sdoutInp32(rSDO_CLKCON, uRegValue);
	
	if(uOnOff == 1)
	{	
		uRegValue |= 0x1;
		sdoutOutp32(rSDO_CLKCON, uRegValue);
		//sdoutOutp32(rSDO_CLKCON, Inp32(rSDO_CLKCON)|0x1);
	}
	else if (uOnOff == 0)
	{
		//while(!((Inp32(rSDO_CLKCON)&0x2) == 0x2 ));		// Be careful!! It is not ready, It just flag
		uRegValue = uRegValue & ~(0x1);
		sdoutOutp32(rSDO_CLKCON,  uRegValue);
		//sdoutOutp32(rSDO_CLKCON,  Inp32(rSDO_CLKCON)&~(0x1));
	}

	#endif

}

void TVENC_GetIntrSrc(SDOUT_INTR_SRC eSrc)
{
	eSrc = SDOUT_VSYNC;
}

void TVENC_ClearIntPending(void)
{
	sdoutOutp32(rSDO_IRQ , 0x1);
}

void TVENC_EnableIRQ(void)
{
	sdoutOutp32(rSDO_IRQMASK , 0x0);
}

void TVENC_DisableIRQ(void)
{
	sdoutOutp32(rSDO_IRQMASK , 0x1);
}

// [Set Macrovision]
#if 0
void TVENC_SetMacrovision(SDOUT_MACROVISION_VAL eMType, TV_STANDARDS eTvSys)
{
	switch ( eMType )
	{
		
		case SDOUT_MV_OFF:
			/* Off */
			sdoutOutp32(SDOUT_MV_RGB_PROTECTION_ON       ,0x00000000);
			sdoutOutp32(SDOUT_MV_480P_PROTECTION_ON      ,0x00000000);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_EVEN        ,0x00000000);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_SPACE_EVEN  ,0x00000000);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_ODD         ,0x00000000);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_SPACE_ODD   ,0x00000000);
			sdoutOutp32(SDOUT_MV_SLINE_SPACING           ,0x00000000);
			sdoutOutp32(SDOUT_MV_STRIPES_NUMBER          ,0x00000000);
			sdoutOutp32(SDOUT_MV_STRIPES_THICKNESS       ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_DURATION            ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_FIRST               ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_SPACING             ,0x00000000);
			sdoutOutp32(SDOUT_MV_SEL_LINE_PSP_AGC        ,0x00000000);
			sdoutOutp32(SDOUT_MV_SEL_FORMAT_PSP_AGC      ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_AGC_A_ON            ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_AGC_B_ON            ,0x00000000);
			sdoutOutp32(SDOUT_MV_BACK_PORCH              ,0x00000000);
			sdoutOutp32(SDOUT_MV_BURST_ADVANCED_ON       ,0x00000000);                                                                                       
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE1    ,0x00000000);
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE2    ,0x00000000);
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE3    ,0x00000000);
			sdoutOutp32(SDOUT_MV_BURST_PHASE_ZONE        ,0x00000000);
			sdoutOutp32(SDOUT_MV_SLICE_PHASE_LINE        ,0x00000000);
			sdoutOutp32(SDOUT_MV_RGB_PROTECTION_ON       ,0x00000000);
			sdoutOutp32(SDOUT_MV_480P_PROTECTION_ON      ,0x00000000);
			sdoutOutp32(SDOUT_MV_ON                      ,0x00000000);           /* macrovision off */
			break;
		case SDOUT_MV_NTSC_AGC_ONLY:
			/* NTSC : AGC Only */
			//rSDO_MV_SLINE_FIRST_EVEN      = 0x0000001d;
			//rSDO_MV_SLINE_FIRST_SPACE_EVEN= 0x00000011;
			//rSDO_MV_SLINE_FIRST_ODD       = 0x00000025;
			//rSDO_MV_SLINE_FIRST_SPACE_ODD = 0x00000011;
			//rSDO_MV_SLINE_SPACING         = 0x00000001;
			//rSDO_MV_STRIPES_NUMBER        = 0x00000007;
			//rSDO_MV_STRIPES_THICKNESS     = 0x00000000;
			sdoutOutp32(SDOUT_MV_PSP_DURATION            ,0x0000001B);
			sdoutOutp32(SDOUT_MV_PSP_FIRST               ,0x0000001B);
			sdoutOutp32(SDOUT_MV_PSP_SPACING             ,0x00000024);
			sdoutOutp32(SDOUT_MV_SEL_LINE_PSP_AGC        ,0x000007f8);
			sdoutOutp32(SDOUT_MV_SEL_FORMAT_PSP_AGC      ,0x00000000);
/* <<<@: R130XEU-xxx.Dongwoo Kim 060325: N13 and N14 should be 1E for PAL60 */
			if (eTvSys == PAL_60)
			{
				sdoutOutp32(SDOUT_MV_PSP_AGC_A_ON    ,0x0000001e);
				sdoutOutp32(SDOUT_MV_PSP_AGC_B_ON    ,0x0000001e);
			}
			else
			{
				sdoutOutp32(SDOUT_MV_PSP_AGC_A_ON    ,0x0000000f);
				sdoutOutp32(SDOUT_MV_PSP_AGC_B_ON    ,0x0000000f);
			}
/* >>>@: R130XEU-xxx.Dongwoo Kim 060325: N13 and N14 should be 1E for PAL60 */
			sdoutOutp32(SDOUT_MV_BACK_PORCH          ,0x00000060);
			//rSDO_MV_BURST_ADVANCED_ON     = 0x00000001;                                                                                       
			//rSDO_MV_BURST_DURATION_ZONE1  = 0x0000000a;
			//rSDO_MV_BURST_DURATION_ZONE2  = 0x00000000;
			//rSDO_MV_BURST_DURATION_ZONE3  = 0x00000005;
			//rSDO_MV_BURST_PHASE_ZONE      = 0x00000004;
			//rSDO_MV_SLICE_PHASE_LINE      = 0x000003ff;
			//rSDO_MV_RGB_PROTECTION_ON     = 0x00000001;
			sdoutOutp32(SDOUT_MV_480P_PROTECTION_ON      ,0x00000001);
			sdoutOutp32(SDOUT_MV_ON                      ,0x00000036);           /* macrovision on */
			break;                  
		case SDOUT_MV_NTSC_AGC_2L:
			/* NTSC : AGC + 2Line */
			/* NTSC : AGC Split */
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_EVEN        ,0x0000001d);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_SPACE_EVEN  ,0x00000011);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_ODD         ,0x00000025);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_SPACE_ODD   ,0x00000011);
			sdoutOutp32(SDOUT_MV_SLINE_SPACING           ,0x00000001);
			sdoutOutp32(SDOUT_MV_STRIPES_NUMBER          ,0x00000007);
			sdoutOutp32(SDOUT_MV_STRIPES_THICKNESS       ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_DURATION            ,0x0000001B);
			sdoutOutp32(SDOUT_MV_PSP_FIRST               ,0x0000001B);
			sdoutOutp32(SDOUT_MV_PSP_SPACING             ,0x00000024);
			sdoutOutp32(SDOUT_MV_SEL_LINE_PSP_AGC        ,0x000007f8);
			sdoutOutp32(SDOUT_MV_SEL_FORMAT_PSP_AGC      ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_AGC_A_ON            ,0x0000000f);
			sdoutOutp32(SDOUT_MV_PSP_AGC_B_ON            ,0x0000000f);
			sdoutOutp32(SDOUT_MV_BACK_PORCH              ,0x00000060);
			sdoutOutp32(SDOUT_MV_BURST_ADVANCED_ON       ,0x00000001);    
 // _USE_5001_MACROVISION                       
		//      rSDO_MV_BURST_DURATION_ZONE1    = 0x0000000a;
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE1    ,0x0000000a + 2);
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE2    ,0x00000000);
// _USE_5001_MACROVISION        
		//      rSDO_MV_BURST_DURATION_ZONE3    = 0x00000005;
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE3    ,0x00000005 + 1);
			sdoutOutp32(SDOUT_MV_BURST_PHASE_ZONE        ,0x00000004);
			sdoutOutp32(SDOUT_MV_SLICE_PHASE_LINE        ,0x000003ff);
			sdoutOutp32(SDOUT_MV_RGB_PROTECTION_ON       ,0x00000000);   // ???
			sdoutOutp32(SDOUT_MV_480P_PROTECTION_ON      ,0x00000001);           
			sdoutOutp32(SDOUT_MV_ON                      ,0x0000003e);           /* macrovision on */
			break;
		case SDOUT_MV_NTSC_AGC_4L:
			/* NTSC : AGC + 4Line */
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_EVEN        ,0x00000017);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_SPACE_EVEN  ,0x00000015);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_ODD         ,0x00000021);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_SPACE_ODD   ,0x00000015);
			sdoutOutp32(SDOUT_MV_SLINE_SPACING           ,0x00000005);
			sdoutOutp32(SDOUT_MV_STRIPES_NUMBER          ,0x00000005);
			sdoutOutp32(SDOUT_MV_STRIPES_THICKNESS       ,0x00000002);
			sdoutOutp32(SDOUT_MV_PSP_DURATION            ,0x0000001B);
			sdoutOutp32(SDOUT_MV_PSP_FIRST               ,0x0000001B);
			sdoutOutp32(SDOUT_MV_PSP_SPACING             ,0x00000024);
			sdoutOutp32(SDOUT_MV_SEL_LINE_PSP_AGC        ,0x000007f8);
			sdoutOutp32(SDOUT_MV_SEL_FORMAT_PSP_AGC      ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_AGC_A_ON            ,0x0000000f);
			sdoutOutp32(SDOUT_MV_PSP_AGC_B_ON            ,0x0000000f);
			sdoutOutp32(SDOUT_MV_BACK_PORCH              ,0x00000060);
			sdoutOutp32(SDOUT_MV_BURST_ADVANCED_ON       ,0x00000001);     
 //_USE_5001_MACROVISION        
	//              sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE1    , 0x0000000a);
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE1    ,0x0000000a + 2);
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE2    ,0x00000000);
// _USE_5001_MACROVISION        
	//              sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE3    , 0x00000005);
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE3    ,0x00000005 + 1);
			sdoutOutp32(SDOUT_MV_BURST_PHASE_ZONE        ,0x00000004);
			sdoutOutp32(SDOUT_MV_SLICE_PHASE_LINE        ,0x000003ff);
			sdoutOutp32(SDOUT_MV_RGB_PROTECTION_ON       ,0x00000000);   // ???
			sdoutOutp32(SDOUT_MV_480P_PROTECTION_ON      ,0x00000001);                   
			sdoutOutp32(SDOUT_MV_ON                      ,0x0000003e);           /* macrovision on */
			break;
		case SDOUT_MV_PAL_AGC_ONLY:
		case SDOUT_MV_PAL_AGC_2L:
		case SDOUT_MV_PAL_AGC_4L:
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_EVEN        ,0x0000001a);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_SPACE_EVEN  ,0x00000022);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_ODD         ,0x0000002a);
			sdoutOutp32(SDOUT_MV_SLINE_FIRST_SPACE_ODD   ,0x00000022);
			sdoutOutp32(SDOUT_MV_SLINE_SPACING           ,0x00000005);
			sdoutOutp32(SDOUT_MV_STRIPES_NUMBER          ,0x00000002);
			sdoutOutp32(SDOUT_MV_STRIPES_THICKNESS       ,0x00000000);
			sdoutOutp32(SDOUT_MV_PSP_DURATION            ,0x0000001c);
			sdoutOutp32(SDOUT_MV_PSP_FIRST               ,0x0000003d);
			sdoutOutp32(SDOUT_MV_PSP_SPACING             ,0x00000014);
			sdoutOutp32(SDOUT_MV_SEL_LINE_PSP_AGC        ,0x000003fe);
			sdoutOutp32(SDOUT_MV_SEL_FORMAT_PSP_AGC      ,0x00000154);
			sdoutOutp32(SDOUT_MV_PSP_AGC_A_ON            ,0x000000fe);
			sdoutOutp32(SDOUT_MV_PSP_AGC_B_ON            ,0x0000007e);
			sdoutOutp32(SDOUT_MV_BACK_PORCH              ,0x00000060);
			sdoutOutp32(SDOUT_MV_BURST_ADVANCED_ON       ,0x00000000);      
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE1    ,0x00000008 + 2);
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE2    ,0x00000000);
			sdoutOutp32(SDOUT_MV_BURST_DURATION_ZONE3    ,0x00000004 + 1);
			sdoutOutp32(SDOUT_MV_BURST_PHASE_ZONE        ,0x00000007);
			sdoutOutp32(SDOUT_MV_SLICE_PHASE_LINE        ,0x00000155);
			sdoutOutp32(SDOUT_MV_RGB_PROTECTION_ON       ,0x00000000);
			sdoutOutp32(SDOUT_MV_480P_PROTECTION_ON      ,0x00000001);                   
			sdoutOutp32(SDOUT_MV_ON                      ,0x00000036);           /* macrovision on */                    
			break;
		default:
	//              ASSERT(0);
			break;
	}
}
#endif

// [Set Filter Value]
void TVENC_SetFilterValue( void )
{
	u32 uSelScale ;
	u32 uSdencSel;

	sdoutInp32( rSDO_SCALE, uSelScale );
	uSelScale  = uSelScale & 0x00000003;

	sdoutInp32( rSDO_CONFIG, uSdencSel );
	uSdencSel = uSdencSel & 0xc0;

	if ( uSelScale == 0 )
	{
		// Y or C(2DAC) is CVBS. 
		if ( uSdencSel == 0x0 )
		{
			sdoutOutp32(rSDO_Y0 , 0x00000000 );
			sdoutOutp32(rSDO_Y1 , 0x00000000 );
			sdoutOutp32(rSDO_Y2 , 0x00000000 );
			sdoutOutp32(rSDO_Y3 , 0x00000000 );
			sdoutOutp32(rSDO_Y4 , 0x00000000 );
			sdoutOutp32(rSDO_Y5 , 0x00000000 );
			sdoutOutp32(rSDO_Y6 , 0x00000000 );
			sdoutOutp32(rSDO_Y7 , 0x00000000 );
			sdoutOutp32(rSDO_Y8 , 0x00000000 );
			sdoutOutp32(rSDO_Y9 , 0x00000000 );
			sdoutOutp32(rSDO_Y10, 0x00000000 );
			sdoutOutp32(rSDO_Y11, 0x0000029a );
			sdoutOutp32(rSDO_CB0, 0x00000000 );
			sdoutOutp32(rSDO_CB1, 0x00000000 );
			sdoutOutp32(rSDO_CB2, 0x00000000 );
			sdoutOutp32(rSDO_CB3, 0x00000000 );
			sdoutOutp32(rSDO_CB4, 0x00000000 );
			sdoutOutp32(rSDO_CB5, 0x00000001 );
			sdoutOutp32(rSDO_CB6, 0x00000007 );
			sdoutOutp32(rSDO_CB7, 0x00000015 );
			sdoutOutp32(rSDO_CB8, 0x0000002b );
			sdoutOutp32(rSDO_CB9, 0x00000045 );
			sdoutOutp32(rSDO_CB10,0x00000059 );
			sdoutOutp32(rSDO_CB11,0x00000061 );
			sdoutOutp32(rSDO_CR1, 0x00000000 );
			sdoutOutp32(rSDO_CR2, 0x00000000 );
			sdoutOutp32(rSDO_CR3, 0x00000000 );
			sdoutOutp32(rSDO_CR4, 0x00000000 );
			sdoutOutp32(rSDO_CR5, 0x00000002 );
			sdoutOutp32(rSDO_CR6, 0x0000000a );
			sdoutOutp32(rSDO_CR7, 0x0000001e );
			sdoutOutp32(rSDO_CR8, 0x0000003d );
			sdoutOutp32(rSDO_CR9, 0x00000061 );
			sdoutOutp32(rSDO_CR10,0x0000007a );
			sdoutOutp32(rSDO_CR11,0x0000008f );
		}
		else 
		{
			sdoutOutp32(rSDO_Y0 , 0x00000000 );
			sdoutOutp32(rSDO_Y1 , 0x00000000 );
			sdoutOutp32(rSDO_Y2 , 0x00000000 );
			sdoutOutp32(rSDO_Y3 , 0x00000000 );
			sdoutOutp32(rSDO_Y4 , 0x00000000 );
			sdoutOutp32(rSDO_Y5 , 0x00000000 );
			sdoutOutp32(rSDO_Y6 , 0x00000000 );
			sdoutOutp32(rSDO_Y7 , 0x00000000 );
			sdoutOutp32(rSDO_Y8 , 0x00000000 );
			sdoutOutp32(rSDO_Y9 , 0x00000000 );
			sdoutOutp32(rSDO_Y10, 0x00000000 );
			sdoutOutp32(rSDO_Y11, 0x0000029a );
			sdoutOutp32(rSDO_CB0, 0x00000000 );
			sdoutOutp32(rSDO_CB1, 0x00000000 );
			sdoutOutp32(rSDO_CB2, 0x00000000 );
			sdoutOutp32(rSDO_CB3, 0x00000000 );
			sdoutOutp32(rSDO_CB4, 0x00000000 );
			sdoutOutp32(rSDO_CB5, 0x00000001 );
			sdoutOutp32(rSDO_CB6, 0x00000007 );
			sdoutOutp32(rSDO_CB7, 0x00000015 );
			sdoutOutp32(rSDO_CB8, 0x0000002b );
			sdoutOutp32(rSDO_CB9, 0x00000045 );
			sdoutOutp32(rSDO_CB10,0x00000059 );
			sdoutOutp32(rSDO_CB11,0x00000061 );
			sdoutOutp32(rSDO_CR1 ,0x00000000 );
			sdoutOutp32(rSDO_CR2 ,0x00000000 );
			sdoutOutp32(rSDO_CR3 ,0x00000000 );
			sdoutOutp32(rSDO_CR4 ,0x00000000 );
			sdoutOutp32(rSDO_CR5 ,0x00000002 );
			sdoutOutp32(rSDO_CR6 ,0x0000000a );
			sdoutOutp32(rSDO_CR7 ,0x0000001e );
			sdoutOutp32(rSDO_CR8 ,0x0000003d );
			sdoutOutp32(rSDO_CR9 ,0x00000061 );
			sdoutOutp32(rSDO_CR10,0x0000007a );
			sdoutOutp32(rSDO_CR11,0x0000008f );
		}
	}           
	else if ( uSelScale == 1 )
	{
		sdoutOutp32(rSDO_Y0  , 0x00000000);
		sdoutOutp32(rSDO_Y1  , 0x00000000);
		sdoutOutp32(rSDO_Y2  , 0x00000000);
		sdoutOutp32(rSDO_Y3  , 0x00000000);
		sdoutOutp32(rSDO_Y4  , 0x00000000);
		sdoutOutp32(rSDO_Y5  , 0x00000000);
		sdoutOutp32(rSDO_Y6  , 0x00000000);
		sdoutOutp32(rSDO_Y7  , 0x00000000);
		sdoutOutp32(rSDO_Y8  , 0x00000000);
		sdoutOutp32(rSDO_Y9  , 0x00000000);
		sdoutOutp32(rSDO_Y10 , 0x00000000);
		sdoutOutp32(rSDO_Y11 , 0x00000281);
		sdoutOutp32(rSDO_CB0 , 0x00000000);
		sdoutOutp32(rSDO_CB1 , 0x00000000);
		sdoutOutp32(rSDO_CB2 , 0x00000000);
		sdoutOutp32(rSDO_CB3 , 0x00000000);
		sdoutOutp32(rSDO_CB4 , 0x00000000);
		sdoutOutp32(rSDO_CB5 , 0x00000001);
		sdoutOutp32(rSDO_CB6 , 0x00000007);
		sdoutOutp32(rSDO_CB7 , 0x00000015);
		sdoutOutp32(rSDO_CB8 , 0x0000002a);
		sdoutOutp32(rSDO_CB9 , 0x00000044);
		sdoutOutp32(rSDO_CB10, 0x00000057);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
		sdoutOutp32(rSDO_CB11, 0x0000005f);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
		sdoutOutp32(rSDO_CR1 , 0x00000000);
		sdoutOutp32(rSDO_CR2 , 0x00000000);
		sdoutOutp32(rSDO_CR3 , 0x00000000);
		sdoutOutp32(rSDO_CR4 , 0x00000000);
		sdoutOutp32(rSDO_CR5 , 0x00000002);
		sdoutOutp32(rSDO_CR6 , 0x0000000a);
		sdoutOutp32(rSDO_CR7 , 0x0000001d);
		sdoutOutp32(rSDO_CR8 , 0x0000003c);
		sdoutOutp32(rSDO_CR9 , 0x0000005f);
		sdoutOutp32(rSDO_CR10, 0x0000007b);
		sdoutOutp32(rSDO_CR11, 0x00000086);
	} 
	else if ( uSelScale == 2 )
	{        
		sdoutOutp32(rSDO_Y0  ,0x00000000);
		sdoutOutp32(rSDO_Y1  ,0x00000000);
		sdoutOutp32(rSDO_Y2  ,0x00000000);
		sdoutOutp32(rSDO_Y3  ,0x00000000);
		sdoutOutp32(rSDO_Y4  ,0x00000000);
		sdoutOutp32(rSDO_Y5  ,0x00000000);
		sdoutOutp32(rSDO_Y6  ,0x00000000);
		sdoutOutp32(rSDO_Y7  ,0x00000000);
		sdoutOutp32(rSDO_Y8  ,0x00000000);
		sdoutOutp32(rSDO_Y9  ,0x00000000);
		sdoutOutp32(rSDO_Y10 ,0x00000000);
		sdoutOutp32(rSDO_Y11 ,0x0000025d);
		sdoutOutp32(rSDO_CB0 ,0x00000000);
		sdoutOutp32(rSDO_CB1 ,0x00000000);
		sdoutOutp32(rSDO_CB2 ,0x00000000);
		sdoutOutp32(rSDO_CB3 ,0x00000000);
		sdoutOutp32(rSDO_CB4 ,0x00000000);
		sdoutOutp32(rSDO_CB5 ,0x00000001);
		sdoutOutp32(rSDO_CB6 ,0x00000007);
		sdoutOutp32(rSDO_CB7 ,0x00000014);
		sdoutOutp32(rSDO_CB8 ,0x00000028);
		sdoutOutp32(rSDO_CB9 ,0x0000003f);
		sdoutOutp32(rSDO_CB10,0x00000052);
		sdoutOutp32(rSDO_CB11,0x0000005a);
		sdoutOutp32(rSDO_CR1 ,0x00000000);
		sdoutOutp32(rSDO_CR2 ,0x00000000);
		sdoutOutp32(rSDO_CR3 ,0x00000000);
		sdoutOutp32(rSDO_CR4 ,0x00000000);
		sdoutOutp32(rSDO_CR5 ,0x00000001);
		sdoutOutp32(rSDO_CR6 ,0x00000009);
		sdoutOutp32(rSDO_CR7 ,0x0000001c);
		sdoutOutp32(rSDO_CR8 ,0x00000039);
		sdoutOutp32(rSDO_CR9 ,0x0000005a);
		sdoutOutp32(rSDO_CR10,0x00000074);
		sdoutOutp32(rSDO_CR11,0x0000007e);
	}                                                 
	else                                      
	{                                         
		sdoutOutp32(rSDO_Y0  ,0x00000000);
		sdoutOutp32(rSDO_Y1  ,0x00000000);
		sdoutOutp32(rSDO_Y2  ,0x00000000);
		sdoutOutp32(rSDO_Y3  ,0x00000000);
		sdoutOutp32(rSDO_Y4  ,0x00000000);
		sdoutOutp32(rSDO_Y5  ,0x00000000);
		sdoutOutp32(rSDO_Y6  ,0x00000000);
		sdoutOutp32(rSDO_Y7  ,0x00000000);
		sdoutOutp32(rSDO_Y8  ,0x00000000);
		sdoutOutp32(rSDO_Y9  ,0x00000000);
		sdoutOutp32(rSDO_Y10 ,0x00000000);
		sdoutOutp32(rSDO_Y11 ,0x00000251);
		sdoutOutp32(rSDO_CB0 ,0x00000000);
		sdoutOutp32(rSDO_CB1 ,0x00000000);
		sdoutOutp32(rSDO_CB2 ,0x00000000);
		sdoutOutp32(rSDO_CB3 ,0x00000000);
		sdoutOutp32(rSDO_CB4 ,0x00000000);
		sdoutOutp32(rSDO_CB5 ,0x00000001);
		sdoutOutp32(rSDO_CB6 ,0x00000006);
		sdoutOutp32(rSDO_CB7 ,0x00000013);
		sdoutOutp32(rSDO_CB8 ,0x00000028);
		sdoutOutp32(rSDO_CB9 ,0x0000003f);
		sdoutOutp32(rSDO_CB10,0x00000051);
		sdoutOutp32(rSDO_CB11,0x00000056);
		sdoutOutp32(rSDO_CR1 ,0x00000000);
		sdoutOutp32(rSDO_CR2 ,0x00000000);
		sdoutOutp32(rSDO_CR3 ,0x00000000);
		sdoutOutp32(rSDO_CR4 ,0x00000000);
		sdoutOutp32(rSDO_CR5 ,0x00000002);
		sdoutOutp32(rSDO_CR6 ,0x00000005);
		sdoutOutp32(rSDO_CR7 ,0x00000018);
		sdoutOutp32(rSDO_CR8 ,0x00000037);
		sdoutOutp32(rSDO_CR9 ,0x0000005A);
		sdoutOutp32(rSDO_CR10,0x00000076);
		sdoutOutp32(rSDO_CR11,0x0000007e);
	}
}


// [Set CRC]
void TVENC_SetCrc( void )
{
	u32 i;
	u8 CGMS[14], CRC[6], OLD_CRC;
	u32 TEMP_IN;
	
	sdoutInp32( rSDO_ARMWSS525, TEMP_IN );
	for ( i=0; i<14; i++ )
		CGMS[i] = (u8)(TEMP_IN>>i ) & 0x1 ;
	
	// initialize state 
	for ( i=0; i<6; i++ )
		CRC[i] = 0x1;

	// round 20 
	for ( i=0; i<14; i++ )
	{
		OLD_CRC = CRC[0];
		CRC[0] = CRC[1];
		CRC[1] = CRC[2];
		CRC[2] = CRC[3];
		CRC[3] = CRC[4];
		CRC[4] = OLD_CRC ^ CGMS[i] ^ CRC[5];
		CRC[5] = OLD_CRC ^ CGMS[i];
	}

	// recompose to return crc 
	TEMP_IN &= 0x3fff;
	
	for( i=0; i<6; i++ )
	{
		TEMP_IN |= ( (u32)(CRC[i]&0x1)<<(i+14));
	}

	sdoutOutp32( rSDO_ARMWSS525, TEMP_IN );
	sdoutOutp32( rSDO_ARMCGMS525, TEMP_IN );
}

// [Set Wss525Cgms ratio]
void TVENC_SetWss525CgmsRatio( SDOUT_WSS525_RATIO_T eAspectRatio)
{
	u32 uTempVal=0, uWssTemp=0;
	 
	switch ( eAspectRatio )
	{
		case SDOUT_WSS525_NORMAL:
			uTempVal = 0x00;
			break;
			
		case SDOUT_WSS525_ANAMORPHIC:
			uTempVal = 0x01;
			break;

		case SDOUT_WSS525_LB:
			uTempVal = 0x02;
			break;
	}

	sdoutInp32( rSDO_ARMWSS525, uWssTemp ); 	
	uWssTemp &= 0xfffffffC; // [19]111111 11111111 11111 00[0]
	uWssTemp |= uTempVal;

	sdoutOutp32(rSDO_ARMWSS525, uWssTemp);
	sdoutOutp32(rSDO_ARMCGMS525, uWssTemp);

	TVENC_SetCrc();
	
}

// [Set Wss525Cci And Copy]
void TVENC_SetWss525CciAndCopy( SDOUT_WSS525_CCI_T eCciOnOff, SDOUT_WSS525_COPY_T eCopyOnOff )
{
	u32 uTempVal=0, uWssTemp=0;
	
	switch ( eCciOnOff )
	{
		case SDOUT_WSS525_CCI_ON:
			uTempVal |= ( 0x0 << 2 );
			break;
			
		case SDOUT_WSS525_CCI_OFF:
			uTempVal |= ( 0xf << 2 );
			break;
	}

	switch ( eCopyOnOff )
	{
		case SDOUT_WSS525_COPY:
			uTempVal |= ( 0x0 << 6 );
			break;
			
		case SDOUT_WSS525_COPY_ONE:
			uTempVal |= ( 0x1 << 6 );
			break;

		case SDOUT_WSS525_COPY_NO:
			uTempVal |= ( 0x3 << 6 );
			break;
	}

	sdoutInp32( rSDO_ARMWSS525, uWssTemp ); 	
	uWssTemp &= 0xffffc003;	// [19]111111 00000000 0000 11[0] 
	uWssTemp |= uTempVal;
	
	sdoutOutp32(rSDO_ARMWSS525, uWssTemp);
	sdoutOutp32(rSDO_ARMCGMS525, uWssTemp);

	TVENC_SetCrc();
}

// [Set Wss525Analog And Psp]
//void TVENC_SetWss525AnalogAndPsp( SDOUT_WSS525_ANALOG_T analog, SDOUT_WSS525_PSP_T psp)
void TVENC_SetWss525AnalogAndPsp( SDOUT_WSS525_PSP_T psp, SDOUT_WSS525_ANALOG_T analog )
{
	u32 uTempVal=0, uWssTemp=0;
	
	switch ( psp )
	{
		case SDOUT_WSS525_PSP_OFF:
			uTempVal |= ( 0x0 << 8 );
			break;
			
		case SDOUT_WSS525_PSP_2LINE:
			uTempVal |= ( 0x1 << 8 );
			break;

		case SDOUT_WSS525_PSP_ONLY:
			uTempVal |= ( 0x2 << 8 );
			break;

		case SDOUT_WSS525_PSP_4LINE:
			uTempVal |= ( 0x3 << 8 );
			break;
	}

	switch ( analog )
	{
		case SDOUT_WSS525_ANALOG_OFF:
			uTempVal |= ( 0x0 << 10 );
			break;
			
		case SDOUT_WSS525_ANALOG_ON:
			uTempVal |= ( 0x1 << 10 );
			break;
	}

	sdoutInp32( rSDO_ARMWSS525, uWssTemp ); 	
	uWssTemp &= 0xfffffaff;	// [19]111111 00000000 0000 11[0] 
	uWssTemp |= uTempVal;

	sdoutOutp32(rSDO_ARMWSS525, uWssTemp);
	sdoutOutp32(rSDO_ARMCGMS525, uWssTemp);

	TVENC_SetCrc();
}

// [Set Wss625 Ratio]
void TVENC_SetWss625Ratio( SDOUT_WSS625_RATIO_T ratio )
{
	u32 uTempVal = 0;
	u32 uWssTemp = 0;

	switch ( ratio )
	{
		case SDOUT_WSS625_4_3_FULL:
			uTempVal			 |= ( 0x8 << 0 );
			break; 
			 
		case SDOUT_WSS625_14_9_LB_C:
			uTempVal			 |= ( 0x1 << 0 );
			break; 
 
		case SDOUT_WSS625_14_9_LB_T:
			uTempVal			 |= ( 0x2 << 0 );
			break; 
 
		case SDOUT_WSS625_16_9_LB_C:
			uTempVal			 |= ( 0xB << 0 );
			break; 
 
		case SDOUT_WSS625_16_9_LB_T:
			uTempVal			 |= ( 0x4 << 0 );
			break; 
 
		case SDOUT_WSS625_16_9_LB_C2:
			uTempVal			 |= ( 0xD << 0 );
			break; 
 
		case SDOUT_WSS625_14_9_FULL:
			uTempVal			 |= ( 0xE << 0 );
			break; 
 
		case SDOUT_WSS625_16_9_FULL:
			uTempVal			 |= ( 0x7 << 0 );
			break; 
	}

	sdoutInp32(rSDO_ARMWSS625, uWssTemp);  																																													
	uWssTemp &= 0xfffffff0;	            																																													
	uWssTemp |= uTempVal;                 																																													
                                                   																																													
	sdoutOutp32(rSDO_ARMWSS625, uWssTemp); 																																													
	sdoutOutp32(rSDO_ARMCGMS625, uWssTemp);																																													

}

// [Set Wss625Mode And Color And Helper]
void  TVENC_SetWss625ModeAndColorAndHelper( 
	SDOUT_WSS625_MODE_T camera_film, SDOUT_WSS625_COLOR_T pal_ma, SDOUT_WSS625_HELPER_T helper)
{

	u32 uTempVal = 0;
	u32 uWssTemp = 0;

	switch ( camera_film )
	{
		case SDOUT_WSS625_CAMERA:
			uTempVal		|= ( 0x0 << 4 );
			break;
			
		case SDOUT_WSS625_FILM:
			uTempVal		|= ( 0x1 << 4 );
			break;
	}

	switch ( pal_ma )
	{
		case SDOUT_WSS625_PAL:
			uTempVal		|= ( 0x0 << 5 );
			break;
			
		case SDOUT_WSS625_MA:
			uTempVal		|= ( 0x1 << 5 );
			break;
	}

	switch ( helper )
	{
		case SDOUT_WSS625_HELPER_OFF:
			uTempVal			|= ( 0x0 << 6 );
			break;
			
		case SDOUT_WSS625_HELPER_ON:
			uTempVal			|= ( 0x1 << 6 );
			break;
	}

	sdoutInp32(rSDO_ARMWSS625, uWssTemp);
	uWssTemp	&= 0xffffff8f;	// 1000 1111 
	uWssTemp	|= uTempVal;

	sdoutOutp32(rSDO_ARMWSS625, uWssTemp);
	sdoutOutp32(rSDO_ARMCGMS625, uWssTemp);

}

// [Set Wss625Text And Subtitle]
void TVENC_SetWss625TextAndSubtitle( 
	SDOUT_WSS625_TELETEXT_T teletext, SDOUT_WSS625_SUBTITLE_T subtitle )
{
	u32 uTempVal = 0;
	u32 uWssTemp = 0;

	switch ( teletext )
	{
		case SDOUT_WSS625_TELETEXT_OFF:
			uTempVal			|= ( 0x0 << 8 );
			break;
			
		case SDOUT_WSS625_TELETEXT_ON:
			uTempVal			|= ( 0x1 << 8 );
			break;
	}

	switch ( subtitle )
	{
		case SDOUT_WSS625_SUBTITLE_OFF:
			uTempVal				|= ( 0x0 << 9 );
			break;
			
		case SDOUT_WSS625_SUBTITLE_INSIDE:
			uTempVal				|= ( 0x1 << 9 );
			break;

		case SDOUT_WSS625_SUBTITLE_OUTSIDE:
			uTempVal				|= ( 0x2 << 9);
			break;
	}

	sdoutInp32(rSDO_ARMWSS625, uWssTemp);
	uWssTemp &= 0xfffff8ff;	// 1000 1111 1111 
	uWssTemp |= uTempVal;

	sdoutOutp32(rSDO_ARMWSS625, uWssTemp);
	sdoutOutp32(rSDO_ARMCGMS625, uWssTemp);


}

// [Set Wss625Surround And Copy And Restrict]
void TVENC_SetWss625SurroundAndCopyAndRestrict( 
	SDOUT_WSS625_SURROUND_T surround, SDOUT_WSS625_COPYRIGHT_T copyright, SDOUT_WSS625_RESTRICT_T restrict )
{
	u32 uTempVal = 0;
	u32 uWssTemp = 0;

	switch ( surround )
	{
		case SDOUT_WSS625_SURROUND_OFF:
			uTempVal			|= ( 0x0 << 11 );
			break;
			
		case SDOUT_WSS625_SURROUND_ON:
			uTempVal			|= ( 0x1 << 11 );
			break;
	}

	switch ( copyright )
	{
		case SDOUT_WSS625_COPYRIGHT_OFF:
			uTempVal			|= ( 0x0 << 12 );
			break;
			
		case SDOUT_WSS625_COPYRIGHT_ON:
			uTempVal			|= ( 0x1 << 12 );
			break;
	}

	switch ( restrict )
	{
		case SDOUT_WSS625_COPY_RESTRICT_NOT:
			uTempVal				|= ( 0x0 << 13 );
			break;
			
		case SDOUT_WSS625_COPY_RESTRICT:
			uTempVal				|= ( 0x1 << 13 );
			break;
	}

	sdoutInp32(rSDO_ARMWSS625, uWssTemp);
	uWssTemp &= 0xffffc7ff;	// 1100 0111 1111 1111 
	uWssTemp |= uTempVal;

	sdoutOutp32(rSDO_ARMWSS625, uWssTemp);
	sdoutOutp32(rSDO_ARMCGMS625, uWssTemp);

}








// [Reset]
void TVENC_Reset(void)
{
	u32 uClkVal;
	sdoutInp32(rSDO_CLKCON, uClkVal);
	uClkVal |= (0x1<<4);
	sdoutOutp32(rSDO_CLKCON, uClkVal);
}

// 
void TVENC_ClrReset(void)
{
	u32 uClkVal;
	sdoutInp32(rSDO_CLKCON, uClkVal);
	uClkVal &= ~(0x1<<4);
	sdoutOutp32(rSDO_CLKCON, uClkVal);
}


// [Set OverSampling Filter]
void TVENC_SetOverSamplingFilter(SCAN_MODE eScanMode)
{
	u32 uOffset=0;
	u32 uStartOsfcReg;
	u32 uOsfcReg[24];
	u32 i;
	
	if (eScanMode == PROGRESSIVE)
	{
		u32 uOsfcReg0 = rSDO_OSFC00_0;
		u32 uOsfcReg1 = rSDO_OSFC00_1;
		u32 uOsfcReg2 = rSDO_OSFC00_2; 
		for ( i=0; i<12; i++, uOsfcReg0+=4, uOsfcReg1+=4) // Setting SFR data
		{ 
			sdoutOutp32(uOsfcReg0, 0); // Setting from SDOUT_OSFC00_0 to SDOUT_OSFC11_0
			sdoutOutp32(uOsfcReg1, 0); // Setting from SDOUT_OSFC00_1 to SDOUT_OSFC11_1
			sdoutOutp32(uOsfcReg2, 0); // Setting from SDOUT_OSFC00_2 to SDOUT_OSFC11_2
		}

		
		uStartOsfcReg = rSDO_OSFC12_0;
		for ( i=0; i<12; i++, uOffset+=4) // Setting SFR addr from SDOUT_OSFC12_0 to SDOUT_OSFC23_0
			uOsfcReg[i] = uStartOsfcReg+uOffset;

		uOffset = 0;
		// Setting SFR data from SDOUT_OSFC12_0 ~ SDOUT_OSFC23_0 to SDOUT_OSFC12_2~SDOUT_OSFC23_2		
		for ( i=0; i<3; i++) 
		{
			uOffset += (i==0) ? 0x0 : (i==1) ? 0xc0 : 0x60;
			
			sdoutOutp32(uOsfcReg[0]+uOffset, ((-3&0xfff)<<0)|(0<<16));
			sdoutOutp32(uOsfcReg[1]+uOffset, (5<<0)|(0<<16));
			sdoutOutp32(uOsfcReg[2]+uOffset, ((-8&0xfff)<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[3]+uOffset, (13<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[4]+uOffset, ((-19&0xfff)<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[5]+uOffset, (28<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[6]+uOffset, ((-39&0xfff)<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[7]+uOffset, (55<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[8]+uOffset, ((-79&0xfff)<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[9]+uOffset, (120<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[10]+uOffset, ((-211&0xff)<<0)|(0<<16));	
			sdoutOutp32(uOsfcReg[11]+uOffset, (650<<0)|(1024<<16));			
		}
	}
	else // INTERLACE 
	{

		uStartOsfcReg = rSDO_OSFC00_0;
		for ( i=0; i<24; i++, uOffset+=4) // Setting SFR addr from SDOUT_OSFC00_0 to SDOUT_OSFC23_0
			uOsfcReg[i] = uStartOsfcReg + uOffset;

		uOffset = 0;
		for ( i=0; i<3; i++) // Setting SFR data from SDOUT_OSFC00_0 to SDOUT_OSFC23_2
		{
			uOffset += (i==0) ? 0x0 : (i==1) ? 0xc0 : 0x60;
			
			sdoutOutp32( uOsfcReg[0]+uOffset, ((-2&0xfff)<<0)|((-3&0xfff)<<0) );
			sdoutOutp32( uOsfcReg[1]+uOffset, 0 );
			sdoutOutp32( uOsfcReg[2]+uOffset, (4<<0)|(5<<16) );
			sdoutOutp32( uOsfcReg[3]+uOffset, ((-1&0xfff)<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[4]+uOffset, ((-6&0xfff)<<0)|((-9&0xfff)<<16) );
			sdoutOutp32( uOsfcReg[5]+uOffset, (1<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[6]+uOffset, (10<<0)|(14<<16) );
			sdoutOutp32( uOsfcReg[7]+uOffset, ((-1&0xfff)<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[8]+uOffset, ((-14&0xfff)<<0)|((-20&0xfff)<<16) );
			sdoutOutp32( uOsfcReg[9]+uOffset, (1<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[10]+uOffset, (20<<0)|(29<<16) );
			sdoutOutp32( uOsfcReg[11]+uOffset, ((-2&0xfff)<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[12]+uOffset, ((-28&0xfff)<<0)|((-40&0xfff)<<16) );
			sdoutOutp32( uOsfcReg[13]+uOffset, (2<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[14]+uOffset, (40<<0)|(56<<16) );
			sdoutOutp32( uOsfcReg[15]+uOffset, ((-3&0xfff)<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[16]+uOffset, ((-57&0xfff)<<0)|((-80&0xfff)<<16) );
			sdoutOutp32( uOsfcReg[17]+uOffset, (5<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[18]+uOffset, (86<<0)|(121<<16) );	
			sdoutOutp32( uOsfcReg[19]+uOffset, ((-10&0xfff)<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[20]+uOffset, ((-154&0xfff)<<0)|((-212&0xfff)<<16) );
			sdoutOutp32( uOsfcReg[21]+uOffset, (27<<0)|(0<<16) );
			sdoutOutp32( uOsfcReg[22]+uOffset, (613<<0)|(651<<16) );
			sdoutOutp32( uOsfcReg[23]+uOffset, ((-308&0xfff)<<0)|(1024<<16) );			
		}
	}
}

#if 0
// [InitBaseHWForSdout]
void InitBaseHWForSdout(void)
{
	// Set Mixer Clock
	u32 x=0;
	sdoutInp32(0xe0100208,x);
	x |= (1<<28);
	sdoutOutp32(0xe0100208, x);

	// Set DAC Enable
	x = 0;
	sdoutInp32(0xe0108200,x);
	x |= (1<<26);
	sdoutOutp32(0xe0108200, x);

	// Set 'MIXER_OUT_SEL' to TVENC 
	x = 0;
	sdoutInp32(0xe0200304,x);
	x |= (0<<0);
	sdoutOutp32(0xe0200304, x);
}
#endif


void TVENC_InitIpAndSetOn( TV_STANDARDS eTvSys, SCAN_MODE eScanMode, SDOUT_VIDEO_SIGNAL eVidSignal )
{
	TVENC_Reset(); 
	TVENC_InitIp( eTvSys, eScanMode, eVidSignal );
	if ((eVidSignal == SDOUT_COMPONENT_SIG)||(eVidSignal == SDOUT_COMPONENT_SIG_PROG))
	{
		TVENC_SetComponentIf(SDOUT_YPBPR);
	}
	else if ((eVidSignal == SDOUT_COMPONENT_RGB)||(eVidSignal == SDOUT_COMPONENT_RGB_PROG))
	{
		TVENC_SetComponentIf(SDOUT_RGB);
	}
	TVENC_SetOnOff(1);
}

//////////////////////////////////////////////////////////

void TVENC_SetCfgDAC (SDOUT_VIDEO_SIGNAL eVidSignal, DAC_SIG eDAC2, DAC_SIG eDAC1, DAC_SIG eDAC0  )
{
	u32 uRegValue;
	u32 uComVidType;

	//uRegValue = Inp32(rSDO_CONFIG);
	sdoutInp32(rSDO_CONFIG, uRegValue);
	

	if(eVidSignal == SDOUT_COMPOSITE_SIG)
	{
		uRegValue = (uRegValue & ~(0x3<<12|0x3<<10|0x3<<8|0x1<<6|0x1<<4))|((eDAC2<<12)|(eDAC1<<10)|(eDAC0<<8)|(0<<6)|(0<<4)) ;
		Outp32(rSDO_CONFIG, uRegValue);
		
	}
	else if (eVidSignal == SDOUT_SVIDEO_SIG)
	{
		uRegValue = (uRegValue & ~(0x3<<12|0x3<<10|0x3<<8|0x1<<6|0x1<<4))|((eDAC2<<12)|(eDAC1<<10)|(eDAC0<<8)|(0<<6)|(0<<4)) ;
		Outp32(rSDO_CONFIG, uRegValue);
	}
	else if (eVidSignal == SDOUT_COMPONENT_SIG)
	{
		uRegValue = (uRegValue & ~(0x3<<20|0x3<<18|0x3<<16|0x1<<6|0x1<<5|0x1<<4));
		uRegValue = uRegValue |((eDAC2<<20)|(eDAC1<<18)|(eDAC0<<16)|(1<<6)|(1<<5)|(0<<4)) ;
		Outp32(rSDO_CONFIG, uRegValue);
	}
	else if (eVidSignal == SDOUT_COMPONENT_SIG_PROG)
	{
		uRegValue = (uRegValue & ~(0x3<<20|0x3<<18|0x3<<16|0x1<<6|0x1<<5|0x1<<4));
		uRegValue = uRegValue |((eDAC2<<20)|(eDAC1<<18)|(eDAC0<<16)|(1<<6)|(1<<5)|(1<<4)) ;
		Outp32(rSDO_CONFIG, uRegValue);
	}
	else if (eVidSignal == SDOUT_COMPONENT_RGB)
	{
		uRegValue = (uRegValue & ~(0x3<<20|0x3<<18|0x3<<16|0x1<<6|0x1<<5|0x1<<4));
		uRegValue = uRegValue |((eDAC2<<20)|(eDAC1<<18)|(eDAC0<<16)|(1<<6)|(0<<5)|(0<<4)) ;
		Outp32(rSDO_CONFIG, uRegValue);
	}
	else if (eVidSignal == SDOUT_COMPONENT_RGB_PROG)
	{
		uRegValue = (uRegValue & ~(0x3<<20|0x3<<18|0x3<<16|0x1<<6|0x1<<5|0x1<<4));
		uRegValue = uRegValue |((eDAC2<<20)|(eDAC1<<18)|(eDAC0<<16)|(1<<6)|(0<<5)|(1<<4)) ;
		Outp32(rSDO_CONFIG, uRegValue);
	}

	
}

//////////
// Function Name 	: 	TVENC_SetVidSync
// Description		:	Sync Signal Insertion for Ypbpr, RGB ( for only Component Signal)
// Input 			:	SDOUT_SYNC_CONFIG : YPbPr - SDOUT_SYNC_ONE_CH
void TVENC_SetVidSync (SDOUT_SYNC_CONFIG eSyncIn )
{

	sdoutOutp32(rSDO_SYNC, eSyncIn);

}

//////////
// Function Name 	: 	TVENC_SetVBICfg
// Description		:	
// Input 			:	
void TVENC_SetVBICfg (SDOUT_VIDEO_SIGNAL eVidSignal,  SDOUT_InsertVBI eWSS, SDOUT_InsertVBI eCC, SDOUT_InsertVBI eCGMS )
{
	u32 uRegValue;

	switch(eVidSignal)
	{
		case SDOUT_COMPOSITE_SIG:
				uRegValue =  eWSS<<14|eCC<<12;
				sdoutOutp32(rSDO_VBI, uRegValue);					
				break;
		case SDOUT_SVIDEO_SIG:
				uRegValue =  eWSS<<10|eCC<<8;
				sdoutOutp32(rSDO_VBI, uRegValue);	
				break;
		case SDOUT_COMPONENT_SIG:
				uRegValue =  eWSS<<2|eCC<<0;
				sdoutOutp32(rSDO_VBI, uRegValue);				
				break;
		case SDOUT_COMPONENT_SIG_PROG:
				uRegValue =  eCGMS<<3;
				sdoutOutp32(rSDO_VBI, uRegValue);	
				break;				
		case SDOUT_COMPONENT_RGB:
				uRegValue =  eWSS<<6|eCC<<4;
				sdoutOutp32(rSDO_VBI, uRegValue);	
				break;
		case SDOUT_COMPONENT_RGB_PROG:
				uRegValue =  eCGMS<<7;
				sdoutOutp32(rSDO_VBI, uRegValue);
				break;			
	}
}

//////////
// Function Name 	: 	TVENC_SetChSignalScale
// Description		:	
// Input 			:	SDOUT_DAC
//					uOffset : 0x0 ~ 0x3FF   : 0x0 ->0, 1FF -> 511, 200 -> -512 
//					uGain   : 0x0 ~ 0xFFF   : 0x800 -> x1.0
void TVENC_SetChSignalScale (SDOUT_DAC eDAC, u32 uOffset, u32 uGain)
{
	switch(eDAC)
	{
		case DAC0:
				sdoutOutp32(rSDO_SCALE_CH0, uOffset<<16|uGain<<0);
				break;
		case DAC1:
				sdoutOutp32(rSDO_SCALE_CH1, uOffset<<16|uGain<<0);
				break;		
		case DAC2:
				sdoutOutp32(rSDO_SCALE_CH2, uOffset<<16|uGain<<0);
				break;				
	}
	

}

//////////
// Function Name 	: 	TVENC_SetYCDELAY
// Description		:	
// Input 			:	uYdelay (0x0~0xF)
//					uActStartDelay(0x0~0x3F, 0xFF~0x40) 
//					uActEndDelay (0x0~0x3F, 0xFF~0x40)
void TVENC_SetYCDELAY (u32 uYdelay, u32 uActStartDelay, u32 uActEndDelay)
{
		sdoutOutp32(rSDO_YCDELAY, uYdelay<<16|uActStartDelay<<8|uActEndDelay<<0);
}

//////////
// Function Name 	: 	TVENC_SetPwrCtrlDAC
// Description		:	
// Input 			:	SDOUT_DAC (DAC0,DAC1,DAC2, DAC_ALL)
//					uOnOff (On: 1, Off:0)
void TVENC_SetPwrCtrlDAC (SDOUT_DAC eDAC, u32 uOnOff)
{
	u32 uRegValue;

	sdoutInp32(rSDO_DAC,uRegValue);

	switch(eDAC)
	{
		case DAC0:
			uRegValue = (uRegValue&~(0x1<<0))|(uOnOff<<0);	
			//sdoutOutp32(rSDO_DAC, (Inp32(rSDO_DAC)&~(0x1<<0))|(uOnOff<<0));
			sdoutOutp32(rSDO_DAC, uRegValue);
			break;
		case DAC1:
			uRegValue = (uRegValue&~(0x1<<1))|(uOnOff<<1);	
			sdoutOutp32(rSDO_DAC, uRegValue);	
			//sdoutOutp32(rSDO_DAC, (Inp32(rSDO_DAC)&~(0x1<<1))|(uOnOff<<1));
			break;			
		case DAC2:
			uRegValue = (uRegValue&~(0x1<<2))|(uOnOff<<2);	
			sdoutOutp32(rSDO_DAC, uRegValue);	
			//sdoutOutp32(rSDO_DAC, (Inp32(rSDO_DAC)&~(0x1<<2))|(uOnOff<<2));
			break;	
		case DAC_ALL:
			uRegValue = (uRegValue&~(0x7<<0))|(uOnOff<<2|uOnOff<<1|uOnOff<<0);	
			sdoutOutp32(rSDO_DAC, uRegValue);	
			//sdoutOutp32(rSDO_DAC, (Inp32(rSDO_DAC)&~(0x7<<0))|(uOnOff<<2|uOnOff<<1|uOnOff<<0));
			break;			
	}
}

//////////
// Function Name 	: 	TVENC_GetFieldInfo
// Description		:	
// Input 			:	void
void TVENC_GetFieldInfo (void)
{
	u32 uRegValue;
	
	//uRegValue = Inp32(rSDO_FINFO);
	sdoutInp32(rSDO_FINFO, uRegValue);
	
	g_FieldCounter = (uRegValue >> 16)&0x3FF;
	g_FieldId = uRegValue & 0x3;
}

//////////
// Function Name 	: 	TVENC_SetHueBrightCtrl
// Description		:	
// Input 			:	uBypass : "1" (Bypass), "0"(ON)
//					Y/CB/CR : Offset, Gain0, Gain1
void TVENC_SetHueBrightCtrl (u32 uBypass, oSDOUT_HueCtrl oYScale, oSDOUT_HueCtrl oCBScale, oSDOUT_HueCtrl oCRScale)
{
	u32 uGain0_Y, uGain0_CB, uGain1_CB, uGain0_CR, uGain1_CR;
	u32 uOffset_Y, uOffset_CB, uOffset_CR;
	u32 uRegVal;

	uGain0_Y = oYScale.SDO_Gain0;
	uOffset_Y = oYScale.SDO_Offset;
	uGain0_CB = oCBScale.SDO_Gain0;
	uGain1_CB = oCBScale.SDO_Gain1;
	uOffset_CB = oCBScale.SDO_Offset;
	uGain0_CR = oCRScale.SDO_Gain0;
	uGain1_CR = oCRScale.SDO_Gain1;
	uOffset_CR = oCRScale.SDO_Offset;	

	sdoutInp32(rSDO_CCCON, uRegVal);

	if(uBypass == 1)	// ByPass
	{
		uRegVal = (uRegVal&~(1<<4))|(1<<4);
		//sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<4))|(1<<4));
		sdoutOutp32(rSDO_CCCON, uRegVal);
	}
	else 			// Hue&Brightness Control ON
	{
		sdoutOutp32(rSDO_YSCALE, (uGain0_Y<<16|uOffset_Y<<0));
		sdoutOutp32(rSDO_CBSCALE, (uGain0_CB<<16|uGain1_CB<<0));
		sdoutOutp32(rSDO_CRSCALE, (uGain0_CR<<16|uGain1_CR<<0));
		sdoutOutp32(rSDO_CB_CR_OFFSET, (uOffset_CR<<16|uOffset_CB<<0));

		uRegVal = (uRegVal&~(1<<4))|(0<<4);
		sdoutOutp32(rSDO_CCCON, uRegVal);
		//sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<4))|(0<<4));
	
	}

}

//////////
// Function Name 	: 	TVENC_SetYPbPrCC
// Description		:	
// Input 			:	uBypass : "1" (Bypass), "0"(ON)
//					
void TVENC_SetYPbPrCC(u32 uBypass)
{
	u32 uRegVal;

	sdoutInp32(rSDO_CCCON, uRegVal);

	if(uBypass == 1)	// ByPass
	{
		uRegVal = (uRegVal&~(1<<3))|(1<<3);
		sdoutOutp32(rSDO_CCCON, uRegVal);
		//sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<3))|(1<<3));
	}
	else
	{
		uRegVal = (uRegVal&~(1<<3))|(0<<3);
		sdoutOutp32(rSDO_CCCON, uRegVal);
		//sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<3))|(0<<3));
	}

}

//////////
// Function Name 	: 	TVENC_SetRGBCC
// Description		:	
// Input 			:	uBypass : "1" (Bypass), "0"(ON)
//					Max_RGB_Cube(0~0xFF), Min_RGB_Cube(0~0xFF) & Max value shout be higher than Min Value 
void TVENC_SetRGBCC(u32 uBypass, u32 uMaxVal, u32 uMinVal)
{
	u32 uRegVal;
	sdoutInp32(rSDO_CCCON, uRegVal);

	if(uBypass == 1)	// ByPass
	{
		uRegVal = (uRegVal&~(1<<2))|(1<<2);
		sdoutOutp32(rSDO_CCCON, uRegVal);
		//sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<2))|(1<<2));
	}
	else
	{
		Assert(uMaxVal >= uMinVal);
		sdoutOutp32(rSDO_RGB_CC, (uMaxVal<<8|uMinVal<<0));
		uRegVal = (uRegVal&~(1<<2))|(0<<2);
		sdoutOutp32(rSDO_CCCON, uRegVal);
		//sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<2))|(0<<2));
	}

}


//////////
// Function Name 	: 	TVENC_SetYCCC
// Description		:	
// Input 			:	uBypass : "1" (Bypass), "0"(ON)
//					SDOUT_YCnCVBS_CC 
void TVENC_SetYCCC(u32 uBypass, oSDOUT_YCnCVBS_CC oYCCC)
{
	u32 uTopCylinder, uBtmCylinder;
	u32 uRadius;
	u32 uRegVal;

	uTopCylinder = oYCCC.SDO_Y_Top;
	uBtmCylinder = oYCCC.SDO_Y_Bottom;
	uRadius = oYCCC.SDO_Y_Radius;

	sdoutInp32(rSDO_CCCON, uRegVal);
	
	if(uBypass == 1)	// ByPass
	{
		uRegVal = (uRegVal&~(1<<1))|(1<<1);
		sdoutOutp32(rSDO_CCCON, uRegVal);
		//sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<1))|(1<<1));
	}
	else
	{
		Assert(uTopCylinder>= uBtmCylinder);
		sdoutOutp32(rSDO_YC_CC_Y, (uTopCylinder<<16|uBtmCylinder<<0));
		sdoutOutp32(rSDO_YC_CC_C, uRadius);
		uRegVal = (uRegVal&~(1<<1))|(0<<1);
		sdoutOutp32(rSDO_CCCON, uRegVal);	
//		sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<1))|(0<<1));
	}

}

//////////
// Function Name 	: 	TVENC_SetCVBSCC
// Description		:	
// Input 			:	uBypass : "1" (Bypass), "0"(ON)
//					SDOUT_YCnCVBS_CC 
void TVENC_SetCVBSCC(u32 uBypass, oSDOUT_YCnCVBS_CC oCVBSCC)
{
	u32 uLowCylinder,uBtmCylinder, uTopCylinder, uUpperCylinder ;
	u32 uRadius;
	u32 uRegVal;

	uTopCylinder = oCVBSCC.SDO_Y_Top;
	uBtmCylinder = oCVBSCC.SDO_Y_Bottom;
	uUpperCylinder = oCVBSCC.SDO_Y_Upper;
	uLowCylinder = oCVBSCC.SDO_Y_Lower;
	uRadius = oCVBSCC.SDO_Y_Radius;

	sdoutInp32(rSDO_CCCON, uRegVal);
	
	if(uBypass == 1)	// ByPass
	{
		uRegVal = (uRegVal&~(1<<1))|(1<<0);
		sdoutOutp32(rSDO_CCCON, uRegVal);
		//sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<0))|(1<<0));
	}
	else
	{
		
		sdoutOutp32(rSDO_CVBS_CC_Y1, (uLowCylinder<<16|uBtmCylinder<<0));
		sdoutOutp32(rSDO_CVBS_CC_Y2, (uTopCylinder<<16|uUpperCylinder<<0));
		sdoutOutp32(rSDO_CVBS_CC_C, uRadius);
		uRegVal = (uRegVal&~(1<<1))|(0<<0);
		sdoutOutp32(rSDO_CCCON, uRegVal);	
//		sdoutOutp32(rSDO_CCCON, (Inp32(rSDO_CCCON)&~(1<<0))|(0<<0));
	}

}

//////////
// Function Name 	: 	TVENC_Ctrl525Porch
// Description		:	
// Input 			:	uBackPorch :0~0x3FF
//					uFrontPorch :0~0x3FF
void TVENC_Ctrl525Porch(u32 uBackPorch, u32 uFrontPorch)
{
	sdoutOutp32(rSDO_CSC_525_PORCH,  (uBackPorch<<16 | uFrontPorch<<0));
}

//////////
// Function Name 	: 	TVENC_Ctrl625Porch
// Description		:	
// Input 			:	uBackPorch :0~0x3FF
//					uFrontPorch :0~0x3FF
void TVENC_Ctrl625Porch(u32 uBackPorch, u32 uFrontPorch)
{
	sdoutOutp32(rSDO_CSC_625_PORCH,  (uBackPorch<<16 | uFrontPorch<<0));
}

//////////
// Function Name 	: 	TVENC_CtrlVesaRgbSync
// Description		:	
// Input 			:	eSyncType : SDOUT_SYNC_COMPOSITE, SDOUT_SYNC_SEPARATE
//					eVSYNC :SDOUT_SYNC_LOW,SDOUT_SYNC_HIGH
//					eHSYNC :SDOUT_SYNC_LOW,SDOUT_SYNC_HIGH
void TVENC_CtrlVesaRgbSync(SDOUT_VESA_SYNC eSyncType, SDOUT_SYNC_POLARITY eVSYNC, SDOUT_SYNC_POLARITY eHSYNC)
{
	sdoutOutp32(rSDO_RGBSYNC,  (eSyncType<<8 | eVSYNC<<4 | eHSYNC<<0));
}

//////////
// Function Name 	: 	TVENC_Ctrl625Porch
// Description		:	
// Input 			:	eDAC : 
//					uCoef2 :SDOUT_SYNC_LOW,SDOUT_SYNC_HIGH
//					uCoef1 :SDOUT_SYNC_LOW,SDOUT_SYNC_HIGH
void TVENC_SetXtalkCoef(SDOUT_DAC eDAC, u32 uCoef2, u32 uCoef1)
{
	switch(eDAC)
	{
		case DAC0:
			sdoutOutp32(rSDO_XTALK0, (uCoef2<<16|uCoef1<<0));
			break;
		case DAC1:
			sdoutOutp32(rSDO_XTALK1, (uCoef2<<16|uCoef1<<0));
			break;			
		case DAC2:
			sdoutOutp32(rSDO_XTALK2, (uCoef2<<16|uCoef1<<0));
			break;	
		case DAC_ALL:
			sdoutOutp32(rSDO_XTALK0, (uCoef2<<16|uCoef1<<0));
			sdoutOutp32(rSDO_XTALK1, (uCoef2<<16|uCoef1<<0));
			sdoutOutp32(rSDO_XTALK2, (uCoef2<<16|uCoef1<<0));	
			break;			
	}
}

//////////
// Function Name 	: 	TVENC_DisBBMode
// Description		:	
// Input 			:	
void TVENC_DisBBMode(void)
{
	sdoutOutp32(rSDO_BB_CTRL,  0x0);
}


//////////
// Function Name 	: 	TVENC_SetBBMode
// Description		:	
// Input 			:	
void TVENC_EnBBMode(SDOUT_DAC eDAC, u32 uBBLvl)
{
	u32 uRegVal;
	sdoutInp32(rSDO_CONFIG, uRegVal);
	uRegVal =  (uRegVal&~(0xff<<6));
	//sdoutOutp32(rSDO_CONFIG,  (Inp32(rSDO_CONFIG)&~(0xff<<6)));		// All of the DAC set to "0" (CVBS)
	sdoutOutp32(rSDO_CONFIG,  uRegVal);	
	switch(eDAC)
	{
		case DAC0:
			sdoutOutp32(rSDO_BB_CTRL, (uBBLvl<<8|0<<4|1<<0));
			break;
		case DAC1:
			sdoutOutp32(rSDO_BB_CTRL, (uBBLvl<<8|1<<4|1<<0));
			break;			
		case DAC2:
			sdoutOutp32(rSDO_BB_CTRL, (uBBLvl<<8|2<<4|1<<0));
			break;	
	}

}

void __irq Isr_TVENC(void)
{
	u32 uRegVal;

	//uRegVal = Inp32(rSDO_FINFO);
	sdoutInp32(rSDO_FINFO, uRegVal);
	
	UART_Printf("VSYNC: %d %x\n",g_TVENC, uRegVal);
	g_TVENC++;
	TVENC_ClearIntPending();
	
	INTC_ClearVectAddr();
}


SD_FieldId TVENC_GetFieldId( void )
{
	u32 uRegVal;

	sdoutInp32(rSDO_FINFO,uRegVal);

	if (  uRegVal & 0x02 )
	{
		return (SDOUT_BOTTOM);
	}
	else
	{
		return (SDOUT_TOP);
	}
}

void TVENC_SetCCData(u32 udata)
{
	sdoutOutp32(rSDO_ARMCC, udata);		// bit7 -> Odd parrity

}

u32 TVENC_ShadowSFRVerify(void)
{
	u32 uRegValue[5], uShdowVal[5], i;	

	
	sdoutInp32(rSDO_ARMCC, uRegValue[0]);
	sdoutInp32(rSDO_ARMWSS525, uRegValue[1]);
	sdoutInp32(rSDO_ARMWSS625, uRegValue[2]);
	sdoutInp32(rSDO_ARMCGMS525, uRegValue[3]);
	sdoutInp32(rSDO_ARMCGMS625, uRegValue[4]);

	sdoutInp32(rSDO_CC, uShdowVal[0]);
	sdoutInp32(rSDO_WSS525, uShdowVal[1]);
	sdoutInp32(rSDO_WSS625, uShdowVal[2]);
	sdoutInp32(rSDO_CGMS525, uShdowVal[3]);
	sdoutInp32(rSDO_CGMS625, uShdowVal[4]);
	
	for(i=0; i<5; i++)
	{		

		if(uRegValue[i] == uShdowVal[i])
		{
			return true;
		}
		else 
		{
			UART_Printf("\n%d: ARM 0x%08X, Shadow 0x%08X", i,uRegValue[i],uShdowVal[i]);	
			return false;
		}			
	}
	
}

