#ifndef __MIXER_H__
#define __MIXER_H__

#ifdef __cplusplus
extern "C" {
#endif

#define 	MX_VIDEO_LAY		(0)
#define	MX_GRP_LAY0		(1)
#define	MX_GRP_LAY1		(2)

#define 	MX_ENDIAN_LITTLE	(0)
#define 	MX_ENDIAN_BIG		(1)

typedef enum 
{ 
	// VD : video W0:Win0, W1:Win1, DN:Down
	DN_VDW0W1_UP 	= (MX_VIDEO_LAY<<8)|(MX_GRP_LAY0<<4)|(MX_GRP_LAY1<<0),
	DN_VDW1W0_UP 	= (MX_VIDEO_LAY<<8)|(MX_GRP_LAY1<<4)|(MX_GRP_LAY0<<0),
	DN_W1VDW0_UP 	= (MX_GRP_LAY1<<8)|(MX_VIDEO_LAY<<4)|(MX_GRP_LAY0<<0),
	DN_W1W0VD_UP 	= (MX_GRP_LAY1<<8)|(MX_GRP_LAY0<<4)|(MX_VIDEO_LAY<<0),
	DN_W0W1VD_UP 	= (MX_GRP_LAY0<<8)|(MX_GRP_LAY1<<4)|(MX_VIDEO_LAY<<0),
	DN_W0VDW1_UP 	= (MX_GRP_LAY0<<8)|(MX_VIDEO_LAY<<4)|(MX_GRP_LAY1<<0)
}MIXER_WIN_ORDER;

typedef enum 
{
	DN_WOW1_UP, DN_W1W0_UP
}MIXER_GRPH_WIN_ORDER;

typedef enum 
{
	MX_WIN0=0, MX_WIN1=1
}MIXER_GRPH_WIN;

typedef enum 
{
	MX_NO_BLEND, 
	MX_PER_PLANE, 
	MX_PER_PIX, 
	MX_PER_PMUL_PIX, 
	MX_PER_PLANE_PIX, 
	MX_PER_PLANE_PIX_PMUL
}MX_BLD_TYPE;

typedef enum 
{
	MX_VERTICAL, MX_HORIZONTAL
}MX_GRADIENT_TYPE;

typedef enum 
{
	RGB_TO_YUV601_LR, RGB_TO_YUV601_FR, RGB_TO_YUV709_LR, RGB_TO_YUV709_FR
}MX_CSC_TYPE;

typedef enum
{
	RGB601_0_255,
	RGB601_16_235,
	RGB709_0_255,
	RGB709_16_235
}MX_RGB_FORMAT;

typedef enum
{
	MX_YUV444,
	MX_RGB888
}MX_RGB_OUT_TYPE;

typedef enum 
{
	// 090224 modifed by rb1004.....Register Bit Position
	VP_UNDERRUN = 10,
	GRP0_UNDERRUN = 8,
	GRP1_UNDERRUN = 9,
	LINEBUF_UNDERRUN = 0
}MX_INTR_SRC;

typedef enum
{
	TV_OUT,
	HDMI_OUT
}MX_OUTSEL;

typedef enum
{
	SCALE_X1=0,
	SCALE_X2=1,
	SCALE_X4=2,
	SCALE_X8=3
}MX_SCALE_RATIO;

typedef struct __MIXER_SOURCE_ARGUMENTS
{
	u32 uImgHsz;
	u32 uSrcHsz;
	u32 uSrcVsz;
	u32 uSrcXPos;
	u32 uSrcYPos;
	u32 uFbStAddr;

	IMG_FMT eBpp;
}oMX_Source;

typedef struct __MIXER_DESTINATION_ARGUMENTS
{
	u32 uDstXPos;
	u32 uDstYPos;
	u32 uOutSel;
}oMX_Destination;

void MIXER_InitIP(IMG_RESOLUTION eImgSz, SCAN_MODE eScanMode, TV_STANDARDS eStrd, MX_OUTSEL eOutSel);
void MIXER_InitForATv(IMG_RESOLUTION eImgSz, SCAN_MODE eScanMode, TV_STANDARDS eStrd);
void MIXER_InitForDTv(IMG_RESOLUTION eImgSz, SCAN_MODE eScanMode, MX_RGB_FORMAT eMxCscInRgb);

void MIXER_StartProcessing(void);
void MIXER_StopProcessing(void);
void MIXER_SetOrder(MIXER_WIN_ORDER eOrder);
void MIXER_SetBgColor(u32 uColor1, u32 uColor2, u32 uColor3);

// Grph. win. func.
void MIXER_InitGrphWin(MIXER_GRPH_WIN eWin, oMX_Source oSrcArgs, oMX_Destination oDstArgs);
void MIXER_InitAndSetGrphWinOn(MIXER_GRPH_WIN eWin, oMX_Source oSrcArgs, oMX_Destination oDstArgs);

void MIXER_SetGrphWinOnOff(MIXER_GRPH_WIN eWin, u32 uOnOff);
void MIXER_SetAllGrphWinsOnOff(u32 uOnOff);
void MIXER_SetPerPixelBlendingOnOff(MIXER_GRPH_WIN eWin, u32 uOnOff);
void MIXER_SetPerPreMul_PixelBlendingOnOff(MIXER_GRPH_WIN eWin, u32 uOnOff);
void MIXER_SetPerPlaneBlendingOnOff(MIXER_GRPH_WIN eWin, u8 ucAlphaVal, u32 uOnOff);
void MIXER_SetColorKeyOnOff(MIXER_GRPH_WIN eWin, u32 uColorKeyVal, u32 uOnOff);

// Video win. func.
void MIXER_SetVdWinOnOff(u32 uOnOff);
void MIXER_SetVdBlendingOnOff(u8 ucAlphaVal, u32 uOnOff);

void MIXER_SetPosition(MIXER_GRPH_WIN eWin, u32 uDstXPos, u32 uDstYPos);
void MIXER_SetCropping(MIXER_GRPH_WIN eWin, u32 uSrcXPos, u32 uSrcYPos, u32 uCroppedHsz, u32 uCroppedVsz, u32 uDstXPos, u32 uDstYPos);
void MIXER_SetCscVal(MX_CSC_TYPE eMxCscType);

void MIXER_GetIntrSrc(MX_INTR_SRC* eIntStat);
void MIXER_ClearPending(void);
void MIXER_SetVideoLimiterOnOff(u32 uY_Upper, u32 uY_Lower, u32 uC_Upper, u32 uC_Lower, u32 uOnOff);
void MIXER_SetScalingRatio(MIXER_GRPH_WIN eWin, MX_SCALE_RATIO eScale_H, MX_SCALE_RATIO eScale_V);
void MIXER_SetRGBColorFormat(MX_RGB_OUT_TYPE eRGBOut, MX_RGB_FORMAT eRGBOutFormat);
void MIXER_SetEndianMode(u32 uEndian);

#ifdef __cplusplus
}
#endif

#endif
