/**
 * File Name : hdmi_test.c
 *
 * File Description :
 * This file implements to test the hdmi v1.3 in S5PV210 project
 *
 * Author : Hee Myung Noh
 * Dept : AP Development
 * Created Date : 2009/01/22
 * Version : 0.1
 * History 
 *  - Initiate version (Hee Myung Noh 090122)
 */
 #include <string.h>
  
#include "system.h"
#include "library.h"
#include "def.h"
#include "util.h"
#include "mixer.h"
#include "vp_v210.h"
#include "fimc.h"
#include "timer.h"
#include "glib.h"
#include "intc.h"
#include "hdmi.h"
#include "phy.h"
#include "hpd.h"
#include "hdcp.h"
#include "i2c_hdmi.h"
#include "edid.h"
#include "tvout_common.h"
#include "cec.h"
#include "wavefile.h"
#include "spdif.h"
//#include "i2s.h"
#include "hdmi_audio.h"
#include "i2s_hdmi.h"
#include "spdif.h"
#include "sysc.h"
#include "sblock.h"
#include "Morex_types.h"
 
typedef struct AutoTest_Param
{
	u32 uInput; 
	u8 	*desc;
} oAutoTest_Param;

//I2S
static I2S oI2s0, oI2s0;
static I2S_FORMAT eSerialDataFmt;
static u32 uCdclk=24576000;

static SCAN_MODE eScanMode;
static IMG_RESOLUTION eImgSz;

static u32 uPcmSize;

extern oVP_Source 		oVP_SrcInf;
extern oVP_Destination 		oVP_DstInf;
extern oMX_Source		oMx_SrcInf[2];
extern oMX_Destination		oMx_DstInf[2];

extern void FIMC_CSC_Scaling_Temp(u32 srcAddr,u32 dstAddr,
	u32 srcFullWidth,u32 srcFullHeight,u32 dstFullWidth,u32 dstFullHeight,
	IMG_FMT srcColor, IMG_FMT dstColor);


void FIMC_CSC_Scaling_ForHD(u32 srcAddr,u32 dstAddr,
	u32 srcFullWidth,u32 srcFullHeight,u32 dstFullWidth,u32 dstFullHeight,
	IMG_FMT srcColor, IMG_FMT dstColor,
	MX_RGB_FORMAT eMxOutRgb)
{
	CSC_EQUATION eCscEq;
	YCBCR_RANGE eYuvRange;
	IMG_FMT	eSrcImgType_Temp;
	
	if(eMxOutRgb == RGB601_0_255)
	{
		eCscEq = CSC_ITU601;
		eYuvRange = YCBCR_WIDE;
	}
	else if(eMxOutRgb == RGB601_16_235)
	{
		eCscEq = CSC_ITU601;
		eYuvRange = YCBCR_NARROW;
	}
	else if(eMxOutRgb == RGB709_0_255)
	{
		eCscEq = CSC_ITU709;
		eYuvRange = YCBCR_WIDE;
	}
	else if(eMxOutRgb == RGB709_16_235)
	{
		eCscEq = CSC_ITU709;
		eYuvRange = YCBCR_NARROW;
	}
	else
	{}

#if 0
	eSrcImgType_Temp = dstColor;
   	if(dstColor == NV12_IW || dstColor == NV12_IB)
		eSrcImgType_Temp = NV12;
	else if(dstColor == TILE_NV12_IW || dstColor == TILE_NV12_IB)
		eSrcImgType_Temp = TILE_NV12;
#else
	eSrcImgType_Temp = dstColor;
   	if(dstColor == NV12_IW)
		eSrcImgType_Temp = NV12;
	else if(dstColor == TILE_NV12_IW)
		eSrcImgType_Temp = TILE_NV12;
#endif	
	else
	{}

	FIMC_ColorSpaceConversion(	srcAddr, dstAddr,
								srcFullWidth, srcFullHeight, dstFullWidth, dstFullHeight,
								srcColor, eSrcImgType_Temp, eCscEq, eYuvRange);		
}
 
 
void FIMC_RunWith_CSC_YUVRange(MX_RGB_FORMAT eMxOutRgb)
{
	CSC_EQUATION eCscEq;
	YCBCR_RANGE eYuvRange;
	
	if(eMxOutRgb == RGB601_0_255)
	{
		eCscEq = CSC_ITU601;
		eYuvRange = YCBCR_WIDE;
	}
	else if(eMxOutRgb == RGB601_16_235)
	{
		eCscEq = CSC_ITU601;
		eYuvRange = YCBCR_NARROW;
	}
	else if(eMxOutRgb == RGB709_0_255)
	{
		eCscEq = CSC_ITU709;
		eYuvRange = YCBCR_WIDE;
	}
	else if(eMxOutRgb == RGB709_16_235)
	{
		eCscEq = CSC_ITU709;
		eYuvRange = YCBCR_NARROW;
	}
	else
	{}
	
	FIMC_CSC_YUVRange(eCscEq, eYuvRange);		
}


void InitSysconForHD(void)
{

	SYSC_SetBlockPowerOFF_IP(eHDTV);
	SYSC_SetClkOFF_IP(eVP);
	SYSC_SetClkOFF_IP(eMIXER);
	SYSC_SetClkOFF_IP(eHDMI);
	
	DelayfrTimer(milli, 200);

	SYSC_SetClkON_IP(eVP);
	SYSC_SetClkON_IP(eMIXER);
	SYSC_SetClkON_IP(eHDMI);	
	SYSC_SetBlockPowerON_IP(eHDTV);
	
	SYSC_SetDivHDMI(0x96);
	SYSC_EnHDMIPHY();
}


void HDVPT_InitParaForTV(IMG_FMT eImgType)
{
	u32 uImgSize_H, uImgSize_V;

	if(eImgSz == HD720)
	{
		uImgSize_H = HD720_HSIZE;
		uImgSize_V = HD720_VSIZE;
	}
	else if(eImgSz == HD1080)
	{
		uImgSize_H = HD1080_HSIZE;
		uImgSize_V = HD1080_VSIZE;
	}
	else if(eImgSz == SD480)
	{
		uImgSize_H = SD480_HSIZE;
		uImgSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		uImgSize_H = SD576_HSIZE;
		uImgSize_V = SD576_VSIZE;
	}
	else
		Assert(0);
		
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eImgType;
	oVP_SrcInf.uImgHsz = uImgSize_H;
	oVP_SrcInf.uImgVsz = uImgSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uImgSize_H;
	oVP_SrcInf.uSrcVsz=uImgSize_V;
	oVP_SrcInf.uSrcNumOfFrm = 1;
	oVP_SrcInf.eStep = STEP0;

	oVP_DstInf.eScanMode = eScanMode;
	oVP_DstInf.uOrgDstHsz = uImgSize_H;
	oVP_DstInf.uOrgDstVsz = uImgSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImgSize_H;
	oVP_DstInf.uDstVsz = uImgSize_V;	
	oVP_DstInf.eImgSz = eImgSz;
}


void HDMXT_InitParaForTV(void)
{
	u32 i;

	for(i=0 ; i<2 ; i++)
	{
		oMx_SrcInf[i].eBpp = RGB16;
		oMx_SrcInf[i].uImgHsz = HD720_HSIZE;
		oMx_SrcInf[i].uSrcXPos = 0;
		oMx_SrcInf[i].uSrcYPos = 0;
		oMx_SrcInf[i].uSrcHsz = HD720_HSIZE;
		oMx_SrcInf[i].uSrcVsz = HD720_VSIZE;

		oMx_DstInf[i].uDstXPos = 0;
		oMx_DstInf[i].uDstYPos = 0;
		oMx_DstInf[i].uOutSel = 0;
	}
}

static void HDVpMx_VPSettingForTest(u32 uVpSrcAddr, IMG_FMT eImgType)
{
	HDVPT_InitParaForTV(eImgType);

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
///	VP_EnableIP(1);
}


static void HDVpMx_MixerSettingForTest(u32 uWin0StAddr, u32 uWin1StAddr, IMG_FMT eSrcImgType)
{
	HDMXT_InitParaForTV();

	// Mixer setting
	UART_Printf("Video Layer Displayed\n");
	
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
	
	UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
///	oMx_DstInf[0].uDstXPos = 0;
///	oMx_DstInf[0].uDstYPos = 0;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);

	MIXER_SetVideoLimiterOnOff(0xeb, 0x10, 0xf0, 0x10, 1);
	MIXER_SetRGBColorFormat(MX_YUV444, RGB709_16_235);
}


static void HDVpMx_DownImageForVP(	IMG_RESOLUTION eImageSize, u32 uBMPSrcAddr, u32 uRGBSrcAddr, u32 uVpSrcAddr,
											IMG_FMT eSrcImgType, u32 *uImageSize_H, u32 *uImageSize_V, MX_RGB_FORMAT eMxOutRgb)
{
	oDownImage_Inform 	oDownImg;
	
	if(eImageSize == HD720)
	{
		oDownImg.eImageSize = BMP_1280x720;
		oDownImg.pImagePath = pTest_Image[BMP_1280x720];
		*uImageSize_H = HD720_HSIZE;
		*uImageSize_V = HD720_VSIZE;
	}
	else if(eImageSize == HD1080)
	{
		oDownImg.eImageSize = BMP_1920x1080;
		oDownImg.pImagePath = pTest_Image[BMP_1920x1080];
		*uImageSize_H = HD1080_HSIZE;
		*uImageSize_V = HD1080_VSIZE;		
	}
	else if(eImageSize == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		*uImageSize_H = SD480_HSIZE;
		*uImageSize_V = SD480_VSIZE;		
	}
	else if(eImageSize == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		*uImageSize_H = SD576_HSIZE;
		*uImageSize_V = SD576_VSIZE;		
	}	
	else
	{
		UART_Printf("Not supported image size..\n");
		Assert(0);
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	{
		s32 sFail;
		u32 uFileReadSize;
		t_file_handler oFileHandler;
		
		sFail = FS_Open(oDownImg.pImagePath, &oFileHandler);
		if(sFail != 0)
		{
			UART_Printf("%s open fail\n", oDownImg.pImagePath);
			return;
		}
	else
			UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		
		//(void *)uBMPSrcAddr = malloc(oFileHandler.nSize);	
		FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uBMPSrcAddr, &uFileReadSize);	
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, *uImageSize_H, *uImageSize_V);
		
		FIMC_CSC_Scaling_ForHD(uRGBSrcAddr, uVpSrcAddr, *uImageSize_H,*uImageSize_V,*uImageSize_H,*uImageSize_V,
								RGB888, eSrcImgType, eMxOutRgb);		
		//free(uBMPSrcAddr);
	}

#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, *uImageSize_H, *uImageSize_V);

		FIMC_CSC_Scaling_ForHD(uRGBSrcAddr, uVpSrcAddr, *uImageSize_H,*uImageSize_V,*uImageSize_H,*uImageSize_V,
								RGB888, eSrcImgType, eMxOutRgb);
	}
	else
	{
		UART_Printf("Fail to load image\n");	
		Assert(0);
	}
#endif	
}


static void HDVpMx_CalcImageSize(IMG_RESOLUTION eImageSize, u32 *uImageSize_H, u32 *uImageSize_V)
{
	
	if(eImageSize == HD720)
	{
		*uImageSize_H = HD720_HSIZE;
		*uImageSize_V = HD720_VSIZE;
	}
	else if(eImageSize == HD1080)
	{
		*uImageSize_H = HD1080_HSIZE;
		*uImageSize_V = HD1080_VSIZE;		
	}
	else if(eImageSize == SD480)
	{
		*uImageSize_H = SD480_HSIZE;
		*uImageSize_V = SD480_VSIZE;		
	}
	else if(eImageSize == SD576)
	{
		*uImageSize_H = SD576_HSIZE;
		*uImageSize_V = SD576_VSIZE;		
	}	
	else
	{
		UART_Printf("Not supported image size..\n");
		Assert(0);
	}
}


static void HDVpMx_DrawGraphicForMixer(u32 uWin0StAddr, u32 uWin1StAddr, IMG_FMT eSrcImgType)
{
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	//GLIB_DrawPattern_Blue(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_InitFont();
	GLIB_Printf(90,160, "Window 0");
	
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_Printf(90,160, "Window 1");
}


static void HDVp_ChangeImageEndianMode(oVP_Source oVp_Src)
{
	u32 i, j, uYSize, uCSize;
	u8 pBuffer[8];
	u8 *pSrcBuf;
	
	VP_CalcImageSize(oVp_Src, &uYSize, &uCSize);
	pSrcBuf = (u8 *)oVp_Src.uSrcStAddr;
	
	for(i=0 ; i<uYSize+uCSize ; i+=8)
	{
		for(j=0 ; j<8 ; j++)
			pBuffer[j] =  *(pSrcBuf+j);
		for(j=0 ; j<8 ; j++)
			*(pSrcBuf+j) = pBuffer[7-j];
		pSrcBuf += 8;		
	}
}


static void HDMx_ChangeImageEndianMode(oMX_Source oMx_SrcInf)
{
	u32 i, j;
	u16 pBuffer16[4];
	u32 pBuffer32[2];
	u16 *pSrcBuf16;
	u32 *pSrcBuf32;

	if(oMx_SrcInf.eBpp == ARGB8888)
	{
		pSrcBuf32 = (u32 *)oMx_SrcInf.uFbStAddr;
		for(i=0 ; i<(oMx_SrcInf.uSrcHsz*oMx_SrcInf.uSrcVsz*4) ; i+=8)
		{
			for(j=0 ; j<2 ; j++)
				pBuffer32[j] =  *(pSrcBuf32+j);
			for(j=0 ; j<2 ; j++)
				*(pSrcBuf32+j) = pBuffer32[1-j];
			pSrcBuf32 += 2;		
		}
	}
	else if( (oMx_SrcInf.eBpp == ARGB4444) || (oMx_SrcInf.eBpp == ARGB1555) ||  (oMx_SrcInf.eBpp == RGB565) )
	{
		pSrcBuf16 = (u16 *)oMx_SrcInf.uFbStAddr;
		for(i=0 ; i<(oMx_SrcInf.uSrcHsz*oMx_SrcInf.uSrcVsz*2) ; i+=8)
		{
			for(j=0 ; j<4 ; j++)
				pBuffer16[j] =  *(pSrcBuf16+j);
			for(j=0 ; j<4 ; j++)
				*(pSrcBuf16+j) = pBuffer16[3-j];
			pSrcBuf16 += 4;		
		}
	}
	else
	{
		Assert(0);
	}
}


u32 HDMXT_SimpleDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDMXT_SimpleDisplay]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 		1 : ARGB1555,		2 : ARGB4444,		3 : ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>3)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : ARGB8888;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( (eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)||(eSrcImgType==ARGB8888) );
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
	{
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	}
	
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_InitFont();
		GLIB_Printf(90,160, "Window 0");
	}
	else
		GLIB_DrawPattern_Alpha(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_Printf(90,160, "Window 1");
	}
	else
		GLIB_DrawPattern_Alpha(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	
//	HDVpMx_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr, eSrcImgType);
	
	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
	//Mixer Setting
	HDVpMx_MixerSettingForTest(uWin0StAddr, uWin1StAddr, eSrcImgType);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	UART_Getc();

	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);

	return 1;
}


void HDMXT_PerPlaneBlending(void)
{
	u32 i;

	UART_Printf("[HDMXT_PerPlaneBlending]\n");	
	
	UART_Printf("Video Layer Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 50);
	}	
	INPUT_DELAY;	
	MIXER_SetVdBlendingOnOff(0, 0);
	UART_Printf("\n\n");	

	UART_Printf("Graphic Layer 0 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	UART_Printf("\n\n");

	UART_Printf("Graphic Layer 1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	UART_Printf("\n\n");

	UART_Printf("Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	UART_Printf("\n\n");	
}


void HDMXT_PerPixelBlending(void)
{
	UART_Printf("[HDMXT_PerPixelBlending]\n");	

	UART_Printf("Graphic Layer 0 Pixel Blending\n");	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 1 Pixel Blending\n");	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 0/1 Pixel Blending\n");	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	
}


void HDMXT_PerPixelAndPremulBlending(void)
{
	UART_Printf("[HDMXT_PerPixelAndPremulBlending]\n");	

	UART_Printf("Graphic Layer 0 Pixel Blending\n");	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 1 Pixel Blending\n");	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 0/1 Pixel Blending\n");	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	DelayfrTimer(milli, 2000);
	INPUT_DELAY;
	
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	
}


void HDMXT_PerPlaneAndPixelBlending(void)
{
	u32 i;
	
	UART_Printf("[HDMXT_PerPlaneAndPixelBlending]\n");	
	
	UART_Printf("Video Layer Alpha Value : (0~255)\n");	
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}	
	INPUT_DELAY;		
	MIXER_SetVdBlendingOnOff(0, 0);
	UART_Printf("\n");	

	UART_Printf("Graphic Layer 0 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 1 Alpha Value : (0~255)\n");	
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");


	UART_Printf("Video & Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetVdBlendingOnOff(0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	
}


void HDMXT_PerPlaneAndPixelAndPremulBlending(void)
{
	u32 i;
	
	UART_Printf("[HDMXT_PerPlaneAndPixelAndPremulBlending]\n");	

	UART_Printf("Video Layer Alpha Value : (0~255)\n");	
	UART_Printf("Alpha Value : ");
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		UART_Printf("%d ", i);		
		DelayfrTimer(milli, 50);
	}	
	INPUT_DELAY;		
	MIXER_SetVdBlendingOnOff(0, 0);
	UART_Printf("\n");	

	UART_Printf("Graphic Layer 0 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");

	UART_Printf("Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	

	UART_Printf("Video Layer & Graphic Layer 0/1 Alpha Value : (0~255)\n");
	UART_Printf("Alpha Value : ");
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 1);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 1);
	for(i=0; i<=0xff; i+=2)
	{
		MIXER_SetVdBlendingOnOff(i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, i, 1);
		MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, i, 1);
		UART_Printf("%d ", i);	
		DelayfrTimer(milli, 50);
	}
	INPUT_DELAY;		
	MIXER_SetVdBlendingOnOff(i, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN0, 0, 0);
	MIXER_SetPerPlaneBlendingOnOff(MX_WIN1, 0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN0, 0);
	MIXER_SetPerPreMul_PixelBlendingOnOff(MX_WIN1, 0);
	UART_Printf("\n");	
}


// Return		: 	1 - Condition is matched
//					0 - Condition is not matched
u32 HDMXT_CheckBlendingCondition(IMG_FMT eImgFmt, MX_BLD_TYPE eBlendType)
{
	if(eImgFmt == RGB16)
	{
		if(eBlendType == MX_PER_PLANE)
			return 1;
	}
	else if((eImgFmt == ARGB1555)||(eImgFmt == ARGB4444)||(eImgFmt == ARGB8888))
	{
		if((eBlendType == MX_PER_PLANE)||(eBlendType == MX_PER_PIX)||(eBlendType == MX_PER_PLANE_PIX))
			return 1;
	}
	else if(eImgFmt == PRE_ARGB8888)
	{
		if((eBlendType == MX_PER_PMUL_PIX)||(eBlendType == MX_PER_PLANE_PIX_PMUL))
			return 1;
	}
	else
	{}

	UART_Printf(">>Image Format is not matched with the blending Type\n");
	return 0;
}


u32 HDMXT_Blending(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp, uLayOrd_Temp, uBlend_Temp;
	IMG_FMT eSrcImgType;
	MIXER_WIN_ORDER eLayOrder;
	MX_BLD_TYPE eBlendType;

	UART_Printf("[HDMXT_Blending]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 	1 : ARGB1555,	2 : ARGB4444,	3 : ARGB8888, 	4 : PRE_ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>4)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : 
						(uSrcImgType_Temp == 3)? ARGB8888 : PRE_ARGB8888;

		UART_Printf("Select the Layer order\n");
		UART_Printf("0 : VDW0W1(D), 		1 : VDW1W0,		2 : W0VDW1,		3 : W0W1VD\n");
		UART_Printf("4 : W1VDW0, 		5 : W1W0VD\n");
		uLayOrd_Temp = UART_GetIntNum();
		if(uLayOrd_Temp>5)
			uLayOrd_Temp = 0;

		eLayOrder = 		(uLayOrd_Temp  == 0)? DN_VDW0W1_UP :
						(uLayOrd_Temp  == 1)? DN_VDW1W0_UP :
						(uLayOrd_Temp  == 2)? DN_W0VDW1_UP :
						(uLayOrd_Temp  == 3)? DN_W0W1VD_UP :
						(uLayOrd_Temp  == 4)? DN_W1VDW0_UP : DN_W1W0VD_UP;

		UART_Printf("Select the Blending Type\n");
		UART_Printf("0 : Per plane(D), 		1 : Per pixel,		2 : Per premul+pixel\n");
		UART_Printf("3 : Per plane+pixel,		4 : Per plane+pixel+premul\n");
		uBlend_Temp = UART_GetIntNum();
		if(uBlend_Temp>4)
			uBlend_Temp = 0;

		eBlendType = 	(uBlend_Temp  == 0)? MX_PER_PLANE :
						(uBlend_Temp  == 1)? MX_PER_PIX :
						(uBlend_Temp  == 2)? MX_PER_PMUL_PIX :
						(uBlend_Temp  == 3)? MX_PER_PLANE_PIX : MX_PER_PLANE_PIX_PMUL;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		eLayOrder = (MIXER_WIN_ORDER)oPara.Test_Parameter[1];
		eBlendType = (MX_BLD_TYPE)oPara.Test_Parameter[2];
		Assert( 	(eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)
				||(eSrcImgType==ARGB8888)||(eSrcImgType==PRE_ARGB8888) 	);
	}

	//Check the Blending condition
	if(!HDMXT_CheckBlendingCondition(eSrcImgType, eBlendType))
		return 1;
		
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	if(eTest == eTest_Manual)
	{
		UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
		if(UART_Getc() == 'y')
			HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	}
	else
	{
		if(oPara.Test_Parameter[3] == 1)
			HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	}
	
	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
	
	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_InitFont();
		GLIB_Printf(90,160, "Window 0");
	}
	else
		GLIB_DrawPattern_Alpha(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_Printf(90,160, "Window 1");
	}
	else
		GLIB_DrawPattern_Alpha(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);

	//Mixer Setting
	HDVpMx_MixerSettingForTest(uWin0StAddr, uWin1StAddr, eSrcImgType);
	MIXER_SetOrder(eLayOrder);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	//Blending Test
	switch (eBlendType)
	{
		case	MX_PER_PLANE			:	HDMXT_PerPlaneBlending();
											break;
		case	MX_PER_PIX				:	HDMXT_PerPixelBlending();
											break;
		case	MX_PER_PMUL_PIX			:	HDMXT_PerPixelAndPremulBlending();
											break;
		case	MX_PER_PLANE_PIX		:	HDMXT_PerPlaneAndPixelBlending();
											break;
		case	MX_PER_PLANE_PIX_PMUL	:	HDMXT_PerPlaneAndPixelAndPremulBlending();
											break;
		default							: 	break;
	}	

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDMXT_Cropping(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXSize, uSrcYSize;
	u32 uWinTemp, uTempKey;
	MIXER_GRPH_WIN uWindow;

	UART_Printf("[HDMXT_Cropping]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Graphic Window to test\n");
		UART_Printf("0 : WIN0(D), 		1 : WIN1\n");
		uWinTemp = UART_GetIntNum();
		if(uWinTemp>1)
			uWinTemp = 0;

		uWindow = 	(uWinTemp == 0)? MX_WIN0 : MX_WIN1;
	}
	else
	{
		uWindow = (MIXER_GRPH_WIN)oPara.Test_Parameter[0];
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);
	
	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, uImageSize_H, uImageSize_V, RGB16);
	if(uWindow == MX_WIN0)
		GLIB_DrawPattern(uImageSize_H, uImageSize_V);
	else
		GLIB_DrawPattern2(uImageSize_H, uImageSize_V);
	
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
	
	UART_Printf("Graphic Layer %d is displayed\n", (u32)uWindow);
	oMx_SrcInf[uWindow].eBpp = RGB16;
	oMx_SrcInf[uWindow].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[uWindow].uImgHsz = uImageSize_H;
	oMx_SrcInf[uWindow].uSrcXPos = 0;
	oMx_SrcInf[uWindow].uSrcYPos = 0;
	oMx_SrcInf[uWindow].uSrcHsz = uImageSize_H;
	oMx_SrcInf[uWindow].uSrcVsz = uImageSize_V;

	oMx_DstInf[uWindow].uDstXPos = 0;
	oMx_DstInf[uWindow].uDstYPos = 0;
	
	MIXER_InitGrphWin(uWindow, oMx_SrcInf[uWindow], oMx_DstInf[uWindow]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(uWindow, 1);
	
	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	UART_Printf("Press 's' key to hold the test\n");
	UART_Printf("Press 'x' key to exit the test\n");
	for(uSrcXSize=VP_SRCSIZE_MIN_H ; uSrcXSize<=uImageSize_H ; uSrcXSize+=3)
	{
		for(uSrcYSize=VP_SRCSIZE_MIN_V ; uSrcYSize<=uImageSize_V ; uSrcYSize+=3)
		{
			MIXER_SetCropping(uWindow, 0, 0, uSrcXSize, uSrcYSize, 0, 0);

			UART_Printf("Cropped Source Size : (%d,%d)\n", uSrcXSize, uSrcYSize);

			//Waiting
			DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_SetVdWinOnOff(0);
				HDMI_Enable(FALSE);
				return 1;
			}
		}
	}

	UART_Getc();
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDMXT_SourceImgPositioning(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize;
	u32 uWinTemp, uTempKey;
	MIXER_GRPH_WIN uWindow;

	UART_Printf("[HDMXT_SourceImgPositioning]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Graphic Window to test\n");
		UART_Printf("0 : WIN0(D), 		1 : WIN1\n");
		uWinTemp = UART_GetIntNum();
		if(uWinTemp>1)
			uWinTemp = 0;

		uWindow = 	(uWinTemp == 0)? MX_WIN0 : MX_WIN1;
	}
	else
	{
		uWindow = (MIXER_GRPH_WIN)oPara.Test_Parameter[0];
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);

	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, uImageSize_H, uImageSize_V, RGB16);
	if(uWindow == MX_WIN0)
		GLIB_DrawPattern(uImageSize_H, uImageSize_V);
	else
		GLIB_DrawPattern2(uImageSize_H, uImageSize_V);
	
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
///	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer %d is displayed\n", (u32)uWindow);
	uSrcXSize = 200;
	uSrcYSize = 150;
	oMx_SrcInf[uWindow].eBpp = RGB16;
	oMx_SrcInf[uWindow].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[uWindow].uImgHsz = uImageSize_H;
	oMx_SrcInf[uWindow].uSrcXPos = 0;
	oMx_SrcInf[uWindow].uSrcYPos = 0;
	oMx_SrcInf[uWindow].uSrcHsz = uSrcXSize;
	oMx_SrcInf[uWindow].uSrcVsz = uSrcYSize;

	oMx_DstInf[uWindow].uDstXPos = 0;
	oMx_DstInf[uWindow].uDstYPos = 0;
	
	MIXER_InitGrphWin(uWindow, oMx_SrcInf[uWindow], oMx_DstInf[uWindow]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(uWindow, 1);
	
	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	for(uSrcXPos=VP_SRCSIZE_MIN_H ; uSrcXPos<=uImageSize_H-uSrcXSize ; uSrcXPos+=3)
	{
		for(uSrcYPos=VP_SRCSIZE_MIN_V ; uSrcYPos<=uImageSize_V-uSrcYSize ; uSrcYPos+=3)
		{
			MIXER_SetCropping(uWindow, uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize, 100, 100);

			UART_Printf("Source Position : (%d,%d),  Source Size : (%d, %d)\n", uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize);

			//Waiting
			DelayfrTimer(milli, 5);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_SetVdWinOnOff(0);
				HDMI_Enable(FALSE);
				return 1;
			}
		}
	}

	UART_Getc();
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDMXT_DestinationImgPositioning(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXSize, uSrcYSize;
	u32 uDstXPos, uDstYPos;
	u32 uWinTemp, uTempKey;
	MIXER_GRPH_WIN uWindow;

	UART_Printf("[HDMXT_DestinationImgPositioning]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Graphic Window to test\n");
		UART_Printf("0 : WIN0(D), 		1 : WIN1\n");
		uWinTemp = UART_GetIntNum();
		if(uWinTemp>1)
			uWinTemp = 0;

		uWindow = 	(uWinTemp == 0)? MX_WIN0 : MX_WIN1;
	}
	else
	{
		uWindow = (MIXER_GRPH_WIN)oPara.Test_Parameter[0];
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);
	
	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, uImageSize_H, uImageSize_V, RGB16);
	if(uWindow == MX_WIN0)
		GLIB_DrawPattern(uImageSize_H, uImageSize_V);
	else
		GLIB_DrawPattern2(uImageSize_H, uImageSize_V);
	
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
///	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer %d is displayed\n", (u32)uWindow);
	uSrcXSize = 200;
	uSrcYSize = 150;
	oMx_SrcInf[uWindow].eBpp = RGB16;
	oMx_SrcInf[uWindow].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[uWindow].uImgHsz = uImageSize_H;
	oMx_SrcInf[uWindow].uSrcXPos = 0;
	oMx_SrcInf[uWindow].uSrcYPos = 0;
	oMx_SrcInf[uWindow].uSrcHsz = uSrcXSize;
	oMx_SrcInf[uWindow].uSrcVsz = uSrcYSize;

	oMx_DstInf[uWindow].uDstXPos = 0;
	oMx_DstInf[uWindow].uDstYPos = 0;
	
	MIXER_InitGrphWin(uWindow, oMx_SrcInf[uWindow], oMx_DstInf[uWindow]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(uWindow, 1);
	
	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	for(uDstXPos=VP_SRCSIZE_MIN_H ; uDstXPos<=uImageSize_H-uSrcXSize ; uDstXPos+=3)
	{
		for(uDstYPos=VP_SRCSIZE_MIN_V ; uDstYPos<=uImageSize_V-uSrcYSize ; uDstYPos+=3)
		{
			MIXER_SetPosition(uWindow, uDstXPos, uDstYPos);

			UART_Printf("Destination Position : (%d,%d),  Source Size : (%d, %d)\n", uDstXPos, uDstYPos, uSrcXSize, uSrcYSize);

			//Waiting
			DelayfrTimer(milli, 5);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_SetVdWinOnOff(0);
				HDMI_Enable(FALSE);
				HDMI_TG_OnOff(FALSE);
				return 1;
			}
		}
	}

	UART_Getc();
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDMXT_ColorSpaceConversion(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;

	UART_Printf("[HDMXT_ColorSpaceConversion]\n");

	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);
	
	HDVpMx_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr, RGB16);
	
	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
	// Mixer Setting
	HDVpMx_MixerSettingForTest(uWin0StAddr, uWin1StAddr, RGB16);
	
	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	UART_Printf("Source RGB : Full range\n");
	while(!UART_GetKey())
	{
		MIXER_SetCscVal(RGB_TO_YUV601_FR);
		DelayfrTimer(milli, 1000);
		MIXER_SetCscVal(RGB_TO_YUV709_FR);
		DelayfrTimer(milli, 1000);
	}

	UART_Printf("Source RGB : Limited range\n");
	while(!UART_GetKey())
	{
		MIXER_SetCscVal(RGB_TO_YUV601_LR);
		DelayfrTimer(milli, 1000);
		MIXER_SetCscVal(RGB_TO_YUV709_LR);
		DelayfrTimer(milli, 1000);
	}
	
	// Waiting
	UART_Getc();

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDMXT_Scaling(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXSize, uSrcYSize;
	u32 i, j, uWinTemp;
	MIXER_GRPH_WIN uWindow;

	UART_Printf("[HDMXT_Scaling]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Graphic Window to test\n");
		UART_Printf("0 : WIN0(D), 		1 : WIN1\n");
		uWinTemp = UART_GetIntNum();
		if(uWinTemp>1)
			uWinTemp = 0;

		uWindow = 	(uWinTemp == 0)? MX_WIN0 : MX_WIN1;
	}
	else
	{
		uWindow = (MIXER_GRPH_WIN)oPara.Test_Parameter[0];
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);
	
	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);

	// Mixer setting
	uSrcXSize = uImageSize_H/8;
	if(uSrcXSize%8)
		uSrcXSize -= (uSrcXSize%8);
	uSrcYSize = uImageSize_V/8;
	if(uSrcYSize%8)
		uSrcYSize -= (uSrcYSize%8);	
	GLIB_InitInstance(uWin0StAddr, uSrcXSize, uSrcYSize, RGB16);
	if(uWindow == MX_WIN0)
		GLIB_DrawPattern(uSrcXSize, uSrcYSize);
	else
		GLIB_DrawPattern2(uSrcXSize, uSrcYSize);
	
	UART_Printf("Video Layer Displayed\n");
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
///	MIXER_StartProcessing();
	
	UART_Printf("Graphic Layer %d is displayed\n", (u32)uWindow);
	oMx_SrcInf[uWindow].eBpp = RGB16;
	oMx_SrcInf[uWindow].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[uWindow].uImgHsz = uSrcXSize;
	oMx_SrcInf[uWindow].uSrcXPos = 0;
	oMx_SrcInf[uWindow].uSrcYPos = 0;
	oMx_SrcInf[uWindow].uSrcHsz = uSrcXSize;
	oMx_SrcInf[uWindow].uSrcVsz = uSrcYSize;

	oMx_DstInf[uWindow].uDstXPos = 0;
	oMx_DstInf[uWindow].uDstYPos = 0;
	
	MIXER_InitGrphWin(uWindow, oMx_SrcInf[uWindow], oMx_DstInf[uWindow]);
	MIXER_SetOrder(DN_VDW0W1_UP);	
	MIXER_SetGrphWinOnOff(uWindow, 1);
	
	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	for(i=0 ; i<4 ; i++)
	{
		for(j=0 ; j<4 ; j++)
		{
			UART_Printf("Ratio : (X%d, X%d)\n", Pow(2, i), Pow(2, j));
			MIXER_SetScalingRatio(uWindow, (MX_SCALE_RATIO)(i), (MX_SCALE_RATIO)(j));
			UART_Getc();	
		}
	}
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDMXT_ColorKey(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V; 
	u32 uSrcImgType_Temp, uLayOrd_Temp;
	u32 aColorKey[2];
	IMG_FMT eSrcImgType;
	MIXER_WIN_ORDER eLayOrder;

	UART_Printf("[HDMXT_ColorKey]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 	1 : ARGB1555,	2 : ARGB4444,	3 : ARGB8888, 	4 : PRE_ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>4)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : 
						(uSrcImgType_Temp == 3)? ARGB8888 : PRE_ARGB8888;

		UART_Printf("Select the Layer order\n");
		UART_Printf("0 : VDW0W1(D), 		1 : VDW1W0,		2 : W0VDW1,		3 : W0W1VD\n");
		UART_Printf("4 : W1VDW0, 		5 : W0W1VD\n");
		uLayOrd_Temp = UART_GetIntNum();
		if(uLayOrd_Temp>5)
			uLayOrd_Temp = 0;

		eLayOrder = 		(uLayOrd_Temp  == 0)? DN_VDW0W1_UP :
						(uLayOrd_Temp  == 1)? DN_VDW1W0_UP :
						(uLayOrd_Temp  == 2)? DN_W0VDW1_UP :
						(uLayOrd_Temp  == 3)? DN_W0W1VD_UP :
						(uLayOrd_Temp  == 4)? DN_W1VDW0_UP : DN_W1W0VD_UP;


	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		eLayOrder = (MIXER_WIN_ORDER)oPara.Test_Parameter[1];
		Assert( (eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)||(eSrcImgType==ARGB8888) );
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	if(eTest == eTest_Manual)
	{
		UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
		if(UART_Getc() == 'y')
			HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	}
	else
	{
		if(oPara.Test_Parameter[2] == 1)
			HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	}
	
	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);

	// Mixer setting
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_InitFont();
		GLIB_Printf(90,160, "Window 0");
	}
	else
		GLIB_DrawPattern_Alpha2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);
	if(eSrcImgType == RGB16)
	{
		GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
		GLIB_Printf(90,160, "Window 1");
	}
	else
		GLIB_DrawPattern_Alpha2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, eSrcImgType);

	
	//UART_Printf("Video Layer Displayed\n");
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
	
	//UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = eSrcImgType;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(eLayOrder);	
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	//UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = eSrcImgType;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(eLayOrder);	
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);
	
	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	if(eSrcImgType == RGB16)
	{
		aColorKey[MX_WIN0] = 0xf800;		//Red
		aColorKey[MX_WIN1] = 0x07e0;		//Green
	}
	else if(eSrcImgType == ARGB1555)
	{
		//aColorKey[MX_WIN0] = 0x7c00;		//Red
		//aColorKey[MX_WIN1] = 0x03e0;		//Green
		aColorKey[MX_WIN0] = 0xfc00;		//A_Red
		aColorKey[MX_WIN1] = 0x83e0;		//A_Green		
	}
	else if(eSrcImgType == ARGB4444)
	{
		aColorKey[MX_WIN0] = 0x0f00;		//Red
		aColorKey[MX_WIN1] = 0x00f0;		//Green
	}
	else if(eSrcImgType == ARGB8888)
	{
		aColorKey[MX_WIN0] = 0xff0000;		//Red
		aColorKey[MX_WIN1] = 0x00ff00;		//Green
	}
	
	MIXER_SetColorKeyOnOff(MX_WIN0, aColorKey[MX_WIN0], 1);
	MIXER_SetColorKeyOnOff(MX_WIN1, aColorKey[MX_WIN1], 1);

	UART_Getc();

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDMXT_BigEndianMode(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDMXT_BigEndianMode]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : RGB565(D), 		1 : ARGB1555,		2 : ARGB4444,		3 : ARGB8888\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>3)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? RGB16 :
						(uSrcImgType_Temp == 1)? ARGB1555 :
						(uSrcImgType_Temp == 2)? ARGB4444 : ARGB8888;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( (eSrcImgType==RGB16)||(eSrcImgType==ARGB1555)||(eSrcImgType==ARGB4444)||(eSrcImgType==ARGB8888) );
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
	{
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, NV12, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	}
	HDVpMx_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr, eSrcImgType);
	
	// VP Setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
	//Mixer Setting
	HDVpMx_MixerSettingForTest(uWin0StAddr, uWin1StAddr, eSrcImgType);
	MIXER_SetEndianMode(MX_ENDIAN_BIG);
	
	// Change Image to Big Endian
	HDMx_ChangeImageEndianMode(oMx_SrcInf[0]);
	HDMx_ChangeImageEndianMode(oMx_SrcInf[1]);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	UART_Getc();
 
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);

	return 1;
}



void HDMXT_GetRanValueForMx(u32 *pRandom)
{
	u32 uDstFullSize_H, uDstFullSize_V;

	if (eImgSz == SD480)
	{
		uDstFullSize_H = SD480_HSIZE;
		uDstFullSize_V = SD480_VSIZE;
	}
	else if(eImgSz == SD576)
	{
		uDstFullSize_H = SD576_HSIZE;
		uDstFullSize_V = SD576_VSIZE;
	}
	else if(eImgSz == HD720)
	{
		uDstFullSize_H = HD720_HSIZE;
		uDstFullSize_V = HD720_VSIZE;
	}
	else if(eImgSz == HD1080)
	{
		uDstFullSize_H = HD1080_HSIZE;
		uDstFullSize_V = HD1080_VSIZE;
	}	
	else
	{}

	/// Window 0
	//oMx_SrcInf.uSrcXPos
	pRandom[0] = SBLK_GetRand()%(uDstFullSize_H-1);
	oMx_SrcInf[MX_WIN0].uSrcXPos = pRandom[0];

	//oMx_SrcInf.uSrcYPos
	pRandom[1] = SBLK_GetRand()%(uDstFullSize_V-1);
	oMx_SrcInf[MX_WIN0].uSrcYPos = pRandom[1];

	//oVP_DstInf.uDstXPos
	pRandom[2] = SBLK_GetRand()%(uDstFullSize_H-1);
	oMx_DstInf[MX_WIN0].uDstXPos = pRandom[2];

	//oVP_DstInf.uDstYPos
	pRandom[3] = SBLK_GetRand()%(uDstFullSize_V-1);
	oMx_DstInf[MX_WIN0].uDstYPos = pRandom[3];
	
	//oMx_SrcInf.uSrcHsz 
	if(oMx_DstInf[MX_WIN0].uDstXPos > oMx_SrcInf[MX_WIN0].uSrcXPos)
	{
		pRandom[4] = (SBLK_GetRand()%(uDstFullSize_H-oMx_DstInf[MX_WIN0].uDstXPos))+1;
		oMx_SrcInf[MX_WIN0].uSrcHsz = pRandom[4];
	}
	else
	{
		pRandom[4] = (SBLK_GetRand()%(uDstFullSize_H-oMx_SrcInf[MX_WIN0].uSrcXPos))+1;
		oMx_SrcInf[MX_WIN0].uSrcHsz = pRandom[4];
	}		

	//oVP_SrcInf.uSrcVsz
	if(oMx_DstInf[MX_WIN0].uDstYPos > oMx_SrcInf[MX_WIN0].uSrcYPos)
	{	
		pRandom[5] = (SBLK_GetRand()%(uDstFullSize_V-oMx_DstInf[MX_WIN0].uDstYPos))+1;
		oMx_SrcInf[MX_WIN0].uSrcVsz = pRandom[5];
	}
	else
	{
		pRandom[5] = (SBLK_GetRand()%(uDstFullSize_V-oMx_SrcInf[MX_WIN0].uSrcYPos))+1;
		oMx_SrcInf[MX_WIN0].uSrcVsz = pRandom[5];
	}

	/// Window 1
	//oMx_SrcInf.uSrcXPos
	pRandom[6] = SBLK_GetRand()%(uDstFullSize_H-1);
	oMx_SrcInf[MX_WIN1].uSrcXPos = pRandom[6];

	//oMx_SrcInf.uSrcYPos
	pRandom[7] = SBLK_GetRand()%(uDstFullSize_V-1);
	oMx_SrcInf[MX_WIN1].uSrcYPos = pRandom[7];

	//oVP_DstInf.uDstXPos
	pRandom[8] = SBLK_GetRand()%(uDstFullSize_H-1);
	oMx_DstInf[MX_WIN1].uDstXPos = pRandom[8];

	//oVP_DstInf.uDstYPos
	pRandom[9] = SBLK_GetRand()%(uDstFullSize_V-1);
	oMx_DstInf[MX_WIN1].uDstYPos = pRandom[9];
	
	//oMx_SrcInf.uSrcHsz 
	if(oMx_DstInf[MX_WIN1].uDstXPos > oMx_SrcInf[MX_WIN1].uSrcXPos)
	{
		pRandom[10] = (SBLK_GetRand()%(uDstFullSize_H-oMx_DstInf[MX_WIN1].uDstXPos))+1;
		oMx_SrcInf[MX_WIN1].uSrcHsz = pRandom[10];
	}
	else
	{
		pRandom[10] = (SBLK_GetRand()%(uDstFullSize_H-oMx_SrcInf[MX_WIN1].uSrcXPos))+1;
		oMx_SrcInf[MX_WIN1].uSrcHsz = pRandom[10];
	}		

	//oVP_SrcInf.uSrcVsz
	if(oMx_DstInf[MX_WIN1].uDstYPos > oMx_SrcInf[MX_WIN1].uSrcYPos)
	{	
		pRandom[11] = (SBLK_GetRand()%(uDstFullSize_V-oMx_DstInf[MX_WIN1].uDstYPos))+1;
		oMx_SrcInf[MX_WIN1].uSrcVsz = pRandom[11];
	}
	else
	{
		pRandom[11] = (SBLK_GetRand()%(uDstFullSize_V-oMx_SrcInf[MX_WIN1].uSrcYPos))+1;
		oMx_SrcInf[MX_WIN1].uSrcVsz = pRandom[11];
	}

	UART_Printf("==============================================\n");
	UART_Printf(">> Window 0\n");
	UART_Printf("Src Position(%d, %d)\n", oMx_SrcInf[MX_WIN0].uSrcXPos, oMx_SrcInf[MX_WIN0].uSrcYPos);
	UART_Printf("Dst Position(%d, %d)\n", oMx_DstInf[MX_WIN0].uDstXPos, oMx_DstInf[MX_WIN0].uDstYPos);
	UART_Printf("Src Size(%d, %d)\n", oMx_SrcInf[MX_WIN0].uSrcHsz, oMx_SrcInf[MX_WIN0].uSrcVsz);

	UART_Printf(">> Window 1\n");
	UART_Printf("Src Position(%d, %d)\n", oMx_SrcInf[MX_WIN1].uSrcXPos, oMx_SrcInf[MX_WIN1].uSrcYPos);
	UART_Printf("Dst Position(%d, %d)\n", oMx_DstInf[MX_WIN1].uDstXPos, oMx_DstInf[MX_WIN1].uDstYPos);
	UART_Printf("Src Size(%d, %d)\n", oMx_SrcInf[MX_WIN1].uSrcHsz, oMx_SrcInf[MX_WIN1].uSrcVsz);	
	UART_Printf("==============================================\n");
	
	UART_Printf("\n");
}


u32 HDVPT_SimpleDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDVPT_SimpleDisplay]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;

	HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);

	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uImageSize_H;
	oVP_SrcInf.uSrcVsz=uImageSize_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImageSize_H;
	oVP_DstInf.uDstVsz = uImageSize_V;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
///	VP_EnableIP(1);

	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
///	MIXER_StartProcessing();

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	// Waiting
	UART_Printf("Press any key to exit!\n");
	UART_Getc();

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDVPT_Scaling(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 i, uScaleCount, uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	float fScaleFactor[] = 	{ 	0.25, 0.33, 0.5, 
							1, 1.25, 1.5, 1.75, 
							2, 2.25, 2.5, 2.75, 
							3, 3.25, 3.5, 3.75, 
							4, 4.25, 4.5, 4.75, 
							5, 5.25, 5.5, 5.75, 
							6, 6.25, 6.5, 6.75, 
							7, 7.25, 7.5, 7.75, 
							8, 8.25, 8.5, 8.75, 
							9, 9.25, 9.5, 9.75, 
							10, 10.25, 10.5, 10.75, 
							11, 11.25, 11.5, 11.75, 
							12, 12.25, 12.5, 12.75, 
							13, 13.25, 13.5, 13.75, 
							14, 14.25, 14.5, 14.75, 
							15, 15.25, 15.5, 15.75, 
							16};

	UART_Printf("[HDVPT_Scaling]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	
	uScaleCount = sizeof(fScaleFactor)/sizeof(fScaleFactor[0]);

	if(eTest == eTest_Manual)
	{
	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);
	}
	else
	{
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	}
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;

	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);
		
	if(eTest == eTest_Auto)
	{
		UART_Printf("Press Any key\n");
		UART_Getc();
	}	
	
	UART_Printf("1. X-axis Scaling Test\n");	
	for(i=0 ; i<uScaleCount ; i++)
	{
		oVP_SrcInf.uSrcHsz = (u32)((float)uImageSize_H/fScaleFactor[i]);
		if(oVP_SrcInf.uSrcHsz > uImageSize_H)
			oVP_SrcInf.uSrcHsz = uImageSize_H;
		oVP_SrcInf.uSrcVsz = uImageSize_V;

		oVP_DstInf.uDstHsz = (u32)((float)oVP_SrcInf.uSrcHsz*fScaleFactor[i]);
		oVP_DstInf.uDstVsz = uImageSize_V;

		UART_Printf("Src(%d,%d) -> Dst(%d,%d)  :  Scaling(%0.2f, 1)\n", 
					oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz, fScaleFactor[i] );

		VP_SetCroppingSize(0, 0, oVP_SrcInf.uSrcHsz,  oVP_SrcInf.uSrcVsz, STEP0);
		VP_SetViewPosition(0, 0, 	oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);

		//Waiting
		if(eTest == eTest_Manual)
			UART_Getc();
		else
			DelayfrTimer(milli, 200);
	}

	UART_Printf("2. Y-axis Scaling Test\n");	
	for(i=0 ; i<uScaleCount ; i++)
	{
		oVP_SrcInf.uSrcHsz = uImageSize_H;
		oVP_SrcInf.uSrcVsz = (u32)((float)uImageSize_V/fScaleFactor[i]);
		if(oVP_SrcInf.uSrcVsz > uImageSize_V)
			oVP_SrcInf.uSrcVsz = uImageSize_V;		
		
		oVP_DstInf.uDstHsz = uImageSize_H;
		oVP_DstInf.uDstVsz = (u32)((float)oVP_SrcInf.uSrcVsz*fScaleFactor[i]);;

		UART_Printf("Src(%d,%d) -> Dst(%d,%d)  :  Scaling(1, %0.2f)\n", 
					oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz, fScaleFactor[i] );

		VP_SetCroppingSize(0, 0, oVP_SrcInf.uSrcHsz,  oVP_SrcInf.uSrcVsz, STEP0);
		VP_SetViewPosition(0, 0, 	oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);		

		//Waiting
		if(eTest == eTest_Manual)
			UART_Getc();
		else
			DelayfrTimer(milli, 200);
	}

	UART_Printf("3. XY-axis Scaling Test\n");	
	for(i=0 ; i<uScaleCount ; i++)
	{
		oVP_SrcInf.uSrcHsz = (u32)((float)uImageSize_H/fScaleFactor[i]);
		if(oVP_SrcInf.uSrcHsz > uImageSize_H)
			oVP_SrcInf.uSrcHsz = uImageSize_H;
		oVP_SrcInf.uSrcVsz = (u32)((float)uImageSize_V/fScaleFactor[i]);
		if(oVP_SrcInf.uSrcVsz > uImageSize_V)
			oVP_SrcInf.uSrcVsz = uImageSize_V;		
		
		oVP_DstInf.uDstHsz = (u32)((float)oVP_SrcInf.uSrcHsz*fScaleFactor[i]);
		oVP_DstInf.uDstVsz = (u32)((float)oVP_SrcInf.uSrcVsz*fScaleFactor[i]);;

		UART_Printf("Src(%d,%d) -> Dst(%d,%d)  :  Scaling(%0.2f, %0.2f)\n", 
					oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz, fScaleFactor[i], fScaleFactor[i] );

		VP_SetCroppingSize(0, 0, oVP_SrcInf.uSrcHsz,  oVP_SrcInf.uSrcVsz, STEP0);
		VP_SetViewPosition(0, 0, 	oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);		

		//Waiting
		if(eTest == eTest_Manual)
			UART_Getc();
		else
			DelayfrTimer(milli, 200);
	}	

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);	
	return 1;
}


u32 HDVPT_SourceCropping(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXSize, uSrcYSize;
	u32 uSrcImgType_Temp;
	u32 uTempKey;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDVPT_SourceCropping]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);
	
	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=VP_SRCSIZE_MIN_H;
	oVP_SrcInf.uSrcVsz=VP_SRCSIZE_MIN_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = oVP_SrcInf.uSrcHsz;
	oVP_DstInf.uDstVsz = oVP_SrcInf.uSrcVsz;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
///	VP_EnableIP(1);

	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
///	MIXER_StartProcessing();

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);
			
	for(uSrcXSize=VP_SRCSIZE_MIN_H ; uSrcXSize<=uImageSize_H ; uSrcXSize+=5)
	{
		for(uSrcYSize=VP_SRCSIZE_MIN_V ; uSrcYSize<=uImageSize_V ; uSrcYSize+=5)
		{
			// Set Image Positioning
			VP_SetCroppingSize(0, 0, uSrcXSize, uSrcYSize, STEP0);
			VP_SetViewPosition(0, 0, uSrcXSize, uSrcYSize);

			UART_Printf("Cropped Src(%d,%d) -> Dst(%d,%d)\n", 
						oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz, oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);

			//Waiting
			//DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{			
				//TV Off
				VP_EnableIP(0);
				MIXER_StopProcessing();
				HDMI_Enable(FALSE);
				HDMI_TG_OnOff(FALSE);
				return 1;
			}
		}
	}

	UART_Getc();
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}



u32 HDVPT_SourceImgPositioning(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize;
	u32 uSrcImgType_Temp;
	u32 uTempKey;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDVPT_SourceImgPositioning]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);
	
	// VP setting
	uSrcXSize=200;
	uSrcYSize=150;
	
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz = uSrcXSize;
	oVP_SrcInf.uSrcVsz = uSrcYSize;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 80;
	oVP_DstInf.uDstYPos = 60;
	oVP_DstInf.uDstHsz = uSrcXSize;
	oVP_DstInf.uDstVsz = uSrcYSize;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
///	VP_EnableIP(1);

	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
///	MIXER_StartProcessing();

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);
			
	for(uSrcXPos=0 ; uSrcXPos<=uImageSize_H-uSrcXSize ; uSrcXPos+=5)
	{
		for(uSrcYPos=0 ; uSrcYPos<=uImageSize_V-uSrcYSize ; uSrcYPos+=5)
		{
			UART_Printf("Src Positioning(%d,%d) -> Dst(%d,%d),    Image Size(%d, %d)\n", 
						uSrcXPos, uSrcYPos, oVP_DstInf.uDstXPos, oVP_DstInf.uDstYPos, uSrcXSize, uSrcYSize);

			// Set Image Positioning
			VP_SetCroppingSize(uSrcXPos, uSrcYPos, uSrcXSize, uSrcYSize, STEP0);
			
			//Waiting
			//DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{
				//TV Off
				VP_EnableIP(0);
				MIXER_StopProcessing();
				HDMI_Enable(FALSE);
				HDMI_TG_OnOff(FALSE);
				return 1;
			}
		}
	}

	UART_Getc();
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDVPT_DestinationImgPositioning(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uDstXPos, uDstYPos, uDstXSize, uDstYSize;
	u32 uSrcImgType_Temp;
	u32 uTempKey;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDVPT_DestinationImgPositioning]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);
	
	// VP setting
	uDstXSize = 200;
	uDstYSize = 150;
	
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz = uDstXSize;
	oVP_SrcInf.uSrcVsz = uDstYSize;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uDstXSize;
	oVP_DstInf.uDstVsz = uDstYSize;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
///	VP_EnableIP(1);

	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
///	MIXER_StartProcessing();

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);
			
	for(uDstXPos=0 ; uDstXPos<=uImageSize_H-uDstXSize ; uDstXPos+=5)
	{
		for(uDstYPos=0 ; uDstYPos<=uImageSize_V-uDstYSize ; uDstYPos+=5)
		{
			// Set Desitionation Image Positioning
			VP_SetViewPosition(uDstXPos, uDstYPos, uDstXSize, uDstYSize);
			
			UART_Printf("Src Position(%d,%d) -> Dst Position(%d,%d),    Image Size(%d, %d)\n", 
						oVP_SrcInf.uSrcXPos, oVP_SrcInf.uSrcYPos, uDstXPos, uDstYPos, uDstXSize, uDstYSize);
			
			//Waiting
			//DelayfrTimer(milli, 10);

			uTempKey = UART_GetKey();
			if(uTempKey == 's')
				UART_Getc();
			else if(uTempKey == 'x')
			{
				//TV Off
				VP_EnableIP(0);
				MIXER_StopProcessing();
				HDMI_Enable(FALSE);	
				HDMI_TG_OnOff(FALSE);
				return 1;
			}
		}
	}

	UART_Getc();
	
	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);	
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDVPT_ColorSpaceConversion(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDVPT_ColorSpaceConversion] : BT.709 to BT.601\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
		HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	else
		HDVpMx_CalcImageSize(eImgSz, &uImageSize_H, &uImageSize_V);

	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz = uImageSize_H;
	oVP_SrcInf.uSrcVsz = uImageSize_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImageSize_H;
	oVP_DstInf.uDstVsz = uImageSize_V;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
	VP_SetCscOnOff(HD_TO_SD, MINUS16, 1);

	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	while(1)
	{
		UART_Printf("HD_TO_SD, MINUS16\n");
		FIMC_RunWith_CSC_YUVRange(RGB709_16_235);
		HDMI_SetColorimetry(HDMI_COLORIMETRY_ITU601);
		HDMI_UpdateAVIChecksum();
		///HDMI_Enable(TRUE);	
		VP_SetCscOnOff(HD_TO_SD, MINUS16, 1);
		if(UART_Getc() == 'x')
			break;

		UART_Printf("HD_TO_SD, ZERO\n");
		FIMC_RunWith_CSC_YUVRange(RGB709_0_255);
		HDMI_SetColorimetry(HDMI_COLORIMETRY_ITU601);
		//HDMI_UpdateAVIChecksum();
		HDMI_Enable(TRUE);	
		VP_SetCscOnOff(HD_TO_SD, ZERO, 1);
		if(UART_Getc() == 'x')
			break;

		UART_Printf("SD_TO_HD, MINUS16\n");
		FIMC_RunWith_CSC_YUVRange(RGB601_16_235);
		HDMI_SetColorimetry(HDMI_COLORIMETRY_ITU709);
		//HDMI_UpdateAVIChecksum();
		HDMI_Enable(TRUE);	
		VP_SetCscOnOff(SD_TO_HD, MINUS16, 1);
		if(UART_Getc() == 'x')
			break;		

		UART_Printf("SD_TO_HD, ZERO\n");
		FIMC_RunWith_CSC_YUVRange(RGB601_0_255);
		HDMI_SetColorimetry(HDMI_COLORIMETRY_ITU709);
		//HDMI_UpdateAVIChecksum();
		HDMI_Enable(TRUE);	
		VP_SetCscOnOff(SD_TO_HD, ZERO, 1);
		if(UART_Getc() == 'x')
			break;
	}
	
	// TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);	
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


u32 HDVPT_Saturation(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{	
	u32 i;

	UART_Printf("[HDVPT_Saturation]\n");

	VP_SetPostProcessingOnOff(1);
	
	for(i=0 ; i<=0xFF ; i++)
	{
		VP_SetSaturation(i);
		DelayfrTimer(milli, 50);
	}

	// Reset to Default
	VP_SetSaturation(0x80);

	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 HDVPT_Sharpness(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;

	UART_Printf("[HDVPT_Sharpness]\n");
	
	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=3 ; i++)
	{
		VP_SetSharpness((VP_eSHARPNESS)i, 0x5);
		DelayfrTimer(milli, 2000);
	}

	// Reset to Default
	VP_SetSharpness(NO_EFFECT, 0x5);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 HDVPT_Brightness(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, j, aBrightness[8];

	UART_Printf("[HDVPT_Brightness]\n");

	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=0xFFFF ; i++)
	{
		for(j=0 ; j<8 ; j++)
			aBrightness[j] = i;		//chnage to resonable value
		
		VP_SetBrightness(aBrightness);
		DelayfrTimer(milli, 1);
	}

	// Reset to Default
	for(i=0 ; i<8 ; i++)
		aBrightness[i] = 0;
	VP_SetBrightness(aBrightness);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 HDVPT_Contrast(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, j, aContrast[8];

	UART_Printf("[HDVPT_Contrast]\n");

	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=0xFF ; i++)
	{
		for(j=0 ; j<8 ; j++)
			aContrast[j] = i;		//chnage to resonable value
		
		VP_SetContrast(aContrast);
		DelayfrTimer(milli, 50);
	}

	// Reset to Default
	for(i=0 ; i<8 ; i++)
		aContrast[i] = 0x80;
	VP_SetContrast(aContrast);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 HDVPT_Brightness_Offset(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;

	UART_Printf("[HDVPT_Brightness_Offset]\n");

	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=0x1FF ; i++)
	{
		VP_SetBrightOffset(i);
		DelayfrTimer(milli, 50);
	}

	// Reset to Default
	VP_SetBrightOffset(0);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


u32 HDVPT_TH_HNoise(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;

	UART_Printf("[HDVPT_TH_HNoise]\n");

	VP_SetPostProcessingOnOff(1);
	for(i=0 ; i<=0xFF ; i++)
	{
		VP_SetSharpness(NO_EFFECT, i);
		DelayfrTimer(milli, 50);
	}

	// Reset to Default
	VP_SetSharpness(NO_EFFECT, 0x5);
	VP_SetPostProcessingOnOff(0);
	UART_Printf("\n");

	return 1;
}


const AutotestFuncMenu HDTV_VpEnc_menu[]=
{
	HDVPT_Saturation,				"VP Saturation",
	HDVPT_Sharpness,				"VP Sharpness",
	HDVPT_Brightness,				"VP Brightness",
	HDVPT_Contrast,					"VP Contrast",
	HDVPT_Brightness_Offset,		"VP Brightness Offset",
	HDVPT_TH_HNoise,				"VP TH HNoise",
	0,0
};


u32 HDVPT_Enhacement(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	s32 sSel;
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 i, uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDVPT_Enhacement]\n");
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("Select the Source Image Type\n");
		UART_Printf("0 : NV12(D), 		1 : NV12_IB(Packed),		2 : NV12_IW\n");
		UART_Printf("3 : TILE_NV12,  	4 : TILE_NV12_IB(Packed),	5 : TILE_NV12_IW\n");
		uSrcImgType_Temp = UART_GetIntNum();
		if(uSrcImgType_Temp>5)
			uSrcImgType_Temp = 0;

		eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 :
						(uSrcImgType_Temp == 1)? NV12_IB :
						(uSrcImgType_Temp == 2)? NV12_IW :
						(uSrcImgType_Temp == 3)? TILE_NV12 :
						(uSrcImgType_Temp == 4)? TILE_NV12_IB : TILE_NV12_IW;
	}
	else
	{
		eSrcImgType = (IMG_FMT)oPara.Test_Parameter[0];
		Assert( 	(eSrcImgType==NV12)||(eSrcImgType==NV12_IB)||(eSrcImgType==NV12_IW)||
				(eSrcImgType==TILE_NV12)||(eSrcImgType==TILE_NV12_IB)||(eSrcImgType==TILE_NV12_IW));
	}
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;

	HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);

	// VP setting
	oVP_SrcInf.eSrcBpp = eSrcImgType;
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uImageSize_H;
	oVP_SrcInf.uImgVsz = uImageSize_V;
	oVP_SrcInf.uSrcXPos = 0;
	oVP_SrcInf.uSrcYPos = 0;
	oVP_SrcInf.uSrcHsz=uImageSize_H;
	oVP_SrcInf.uSrcVsz=uImageSize_V;

	oVP_DstInf.uOrgDstHsz = uImageSize_H;
	oVP_DstInf.uOrgDstVsz = uImageSize_V;
	oVP_DstInf.uDstXPos = 0;
	oVP_DstInf.uDstYPos = 0;
	oVP_DstInf.uDstHsz = uImageSize_H;
	oVP_DstInf.uDstVsz = uImageSize_V;	

	VP_InitIP(oVP_SrcInf, oVP_DstInf);
///	VP_EnableIP(1);

	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);
///	MIXER_StartProcessing();

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);
	
	while (true)
	{
		for ( i=0; (int)(HDTV_VpEnc_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, HDTV_VpEnc_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(HDTV_VpEnc_menu)/8-1))
			(HDTV_VpEnc_menu[sSel].func) (eTest_Manual, oPara);
	}

	// TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);

	return 1;	
}


u32 HDVPT_PictureBigEndianMode(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr;
	u32 uImageSize_H, uImageSize_V;
	u32 uSrcImgType_Temp;
	IMG_FMT eSrcImgType;

	UART_Printf("[HDVPT_PictureBigEndianMode]\n");
	
	UART_Printf("Select the Source Image Type\n");
	UART_Printf("0 : NV12(D), 		1 : TILE_NV12\n");
	uSrcImgType_Temp = UART_GetIntNum();
	if(uSrcImgType_Temp>1)
		uSrcImgType_Temp = 0;
	eSrcImgType = 	(uSrcImgType_Temp == 0)? NV12 : TILE_NV12;
	
	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;

	HDVpMx_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eSrcImgType, &uImageSize_H, &uImageSize_V, RGB709_16_235);
	HDVpMx_VPSettingForTest(uVpSrcAddr, eSrcImgType);
	HDVp_ChangeImageEndianMode(oVP_SrcInf); 	
	VP_SetEndianMode(ENDIAN_BIG);

	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	// Waiting
	UART_Printf("Press any key to exit!\n");
	UART_Getc();

	//TV Off
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return 1;
}


void HDVPT_GetRanValueForVP(u32 *pRandom)
{
	u32 uDstFullSize_H, uDstFullSize_V;
	u32 uRepeatCount=0;

	if (oVP_DstInf.eImgSz == SD480)
	{
		uDstFullSize_H = SD480_HSIZE;
		uDstFullSize_V = SD480_VSIZE;
	}
	else if(oVP_DstInf.eImgSz == SD576)
	{
		uDstFullSize_H = SD576_HSIZE;
		uDstFullSize_V = SD576_VSIZE;
	}
	else if(oVP_DstInf.eImgSz == HD720)
	{
		uDstFullSize_H = HD720_HSIZE;
		uDstFullSize_V = HD720_VSIZE;
	}
	else if(oVP_DstInf.eImgSz == HD1080)
	{
		uDstFullSize_H = HD1080_HSIZE;
		uDstFullSize_V = HD1080_VSIZE;
	}	
	else
	{}
	
	//oVP_SrcInf.eSrcBpp
	pRandom[0] = SBLK_GetRand()%6;
	//pRandom[0] = 3;

	//oVP_SrcInf.uSrcXPos
	pRandom[1] = SBLK_GetRand()%(oVP_SrcInf.uImgHsz-VP_SRCSIZE_MIN_H+1);
	oVP_SrcInf.uSrcXPos = pRandom[1];

	//oVP_SrcInf.uSrcYPos
	pRandom[2] = SBLK_GetRand()%(oVP_SrcInf.uImgVsz-VP_SRCSIZE_MIN_V+1);
	oVP_SrcInf.uSrcYPos = pRandom[2];

	//oVP_SrcInf.uSrcHsz 
	do
	{
		pRandom[3] = SBLK_GetRand()%(oVP_SrcInf.uImgHsz-oVP_SrcInf.uSrcXPos+2);
		if(pRandom[3] < VP_SRCSIZE_MIN_H)
			pRandom[3] = VP_SRCSIZE_MIN_H;
	}while(oVP_SrcInf.uSrcXPos+pRandom[3] > oVP_SrcInf.uImgHsz);
	oVP_SrcInf.uSrcHsz = pRandom[3];

	//oVP_SrcInf.uSrcVsz
	do
	{
		pRandom[4] = SBLK_GetRand()%(oVP_SrcInf.uImgVsz-oVP_SrcInf.uSrcYPos+2);
		if(pRandom[4] < VP_SRCSIZE_MIN_V)
			pRandom[4] = VP_SRCSIZE_MIN_V;
	}while(oVP_SrcInf.uSrcYPos+pRandom[4] > oVP_SrcInf.uImgVsz);
	oVP_SrcInf.uSrcVsz = pRandom[4];

	//oVP_DstInf.uDstXPos
	pRandom[5] = SBLK_GetRand()%(uDstFullSize_H-VP_SRCSIZE_MIN_H+1);
	oVP_DstInf.uDstXPos = pRandom[5];

	//oVP_DstInf.uDstYPos
	pRandom[6] = SBLK_GetRand()%(uDstFullSize_V-VP_SRCSIZE_MIN_V+1);
	oVP_DstInf.uDstYPos = pRandom[6];

	//oVP_DstInf.uDstHsz
	do
	{
		uRepeatCount++;
		if(uRepeatCount > 10)
		{
			uRepeatCount = 0;
			//oVP_DstInf.uDstXPos
			pRandom[5] = SBLK_GetRand()%(uDstFullSize_H-VP_SRCSIZE_MIN_H+1);
			oVP_DstInf.uDstXPos = pRandom[5];			
		}
		
		pRandom[7] = SBLK_GetRand()%(uDstFullSize_H-oVP_DstInf.uDstXPos+1);
		if(pRandom[7] < VP_SRCSIZE_MIN_H)
			pRandom[7] = VP_SRCSIZE_MIN_H;		
	}while( (pRandom[7]>(oVP_SrcInf.uSrcHsz*16)) || ((float)pRandom[7]<(float)((float)oVP_SrcInf.uSrcHsz*(float)0.25)) );
	oVP_DstInf.uDstHsz = pRandom[7];

	//oVP_DstInf.uDstVsz
	uRepeatCount = 0;
	do
	{
		uRepeatCount++;
		if(uRepeatCount > 10)
		{
			uRepeatCount = 0;
			//oVP_DstInf.uDstYPos
			pRandom[6] = SBLK_GetRand()%(uDstFullSize_V-VP_SRCSIZE_MIN_V+1);
			oVP_DstInf.uDstYPos = pRandom[6];		
		}		

		pRandom[8] = SBLK_GetRand()%(uDstFullSize_V-oVP_DstInf.uDstYPos+1);
		if(pRandom[8] < VP_SRCSIZE_MIN_V)
			pRandom[8] = VP_SRCSIZE_MIN_V;		
	}while( (pRandom[8]>(oVP_SrcInf.uSrcVsz*16)) || ((float)pRandom[8]<(float)((float)oVP_SrcInf.uSrcVsz*(float)0.25)) );
	oVP_DstInf.uDstVsz = pRandom[8];

	pRandom[9] = SBLK_GetRand()%16;		// Step
	
	if(pRandom[0] == 0)
		UART_Printf("Src Image Format : NV12\n");
	else if(pRandom[0] == 1)
		UART_Printf("Src Image Format : NV12_IB\n");
	else if(pRandom[0] == 2)
		UART_Printf("Src Image Format : NV12_IW\n");
	else if(pRandom[0] == 3)
		UART_Printf("Src Image Format : TILE_NV12\n");
	else if(pRandom[0] == 4)
		UART_Printf("Src Image Format : TILE_NV12_IB\n");
	else
		UART_Printf("Src Image Format : TILE_NV12_IW\n");
						
	UART_Printf("Src Image : Pos(%d, %d), Size(%d, %d)\n",	oVP_SrcInf.uSrcXPos, oVP_SrcInf.uSrcYPos,
														oVP_SrcInf.uSrcHsz, oVP_SrcInf.uSrcVsz);
	UART_Printf("Dst Image : Pos(%d, %d), Size(%d, %d)\n",	oVP_DstInf.uDstXPos, oVP_DstInf.uDstYPos,
														oVP_DstInf.uDstHsz, oVP_DstInf.uDstVsz);	
	UART_Printf("Horizontal Scaling = %0.2f\n", (float)oVP_DstInf.uDstHsz/(float)oVP_SrcInf.uSrcHsz);
	UART_Printf("Vertial Scaling = %0.2f (or x2)\n", (float)oVP_DstInf.uDstVsz/(float)oVP_SrcInf.uSrcVsz);
	UART_Printf("Step = %d\n", pRandom[9]);
	UART_Printf("\n");
}



const AutotestFuncMenu HDTV_VPMixer_menu[]=
{
	//-- Mixer -- 
	HDMXT_SimpleDisplay,				"Mixer Simple Display",
	HDMXT_Blending,					"Mixer Blending",
	HDMXT_Cropping,					"Mixer Cropping",
	HDMXT_SourceImgPositioning,		"Mixer Source Image Positioning",
	HDMXT_DestinationImgPositioning,	"Mixer Destination Image Positioning",
	HDMXT_ColorSpaceConversion,		"Mixer CSC",
	HDMXT_Scaling,						"Mixer Scaling",
	HDMXT_ColorKey,					"Mixer ColorKey",
	HDMXT_BigEndianMode,				"Mixer Big Endian",
	
	// -- VP --
	HDVPT_SimpleDisplay,				"VP Simple Display",
	HDVPT_Scaling,						"VP Scaling Test",
	HDVPT_SourceCropping,				"VP Source Cropping Test",
	HDVPT_SourceImgPositioning,		"VP Source Image Positioning",
	HDVPT_DestinationImgPositioning,	"VP Destination Image Positioning",
	HDVPT_ColorSpaceConversion,		"VP CSC",
	HDVPT_Enhacement,					"VP Enhancement",
	HDVPT_PictureBigEndianMode,		"VP Endian Mode",
	0,0
};



void VPMixer_Test(void)
{
	s32 sSel;
	u32 i, uResolution, uScanMode, uHdmiMode;
	oFunctionT_AutoVar oPara;
	HDMIMode eHDMI_DVI;
	VideoFormat eVideoFmt;
	ColorDepth eColorDepth;
	PixelAspectRatio ePixelRatio;	
	
	UART_Printf("[VPMixer_Test]\n");

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	if(FS_Init()!=0)
		Disp("Fail to open FAT with SD CARD\n");
	UART_Printf("\n\n");	
#endif

	InitSysconForHD();
	
	UART_Printf("\n");
	UART_Printf("0. 1080		1. 720 		2. 480		3. 576  \n");
	UART_Printf("Select the Video Resolution : ");
	uResolution = UART_GetIntNum();
	if(uResolution>3)
		uResolution = 0;
	eImgSz = 	(uResolution == 0)? HD1080 :
				(uResolution == 1)? HD720:
				(uResolution == 2)? SD480 : SD576;
	
	UART_Printf("\n");
	UART_Printf("0. PROGRESSIVE		1.INTERLACED \n");
	UART_Printf("Select the Scan Mode : ");
	uScanMode = UART_GetIntNum();
	if(uScanMode>1)
		uScanMode = 0;
	eScanMode = (uScanMode == 0)? PROGRESSIVE : INTERLACED;
				
	eVideoFmt = 	(eImgSz == HD1080)? ((eScanMode== PROGRESSIVE)? v1920x1080p_60Hz : v1920x1080i_60Hz) :
				(eImgSz == HD720)? 	v1280x720p_60Hz:
				(eImgSz == SD480)? 	((eScanMode== PROGRESSIVE)? v720x480p_60Hz : v720x480i_60Hz) :
									((eScanMode== PROGRESSIVE)? v720x576p_50Hz : v720x576i_50Hz);
									
	ePixelRatio = 	(eImgSz == HD1080)? HDMI_PIXEL_RATIO_16_9:
				(eImgSz == HD720)? 	HDMI_PIXEL_RATIO_16_9:
				(eImgSz == SD480)?	HDMI_PIXEL_RATIO_4_3: HDMI_PIXEL_RATIO_4_3;
	
	UART_Printf("\n");
	UART_Printf("0. HDMI		1.DVI \n");
	UART_Printf("Select the HDMI or DVI : ");
	uHdmiMode = UART_GetIntNum();
	if(uHdmiMode>1)
		uHdmiMode = 0;
	eHDMI_DVI = (uHdmiMode == 0)? HDMI : DVI;

	//VP & Mixer Initialize
	HDVPT_InitParaForTV(NV12);
	HDMXT_InitParaForTV();

	//HDMI Initialize
	UART_Printf("HDMI Init\n");
	HDMI_Init();
	HPD_Init();

	UART_Printf("Waiting HPD...\n");
	while (HPD_Detect() != HDMI_HPD_CABLE_IN);
	
	HDMI_SetMode(eHDMI_DVI);
	HDMI_SetColorSpace(HDMI_CS_YCBCR444);

	eColorDepth = HDMI_CD_24;
	HDMI_SetVideoMode(eVideoFmt, eColorDepth, ePixelRatio);
	HDMI_SetPixelLimit(HDMI_YCBCR_LIMIT_RANGE);

	while (true)
	{
		for ( i=0; (int)(HDTV_VPMixer_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, HDTV_VPMixer_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(HDTV_VPMixer_menu)/8-1))
			(HDTV_VPMixer_menu[sSel].func) (eTest_Manual, oPara);
	}

}



//////////////////////////////////////////////////////////////////////////////////////////////////////
/////  	HDMI TEST
//////////////////////////////////////////////////////////////////////////////////////////////////////

static void HDMIT_VPSettingForTest(u32 uVpSrcAddr)
{
	HDVPT_InitParaForTV(NV12);

	// VP Setting
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	VP_InitIP(oVP_SrcInf, oVP_DstInf);
}


static void HDMIT_MixerSettingForTest(u32 uWin0StAddr, u32 uWin1StAddr, ColorSpace eColorSpace, MX_RGB_FORMAT eMxOutRgb)
{
	MX_RGB_FORMAT eMxCscInRgb;
	
	HDMXT_InitParaForTV();

	// Mixer setting
	UART_Printf("Video Layer Displayed\n");

	if((eMxOutRgb == RGB601_0_255) || (eMxOutRgb == RGB601_16_235))
		eMxCscInRgb = RGB601_0_255;		// Glib graphic range : 0 ~ 255
	else
		eMxCscInRgb = RGB709_0_255;		// Glib graphic range : 0 ~ 255
	
	MIXER_InitForDTv(eImgSz, eScanMode, eMxCscInRgb);
	MIXER_SetVdWinOnOff(1);
	
	UART_Printf("Graphic Layer 0 Displayed\n");
	oMx_SrcInf[0].eBpp = RGB16;
	oMx_SrcInf[0].uFbStAddr = uWin0StAddr;
	oMx_SrcInf[0].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcXPos = 0;
	oMx_SrcInf[0].uSrcYPos = 0;
	oMx_SrcInf[0].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[0].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[0].uDstXPos = 70;
	oMx_DstInf[0].uDstYPos = 50;
///	oMx_DstInf[0].uDstXPos = 0;
///	oMx_DstInf[0].uDstYPos = 0;
	
	MIXER_InitGrphWin(MX_WIN0, oMx_SrcInf[MX_WIN0], oMx_DstInf[MX_WIN0]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN0, 1);

	UART_Printf("Graphic Layer 1 Displayed\n");
	oMx_SrcInf[1].eBpp = RGB16;
	oMx_SrcInf[1].uFbStAddr = uWin1StAddr;
	oMx_SrcInf[1].uImgHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcXPos = 0;
	oMx_SrcInf[1].uSrcYPos = 0;
	oMx_SrcInf[1].uSrcHsz = IMG_SRC_HSZ_240;
	oMx_SrcInf[1].uSrcVsz = IMG_SRC_VSZ_320;

	oMx_DstInf[1].uDstXPos = 250;
	oMx_DstInf[1].uDstYPos = 100;
	
	MIXER_InitGrphWin(MX_WIN1, oMx_SrcInf[MX_WIN1], oMx_DstInf[MX_WIN1]);
	MIXER_SetOrder(DN_VDW0W1_UP);
	MIXER_SetGrphWinOnOff(MX_WIN1, 1);

	if((eMxOutRgb == RGB601_16_235) || (eMxOutRgb == RGB709_16_235))
		MIXER_SetVideoLimiterOnOff(0xeb, 0x10, 0xf0, 0x10, 1);
	else
		MIXER_SetVideoLimiterOnOff(0xff, 0x00, 0xff, 0x00, 0);
	
	if(eColorSpace == HDMI_CS_RGB)
		MIXER_SetRGBColorFormat(MX_RGB888, eMxOutRgb);
	else
		MIXER_SetRGBColorFormat(MX_YUV444, eMxOutRgb);
	
///	MIXER_StartProcessing();
}


static void HDMIT_DownImageForVP(IMG_RESOLUTION eImageSize, u32 uBMPSrcAddr, u32 uRGBSrcAddr, u32 uVpSrcAddr, 	
									MX_RGB_FORMAT eMxOutRgb)
{
	u32 uImageSize_H, uImageSize_V;
	oDownImage_Inform 	oDownImg;
	
	if(eImageSize == HD720)
	{
		oDownImg.eImageSize = BMP_1280x720;
		oDownImg.pImagePath = pTest_Image[BMP_1280x720];
		uImageSize_H = HD720_HSIZE;
		uImageSize_V = HD720_VSIZE;
	}
	else if(eImageSize == HD1080)
	{
		oDownImg.eImageSize = BMP_1920x1080;
		oDownImg.pImagePath = pTest_Image[BMP_1920x1080];
		uImageSize_H = HD1080_HSIZE;
		uImageSize_V = HD1080_VSIZE;		
	}
	else if(eImageSize == SD480)
	{
		oDownImg.eImageSize = BMP_720x480;
		oDownImg.pImagePath = pTest_Image[BMP_720x480];
		uImageSize_H = SD480_HSIZE;
		uImageSize_V = SD480_VSIZE;		
	}
	else if(eImageSize == SD576)
	{
		oDownImg.eImageSize = BMP_720x576;
		oDownImg.pImagePath = pTest_Image[BMP_720x576];
		uImageSize_H = SD576_HSIZE;
		uImageSize_V = SD576_VSIZE;		
	}	
	else
	{
		UART_Printf("Not supported image size..\n");
		Assert(0);
	}

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	{
		s32 sFail;
		u32 uFileReadSize;
		t_file_handler oFileHandler;
		
		sFail = FS_Open(oDownImg.pImagePath, &oFileHandler);
		if(sFail != 0)
		{
			UART_Printf("%s open fail\n", oDownImg.pImagePath);
			return;
		}
	else
			UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		
		//(void *)uBMPSrcAddr = malloc(oFileHandler.nSize);	
		FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uBMPSrcAddr, &uFileReadSize);	
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);
		
		FIMC_CSC_Scaling_ForHD(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12, eMxOutRgb);	
		//free(uBMPSrcAddr);
	}
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
	if(LoadFromFile((const char *)oDownImg.pImagePath, uBMPSrcAddr)) // Load NV12 img from mem
	{
		UART_Printf("Success to load image(%s)\n", oDownImg.pImagePath);
		ConvertBmpToRgb24bpp((u32)uBMPSrcAddr, (u32)uRGBSrcAddr, uImageSize_H, uImageSize_V);

		FIMC_CSC_Scaling_ForHD(uRGBSrcAddr, uVpSrcAddr, uImageSize_H,uImageSize_V,uImageSize_H,uImageSize_V,
								RGB888, NV12, eMxOutRgb);
	}
	else
	{
		UART_Printf("Fail to load image\n");	
		Assert(0);
	}
#endif	
}


static void HDMIT_DrawGraphicForMixer(u32 uWin0StAddr, u32 uWin1StAddr)
{
	GLIB_InitInstance(uWin0StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, RGB16);
	GLIB_DrawPattern(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	//GLIB_DrawPattern_Blue(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_InitFont();
	GLIB_Printf(90,160, "Window 0");
	
	GLIB_InitInstance(uWin1StAddr, IMG_SRC_HSZ_240, IMG_SRC_VSZ_320, RGB16);
	GLIB_DrawPattern2(IMG_SRC_HSZ_240, IMG_SRC_VSZ_320);
	GLIB_Printf(90,160, "Window 1");
}


u32 HDMIT_SupportResolutionDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uWaveBufAddr, uPcmBufAddr, uHdmiMode, uColorFormat;
	u32 uChannelType, uSampleRate, uBitsPerSample;	
	u32 uWideColor;
	u8 ucTxCheck;
	static u32 uImgDownCheck=0xff;
	u32 uAudioDownCheck = 0;
	HDMIMode eHDMI_DVI;
	ColorSpace eColorSpace;
	MX_RGB_FORMAT eMxOutRgb;
	PixelLimit ePixelLimit;	
	
	UART_Printf("[HDMIT_SupportResolutionDisplay]\n");

	while(TRUE)
	{
		if(eTest == eTest_Manual)
		{
			UART_Printf("\n");
			UART_Printf("0. HDMI		1.DVI \n");
			UART_Printf("Select the HDMI or DVI : ");
			uHdmiMode = UART_GetIntNum();
		}
		else
			uHdmiMode = oPara.Test_Parameter[0];
		
		if(uHdmiMode>1)
			uHdmiMode = 0;
		eHDMI_DVI = (uHdmiMode == 0)? HDMI : DVI;
		
		if(eHDMI_DVI == HDMI)
		{
			if(eTest == eTest_Manual)
			{
				UART_Printf("\n");
				UART_Printf("0. YCbCr444		1. RGB\n");
				UART_Printf("Select the HDMI Color Format: ");
				uColorFormat = UART_GetIntNum();
			}
			else
				uColorFormat = oPara.Test_Parameter[1];

			if(uColorFormat>1)
				uColorFormat = 0;
			eColorSpace = 	(uColorFormat == 0)? HDMI_CS_YCBCR444 : HDMI_CS_RGB;
		}	
		else
		{
			//For DVI
			eColorSpace = HDMI_CS_RGB;
		}	

		if(eTest == eTest_Manual)
		{
			UART_Printf("\n");
			UART_Printf("0. Range(BT601. 16~235)		1. Range(BT601. 0~255)	2. Range(BT709. 16~235)		3. Range(BT709. 0~255)\n");
			UART_Printf("Select the Color Value Range: ");
			uWideColor = UART_GetIntNum();
		}
		else
			uWideColor = oPara.Test_Parameter[5];
		
		if(uWideColor>3)
			uWideColor = 0;	
		if(eColorSpace == HDMI_CS_RGB)
		{
			eMxOutRgb = 	(uWideColor == 0)? RGB601_16_235 : 
						(uWideColor == 1)? RGB601_0_255 : 
						(uWideColor == 2)? RGB709_16_235 : RGB709_0_255 ;

			if( (eMxOutRgb == RGB601_0_255) || (eMxOutRgb == RGB709_0_255) )
				ePixelLimit = HDMI_FULL_RANGE;
			else
				ePixelLimit = HDMI_RGB_LIMIT_RANGE;
		}
		else
		{
			eMxOutRgb = 	(uWideColor == 0)? RGB601_16_235 : 
						(uWideColor == 1)? RGB601_0_255 : 
						(uWideColor == 2)? RGB709_16_235 : RGB709_0_255 ;
							
			ePixelLimit = (uWideColor == 0 ||uWideColor == 2 )? HDMI_YCBCR_LIMIT_RANGE : HDMI_FULL_RANGE;		
		}

	
		if(eTest == eTest_Manual)
		{
			UART_Printf("0. v720x480p_60Hz, HDMI_CD_24 \n");
			UART_Printf("1. v720x480p_60Hz, HDMI_CD_30 \n");	  
			UART_Printf("2. v720x480p_60Hz, HDMI_CD_36 \n");
			UART_Printf("\n");
			UART_Printf("3. v720x576p_50Hz, HDMI_CD_24 \n");
			UART_Printf("4. v720x576p_50Hz, HDMI_CD_30 \n");	  
			UART_Printf("5. v720x576p_50Hz, HDMI_CD_36 \n");
			UART_Printf("\n");
			UART_Printf("6. v1280x720p_60Hz, HDMI_CD_24 \n");
			UART_Printf("7. v1280x720p_60Hz, HDMI_CD_30 \n");	  
			UART_Printf("8. v1280x720p_60Hz, HDMI_CD_36 \n");
			UART_Printf("\n");
			UART_Printf("9.  v1280x720p_50Hz, HDMI_CD_24 \n");
			UART_Printf("10. v1280x720p_50Hz, HDMI_CD_30 \n");	  
			UART_Printf("11. v1280x720p_50Hz, HDMI_CD_36 \n");
			UART_Printf("\n");
			UART_Printf("12. v1920x1080i_60Hz, HDMI_CD_24 \n");
			UART_Printf("13. v1920x1080i_60Hz, HDMI_CD_30 \n");	  
			UART_Printf("14. v1920x1080i_60Hz, HDMI_CD_36 \n");
			UART_Printf("\n");
			UART_Printf("15. v1920x1080i_50Hz, HDMI_CD_24 \n");
			UART_Printf("16. v1920x1080i_50Hz, HDMI_CD_30 \n");	  
			UART_Printf("17. v1920x1080i_50Hz, HDMI_CD_36 \n");
			UART_Printf("\n");
			UART_Printf("18. v1920x1080p_60Hz, HDMI_CD_24 \n");
			UART_Printf("19. v1920x1080p_60Hz, HDMI_CD_30 \n");	  
			UART_Printf("20. v1920x1080p_60Hz, HDMI_CD_36 \n");
			UART_Printf("\n");
			UART_Printf("21. v1920x1080p_50Hz, HDMI_CD_24 \n");
			UART_Printf("22. v1920x1080p_50Hz, HDMI_CD_30 \n");	  
			UART_Printf("23. v1920x1080p_50Hz, HDMI_CD_36 \n");
			UART_Printf("\n");	
			UART_Printf("24. v1920x1080p_30Hz, HDMI_CD_24 \n");
			UART_Printf("25. v1920x1080p_30Hz, HDMI_CD_30 \n");	  
			UART_Printf("26. v1920x1080p_30Hz, HDMI_CD_36 \n");
			UART_Printf("\n");				
			UART_Printf("27. v1920x1080p_25Hz, HDMI_CD_24 \n");
			UART_Printf("28. v1920x1080p_25Hz, HDMI_CD_30 \n");	  
			UART_Printf("29. v1920x1080p_25Hz, HDMI_CD_36 \n");
			UART_Printf("\n");
		 
			UART_Printf("Select the HDMI Resolution(Press 'Enter' key to exit) : ");
			uHdmiMode = UART_GetIntNum();	
		}
		else
			uHdmiMode =oPara.Test_Parameter[2];
		
		uVpSrcAddr = CODEC_MEM_ST;
		uWaveBufAddr = uVpSrcAddr + HD1080_HSIZE*HD1080_VSIZE*2;
		uPcmBufAddr = uWaveBufAddr + WAVFILE_HEADER_SZ;
		
		if(uHdmiMode < 3)
		{
			if(uImgDownCheck != BMP_720x480)
			{
				#if (IMAGE_LOAD == LOADFILE_FROM_SD)
				{
					s32 sFail;
					u32 uFileReadSize;
					t_file_handler oFileHandler;
					
					sFail = FS_Open(pResolution_Image[BMP_720x480], &oFileHandler);
					if(sFail != 0)
					{
						UART_Printf("%s open fail\n", pResolution_Image[BMP_720x480]);
						return;
					}
					else
						UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_720x480]);
					
					FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
				}
				#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)
				LoadFromFile((const char *)pResolution_Image[BMP_720x480], uVpSrcAddr);	
				#endif
			}
			
			eImgSz = SD480;
			eScanMode = PROGRESSIVE;
			uImgDownCheck = BMP_720x480;
		}
		else if(uHdmiMode < 6)
		{
			if(uImgDownCheck != BMP_720x576)
			{
				#if (IMAGE_LOAD == LOADFILE_FROM_SD)
				{
					s32 sFail;
					u32 uFileReadSize;
					t_file_handler oFileHandler;
					
					sFail = FS_Open(pResolution_Image[BMP_720x576], &oFileHandler);
					if(sFail != 0)
					{
						UART_Printf("%s open fail\n", pResolution_Image[BMP_720x576]);
						return;
					}
					else
						UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_720x576]);
					
					FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
				}
				#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)				
				LoadFromFile((const char *)pResolution_Image[BMP_720x576], uVpSrcAddr);
				#endif
			}
			
			eImgSz = SD576;
			eScanMode = PROGRESSIVE;
			uImgDownCheck = BMP_720x576;
		}
		else if(uHdmiMode < 12)
		{
			if(uImgDownCheck != BMP_1280x720)
			{
				#if (IMAGE_LOAD == LOADFILE_FROM_SD)
				{
					s32 sFail;
					u32 uFileReadSize;
					t_file_handler oFileHandler;
					
					sFail = FS_Open(pResolution_Image[BMP_1280x720], &oFileHandler);
					if(sFail != 0)
					{
						UART_Printf("%s open fail\n", pResolution_Image[BMP_1280x720]);
						return;
					}
					else
						UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1280x720]);
					
					FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
				}
				#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)					
				LoadFromFile((const char *)pResolution_Image[BMP_1280x720], uVpSrcAddr);
				#endif
			}
							
			eImgSz = HD720;
			eScanMode = PROGRESSIVE;
			uImgDownCheck = BMP_1280x720;
		}
		else if(uHdmiMode < 18)
		{
			if(uImgDownCheck != BMP_1920x1080)
			{
				#if (IMAGE_LOAD == LOADFILE_FROM_SD)
				{
					s32 sFail;
					u32 uFileReadSize;
					t_file_handler oFileHandler;
					
					sFail = FS_Open(pResolution_Image[BMP_1920x1080], &oFileHandler);
					if(sFail != 0)
					{
						UART_Printf("%s open fail\n", pResolution_Image[BMP_1920x1080]);
						return;
					}
					else
						UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1920x1080]);
					
					FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
				}
				#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)					
				LoadFromFile((const char *)pResolution_Image[BMP_1920x1080], uVpSrcAddr);	
				#endif
			}
							
			eImgSz = HD1080;
			eScanMode = INTERLACED;
			uImgDownCheck = BMP_1920x1080;
		}	
		else if(uHdmiMode < 24)
		{
			if(uImgDownCheck != BMP_1920x1080)
			{
				#if (IMAGE_LOAD == LOADFILE_FROM_SD)
				{
					s32 sFail;
					u32 uFileReadSize;
					t_file_handler oFileHandler;
					
					sFail = FS_Open(pResolution_Image[BMP_1920x1080], &oFileHandler);
					if(sFail != 0)
					{
						UART_Printf("%s open fail\n", pResolution_Image[BMP_1920x1080]);
						return;
					}
					else
						UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1920x1080]);
					
					FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
				}
				#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)					
					LoadFromFile((const char *)pResolution_Image[BMP_1920x1080], uVpSrcAddr);	
				#endif
			}
							
			eImgSz = HD1080;
			eScanMode = PROGRESSIVE;
			uImgDownCheck = BMP_1920x1080;
		}
		else if(uHdmiMode < 27)
		{
			if(uImgDownCheck != BMP_1920x1080)
			{
				#if (IMAGE_LOAD == LOADFILE_FROM_SD)
				{
					s32 sFail;
					u32 uFileReadSize;
					t_file_handler oFileHandler;
					
					sFail = FS_Open(pResolution_Image[BMP_1920x1080], &oFileHandler);
					if(sFail != 0)
					{
						UART_Printf("%s open fail\n", pResolution_Image[BMP_1920x1080]);
						return;
					}
					else
						UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1920x1080]);
					
					FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
				}
				#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)					
					LoadFromFile((const char *)pResolution_Image[BMP_1920x1080], uVpSrcAddr);	
				#endif
			}
							
			eImgSz = HD1080;
			eScanMode = PROGRESSIVE;
			uImgDownCheck = BMP_1920x1080;
		}		
		else if(uHdmiMode < 30)
		{
			if(uImgDownCheck != BMP_1920x1080)
			{
				#if (IMAGE_LOAD == LOADFILE_FROM_SD)
				{
					s32 sFail;
					u32 uFileReadSize;
					t_file_handler oFileHandler;
					
					sFail = FS_Open(pResolution_Image[BMP_1920x1080], &oFileHandler);
					if(sFail != 0)
					{
						UART_Printf("%s open fail\n", pResolution_Image[BMP_1920x1080]);
						return;
					}
					else
						UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1920x1080]);
					
					FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
				}
				#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)					
				LoadFromFile((const char *)pResolution_Image[BMP_1920x1080], uVpSrcAddr);	
				#endif
			}
							
			eImgSz = HD1080;
			eScanMode = PROGRESSIVE;
			uImgDownCheck = BMP_1920x1080;
		}
		else
		{
			return TRUE;
		}
		
		// Audio File Download
#if (IMAGE_LOAD == LOADFILE_FROM_SD)
		if(uAudioDownCheck == 0)
		{
			s32 sFail;
			u32 uFileReadSize;
			t_file_handler oFileHandler;

			sFail = FS_Open(pAudio_Source[WAVE_BOA], &oFileHandler);
			if(sFail != 0)
			{
				UART_Printf("%s open fail\n", pAudio_Source[WAVE_BOA]);
				return;
			}
			else
				UART_Printf("Success to load image(%s)\n", pAudio_Source[WAVE_BOA]);
			
			FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uWaveBufAddr, &uFileReadSize);	

			uAudioDownCheck = 1;
		}			
#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)	
		if(uAudioDownCheck == 0)
		{
			LoadFromFile((const char *)pAudio_Source[WAVE_BOA], uWaveBufAddr);
			uAudioDownCheck = 1;
		}				
#endif
		
		// VP setting
		HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
		// Mixer setting
		MIXER_InitForDTv(eImgSz, eScanMode, eMxOutRgb);
		if(eColorSpace == HDMI_CS_RGB)
			MIXER_SetRGBColorFormat(MX_RGB888, eMxOutRgb);
		else
			MIXER_SetRGBColorFormat(MX_YUV444, eMxOutRgb);
		MIXER_SetVdWinOnOff(1);

		HDMI_SetMode(eHDMI_DVI);
		HDMI_SetColorSpace(eColorSpace);
		HDMI_SetPixelLimit(ePixelLimit); 
	 
		switch(uHdmiMode)
		{
			case 0 	:	HDMI_SetVideoMode(v720x480p_60Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_4_3);  
						break;
			case 1	:	HDMI_SetVideoMode(v720x480p_60Hz, HDMI_CD_30, HDMI_PIXEL_RATIO_4_3); 
						break;
			case 2	:	HDMI_SetVideoMode(v720x480p_60Hz, HDMI_CD_36, HDMI_PIXEL_RATIO_4_3); 
						break;
						
			case 3	:	HDMI_SetVideoMode(v720x576p_50Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_4_3);
						break;
			case 4	:	HDMI_SetVideoMode(v720x576p_50Hz, HDMI_CD_30, HDMI_PIXEL_RATIO_4_3);   	
						break;
			case 5	:	HDMI_SetVideoMode(v720x576p_50Hz, HDMI_CD_36, HDMI_PIXEL_RATIO_4_3); 
						break;	
						
			case 6	:	HDMI_SetVideoMode(v1280x720p_60Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_16_9);
						break;
			case 7	:	HDMI_SetVideoMode(v1280x720p_60Hz, HDMI_CD_30, HDMI_PIXEL_RATIO_16_9);
						break;
			case 8	:	HDMI_SetVideoMode(v1280x720p_60Hz, HDMI_CD_36, HDMI_PIXEL_RATIO_16_9);
						break;
						
			case 9	:	HDMI_SetVideoMode(v1280x720p_50Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_16_9);
						break;
			case 10	:	HDMI_SetVideoMode(v1280x720p_50Hz, HDMI_CD_30, HDMI_PIXEL_RATIO_16_9);
						break;
			case 11	:	HDMI_SetVideoMode(v1280x720p_50Hz, HDMI_CD_36, HDMI_PIXEL_RATIO_16_9);
						break;	
						
			case 12	:	HDMI_SetVideoMode(v1920x1080i_60Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_16_9);
						break;
			case 13	:	HDMI_SetVideoMode(v1920x1080i_60Hz, HDMI_CD_30, HDMI_PIXEL_RATIO_16_9);
						break;
			case 14	:	HDMI_SetVideoMode(v1920x1080i_60Hz, HDMI_CD_36, HDMI_PIXEL_RATIO_16_9);
						break;
						
			case 15	:	HDMI_SetVideoMode(v1920x1080i_50Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_16_9);
						break;
			case 16	:	HDMI_SetVideoMode(v1920x1080i_50Hz, HDMI_CD_30, HDMI_PIXEL_RATIO_16_9);
						break;
			case 17	:	HDMI_SetVideoMode(v1920x1080i_50Hz, HDMI_CD_36, HDMI_PIXEL_RATIO_16_9);
						break;
					
			case 18	:	HDMI_SetVideoMode(v1920x1080p_60Hz,HDMI_CD_24 ,HDMI_PIXEL_RATIO_16_9);
						break;
			case 19	:	HDMI_SetVideoMode(v1920x1080p_60Hz,HDMI_CD_30 ,HDMI_PIXEL_RATIO_16_9);
						break;
			case 20	:	HDMI_SetVideoMode(v1920x1080p_60Hz,HDMI_CD_36 ,HDMI_PIXEL_RATIO_16_9);
						break;
						
			case 21	:	HDMI_SetVideoMode(v1920x1080p_50Hz,HDMI_CD_24 ,HDMI_PIXEL_RATIO_16_9);
						break;
			case 22	:	HDMI_SetVideoMode(v1920x1080p_50Hz,HDMI_CD_30 ,HDMI_PIXEL_RATIO_16_9);
						break;
			case 23	:	HDMI_SetVideoMode(v1920x1080p_50Hz,HDMI_CD_36 ,HDMI_PIXEL_RATIO_16_9);
						break;

			case 24	:	HDMI_SetVideoMode(v1920x1080p_30Hz,HDMI_CD_24 ,HDMI_PIXEL_RATIO_16_9);
						break;
			case 25	:	HDMI_SetVideoMode(v1920x1080p_30Hz,HDMI_CD_30 ,HDMI_PIXEL_RATIO_16_9);
						break;
			case 26	:	HDMI_SetVideoMode(v1920x1080p_30Hz,HDMI_CD_36 ,HDMI_PIXEL_RATIO_16_9);
						break;

			case 27	:	HDMI_SetVideoMode(v1920x1080p_25Hz,HDMI_CD_24 ,HDMI_PIXEL_RATIO_16_9);
						break;
			case 28	:	HDMI_SetVideoMode(v1920x1080p_25Hz,HDMI_CD_30 ,HDMI_PIXEL_RATIO_16_9);
						break;
			case 29	:	HDMI_SetVideoMode(v1920x1080p_25Hz,HDMI_CD_36 ,HDMI_PIXEL_RATIO_16_9);
						break;
						
			default	: 	break;
		}

		if(ePixelLimit == HDMI_FULL_RANGE)
		{
			if(eMxOutRgb == RGB601_0_255)
			{
				HDMI_SetGamutMetadataColorSpace(HDMI_COLORIMETRY_ITU601);
				HDMI_SetExtendedColorimetry(HDMI_COLORIMETRY_EXTENDED_xvYCC601);	
			}
			else
			{
				HDMI_SetGamutMetadataColorSpace(HDMI_COLORIMETRY_ITU709);
				HDMI_SetExtendedColorimetry(HDMI_COLORIMETRY_EXTENDED_xvYCC709);
			}
			
			HDMI_SetColorimetry(HDMI_COLORIMETRY_EXTENDED);
			HDMI_EnableGamutMetadata(1);
		}
		else
		{
			HDMI_EnableGamutMetadata(0);
		}
	
#if 1
		// TV On
		VP_EnableIP(1);
		MIXER_StartProcessing();
		HDMI_Enable(TRUE);	
		HDMI_TG_OnOff(TRUE);

		UART_Printf("SRF read : 'r' key, SRF write : 'w' key\n");
		while(	((ucTxCheck = (u8)UART_GetKey()) == 'r') || (ucTxCheck == 'R') || 
			  	(ucTxCheck == 'w') || (ucTxCheck == 'W') ||(!ucTxCheck)) 
		{
			if((ucTxCheck == 'w') || (ucTxCheck == 'W'))
			{
				u32 uAddr, uData, uOnOff, uMoreWrite;

				uMoreWrite = true;
				
				UART_Printf("Do you want to off&on the HDMI : yes('y'),  no(other key)\n");
				uOnOff = UART_Getc();
				if(uOnOff == 'y')
				{
					VP_EnableIP(0);
					MIXER_StopProcessing();
					HDMI_Enable(FALSE);	
					HDMI_TG_OnOff(FALSE);	
				}

				while(uMoreWrite == true)
				{
					UART_Printf("Input Address to write: ");
					uAddr = (u32)UART_GetIntNum();
					UART_Printf("Input Data : ");
					uData = (u32)UART_GetIntNum();
					Outp32(uAddr, uData);
					UART_Printf("Verify : [0x%08x : 0x%08x]\n\n", uAddr, Inp32(uAddr));
					UART_Printf("Do you want to write any more? yes('y'), no(any key)\n");
					uMoreWrite = UART_Getc();

					if(uMoreWrite == 'y')
						uMoreWrite = true;
					else
						uMoreWrite = false;					
				}				
				
				if(uOnOff == 'y')
				{
					VP_EnableIP(1);
					MIXER_StartProcessing();
					HDMI_Enable(TRUE);	
					HDMI_TG_OnOff(TRUE);	
				}				
			}

			if((ucTxCheck == 'r') || (ucTxCheck == 'R'))
			{
				u32 uAddr;
				u32 uData;
				
				UART_Printf("Input Address to read: ");
				uAddr = (u32)UART_GetIntNum();

				UART_Printf("Read : [0x%08x : 0x%08x]\n\n", uAddr, Inp32(uAddr));
			}	
		}		
#if 0		
		while(!UART_GetKey())
		{
			SPDIF_CheckDMATransferDone();	
			SPDIF_StartPlayingPcmByDma(uPcmBufAddr, uPcmSize, PCM, uChannelType, uSampleRate, uBitsPerSample);
		}
#endif

		VP_EnableIP(0);
		MIXER_StopProcessing();
		HDMI_Enable(FALSE);	
		HDMI_TG_OnOff(FALSE);	
#else
		while(!UART_GetKey())	// On/Off test
		{
			VP_EnableIP(1);
			MIXER_StartProcessing();
			HDMI_Enable(TRUE);	
			HDMI_TG_OnOff(TRUE);

			DelayfrTimer(milli, 3000);

			VP_EnableIP(0);
			MIXER_StopProcessing();
			HDMI_Enable(FALSE);	
			HDMI_TG_OnOff(FALSE);
			
			DelayfrTimer(milli, 500);
		}

#endif
	}
	
	return TRUE;
}


u32 HDMIT_SimpleDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uResolution, uScanMode, uHdmiMode, uColorFormat, uBitPerColor, uWideColor;
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;
	HDMIMode eHDMI_DVI;
	VideoFormat eVideoFmt;
	ColorDepth eColorDepth;
	PixelAspectRatio ePixelRatio;
	ColorSpace eColorSpace;
	PixelLimit ePixelLimit;
	MX_RGB_FORMAT eMxOutRgb;
	
	UART_Printf("[HDMIT_SimpleDisplay]\n");

	if(eTest == eTest_Manual)
	{
		UART_Printf("\n");
		UART_Printf("0. HDMI		1.DVI \n");
		UART_Printf("Select the HDMI or DVI : ");
		uHdmiMode = UART_GetIntNum();
	}
	else
		uHdmiMode = oPara.Test_Parameter[0];
	
	if(uHdmiMode>1)
		uHdmiMode = 0;
	eHDMI_DVI = (uHdmiMode == 0)? HDMI : DVI;
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("\n");
		UART_Printf("0. 480 Resolution\n");
		UART_Printf("1. 576 Resolution\n");
		UART_Printf("2. 720 Resolution\n");
		UART_Printf("3. 1080 Resolution\n");
		UART_Printf("4. 1080 30p Resolution\n");
		UART_Printf("5. 1080 25p Resolution\n");
		UART_Printf("Select the Video Resolution : ");
		uResolution = UART_GetIntNum();
	}
	else
		uResolution = oPara.Test_Parameter[1];
	
	if(uResolution>5)
		uResolution = 0;
	eImgSz = 	(uResolution == 0)? SD480 :
				(uResolution == 1)? SD576:
				(uResolution == 2)? HD720 : HD1080;
	if(eImgSz != HD720)
	{
		if(eTest == eTest_Manual)
		{
			UART_Printf("\n");
			UART_Printf("0. PROGRESSIVE		1.INTERLACED \n");
			UART_Printf("Select the Scan Mode : ");
			uScanMode = UART_GetIntNum();
		}
		else
			uScanMode = oPara.Test_Parameter[2];
		
		if(uScanMode>1)
			uScanMode = 0;
		eScanMode = (uScanMode == 0)? PROGRESSIVE : INTERLACED;
	}
	else
		eScanMode = PROGRESSIVE;
#if 0	
	eVideoFmt = 	(eImgSz == HD1080)? ((eScanMode== PROGRESSIVE)? v1920x1080p_60Hz : v1920x1080i_60Hz) :
				(eImgSz == HD720)? 	v1280x720p_60Hz:
				(eImgSz == SD480)? 	((eScanMode== PROGRESSIVE)? v720x480p_60Hz : v720x480i_60Hz) :
									((eScanMode== PROGRESSIVE)? v720x576p_50Hz : v720x576i_50Hz);
#endif
	eVideoFmt = 	(eImgSz == HD1080)? ((eScanMode== PROGRESSIVE)? ((uResolution == 3)? v1920x1080p_60Hz : ((uResolution == 4)? v1920x1080p_30Hz : v1920x1080p_25Hz)) : v1920x1080i_60Hz) :
				(eImgSz == HD720)? 	v1280x720p_60Hz:
				(eImgSz == SD480)? 	((eScanMode== PROGRESSIVE)? v720x480p_60Hz : v720x480i_60Hz) :
									((eScanMode== PROGRESSIVE)? v720x576p_50Hz : v720x576i_50Hz);
									
	ePixelRatio = 	(eImgSz == HD1080)? HDMI_PIXEL_RATIO_16_9:
				(eImgSz == HD720)? 	HDMI_PIXEL_RATIO_16_9:
				(eImgSz == SD480)?	HDMI_PIXEL_RATIO_4_3: HDMI_PIXEL_RATIO_4_3;

	if(eHDMI_DVI == HDMI)
	{
		if(eTest == eTest_Manual)
		{
			UART_Printf("\n");
			UART_Printf("0. YCbCr444		1. RGB\n");
			UART_Printf("Select the HDMI Color Format: ");
			uColorFormat = UART_GetIntNum();
		}
		else
			uColorFormat = oPara.Test_Parameter[3];

		if(uColorFormat>1)
			uColorFormat = 0;

		eColorSpace = 	(uColorFormat == 0)? HDMI_CS_YCBCR444 : HDMI_CS_RGB;

		if(eTest == eTest_Manual)
		{				
			UART_Printf("\n");
			UART_Printf("0. 8bit		1. 10bit		2. 12bit \n");
			UART_Printf("Select the HDMI Bit Per Color : ");
			uBitPerColor = UART_GetIntNum();
		}
		else
			uBitPerColor = oPara.Test_Parameter[4];

		if(uBitPerColor>2)
			uBitPerColor = 0;

		eColorDepth = 	(uBitPerColor == 0)? HDMI_CD_24 :
						(uBitPerColor == 1)? HDMI_CD_30 : HDMI_CD_36 ;
	}	
	else
	{
		//For DVI
		eColorSpace = HDMI_CS_RGB;
		eColorDepth = HDMI_CD_24;
	}

	if(eTest == eTest_Manual)
	{
		UART_Printf("\n");
		UART_Printf("0. Range(BT601. 16~235)		1. Range(BT601. 0~255)	2. Range(BT709. 16~235)		3. Range(BT709. 0~255)\n");
		UART_Printf("Select the Color Value Range: ");
		uWideColor = UART_GetIntNum();
	}
	else
		uWideColor = oPara.Test_Parameter[5];
	
	if(uWideColor>3)
		uWideColor = 0;	
	if(eColorSpace == HDMI_CS_RGB)
	{
		eMxOutRgb = 	(uWideColor == 0)? RGB601_16_235 : 
					(uWideColor == 1)? RGB601_0_255 : 
					(uWideColor == 2)? RGB709_16_235 : RGB709_0_255 ;

		if( (eMxOutRgb == RGB601_0_255) || (eMxOutRgb == RGB709_0_255) )
			ePixelLimit = HDMI_FULL_RANGE;
		else
			ePixelLimit = HDMI_RGB_LIMIT_RANGE;
	}
	else
	{
		eMxOutRgb = 	(uWideColor == 0)? RGB601_16_235 : 
					(uWideColor == 1)? RGB601_0_255 : 
					(uWideColor == 2)? RGB709_16_235 : RGB709_0_255 ;
						
		ePixelLimit = (uWideColor == 0 ||uWideColor == 2 )? HDMI_YCBCR_LIMIT_RANGE : HDMI_FULL_RANGE;		
	}

	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	if(eTest == eTest_Manual)
	{
		UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
		if(UART_Getc() == 'y')
		{
			// Video layer Image download
			HDMIT_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eMxOutRgb);
			// Graphic layer Image drawing
			HDMIT_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr);
		}
	}
	else
	{
		if(oPara.Test_Parameter[6] == TRUE)
		{
			// Video layer Image download
			HDMIT_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, eMxOutRgb);
			// Graphic layer Image drawing
			HDMIT_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr);
		}	
		else
			FIMC_RunWith_CSC_YUVRange(eMxOutRgb);
	}
	//VP & Mixer Setting
	HDMIT_VPSettingForTest(uVpSrcAddr);
	HDMIT_MixerSettingForTest(uWin0StAddr, uWin1StAddr, eColorSpace, eMxOutRgb);
	
	HDMI_SetMode(eHDMI_DVI);
	HDMI_SetColorSpace(eColorSpace);
	HDMI_SetPixelLimit(ePixelLimit); 	
	HDMI_SetVideoMode(eVideoFmt, eColorDepth, ePixelRatio);
  
//	while(!UART_GetKey())
  	{
  		static u32 uCount = 1;
		
//		UART_Printf("Count : %d \n", uCount++);
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

//		DelayfrTimer(milli, 2000);
		
	if(eTest == eTest_Manual)
		UART_Getc();
	else
		UART_Getc();
		//DelayfrTimer(milli, 5000);
	
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
//		DelayfrTimer(milli, 1000);	
  	}
	return TRUE;
}


u32 HDMIT_AutoSimpleDisplay(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, j, k, l, m, n;
	oFunctionT_AutoVar oTestPara;
	u32 uResolutionSize, uScanModeSize, uHdmiModeSize, uColorSpaceSize, uColorDepthSize, uColorRangeSize;
	oAutoTest_Param HdmiMode[] = 	{	0,	"HDMI",
										1,	"DVI"
									};
	oAutoTest_Param Resolution[] = 	{	0,	"480 Resolution",
										1,	"576 Resolution",
										2,	"720 Resolution",
										3,	"1080 Resolution"										
									};
	oAutoTest_Param ScanMode[] = 	{	0,	"PROGRESSIVE",
										1,	"INTERLACED"
									};
	oAutoTest_Param ColorSpace[] = 	{	0,	"YCbCr444",
										1,	"RGB"
									};
	oAutoTest_Param ColorDepth[] = 	{	0,	"8bit",
										1,	"10bit",
										2,	"12bit"
									};	
	oAutoTest_Param ColorRange[] = 	{	0,	"Range(BT601. 16~235)",
										1,	"Range(BT601. 0~255)",
										2,	"Range(BT709. 16~235)",
										3, 	"Range(BT709. 0~255)"
									};		
	
	// Auto Test Parameter setting Value
	// oTestPara.Test_Parameter[0] : 	0. HDMI					1.DVI	
	// oTestPara.Test_Parameter[1] :  	0. 1080 Resolution			1. 720 Resolution			2. 480 Resolution		3. 576 Resolution
	// oTestPara.Test_Parameter[2] : 	0. PROGRESSIVE			1.INTERLACED
	// oTestPara.Test_Parameter[3] : 	0. YCbCr444				1. RGB
	// oTestPara.Test_Parameter[4] : 	0. 8bit					1. 10bit					2. 12bit
	// oTestPara.Test_Parameter[5] : 	0. Range(BT601. 16~235)	1. Range(BT601. 0~255)	2. Range(BT709. 16~235)	3. Range(BT709. 0~255)
	// oTestPara.Test_Parameter[6] : 	TRUE. Image Download		FALSE. No Image Download
	
	uHdmiModeSize = sizeof(HdmiMode)/8;	
	uResolutionSize = sizeof(Resolution)/8;
	uScanModeSize = sizeof(ScanMode)/8;
	uColorSpaceSize = sizeof(ColorSpace)/8;
	uColorDepthSize = sizeof(ColorDepth)/8;
	uColorRangeSize =  sizeof(ColorRange)/8;
	
	for(i=0 ; i<uHdmiModeSize ; i++)
		for(j=0 ; j<uResolutionSize ; j++)
		{
			oTestPara.Test_Parameter[6] = TRUE;
			
			for(k=0 ; k<uScanModeSize ; k++)
				for(l=0 ; l<uColorSpaceSize ; l++)
				{
					for(m=0 ; m<uColorDepthSize ; m++)
					{
						for(n=0 ; n<uColorRangeSize ; n++)
						{
							UART_Printf("=====================================\n");
							oTestPara.Test_Parameter[0] = HdmiMode[i].uInput;
							oTestPara.Test_Parameter[1] = Resolution[j].uInput;
							UART_Printf("HdmiMode : %s\n", HdmiMode[i].desc);							
							UART_Printf("Resolution : %s\n", Resolution[j].desc);

							oTestPara.Test_Parameter[2] = ScanMode[k].uInput;										
							UART_Printf("ScanMode : %s\n", ScanMode[k].desc);	
							
							if( 	(!strcmp((const char *)Resolution[j].desc, (const char *)"480 Resolution")) ||
								(!strcmp((const char *)Resolution[j].desc, (const char *)"576 Resolution")) ||
								(!strcmp((const char *)Resolution[j].desc, (const char *)"720 Resolution")) )		// if 480p, 576p, 720P
							{
								if(!strcmp((const char *)ScanMode[k].desc, (const char *)"INTERLACED"))		// if interaced
								{
									UART_Printf("==> Not Supported Mode\n");
									UART_Printf("=====================================\n");
									continue;
								}
							}
							
							oTestPara.Test_Parameter[3] = ColorSpace[l].uInput;
							oTestPara.Test_Parameter[4] = ColorDepth[m].uInput;
							UART_Printf("ColorSpace : %s\n", ColorSpace[l].desc);
							UART_Printf("ColorDepth : %s\n", ColorDepth[m].desc);	
								
							if(!strcmp((const char *)HdmiMode[i].desc, (const char *)"DVI"))		// if DVI
							{
								if(!strcmp((const char *)ColorSpace[l].desc, (const char *)"YCbCr444"))	//if YCbCr444
								{
									UART_Printf("==> Not Supported Mode\n");
									UART_Printf("=====================================\n");
									continue;
								}
								else
								{
									if(strcmp((const char *)ColorDepth[m].desc, (const char *)"8bit"))	// if not 8bit
									{
										UART_Printf("==> Not Supported Mode\n");
										UART_Printf("=====================================\n");
										continue;
									}									
								}							
							}
							
							oTestPara.Test_Parameter[5] = ColorRange[n].uInput;
							UART_Printf("ColorRange : %s\n", ColorRange[n].desc);
							
							HDMIT_SimpleDisplay(eTest_Auto, oTestPara);
							oTestPara.Test_Parameter[6] = FALSE;
						}
							
					}
				}
		}
		
	return TRUE;
}
 

u32 HDMIT_HDCP(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uRGBSrcAddr,uBMPSrcAddr, uWin0StAddr, uWin1StAddr;

	uVpSrcAddr = CODEC_MEM_ST;
	uRGBSrcAddr = uVpSrcAddr + 0x00800000;
	uBMPSrcAddr = uRGBSrcAddr + 0x00800000;
	uWin0StAddr = uBMPSrcAddr + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	eImgSz = SD480;
	eScanMode = PROGRESSIVE;
		
	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
	{
		// Video layer Image download
		HDMIT_DownImageForVP(eImgSz, uBMPSrcAddr, uRGBSrcAddr, uVpSrcAddr, RGB709_16_235);
		// Graphic layer Image drawing
		HDMIT_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr);
	}
	//VP & Mixer Setting
	HDMIT_VPSettingForTest(uVpSrcAddr);
	HDMIT_MixerSettingForTest(uWin0StAddr, uWin1StAddr, HDMI_CS_YCBCR444, RGB709_16_235);
	
	//HDMI Setting
	HDMI_SetMode(HDMI);
	HDMI_SetColorSpace(HDMI_CS_YCBCR444);
	HDMI_SetPixelLimit(HDMI_RGB_LIMIT_RANGE); 	
	HDMI_SetVideoMode(v720x480p_60Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_4_3);
  
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

	HDCP_Run();

	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
	
	return TRUE;
}


u32 HDMIT_EEDID(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	UART_Printf("[HDMIT_EEDID]\n");

	// read EDID
	if(ReadEDID(NUM_OF_RETRY) != OK)
	{
		UART_Printf("Error : fail to read the EDID: %s, %s\n",__FILE__,__LINE__);
		return FALSE;
	}
	else
	{
		UART_Printf("Pass : E-EDID Read\n");
	}

	return TRUE;
}


s32 HDMIT_CECPlay(u8 uLogicalAddr, u32 uPhyAddr)
{
    int size;
    unsigned char buffer[CEC_MAX_FRAME_SIZE];

    /* send "Image View On" */
    buffer[0] = (uLogicalAddr << 4) | 0; // TV logical address is "0"
    buffer[1] = CEC_OPCODE_IMAGE_VIEW_ON;
    size = 2;

    if (CEC_SendMessage(buffer, size) != size) {
        UART_Printf("CECSendMessage() failed!!!\n");
        return FALSE;
    }

    /* send "Active Source" */
    buffer[0] = (uLogicalAddr << 4) | CEC_MSG_BROADCAST;
    buffer[1] = CEC_OPCODE_ACTIVE_SOURCE;
    buffer[2] = (uPhyAddr >> 8) & 0xFF;
    buffer[3] = uPhyAddr & 0xFF;
    size = 4;

    if (CEC_SendMessage(buffer, size) != size) {
        UART_Printf("CECSendMessage() failed!!!\n");
        return 0;
    }

    return 1;
}


extern cec_state g_eCECRxStatus;
extern oCec_Rx_struct oCec_Rx;
u32 HDMIT_CEC(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, uPhyAddr;
	u8 uLogicalAddr, ucTxCheck;
	CECDeviceType eDevtype = CEC_DEVICE_PLAYER;
	
	UART_Printf("[HDMIT_CEC]\n");

	if(CEC_Init() != OK)
	{
		UART_Printf("Error : CEC_Init()\n");
		return FALSE;
	}
	
	CEC_Open();

	if(GetCECPhysicalAddr(&uPhyAddr) != OK)
	{
		UART_Printf("Error : GetCECPhysicalAddr()\n");
		return FALSE;
	}
	else
	{
		UART_Printf("Device physical address is %X.%X.%X.%X\n", (uPhyAddr & 0xF000) >> 12, (uPhyAddr & 0x0F00) >> 8,
          														(uPhyAddr & 0x00F0) >> 4, uPhyAddr & 0x000F);
	}
  
	uLogicalAddr = CEC_AllocLogicalAddress(uPhyAddr, eDevtype);
    	if (!uLogicalAddr) 
	{
		UART_Printf("CEC_AllocLogicalAddress() failed!!!\n");
		return FALSE;
   	 }	

	UART_Printf("\n");
	UART_Printf("Press 't' key to CEC TX\n");
	while(	((ucTxCheck = (u8)UART_GetKey()) == 't') || (ucTxCheck == 'T') || (ucTxCheck == 'd') || 
			(ucTxCheck == 'D') ||(ucTxCheck == 'r') || (ucTxCheck == 'R') ||(!ucTxCheck)) 
	{
		if((ucTxCheck == 't') || (ucTxCheck == 'T'))
		{
			u32 uTxSize;		
			u8 pTxBuf[CEC_MAX_FRAME_SIZE];			

			UART_Printf("\n");
			UART_Printf("CEC TX Data Input ('Enter' key to exit input)\n");
			UART_Printf("Header Data[0] : ");
			pTxBuf[0] = UART_GetIntNum();

			for(i=1 ; i<CEC_MAX_FRAME_SIZE ; i++)
			{
				UART_Printf("Data Block[%d]: ",i);
				pTxBuf[i] = UART_GetIntNum();

				if( (pTxBuf[i] == 0xff))
					break;
			}
			uTxSize = i;
			UART_Printf("TX Size = %d\n", uTxSize);
			
		       if (CEC_SendMessage(pTxBuf, uTxSize) != uTxSize) 
			{
				UART_Printf("CECSendMessage() failed!!!\n");
		       }
		} 
		
		if(g_eCECRxStatus == STATE_DONE)
		{
			u32 uRcvSize, uTxSize;
			u8 *pRxBuf;
			u8 ucSrcLogAddr, ucDstLogAddr, ucOpcode;
			u8 pTxBuf[CEC_MAX_FRAME_SIZE];

			g_eCECRxStatus = STATE_RX;
			uRcvSize = oCec_Rx.size;
			pRxBuf = oCec_Rx.buffer;
			
			if(uRcvSize == 0)	// No data available
				continue;
			if(uRcvSize == 1)	// Polling message
			{
				UART_Printf("### Polling message\n");
				continue;
			}
			
			ucSrcLogAddr = pRxBuf[0]>>4;
			if( ucSrcLogAddr == uLogicalAddr)	// Ignore messages with src address == logical address
				continue;

			ucOpcode = pRxBuf[1];

		       if (CEC_IgnoreMessage(ucOpcode, ucSrcLogAddr)) 
			{
		            UART_Printf("### ignore message coming from address 15 (unregistered)\n");
		            continue;
        		}

			if (!CEC_CheckMessageSize(ucOpcode, uRcvSize)) 
			{
				UART_Printf("### invalid message size ###\n");
				continue;
			}

			/* check if message broadcasted/directly addressed */
			if (!CEC_CheckMessageMode(ucOpcode, (pRxBuf[0] & 0x0F) == CEC_MSG_BROADCAST ? 1 : 0)) 
			{
				UART_Printf("### invalid message mode (directly addressed/broadcast) ###\n");
				continue;
			}
			
			ucDstLogAddr = ucSrcLogAddr;

			switch (ucOpcode) 
			{
				case CEC_OPCODE_GIVE_PHYSICAL_ADDRESS:
						UART_Printf("[CEC_OPCODE_GIVE_PHYSICAL_ADDRESS]\n");
						/* responce with "Report Physical Address" */
						pTxBuf[0] = (uLogicalAddr << 4) | CEC_MSG_BROADCAST;
						pTxBuf[1] = CEC_OPCODE_REPORT_PHYSICAL_ADDRESS;
						pTxBuf[2] = (uPhyAddr >> 8) & 0xFF;
						pTxBuf[3] = uPhyAddr & 0xFF;
						pTxBuf[4] = eDevtype;
						uTxSize = 5;
						UART_Printf("TX : [CEC_OPCODE_REPORT_PHYSICAL_ADDRESS]\n");
						break;

				case CEC_OPCODE_SET_MENU_LANGUAGE:
						UART_Printf("[CEC_OPCODE_SET_MENU_LANGUAGE]\n");
						UART_Printf("[Language] : 0x%06x\n", (pRxBuf[4]<<16)|(pRxBuf[3]<<8)|pRxBuf[2] );
						continue;

				case CEC_OPCODE_REPORT_PHYSICAL_ADDRESS:// TV
						UART_Printf("[CEC_OPCODE_REPORT_PHYSICAL_ADDRESS]\n");
						UART_Printf("[Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						UART_Printf("[Device Type] : 0x%02x\n", pRxBuf[4]);
						continue;
						
				case CEC_OPCODE_ACTIVE_SOURCE:        // TV, CEC Switches
						UART_Printf("[CEC_OPCODE_ACTIVE_SOURCE]\n");
						UART_Printf("[Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						continue;
						
				case CEC_OPCODE_ROUTING_CHANGE:        // CEC Switches
						UART_Printf("[CEC_OPCODE_ROUTING_CHANGE]\n");
						UART_Printf("[Original Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						UART_Printf("[New Physical Address] : 0x%04x\n", (pRxBuf[5]<<8) | pRxBuf[4]);
						continue;
						
				case CEC_OPCODE_ROUTING_INFORMATION:    // CEC Switches
						UART_Printf("[CEC_OPCODE_ROUTING_INFORMATION]\n");
						UART_Printf("[Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						continue;	
						
				case CEC_OPCODE_SET_STREAM_PATH:    // CEC Switches
						UART_Printf("[CEC_OPCODE_SET_STREAM_PATH]\n");
						UART_Printf("[Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						continue;
						
				case CEC_OPCODE_SET_SYSTEM_AUDIO_MODE:    // TV
						UART_Printf("[CEC_OPCODE_SET_SYSTEM_AUDIO_MODE]\n");
						continue;
						
				case CEC_OPCODE_DEVICE_VENDOR_ID:    // ???
						UART_Printf("[CEC_OPCODE_DEVICE_VENDOR_ID]\n");
						UART_Printf("[Vendor ID] : 0x%06x\n", (pRxBuf[4]<<16) | (pRxBuf[3]<<8) | pRxBuf[2]);
						continue;

				case CEC_OPCODE_DECK_CONTROL:
						///if (pRxBuf[2] == CEC_DECK_CONTROL_MODE_STOP) 
						///{
						///	UART_Printf("### DECK CONTROL : STOP ###\n");
						///}
						UART_Printf("[CEC_OPCODE_DECK_CONTROL]\n");
						UART_Printf("[Deck Control Mode] : 0x%02x\n", pRxBuf[2]);
						continue;

				case CEC_OPCODE_PLAY:
						///if (pRxBuf[2] == CEC_PLAY_MODE_PLAY_FORWARD) 
						///{
						///	UART_Printf("### PLAY MODE : PLAY ###\n");
						///}
						UART_Printf("[CEC_OPCODE_PLAY]\n");
						UART_Printf("[Play Mode] : 0x%02x\n", pRxBuf[2]);
						continue;

				case CEC_OPCODE_STANDBY:
						UART_Printf("[CEC_OPCODE_STANDBY] : Switch the device into standby\n");
						continue;

				case CEC_OPCODE_REQUEST_ACTIVE_SOURCE:
						UART_Printf("[CEC_OPCODE_REQUEST_ACTIVE_SOURCE]\n");
						/* responce with "Active Source" */
						pTxBuf[0] = (uLogicalAddr << 4) | CEC_MSG_BROADCAST;
						pTxBuf[1] = CEC_OPCODE_ACTIVE_SOURCE;
						pTxBuf[2] = (uPhyAddr >> 8) & 0xFF;
						pTxBuf[3] = uPhyAddr & 0xFF;
						uTxSize = 4;
						UART_Printf("Tx : [CEC_OPCODE_ACTIVE_SOURCE]\n");
						break;
						
				case CEC_OPCODE_GET_DEVICE_VENDOR_ID:
						UART_Printf("[CEC_OPCODE_GET_DEVICE_VENDOR_ID]\n");
						/* responce with "Active Source" */
						pTxBuf[0] = (uLogicalAddr << 4) | CEC_MSG_BROADCAST;
						pTxBuf[1] = CEC_OPCODE_DEVICE_VENDOR_ID;
						pTxBuf[2] = 0x00;
						pTxBuf[3] = 0x00;
						pTxBuf[4] = 0xF0;
						uTxSize = 5;
						UART_Printf("Tx : [CEC_OPCODE_DEVICE_VENDOR_ID]\n");
						break;
						
				case CEC_OPCODE_GIVE_OSD_NAME:
						UART_Printf("[CEC_OPCODE_GIVE_OSD_NAME]\n");
						/* responce with "Active Source" */
						pTxBuf[0] = (uLogicalAddr << 4) | ((pRxBuf[0]>>4)&0xf);
						pTxBuf[1] = CEC_OPCODE_SET_OSD_NAME;
						pTxBuf[2] = 0x02;
						uTxSize = 3;
						UART_Printf("Tx : [CEC_OPCODE_SET_OSD_NAME]\n");
						break;
						
				default:
						UART_Printf("[Not Supported Feature]\n");
						UART_Printf("[OpCode] : 0x%02x\n", pRxBuf[1]);
						
						for(i=0 ; i<uRcvSize-2 ; i++);
							UART_Printf("[Data%] : 0x%02x\n", i, pRxBuf[i+2]);
						
						/* send "Feature Abort" */
						pTxBuf[0] = (uLogicalAddr << 4) | ucDstLogAddr;
						pTxBuf[1] = CEC_OPCODE_FEATURE_ABORT;
						//rb1004..modify
						///pTxBuf[2] = CEC_OPCODE_ABORT;
						pTxBuf[2] = ucOpcode;
						pTxBuf[3] = 0x04; // "refused"
						uTxSize = 4;
						UART_Printf("Tx : [CEC_OPCODE_FEATURE_ABORT]\n");						
			}	
			
		       if (CEC_SendMessage(pTxBuf, uTxSize) != uTxSize) 
			{
				UART_Printf("CECSendMessage() failed!!!\n");
		       }
		}
	}

	CEC_Close();

	return TRUE;
}


u32 HDMIT_InitIP(void);
u32 HDMIT_CEC_WakeUp(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i, uPhyAddr;
	u8 uLogicalAddr, ucTxCheck;
	CECDeviceType eDevtype = CEC_DEVICE_PLAYER;

	UART_Printf("[HDMIT_CEC_WakeUp]\n");
 
	if(CEC_Init() != OK)
	{
		UART_Printf("Error : CEC_Init()\n");
		return FALSE;
	}
 
	CEC_Open();

	if(GetCECPhysicalAddr(&uPhyAddr) != OK)
	{
		UART_Printf("Error : GetCECPhysicalAddr()\n");
		return FALSE;
	}
	else
	{
		UART_Printf("Device physical address is %X.%X.%X.%X\n", (uPhyAddr & 0xF000) >> 12, (uPhyAddr & 0x0F00) >> 8,
          														(uPhyAddr & 0x00F0) >> 4, uPhyAddr & 0x000F);
	}
  
	uLogicalAddr = CEC_AllocLogicalAddress(uPhyAddr, eDevtype);
    	if (!uLogicalAddr) 
	{
		UART_Printf("CEC_AllocLogicalAddress() failed!!!\n");
		return FALSE;
   	 }	

	UART_Printf("\n");
	UART_Printf("Press 't' key to CEC TX, and press 'p'key to enter power mode\n");
	while(((ucTxCheck = (u8)UART_GetKey()) == 't') || (ucTxCheck == 'T') ||  (ucTxCheck == 'p') || (!ucTxCheck)) 
	{
		if((ucTxCheck == 't') || (ucTxCheck == 'T'))
		{
			u32 uTxSize;		
			u8 pTxBuf[CEC_MAX_FRAME_SIZE];			

			UART_Printf("\n");
			UART_Printf("CEC TX Data Input ('Enter' key to exit input)\n");
			UART_Printf("Header Data[0] : ");
			pTxBuf[0] = UART_GetIntNum();

			for(i=1 ; i<CEC_MAX_FRAME_SIZE ; i++)
			{
				UART_Printf("Data Block[%d]: ",i);
				pTxBuf[i] = UART_GetIntNum();

				if( (pTxBuf[i] == 0xff))
					break;
			}
			uTxSize = i;
			UART_Printf("TX Size = %d\n", uTxSize);
			
		       if (CEC_SendMessage(pTxBuf, uTxSize) != uTxSize) 
			{
				UART_Printf("CECSendMessage() failed!!!\n");
		       }
		}

// test for silicon
#if 1
		if(ucTxCheck == 'p') 
		{
			u32 uPowerMode;

			UART_Printf("Select Test mode : 1.Idle(D), 2.DeepIdle, 3.Stop, 4.DeepStop, 5.Sleep\n");
			uPowerMode = UART_GetIntNum();
			if( (uPowerMode > 5) || (uPowerMode == 0) )
				uPowerMode = 1;
			SYSCT_TestSimplePowerMode_Temp(uPowerMode);
			SYSC_ReleaseRetentionIO(eRET_BLOCK_ALL); // release retention all for UART debug, GPIOs, ...	

			if(uPowerMode == 3)		//Stop mode : VIC block off
				INTC_Enable(NUM_CEC);
			
			DelayfrTimer(milli, 500);
			UART_Printf("Wakeup!\n");
//			CEC_EnableRx();
		}
#endif		
		if(g_eCECRxStatus == STATE_DONE)
		{
			u32 uRcvSize, uTxSize;
			u8 *pRxBuf;
			u8 ucSrcLogAddr, ucDstLogAddr, ucOpcode;
			u8 pTxBuf[CEC_MAX_FRAME_SIZE];

			g_eCECRxStatus = STATE_RX;
			uRcvSize = oCec_Rx.size;
			pRxBuf = oCec_Rx.buffer;
			
			if(uRcvSize == 0)	// No data available
				continue;
			if(uRcvSize == 1)	// Polling message
			{
				UART_Printf("### Polling message\n");
				continue;
			}
			
			ucSrcLogAddr = pRxBuf[0]>>4;
			if( ucSrcLogAddr == uLogicalAddr)	// Ignore messages with src address == logical address
				continue;

			ucOpcode = pRxBuf[1];

		       if (CEC_IgnoreMessage(ucOpcode, ucSrcLogAddr)) 
			{
		            UART_Printf("### ignore message coming from address 15 (unregistered)\n");
		            continue;
        		}

			if (!CEC_CheckMessageSize(ucOpcode, uRcvSize)) 
			{
				UART_Printf("### invalid message size ###\n");
				continue;
			}

			/* check if message broadcasted/directly addressed */
			if (!CEC_CheckMessageMode(ucOpcode, (pRxBuf[0] & 0x0F) == CEC_MSG_BROADCAST ? 1 : 0)) 
			{
				UART_Printf("### invalid message mode (directly addressed/broadcast) ###\n");
				continue;
			}
			
			ucDstLogAddr = ucSrcLogAddr;

			switch (ucOpcode) 
			{
				case CEC_OPCODE_GIVE_PHYSICAL_ADDRESS:
						UART_Printf("[CEC_OPCODE_GIVE_PHYSICAL_ADDRESS]\n");
						/* responce with "Report Physical Address" */
						pTxBuf[0] = (uLogicalAddr << 4) | CEC_MSG_BROADCAST;
						pTxBuf[1] = CEC_OPCODE_REPORT_PHYSICAL_ADDRESS;
						pTxBuf[2] = (uPhyAddr >> 8) & 0xFF;
						pTxBuf[3] = uPhyAddr & 0xFF;
						pTxBuf[4] = eDevtype;
						uTxSize = 5;
						UART_Printf("TX : [CEC_OPCODE_REPORT_PHYSICAL_ADDRESS]\n");
						break;

				case CEC_OPCODE_SET_MENU_LANGUAGE:
						UART_Printf("[CEC_OPCODE_SET_MENU_LANGUAGE]\n");
						UART_Printf("[Language] : 0x%06x\n", (pRxBuf[4]<<16)|(pRxBuf[3]<<8)|pRxBuf[2] );
						continue;

				case CEC_OPCODE_REPORT_PHYSICAL_ADDRESS:// TV
						UART_Printf("[CEC_OPCODE_REPORT_PHYSICAL_ADDRESS]\n");
						UART_Printf("[Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						UART_Printf("[Device Type] : 0x%02x\n", pRxBuf[4]);
						continue;
						
				case CEC_OPCODE_ACTIVE_SOURCE:        // TV, CEC Switches
						UART_Printf("[CEC_OPCODE_ACTIVE_SOURCE]\n");
						UART_Printf("[Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						continue;
						
				case CEC_OPCODE_ROUTING_CHANGE:        // CEC Switches
						UART_Printf("[CEC_OPCODE_ROUTING_CHANGE]\n");
						UART_Printf("[Original Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						UART_Printf("[New Physical Address] : 0x%04x\n", (pRxBuf[5]<<8) | pRxBuf[4]);
						continue;
						
				case CEC_OPCODE_ROUTING_INFORMATION:    // CEC Switches
						UART_Printf("[CEC_OPCODE_ROUTING_INFORMATION]\n");
						UART_Printf("[Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						continue;	
						
				case CEC_OPCODE_SET_STREAM_PATH:    // CEC Switches
						UART_Printf("[CEC_OPCODE_SET_STREAM_PATH]\n");
						UART_Printf("[Physical Address] : 0x%04x\n", (pRxBuf[3]<<8) | pRxBuf[2]);
						continue;
						
				case CEC_OPCODE_SET_SYSTEM_AUDIO_MODE:    // TV
						UART_Printf("[CEC_OPCODE_SET_SYSTEM_AUDIO_MODE]\n");
						continue;
						
				case CEC_OPCODE_DEVICE_VENDOR_ID:    // ???
						UART_Printf("[CEC_OPCODE_DEVICE_VENDOR_ID]\n");
						UART_Printf("[Vendor ID] : 0x%06x\n", (pRxBuf[4]<<16) | (pRxBuf[3]<<8) | pRxBuf[2]);
						continue;

				case CEC_OPCODE_DECK_CONTROL:
						///if (pRxBuf[2] == CEC_DECK_CONTROL_MODE_STOP) 
						///{
						///	UART_Printf("### DECK CONTROL : STOP ###\n");
						///}
						UART_Printf("[CEC_OPCODE_DECK_CONTROL]\n");
						UART_Printf("[Deck Control Mode] : 0x%02x\n", pRxBuf[2]);
						continue;

				case CEC_OPCODE_PLAY:
						///if (pRxBuf[2] == CEC_PLAY_MODE_PLAY_FORWARD) 
						///{
						///	UART_Printf("### PLAY MODE : PLAY ###\n");
						///}
						UART_Printf("[CEC_OPCODE_PLAY]\n");
						UART_Printf("[Play Mode] : 0x%02x\n", pRxBuf[2]);
						continue;

				case CEC_OPCODE_STANDBY:
						UART_Printf("[CEC_OPCODE_STANDBY] : Switch the device into standby\n");
						continue;

				case CEC_OPCODE_REQUEST_ACTIVE_SOURCE:
						UART_Printf("[CEC_OPCODE_REQUEST_ACTIVE_SOURCE]\n");
						/* responce with "Active Source" */
						pTxBuf[0] = (uLogicalAddr << 4) | CEC_MSG_BROADCAST;
						pTxBuf[1] = CEC_OPCODE_ACTIVE_SOURCE;
						pTxBuf[2] = (uPhyAddr >> 8) & 0xFF;
						pTxBuf[3] = uPhyAddr & 0xFF;
						uTxSize = 4;
						UART_Printf("Tx : [CEC_OPCODE_ACTIVE_SOURCE]\n");
						break;

				default:
						UART_Printf("[Not Supported Feature]\n");
						UART_Printf("[OpCode] : 0x%02x\n", pRxBuf[1]);
						
						for(i=0 ; i<uRcvSize-2 ; i++);
							UART_Printf("[Data%] : 0x%02x\n", i, pRxBuf[i+2]);
						
						/* send "Feature Abort" */
						pTxBuf[0] = (uLogicalAddr << 4) | ucDstLogAddr;
						pTxBuf[1] = CEC_OPCODE_FEATURE_ABORT;
						//rb1004..modify
						///pTxBuf[2] = CEC_OPCODE_ABORT;
						pTxBuf[2] = ucOpcode;
						pTxBuf[3] = 0x04; // "refused"
						uTxSize = 4;
						UART_Printf("Tx : [CEC_OPCODE_FEATURE_ABORT]\n");						
			}	
			
		       if (CEC_SendMessage(pTxBuf, uTxSize) != uTxSize) 
			{
				UART_Printf("CECSendMessage() failed!!!\n");
		       }
		}
	}
	ResetEDID();
	
	return TRUE;
}


u32 HDMIT_PHY(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u8 *ucTemp = 0;
	u32 uResolution, uScanMode, uBitPerColor;
	VideoFormat eVideoFmt;
	ColorDepth eColorDepth;
	
	UART_Printf("[HDMIT_PHY]\n");

	while((ucTemp != "q") && (ucTemp != "Q"))
	{
		UART_Printf("\n");
		UART_Printf("0. 1080 Resolution		1. 720 Resolution	2. 480 Resolution	3. 576 Resolution \n");
		UART_Printf("Select the Video Resolution : ");
		uResolution = UART_GetIntNum();
		
		if(uResolution>3)
			uResolution = 0;
		eImgSz = 	(uResolution == 0)? HD1080 :
					(uResolution == 1)? HD720:
					(uResolution == 2)? SD480 : SD576;

		UART_Printf("\n");
		UART_Printf("0. PROGRESSIVE		1.INTERLACED \n");
		UART_Printf("Select the Scan Mode : ");
		uScanMode = UART_GetIntNum();
			
		if(uScanMode>1)
			uScanMode = 0;
		eScanMode = (uScanMode == 0)? PROGRESSIVE : INTERLACED;
							
		eVideoFmt = 	(eImgSz == HD1080)? ((eScanMode== PROGRESSIVE)? v1920x1080p_60Hz : v1920x1080i_60Hz) :
					(eImgSz == HD720)? 	v1280x720p_60Hz:
					(eImgSz == SD480)? 	((eScanMode== PROGRESSIVE)? v720x480p_60Hz : v720x480i_60Hz) :
										((eScanMode== PROGRESSIVE)? v720x576p_50Hz : v720x576i_50Hz);
					
		UART_Printf("\n");
		UART_Printf("0. 8bit		1. 10bit		2. 12bit \n");
		UART_Printf("Select the HDMI Bit Per Color : ");
		uBitPerColor = UART_GetIntNum();

		if(uBitPerColor>2)
			uBitPerColor = 0;

		eColorDepth = 	(uBitPerColor == 0)? HDMI_CD_24 :
						(uBitPerColor == 1)? HDMI_CD_30 : HDMI_CD_36 ;
										
		if (HDMI_SetPhyFreq(eVideoFmt, eColorDepth) == ERROR)
		{
			UART_Printf("PHYConfig() failed.\n");
		}
		else			
			UART_Printf("HDMI PHY Setting is done\n");

		UART_Printf("\n");
		UART_Printf("Press 'q' key to exit\n");
		*ucTemp = (u8)UART_Getc();
	}
	
	//return to default
	UART_Printf("HDMI PHY Default Setting\n");
	HDMI_SetPhyFreq(v720x480p_60Hz, HDMI_CD_24);
	
	return OK;
}

#if 0
u32 HDMIT_SPDIF_Audio(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uHdmiMode, uColorFormat;
	u32 uWaveBufAddr, uPcmBufAddr;
	u32 uChannelType, uSampleRate, uBitsPerSample;
	static u32 uImgDownCheck=0xff;
	HDMIMode eHDMI_DVI;
	ColorSpace eColorSpace;
	
	UART_Printf("[HDMIT_SPDIF_Audio]\n");

	SPDIF_SetGpio(1);
	TZPC_Init();	
	
	eHDMI_DVI = HDMI;
	eColorSpace = HDMI_CS_YCBCR444;

	uVpSrcAddr = CODEC_MEM_ST;	
	uWaveBufAddr = uVpSrcAddr + 0x01000000;
	uPcmBufAddr = uWaveBufAddr + WAVFILE_HEADER_SZ;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
	{
		#if (IMAGE_LOAD == LOADFILE_FROM_SD)
		{
			s32 sFail;
			u32 uFileReadSize;
			t_file_handler oFileHandler;
			
			sFail = FS_Open(pResolution_Image[BMP_1280x720], &oFileHandler);
			if(sFail != 0)
			{
				UART_Printf("%s open fail\n", pResolution_Image[BMP_1280x720]);
				return;
			}
			else
				UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1280x720]);
			
			FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	

			sFail = FS_Open(pAudio_Source[WAVE_BOA], &oFileHandler);
			if(sFail != 0)
			{
				UART_Printf("%s open fail\n", pAudio_Source[WAVE_BOA]);
				return;
			}
			else
				UART_Printf("Success to load image(%s)\n", pAudio_Source[WAVE_BOA]);
			
			FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uWaveBufAddr, &uFileReadSize);				
		}
		#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)			
		LoadFromFile((const char *)pAudio_Source[WAVE_BOA], uWaveBufAddr);
			LoadFromFile((const char *)pResolution_Image[BMP_1280x720], uVpSrcAddr);	
		#endif
	}
	eImgSz = HD720;
	eScanMode = PROGRESSIVE;
	
	// VP setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetRGBColorFormat(MX_YUV444, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);

	HDMI_SetMode(eHDMI_DVI);
	HDMI_SetColorSpace(eColorSpace);
	HDMI_SetVideoMode(v1280x720p_60Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_4_3);  
	
	WAVEFILE_ParseHeader(uWaveBufAddr, &uPcmSize, &uChannelType, &uSampleRate, &uBitsPerSample);
	SPDIF_StartPlayingPcmByDma(uPcmBufAddr, uPcmSize, PCM, uChannelType, uSampleRate, uBitsPerSample);
	
	HDMI_SetAudioInputPort(SPDIF_PORT);
	HDMI_SetAudioStreamType(ASP, SF_48KHZ);
	HDMI_SetAudioNumberOfChannels(CH_2);
	HDMI_SetChannelAllocation(0x00);
	
	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);

#if 1
	SPDIF_CheckDMATransferDone();	
	SPDIF_TurnOffSpdifoutClock();
#else
	while(!UART_GetKey())
		SPDIF_StartPlayingPcmByCpu(uPcmBufAddr, uPcmSize, PCM, uChannelType, uSampleRate, uBitsPerSample);
#endif

	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_CloseAudioInputPort(SPDIF_PORT);	
	HDMI_Enable(FALSE);	
	HDMI_TG_OnOff(FALSE);	
	
	return TRUE;
}


u32 HDMIT_I2S_Audio(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 uVpSrcAddr, uHdmiMode, uColorFormat;
	u32 uWaveBufAddr, uPcmBufAddr;
	u32 uChannelType, uSampleRate, uBitsPerSample;
	HDMIMode eHDMI_DVI;
	ColorSpace eColorSpace;
	
	UART_Printf("[HDMIT_SPDIF_Audio]\n");
	
	eHDMI_DVI = HDMI;
	eColorSpace = HDMI_CS_YCBCR444;

	uVpSrcAddr = CODEC_MEM_ST;	
	uWaveBufAddr = uVpSrcAddr + 0x01000000;
	uPcmBufAddr = uWaveBufAddr + WAVFILE_HEADER_SZ;

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
	{
		#if (IMAGE_LOAD == LOADFILE_FROM_SD)
		{
			s32 sFail;
			u32 uFileReadSize;
			t_file_handler oFileHandler;
			
			sFail = FS_Open(pResolution_Image[BMP_1280x720], &oFileHandler);
			if(sFail != 0)
			{
				UART_Printf("%s open fail\n", pResolution_Image[BMP_1280x720]);
				return;
			}
			else
				UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1280x720]);
			
			FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	

			sFail = FS_Open(pAudio_Source[WAVE_BOA], &oFileHandler);
			if(sFail != 0)
			{
				UART_Printf("%s open fail\n", pAudio_Source[WAVE_BOA]);
				return;
			}
			else
				UART_Printf("Success to load image(%s)\n", pAudio_Source[WAVE_BOA]);
			
			FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uWaveBufAddr, &uFileReadSize);				
		}
		#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)		
		LoadFromFile((const char *)pAudio_Source[WAVE_BOA], uWaveBufAddr);
			LoadFromFile((const char *)pResolution_Image[BMP_1280x720], uVpSrcAddr);	
		#endif
	}
	eImgSz = HD720;
	eScanMode = PROGRESSIVE;
	
	// VP setting
	HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
	// Mixer setting
	MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
	MIXER_SetRGBColorFormat(MX_YUV444, RGB709_0_255);
	MIXER_SetVdWinOnOff(1);

	HDMI_SetMode(eHDMI_DVI);
	HDMI_SetColorSpace(eColorSpace);
	HDMI_SetVideoMode(v1280x720p_60Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_4_3);  
	
	WAVEFILE_ParseHeader(uWaveBufAddr, &uPcmSize, &uChannelType, &uSampleRate, &uBitsPerSample);
	UART_Printf("\nChannelType: %d\n", uChannelType);
	UART_Printf("SampleRate: %d\n", uSampleRate);
	UART_Printf("BitsPerSample: %d\n", uBitsPerSample);
	UART_Printf("PcmSize: %d\n", uPcmSize);
	
	I2S_InitIp(TX_MODE, EXTERNAL_MASTER, uChannelType, uSampleRate, uBitsPerSample, SPEAKER_MODE, eSerialDataFmt, uCdclk, AUDIO_WM8580, &oI2s0);	

	SPDIF_SetGpio(1);
        // pin sel to I2S
       HDMI_SetAudioInputPort(I2S_PORT);
       // 48kHz
       HDMI_SetAudioStreamType(ASP, SF_48KHZ);
       // 2ch
       HDMI_SetAudioNumberOfChannels(CH_2);
       HDMI_SetChannelAllocation(0x00);
       
       // set audio stream information
       CUVSetCodingType(CUV_LPCM);
       CUVSetCopyrighted(TRUE);
       CUVSetEquipmentType(CUV_CATEGORY_GENERAL, 0);
       CUVSetChannelNumber(CUV_CH_UNDEFINED);
       CUVSetSourceNumber(CUV_SRC_UNDEFINED);
       CUVSetClockAccuracy(CUV_CA_LEVEL_I);
       CUVSetOriginalSamplingFrequency(I2S_CH_ST_4_OSF_44KHZ);
	CUVSetSampleWordLength(I2S_CH_ST_4_WL_24_24);

       CUVUpdate(); 

	// TV On
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);
	
	while(!UART_GetKey())
		I2S_PlayByCpuForHW(uPcmBufAddr, uPcmSize, uChannelType, &oI2s0);

	UART_Printf("Press any key to exit\n");
	UART_Getc();

	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_CloseAudioInputPort(I2S_PORT);		
	HDMI_Enable(FALSE);	
	HDMI_TG_OnOff(FALSE);	
	
	return TRUE;
}
#endif

u32 HDMIT_BlockPowerOnOff(void)
{
	u32 uVpSrcAddr, uHdmiMode, uColorFormat;
	u32 uWin0StAddr, uWin1StAddr;
	HDMIMode eHDMI_DVI;
	ColorSpace eColorSpace;
	s32 uRanOffset;
	u32 uCount=1;
		
	UART_Printf("[HDMIT_BlockPowerOnOff]\n");
	
	eHDMI_DVI = HDMI;
	eColorSpace = HDMI_CS_YCBCR444;

	uVpSrcAddr = CODEC_MEM_ST;	

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
	{
		#if (IMAGE_LOAD == LOADFILE_FROM_SD)
		{
			s32 sFail;
			u32 uFileReadSize;
			t_file_handler oFileHandler;
			
			sFail = FS_Open(pResolution_Image[BMP_1280x720], &oFileHandler);
			if(sFail != 0)
			{
				UART_Printf("%s open fail\n", pResolution_Image[BMP_1280x720]);
				return;
			}
			else
				UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1280x720]);
			
			FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
		}
		#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)	
		LoadFromFile((const char *)pResolution_Image[BMP_1280x720], uVpSrcAddr);	
		#endif	
	}
	
	eImgSz = HD720;
	eScanMode = PROGRESSIVE;

	uWin0StAddr = CODEC_MEM_ST + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;
	HDMIT_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr);
	
	while(!UART_GetKey())
	{
		UART_Printf("Count : %d\n", uCount++);
		
		// VP setting
		HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
		// Mixer setting
		HDMIT_MixerSettingForTest(uWin0StAddr, uWin1StAddr, HDMI_CS_YCBCR444, RGB709_0_255);
		
		//MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
		//MIXER_SetRGBColorFormat(MX_YUV444, RGB709_0_255);
		//MIXER_SetVdWinOnOff(1);

		HDMI_SetMode(eHDMI_DVI);
		HDMI_SetColorSpace(eColorSpace);
		HDMI_SetVideoMode(v1280x720p_60Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_16_9);  

		// TV On
		VP_EnableIP(1);
		MIXER_StartProcessing();
		HDMI_Enable(TRUE);	
		HDMI_TG_OnOff(TRUE);

		DelayfrTimer(milli, SBLK_GetRand()%100 + 3000);

		//TV Off
		VP_EnableIP(0);
		MIXER_StopProcessing();
//		DelayfrTimer(milli, 20);
		HDMI_Enable(FALSE);	
		HDMI_TG_OnOff(FALSE);	
		
		DelayfrTimer(milli, 2000);
		
		// T-Block Power Off and On
		SYSC_SetBlockPowerOFF_IP(eHDTV);
		UART_Printf("HDTV Block Power off\n");
		
		DelayfrTimer(milli, SBLK_GetRand()%100);
		
		SYSC_SetBlockPowerON_IP(eHDTV);
		UART_Printf("HDTV Block Power on\n");
	}
	
	return TRUE;
}


u32 HDMIT_ClockOnOff(void)
{
	u32 uVpSrcAddr, uHdmiMode, uColorFormat;
	HDMIMode eHDMI_DVI;
	ColorSpace eColorSpace;
	s32 uRanOffset;
	u32 uCount=1;
		
	UART_Printf("[HDMIT_ClockOnOff]\n");
	
	eHDMI_DVI = HDMI;
	eColorSpace = HDMI_CS_YCBCR444;

	uVpSrcAddr = CODEC_MEM_ST;	

	UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
	if(UART_Getc() == 'y')
	{
		#if (IMAGE_LOAD == LOADFILE_FROM_SD)
		{
			s32 sFail;
			u32 uFileReadSize;
			t_file_handler oFileHandler;
			
			sFail = FS_Open(pResolution_Image[BMP_1280x720], &oFileHandler);
			if(sFail != 0)
			{
				UART_Printf("%s open fail\n", pResolution_Image[BMP_1280x720]);
				return;
			}
			else
				UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1280x720]);
			
			FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
		}
		#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)	
		LoadFromFile((const char *)pResolution_Image[BMP_1280x720], uVpSrcAddr);	
		#endif	
	}
	eImgSz = HD720;
	eScanMode = PROGRESSIVE;

//	UART_Printf("Input the random offset value\n");
//	uRanOffset = UART_GetIntNum();
//	srand(uRanOffset);		
	
	while(!UART_GetKey())
	{
		UART_Printf("Count : %d\n", uCount++);
	
		// VP setting
		HDVpMx_VPSettingForTest(uVpSrcAddr, NV12);
		// Mixer setting
		MIXER_InitForDTv(eImgSz, eScanMode, RGB709_0_255);
		MIXER_SetRGBColorFormat(MX_YUV444, RGB709_0_255);
		MIXER_SetVdWinOnOff(1);

		HDMI_SetMode(eHDMI_DVI);
		HDMI_SetColorSpace(eColorSpace);
		HDMI_SetVideoMode(v1280x720p_60Hz, HDMI_CD_24, HDMI_PIXEL_RATIO_16_9);  

		// IP Clock Off and On Before IP Running.....
		SYSC_SetClkOFF_IP(eVP);
		SYSC_SetClkOFF_IP(eMIXER);
		SYSC_SetClkOFF_IP(eHDMI);
		UART_Printf("HDTV Block Clock off\n");
				
		DelayfrTimer(milli, SBLK_GetRand()%1000);	
		
		SYSC_SetClkON_IP(eVP);
		SYSC_SetClkON_IP(eMIXER);
		SYSC_SetClkON_IP(eHDMI);
		UART_Printf("HDTV Block Clock on\n");
		
		// TV On
		VP_EnableIP(1);
		MIXER_StartProcessing();
		HDMI_Enable(TRUE);	
		HDMI_TG_OnOff(TRUE);

		DelayfrTimer(milli, 3000);

		//TV Off
		VP_EnableIP(0);
		MIXER_StopProcessing();
		HDMI_Enable(FALSE);	
		HDMI_TG_OnOff(FALSE);	
		
		DelayfrTimer(milli, 2000);
	}

	return TRUE;
}


u32 HDMIT_InitSimplePlay(u32 uVpSrcAddr, u32 uSrcHSize, u32 uSrcVSize,  
						IMG_RESOLUTION eOutImgRes, SCAN_MODE eOutScan);
u32 HDMIT_SimplePlayOn(void);
u32 HDMIT_SimplePlayOff(void);
						
// Condition : Boot code preparing & Write the test code into Booting device
// This PowerMode function must be called in main() function
u32 HDMIT_PowerMode(void)
{
	u32 uVpSrcAddr, uHdmiMode, uColorFormat;
	HDMIMode eHDMI_DVI;
	ColorSpace eColorSpace;
	s32 uRanOffset;
		
	UART_Printf("[HDMIT_PowerMode]\n");
	
#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	if(FS_Init()!=0)
		Disp("Fail to open FAT with SD CARD\n");
	UART_Printf("\n\n");	
#endif

	uVpSrcAddr = CODEC_MEM_ST;	

	if(SYSC_GetInformReg(4) != 0x89abcdef)
	{
		UART_Printf("Do you want to download the Image : yes('y'), no(any key)\n");
		if(UART_Getc() == 'y')
		{
			#if (IMAGE_LOAD == LOADFILE_FROM_SD)
			{
				s32 sFail;
				u32 uFileReadSize;
				t_file_handler oFileHandler;
				
				sFail = FS_Open(pResolution_Image[BMP_1280x720], &oFileHandler);
				if(sFail != 0)
				{
					UART_Printf("%s open fail\n", pResolution_Image[BMP_1280x720]);
					return;
				}
				else
					UART_Printf("Success to load image(%s)\n", pResolution_Image[BMP_1280x720]);
				
				FS_Read(&oFileHandler, oFileHandler.nSize, (u32 *)uVpSrcAddr, &uFileReadSize);	
			}
			#elif (IMAGE_LOAD == LOADFILE_FROM_SEMI)	
			LoadFromFile((const char *)pResolution_Image[BMP_1280x720], uVpSrcAddr);	
			#endif				
		}
		
		SYSC_SetInformReg(4, 0x89abcdef);
		SYSC_SetInformReg(5, 0);		//Count
	}
	SYSC_SetInformReg(5, SYSC_GetInformReg(5)+1);	
	UART_Printf("Count : %d\n", SYSC_GetInformReg(5));
	
	HDMIT_InitSimplePlay(uVpSrcAddr, HD720_HSIZE, HD720_VSIZE, HD720, PROGRESSIVE);
	while(!UART_GetKey())
	{
		u32 uPowerMode;
		
		HDMIT_SimplePlayOn();

		uPowerMode = SBLK_GetRand()%6+1;
//		if(uPowerMode == 5)
//			uPowerMode = 6;

		UART_Printf("Power Mode : %d (Idle(1), Deep Idle(2), Stop(3), Deep Stop(4), Sleep(5), S/W reset(6))\n", uPowerMode);

		UART_Printf("Press Any key\n");
		UART_Getc();
		DelayfrTimer(milli, SBLK_GetRand()%1000+2000);
		
		SYSCT_TestSimplePowerMode_Temp(uPowerMode);

		//TV Off
		HDMIT_SimplePlayOff();	
	}

	return TRUE;
}


const AutotestFuncMenu HDTV_ETC_menu[]=
{
	HDMIT_BlockPowerOnOff,					"HDMI Block Power On/Off",
	HDMIT_ClockOnOff,						"HDMI Clock On/Off",
	HDMIT_PowerMode,						"HDMI Power Mode",
	0,0
};

u32 HDMIT_ETCTest(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;
	s32 sSel;
	
	while (true)
	{
		UART_Printf("\n");
		for ( i=0; (int)(HDTV_ETC_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, HDTV_ETC_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(HDTV_ETC_menu)/8-1))
			(HDTV_ETC_menu[sSel].func) (eTest_Manual, oPara);
	}


	return OK;
}


u32 HDMIT_InitIP(void)
{
	u32 hpd;
	
	SYSC_SetDivHDMI(0x96);
	SYSC_EnHDMIPHY();
	
	HDMI_Init();

	if (HPD_Init() != OK)
	{
		UART_Printf("fail to init HPD\n");
		return;
	}

	I2CHDMI_Init();
    
	if (EDDC_Init() != OK)
	{
		UART_Printf("fail to init EDDC\n");
		return;
	}

	if (HDCP_Init() != OK)
	{
		UART_Printf("fail to init HDMI\n");
		return;
	}
	    
	UART_Printf("waiting for HPD...\n");
	while(!UART_GetKey())
	{
		hpd = HPD_Detect();
		if(hpd == HDMI_HPD_CABLE_IN)
		{
			UART_Printf("HDMI_HPD_CABLE_IN\n");
			break;
		}
	}

	return TRUE;
}


// for Manual Test
u32 HDMIT_InitSimplePlay(u32 uVpSrcAddr, u32 uSrcHSize, u32 uSrcVSize,  
						IMG_RESOLUTION eOutImgRes, SCAN_MODE eOutScan)
{
	u32 uResolution, uScanMode, uHdmiMode, uColorFormat, uBitPerColor, uWideColor;
	u32 uWin0StAddr, uWin1StAddr;
	HDMIMode eHDMI_DVI;
	VideoFormat eVideoFmt;
	ColorDepth eColorDepth;
	PixelAspectRatio ePixelRatio;
	ColorSpace eColorSpace;
	PixelLimit ePixelLimit;
	MX_RGB_FORMAT eMxOutRgb;
	
	eHDMI_DVI =HDMI;	
	eImgSz = eOutImgRes;
	eScanMode = eOutScan;
	
	eVideoFmt = 	(eImgSz == HD1080)? ((eScanMode== PROGRESSIVE)? v1920x1080p_60Hz : v1920x1080i_60Hz) :
				(eImgSz == HD720)? 	v1280x720p_60Hz:
				(eImgSz == SD480)? 	((eScanMode== PROGRESSIVE)? v720x480p_60Hz : v720x480i_60Hz) :
									((eScanMode== PROGRESSIVE)? v720x576p_50Hz : v720x576i_50Hz);
									
	ePixelRatio = 	(eImgSz == HD1080)? HDMI_PIXEL_RATIO_16_9:
				(eImgSz == HD720)? 	HDMI_PIXEL_RATIO_16_9:
				(eImgSz == SD480)?	HDMI_PIXEL_RATIO_4_3: HDMI_PIXEL_RATIO_4_3;

	eColorSpace =  HDMI_CS_YCBCR444;
	eColorDepth = HDMI_CD_24;
	eMxOutRgb = 	RGB709_16_235;	
	ePixelLimit = HDMI_RGB_LIMIT_RANGE;
					
	uWin0StAddr = CODEC_MEM_ST + 0x00800000;
	uWin1StAddr = uWin0StAddr + 0x00800000;

	// for Graphic Layer Image
	HDMIT_DrawGraphicForMixer(uWin0StAddr, uWin1StAddr);

	HDMIT_InitIP();
		
	// VP setting
	HDVPT_InitParaForTV(NV12);
	oVP_SrcInf.uSrcStAddr = uVpSrcAddr;
	oVP_SrcInf.uImgHsz = uSrcHSize;
	oVP_SrcInf.uImgVsz = uSrcVSize;
	oVP_SrcInf.uSrcHsz=uSrcHSize;
	oVP_SrcInf.uSrcVsz=uSrcVSize;	
	VP_InitIP(oVP_SrcInf, oVP_DstInf);

	HDMIT_MixerSettingForTest(uWin0StAddr, uWin1StAddr, eColorSpace, eMxOutRgb);
	MIXER_SetGrphWinOnOff(MX_WIN0, 0);
	MIXER_SetGrphWinOnOff(MX_WIN1, 0);
	
	HDMI_SetMode(eHDMI_DVI);
	HDMI_SetColorSpace(eColorSpace);
	HDMI_SetPixelLimit(ePixelLimit); 	
	HDMI_SetVideoMode(eVideoFmt, eColorDepth, ePixelRatio);
	
	return TRUE;
}


// for Manual Test
u32 HDMIT_SimplePlayOn(void)
{
	VP_EnableIP(1);
	MIXER_StartProcessing();
	HDMI_Enable(TRUE);	
	HDMI_TG_OnOff(TRUE);
}

u32 HDMIT_SimplePlayOff(void)
{
	VP_EnableIP(0);
	MIXER_StopProcessing();
	HDMI_Enable(FALSE);
	HDMI_TG_OnOff(FALSE);
}


const AutotestFuncMenu HDTV_HDMI_menu[]=
{
	//-- HDMI -- 
	HDMIT_SimpleDisplay,					"HDMI Simple Display",
	HDMIT_AutoSimpleDisplay,				"HDMI Simple Display Full",
	HDMIT_SupportResolutionDisplay,			"HDMI Resolution Display",
	//-- HDCP--
	HDMIT_HDCP,							"HDCP Test",
	//--EEDID--
	HDMIT_EEDID,							"HDMI E-EDID Test",
	//--CEC--
	HDMIT_CEC,								"HDMI CEC",
	HDMIT_CEC_WakeUp,						"HDMI CEC Wake-Up",
	//--PHY Freq Setting
	HDMIT_PHY,								"PHY Setting",
	//--ETC--
	HDMIT_ETCTest,							"HDMI ETC Test",
	//-- Audio --
//	HDMIT_SPDIF_Audio,						"HDMI Audio(SPDIF)",
//	HDMIT_I2S_Audio,						"HDMI Audio(I2S 5-ch)",
	0,0
};


void HDMI_Test(void)
{
	u32 i, hpd;
	s32 sSel;
	oFunctionT_AutoVar oPara;

	UART_Printf("[HDMI_Test]\n");

#if (IMAGE_LOAD == LOADFILE_FROM_SD)
	if(FS_Init()!=0)
		Disp("Fail to open FAT with SD CARD\n");
	UART_Printf("\n\n");	
#endif
	
	InitSysconForHD();
	HDMI_Init();

	if (HPD_Init() != OK)
	{
		UART_Printf("fail to init HPD\n");
		return;
	}

	I2CHDMI_Init();
    
	if (EDDC_Init() != OK)
	{
		UART_Printf("fail to init EDDC\n");
		return;
	}

	if (HDCP_Init() != OK)
	{
		UART_Printf("fail to init HDMI\n");
		return;
	}

	if(PHY_TxPowerDown() != OK)
	{
		UART_Printf("fail to off PHY TX \n");
		return;
	}		
	    
	UART_Printf("waiting for HPD...\n");
	while(!UART_GetKey())
	{
		hpd = HPD_Detect();
		if(hpd == HDMI_HPD_CABLE_IN)
		{
			UART_Printf("HDMI_HPD_CABLE_IN\n");
			break;
		}
	}

	while (true)
	{
		UART_Printf("\n");
		UART_Printf("\n");
		for ( i=0; (int)(HDTV_HDMI_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, HDTV_HDMI_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(HDTV_HDMI_menu)/8-1))
			(HDTV_HDMI_menu[sSel].func) (eTest_Manual, oPara);
	}

	ResetEDID();
//	HDCP_Stop();
//	HDMI_Enable(FALSE);
}









