#ifndef __TVOUT_COMMON_H__
#define __TVOUT_COMMON_H__

#ifdef __cplusplus
extern "C" {
#endif

#define TVENC_IMG_MAX			10
#define HDMI_AUDIO_MAX			5

#define LOADFILE_FROM_SEMI			0
#define LOADFILE_FROM_SD			1
#define LOADFILE_FROM_USB			2
#define IMAGE_LOAD			LOADFILE_FROM_SEMI

//#define TVOUT_DEBUG
#ifdef TVOUT_DEBUG
	#define INPUT_DELAY		UART_Getc()
#else	
	#define INPUT_DELAY		DelayfrTimer(milli, 500)
#endif


typedef enum
{	
	// [11:8] : Window Blending ( 0 : off, 1 : on)
	// [7:4] : Pixel Blending ( 0 : off, 1 : on)
	// [3:0] : Pre_multiplied Blending ( 0 : off, 1 : on)	
	nWIN_nPIX_nPRE	=	0x000,
	nWIN_PIX_nPRE		=	0x010,
	nWIN_PIX_PRE		=	0x011,
	WIN_nPIX_nPRE		=	0x100,
	WIN_PIX_nPRE		=	0x110,
	WIN_PIX_PRE		=	0x111,
}MXT_eBlend_Op;

/////////////////////
// Image Size Define 
////////////////////
typedef enum
{
	BMP_240x320		=	0,
	BMP_320x240		=	1,
	BMP_720x480		= 	2,
	BMP_720x576		= 	3,
	BMP_1280x720		=	4,
	BMP_1920x1080		=	5
}TVT_eIMAGE_SIZE;

typedef enum
{
	WAVE_BOA		=	0
}TVT_eAudioSource;

typedef struct FullTestMenu {
	u32 uType; 
	u8 *pString;
} FullTestMenu;

#if (IMAGE_LOAD == LOADFILE_FROM_SEMI)
// must the same order with the TVT_eIMAGE_SIZE enum...
static u8 *pTest_Image[TVENC_IMG_MAX] = 	{	"F:/AP/MultiMedia/Test_Image/BMP/240x320_prayer.bmp",
											"F:/AP/MultiMedia/Test_Image/BMP/320x240_prayer.bmp",
											"F:/AP/MultiMedia/Test_Image/BMP/720x480_overscan.bmp",
											"F:/AP/MultiMedia/Test_Image/BMP/720x576_testpattern.bmp",
											//"F:/AP/MultiMedia/Test_Image/BMP/720x576_pinkbee.bmp",
											"F:/AP/MultiMedia/Test_Image/BMP/1280x720_overscan.bmp",
											"F:/AP/MultiMedia/Test_Image/BMP/1920x1080_overscan.bmp"
											//"F:/AP/MultiMedia/Test_Image/BMP/1920x1080_lulworthcove.bmp"
											//"F:/AP/MultiMedia/Test_Image/BMP/1920x1080_pinkbee.bmp"
										};
static u8 *pResolution_Image[TVENC_IMG_MAX] = 	{	" ",
													" ",
													"F:/AP/MultiMedia/Test_Image/NV12_sample/720x480_NV12.yuv",
													"F:/AP/MultiMedia/Test_Image/NV12_sample/720x576_NV12.yuv",
													"F:/AP/MultiMedia/Test_Image/NV12_sample/1280x720_NV12.yuv",
													"F:/AP/MultiMedia/Test_Image/NV12_sample/1920x1080_NV12.yuv"
												};
static u8 *pAudio_Source[HDMI_AUDIO_MAX] = 	{ "F:/AP/MultiMedia/AudioFile/Boa48.wav",
											};


static u8 *pResol_NV12_IB[TVENC_IMG_MAX] = 	{	" ",
												" ",
												"F:/AP/MultiMedia/Test_Image/NV12_sample/720x480_NV12_IB.yuv",
												"F:/AP/MultiMedia/Test_Image/NV12_sample/720x576_NV12_IB.yuv",
												" ",
												" "
												};

static u8 *pResol_TILE_NV12[TVENC_IMG_MAX] = 	{	" ",
												" ",
												"F:/AP/MultiMedia/Test_Image/NV12_sample/720x480_TILE_NV12.yuv",
												"F:/AP/MultiMedia/Test_Image/NV12_sample/720x576_TILE_NV12.yuv",
												" ",
												" "
												};
static u8 *pResol_TILE_NV12_IB[TVENC_IMG_MAX] = 	{	" ",
												" ",
												"F:/AP/MultiMedia/Test_Image/NV12_sample/720x480_TILE_NV12_IB.yuv",
												"F:/AP/MultiMedia/Test_Image/NV12_sample/720x576_TILE_NV12_IB.yuv",
												" ",
												" "
												};

#elif(IMAGE_LOAD == LOADFILE_FROM_SD) 
static u8 *pTest_Image[TVENC_IMG_MAX] = 	{	"MultiMedia/Test_Image/BMP/240x320_prayer.bmp",
											"MultiMedia/Test_Image/BMP/320x240_prayer.bmp",
											"MultiMedia/Test_Image/BMP/720x480_overscan.bmp",
											"MultiMedia/Test_Image/BMP/720x576_testpattern.bmp",
											//"MultiMedia/Test_Image/BMP/720x576_pinkbee.bmp",
											"MultiMedia/Test_Image/BMP/1280x720_overscan.bmp",
											"MultiMedia/Test_Image/BMP/1920x1080_overscan.bmp"
											//"MultiMedia/Test_Image/BMP/1920x1080_lulworthcove.bmp"
											//"MultiMedia/Test_Image/BMP/1920x1080_pinkbee.bmp"
										};
static u8 *pResolution_Image[TVENC_IMG_MAX] = 	{	" ",
													" ",
													"MultiMedia/Test_Image/NV12_sample/720x480_NV12.yuv",
													"MultiMedia/Test_Image/NV12_sample/720x576_NV12.yuv",
													"MultiMedia/Test_Image/NV12_sample/1280x720_NV12.yuv",
													//"MultiMedia/Test_Image/NV12_sample/1920x1080_NV12.yuv"
													"MultiMedia/Test_Image/NV12_sample/colorchecker_420.raw"
												};
static u8 *pAudio_Source[HDMI_AUDIO_MAX] = 	{ "MultiMedia/AudioFile/Boa48.wav",
											};


static u8 *pResol_NV12_IB[TVENC_IMG_MAX] = 	{	" ",
												" ",
												"MultiMedia/Test_Image/NV12_sample/720x480_NV12_IB.yuv",
												"MultiMedia/Test_Image/NV12_sample/720x576_NV12_IB.yuv",
												" ",
												" "
												};

static u8 *pResol_TILE_NV12[TVENC_IMG_MAX] = 	{	" ",
													" ",
													"MultiMedia/Test_Image/NV12_sample/720x480_TILE_NV12.yuv",
													"MultiMedia/Test_Image/NV12_sample/720x576_TILE_NV12.yuv",
													" ",
													" "
												};
static u8 *pResol_TILE_NV12_IB[TVENC_IMG_MAX] = 	{	" ",
													" ",
													"MultiMedia/Test_Image/NV12_sample/720x480_TILE_NV12_IB.yuv",
													"MultiMedia/Test_Image/NV12_sample/720x576_TILE_NV12_IB.yuv",
													" ",
													" "
												};

#endif

#define IMG_SRC_HSZ_240   	240
#define IMG_SRC_VSZ_320   	320
//#define IMG_SRC_HSZ_240   	120
//#define IMG_SRC_VSZ_320   	160
 
#define IMG_SRC_HSZ_VP 		640
#define IMG_SRC_VSZ_VP 		480
#define IMG_SRC_HSZ_320 	320
#define IMG_SRC_VSZ_240 	240
#define IMG_SRC_HSZ_720   	720
#define IMG_SRC_VSZ_480   	480

typedef struct
{
	TVT_eIMAGE_SIZE 	eImageSize;
	u8					*pImagePath;
}oDownImage_Inform;


#ifdef __cplusplus
}
#endif

#endif

