/**
 * File Name : phy.c
 *
 * File Description :
 * This file implements to config the HDMI PHY
 *
 * Author : Hee Myung Noh
 * Dept : AP Development
 * Created Date : 2009/01/22
 * Version : 0.1
 * History 
 *  - Initiate version (Hee Myung Noh 090122)
 */

#include "system.h"
#include "Library.h"
#include "v210_sfr.h"
#include "intc.h"
#include "phy.h"
#include "i2c_hdmi.h"
#include "sysc.h"

#define PHY_IN_27MHz		(0)
#define PHY_IN_24MHz		(1)
#define PHY_IN_FREQ			PHY_IN_24MHz

#define PHY_SET_VER00		(0)
#define PHY_SET_VER10		(1)
#define PHY_SET_VERSION	PHY_SET_VER00

#define PHY_I2C_ADDRESS       		0x70
#define PHY_REG_MODE_SET_DONE 	0x1F		//45nm

/**
 * PHY chip configuration:
 * Clock scheme using an external video PLL for pixel clock generation.
 * The integrated video PLL is configured as jitter-filter PLL.
 */

#if(PHY_SET_VERSION == PHY_SET_VER00)

#if(PHY_IN_FREQ == PHY_IN_27MHz)
	static const u8 phy_config[][3][32] = {
		// chip using internal video PLL ;
		// freq = 25.200 MHz
		{
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x50, 0x11, 0x52, 0x5f, 0x20, 0x5B, 0xA8, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0x11, 0x27, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x50, 0x11, 0x52, 0x5f, 0x21, 0x5B, 0xD2, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xDA, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x52, 0x5f, 0x20, 0x5B, 0xA8, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xB6, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 25.175 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xFC, 0x48, 0x6B, 0x50, 0x11, 0x52, 0x5f, 0x20, 0x5B, 0xA8, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0x12, 0x27, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xFB, 0x48, 0x6B, 0x50, 0x11, 0x52, 0x5f, 0x21, 0x5B, 0xD2, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xDB, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xFC, 0x48, 0x6B, 0x10, 0x02, 0x52, 0x5f, 0x20, 0x5B, 0xA8, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xB6, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 27 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x52, 0x3f, 0x20, 0x5B, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x52, 0x3f, 0x21, 0x5B, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x52, 0x4f, 0x21, 0x5B, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xAA, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 27.027 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x32, 0x6B, 0x10, 0x02, 0x52, 0x3f, 0x20, 0x5B, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x28, 0x6B, 0x10, 0x02, 0x52, 0x3f, 0x21, 0x5B, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x03, 0x32, 0x6B, 0x10, 0x02, 0x52, 0x4f, 0x21, 0x5B, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xA9, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 54 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x3f, 0x20, 0x5B, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x3f, 0x21, 0x5B, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x4f, 0x21, 0x5B, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xAA, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 54.054 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x32, 0x6B, 0x10, 0x01, 0x52, 0x3f, 0x20, 0x5B, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x28, 0x6B, 0x10, 0x01, 0x52, 0x3f, 0x21, 0x5B, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x03, 0x32, 0x6B, 0x10, 0x01, 0x52, 0x4f, 0x21, 0x5B, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xA9, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 74.250 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x9f, 0x21, 0x5B, 0xA5, 0x84, 0x00, 0x20, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xB9, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x2f, 0x32, 0x5B, 0xCE, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x94, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x20, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x9f, 0x32, 0x5B, 0xF8, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xF7, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 74.176 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x56, 0x5B, 0x6B, 0x10, 0x01, 0x52, 0x1f, 0x25, 0x5B, 0xA5, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xB9, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x3E, 0x5B, 0x6B, 0x10, 0x01, 0x52, 0x2f, 0x32, 0x5B, 0xCE, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x94, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x26, 0x5B, 0x6B, 0x10, 0x01, 0x52, 0x9f, 0x32, 0x5B, 0xF7, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xF7, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 148.500 MHz  - Pre-emph + Higher Tx amp.                                                                                                                                                        
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x9f, 0x21, 0x5B, 0xA5, 0x84, 0x00, 0x20, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xB9, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x2f, 0x32, 0x5B, 0xCE, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x94, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x20, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x9f, 0x32, 0x5B, 0xF8, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x7B, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 148.352 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x56, 0x5B, 0x6B, 0x18, 0x01, 0x52, 0x1f, 0x25, 0x5B, 0xA5, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xB9, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x3E, 0x5B, 0x6B, 0x18, 0x01, 0x52, 0x2f, 0x32, 0x5B, 0xCE, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x94, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x26, 0x5B, 0x6B, 0x18, 0x01, 0x52, 0x9f, 0x32, 0x5B, 0xF7, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x7B, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 108.108 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x32, 0x6B, 0x18, 0x01, 0x52, 0x3f, 0x20, 0x5B, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x28, 0x6B, 0x18, 0x01, 0x52, 0x3f, 0x21, 0x5B, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x06, 0x64, 0x6B, 0x18, 0x01, 0x52, 0x4f, 0x21, 0x5B, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xA9, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 72 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x6f, 0x21, 0x5B, 0x50, 0x84, 0x00, 0x21, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xBF, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x8f, 0x21, 0x5B, 0x64, 0x84, 0x00, 0x21, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x99, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x3f, 0x20, 0x5B, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 25 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xE8, 0x36, 0x6B, 0x50, 0x11, 0x52, 0x5f, 0x20, 0x5B, 0xA7, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0x13, 0x27, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xE2, 0x36, 0x6B, 0x50, 0x11, 0x52, 0x5f, 0x21, 0x5B, 0xD0, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xDC, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xE8, 0x36, 0x6B, 0x10, 0x02, 0x52, 0x5f, 0x20, 0x5B, 0xA7, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xB7, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 65 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x08, 0x36, 0x6B, 0x10, 0x01, 0x52, 0x4f, 0x20, 0x5B, 0x90, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xD4, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x0A, 0x36, 0x6B, 0x10, 0x01, 0x52, 0x8f, 0x22, 0x5B, 0xB5, 0x84, 0x00, 0x20, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xA9, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x0C, 0x36, 0x6B, 0x10, 0x01, 0x52, 0x4f, 0x22, 0x5B, 0xD9, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x8D, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 108 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x3f, 0x20, 0x5B, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x3f, 0x21, 0x5B, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x4f, 0x21, 0x5B, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xAA, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 162 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x4f, 0x21, 0x5B, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xAA, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0xDf, 0x21, 0x5B, 0xE1, 0x84, 0x00, 0x20, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x88, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x52, 0x7f, 0x21, 0x5B, 0x0E, 0x85, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x71, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},
	};

#else	//PHY_IN_FREQ == PHY_IN_24MHz
	static const u8 phy_config[][3][32] = {
		// chip using internal video PLL ; (INT_27M pin(USB 24MHz))
		// freq = 25.200 MHz
		{
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x52, 0x1f, 0x23, 0x5B, 0x7e, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xf3, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x52, 0xdf, 0x23, 0x5B, 0x9e, 0x84, 0x00, 0x32, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xc2, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x52, 0x7f, 0x23, 0x5B, 0xbd, 0x84, 0x00, 0x30, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xa2, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 25.175 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x1e, 0x20, 0x6B, 0x50, 0x10, 0x52, 0xff, 0x31, 0x5B, 0xbd, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xf3, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x2b, 0x40, 0x6B, 0x50, 0x10, 0x52, 0x7f, 0x32, 0x5B, 0xec, 0x84, 0x00, 0x10, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xc2, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x1e, 0x20, 0x6B, 0x10, 0x02, 0x52, 0xff, 0x31, 0x5B, 0xbd, 0x84, 0x00, 0x10, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xa2, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 27 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x52, 0x7f, 0x21, 0x5B, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe3, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x08, 0x6B, 0x10, 0x02, 0x52, 0x5f, 0x20, 0x5B, 0xa9, 0x84, 0x00, 0x10, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xfc, 0x08, 0x6B, 0x10, 0x02, 0x52, 0x2f, 0x32, 0x5B, 0xcb, 0x84, 0x00, 0x10, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 27.027 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0x09, 0x64, 0x6B, 0x10, 0x02, 0x52, 0x7f, 0x21, 0x5B, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe2, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0x31, 0x50, 0x6B, 0x10, 0x02, 0x52, 0x6f, 0x23, 0x5B, 0xa9, 0x84, 0x00, 0x30, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0x1b, 0x64, 0x6B, 0x10, 0x02, 0x52, 0xdf, 0x25, 0x5B, 0xcb, 0x84, 0x00, 0x32, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 54 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x7f, 0x21, 0x5B, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe3, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x08, 0x6B, 0x10, 0x01, 0x52, 0x5f, 0x20, 0x5B, 0xa9, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xfc, 0x08, 0x6B, 0x10, 0x01, 0x52, 0x2f, 0x32, 0x5B, 0xcb, 0x84, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 54.054 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xd4, 0x10, 0x9C, 0x09, 0x64, 0x6B, 0x10, 0x01, 0x52, 0x7f, 0x21, 0x5B, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe2, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xd4, 0x10, 0x9C, 0x31, 0x50, 0x6B, 0x10, 0x01, 0x52, 0x6f, 0x23, 0x5B, 0xa9, 0x84, 0x00, 0x30, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0x1b, 0x64, 0x6B, 0x10, 0x01, 0x52, 0xdf, 0x25, 0x5B, 0xcb, 0x84, 0x00, 0x32, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 74.250 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xf8, 0x40, 0x6B, 0x10, 0x01, 0x52, 0xff, 0x31, 0x5B, 0xba, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xa4, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xd6, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x7f, 0x32, 0x5B, 0xe8, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x83, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x34, 0x40, 0x6B, 0x10, 0x01, 0x52, 0xef, 0x32, 0x5B, 0x16, 0x85, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xdc, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 74.176 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xef, 0x5B, 0x6B, 0x10, 0x01, 0x52, 0xef, 0x33, 0x5B, 0xb9, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xa5, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0xab, 0x5B, 0x6B, 0x10, 0x01, 0x52, 0xbf, 0x39, 0x5B, 0xe8, 0x84, 0x00, 0x32, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x84, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0xcd, 0x5B, 0x6B, 0x10, 0x01, 0x52, 0xdf, 0x35, 0x5B, 0x16, 0x85, 0x00, 0x30, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xdc, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 148.500 MHz  - Pre-emph + Higher Tx amp.                                                                                                                                                       
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xf8, 0x40, 0x6B, 0x18, 0x00, 0x52, 0xff, 0x31, 0x5B, 0xba, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xa4, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xd6, 0x40, 0x6B, 0x18, 0x00, 0x52, 0x7f, 0x32, 0x5B, 0xe8, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x23, 0x41, 0x83, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x34, 0x40, 0x6B, 0x18, 0x00, 0x52, 0xef, 0x32, 0x5B, 0x16, 0x85, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x23, 0x41, 0x6d, 0x26, 0x02, 0x00, 0x00, 0x80, },
			//{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x34, 0x40, 0x6B, 0x18, 0x00, 0x51, 0xE8, 0xF2, 0x54, 0x16, 0x85, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x23, 0x41, 0x6d, 0x26, 0x02, 0x00, 0x00, 0x00, },
		},                                                                                                                                                                                                       
		// freq = 148.352 MHz                                                                                                                                                                                    
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xef, 0x5B, 0x6B, 0x18, 0x00, 0x52, 0xef, 0x33, 0x5B, 0xb9, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xa5, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0xab, 0x5B, 0x6B, 0x18, 0x00, 0x52, 0xbf, 0x39, 0x5B, 0xe8, 0x84, 0x00, 0x32, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x23, 0x41, 0x84, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0xcd, 0x5B, 0x6B, 0x18, 0x00, 0x52, 0xdf, 0x35, 0x5B, 0x16, 0x85, 0x00, 0x30, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x23, 0x41, 0x6d, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 108.108 MHz                                                                                                                                                                                    
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0x09, 0x64, 0x6B, 0x18, 0x00, 0x52, 0x7f, 0x21, 0x5B, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe2, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0x31, 0x50, 0x6B, 0x18, 0x00, 0x52, 0x6f, 0x23, 0x5B, 0xa9, 0x84, 0x00, 0x30, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0x1b, 0x64, 0x6B, 0x18, 0x00, 0x52, 0xdf, 0x25, 0x5B, 0xcb, 0x84, 0x00, 0x32, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 72 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x4f, 0x21, 0x5B, 0xb4, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xaa, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x52, 0xdf, 0x21, 0x5B, 0xe1, 0x84, 0x00, 0x30, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x88, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x00, 0x52, 0x7f, 0x21, 0x5B, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xe3, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 25 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x20, 0x40, 0x6B, 0x50, 0x10, 0x52, 0xff, 0x31, 0x5B, 0xbc, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xf5, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x08, 0x40, 0x6B, 0x50, 0x10, 0x52, 0x7f, 0x32, 0x5B, 0xea, 0x84, 0x00, 0x10, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xc4, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x20, 0x40, 0x6B, 0x10, 0x02, 0x52, 0xff, 0x31, 0x5B, 0xbc, 0x84, 0x00, 0x10, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xa3, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                      
		// freq = 65 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x0c, 0x6B, 0x10, 0x01, 0x52, 0x1f, 0x25, 0x5B, 0xa3, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xbc, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xf2, 0x30, 0x6B, 0x10, 0x01, 0x52, 0x2f, 0x32, 0x5B, 0xcb, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x96, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xd0, 0x40, 0x6B, 0x10, 0x01, 0x52, 0x9f, 0x32, 0x5B, 0xf4, 0x84, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x7D, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 108 MHz                                                                                                                                                                                        
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x00, 0x52, 0x7f, 0x21, 0x5B, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe3, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x08, 0x6B, 0x18, 0x00, 0x52, 0x5f, 0x20, 0x5B, 0xa9, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xfc, 0x08, 0x6B, 0x18, 0x00, 0x52, 0x2f, 0x32, 0x5B, 0xcb, 0x84, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 162 MHz                                                                                                                                                                                        
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x00, 0x52, 0xdf, 0x25, 0x5B, 0xcb, 0x84, 0x00, 0x32, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x18, 0x40, 0x6B, 0x18, 0x00, 0x52, 0x5f, 0x22, 0x5B, 0xfd, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x23, 0x41, 0x78, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xd0, 0x40, 0x6B, 0x18, 0x00, 0x52, 0x3f, 0x33, 0x5B, 0x30, 0x85, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x23, 0x41, 0x64, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},
	};
#endif

#else		// PHY_SET_VERSION == PHY_SET_VER10

#if(PHY_IN_FREQ == PHY_IN_27MHz)
	static const u8 phy_config[][3][32] = {
		// chip using internal video PLL ;
		// freq = 25.200 MHz
		{
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x50, 0x11, 0x51, 0xC8, 0xF1, 0x54, 0xA8, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0x11, 0x27, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x50, 0x11, 0x51, 0x38, 0xF2, 0x54, 0xD2, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xDA, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x51, 0xC8, 0xF1, 0x54, 0xA8, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xB6, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 25.175 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xFC, 0x48, 0x6B, 0x50, 0x11, 0x51, 0xC8, 0xF1, 0x54, 0xA8, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0x12, 0x27, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xFB, 0x48, 0x6B, 0x50, 0x11, 0x51, 0x38, 0xF2, 0x54, 0xD2, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xDB, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xFC, 0x48, 0x6B, 0x10, 0x02, 0x51, 0xC8, 0xF1, 0x54, 0xA8, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xB6, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 27 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x51, 0x48, 0xF1, 0x54, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x51, 0x98, 0xF1, 0x54, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x51, 0xE8, 0xF1, 0x54, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xAA, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 27.027 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x32, 0x6B, 0x10, 0x02, 0x51, 0x48, 0xF1, 0x54, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x28, 0x6B, 0x10, 0x02, 0x51, 0x98, 0xF1, 0x54, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x03, 0x32, 0x6B, 0x10, 0x02, 0x51, 0xE8, 0xF1, 0x54, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xA9, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 54 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x51, 0x48, 0xF1, 0x54, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x51, 0x98, 0xF1, 0x54, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x51, 0xE8, 0xF1, 0x54, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xAA, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 54.054 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x32, 0x6B, 0x10, 0x01, 0x51, 0x48, 0xF1, 0x54, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x28, 0x6B, 0x10, 0x01, 0x51, 0x98, 0xF1, 0x54, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x03, 0x32, 0x6B, 0x10, 0x01, 0x51, 0xE8, 0xF1, 0x54, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xA9, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 74.250 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x51, 0x78, 0xF3, 0x54, 0xA5, 0x84, 0x00, 0x20, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xB9, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x51, 0x28, 0xF2, 0x54, 0xCE, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x94, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x20, 0x40, 0x6B, 0x10, 0x01, 0x51, 0x98, 0xF2, 0x54, 0xF8, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xF7, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 74.176 MHz                                                                                                                                                                                      
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x56, 0x5B, 0x6B, 0x10, 0x01, 0x51, 0xB8, 0xF1, 0x54, 0xA5, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xB9, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x3E, 0x5B, 0x6B, 0x10, 0x01, 0x51, 0x28, 0xF2, 0x54, 0xCE, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x94, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x26, 0x5B, 0x6B, 0x10, 0x01, 0x51, 0x98, 0xF2, 0x54, 0xF7, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xF7, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 148.500 MHz  - Pre-emph + Higher Tx amp.                                                                                                                                                        
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0x78, 0xF3, 0x54, 0xA5, 0x84, 0x00, 0x20, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xB9, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0x28, 0xF2, 0x54, 0xCE, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x94, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x20, 0x40, 0x6B, 0x18, 0x01, 0x51, 0x98, 0xF2, 0x54, 0xF8, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x7B, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 148.352 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x56, 0x5B, 0x6B, 0x18, 0x01, 0x51, 0xB8, 0xF1, 0x54, 0xA5, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xB9, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x3E, 0x5B, 0x6B, 0x18, 0x01, 0x51, 0x28, 0xF2, 0x54, 0xCE, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x94, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x26, 0x5B, 0x6B, 0x18, 0x01, 0x51, 0x98, 0xF2, 0x54, 0xF7, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x7B, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 108.108 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x32, 0x6B, 0x18, 0x01, 0x51, 0x48, 0xF1, 0x54, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x28, 0x6B, 0x18, 0x01, 0x51, 0x98, 0xF1, 0x54, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x06, 0x64, 0x6B, 0x18, 0x01, 0x51, 0xE8, 0xF1, 0x54, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xA9, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 72 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0x88, 0xF2, 0x54, 0x50, 0x84, 0x00, 0x21, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xBF, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0x28, 0xF3, 0x54, 0x64, 0x84, 0x00, 0x21, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x99, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0x48, 0xF1, 0x54, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 25 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xE8, 0x36, 0x6B, 0x50, 0x11, 0x51, 0xC8, 0xF1, 0x54, 0xA7, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0x13, 0x27, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xE2, 0x36, 0x6B, 0x50, 0x11, 0x51, 0x38, 0xF2, 0x54, 0xD0, 0x84, 0x00, 0x00, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xDC, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xE8, 0x36, 0x6B, 0x10, 0x02, 0x51, 0xC8, 0xF1, 0x54, 0xA7, 0x84, 0x00, 0x00, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xB7, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 65 MHz                                                                                                                                                                                          
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x08, 0x36, 0x6B, 0x10, 0x01, 0x51, 0x88, 0xF1, 0x54, 0x90, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xD4, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x0A, 0x36, 0x6B, 0x10, 0x01, 0x51, 0xC8, 0xF3, 0x54, 0xB5, 0x84, 0x00, 0x20, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xA9, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x0C, 0x36, 0x6B, 0x10, 0x01, 0x51, 0x48, 0xF2, 0x54, 0xD9, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x8D, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 108 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0x48, 0xF1, 0x54, 0x78, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xFF, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0x98, 0xF1, 0x54, 0x96, 0x84, 0x00, 0x00, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xCC, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0xE8, 0xF1, 0x54, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xAA, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                        
		// freq = 162 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                         
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0xE8, 0xF1, 0x54, 0xB4, 0x84, 0x00, 0x00, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xAA, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0xB8, 0xF4, 0x54, 0xE1, 0x84, 0x00, 0x20, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x88, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x01, 0x51, 0xD8, 0xF2, 0x54, 0x0E, 0x85, 0x00, 0x00, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x71, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},
	};

#else	//PHY_IN_FREQ == PHY_IN_24MHz
	static const u8 phy_config[][3][32] = {
		// chip using internal video PLL ; (INT_27M pin(USB 24MHz))
		// freq = 25.200 MHz
		{
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x51, 0x58, 0xF1, 0x54, 0x7e, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xf3, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6F, 0x10, 0x02, 0x51, 0x98, 0xF6, 0x54, 0x9e, 0x84, 0x00, 0x32, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xc2, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6F, 0x10, 0x02, 0x51, 0xF8, 0xF3, 0x54, 0xbd, 0x84, 0x00, 0x30, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xa2, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 25.175 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x1e, 0x20, 0x6B, 0x50, 0x10, 0x51, 0xf8, 0xF1, 0x54, 0xbd, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xf3, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x2b, 0x40, 0x6B, 0x50, 0x10, 0x51, 0x78, 0xF2, 0x54, 0xec, 0x84, 0x00, 0x10, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xc2, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x1e, 0x20, 0x6B, 0x10, 0x02, 0x51, 0xf8, 0xF1, 0x54, 0xbd, 0x84, 0x00, 0x10, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xa2, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 27 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x02, 0x51, 0xD8, 0xF2, 0x54, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe3, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x08, 0x6A, 0x10, 0x02, 0x51, 0xC8, 0xF1, 0x54, 0xa9, 0x84, 0x00, 0x10, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xfc, 0x08, 0x6B, 0x10, 0x02, 0x51, 0x28, 0xF2, 0x54, 0xcb, 0x84, 0x00, 0x10, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 27.027 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0x09, 0x64, 0x6B, 0x10, 0x02, 0x51, 0xD8, 0xF2, 0x54, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe2, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0x31, 0x50, 0x6B, 0x10, 0x02, 0x51, 0x88, 0xF3, 0x54, 0xa9, 0x84, 0x00, 0x30, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0x1b, 0x64, 0x6F, 0x10, 0x02, 0x51, 0x78, 0xF8, 0x54, 0xcb, 0x84, 0x00, 0x32, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 54 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x51, 0xD8, 0xF2, 0x54, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe3, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x08, 0x6A, 0x10, 0x01, 0x51, 0xC8, 0xF1, 0x54, 0xa9, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xfc, 0x08, 0x6B, 0x10, 0x01, 0x51, 0x28, 0xF2, 0x54, 0xcb, 0x84, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 54.054 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xd4, 0x10, 0x9C, 0x09, 0x64, 0x6B, 0x10, 0x01, 0x51, 0xD8, 0xF2, 0x54, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe2, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xd4, 0x10, 0x9C, 0x31, 0x50, 0x6B, 0x10, 0x01, 0x51, 0x88, 0xF3, 0x54, 0xa9, 0x84, 0x00, 0x30, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0x1b, 0x64, 0x6F, 0x10, 0x01, 0x51, 0x78, 0xF8, 0x54, 0xcb, 0x84, 0x00, 0x32, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 74.250 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xf8, 0x40, 0x6A, 0x10, 0x01, 0x51, 0xf8, 0xF1, 0x54, 0xba, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xa4, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xd6, 0x40, 0x6B, 0x10, 0x01, 0x51, 0x78, 0xF2, 0x54, 0xe8, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x83, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x34, 0x40, 0x6B, 0x10, 0x01, 0x51, 0xe8, 0xF2, 0x54, 0x16, 0x85, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xdc, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 74.176 MHz                                                                                                                                                                                     
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xef, 0x5B, 0x6D, 0x10, 0x01, 0x51, 0xe8, 0xF3, 0x54, 0xb9, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xa5, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0xab, 0x5B, 0x6F, 0x10, 0x01, 0x51, 0xb8, 0xF9, 0x54, 0xe8, 0x84, 0x00, 0x32, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x84, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0xcd, 0x5B, 0x6F, 0x10, 0x01, 0x51, 0xd8, 0xF5, 0x54, 0x16, 0x85, 0x00, 0x30, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xdc, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 148.500 MHz  - Pre-emph + Higher Tx amp.                                                                                                                                                       
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xf8, 0x40, 0x6A, 0x18, 0x00, 0x51, 0xf8, 0xF1, 0x54, 0xba, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xa4, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xd6, 0x40, 0x6B, 0x18, 0x00, 0x51, 0x78, 0xF2, 0x54, 0xe8, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x23, 0x41, 0x83, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x34, 0x40, 0x6B, 0x18, 0x00, 0x51, 0xe8, 0xF2, 0x54, 0x16, 0x85, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x23, 0x41, 0x6d, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 148.352 MHz                                                                                                                                                                                    
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xef, 0x5B, 0x6D, 0x18, 0x00, 0x51, 0xe8, 0xF3, 0x54, 0xb9, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xa5, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0xab, 0x5B, 0x6F, 0x18, 0x00, 0x51, 0xb8, 0xF9, 0x54, 0xe8, 0x84, 0x00, 0x32, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x23, 0x41, 0x84, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0xcd, 0x5B, 0x6F, 0x18, 0x00, 0x51, 0xd8, 0xF5, 0x54, 0x16, 0x85, 0x00, 0x30, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x23, 0x41, 0x6d, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 108.108 MHz                                                                                                                                                                                    
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0x09, 0x64, 0x6B, 0x18, 0x00, 0x51, 0xD8, 0xF2, 0x54, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe2, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD4, 0x10, 0x9C, 0x31, 0x50, 0x6D, 0x18, 0x00, 0x51, 0x88, 0xF3, 0x54, 0xa9, 0x84, 0x00, 0x30, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0x10, 0x10, 0x9C, 0x1b, 0x64, 0x6F, 0x18, 0x00, 0x51, 0x78, 0xF8, 0x54, 0xcb, 0x84, 0x00, 0x32, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 72 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x10, 0x01, 0x51, 0xE8, 0xF1, 0x54, 0xb4, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xaa, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6F, 0x10, 0x01, 0x51, 0xB8, 0xF4, 0x54, 0xe1, 0x84, 0x00, 0x30, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x88, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6B, 0x18, 0x00, 0x51, 0xD8, 0xF2, 0x54, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0xe3, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 25 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x20, 0x40, 0x6B, 0x50, 0x10, 0x51, 0xf8, 0xF1, 0x54, 0xbc, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xf5, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x08, 0x40, 0x6B, 0x50, 0x10, 0x51, 0x78, 0xF2, 0x54, 0xea, 0x84, 0x00, 0x10, 0x38, 0x00, 0xB8, 0x10, 0xE0, 0x22, 0x40, 0xc4, 0x26, 0x00, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x20, 0x40, 0x6B, 0x10, 0x02, 0x51, 0xf8, 0xF1, 0x54, 0xbc, 0x84, 0x00, 0x10, 0x38, 0x00, 0xA4, 0x10, 0xE0, 0x22, 0x40, 0xa3, 0x26, 0x00, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                      
		// freq = 65 MHz                                                                                                                                                                                         
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x0c, 0x6B, 0x10, 0x01, 0x51, 0xB8, 0xF1, 0x54, 0xa3, 0x84, 0x00, 0x10, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xbc, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xf2, 0x30, 0x6A, 0x10, 0x01, 0x51, 0x28, 0xF2, 0x54, 0xcb, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0x96, 0x26, 0x01, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xd0, 0x40, 0x6B, 0x10, 0x01, 0x51, 0x98, 0xF2, 0x54, 0xf4, 0x84, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x7D, 0x26, 0x01, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 108 MHz                                                                                                                                                                                        
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6D, 0x18, 0x00, 0x51, 0xD8, 0xF2, 0x54, 0x87, 0x84, 0x00, 0x30, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0xe3, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x02, 0x08, 0x6A, 0x18, 0x00, 0x51, 0xC8, 0xF1, 0x54, 0xa9, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x22, 0x40, 0xb5, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xfc, 0x08, 0x6B, 0x18, 0x00, 0x51, 0x28, 0xF2, 0x54, 0xcb, 0x84, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},                                                                                                                                                                                                       
		// freq = 162 MHz                                                                                                                                                                                        
		{                                                                                                                                                                                                        
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x1C, 0x30, 0x40, 0x6F, 0x18, 0x00, 0x51, 0x78, 0xF8, 0x54, 0xcb, 0x84, 0x00, 0x32, 0x38, 0x00, 0x08, 0x10, 0xE0, 0x22, 0x40, 0x97, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0x18, 0x40, 0x6B, 0x18, 0x00, 0x51, 0xA8, 0xF2, 0x54, 0xfd, 0x84, 0x00, 0x10, 0x38, 0x00, 0xF8, 0x10, 0xE0, 0x23, 0x41, 0x78, 0x26, 0x02, 0x00, 0x00, 0x80, },
			{ 0x01, 0x05, 0x00, 0xD8, 0x10, 0x9C, 0xd0, 0x40, 0x6B, 0x18, 0x00, 0x51, 0x38, 0xF3, 0x54, 0x30, 0x85, 0x00, 0x10, 0x38, 0x00, 0xE4, 0x10, 0xE0, 0x23, 0x41, 0x64, 0x26, 0x02, 0x00, 0x00, 0x80, },
		},
	};
#endif




#endif

/**
 * Configure PHY HW based on pixel frequency
 * 
 * @return  On success, return OK;Otherwise, return ERROR
 */
s32 PHYConfig(PHYFreq freq, ColorDepth cd)
{
	u32 i, uTemp32;
	s32 index;
	s32 size;
	u8 *buffer;
	u8 buff[2], pReadBuffer[0x40]={0, };

	SYSC_SetClkMuxState(eCLKMUX_MIXER_SDAC);
	SYSC_SetClkMuxState(eCLKMUX_HDMI_SPIXEL);
		
	switch (cd)
	{
		case HDMI_CD_24:
			index = 0;
			break;
		case HDMI_CD_30:
			index = 1;
			break;
		case HDMI_CD_36:
			index = 2;
			break;
		default:
			return FALSE;
	}

	I2CHDMI_Init();

	size = sizeof(phy_config[freq][index]) /
	sizeof(phy_config[freq][index][0]);
	buffer = (u8 *) phy_config[freq][index];

	if (I2CHDMI_Write(PHY_I2C_ADDRESS, size, buffer) != OK)
	{
		return ERROR;
	}

#if 0	
	// start to reconfig after that phy_ready goes down
	buff[0] = PHY_REG_MODE_SET_DONE;
	buff[1] = 0x80;
	if (I2CHDMI_Write(PHY_I2C_ADDRESS, 2, buff) != OK)
	{
		return ERROR;
	}
#endif

	buffer[0] = 0x01;
	// write offset
	if (I2CHDMI_Write(PHY_I2C_ADDRESS, 1, buffer) != 0)
	{
		UART_Printf("I2CHDMIWrite() failed.\n");
		return ERROR;
	}

	// read data
	if (I2CHDMI_Read(PHY_I2C_ADDRESS, size, pReadBuffer) != 0)
	{
		UART_Printf("I2CHDMIRead() failed.\n");
		return ERROR;
	}

	for (i=1; i < size; i++)
	{
		UART_Printf("0x%02x", pReadBuffer[i]);
		if (i % 8)
		{
			UART_Printf(" ");
		}
		else
		{
			UART_Printf("\n");
		}
	}

	UART_Printf("\n");

	HDMI_CheckPhyReady();
	SYSC_SetClkMuxState(eCLKMUX_MIXER_SHDMI);
	SYSC_SetClkMuxState(eCLKMUX_HDMI_SHDMIPHY);

	return OK;
}

s32 PHY_TxPowerDown(void)
{
	u8 buff[2];

	I2CHDMI_Init();

	buff[0] = 0x17;
	buff[1] = 0xe2;
	if (I2CHDMI_Write(PHY_I2C_ADDRESS, 2, buff) != OK)
	{
		return ERROR;
	}

	return OK;
}



