/**
 * File Name : hpd.c
 *
 * File Description :
 * This file implements the hdmi v1.3 detection function in S5PV210 project
 *
 * Author : Hee Myung Noh
 * Dept : AP Development
 * Created Date : 2009/01/22
 * Version : 0.1
 * History 
 *  - Initiate version (Hee Myung Noh 090122)
 */

#include "system.h"
#include "Library.h"
#include "v210_sfr.h"
#include "intc.h"
#include "hdmi_reg.h"
#include "hdmi.h"
#include "phy.h"
#include "hpd.h"
#include "gpio.h"

///rb1004
///static EventGroup gHPDEvent;

#define EVENT_HDMI_HPD_PLUG_HAPPEN              0
#define EVENT_HDMI_HPD_UNPLUG_HAPPEN            1

//#define	DISP_HPD_REG

#ifndef DISP_HPD_REG
#define HpdOutp8(addr, data) 		Outp8(addr, data)
#define HpdInp8(addr)  			Inp8(addr)
#else
#define HpdOutp8(addr, data) 		{UART_Printf("Outp8(\'h%08x, \'h%08x);\n", addr, data), Outp8(addr, data);}
#define HpdInp8(addr) 			{Inp8(addr); UART_Printf("Inp8(\'h%08x, d); // d=0x%08x\n", addr, Inp8(addr));}
#endif

static u32 g_HPD_Event = (1<<EVENT_HDMI_HPD_UNPLUG_HAPPEN);

/** 
 * HPD interrupt service routine.
 */ 
void HPD_ISR(u32 IRQNum)
{
	u8 ucIntFlag, ucIntEnable;

	ucIntFlag = Inp32(rHDMI_INTC_FLAG);

	if(ucIntFlag & (1<<HDMI_IRQ_HPD_UNPLUG) )
	{
		//Pending Clear
		HpdOutp8(rHDMI_INTC_FLAG, 1<<HDMI_IRQ_HPD_UNPLUG);

		ucIntEnable = HpdInp8(rHDMI_INTC_CON);
		HpdOutp8(rHDMI_INTC_CON, ucIntEnable & ~(1<<HDMI_IRQ_HPD_UNPLUG) | (1<<HDMI_IRQ_HPD_PLUG));
		
		g_HPD_Event = (1<<EVENT_HDMI_HPD_UNPLUG_HAPPEN);
///		UART_Printf("HPD Plug Out was detected!\n");
	}
	else if(ucIntFlag & (1<<HDMI_IRQ_HPD_PLUG) )
	{
		//Pending Clear
		HpdOutp8(rHDMI_INTC_FLAG, 1<<HDMI_IRQ_HPD_PLUG);

		ucIntEnable = HpdInp8(rHDMI_INTC_CON);
		HpdOutp8(rHDMI_INTC_CON, ucIntEnable & ~(1<<HDMI_IRQ_HPD_PLUG) | (1<<HDMI_IRQ_HPD_UNPLUG));
		
		g_HPD_Event = (1<<EVENT_HDMI_HPD_PLUG_HAPPEN);
///		UART_Printf("HPD Plug In was detected!\n");
	}
	 
	else
		UART_Printf("This is not HPD INT\n");
	
    return;
}

/* Initialize HPD library
 * 
 * @return  On Success, return OK, otherwise, return ERROR
 */ 
s32 HPD_Init(void)
{
	u8 ucReg, ucHPDStatus;

	UART_Printf("[HPD_Init]\n");
//===============================================================================//
#if 0
	EventInit(&gHPDEvent);

	UART_Printf("%s\n", __FUNCTION__);

	// install HPD ISR on GPIO
	if (IntCreateDirectISR(INT_GPIO, HPDISR) != 0)
	{
		UART_Printf("fail to register HPD Interrupt Service Routine!!!\n");
		return ERROR;
	}

	// enable INT for GPIO_0 
	// GPIO_0 is for HPD

	// IO Mode for Input - set to 1
	Outp32(rGPIO_IOPMODE, GPIO_HPD);

	// LEVEL to High - set to 1
	Outp32(rGPIO_LEVEL, GPIO_HPD);

	// INT_EN - set to 1
	Outp32(rGPIO_INTEN, GPIO_HPD);

	// INT_EN on VIC
	IntUnmask(1 << INT_GPIO);

	// temporary
	// for detecting initial 1 HPD state
	// IO Mode for Input - set to 0
	Outp32(rGPIO_IOPMODE, 0x0000);

	// IO Mode for Input - set to 0
	Outp32(rGPIO_IOPMODE, GPIO_HPD);
#else
//===============================================================================//
	// HW HPD duration for stable HPD input
	HpdOutp8(rHDMI_HPD_GEN, 0xff);

	//HPD GPIO Setting
	//*(u32 *)0xE0200C20 = (*(u32 *)0xE0200C20&~(0xf<<20)) | (0x4<<20);
	//*(u32 *)0xE0200C28 = *(u32 *)0xE0200C28&~(0x3<<10);
	GPIO_SetFunctionEach(eGPIO_H1, eGPIO_5, 4);
	GPIO_SetPullUpDownEach(eGPIO_H1, eGPIO_5, 0);
	
	// ISR install
	if ( HDMI_RegisterISR(HPD_ISR,HDMI_IRQ_HPD_PLUG) != 0 )
	{
		UART_Printf("fail to register HPD_PLUG Interrupt Service Routine\n\n");
		return ERROR;
	}
	if ( HDMI_RegisterISR(HPD_ISR,HDMI_IRQ_HPD_UNPLUG) != 0 )
	{
		UART_Printf("fail to register HPD_UNPLUG Interrupt Service Routine\n\n");
		return ERROR;
	}	

	// HPD Pending Clear
	HpdOutp8(rHDMI_INTC_FLAG, (1<<HDMI_IRQ_HPD_PLUG) | (1<<HDMI_IRQ_HPD_UNPLUG));

#if 1
	ucHPDStatus = HpdInp8(rHDMI_HPD_STATUS);
	if(ucHPDStatus = HDMI_HPD_PLUG)
	{
		g_HPD_Event = (1<<EVENT_HDMI_HPD_PLUG_HAPPEN);
		
		ucReg = HpdInp8(rHDMI_INTC_CON);
		HpdOutp8(rHDMI_INTC_CON, ucReg | (1<<HDMI_IRQ_HPD_UNPLUG) | (1<<HDMI_IRQ_GLOBAL));
	}
	else
	{
		g_HPD_Event = (1<<EVENT_HDMI_HPD_UNPLUG_HAPPEN);
		
		ucReg = HpdInp8(rHDMI_INTC_CON);
		HpdOutp8(rHDMI_INTC_CON, ucReg | (1<<HDMI_IRQ_HPD_PLUG) | (1<<HDMI_IRQ_GLOBAL));
	}
#else	
	ucReg = HpdInp8(rHDMI_INTC_CON);
	HpdOutp8(rHDMI_INTC_CON, ucReg | (1<<HDMI_IRQ_HPD_PLUG) | (1<<HDMI_IRQ_HPD_UNPLUG) | (1<<HDMI_IRQ_GLOBAL));
#endif

#endif

    return OK;
}

/** 
 * Start detecting the change of HPD.
 *
 * @return  If HPD signal is changed from low to high, return HDMI_HPD_CABLE_IN @n
 *          else if HPD signal is changed from high to low, return HDMI_HPD_CABLE_OUT @n
 *          Otherwise, return ERROR.
 */
s32 HPD_Detect(void)
{

	if (g_HPD_Event & (1<<EVENT_HDMI_HPD_PLUG_HAPPEN))// if HPD_PLUG
	{
		return HDMI_HPD_CABLE_IN;
	}
	else if (g_HPD_Event & (1<<EVENT_HDMI_HPD_UNPLUG_HAPPEN))
	{
		return HDMI_HPD_CABLE_OUT;
	}
	else
	{
		UART_Printf("!!! Invalid Event on HPD routine !!!\n");
		return ERROR;    
	}
}
