//-------------------------------------------------------------------
// Copyright SAMSUNG Electronics Co., Ltd
// All right reserved.
//
// This software is the confidential and proprietary information
// of Samsung Electronics, Inc. ("Confidential Information").  You
// shall not disclose such Confidential Information and shall use
// it only in accordance with the terms of the license agreement
// you entered into with Samsung Electronics. 
//-------------------------------------------------------------------

#ifndef _HDMI_REG_H_
#define _HDMI_REG_H_


#ifdef __cplusplus
extern "C" {
#endif

// SFR Base Define
#define	HDMI_CTRL_BASE			(HDMI_BASE)
#define	HDMI_CORE_BASE			(HDMI_BASE + 0x10000)
#define	HDMI_SPDIF_BASE			(HDMI_BASE + 0x30000)
#define	HDMI_I2S_BASE				(HDMI_BASE + 0x40000)
#define	HDMI_TG_BASE				(HDMI_BASE + 0x50000)
#define	HDMI_EFUSE_BASE			(HDMI_BASE + 0x60000)
#define	HDMI_CEC_BASE				(0xE1B00000)
//#define	HDMI_CEC_BASE				(0x01B00000)

typedef enum HDMI_SFR
{
	// HDMI Control Register
	rHDMI_INTC_CON				=	HDMI_CTRL_BASE + 0x000,
	rHDMI_INTC_FLAG				=	HDMI_CTRL_BASE + 0x004,
	rHDMI_HPD_STATUS				=	HDMI_CTRL_BASE + 0x00C,
	rHDMI_AUDIO_CLKSEL			=	HDMI_CTRL_BASE + 0x010,
	rHDMI_PHY_RSTOUT				=	HDMI_CTRL_BASE + 0x014,
	rHDMI_PHY_VPLL					=	HDMI_CTRL_BASE + 0x018,
	rHDMI_PHY_CMU					=	HDMI_CTRL_BASE + 0x01C,
	rHDNI_CORE_RSTOUT				=	HDMI_CTRL_BASE + 0x020,
	
	// HDMI Core Register
	rHDMI_CON_0					= 	HDMI_CORE_BASE + 0x000,
	rHDMI_CON_1					= 	HDMI_CORE_BASE + 0x004,
	rHDMI_CON_2					=	HDMI_CORE_BASE + 0x008,
	rHDMI_STATUS					=	HDMI_CORE_BASE + 0x010,
	rHDMI_PHY_STATUS				=	HDMI_CORE_BASE + 0x014,
	rHDMI_STATUS_EN				=	HDMI_CORE_BASE + 0x020,
	rHDMI_HPD						=	HDMI_CORE_BASE + 0x030,
	rHDMI_MODE_SEL				=	HDMI_CORE_BASE + 0x040,
	rHDCP_ENC_EN					=	HDMI_CORE_BASE + 0x044,
	
	rHDMI_BLUE_SCREEN_0			= 	HDMI_CORE_BASE + 0x050,
	rHDMI_BLUE_SCREEN_1			=	HDMI_CORE_BASE + 0x054,
	rHDMI_BLUE_SCREEN_2			=	HDMI_CORE_BASE + 0x058,
	
	rHDMI_YMAX						=	HDMI_CORE_BASE + 0x060,
	rHDMI_YMIN						=	HDMI_CORE_BASE + 0x064,
	rHDMI_CMAX						=	HDMI_CORE_BASE + 0x068,
	rHDMI_CMIN						=	HDMI_CORE_BASE + 0x06c,

	rHDMI_VACT_ST_MG				=	HDMI_CORE_BASE + 0x088,			//hidden
	rHDMI_VACT_END_MG			=	HDMI_CORE_BASE + 0x08c,			//hidden
	
	rHDMI_H_BLANK_0				=	HDMI_CORE_BASE + 0x0a0,
	rHDMI_H_BLANK_1				=	HDMI_CORE_BASE + 0x0a4,
	rHDMI_V_BLANK_0				=	HDMI_CORE_BASE + 0x0b0,
	rHDMI_V_BLANK_1				=	HDMI_CORE_BASE + 0x0b4,
	rHDMI_V_BLANK_2				=	HDMI_CORE_BASE + 0x0b8,
	rHDMI_H_V_LINE_0				=	HDMI_CORE_BASE + 0x0c0,
	rHDMI_H_V_LINE_1				=	HDMI_CORE_BASE + 0x0c4,
	rHDMI_H_V_LINE_2				=	HDMI_CORE_BASE + 0x0c8,
	
	rHDMI_VSYNC_POL				=	HDMI_CORE_BASE + 0x0e4,
	rHDMI_INT_PRO_MODE			=	HDMI_CORE_BASE + 0x0e8,

	rHDMI_SEND_START_0			=	HDMI_CORE_BASE + 0x0f0,			//hidden
	rHDMI_SEND_START_1			=	HDMI_CORE_BASE + 0x0f4,			//hidden
	rHDMI_SEND_END_0				=	HDMI_CORE_BASE + 0x100,			//hidden
	rHDMI_SEND_END_1				=	HDMI_CORE_BASE + 0x104,			//hidden
	rHDMI_SEND_END_2				=	HDMI_CORE_BASE + 0x108,			//hidden
	
	rHDMI_V_BLANK_F_0				=	HDMI_CORE_BASE + 0x110,
	rHDMI_V_BLANK_F_1				=	HDMI_CORE_BASE + 0x114,
	rHDMI_V_BLANK_F_2				=	HDMI_CORE_BASE + 0x118,
	rHDMI_H_SYNC_GEN_0			=	HDMI_CORE_BASE + 0x120,
	rHDMI_H_SYNC_GEN_1			=	HDMI_CORE_BASE + 0x124,
	rHDMI_H_SYNC_GEN_2			=	HDMI_CORE_BASE + 0x128,                                                           
	rHDMI_V_SYNC_GEN1_0			=	HDMI_CORE_BASE + 0x130,
	rHDMI_V_SYNC_GEN1_1			=	HDMI_CORE_BASE + 0x134,
	rHDMI_V_SYNC_GEN1_2			=	HDMI_CORE_BASE + 0x138,
	rHDMI_V_SYNC_GEN2_0			=	HDMI_CORE_BASE + 0x140,
	rHDMI_V_SYNC_GEN2_1			=	HDMI_CORE_BASE + 0x144,
	rHDMI_V_SYNC_GEN2_2			=	HDMI_CORE_BASE + 0x148,
	rHDMI_V_SYNC_GEN3_0			=	HDMI_CORE_BASE + 0x150,
	rHDMI_V_SYNC_GEN3_1			=	HDMI_CORE_BASE + 0x154,
	rHDMI_V_SYNC_GEN3_2			=	HDMI_CORE_BASE + 0x158,

	rHDMI_ASP_CON					=	HDMI_CORE_BASE + 0x160,
	rHDMI_ASP_SP_FLAT				=	HDMI_CORE_BASE + 0x164,
	rHDMI_ASP_CHCFG0				=	HDMI_CORE_BASE + 0x170,
	rHDMI_ASP_CHCFG1				=	HDMI_CORE_BASE + 0x174,
	rHDMI_ASP_CHCFG2				=	HDMI_CORE_BASE + 0x178,
	rHDMI_ASP_CHCFG3				=	HDMI_CORE_BASE + 0x17c,
	
	rHDMI_ACR_CON					=	HDMI_CORE_BASE + 0x180,
	rHDMI_ACR_MCTS0				=	HDMI_CORE_BASE + 0x184,
	rHDMI_ACR_MCTS1				=	HDMI_CORE_BASE + 0x188,
	rHDMI_ACR_MCTS2				=	HDMI_CORE_BASE + 0x18c,
	rHDMI_ACR_CTS0				=	HDMI_CORE_BASE + 0x190,
	rHDMI_ACR_CTS1				=	HDMI_CORE_BASE + 0x194,
	rHDMI_ACR_CTS2				=	HDMI_CORE_BASE + 0x198,
	rHDMI_ACR_N0					=	HDMI_CORE_BASE + 0x1a0,
	rHDMI_ACR_N1					=	HDMI_CORE_BASE + 0x1a4,
	rHDMI_ACR_N2					=	HDMI_CORE_BASE + 0x1a8,
	rHDMI_ACR_LSB2				=	HDMI_CORE_BASE + 0x1b0,
	rHDMI_ACR_TXCNT				=	HDMI_CORE_BASE + 0x1b4,
	rHDMI_ACR_TXINTERNAL			=	HDMI_CORE_BASE + 0x1b8,
	rHDMI_ACR_CTS_OFFSET			=	HDMI_CORE_BASE + 0x1bc,
	
	rHDMI_GCP_CON					=	HDMI_CORE_BASE + 0x1c0,
	rHDMI_GCP_BYTE1				=	HDMI_CORE_BASE + 0x1d0,
	rHDMI_GCP_BYTE2				=	HDMI_CORE_BASE + 0x1d4,
	rHDMI_GCP_BYTE3				=	HDMI_CORE_BASE + 0x1d8,

	rHDMI_ACP_CON					=	HDMI_CORE_BASE + 0x1e0,
	rHDMI_ACP_TYPE				=	HDMI_CORE_BASE + 0x1e4,
	rHDMI_ACP_DATA00				=	HDMI_CORE_BASE + 0x200,
	rHDMI_ACP_DATA01				=	HDMI_CORE_BASE + 0x204,
	rHDMI_ACP_DATA02				=	HDMI_CORE_BASE + 0x208,
	rHDMI_ACP_DATA03				=	HDMI_CORE_BASE + 0x20c,
	rHDMI_ACP_DATA04				=	HDMI_CORE_BASE + 0x210,
	rHDMI_ACP_DATA05				=	HDMI_CORE_BASE + 0x214,
	rHDMI_ACP_DATA06				=	HDMI_CORE_BASE + 0x218,
	rHDMI_ACP_DATA07				=	HDMI_CORE_BASE + 0x21c,
	rHDMI_ACP_DATA08				=	HDMI_CORE_BASE + 0x220,
	rHDMI_ACP_DATA09				=	HDMI_CORE_BASE + 0x224,
	rHDMI_ACP_DATA10				=	HDMI_CORE_BASE + 0x228,
	rHDMI_ACP_DATA11				=	HDMI_CORE_BASE + 0x22c,
	rHDMI_ACP_DATA12				=	HDMI_CORE_BASE + 0x230,
	rHDMI_ACP_DATA13				=	HDMI_CORE_BASE + 0x234,
	rHDMI_ACP_DATA14				=	HDMI_CORE_BASE + 0x238,
	rHDMI_ACP_DATA15				=	HDMI_CORE_BASE + 0x23c,
	rHDMI_ACP_DATA16				=	HDMI_CORE_BASE + 0x240,

	rHDMI_ISRC_CON				=	HDMI_CORE_BASE + 0x250,
	rHDMI_ISRC1_HEADER1			=	HDMI_CORE_BASE + 0x264,
	rHDMI_ISRC1_DATA00			=	HDMI_CORE_BASE + 0x270,
	rHDMI_ISRC1_DATA01			=	HDMI_CORE_BASE + 0x274,
	rHDMI_ISRC1_DATA02			=	HDMI_CORE_BASE + 0x278,
	rHDMI_ISRC1_DATA03			=	HDMI_CORE_BASE + 0x27c,
	rHDMI_ISRC1_DATA04			=	HDMI_CORE_BASE + 0x280,
	rHDMI_ISRC1_DATA05			=	HDMI_CORE_BASE + 0x284,
	rHDMI_ISRC1_DATA06			=	HDMI_CORE_BASE + 0x288,
	rHDMI_ISRC1_DATA07			=	HDMI_CORE_BASE + 0x28c,
	rHDMI_ISRC1_DATA08			=	HDMI_CORE_BASE + 0x290,
	rHDMI_ISRC1_DATA09			=	HDMI_CORE_BASE + 0x294,
	rHDMI_ISRC1_DATA10			=	HDMI_CORE_BASE + 0x298,
	rHDMI_ISRC1_DATA11			=	HDMI_CORE_BASE + 0x29c,
	rHDMI_ISRC1_DATA12			=	HDMI_CORE_BASE + 0x2a0,
	rHDMI_ISRC1_DATA13			=	HDMI_CORE_BASE + 0x2a4,
	rHDMI_ISRC1_DATA14			=	HDMI_CORE_BASE + 0x2a8,
	rHDMI_ISRC1_DATA15			=	HDMI_CORE_BASE + 0x2ac,
	rHDMI_ISRC2_DATA00			=	HDMI_CORE_BASE + 0x2b0,
	rHDMI_ISRC2_DATA01			=	HDMI_CORE_BASE + 0x2b4,
	rHDMI_ISRC2_DATA02			=	HDMI_CORE_BASE + 0x2b8,
	rHDMI_ISRC2_DATA03			=	HDMI_CORE_BASE + 0x2bc,
	rHDMI_ISRC2_DATA04			=	HDMI_CORE_BASE + 0x2c0,
	rHDMI_ISRC2_DATA05			=	HDMI_CORE_BASE + 0x2c4,
	rHDMI_ISRC2_DATA06			=	HDMI_CORE_BASE + 0x2c8,
	rHDMI_ISRC2_DATA07			=	HDMI_CORE_BASE + 0x2cc,
	rHDMI_ISRC2_DATA08			=	HDMI_CORE_BASE + 0x2d0,
	rHDMI_ISRC2_DATA09			=	HDMI_CORE_BASE + 0x2d4,
	rHDMI_ISRC2_DATA10			=	HDMI_CORE_BASE + 0x2d8,
	rHDMI_ISRC2_DATA11			=	HDMI_CORE_BASE + 0x2dc,
	rHDMI_ISRC2_DATA12			=	HDMI_CORE_BASE + 0x2e0,
	rHDMI_ISRC2_DATA13			=	HDMI_CORE_BASE + 0x2e4,
	rHDMI_ISRC2_DATA14			=	HDMI_CORE_BASE + 0x2e8,
	rHDMI_ISRC2_DATA15			=	HDMI_CORE_BASE + 0x2ec,

	rHDMI_AVI_CON					=	HDMI_CORE_BASE + 0x300,
	rHDMI_AVI_CHECK_SUM			=	HDMI_CORE_BASE + 0x310,
	rHDMI_AVI_BYTE1				=	HDMI_CORE_BASE + 0x320,
	rHDMI_AVI_BYTE2				=	HDMI_CORE_BASE + 0x324,
	rHDMI_AVI_BYTE3				=	HDMI_CORE_BASE + 0x328,
	rHDMI_AVI_BYTE4				=	HDMI_CORE_BASE + 0x32c,
	rHDMI_AVI_BYTE5				=	HDMI_CORE_BASE + 0x330,
	rHDMI_AVI_BYTE6				=	HDMI_CORE_BASE + 0x334,
	rHDMI_AVI_BYTE7				=	HDMI_CORE_BASE + 0x338,
	rHDMI_AVI_BYTE8				=	HDMI_CORE_BASE + 0x33c,
	rHDMI_AVI_BYTE9				=	HDMI_CORE_BASE + 0x340,
	rHDMI_AVI_BYTE10				=	HDMI_CORE_BASE + 0x344,
	rHDMI_AVI_BYTE11				=	HDMI_CORE_BASE + 0x348,
	rHDMI_AVI_BYTE12				=	HDMI_CORE_BASE + 0x34c,
	rHDMI_AVI_BYTE13				=	HDMI_CORE_BASE + 0x350,

	rHDMI_AUI_CON					=	HDMI_CORE_BASE + 0x360,
	rHDMI_AUI_CHECK_SUM			=	HDMI_CORE_BASE + 0x370,
	rHDMI_AUI_BYTE1				=	HDMI_CORE_BASE + 0x380,
	rHDMI_AUI_BYTE2				=	HDMI_CORE_BASE + 0x384,
	rHDMI_AUI_BYTE3				=	HDMI_CORE_BASE + 0x388,
	rHDMI_AUI_BYTE4				=	HDMI_CORE_BASE + 0x38c,
	rHDMI_AUI_BYTE5				=	HDMI_CORE_BASE + 0x390,

	rHDMI_MPG_CON					=	HDMI_CORE_BASE + 0x3a0,
	rHDMI_MPG_CHECK_SUM			=	HDMI_CORE_BASE + 0x3b0,
	rHDMI_MPG_BYTE1				=	HDMI_CORE_BASE + 0x3c0,
	rHDMI_MPG_BYTE2				=	HDMI_CORE_BASE + 0x3c4,
	rHDMI_MPG_BYTE3				=	HDMI_CORE_BASE + 0x3c8,
	rHDMI_MPG_BYTE4				=	HDMI_CORE_BASE + 0x3cc,
	rHDMI_MPG_BYTE5				=	HDMI_CORE_BASE + 0x3d0,

	rHDMI_SPD_CON					=	HDMI_CORE_BASE + 0x400,
	rHDMI_SPD_HEADER0			=	HDMI_CORE_BASE + 0x410,
	rHDMI_SPD_HEADER1			=	HDMI_CORE_BASE + 0x414,
	rHDMI_SPD_HEADER2			=	HDMI_CORE_BASE + 0x418,
	rHDMI_SPD_DATA00				=	HDMI_CORE_BASE + 0x420,
	rHDMI_SPD_DATA01				=	HDMI_CORE_BASE + 0x424,
	rHDMI_SPD_DATA02				=	HDMI_CORE_BASE + 0x428,
	rHDMI_SPD_DATA03				=	HDMI_CORE_BASE + 0x42c,
	rHDMI_SPD_DATA04				=	HDMI_CORE_BASE + 0x430,
	rHDMI_SPD_DATA05				=	HDMI_CORE_BASE + 0x434,
	rHDMI_SPD_DATA06				=	HDMI_CORE_BASE + 0x438,
	rHDMI_SPD_DATA07				=	HDMI_CORE_BASE + 0x43c,
	rHDMI_SPD_DATA08				=	HDMI_CORE_BASE + 0x440,
	rHDMI_SPD_DATA09				=	HDMI_CORE_BASE + 0x444,
	rHDMI_SPD_DATA10				=	HDMI_CORE_BASE + 0x448,
	rHDMI_SPD_DATA11				=	HDMI_CORE_BASE + 0x44c,
	rHDMI_SPD_DATA12				=	HDMI_CORE_BASE + 0x450,
	rHDMI_SPD_DATA13				=	HDMI_CORE_BASE + 0x454,
	rHDMI_SPD_DATA14				=	HDMI_CORE_BASE + 0x458,
	rHDMI_SPD_DATA15				=	HDMI_CORE_BASE + 0x45c,
	rHDMI_SPD_DATA16				=	HDMI_CORE_BASE + 0x460,
	rHDMI_SPD_DATA17				=	HDMI_CORE_BASE + 0x464,
	rHDMI_SPD_DATA18				=	HDMI_CORE_BASE + 0x468,
	rHDMI_SPD_DATA19				=	HDMI_CORE_BASE + 0x46c,
	rHDMI_SPD_DATA20				=	HDMI_CORE_BASE + 0x470,
	rHDMI_SPD_DATA21				=	HDMI_CORE_BASE + 0x474,
	rHDMI_SPD_DATA22				=	HDMI_CORE_BASE + 0x478,
	rHDMI_SPD_DATA23				=	HDMI_CORE_BASE + 0x47c,
	rHDMI_SPD_DATA24				=	HDMI_CORE_BASE + 0x480,
	rHDMI_SPD_DATA25				=	HDMI_CORE_BASE + 0x484,
	rHDMI_SPD_DATA26				=	HDMI_CORE_BASE + 0x488,
	rHDMI_SPD_DATA27				=	HDMI_CORE_BASE + 0x48c,

	rHDCP_SHA1_00					=	HDMI_CORE_BASE + 0x600,
	rHDCP_SHA1_01					=	HDMI_CORE_BASE + 0x604,	
	rHDCP_SHA1_02					=	HDMI_CORE_BASE + 0x608,
	rHDCP_SHA1_03					=	HDMI_CORE_BASE + 0x60c,	
	rHDCP_SHA1_04					=	HDMI_CORE_BASE + 0x610,	
	rHDCP_SHA1_05					=	HDMI_CORE_BASE + 0x614,	
	rHDCP_SHA1_06					=	HDMI_CORE_BASE + 0x618,
	rHDCP_SHA1_07					=	HDMI_CORE_BASE + 0x61c,	
	rHDCP_SHA1_08					=	HDMI_CORE_BASE + 0x620,	
	rHDCP_SHA1_09					=	HDMI_CORE_BASE + 0x624,	
	rHDCP_SHA1_10					=	HDMI_CORE_BASE + 0x628,
	rHDCP_SHA1_11					=	HDMI_CORE_BASE + 0x62c,	
	rHDCP_SHA1_12					=	HDMI_CORE_BASE + 0x630,	
	rHDCP_SHA1_13					=	HDMI_CORE_BASE + 0x634,	
	rHDCP_SHA1_14					=	HDMI_CORE_BASE + 0x638,
	rHDCP_SHA1_15					=	HDMI_CORE_BASE + 0x63c,	
	rHDCP_SHA1_16					=	HDMI_CORE_BASE + 0x640,	
	rHDCP_SHA1_17					=	HDMI_CORE_BASE + 0x644,	
	rHDCP_SHA1_18					=	HDMI_CORE_BASE + 0x648,
	rHDCP_SHA1_19					=	HDMI_CORE_BASE + 0x64c,	

	rHDCP_KSV_LIST_0				=	HDMI_CORE_BASE + 0x650,	
	rHDCP_KSV_LIST_1				=	HDMI_CORE_BASE + 0x654,	
	rHDCP_KSV_LIST_2				=	HDMI_CORE_BASE + 0x658,	
	rHDCP_KSV_LIST_3				=	HDMI_CORE_BASE + 0x65c,		
	rHDCP_KSV_LIST_4				=	HDMI_CORE_BASE + 0x660,	

	rHDCP_KSV_LIST_CON			=	HDMI_CORE_BASE + 0x664,
	rHDCP_SHA_RESULT				=	HDMI_CORE_BASE + 0x670,
	rHDCP_CTRL1					=	HDMI_CORE_BASE + 0x680,
	rHDCP_CTRL2					=	HDMI_CORE_BASE + 0x684,
	rHDCP_CHECK_RESULT			=	HDMI_CORE_BASE + 0x690,
	
	rHDCP_BKSV_0					=	HDMI_CORE_BASE + 0x6a0,
	rHDCP_BKSV_1					=	HDMI_CORE_BASE + 0x6a4,
	rHDCP_BKSV_2					=	HDMI_CORE_BASE + 0x6a8,	
	rHDCP_BKSV_3					=	HDMI_CORE_BASE + 0x6ac,
	rHDCP_BKSV_4					=	HDMI_CORE_BASE + 0x6b0,		
	
	rHDCP_AKSV_0					=	HDMI_CORE_BASE + 0x6c0,
	rHDCP_AKSV_1					=	HDMI_CORE_BASE + 0x6c4,
	rHDCP_AKSV_2					=	HDMI_CORE_BASE + 0x6c8,	
	rHDCP_AKSV_3					=	HDMI_CORE_BASE + 0x6cc,
	rHDCP_AKSV_4					=	HDMI_CORE_BASE + 0x6d0,
                                        
	rHDCP_AN_0						=	HDMI_CORE_BASE + 0x6e0,
	rHDCP_AN_1						=	HDMI_CORE_BASE + 0x6e4, 
	rHDCP_AN_2						=	HDMI_CORE_BASE + 0x6e8, 	
	rHDCP_AN_3						=	HDMI_CORE_BASE + 0x6ec, 
	rHDCP_AN_4						=	HDMI_CORE_BASE + 0x6f0,
	rHDCP_AN_5						=	HDMI_CORE_BASE + 0x6f4, 
	rHDCP_AN_6						=	HDMI_CORE_BASE + 0x6f8,	
	rHDCP_AN_7						=	HDMI_CORE_BASE + 0x6fc, 
                                        
	rHDCP_BCAPS					=	HDMI_CORE_BASE + 0x700,
	rHDCP_BSTATUS_0				=	HDMI_CORE_BASE + 0x710,
	rHDCP_BSTATUS_1				=	HDMI_CORE_BASE + 0x714,
	rHDCP_RI_0						=	HDMI_CORE_BASE + 0x740,
	rHDCP_RI_1						=	HDMI_CORE_BASE + 0x744,
	rHDCP_I2C_INT					=	HDMI_CORE_BASE + 0x780, 
	rHDCP_AN_INT					=	HDMI_CORE_BASE + 0x790, 	
	rHDCP_WDT_INT					=	HDMI_CORE_BASE + 0x7a0,
	rHDCP_RI_INT					=	HDMI_CORE_BASE + 0x7b0,

	rHDCP_RI_COMPARE_0			=	HDMI_CORE_BASE + 0x7d0,
	rHDCP_RI_COMPARE_1			=	HDMI_CORE_BASE + 0x7d4,
	rHDCP_FRAME_COUNT			=	HDMI_CORE_BASE + 0x7e0,

	rHDMI_GAMUT_CON				=	HDMI_CORE_BASE + 0x500,
	rHDMI_GAMUT_HEADER0			=	HDMI_CORE_BASE + 0x504,
	rHDMI_GAMUT_HEADER1			=	HDMI_CORE_BASE + 0x508,
	rHDMI_GAMUT_HEADER2			=	HDMI_CORE_BASE + 0x50c,
	rHDMI_GAMUT_DATA00			=	HDMI_CORE_BASE + 0x510,
	rHDMI_GAMUT_DATA01			=	HDMI_CORE_BASE + 0x514,
	rHDMI_GAMUT_DATA02			=	HDMI_CORE_BASE + 0x518,
	rHDMI_GAMUT_DATA03			=	HDMI_CORE_BASE + 0x51c,
	rHDMI_GAMUT_DATA04			=	HDMI_CORE_BASE + 0x520,
	rHDMI_GAMUT_DATA05			=	HDMI_CORE_BASE + 0x524,
	rHDMI_GAMUT_DATA06			=	HDMI_CORE_BASE + 0x528,
	rHDMI_GAMUT_DATA07			=	HDMI_CORE_BASE + 0x52c,
	rHDMI_GAMUT_DATA08			=	HDMI_CORE_BASE + 0x530,
	rHDMI_GAMUT_DATA09			=	HDMI_CORE_BASE + 0x534,
	rHDMI_GAMUT_DATA10			=	HDMI_CORE_BASE + 0x538,
	rHDMI_GAMUT_DATA11			=	HDMI_CORE_BASE + 0x53c,
	rHDMI_GAMUT_DATA12			=	HDMI_CORE_BASE + 0x540,
	rHDMI_GAMUT_DATA13			=	HDMI_CORE_BASE + 0x544,
	rHDMI_GAMUT_DATA14			=	HDMI_CORE_BASE + 0x548,
	rHDMI_GAMUT_DATA15			=	HDMI_CORE_BASE + 0x54c,
	rHDMI_GAMUT_DATA16			=	HDMI_CORE_BASE + 0x550,
	rHDMI_GAMUT_DATA17			=	HDMI_CORE_BASE + 0x554,
	rHDMI_GAMUT_DATA18			=	HDMI_CORE_BASE + 0x558,
	rHDMI_GAMUT_DATA19			=	HDMI_CORE_BASE + 0x55c,
	rHDMI_GAMUT_DATA20			=	HDMI_CORE_BASE + 0x560,
	rHDMI_GAMUT_DATA21			=	HDMI_CORE_BASE + 0x564,
	rHDMI_GAMUT_DATA22			=	HDMI_CORE_BASE + 0x568,
	rHDMI_GAMUT_DATA23			=	HDMI_CORE_BASE + 0x56c,
	rHDMI_GAMUT_DATA24			=	HDMI_CORE_BASE + 0x570,
	rHDMI_GAMUT_DATA25			=	HDMI_CORE_BASE + 0x574,
	rHDMI_GAMUT_DATA26			=	HDMI_CORE_BASE + 0x578,
	rHDMI_GAMUT_DATA27			=	HDMI_CORE_BASE + 0x57c,

	rHDMI_DC_CONTROL				=	HDMI_CORE_BASE + 0x5c0,
	rHDMI_VIDEO_PATTERN_GEN		=	HDMI_CORE_BASE + 0x5C4,
	rHDMI_HPD_GEN					=	HDMI_CORE_BASE + 0x5c8,

	//HDMI SPDIF register
	rHDMI_SPDIF_CLK_CTRL			=	HDMI_SPDIF_BASE + 0x000,
	rHDMI_SPDIF_OP_CTRL			=	HDMI_SPDIF_BASE + 0x004,
	rHDMI_SPDIF_IRQ_MASK			=	HDMI_SPDIF_BASE + 0x008,
	rHDMI_SPDIF_IRQ_STATUS		= 	HDMI_SPDIF_BASE + 0x00c,	
	rHDMI_SPDIF_CONFIG_1			=	HDMI_SPDIF_BASE + 0x010,
	rHDMI_SPDIF_CONFIG_2			=	HDMI_SPDIF_BASE + 0x014,	
	rHDMI_SPDIF_USER_VALUE_1		= 	HDMI_SPDIF_BASE + 0x020,	
	rHDMI_SPDIF_USER_VALUE_2		= 	HDMI_SPDIF_BASE + 0x024,	
	rHDMI_SPDIF_USER_VALUE_3		=	HDMI_SPDIF_BASE + 0x028,		
	rHDMI_SPDIF_USER_VALUE_4		= 	HDMI_SPDIF_BASE + 0x02c,	
	rHDMI_SPDIF_CH_STATUS_0_1	= 	HDMI_SPDIF_BASE + 0x030,	
	rHDMI_SPDIF_CH_STATUS_0_2	=	HDMI_SPDIF_BASE + 0x034,		
	rHDMI_SPDIF_CH_STATUS_0_3	=	HDMI_SPDIF_BASE + 0x038,		
	rHDMI_SPDIF_CH_STATUS_0_4	=	HDMI_SPDIF_BASE + 0x03c,		
	rHDMI_SPDIF_CH_STATUS_1		=	HDMI_SPDIF_BASE + 0x040,	
	rHDMI_SPDIF_FRAME_PERIOD_1	=	HDMI_SPDIF_BASE + 0x048,
	rHDMI_SPDIF_FRAME_PERIOD_2	=	HDMI_SPDIF_BASE + 0x04c,	
	rHDMI_SPDIF_PC_INFO_1			=	HDMI_SPDIF_BASE + 0x050,
	rHDMI_SPDIF_PC_INFO_2			=	HDMI_SPDIF_BASE + 0x054,
	rHDMI_SPDIF_PD_INFO_1		=	HDMI_SPDIF_BASE + 0x058,	
	rHDMI_SPDIF_PD_INFO_2		=	HDMI_SPDIF_BASE + 0x05c,
	rHDMI_SPDIF_DATA_BUF_0_1		=	HDMI_SPDIF_BASE + 0x060,	
	rHDMI_SPDIF_DATA_BUF_0_2		=	HDMI_SPDIF_BASE + 0x064,	
	rHDMI_SPDIF_DATA_BUF_0_3		=	HDMI_SPDIF_BASE + 0x068,		
	rHDMI_SPDIF_USER_BUF_0		=	HDMI_SPDIF_BASE + 0x06c,
	rHDMI_SPDIF_DATA_BUF_1_1		=	HDMI_SPDIF_BASE + 0x070,	
	rHDMI_SPDIF_DATA_BUF_1_2		=	HDMI_SPDIF_BASE + 0x074,	
	rHDMI_SPDIF_DATA_BUF_1_3		=	HDMI_SPDIF_BASE + 0x078,	
	rHDMI_SPDIF_USER_BUF_1		=	HDMI_SPDIF_BASE + 0x07c,

	//HDMI I2S register
	rHDMI_I2S_CLK_CON				=	HDMI_I2S_BASE + 0x000,
	rHDMI_I2S_CON_1				=	HDMI_I2S_BASE + 0x004,
	rHDMI_I2S_CON_2				=	HDMI_I2S_BASE + 0x008,
	rHDMI_I2S_PIN_SEL_0			=	HDMI_I2S_BASE + 0x00c,
	rHDMI_I2S_PIN_SEL_1			=	HDMI_I2S_BASE + 0x010,
	rHDMI_I2S_PIN_SEL_2			=	HDMI_I2S_BASE + 0x014,
	rHDMI_I2S_PIN_SEL_3			=	HDMI_I2S_BASE + 0x018,
	rHDMI_I2S_DSD_CON				=	HDMI_I2S_BASE + 0x01c,	
	rHDMI_I2S_IN_MUX_CON			=	HDMI_I2S_BASE + 0x020,	
	rHDMI_I2S_CH_ST_CON			=	HDMI_I2S_BASE + 0x024,	
	rHDMI_I2S_CH_ST_0				=	HDMI_I2S_BASE + 0x028,	
	rHDMI_I2S_CH_ST_1				=	HDMI_I2S_BASE + 0x02c,
	rHDMI_I2S_CH_ST_2				=	HDMI_I2S_BASE + 0x030,
	rHDMI_I2S_CH_ST_3				=	HDMI_I2S_BASE + 0x034,
	rHDMI_I2S_CH_ST_4				=	HDMI_I2S_BASE + 0x038,
	rHDMI_I2S_CH_ST_SH_0			=	HDMI_I2S_BASE + 0x03c,
	rHDMI_I2S_CH_ST_SH_1			=	HDMI_I2S_BASE + 0x040,
	rHDMI_I2S_CH_ST_SH_2			=	HDMI_I2S_BASE + 0x044,
	rHDMI_I2S_CH_ST_SH_3			=	HDMI_I2S_BASE + 0x048,
	rHDMI_I2S_CH_ST_SH_4			=	HDMI_I2S_BASE + 0x04c,
	rHDMI_I2S_VD_DATA				=	HDMI_I2S_BASE + 0x050,
	rHDMI_I2S_MUX_CH				=	HDMI_I2S_BASE + 0x054,
	rHDMI_I2S_MUX_CUV				=	HDMI_I2S_BASE + 0x058,
	rHDMI_I2S_IRQ_MASK			=	HDMI_I2S_BASE + 0x05c,
	rHDMI_I2S_IRQ_STATUS			=	HDMI_I2S_BASE + 0x060,
	
	// register address must be added
	
	// HDMI TG register
	rTG_CMD						=	HDMI_TG_BASE + 0x000,
	rTG_CFG						=	HDMI_TG_BASE + 0x004,
	rTG_CB_SZ						=	HDMI_TG_BASE + 0x008, 	// Removed	
	rTG_INDELAY_L					=	HDMI_TG_BASE + 0x00c,
	rTG_INDELAY_H					=	HDMI_TG_BASE + 0x010,
	rTG_POL_CTRL					=	HDMI_TG_BASE + 0x014,
	rTG_H_FSZ_L					=	HDMI_TG_BASE + 0x018, 
	rTG_H_FSZ_H					=	HDMI_TG_BASE + 0x01c, 	
	rTG_HACT_ST_L					=	HDMI_TG_BASE + 0x020, 
	rTG_HACT_ST_H					=	HDMI_TG_BASE + 0x024,	
	rTG_HACT_SZ_L					=	HDMI_TG_BASE + 0x028, 
	rTG_HACT_SZ_H					=	HDMI_TG_BASE + 0x02c,	
	rTG_V_FSZ_L					=	HDMI_TG_BASE + 0x030, 
	rTG_V_FSZ_H					=	HDMI_TG_BASE + 0x034,	
	rTG_VSYNC_L					=	HDMI_TG_BASE + 0x038, 
	rTG_VSYNC_H					=	HDMI_TG_BASE + 0x03c,	
	rTG_VSYNC2_L					=	HDMI_TG_BASE + 0x040, 
	rTG_VSYNC2_H					=	HDMI_TG_BASE + 0x044,	
	rTG_VACT_ST_L					= 	HDMI_TG_BASE + 0x048, 
	rTG_VACT_ST_H					=	HDMI_TG_BASE + 0x04c,	
	rTG_VACT_SZ_L					=	HDMI_TG_BASE + 0x050, 
	rTG_VACT_SZ_H					=	HDMI_TG_BASE + 0x054, 
	rTG_FIELD_CHG_L				=	HDMI_TG_BASE + 0x058, 
	rTG_FIELD_CHG_H				=	HDMI_TG_BASE + 0x05c, 
	rTG_VACT_ST2_L					=	HDMI_TG_BASE + 0x060, 
	rTG_VACT_ST2_H				=	HDMI_TG_BASE + 0x064, 

	rTG_VSYNC_TOP_HDMI_L			=	HDMI_TG_BASE + 0x078, 
	rTG_VSYNC_TOP_HDMI_H			=	HDMI_TG_BASE + 0x07c, 
	rTG_VSYNC_BOT_HDMI_L			=	HDMI_TG_BASE + 0x080, 
	rTG_VSYNC_BOT_HDMI_H			=	HDMI_TG_BASE + 0x084, 
	rTG_FIELD_TOP_HDMI_L			=	HDMI_TG_BASE + 0x088, 
	rTG_FIELD_TOP_HDMI_H			=	HDMI_TG_BASE + 0x08c, 
	rTG_FIELD_BOT_HDMI_L			=	HDMI_TG_BASE + 0x090, 
	rTG_FIELD_BOT_HDMI_H			=	HDMI_TG_BASE + 0x094, 
	rMHL_HSYNC_WIDTH				=	HDMI_TG_BASE + 0x098,	
	rMHL_VSYNC_WIDTH				=	HDMI_TG_BASE + 0x09c,
	rMHL_CLK_INV					=	HDMI_TG_BASE + 0x0a0,			

	//HDMI  E-FUSE regiseter
	rEFUSE_CTRL					=	HDMI_EFUSE_BASE + 0x000,
	rEFUSE_STATUS					=	HDMI_EFUSE_BASE + 0x004,
	rEFUSE_ADDR_WIDTH			=	HDMI_EFUSE_BASE + 0x008,
	rEFUSE_SIGDEV_ASSERT			=	HDMI_EFUSE_BASE + 0x00c,
	rEFUSE_SIGDEV_DEASSERT		=	HDMI_EFUSE_BASE + 0x010,
	rEFUSE_PRCHG_ASSERT			=	HDMI_EFUSE_BASE + 0x014,
	rEFUSE_PRCHG_DEASSERT		=	HDMI_EFUSE_BASE + 0x018,
	rEFUSE_FSET_ASSERT			=	HDMI_EFUSE_BASE + 0x01c,
	rEFUSE_FSET_DEASSERT			=	HDMI_EFUSE_BASE + 0x020,
	rEFUSE_SENSING				=	HDMI_EFUSE_BASE + 0x024,
	rEFUSE_SCK_ASSERT				=	HDMI_EFUSE_BASE + 0x028,
	rEFUSE_SCK_DEASSERT			=	HDMI_EFUSE_BASE + 0x02c,
	rEFUSE_SDOUT_OFFSET			=	HDMI_EFUSE_BASE + 0x030,
	rEFUSE_READ_OFFSET			=	HDMI_EFUSE_BASE + 0x034,

	//HDMI CEC register
	rCEC_TX_STATUS_0				=	HDMI_CEC_BASE + 0x000,
	rCEC_TX_STATUS_1				=	HDMI_CEC_BASE + 0x004,
	rCEC_RX_STATUS_0				=	HDMI_CEC_BASE + 0x008,
	rCEC_RX_STATUS_1				=	HDMI_CEC_BASE + 0x00c,
	rCEC_INTR_MASK				=	HDMI_CEC_BASE + 0x010,
	rCEC_INTR_CLEAR				=	HDMI_CEC_BASE + 0x014,
	rCEC_LOGIC_ADDR				=	HDMI_CEC_BASE + 0x020,
	rCEC_DIVISOR_0					=	HDMI_CEC_BASE + 0x030,
	rCEC_DIVISOR_1					=	HDMI_CEC_BASE + 0x034,
	rCEC_DIVISOR_2					=	HDMI_CEC_BASE + 0x038,
	rCEC_DIVISOR_3					=	HDMI_CEC_BASE + 0x03c,
	rCEC_TX_CTRL					=	HDMI_CEC_BASE + 0x040,
	rCEC_TX_BYTE_NUM				=	HDMI_CEC_BASE + 0x044,
	rCEC_TX_STATUS_2				=	HDMI_CEC_BASE + 0x060,
	rCEC_TX_STATUS_3				=	HDMI_CEC_BASE + 0x064,
	rCEC_TX_BUFFER00				=	HDMI_CEC_BASE + 0x080,
	rCEC_TX_BUFFER01				=	HDMI_CEC_BASE + 0x084,
	rCEC_TX_BUFFER02				=	HDMI_CEC_BASE + 0x088,
	rCEC_TX_BUFFER03				=	HDMI_CEC_BASE + 0x08c,
	rCEC_TX_BUFFER04				=	HDMI_CEC_BASE + 0x090,
	rCEC_TX_BUFFER05				=	HDMI_CEC_BASE + 0x094,
	rCEC_TX_BUFFER06				=	HDMI_CEC_BASE + 0x098,
	rCEC_TX_BUFFER07				=	HDMI_CEC_BASE + 0x09c,
	rCEC_TX_BUFFER08				=	HDMI_CEC_BASE + 0x0a0,
	rCEC_TX_BUFFER09				=	HDMI_CEC_BASE + 0x0a4,
	rCEC_TX_BUFFER10				=	HDMI_CEC_BASE + 0x0a8,
	rCEC_TX_BUFFER11				=	HDMI_CEC_BASE + 0x0ac,
	rCEC_TX_BUFFER12				=	HDMI_CEC_BASE + 0x0b0,
	rCEC_TX_BUFFER13				=	HDMI_CEC_BASE + 0x0b4,
	rCEC_TX_BUFFER14				=	HDMI_CEC_BASE + 0x0b8,
	rCEC_TX_BUFFER15				=	HDMI_CEC_BASE + 0x0bc,
	rCEC_RX_CTRL					=	HDMI_CEC_BASE + 0x0c0,
	rCEC_RX_STATUS_2				=	HDMI_CEC_BASE + 0x0e0,
	rCEC_RX_STATUS_3				=	HDMI_CEC_BASE + 0x0e4,
	rCEC_RX_BUFFER00				=	HDMI_CEC_BASE + 0x100,
	rCEC_RX_BUFFER01				=	HDMI_CEC_BASE + 0x104,
	rCEC_RX_BUFFER02				=	HDMI_CEC_BASE + 0x108,
	rCEC_RX_BUFFER03				=	HDMI_CEC_BASE + 0x10c,
	rCEC_RX_BUFFER04				=	HDMI_CEC_BASE + 0x110,
	rCEC_RX_BUFFER05				=	HDMI_CEC_BASE + 0x114,
	rCEC_RX_BUFFER06				=	HDMI_CEC_BASE + 0x118,
	rCEC_RX_BUFFER07				=	HDMI_CEC_BASE + 0x11c,
	rCEC_RX_BUFFER08				=	HDMI_CEC_BASE + 0x120,
	rCEC_RX_BUFFER09				=	HDMI_CEC_BASE + 0x124,
	rCEC_RX_BUFFER10				=	HDMI_CEC_BASE + 0x128,
	rCEC_RX_BUFFER11				=	HDMI_CEC_BASE + 0x12c,
	rCEC_RX_BUFFER12				=	HDMI_CEC_BASE + 0x130,
	rCEC_RX_BUFFER13				=	HDMI_CEC_BASE + 0x134,
	rCEC_RX_BUFFER14				=	HDMI_CEC_BASE + 0x138,
	rCEC_RX_BUFFER15				=	HDMI_CEC_BASE + 0x13c,
	rCEC_FILTER_CTRL				=	HDMI_CEC_BASE + 0x180,
	rCEC_FILTER_TH					=	HDMI_CEC_BASE + 0x184
}HDMI_SFR;


#ifdef __cplusplus
}
#endif

#endif /*_HDMI_REG_H_*/ 
