//-------------------------------------------------------------------
// Copyright SAMSUNG Electronics Co., Ltd
// All right reserved.
//
// This software is the confidential and proprietary information
// of Samsung Electronics, Inc. ("Confidential Information").  You
// shall not disclose such Confidential Information and shall use
// it only in accordance with the terms of the license agreement
// you entered into with Samsung Electronics. 
//-------------------------------------------------------------------

/** Registers related to I2S/SPDIF HW **/
#ifndef _HDMI_AUDIOREG_H_
#define _HDMI_AUDIOREG_H_


/*
 * I2S
 */
#define I2S_PIN_SEL_AUDIO_0         0x0
#define I2S_PIN_SEL_AUDIO_1         0x1
#define I2S_PIN_SEL_AUDIO_2         0x2
#define I2S_PIN_SEL_AUDIO_3         0x3
#define I2S_PIN_SEL_AUDIO_4         0x4
#define I2S_PIN_SEL_AUDIO_5         0x5
#define I2S_PIN_SEL_AUDIO_6         0x6

#define I2S_CLK_CON_ENABLE          (1)
#define I2S_CLK_CON_DISABLE         (0)

#define I2S_CON_SC_POL_FALLING      (0<<1)
#define I2S_CON_SC_POL_RISING       (1<<1)

#define I2S_CON_CH_POL_LOW          (0)
#define I2S_CON_CH_POL_HIGH         (1)

#define I2S_CON_MSB                 (0<<6)
#define I2S_CON_LSB                 (1<<6)

#define I2S_CON_BIT_CH_32           (0<<4)
#define I2S_CON_BIT_CH_48           (1<<4)
#define I2S_CON_BIT_CH_64           (2<<4)

#define I2S_CON_DATA_NUM_MASK       (3<<2)
#define I2S_CON_DATA_NUM_16         (1<<2)
#define I2S_CON_DATA_NUM_20         (2<<2)
#define I2S_CON_DATA_NUM_24         (3<<2)

#define I2S_CON_I2S_MODE_BASIC           (0)
#define I2S_CON_I2S_MODE_LEFT_JUSTIFIED  (2)
#define I2S_CON_I2S_MODE_RIGHT_JUSTIFIED (3)

#define I2S_DSD_CON_POL_RISING      (1<<1)
#define I2S_DSD_CON_POL_FALLING     (0<<1)

#define I2S_DSD_CON_ENABLE          (1)
#define I2S_DSD_CON_DISABLE         (0)

#define I2S_IN_MUX_IN_ENABLE        (1<<4)
#define I2S_IN_MUX_SELECT_DSD       (2<<2)
#define I2S_IN_MUX_SELECT_I2S       (1<<2)
#define I2S_IN_MUX_SELECT_SPDIF     (0)
#define I2S_IN_MUX_CUV_ENABLE       (1<<1)
#define I2S_IN_MUX_ENABLE           (1)


/*
 * SPDIF
 */
#define SPDIF_CLK_CTRL_ENABLE       (1)
#define SPDIF_CLK_CTRL_DISABLE      (0)

//#define SPDIF_OP_CTRL ????

#define SPDIF_IRQ_ENABLE_ALL        (0xFF)
#define SPDIF_IRQ_DISABLE_ALL       (0)

#define SPDIF_CH_STATUS_0_1_LPCM    (0)
#define SPDIF_CH_STATUS_0_1_NPCM    (1<<1)

#define SPDIF_CONFIG_1_NOISE_FILTER_2_SAMPLES   (1<<6)
#define SPDIF_CONFIG_1_NOISE_FILTER_3_SAMPLES   (0)
#define SPDIF_CONFIG_1_LPCM                     (0)
#define SPDIF_CONFIG_1_NPCM                     (1<<5)
#define SPDIF_CONFIG_1_PCPD_MANUAL              (1<<4)
#define SPDIF_CONFIG_1_WORD_LENGTH_MANUAL       (1<<3)
#define SPDIF_CONFIG_1_UVCP_ENABLE              (1<<2)
#define SPDIF_CONFIG_1_HDMI_1_BURST             (0)
#define SPDIF_CONFIG_1_HDMI_2_BURST             (1<<1)
#define SPDIF_CONFIG_1_ALIGN_16BIT              (0)
#define SPDIF_CONFIG_1_ALIGN_32BIT              (1<<0)

#define SPDIF_CLK_RECOVERY_FAIL_MASK         (1<<0)
#define SPDIF_STATUS_RECOVERED_MASK          (1<<1)
#define SPDIF_PREAMBLE_DETECTED_MASK         (1<<2)
#define SPDIF_HEADER_NOT_DETECTED_MASK       (1<<3)
#define SPDIF_HEADER_DETECTED_MASK           (1<<4)
#define SPDIF_PAPD_NOT_DETECTED_MASK         (1<<5)
#define SPDIF_ABNORMAL_PD_MASK               (1<<6)
#define SPDIF_BUFFER_OVERFLOW_MASK           (1<<7)

/*
 * CUV related definitions
 */

#define I2S_CH_ST_0_TYPE_MASK           (1<<1)
#define I2S_CH_ST_0_TYPE_LPCM           0
#define I2S_CH_ST_0_TYPE_NLPCM          (1<<1)

#define I2S_CH_ST_0_COPY_MASK           (1<<2)
#define I2S_CH_ST_0_NOT_COPYRIGHTED     (1<<2)

#define I2S_CH_ST_1_CATEGORY_GENERAL             0x00 // 0b000 00000
#define I2S_CH_ST_1_CATEGORY_CD                  0x01 // 0b100 XXXXL
#define I2S_CH_ST_1_CATEGORY_DC                  0x02 // 0b010 XXXXL
#define I2S_CH_ST_1_CATEGORY_DAT                 0x03 // 0b110 XXXXL
#define I2S_CH_ST_1_CATEGORY_BROADCAST           0x04 // 0b001 XXXXL and 0b011 1XXXL
#define I2S_CH_ST_1_CATEGORY_MIC                 0x05 // 0b101 XXXXL
#define I2S_CH_ST_1_CATEGORY_ADC                 0x06 // 0b011 00XXL
#define I2S_CH_ST_1_CATEGORY_ADC_COPYRIGHTED     0x16 // 0b011 01XXL
#define I2S_CH_ST_1_CATEGORY_SS                  0x08 // 0b000 1XXXL
#define I2S_CH_ST_1_CATEGORY_EXPERIMENTAL        0x40 // 0b000 0001L

#define I2S_CH_ST_2_CHANNEL_MASK        0xF0
#define I2S_CH_ST_2_CH_UNDEFINED        0
#define I2S_CH_ST_2_CH_01               (0x1<<4)
#define I2S_CH_ST_2_CH_02               (0x2<<4)
#define I2S_CH_ST_2_CH_03               (0x3<<4)
#define I2S_CH_ST_2_CH_04               (0x4<<4)
#define I2S_CH_ST_2_CH_05               (0x5<<4)
#define I2S_CH_ST_2_CH_06               (0x6<<4)
#define I2S_CH_ST_2_CH_07               (0x7<<4)
#define I2S_CH_ST_2_CH_08               (0x8<<4)
#define I2S_CH_ST_2_CH_09               (0x9<<4)
#define I2S_CH_ST_2_CH_10               (0xA<<4)
#define I2S_CH_ST_2_CH_11               (0xB<<4)
#define I2S_CH_ST_2_CH_12               (0xC<<4)
#define I2S_CH_ST_2_CH_13               (0xD<<4)
#define I2S_CH_ST_2_CH_14               (0xE<<4)
#define I2S_CH_ST_2_CH_15               (0xF<<4)

#define I2S_CH_ST_2_SRC_MASK            0xF0
#define I2S_CH_ST_2_SRC_UNDEFINED       0x0
#define I2S_CH_ST_2_SRC_01              0x1
#define I2S_CH_ST_2_SRC_02              0x2
#define I2S_CH_ST_2_SRC_03              0x3
#define I2S_CH_ST_2_SRC_04              0x4
#define I2S_CH_ST_2_SRC_05              0x5
#define I2S_CH_ST_2_SRC_06              0x6
#define I2S_CH_ST_2_SRC_07              0x7
#define I2S_CH_ST_2_SRC_08              0x8
#define I2S_CH_ST_2_SRC_09              0x9
#define I2S_CH_ST_2_SRC_10              0xA
#define I2S_CH_ST_2_SRC_11              0xB
#define I2S_CH_ST_2_SRC_12              0xC
#define I2S_CH_ST_2_SRC_13              0xD
#define I2S_CH_ST_2_SRC_14              0xE
#define I2S_CH_ST_2_SRC_15              0xF

#define I2S_CH_ST_3_SF_MASK             (0x0F)
#define I2S_CH_ST_3_SF_44KHZ            0x0 // 0b0000
#define I2S_CH_ST_3_SF_88KHZ            0x8 // 0b1000
#define I2S_CH_ST_3_SF_176KHZ           0xC // 0b1100
#define I2S_CH_ST_3_SF_48KHZ            0x2 // 0b0010
#define I2S_CH_ST_3_SF_96KHZ            0xA // 0b1010
#define I2S_CH_ST_3_SF_192KHZ           0xE // 0b1110
#define I2S_CH_ST_3_SF_32KHZ            0x3 // 0b0011

#define I2S_CH_ST_3_CA_MASK             (0x3<<4)
#define I2S_CH_ST_3_CA_LEVEL_I          (0x1<<4) // 0b01
#define I2S_CH_ST_3_CA_LEVEL_II         (0x0<<4) // 0b00
#define I2S_CH_ST_3_CA_LEVEL_III        (0x2 <<4)// 0b10
#define I2S_CH_ST_3_CA_NOT_MATCH        (0x3<<4) // 0b11

#define I2S_CH_ST_4_OSF_MASK            0xF0
#define I2S_CH_ST_4_OSF_44KHZ           (0xF<<4) // 0b1111
#define I2S_CH_ST_4_OSF_88KHZ           (0xE<<4) // 0b1110
#define I2S_CH_ST_4_OSF_22KHZ           (0xD<<4) // 0b1101
#define I2S_CH_ST_4_OSF_176KHZ          (0xC<<4) // 0b1100
#define I2S_CH_ST_4_OSF_48KHZ           (0xB<<4) // 0b1011
#define I2S_CH_ST_4_OSF_96KHZ           (0xA<<4) // 0b1010
#define I2S_CH_ST_4_OSF_24KHZ           (0x9<<4) // 0b1001
#define I2S_CH_ST_4_OSF_192KHZ          (0x8<<4) // 0b1000
#define I2S_CH_ST_4_OSF_8KHZ            (0x6<<4) // 0b0110
#define I2S_CH_ST_4_OSF_11KHZ           (0x5<<4) // 0b0101
#define I2S_CH_ST_4_OSF_12KHZ           (0x4<<4) // 0b0100
#define I2S_CH_ST_4_OSF_32KHZ           (0x3<<4) // 0b0011
#define I2S_CH_ST_4_OSF_16KHZ           (0x1<<4) // 0b0001
#define I2S_CH_ST_4_OSF_NOT_INDICATED   (0x0<<4) // 0b0000

#define I2S_CH_ST_4_WL_MASK             0x0F
#define I2S_CH_ST_4_WL_20_NOT_DEFINED   0x0 // 0b0000
#define I2S_CH_ST_4_WL_20_16            0x8 // 0b0010        
#define I2S_CH_ST_4_WL_20_18            0x4 // 0b0100        
#define I2S_CH_ST_4_WL_20_19            0x2 // 0b1000        
#define I2S_CH_ST_4_WL_20_20            0xA // 0b1010        
#define I2S_CH_ST_4_WL_20_17            0x6 // 0b1100        
#define I2S_CH_ST_4_WL_24_NOT_DEFINED   0x1 // 0b0001        
#define I2S_CH_ST_4_WL_24_20            0x9 // 0b0011        
#define I2S_CH_ST_4_WL_24_22            0x5 // 0b0101        
#define I2S_CH_ST_4_WL_24_23            0x3 // 0b1001        
#define I2S_CH_ST_4_WL_24_24            0xB // 0b1011        
#define I2S_CH_ST_4_WL_24_21            0x7 // 0b1101        

#endif // _HDMI_AUDIOREG_H_