//-------------------------------------------------------------------
// Copyright SAMSUNG Electronics Co., Ltd
// All right reserved.
//
// This software is the confidential and proprietary information
// of Samsung Electronics, Inc. ("Confidential Information").  You
// shall not disclose such Confidential Information and shall use
// it only in accordance with the terms of the license agreement
// you entered into with Samsung Electronics. 
//-------------------------------------------------------------------
#ifndef _HDMI_AUDIO_H_
#define _HDMI_AUDIO_H_

#include "hdmi_audioreg.h"
#include "hdmi.h"

#ifdef __cplusplus
extern "C" {
#endif


#define HDMI_SPDIF_INT_WRONG_SIG				(1<<0)
#define HDMI_SPDIF_INT_STATUS_RECOVERED		(1<<1)
#define HDMI_SPDIF_INT_WRONG_PREAMBLE		(1<<2)
#define HDMI_SPDIF_INT_HEADER_NOT_DET		(1<<3)
#define HDMI_SPDIF_INT_HEADER_DET			(1<<4)
#define HDMI_SPDIF_INT_BUF_OVERFLOW			(1<<7)
#define HDMI_SPDIF_INT_ALL_EN					(0x9f)

#define HDMI_I2S_INT_INT1				(1<<0)
#define HDMI_I2S_INT_INT2				(1<<1)


typedef enum
{
    CUV_LPCM,
    CUV_NLPCM
}CUVAudioCoding;

typedef enum 
{
    CUV_CATEGORY_GENERAL,
    CUV_CATEGORY_CD,
    CUV_CATEGORY_DC,
    CUV_CATEGORY_DAT,
    CUV_CATEGORY_BROADCAST,
    CUV_CATEGORY_MIC,
    CUV_CATEGORY_ADC,
    CUV_CATEGORY_ADC_COPYRIGHTED,
    CUV_CATEGORY_SS,
    CUV_CATEGORY_EXPERIMENTAL,
}CUVEquipmentType;

typedef enum 
{
    CUV_CH_UNDEFINED = 0,
    CUV_CH_01,
    CUV_CH_02,
    CUV_CH_03,
    CUV_CH_04,
    CUV_CH_05,
    CUV_CH_06,
    CUV_CH_07,
    CUV_CH_08,
    CUV_CH_09,
    CUV_CH_10,
    CUV_CH_11,
    CUV_CH_12,
    CUV_CH_13,
    CUV_CH_14,
    CUV_CH_15,
}CUVChannelNumber;

typedef enum 
{
    CUV_SRC_UNDEFINED = 0,
    CUV_SRC_01,
    CUV_SRC_02,
    CUV_SRC_03,
    CUV_SRC_04,
    CUV_SRC_05,
    CUV_SRC_06,
    CUV_SRC_07,
    CUV_SRC_08,
    CUV_SRC_09,
    CUV_SRC_10,
    CUV_SRC_11,
    CUV_SRC_12,
    CUV_SRC_13,
    CUV_SRC_14,
    CUV_SRC_15,
}CUVSourceNumber;

typedef enum 
{
    CUV_CA_LEVEL_I,
    CUV_CA_LEVEL_II,
    CUV_CA_LEVEL_III,
    CUV_CA_NOT_MATCH,
}CUVClockAccuracy;

typedef enum 
{
    CUV_OSF_44KHZ,         
    CUV_OSF_88KHZ,        
    CUV_OSF_22KHZ,         
    CUV_OSF_176KHZ,        
    CUV_OSF_48KHZ,         
    CUV_OSF_96KHZ,         
    CUV_OSF_24KHZ,         
    CUV_OSF_192KHZ,        
    CUV_OSF_8KHZ,          
    CUV_OSF_11KHZ,         
    CUV_OSF_12KHZ,         
    CUV_OSF_32KHZ,         
    CUV_OSF_16KHZ,         
    CUV_OSF_NOT_INDICATED,
}CUVOrigSamplingFreq;

typedef enum 
{
    CUV_WL_20_NOT_DEFINED,
    CUV_WL_20_16,         
    CUV_WL_20_18,         
    CUV_WL_20_19,         
    CUV_WL_20_20,         
    CUV_WL_20_17,         
    CUV_WL_24_NOT_DEFINED,
    CUV_WL_24_20,         
    CUV_WL_24_22,         
    CUV_WL_24_23,         
    CUV_WL_24_24,         
    CUV_WL_24_21,         
}CUVWordLength;

//enum SamplingFreq;

// set CUV fields on I2S Hardware
void HDMI_SPDIF_ISR(u32 IRQNum);
void HDMI_I2S_ISR(u32 IRQNum);

s32 CUVSetCodingType(CUVAudioCoding coding);
s32 CUVSetCopyrighted(s32 copyrighted);
s32 CUVSetEquipmentType(CUVEquipmentType equip, int commertial);
s32 CUVSetChannelNumber(CUVChannelNumber ch);
s32 CUVSetSourceNumber(CUVSourceNumber src);
s32 CUVSetSamplingFreq(SamplingFreq freq);
s32 CUVSetClockAccuracy(CUVClockAccuracy ca);
s32 CUVSetOriginalSamplingFrequency(CUVOrigSamplingFreq osf);
s32 CUVSetSampleWordLength(CUVWordLength wl);
s32 CUVUpdate(void);
s32 CUVReset(void);

#ifdef __cplusplus
}
#endif

#endif // _HDMI_AUDIO_H_