//-------------------------------------------------------------------
// Copyright SAMSUNG Electronics Co., Ltd
// All right reserved.
//
// This software is the confidential and proprietary information
// of Samsung Electronics, Inc. ("Confidential Information").  You
// shall not disclose such Confidential Information and shall use
// it only in accordance with the terms of the license agreement
// you entered into with Samsung Electronics. 
//-------------------------------------------------------------------
#include "system.h"
#include "Library.h"
#include "v210_sfr.h"
#include "intc.h"
#include "hdmi_reg.h"
#include "hdmi.h"
#include "hdmi_audio1.h"
#include "hdmi_audioreg.h"

u32 gHDMI_SPDIF_Event = 0;

//#define	DISP_HDMI_AUDIO_REG

#ifndef DISP_HDMI_AUDIO_REG
#define HdmiAudioOutp8(addr, data) 	Outp8(addr, data)
#define HdmiAudioInp8(addr)  			Inp8(addr)
#else
#define HdmiAudioOutp8(addr, data) 	{UART_Printf("Outp8(\'h%08x, \'h%08x);\n", addr, data), Outp8(addr, data);}
#define HdmiAudioInp8(addr) 			{Inp8(addr); UART_Printf("Inp8(\'h%08x, d); // d=0x%08x\n", addr, Inp8(addr));}
#endif


void HDMI_SPDIF_ISR(u32 IRQNum)
{
	u8 HDMI_SPDIFState = HdmiAudioInp8(rHDMI_SPDIF_IRQ_STATUS)&0x9F;

	UART_Printf("HDMI SPDIF State  = 0x%x\n",HDMI_SPDIFState);

	if (HDMI_SPDIFState & HDMI_SPDIF_INT_WRONG_SIG)
	{
		UART_Printf("SPDIF IRQ : HDMI_SPDIF_INT_WRONG_SIG\n");

		HdmiAudioOutp8(rHDMI_SPDIF_IRQ_STATUS,HDMI_SPDIF_INT_WRONG_SIG);
		gHDMI_SPDIF_Event |= HDMI_SPDIF_INT_WRONG_SIG;
	}

	if (HDMI_SPDIFState & HDMI_SPDIF_INT_STATUS_RECOVERED)
	{
		UART_Printf("SPDIF IRQ : HDMI_SPDIF_INT_STATUS_RECOVERED\n");

		HdmiAudioOutp8(rHDMI_SPDIF_IRQ_STATUS,HDMI_SPDIF_INT_STATUS_RECOVERED);
		gHDMI_SPDIF_Event |= HDMI_SPDIF_INT_STATUS_RECOVERED;
	}

	if (HDMI_SPDIFState & HDMI_SPDIF_INT_WRONG_PREAMBLE)
	{
		UART_Printf("SPDIF IRQ : HDMI_SPDIF_INT_WRONG_PREAMBLE\n");

		HdmiAudioOutp8(rHDMI_SPDIF_IRQ_STATUS,HDMI_SPDIF_INT_WRONG_PREAMBLE);
		gHDMI_SPDIF_Event |= HDMI_SPDIF_INT_WRONG_PREAMBLE;
	}

	if (HDMI_SPDIFState & HDMI_SPDIF_INT_HEADER_NOT_DET)
	{
		UART_Printf("SPDIF IRQ : HDMI_SPDIF_INT_HEADER_NOT_DET\n");

		HdmiAudioOutp8(rHDMI_SPDIF_IRQ_STATUS,HDMI_SPDIF_INT_HEADER_NOT_DET);
		gHDMI_SPDIF_Event |= HDMI_SPDIF_INT_HEADER_NOT_DET;
	}

	if (HDMI_SPDIFState & HDMI_SPDIF_INT_HEADER_DET)
	{
		UART_Printf("SPDIF IRQ : HDMI_SPDIF_INT_HEADER_DET\n");

		HdmiAudioOutp8(rHDMI_SPDIF_IRQ_STATUS,HDMI_SPDIF_INT_HEADER_DET);
		gHDMI_SPDIF_Event |= HDMI_SPDIF_INT_HEADER_DET;
	}

	if (HDMI_SPDIFState & HDMI_SPDIF_INT_BUF_OVERFLOW)
	{
		UART_Printf("SPDIF IRQ : HDMI_SPDIF_INT_BUF_OVERFLOW\n");

		HdmiAudioOutp8(rHDMI_SPDIF_IRQ_STATUS,HDMI_SPDIF_INT_BUF_OVERFLOW);
		gHDMI_SPDIF_Event |= HDMI_SPDIF_INT_BUF_OVERFLOW;
	}	
}


void HDMI_I2S_ISR(u32 IRQNum)
{
	u8 HDMI_I2SState = HdmiAudioInp8(rHDMI_I2S_IRQ_STATUS)&0x03;

	UART_Printf("HDMI I2S State  = 0x%x\n",HDMI_I2SState);

	if (HDMI_I2SState & HDMI_I2S_INT_INT1)
	{
		UART_Printf("I2S IRQ : HDMI_I2S_INT_INT1\n");

		HdmiAudioOutp8(rHDMI_I2S_IRQ_STATUS,HDMI_I2S_INT_INT1);
	}

	if (HDMI_I2SState & HDMI_I2S_INT_INT2)
	{
		UART_Printf("I2S IRQ : HDMI_I2S_INT_INT2\n");

		HdmiAudioOutp8(rHDMI_I2S_IRQ_STATUS,HDMI_I2S_INT_INT2);
	}
}



/**
 * Set audio encoding type on I2S Hardware CUV fields
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetCodingType(CUVAudioCoding coding)
{
    u8 reg = HdmiAudioInp8(rHDMI_I2S_CH_ST_0) & ~I2S_CH_ST_0_TYPE_MASK;

    switch (coding)
    {
        case CUV_LPCM:
            reg |= I2S_CH_ST_0_TYPE_LPCM;
            break;

        case CUV_NLPCM:
            reg |= I2S_CH_ST_0_TYPE_NLPCM;
            break;

        default:
            return ERROR;
    };
    
    HdmiAudioOutp8(rHDMI_I2S_CH_ST_0, reg);

    return OK;
}

/**
 * Set audio copyright information on I2S Hardware CUV fields.
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetCopyrighted(s32 copyrighted)
{
    u8 reg = HdmiAudioInp8(rHDMI_I2S_CH_ST_0) & ~I2S_CH_ST_0_COPY_MASK;
    
    if (!copyrighted)
        reg |= I2S_CH_ST_0_NOT_COPYRIGHTED;

    HdmiAudioOutp8(rHDMI_I2S_CH_ST_0, reg);

    return OK;
}

/**
 * Set equipement type on I2S Hardware CUV fields
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetEquipmentType(CUVEquipmentType equip, int commercial)
{
    u8 category;

    category = commercial ? 0x80 : 0;

    switch (equip)
    {
        case CUV_CATEGORY_GENERAL:
            category |= I2S_CH_ST_1_CATEGORY_GENERAL;
            break;

        case CUV_CATEGORY_CD:
            category |= I2S_CH_ST_1_CATEGORY_CD;
            break;

        case CUV_CATEGORY_DC:
            category |= I2S_CH_ST_1_CATEGORY_DC;
            break;

        case CUV_CATEGORY_DAT:
            category |= I2S_CH_ST_1_CATEGORY_DAT;
            break;

        case CUV_CATEGORY_BROADCAST:
            category |= I2S_CH_ST_1_CATEGORY_BROADCAST;
            break;

        case CUV_CATEGORY_MIC:
            category |= I2S_CH_ST_1_CATEGORY_MIC;
            break;

        case CUV_CATEGORY_ADC:
            category |= I2S_CH_ST_1_CATEGORY_ADC;
            break;

        case CUV_CATEGORY_ADC_COPYRIGHTED:
            category |= I2S_CH_ST_1_CATEGORY_ADC_COPYRIGHTED;
            break;

        case CUV_CATEGORY_SS:
            category |= I2S_CH_ST_1_CATEGORY_SS;
            break;

        case CUV_CATEGORY_EXPERIMENTAL:
            category |= I2S_CH_ST_1_CATEGORY_EXPERIMENTAL;
            break;

        default:
            return ERROR;
    }

    HdmiAudioOutp8(rHDMI_I2S_CH_ST_1, category);

    return OK;  
}

/**
 * Set equipement type on I2S Hardware CUV fields
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetChannelNumber(CUVChannelNumber ch)
{
    u8 reg = HdmiAudioInp8(rHDMI_I2S_CH_ST_2) & ~I2S_CH_ST_2_CHANNEL_MASK;

    switch (ch)
    {
        case CUV_CH_UNDEFINED:
            reg |= I2S_CH_ST_2_CH_UNDEFINED;
            break;

        case CUV_CH_01:
            reg |= I2S_CH_ST_2_CH_01;
            break;

        case CUV_CH_02:
            reg |= I2S_CH_ST_2_CH_02;
            break;

        case CUV_CH_03:
            reg |= I2S_CH_ST_2_CH_03;
            break;

        case CUV_CH_04:
            reg |= I2S_CH_ST_2_CH_04;
            break;

        case CUV_CH_05:
            reg |= I2S_CH_ST_2_CH_05;
            break;

        case CUV_CH_06:
            reg |= I2S_CH_ST_2_CH_06;
            break;

        case CUV_CH_07:
            reg |= I2S_CH_ST_2_CH_07;
            break;

        case CUV_CH_08:
            reg |= I2S_CH_ST_2_CH_08;
            break;

        case CUV_CH_09:
            reg |= I2S_CH_ST_2_CH_09;
            break;

        case CUV_CH_10:
            reg |= I2S_CH_ST_2_CH_10;
            break;

        case CUV_CH_11:
            reg |= I2S_CH_ST_2_CH_11;
            break;

        case CUV_CH_12:
            reg |= I2S_CH_ST_2_CH_12;
            break;

        case CUV_CH_13:
            reg |= I2S_CH_ST_2_CH_13;
            break;

        case CUV_CH_14:
            reg |= I2S_CH_ST_2_CH_14;
            break;

        case CUV_CH_15:
            reg |= I2S_CH_ST_2_CH_15;
            break;

        default:
            return ERROR;
    }

    HdmiAudioOutp8(rHDMI_I2S_CH_ST_2, reg);

    return OK;  
}

/**
 * Set number of source information on I2S Hardware CUV fields
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetSourceNumber(CUVSourceNumber src)
{
    u8 reg = HdmiAudioInp8(rHDMI_I2S_CH_ST_2) & ~I2S_CH_ST_2_SRC_MASK;

    switch (src)
    {
        case CUV_SRC_UNDEFINED:
            reg |= I2S_CH_ST_2_SRC_UNDEFINED;
            break;

        case CUV_SRC_01:
            reg |= I2S_CH_ST_2_SRC_01;
            break;

        case CUV_SRC_02:
            reg |= I2S_CH_ST_2_SRC_02;
            break;

        case CUV_SRC_03:
            reg |= I2S_CH_ST_2_SRC_03;
            break;

        case CUV_SRC_04:
            reg |= I2S_CH_ST_2_SRC_04;
            break;

        case CUV_SRC_05:
            reg |= I2S_CH_ST_2_SRC_05;
            break;

        case CUV_SRC_06:
            reg |= I2S_CH_ST_2_SRC_06;
            break;

        case CUV_SRC_07:
            reg |= I2S_CH_ST_2_SRC_07;
            break;

        case CUV_SRC_08:
            reg |= I2S_CH_ST_2_SRC_08;
            break;

        case CUV_SRC_09:
            reg |= I2S_CH_ST_2_SRC_09;
            break;

        case CUV_SRC_10:
            reg |= I2S_CH_ST_2_SRC_10;
            break;

        case CUV_SRC_11:
            reg |= I2S_CH_ST_2_SRC_11;
            break;

        case CUV_SRC_12:
            reg |= I2S_CH_ST_2_SRC_12;
            break;

        case CUV_SRC_13:
            reg |= I2S_CH_ST_2_SRC_13;
            break;

        case CUV_SRC_14:
            reg |= I2S_CH_ST_2_SRC_14;
            break;

        case CUV_SRC_15:
            reg |= I2S_CH_ST_2_SRC_15;
            break;

        default:
            return ERROR;
    }

    HdmiAudioOutp8(rHDMI_I2S_CH_ST_2, reg);

    return OK;
}

/**
 * Set sampling frequency on I2S Hardware CUV fields
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetSamplingFreq(SamplingFreq freq)
{
    u8 reg = HdmiAudioInp8(rHDMI_I2S_CH_ST_3) & ~I2S_CH_ST_3_SF_MASK;

    switch (freq)
    {
        case SF_32KHZ:
            reg |= I2S_CH_ST_3_SF_32KHZ;
            break;
        case SF_44KHZ:
            reg |= I2S_CH_ST_3_SF_44KHZ;
            break;
        case SF_88KHZ:
            reg |= I2S_CH_ST_3_SF_88KHZ;
            break;
        case SF_176KHZ:
            reg |= I2S_CH_ST_3_SF_176KHZ;
            break;
        case SF_48KHZ:
            reg |= I2S_CH_ST_3_SF_48KHZ;
            break;
        case SF_96KHZ:
            reg |= I2S_CH_ST_3_SF_96KHZ;
            break;
        case SF_192KHZ:
            reg |= I2S_CH_ST_3_SF_192KHZ;
            break;
        default:
            return ERROR;
    }
    
    HdmiAudioOutp8(rHDMI_I2S_CH_ST_3, reg);

    return OK;  
}

/**
 * Set clock accuracy information on I2S Hardware CUV fields
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetClockAccuracy(CUVClockAccuracy ca)
{
    u8 reg = HdmiAudioInp8(rHDMI_I2S_CH_ST_3) & ~I2S_CH_ST_3_CA_MASK;

    switch (ca)
    {
        case CUV_CA_LEVEL_I:
            reg |= I2S_CH_ST_3_CA_LEVEL_I;
            break;

        case CUV_CA_LEVEL_II:
            reg |= I2S_CH_ST_3_CA_LEVEL_II;
            break;

        case CUV_CA_LEVEL_III:
            reg |= I2S_CH_ST_3_CA_LEVEL_III;
            break;

        case CUV_CA_NOT_MATCH:
            reg |= I2S_CH_ST_3_CA_NOT_MATCH;
            break;

        default:
            return ERROR;
    }

    HdmiAudioOutp8(rHDMI_I2S_CH_ST_3, reg);

    return OK;  
}

/**
 * Set original sampling frequency on I2S Hardware CUV fields
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetOriginalSamplingFrequency(CUVOrigSamplingFreq osf)
{
    u8 reg = HdmiAudioInp8(rHDMI_I2S_CH_ST_4) & ~I2S_CH_ST_4_OSF_MASK;

    switch (osf)
    {
        case CUV_OSF_44KHZ:
            reg |= I2S_CH_ST_4_OSF_44KHZ;
            break;

        case CUV_OSF_88KHZ:
            reg |= I2S_CH_ST_4_OSF_88KHZ;
            break;

        case CUV_OSF_22KHZ:
            reg |= I2S_CH_ST_4_OSF_22KHZ;
            break;

        case CUV_OSF_176KHZ:
            reg |= I2S_CH_ST_4_OSF_176KHZ;
            break;

        case CUV_OSF_48KHZ:
            reg |= I2S_CH_ST_4_OSF_48KHZ;
            break;

        case CUV_OSF_96KHZ:
            reg |= I2S_CH_ST_4_OSF_96KHZ;
            break;

        case CUV_OSF_24KHZ:
            reg |= I2S_CH_ST_4_OSF_24KHZ;
            break;

        case CUV_OSF_192KHZ:
            reg |= I2S_CH_ST_4_OSF_192KHZ;
            break;

        case CUV_OSF_8KHZ:
            reg |= I2S_CH_ST_4_OSF_8KHZ;
            break;

        case CUV_OSF_11KHZ:
            reg |= I2S_CH_ST_4_OSF_11KHZ;
            break;

        case CUV_OSF_12KHZ:
            reg |= I2S_CH_ST_4_OSF_12KHZ;
            break;

        case CUV_OSF_32KHZ:
            reg |= I2S_CH_ST_4_OSF_32KHZ;
            break;

        case CUV_OSF_16KHZ:
            reg |= I2S_CH_ST_4_OSF_16KHZ;
            break;

        case CUV_OSF_NOT_INDICATED:
            reg |= I2S_CH_ST_4_OSF_NOT_INDICATED;
            break;
             
        default:
            return ERROR;
    }

    HdmiAudioOutp8(rHDMI_I2S_CH_ST_4, reg);

    return OK;  
}

/**
 * Set word length of LPCM stream on I2S Hardware CUV fields
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVSetSampleWordLength(CUVWordLength wl)
{
    u8 reg = HdmiAudioInp8(rHDMI_I2S_CH_ST_4) & ~I2S_CH_ST_4_WL_MASK;

    switch (wl)
    {
        case CUV_WL_20_NOT_DEFINED:
            reg |= I2S_CH_ST_4_WL_20_NOT_DEFINED;
            break;

        case CUV_WL_20_16:
            reg |= I2S_CH_ST_4_WL_20_16;
            break;

        case CUV_WL_20_18:
            reg |= I2S_CH_ST_4_WL_20_18;
            break;

        case CUV_WL_20_19:
            reg |= I2S_CH_ST_4_WL_20_19;
            break;

        case CUV_WL_20_20:
            reg |= I2S_CH_ST_4_WL_20_20;
            break;

        case CUV_WL_20_17:
            reg |= I2S_CH_ST_4_WL_20_17;
            break;

        case CUV_WL_24_NOT_DEFINED:
            reg |= I2S_CH_ST_4_WL_24_NOT_DEFINED;
            break;

        case CUV_WL_24_20:
            reg |= I2S_CH_ST_4_WL_24_20;
            break;

        case CUV_WL_24_22:
            reg |= I2S_CH_ST_4_WL_24_22;
            break;

        case CUV_WL_24_23:
            reg |= I2S_CH_ST_4_WL_24_23;
            break;

        case CUV_WL_24_24:
            reg |= I2S_CH_ST_4_WL_24_24;
            break;

        case CUV_WL_24_21:
            reg |= I2S_CH_ST_4_WL_24_21;
            break;

        default:
            return ERROR;
    }

    HdmiAudioOutp8(rHDMI_I2S_CH_ST_4, reg);

    return OK;  
}

/**
 * Make the setting values adopted in I2S Hardware. @n
 * Without this, the setting value does not work.
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVUpdate(void)
{
    // update channel state data
    HdmiAudioOutp8(rHDMI_I2S_CH_ST_CON, 0x01);

    return OK;
}

/**
 * Reset I2S CUV values
 *
 * @return On success, return OK;Otherwise, return ERROR
 */
s32 CUVReset(void)
{
    HdmiAudioOutp8(rHDMI_I2S_CH_ST_0, 0x00);
    HdmiAudioOutp8(rHDMI_I2S_CH_ST_1, 0x00);
    HdmiAudioOutp8(rHDMI_I2S_CH_ST_2, 0x00);
    HdmiAudioOutp8(rHDMI_I2S_CH_ST_3, 0x00);
    HdmiAudioOutp8(rHDMI_I2S_CH_ST_4, 0x00);

    CUVUpdate();
    
    return OK;
}
