//-------------------------------------------------------------------
// Copyright SAMSUNG Electronics Co., Ltd
// All right reserved.
//
// This software is the confidential and proprietary information
// of Samsung Electronics, Inc. ("Confidential Information").  You
// shall not disclose such Confidential Information and shall use
// it only in accordance with the terms of the license agreement
// you entered into with Samsung Electronics. 
//-------------------------------------------------------------------

#ifndef _HDMI_H_
#define _HDMI_H_


#ifdef __cplusplus
extern "C" {
#endif

// HDMI_SYSCON0 bit mask
#define HDMI_SYS_ENABLE             		(1<<0)
#define HDMI_PWDN_ENABLE            	(1<<1)
#define HDMI_ASP_ENABLE             	(1<<2)
#define YCBCR422_ENABLE             		(1<<3)
#define ENCODING_OPTION_ENABLE	(1<<4)
#define HDMI_BLUE_SCR_ENABLE        	(1<<5)

#define HDMI_MODE_SEL_DVI           	(1<<0)
#define HDMI_MODE_SEL_HDMI          	(1<<1)

#define SYSCON2_DVI                 		(1<<5 | 1<<1)
#define SYSCON2_HDMI                		(0)

#define HDMI_PHY_READY              		(1<<0)

#define HDMI_IRQ_TOTAL_NUM                              6

#define NUM_OF_POSSIBLE_EDID_BLOCK  4
#define NUM_OF_RETRY                5

//#define SPDIF_NLPCM                 1

// HDMI IRQ Number
#define HDMI_IRQ_PIN_POLAR_CTL		7
#define HDMI_IRQ_GLOBAL				6
#define HDMI_IRQ_I2S					5
#define HDMI_IRQ_CEC					4
#define HDMI_IRQ_HPD_PLUG				3
#define HDMI_IRQ_HPD_UNPLUG			2
#define HDMI_IRQ_SPDIF					1
#define HDMI_IRQ_HDCP					0

// video format for HDMI HW (timings and AVI) and EDID
typedef enum 
{
    v640x480p_60Hz = 0,  
    v720x480p_60Hz,
    v1280x720p_60Hz,
    v1920x1080i_60Hz,
    v720x480i_60Hz,   
    v720x240p_60Hz,   
    v2880x480i_60Hz,   
    v2880x240p_60Hz,   
    v1440x480p_60Hz,
    v1920x1080p_60Hz,
    v720x576p_50Hz,
    v1280x720p_50Hz,
    v1920x1080i_50Hz,
    v720x576i_50Hz,
    v720x288p_50Hz,
    v2880x576i_50Hz,
    v2880x288p_50Hz,
    v1440x576p_50Hz,
    v1920x1080p_50Hz,
    v1920x1080p_24Hz,
    v1920x1080p_25Hz,
    v1920x1080p_30Hz,
    v2880x480p_60Hz,
    v2880x576p_50Hz,
    v1920x1080i_50Hz_1250,
    v1920x1080i_100Hz,
    v1280x720p_100Hz,
    v720x576p_100Hz,
    v720x576i_100Hz,
    v1920x1080i_120Hz,
    v1280x720p_120Hz,
    v720x480p_120Hz,
    v720x480i_120Hz,
    v720x576p_200Hz,
    v720x576i_200Hz,
    v720x480p_240Hz,
    v720x480i_240Hz,   
}VideoFormat;                               

// mode for HDMI HW (settings) and EDID
typedef enum  
{
    DVI = 0,
    HDMI
}HDMIMode;

// pixel aspect ratio for HDMI HW (AVI packet and EDID)
typedef enum
{
    HDMI_PIXEL_RATIO_4_3,
    HDMI_PIXEL_RATIO_16_9
}PixelAspectRatio;

// Color Space for HDMI HW (settings and AVI packet) and EDID
typedef enum 
{
    HDMI_CS_RGB,
    HDMI_CS_YCBCR444,
    HDMI_CS_YCBCR422
}ColorSpace;

// Color Depth for HDMI HW (settings and GCP packet), EDID and PHY HW
typedef enum 
{    
    HDMI_CD_48,
    HDMI_CD_36,
    HDMI_CD_30,
    HDMI_CD_24
}ColorDepth;

// Pixel limitation for HDMI HW (settings)
typedef enum 
{
    HDMI_FULL_RANGE,
    HDMI_RGB_LIMIT_RANGE,
    HDMI_YCBCR_LIMIT_RANGE
}PixelLimit;

// Colorimetry for HDMI HW (AVI packet) and EDID
typedef enum 
{
    HDMI_COLORIMETRY_NO_DATA,
    HDMI_COLORIMETRY_ITU601,
    HDMI_COLORIMETRY_ITU709,
    HDMI_COLORIMETRY_EXTENDED
}HDMIColorimetry;

// Extended Colorimetry for HDMI HW (AVI packet) and EDID
typedef enum 
{
    HDMI_COLORIMETRY_EXTENDED_xvYCC601,
    HDMI_COLORIMETRY_EXTENDED_xvYCC709
}HDMIExtendedColorimetry;

/*
 * Audio related
 */

// Stream type for HDMI HW (audio packet and audio HW settings)
typedef enum 
{
    ASP,
    SACD,
    OneBitAudio,
    DST,
}AudioPacketType;

// for HDMI HW (audio HW settings)
typedef enum 
{
    I2S_PORT,
    SPDIF_PORT
}AudioInputPort; 


// this is used for EDID parsing
typedef enum 
{
    SF_32KHZ = 0, 
    SF_44KHZ, 
    SF_88KHZ, 
    SF_176KHZ,
    SF_48KHZ, 
    SF_96KHZ, 
    SF_192KHZ,
}SamplingFreq;

// for HDMI HW (AVI packet) and EDID
typedef enum 
{
    CH_2 = 2,
    CH_3,
    CH_4,
    CH_5,
    CH_6,
    CH_7,
    CH_8,
}ChannelNum;

// for HDMI HW (audio HW settings)
typedef enum 
{
    I2S_BPC_16,
    I2S_BPC_20,
    I2S_BPC_24,
}I2SBitsPerChannel;

typedef void (*ISR)(u32);

extern ISR vpISRTABLE[HDMI_IRQ_TOTAL_NUM];

s32 HDMI_Init(void);
s32 HDMI_Enable(u32 enable);
s32 HDMI_SetMode(HDMIMode mode);
s32 HDMI_EnableBlueScreen(u32 enable);
s32 HDMI_SWHPDEnable(u32 enable);
s32 HDMI_SetSWHPD(u32 level);
s32 HDMI_SetVideoMode(VideoFormat mode, ColorDepth cd, PixelAspectRatio pixelRatio); 
s32 HDMI_SetPhyFreq(VideoFormat mode, ColorDepth cd);
s32 HDMI_SetColorSpace(ColorSpace cs); 
s32 HDMI_SetPixelLimit(PixelLimit mode);
s32 HDMI_SetGamutMetadataColorSpace(HDMIColorimetry eColormetry);
s32 HDMI_SetAVMute(u32 enable);
s32 HDMI_SetColorimetry(HDMIColorimetry colorimetry);
s32 HDMI_SetExtendedColorimetry(HDMIExtendedColorimetry extcolorimetry);
s32 HDMI_SetGamutMetadata(u8 *pdata, u8 size);
s32 HDMI_EnableGamutMetadata(u32 enable);
s32 HDMI_SetAudioInputPort(AudioInputPort port);
s32 HDMI_CloseAudioInputPort(AudioInputPort port);
s32 HDMI_SetAudioStreamType(AudioPacketType type, SamplingFreq freq);
s32 HDMI_I2SBitsPerChannel(I2SBitsPerChannel bpc);
s32 HDMI_SetAudioNumberOfChannels(ChannelNum chnum);
s32 HDMI_SetChannelAllocation(u8 ucCa);
static s32 HDMI_TransmitSPDInfoFrame(void);
static s32 HDMI_TransmitACPPacket(void);
static s32 HDMI_TransmitISRCPacket(void);
static s32 HDMI_TransmitMPEGInfoFrame(void);
s32 HDMI_CoreReset(void);
s32 HDMI_CheckPhyReady(void);
s32 HDMI_TG_Setting(VideoFormat mode);
s32 HDMI_TG_MHL_Setting(VideoFormat mode, u8 ucClockInv);
s32 HDMI_TG_OnOff(u8 ucEnable);
s32 HDMI_MHLEnable(u32 uOnOff);
void HDMI_UpdateAVIChecksum(void);
s32 HDMI_PHYSetting(VideoFormat mode, ColorDepth cd);

#ifdef __cplusplus
}
#endif

#endif /*_HDMI_H_*/ 
