/**
 * File Name : hdmi.h
 *
 * File Description :
 * This file implements the hdcp
 *
 * Author : Hee Myung Noh
 * Dept : AP Development
 * Created Date : 2009/01/22
 * Version : 0.1
 * History 
 *  - Initial version (Hee Myung Noh 090122)
 */
#ifndef _HDCP_H_
#define _HDCP_H_


#ifdef __cplusplus
extern "C"
{
#endif

#define EFUSE_ADDR_WIDTH			(240)
#define EFUSE_SIGDEV_ASSERT		(0)
#define EFUSE_SIGDEV_DEASSERT		(96)
#define EFUSE_PRCHG_ASSERT		(0)
#define EFUSE_PRCHG_DEASSERT		(144)
#define EFUSE_FSET_ASSERT			(48)
#define EFUSE_FSET_DEASSERT		(192)
#define EFUSE_SENSING				(240)
#define EFUSE_SCK_ASSERT			(48)
#define EFUSE_SCK_DEASSERT			(144)
#define EFUSE_SDOUT_OFFSET		(192)
#define EFUSE_READ_OFFSET			(192)

#define EFUSE_ECC_DONE				(1<<0)
#define EFUSE_ECC_BUSY				(1<<1)
#define EFUSE_ECC_FAIL				(1<<2)

#define HDCP_RI_RETRY				(5)

s32 HDCP_Init(void);
s32 HDCP_Start(void);
s32 HDCP_Stop(void);
void HDCP_Run(void);

#ifdef __cplusplus
}
#endif

#endif  /* _HDCP_H_ */
