/**
 * File Name : edid.h
 *
 * File Description :
 * This file implements the edid of hdmi
 *
 * Author : Hee Myung Noh
 * Dept : AP Development
 * Created Date : 2009/01/22
 * Version : 0.1
 * History 
 *  - Initial version (Hee Myung Noh 090122)
 */

#ifndef _EDID_H_
#define _EDID_H_

///rb1004
///#include "ddc.h"
#include "hdmi.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef enum 
{
	LPCM_FORMAT = 1,
	AC3_FORMAT,
	MPEG1_FORMAT,
	MP3_FORMAT,
	MPEG2_FORMAT,
	AAC_FORMAT,
	DTS_FORMAT,
	ATRAC_FORMAT,
	DSD_FORMAT,
	Dolby_Digital_Plus_FORMAT,
	DTS_HD_FORMAT,
	MAT_FORMAT,
	DST_FORMAT,
	WAM_Pro_FORMAT
}AudioFormat;

typedef enum 
{
	WORD_16 = 0,
	WORD_20,
	WORD_24
}LPCM_WordLen;

// audio paramters for parsing EDID
typedef struct AudioParameter 
{
	AudioFormat FormatCode;
	s32 MaxChannels;
	s32 SampleFreq;
	LPCM_WordLen WordLength;
}AudioParameter;

void ResetEDID(void);
s32 IsHDMIModeSupported(void);
s32 IsVideoModeSupported(VideoFormat videoMode, PixelAspectRatio pixelRatio);
s32 IsColorSpaceAndDepthSupported(ColorSpace colorSpace,ColorDepth colorDepth);
s32 IsColorimetrySupported(HDMIColorimetry colorimetry);
s32 IsAudioSupported(AudioParameter audioPara);
s32 GetCECPhysicalAddr(u32* outAddr);
s32 ReadEDID(s32 retry);

#ifdef __cplusplus
}
#endif

#endif /* _EDID_H_ */
