/**
 * File Name : cec.c
 *
 * File Description :
 * This file implements the hdmi v1.3 cec function in S5PV210 project
 *
 * Author : Hee Myung Noh
 * Dept : AP Development
 * Created Date : 2009/01/22
 * Version : 0.1
 * History 
 *  - Initiate version (Hee Myung Noh 090122)
 */


#ifndef _CEC_H_
#define _CEC_H_

#define CEC_IOC_MAGIC        'c'

/**
 * CEC device request code to set logical address.
 */
#define CEC_IOC_SETLADDR     _IOW(CEC_IOC_MAGIC, 0, unsigned int)

/** Maximum CEC frame size */
#define CEC_MAX_FRAME_SIZE               			 	16
/** Not valid CEC physical address */
#define CEC_NOT_VALID_PHYSICAL_ADDRESS    			0xFFFF

/** CEC broadcast address (as destination address) */
#define CEC_MSG_BROADCAST        						0x0F
/** CEC unregistered address (as initiator address) */
#define CEC_LADDR_UNREGISTERED   					0x0F

/*
 * CEC Messages
 */

/** @name Messages for the One Touch Play Feature */
#define CEC_OPCODE_ACTIVE_SOURCE            			0x82
#define CEC_OPCODE_IMAGE_VIEW_ON					0x04
#define CEC_OPCODE_TEXT_VIEW_ON					0x0D

/** @name Messages for the Routing Control Feature */
#define CEC_OPCODE_INACTIVE_SOURCE				0x9D
#define CEC_OPCODE_REQUEST_ACTIVE_SOURCE		0x85
#define CEC_OPCODE_ROUTING_CHANGE				0x80
#define CEC_OPCODE_ROUTING_INFORMATION			0x81
#define CEC_OPCODE_SET_STREAM_PATH				0x86

/** @name Messages for the Standby Feature */
#define CEC_OPCODE_STANDBY						0x36

/** @name Messages for the One Touch Record Feature */
#define CEC_OPCODE_RECORD_OFF						0x0B
#define CEC_OPCODE_RECORD_ON						0x09
#define CEC_OPCODE_RECORD_STATUS					0x0A
#define CEC_OPCODE_RECORD_TV_SCREEN				0x0F

/** @name Messages for the Timer Programming Feature */
#define CEC_OPCODE_CLEAR_ANALOGUE_TIMER			0x33
#define CEC_OPCODE_CLEAR_DIGITAL_TIMER			0x99
#define CEC_OPCODE_CLEAR_EXTERNAL_TIMER			0xA1
#define CEC_OPCODE_SET_ANALOGUE_TIMER			0x34
#define CEC_OPCODE_SET_DIGITAL_TIMER				0x97
#define CEC_OPCODE_SET_EXTERNAL_TIMER			0xA2
#define CEC_OPCODE_SET_TIMER_PROGRAM_TITLE		0x67
#define CEC_OPCODE_TIMER_CLEARED_STATUS			0x43
#define CEC_OPCODE_TIMER_STATUS					0x35

/** @name Messages for the System Information Feature */
#define CEC_OPCODE_CEC_VERSION					0x9E
#define CEC_OPCODE_GET_CEC_VERSION				0x9F
#define CEC_OPCODE_GIVE_PHYSICAL_ADDRESS		0x83
#define CEC_OPCODE_GET_MENU_LANGUAGE			0x91
//#define CEC_OPCODE_POLLING_MESSAGE
#define CEC_OPCODE_REPORT_PHYSICAL_ADDRESS		0x84
#define CEC_OPCODE_SET_MENU_LANGUAGE			0x32

/** @name Messages for the Deck Control Feature */
#define CEC_OPCODE_DECK_CONTROL					0x42
#define CEC_OPCODE_DECK_STATUS					0x1B
#define CEC_OPCODE_GIVE_DECK_STATUS				0x1A
#define CEC_OPCODE_PLAY							0x41

/** @name Messages for the Tuner Control Feature */
#define CEC_OPCODE_GIVE_TUNER_DEVICE_STATUS		0x08
#define CEC_OPCODE_SELECT_ANALOGUE_SERVICE		0x92
#define CEC_OPCODE_SELECT_DIGITAL_SERVICE		0x93
#define CEC_OPCODE_TUNER_DEVICE_STATUS			0x07
#define CEC_OPCODE_TUNER_STEP_DECREMENT			0x06
#define CEC_OPCODE_TUNER_STEP_INCREMENT			0x05

/** @name Messages for the Vendor Specific Commands Feature */
#define CEC_OPCODE_DEVICE_VENDOR_ID				0x87
#define CEC_OPCODE_GET_DEVICE_VENDOR_ID			0x8C
#define CEC_OPCODE_VENDOR_COMMAND				0x89
#define CEC_OPCODE_VENDOR_COMMAND_WITH_ID		0xA0
#define CEC_OPCODE_VENDOR_REMOTE_BUTTON_DOWN	0x8A
#define CEC_OPCODE_VENDOR_REMOVE_BUTTON_UP		0x8B

/** @name Messages for the OSD Display Feature */
#define CEC_OPCODE_SET_OSD_STRING				0x64

/** @name Messages for the Device OSD Transfer Feature */
#define CEC_OPCODE_GIVE_OSD_NAME					0x46
#define CEC_OPCODE_SET_OSD_NAME					0x47

/** @name Messages for the Device Menu Control Feature */
#define CEC_OPCODE_MENU_REQUEST					0x8D
#define CEC_OPCODE_MENU_STATUS					0x8E
#define CEC_OPCODE_USER_CONTROL_PRESSED			0x44
#define CEC_OPCODE_USER_CONTROL_RELEASED		0x45

/** @name Messages for the Remote Control Passthrough Feature */

/** @name Messages for the Power Status Feature */
#define CEC_OPCODE_GIVE_DEVICE_POWER_STATUS	0x8F
#define CEC_OPCODE_REPORT_POWER_STATUS			0x90

/** @name Messages for General Protocol messages */
#define CEC_OPCODE_FEATURE_ABORT					0x00
#define CEC_OPCODE_ABORT							0xFF

/** @name Messages for the System Audio Control Feature */
#define CEC_OPCODE_GIVE_AUDIO_STATUS						0x71
#define CEC_OPCODE_GIVE_SYSTEM_AUDIO_MODE_STATUS		0x7D
#define CEC_OPCODE_REPORT_AUDIO_STATUS					0x7A
#define CEC_OPCODE_SET_SYSTEM_AUDIO_MODE				0x72
#define CEC_OPCODE_SYSTEM_AUDIO_MODE_REQUEST			0x70
#define CEC_OPCODE_SYSTEM_AUDIO_MODE_STATUS			0x7E

/** @name Messages for the Audio Rate Control Feature */
#define CEC_OPCODE_SET_AUDIO_RATE				0x9A


/** @name CEC Operands */

//TODO: not finished
#define CEC_DECK_CONTROL_MODE_STOP				0x03
#define CEC_PLAY_MODE_PLAY_FORWARD				0x24


/**
 * @name Bit values
 */
#define CEC_STATUS_TX_RUNNING						(1<<0)
#define CEC_STATUS_TX_TRANSFERRING				(1<<1)
#define CEC_STATUS_TX_DONE						(1<<2)
#define CEC_STATUS_TX_ERROR						(1<<3)
#define CEC_STATUS_TX_BYTES						(0xFF<<8)
#define CEC_STATUS_RX_RUNNING						(1<<16)
#define CEC_STATUS_RX_RECEIVING					(1<<17)
#define CEC_STATUS_RX_DONE						(1<<18)
#define CEC_STATUS_RX_ERROR						(1<<19)
#define CEC_STATUS_RX_BCAST						(1<<20)
#define CEC_STATUS_RX_BYTES						(0xFF<<24)

#define CEC_IRQ_TX_DONE							(1<<0)
#define CEC_IRQ_TX_ERROR							(1<<1)
#define CEC_IRQ_RX_DONE							(1<<4)
#define CEC_IRQ_RX_ERROR							(1<<5)

#define CEC_TX_CTRL_START							(1<<0)
#define CEC_TX_CTRL_BCAST							(1<<1)
#define CEC_TX_CTRL_RETRY							(0x04<<4)
#define CEC_TX_CTRL_RESET							(1<<7)

#define CEC_RX_CTRL_ENABLE							(1<<0)
#define CEC_RX_CTRL_RESET							(1<<7)

/** CEC Rx buffer size */
#define CEC_RX_BUFF_SIZE				16
/** CEC Tx buffer size */
#define CEC_TX_BUFF_SIZE				16
#define CEC_LOGIC_ADDR_MASK			0x0F


/**
 * @enum cec_state
 * Defines all possible states of CEC software state machine
 */
typedef enum  {
	STATE_RX,
	STATE_TX,
	STATE_DONE,
	STATE_ERROR
}cec_state;


/**
 * @enum CECDeviceType
 * Type of CEC device
 */
typedef enum {
    /** TV */
    CEC_DEVICE_TV,
    /** Recording Device */
    CEC_DEVICE_RECODER,
    /** Tuner */
    CEC_DEVICE_TUNER,
    /** Playback Device */
    CEC_DEVICE_PLAYER,
    /** Audio System */
    CEC_DEVICE_AUDIO,
}CECDeviceType;

/**
 * @struct cec_rx_struct
 * Holds CEC Rx state and data
 */
typedef struct {
///	spinlock_t lock;
///	wait_queue_head_t waitq;
///	atomic_t state;
	u8 buffer[CEC_MAX_FRAME_SIZE];
	u32 size;
}oCec_Rx_struct;



u32 CEC_Init(void);
void CEC_ISR(void);
s32 CEC_Open(void);
s32 CEC_Close(void);
s32 CEC_SendMessage(u8 *pBuffer, u32 uCount);
void CEC_SetDivider(void);
void CEC_EnableInterrupts(void);
void CEC_DisableInterrupts(void);
void CEC_EnableRx(void);
void CEC_EnableRx(void);
void CEC_MaskRxInterrupts(void);
void CEC_UnmaskRxInterrupts(void);
void CEC_MaskTxInterrupts(void);
void CEC_UnmaskTxInterrupts(void);
void CEC_SetTxState(cec_state eState);
void CEC_SetRxState(cec_state eState);
u8 CEC_AllocLogicalAddress(u32 paddr, CECDeviceType devtype);
s32 CEC_SetLogicalAddr(u32 laddr);
void CEC_PrintFrame(u8 *buffer, u32 size);
s32 CEC_IgnoreMessage(u8 opcode, u8 lsrc);
s32 CEC_CheckMessageSize(u8 opcode, s32 size);
s32 CEC_CheckMessageMode(u8 opcode, s32 broadcast);



#endif /* _CEC_H_ */
