#ifndef _SBLOCK_DATA_H_
#define _SBLOCK_DATA_H_

#include "def.h"
#include "system.h"

#define A1_data_cnt  348 	// 10'th, PKA
#define A1_sfr_cnt 50
#define AB_data_cnt  357 	// 10'th
#define AB_sfr_cnt 50
#define Ovf_data_cnt  200 	// 8'th
#define Ovf_sfr_cnt 40


 u32 uAesPlainText[]=
{
	0xe2bec16b,
	0x969f402e,
	0x117e3de9,
	0x2a179373,

	0x578a2dae,
	0x9cac031e,
	0xac6fb79e,
	0x518eaf45,

	0x461cc830,
	0x11e45ca3,
	0x19c1fbe5,
	0xef520a1a,

	0x45249ff6,
	0x179b4fdf,
	0x7b412bad,
	0x10376ce6
};

u32 uAesCipherText[][16]=
{
	// ECB
	0xb47bd73a,
	0x60367a0d,
	0xf3ca9ea8,
	0x97ef6624,

	0x85d5d3f5,
	0x9d69b903,
	0x5a8985e7,
	0xafbafd96,

	0x7fcdb143,
	0x23ce8e59,
	0xe3001b88,
	0x880603ed,

	0x5e780c7b,
	0x3fade827,
	0x71202382,
	0xd45d7204,

	// CBC
	0xacab4976,
	0x46b21981,
	0x9b8ee9ce,
	0x7d19e912,

	0x9bcb8650,
	0xee197250,
	0x3a11db95,
	0xb2787691,

	0xb8d6be73,
	0x3b74c1e3,
	0x9ee61671,
	0x16952222,

	0xa1caf13f,
	0x09ac1f68,
	0x30ca0e12,
	0xa7e18675,

	// CTR
	0x91614d87,
	0x26e320b6,
	0x6468ef1b,
	0xceb60d99,
	
	0x6bf60698,
	0xfffd7079,
	0x7b181786,
	0xfffdffb9,
	
	0x3edfe45a,
	0x5ed3d5db,
	0x02094f5b,
	0xab3eb00d,
	
	0xda1d031e,
	0xd103be2f,
	0xa0702179,
	0xee9c00f3
};
u32 uAesCipherText128[]=
{
	//CBC
	0xacab4976,
	0x46b21981,
	0x9b8ee9ce,
	0x7d19e912,

	0x9bcb8650,
	0xee197250,
	0x3a11db95,
	0xb2787691,

	0xb8d6be73,
	0x3b74c1e3,
	0x9ee61671,
	0x16952222,

	0xa1caf13f,
	0x09ac1f68,
	0x30ca0e12,
	0xa7e18675
	
};

u32 uAesCipherText192[]=
{
	//CBC
	0xb21d024f,
	0x3d63bc43,
	0x3a187871,
	0xe871a09f,
	0xa9add9b4,
	0xf4ed7dad,
	0x7638e7e5,
	0x5a14693f,

	0x20241b57,
	0xe07afb12,
	0xacbaa97f,
	0xe002f13d,
	0x79e2b008,
	0x81885988,
	0xe6a920d9,
	0xcd15564f
	
};

u32 uAesCipherText256[]=
{
	//CBC
	0x044c8cf5,
	0xbaf1e5d6,
	0xfbab9e77,
	0xd6fb7b5f,
	0x964efc9c,
	0x8d80db7e,
	0x7b779f67,
	0x7d2c70c6,

	0x6933f239,
	0xcfbad9a9,
	0x63e230a5,
	0x61142304,
	0xe205ebb2,
	0xfce99bc3,
	0x07196cda,
	0x1b9d6a8c
	
};

const u32 uAesCTRCipherText[]=
{
	
	0x08e2493c,
	0xcd6d1d4b,
	0x326cb23e,
	0xbce71ec6,
	0xe5829528,
	0x7d6950d4,
	0x813a55b5,
	0x242bf801,
	0x4fb1f6d0,
	0x91ba9596,
	0x74709d04,
	0x5b1c21c3,
	0x5337aa24,
	0xe04b4df4,
	0x85e36887,
	0xbba033ac,

	//192bit
	0xfd7d95bf,
	0xc53a970f,
	0x04205a0d,
	0x1fe19e7b,
	0xf049df92,
	0x9ade731c,
	0x58bce96b,
	0xfdc07322,
	0x80ce4f94,
	0x8b537ee8,
	0x942157de,
	0x2e6f2d88,
	0x2169166c,
	0x2b7b1e8a,
	0x7c59edd2,
	0xec59e6dc,

	//256bit
	0x58fb631d,
	0xe09b8184,
	0x55fa1d41,
	0x3f2b5a85,
	0x05ece1ba,
	0x279995ac,
	0xc748fdfe,
	0xd06b94c1,
	0x092b7884,
	0xd9706a1c,
	0x89131a94,
	0x4841b0df,
	0xf90cc0e4,
	0xca8f6bb2,
	0x89e3b24a,
	0x9268a3f0,

	//256_
	0xea89ac17,
	0xaf9d0566,
	0xcf5058e1,
	0xed834cb3,
	0x72a5e5aa,
	0xc6f26c16,
	0xd4e8ef63,
	0x7a545c91,
	0x635d85a7,
	0x232b3aac,
	0x1c28e43f,
	0xf15ab6af,
	0x0fbe0a16,
	0xd81c1573,
	0x5b91a252,
	0x00dfc89c
	
	
};

const u32 uAesCTRCipherText_[]=
{
	
	0x91614d87,
	0x26e320b6,
	0x6468ef1b,
	0xceb60d99,
	0x6bf60698,
	0xfffd7079,
	0x7b181786,
	0xfffdffb9,
	
	0x3edfe45a,
	0x5ed3d5db,
	0x02094f5b,
	0xab3eb00d,
	0xda1d031e,
	0xd103be2f,
	0xa0702179,
	0xee9c00f3,

	//192bit
	0x2493bc1a,
	0xa21c5217,
	0x59042b4f,
	0x0b6e7efe,
	0xec390309,
	0xeffaa60a,
	0xc6c2ccd5,
	0x948ecef4,

	0x6bb2361e,
	0x70c6ebd1,
	0x661dbdd1,
	0xf7ab2056,
	0xf6a7784f,
	0x580998d2,
	0xecda975a,
	0x50b0c658,

	//256bit
	0x13c31e60,
	0xa5895777,
	0x04f5a7b7,
	0x28d2f3bb,
	0xcae343f4,
	0x9ab5624d,
	0x90e984ca,
	0xc5f5caca,

	0xda30092b,
	0x4ce93da2,
	0xba1770e8,
	0x8d98842d,
	0x8dc5c9df,
	0xa6ad7ab6,
	0x08ddc213,
	0xa6417945


	
	
};

//u32 uDesPlainText[]=
const u32 uDesPlainText[]=   // O.K
{
	0xe70ae5b0,
	0xa69afff9,
	0xbcbfdf74,
	0xeac6cb56,

	0x60eeac7b,
	0xebc4566b,
	0xdb3d950e,
	0xb595fb2f,

	0x9dea6cb3,
	0x82976696,
	0x075111a9,
	0x35040a0d,

	0xe16bef6d,
	0xde72aaff,
	0xe34b7e3a,
	0x3b52d355
};

const u32 uDesCipherText[][16]=
{
	// ECB
	0x12dd62ef,
	0xf547ac22,
	0x07e184ca,
	0x4bbf56f2,

	0x22ce61ef,
	0xf01ad82d,
	0x7f6dba7f,
	0x7a25aedb,

	0xff6f619d,
	0xf12a7fc0,
	0x76c82300,
	0xd9e2a30a,

	0xbc6b88f0,
	0xc608d038,
	0x05e4e1b7,
	0xd6e27424,

	// CBC
	0xec0b875b,
	0xd5227916,
	0x0abcab2a,
	0x146fa6c1,

	0xe3faa9f8,
	0xb354d132,
	0xf09f449f,
	0xaae210ec,

	0x70efb0cc,
	0x33121850,
	0x0fb66488,
	0x181f54dc,

	0xb5951afa,
	0x904f4e90,
	0x94c72c8d,
	0xa7392589
};

const u32 uSha1CipherText16[]=
{
	0x431ed237,
	0x06143033,
	0x5cde8bf6,
	0x4eaca4a7,

	0x5ab96b11
};

const u32 uSha1CipherText47[]=
{
	0xa6086048,
	0x4eb66d61,
	0x95ac942e,
	0xa1d4d5ac,

	0x9c054323
};

const u32 uHmacCiperText19[]=
{
	0x0f9de9e8,
	0x787d2345,
	0xa7ba6b6d,
	0x08785c96,

	0x911affbb
};

const u32 uHmacCiperText47[]=
{
	0x32fb24c7,
	0xffabfe1d,
	0xcab4a00a,
	0x130c381a,

	0x64420583
};

const u32 uHmacPlainText19[]=
{
	0x74736554,
	0x69735520,
	0x4c20676e,
	0x65677261,
	
	0x68542072,
	0x42206e61,
	0x6b636f6c,
	0x7a69532d,
	
	0x654b2065,
	0x6e612079,
	0x614c2064,
	0x72656772,

	0x61685420,
	0x6e4f206e,
	0x6c422065,
	0x2d6b636f,

	0x657a6953,
	0x74614420,
	0x00000061,
};

const u32 uHmacPlainText47[]=
{
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,

	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,

	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261, 0x64636261,
	0x64636261
};

const u32 uSha1PlainText16[]=
{
	0x64636261,
	0x64636261,
	0x64636261,
	0x64636261,

	0x64636261,
	0x64636261,
	0x64636261,
	0x64636261,

	0x64636261,
	0x64636261,
	0x64636261,
	0x64636261,

	0x64636261,
	0x64636261,
	0x64636261,
	0x64636261
};

const u32 uSha1PlainText47[]=
{
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,

	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261, 0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,

	0x64636261, 0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261
};

const u32 uSha1PlainText121[]=
{
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,		

	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261, 0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,

	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261, 0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,

	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261, 0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,

	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261, 0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,

	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261, 0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	0x64636261,	0x64636261,
	
	0x64636261
};


const u32 uSha1PlainText1[]=
{
	0x64636261
	
};

/*
const u32 uSha1CipherText1_1[]=
{
	0x37e4f786,
	0xfca7a5fa,
	0xdc1d5de1,
	0xeaeaeab9,
	0xb8677637
};

const u32 uSha1CipherText1_2[]=
{
	0x4e6123da,
	0x0d9a4602,
	0xbdd17b7c,
	0x479c5cab,
	0xdc04194b
};

const u32 uSha1CipherText1_3[]=
{
	0x363e99a9,
	0x6a810647,
	0x71253eba,
	0x6cc25078,
	0x9dd8d09c
};

const u32 uSha1CipherText1_4[]=
{
	0x81fe8bfe,
	0x87576c3e,
	0xcb224267,
	0x8e578473,
	0x82917acf
};
*/

const u32 uSha1CipherText1[]=
{
	0x37e4f786,
	0xfca7a5fa,
	0xdc1d5de1,
	0xeaeaeab9,
	0xb8677637,

	0x4e6123da,
	0x0d9a4602,
	0xbdd17b7c,
	0x479c5cab,
	0xdc04194b,

	0x363e99a9,
	0x6a810647,
	0x71253eba,
	0x6cc25078,
	0x9dd8d09c,

	0xfe8bfe81,
	0x3e6c5787,
	0x6f4222cb,
	0x7384578e,
	0xcf7a9182
	
};

const u32 uSha1CipherText2[]=
{
	0x23f24ed8,
	0x4a3ac3fa,
	0x1a68c45f,
	0xbac02df2,
	0x1ed2ff78,

	0xf6f85bac,
	0x3d43609e,
	0x5cf00c05,
	0x53f6cd2b,
	0x68eef24f,

	0x225ad2ed,
	0xf6340e31,
	0xc90d21f3,
	0x916355e8,
	0x41629c85,

	0x128e37e0,
	0x9a5facd7,
	0xd85270f3,
	0xf3e43b76,
	0x4130d1e8
	
};

const u32 uSha1CipherText3[]=
{
	0x91ff75e8,
	0x3a39a5da,
	0xbcc11993,
	0x8aecf835,
	0x6862558b,

	0xf6c16f0c,
	0xbaa5cb31,
	0xf3ad0972,
	0xb9df8d4e,
	0x5872a2fd,

	0x09b2e601,
	0xc515de53,
	0x51e053f3,
	0x7dbf05db,
	0x6fa60f86,

	0xf0aacecd,
	0xe7f0848b,
	0x93edd315,
	0xbb35bb49,
	0xbed26167
	
};

const u32 uSha1CipherText4[]=
{
	0xbfec68ec,
	0x0252b7d4,
	0x539ebd78,
	0xcab3e6ac,
	0xd96ef554,

	0x92d57179,
	0x4a2f18fe,
	0x0c148048,
	0x2ea1eee8,
	0x80620789,

	0x5a82529b,
	0xdb2e3835,
	0x519f756f,
	0x7413d738,
	0xed79be08,

	0xf9f73c4e,
	0x9475763b,
	0x252e4d27,
	0x26ca9ffb,
	0xf97ac1e5
	
};

const u32 uSha1CipherText5[]=
{
	0xff27ee23,
	0x3bb1e2ba,
	0x39667619,
	0x27232b48,
	0x6d9a2133,

	0x468dabdc,
	0xdef964ad,
	0xa53c26db,
	0x9af96254,
	0x349f1028,

	0x4cc75f00,
	0xe525cadf,
	0xd941aa13,
	0xd5d21f81,
	0x574d6215,

	0x3b8223b3,
	0xfe1034d5,
	0x4b15c855,
	0x4856631f,
	0x9235da15
	
};

const u32 uSha1CipherText6[]=
{
	0x050f2bad,
	0xe581aaa3,
	0xf0b065f7,
	0x254b425c,
	0x263eb185,

	0x500bba8d,
	0x282b89e0,
	0xf687b968,
	0x692cb5b1,
	0x02bcec0c,

	0x7f27ae17,
	0x1164d76f,
	0x2c16206b,
	0x7600bd73,
	0x73e94e0c,

	0x458967e8,
	0xa48d1fb4,
	0x3dfdb0c3,
	0xae74cfe9,
	0x1c4a4e88
	
};

const u32 uSha1CipherText7[]=
{
	0x8fedf96f,
	0xf93a2fb3,
	0x6a6d8d4f,
	0x43c94294,
	0x07f6d98e,

	0x7d008276,
	0xc8a62247,
	0x6d3bf7d2,
	0x2dd1574c,
	0xb46973b1,

	0xbc617086,
	0x33b05f31,
	0xe81a6885,
	0xc4d63b68,
	0x0f29b401,

	0x2b084fb5,
	0x8d38beb7,
	0xcc539c8d,
	0x693688dc,
	0x1cf98c7d
	
};

const u32 uSha1CipherText8[]=
{
	0x67cc608f,
	0x5b88707e,
	0x6f181d87,
	0x8dca796d,
	0x1661afd6,

	0x8cb58552,
	0xd8b923c9,
	0xb5556531,
	0xbc6540e1,
	0xaa971775,

	0x2a00edc7,
	0x56f95c95,
	0xbb297174,
	0x36717c44,
	0xbe24cb5b,

	0x8caca8a9,
	0xdbb13478,
	0x65cec39f,
	0xb14e7db6,
	0x345e65d5
	
};



const u32 uSha1CipherText9[]=
{
	0xe9cadb42,
	0xca364e17,
	0x8ac5a673,
	0x06ef093a,
	0x8ca0f914,

	0x0e3cee4e,
	0x4270f080,
	0xdfe72fd4,
	0x03f7f71b,
	0x6dcd88ae,

	0x34cedf3b,
	0x47e6aed3,
	0x24c23fee,
	0x363192e0,
	0xbebc138b,

	0x6b9b4d9d,
	0xfc878b90,
	0xb176c83f,
	0xd3fcb0c1,
	0xfd1e2d29
	
};

const u32 uSha1CipherText10[]=
{
	0xeece8597,
	0x9459fcd4,
	0xa1372396,
	0x3246d23c,
	0x8ad8fa44,

	0x233e0673,
	0x95a7713e,
	0x05937105,
	0x73814077,
	0x057a0ad6,

	0x158c4883,
	0xd394c1a1,
	0xcfb6edb1,
	0xf5e8df2f,
	0xd3fb2723,

	0xca350bdf,
	0xf5a9c925,
	0x1a352f41,
	0xc5cecaf9,
	0x024d4c7c
	
};

const u32 uSha1CipherText11[]=
{
	0x8683a9a7,
	0x78fed9d3,
	0x78c4ecea,
	0xb7641f7d,
	0x4cb41f3b,

	0x17d8305a,
	0xb1d98027,
	0xfd191768,
	0xf1b001fc,
	0x826ccf05,

	0x755a6a2f,
	0xca5b6d42,
	0xf818a6ab,
	0x30957140,
	0x5a2b2d54,

	0xe6ada803,
	0x65251d7d,
	0x135406d7,
	0xf6de6673,
	0xb3896972
	
};

const u32 uSha1CipherText12[]=
{
	0xb9bd0dc4,
	0x30fb5df5,
	0xdf0841fb,
	0x08924be1,
	0xc58c6ced,

	0x63d8281c,
	0x490ca514,
	0x171b36b6,
	0xb0858d7b,
	0x9bb2e431,

	0xfab95154,
	0x4733aa3f,
	0x6f72757b,
	0x33883876,
	0x3ff4beeb,

	0xc96b04f7,
	0x9b91cc12,
	0xcdbace41,
	0x81358340,
	0xe8ef6a10
	
};
const u32 uSha1CipherText13[]=
{
	0xa3072b20,
	0x1bfd788c,
	0x46143fcb,
	0x13130f74,
	0x508fec87,

	0x09f137cf,
	0x9fd2eef7,
	0x8c5d0889,
	0xd8e45933,
	0xc99705d7,

	0x989af013,
	0x1d297f3a,
	0xa49f0efa,
	0x1ca7c23f,
	0xb9129fa9,

	0xa8be4663,
	0xfb9b93ab,
	0x6e314683,
	0x174ffe68,
	0x50452edc
	
};
const u32 uSha1CipherText14[]=
{
	0x7d5b5112,
	0x24cc3ea6,
	0xdc99a98d,
	0xde85c23c,
	0x256c534c,

	0x4f0981a9,
	0x2ca55941,
	0xf7d306df,
	0xff053e18,
	0x46473ea5,

	0xc013b796,
	0x7617f4a5,
	0x7285bff8,
	0xb0183f92,
	0xa2254f57,

	0xd8834163,
	0xadf2b795,
	0xec3be7e4,
	0xcd4f46e1,
	0xd45297d8
	
};

const u32 uSha1CipherText15[]=
{
	0x2f5018eb,
	0xa5a8e0a1,
	0x73f22ab4,
	0xd42e3399,
	0xf172e926,

	0xafaaacd9,
	0xeb638b93,
	0xf0fb7b8b,
	0x8694f366,
	0xa4d2792d,

	0x536a097f,
	0x849adea1,
	0xfcc2a591,
	0xdc72e727,
	0x82367d0d,

	0xe073a18b,
	0x15de9531,
	0x74946929,
	0x0764276f,
	0x9a2a7657
	
};

const u32 uSha1CipherText_Inter[]=
{
	0x21f83e20,
	0x362ae8ee,
	0x38b8f219,
	0x81fdc373,
	0x1a56e095
	
};

const u32 uSha1CipherText_InterValue[]=
{
	0x579394FC,
	0xB51EB631,
	0x7944B91F,
	0x1BEC6938,
	0x303FE675
	
};


const u32 uSha1CipherText_1M[]=			// Temp..
{
	0x9959413C,
	0xbabee1b5,
	0xfaa0a2d4,
	0x53180b62,
	0x12276ff5
	
};
const u32 uhmacCipherText_1M[]=			// Temp
{
	0xe62a872f,
	0x8389ae80,
	0x93da1b51,
	0xe21ee426,
	0x7c8a577a
	
};




///////////////////////////////////////////////////////////////
///////   S5PV210

u32 u_Aes_PlainText[]=
{
	0xe2bec16b,	0x969f402e,	0x117e3de9,	0x2a179373,		
	0x578a2dae,	0x9cac031e,	0xac6fb79e,	0x518eaf45,
	0x461cc830,	0x11e45ca3,	0x19c1fbe5,	0xef520a1a,
	0x45249ff6,	0x179b4fdf,	0x7b412bad,	0x10376ce6
};

u32 u_Aes_CipherText[][3][16]=
{
	// 128 key ECB
	0xb47bd73a,	0x60367a0d,	0xf3ca9ea8,	0x97ef6624,
	0x85d5d3f5,	0x9d69b903,	0x5a8985e7,	0xafbafd96,
	0x7fcdb143,	0x23ce8e59,	0xe3001b88,	0x880603ed,
	0x5e780c7b,	0x3fade827,	0x71202382,	0xd45d7204,

	// 128 key CBC
	0xacab4976,	0x46b21981,	0x9b8ee9ce,	0x7d19e912,
	0x9bcb8650,	0xee197250,	0x3a11db95,	0xb2787691,
	0xb8d6be73,	0x3b74c1e3,	0x9ee61671,	0x16952222,
	0xa1caf13f,	0x09ac1f68, 0x30ca0e12,	0xa7e18675,

	// 128 key CTR
	0x91614d87,	0x26e320b6, 0x6468ef1b,	0xceb60d99,
	0x6bf60698,	0xfffd7079,	0x7b181786,	0xfffdffb9,
	0x3edfe45a,	0x5ed3d5db,	0x02094f5b,	0xab3eb00d,
	0xda1d031e,	0xd103be2f,	0xa0702179,	0xee9c00f3,

	// 192 key ECB
	0x5584CD71,	0x2FE73087,	0x360304D5,	0x4F1E9CB9,
	0xB00D8554,	0x026DBD11,	0x2FBDDD11,	0xE14C8FDA,
	0xBA4146A5,	0x37417FA8,	0xBA76A3C2,	0x151E0508,
	0x12253A75,	0xCC3DE72A,	0x722E3A5A,	0xD1E1AABC,
	                              	                                               
	// 192 key CBC                                                 
	0xD09E1499,	0x3D0630E7,	0x63A6B2C7,	0xD0B8B1C3,  
	0xB9F668C3,	0x7FB1E227,	0x7E12A398,	0xE2E0B7D9,  
	0x3F4876D8,	0xDF04D7C3,	0xD39914E9,	0x2CB31AB1,  
	0x267B3FE4,	0x008710EE,	0x67021D4A,	0x7DC5ED80,  
	                           	           	                       	                                               
	// 192 key CTR             	           	                       
	0x33D9B0A7,	0xE79A6123,	0xB8B3213D,	0xDF40A7B2,
	0x19EE49F2,	0xEDDC91D6,	0x3A90CF40,	0x30A494D8,
	0x24B66408,	0x8F7A3995,	0x8CE7E5E5,	0x69E8CE5A,
	0xAA181DA5,	0x855FAAD0,	0xB7F3D5CD,	0xDA42CD61,
	                           	           	                       	                                               
	// 256 key ECB             	           	                       
	0xDACBA63A,	0xB90B5829,	0x0DEDD92A,	0xEB04EFD4,
	0x15B93314,	0x0A42279A,	0x065EDE35,	0xA18B19C2,
	0xFCB6E197,	0xE608D2E9,	0x66DDDE54,	0x938B751E,
	0x1B7043E2,	0xB2FC4A01,	0xA79DE410,	0xF58D41C1,
	                           	           	                      	                                               
	// 256 key CBC             	           	                       
	0x9C2338E7,	0x76FB274A,	0x5764F1A7,	0xB07CAE81, 
	0xD27B2B0C,	0xBAD0B031,	0x34E461AE,	0x584108FC, 
	0xAC1CCB46,	0xBB04E47C,	0x80554474,	0xF67F746A, 
	0x5B0F40B2,	0x52577954,	0xE2D0BC33,	0x97DEDABE, 
	                           	           	       
	// 256 key CTR             	           	                       
	0xB9B8D09E,	0xE150BEC9,	0x6280DC75,	0x72374382,
	0x36A4B572,	0x268FB137,	0x637A559B,	0xC8827656,
	0xB3BF9F11,	0x41CC2E32,	0x767C0357,	0xF82F7752,
	0xAFFE0246,	0x10A90DF0,	0x11C2E100,	0x567C01AD
};

u32 u_Des_PlainText[]=
{
	0xe70ae5b0,	0xa69afff9,	0xbcbfdf74,	0xeac6cb56,
	0x60eeac7b,	0xebc4566b,	0xdb3d950e,	0xb595fb2f,
	0x9dea6cb3,	0x82976696,	0x075111a9,	0x35040a0d,
	0xe16bef6d,	0xde72aaff,	0xe34b7e3a,	0x3b52d355
};

u32 u_Des_CipherText[][16]=
{
	// ECB
	0x12dd62ef,	0xf547ac22,	0x07e184ca,	0x4bbf56f2,
	0x22ce61ef,	0xf01ad82d,	0x7f6dba7f,	0x7a25aedb,
	0xff6f619d,	0xf12a7fc0,	0x76c82300,	0xd9e2a30a,
	0xbc6b88f0,	0xc608d038,	0x05e4e1b7,	0xd6e27424,

	// CBC
	0xec0b875b,	0xd5227916,	0x0abcab2a,	0x146fa6c1,
	0xe3faa9f8,	0xb354d132,	0xf09f449f,	0xaae210ec,
	0x70efb0cc,	0x33121850,	0x0fb66488,	0x181f54dc,
	0xb5951afa,	0x904f4e90,	0x94c72c8d,	0xa7392589
};

u32 u_Tdes_CipherText[][16]=
{
	// ECB EDE
 	0x3b481e3c,	0xf881cb63,	0xc67c4502,	0x79139931, 
 	0x6809f1b6,	0x8c662378,	0x7379d499,	0x522cde71, 
 	0x4b40762c,	0xab44475f,	0x86dc90c0,	0x952af8c6, 
 	0x19b540a7,	0xe8dc89be,	0x810e5f08,	0xa1433937, 
	           	           	           	
	// CBC EDE 	           	           	
 	0xd32e15ed,	0xecc969fa,	0x3b786808,	0xba9e64b2,
 	0xdea60878,	0x30820afb,	0xc1be6551,	0x428ed701,
 	0x5de88cf6,	0xf725f5bb,	0x7e2fdeee,	0x70a72e19,
 	0x7c6ebea3,	0xe50f9b81,	0x7205e680,	0xa5740ebe,
	           	           	           	
	// ECB EEE 	           	           	
 	0x744361c1,	0xc3fdfe82,	0xce119046,	0xb783f569, 
 	0x8d26bbd4,	0x286a07b2,	0x87d41ca7,	0xee711524, 
 	0x0554bca6,	0xb3eb0e24,	0xee000905,	0x2dad139a, 
 	0x23d39742,	0x077b92e6,	0x37d7fa1e,	0x67f36226, 
	           	           	           	
	// CBC EEE 	           	           	
	0xffc36184,	0xf50a33ee,	0x7d66191d,	0x9d0b260a, 
	0x0e21e8e5,	0xbcb9c7b8,	0x48a5c70b,	0xdf747484,
	0x1da5571b,	0xfe73a282,	0xaad1f454,	0xca846204,
	0xf0277e5d,	0x3062101c,	0x47204a7b,	0x24dd06f3
};

u32 u_PlainText[]=
{
	0x64636261,	0x64636261,	0x64636261,	0x64636261,
	0x64636261,	0x64636261,	0x64636261,	0x64636261,
	0x64636261,	0x64636261,	0x64636261,	0x64636261,
	0x64636261,	0x64636261,	0x64636261,	0x64636261,
	
	0x64636261,	0x64636261,	0x64636261,	0x64636261,
	0x64636261,	0x64636261,	0x64636261,	0x64636261,
	0x64636261,	0x64636261,	0x64636261,	0x64636261,
	0x64636261,	0x64636261,	0x64636261,	0x64636261,

	0x64636261, 0x64636261,	0x64636261,	0x64636261,
	0x64636261,	0x64636261,	0x64636261,	0x64636261,
	0x64636261, 0x64636261,	0x64636261,	0x64636261,
	0x64636261,	0x64636261,	0x64636261
};

//------------------------------------------------------------------
// result
// SHA1("abcd" x 16) = 37d21e43_33301406_f68bde5c_a7a4ac4e_116bb95a
//------------------------------------------------------------------
u32 u_Sha1CipherText16[]=
{
	0x431ed237,	0x06143033,	0x5cde8bf6,	0x4eaca4a7,	0x5ab96b11
};

//------------------------------------------------------------------
// result
// SHA1("abcd" x 47) = 486008a6_616db64e_2e94ac95_acd5d4a1_2343059c
//------------------------------------------------------------------
u32 u_Sha1CipherText47[]=
{
	0xa6086048,	0x4eb66d61,	0x95ac942e,	0xa1d4d5ac,	0x9c054323
};

//--------------------------------------------------------------------
// result
// MD5("abcd" x 16) = 386f81fd_57366030_ae7ea039_2a2c87ae
//--------------------------------------------------------------------
u32 u_Md5CipherText16[]=
{
	0xfd816f38,	0x30603657,	0x39a07eae,	0xae872c2a   
};

//--------------------------------------------------------------------
// result
// MD5("abcd" x 47) = e959f5bd_959ee722_50a7ac6c_b586b46d
//--------------------------------------------------------------------
u32 u_Md5CipherText47[]=
{
	0xbdf559e9,	0x22e79e95,	0x6caca750,	0x6db486b5   
};

//--------------------------------------------------
// HMAC message 1
//--------------------------------------------------
u32 u_HmacPlainText19[]=
{
	0x74736554,	0x69735520,	0x4c20676e,	0x65677261,
	0x68542072,	0x42206e61,	0x6b636f6c,	0x7a69532d,
	0x654b2065,	0x6e612079,	0x614c2064,	0x72656772,
	0x61685420,	0x6e4f206e,	0x6c422065,	0x2d6b636f,

	0x657a6953,	0x74614420,	0x00000061,
};

//------------------------------------------------------------------
// SHA1-HMAC correct answer 1
// e8e99d0f_45237d78_6d6bbaa7_965c7808_bbff1a91
//------------------------------------------------------------------
u32 u_Sha1HmacCipherText19[]=
{
	0x0f9de9e8,	0x787d2345,	0xa7ba6b6d,	0x08785c96,	0x911affbb
};

//------------------------------------------------------------------
// SHA1-HMAC correct answer 2
// c724fb32_1dfeabff_0aa0b4ca_1a380c13_83054264
//------------------------------------------------------------------
u32 u_Sha1HmacCipherText47[]=
{
	0x32fb24c7,	0xffabfe1d,	0xcab4a00a,	0x130c381a,	0x64420583
};

//------------------------------------------------------------------
// MD5-HMAC correct answer 1
// 12d0313b_e4783e47_c23d4f54_213bc0a4
//------------------------------------------------------------------
u32 u_Md5HmacCipherText19[]=
{
	0x3b31d012,	0x473e78e4,	0x544f3dc2,	0xa4c03b21
};

//------------------------------------------------------------------
// MD5-HMAC correct answer 2
// ab795fec_c4579cf7_489e4a12_daf9f93d
//------------------------------------------------------------------
u32 u_Md5HmacCipherText47[]=
{
	0xec5f79ab,	0xf79c57c4,	0x124a9e48,	0x3df9f9da
};

const u32 u_Sha1CipherText_Inter[]=
{
	0x21f83e20,	0x362ae8ee,	0x38b8f219,	0x81fdc373,	0x1a56e095
	
};

const u32 u_Sha1CipherText_InterValue[]=
{
	0x579394FC,	0xB51EB631,	0x7944B91F,	0x1BEC6938,	0x303FE675
};

//----------------------------------------------------------
// plaintext used for testing advanced cases.
// 160 bytes = 40 words of random data
//----------------------------------------------------------
u32 uAdvCasePlainText[]=
{
	0x67f35e7f,	0x2276d952,	0x1198679b,	0x2d9d790f,
	0x44b89d81,	0x43aa843a,	0x9f6739ef,	0xcde24c69,
	0xba920036,	0x047bd48d,	0x65d2ddbd,	0x0450cebd,
	0x9deb3d67,	0x63845dd3,	0xe5111c18,	0xdc2eae4b,
    
	0x2540fb7b,	0x83b57508,	0x5293ebd6,	0x1ff48c95,
	0xd1792e31,	0x0030dafd,	0xdd9c7a68,	0x12f5aeb9,
	0xe9cb8af0,	0x06b30a52,	0x40107864,	0xa4c7adce,
	0x62b85cdc,	0xf2ab191f,	0xdc1bb7dd,	0x196605b9,
    
	0x56ac4ad5,	0x45fb7345,	0x6b1962e5,	0xc1d43261,
	0x893d6f68,	0x574d14d9,	0xff5d0bba,	0x8701f31e 

};

//// PKA
static u32 buf_a[64] = {
0x713ffc48,
0x6e3640c1,
0x8d360cc7,
0x2d5e0fca,
0xe4572093,
0xa8fd2bb9,
0xd2696c9c,
0xcccf8f56,
0xc6cc33ec,
0x005a73a9,
0x0781fd3f,
0x09db686f,
0x787226f1,
0xbf40db14,
0xa3f4e4fa,
0xbc73facf,
0xa5a7b7ad,
0x16aae889,
0xa49dc815,
0x229fdbd1,
0x5f25b571,
0x99d24fad,
0x4f272969,
0x16472219,
0xc5d35536,
0x877e6338,
0xf126af12,
0x0768aba2,
0x73758d3b,
0x7b8a36c5,
0x8dd45960,
0x7d3928f4,
0x410cb9de,
0x44ce673a,
0x80725589,
0xc3da3501,
0xa92e8ca2,
0x223f4fd0,
0x63bcafb9,
0x396aebf1,
0x8f0fcb90,
0xc75b4330,
0x3cc40683,
0x447c979d,
0x731619d8,
0x24fa1521,
0x971ecd89,
0xf0ff668c,
0x7da9f4c4,
0x15dbca8b,
0x1d11a0ff,
0x4615e5d3,
0xbfc3cf6e,
0xca1ada2e,
0x5dde793b,
0xaad9673b,
0x000473c6,
0xf7270a84,
0x743e55a4,
0x3bdca078,
0xe729c22f,
0x15dffc0b,
0xf8c46b1c,
0x93b82583
};

static u32 buf_b[64] = {
0x602902ac,
0x7b085900,
0x7ff5a67f,
0xef39366a,
0x9f164aea,
0x0b07cbc8,
0xca7a4a89,
0xbe3a8b05,
0xbb059940,
0xabcfc9c6,
0xa6e40deb,
0xa8e5fc2e,
0xc9081728,
0x7f9b9962,
0x35f95628,
0xf3a220af,
0xcc7a8e27,
0x99da1485,
0x28a0fae7,
0x9591be40,
0x01633e74,
0x0468080d,
0xafc39232,
0xec0a8d4e,
0x60396db6,
0x3a510597,
0x67993b05,
0xdf3a88c0,
0x5b55714a,
0xb9ec0e53,
0xcbf2d07c,
0x1d2824e0,
0x8165b65e,
0x78adc741,
0xd42acec2,
0xceaf4b0a,
0x6c762032,
0x2f0d9989,
0x4b275554,
0x3a7f0bd4,
0x1c119fa2,
0xd81cf83e,
0xfde0379e,
0x7678e1bb,
0xea0ffb91,
0x6ec39c02,
0xd05ab367,
0x9e54e66d,
0xfc54cc4f,
0xfa00b835,
0xece1aaf1,
0xf4cc64bf,
0x5e517be1,
0xac27cb5d,
0x5f1c9b0e,
0x287d7e43,
0x1ba49289,
0xacc4285a,
0xd43acf5c,
0x679f69aa,
0x80057c62,
0x35112c16,
0xeeb7621d,
0x3a5fbb79
};

static u32 buf_m[64] = {
0xe35f334e,
0xd6db2c87,
0x05ef00fd,
0xa3f8a40c,
0xc931987e,
0x22df83ca,
0x04638644,
0xcb5a749c,
0xb0a2902f,
0xd0dca5d7,
0xab8a1523,
0x7dc1f089,
0x089847d4,
0x8c3b62c8,
0x028e614d,
0xd5465243,
0x5835b7eb,
0xa6ef25cd,
0x5360cb1c,
0x835ef4f8,
0x9a176cc9,
0x93cf9789,
0x2eef726c,
0xd8c4d5b9,
0xa1fc157a,
0x37b5b318,
0x68f34739,
0x21a2b88d,
0x4e43fd0a,
0x27c7baba,
0xc185d8fd,
0x8a9a486c,
0x16506b24,
0x246a2f26,
0x1bdfe05d,
0xe48b1c40,
0xc556886d,
0x2699a61a,
0x3bd6343b,
0x5f5456b6,
0x72954ce7,
0xdf489c45,
0xad7905dd,
0xf6e570a9,
0x0d39a416,
0x248bf33d,
0x5e5186a4,
0xfbe41334,
0xb0f511e0,
0x114d87fa,
0x21ef5dcd,
0xc2402c70,
0x0dc49813,
0x6fff7702,
0xff7353c2,
0xaabe2f69,
0x478ab606,
0x608304ef,
0x60796e07,
0x97199525,
0xa514045a,
0x6c3dce7f,
0xb512a87d,
0x682d0851
};

static u32 buf_s[64];

static u32 gold_s[64] = {
0xdb46ddc6,
0xe07d8543,
0x89abbf93,
0x8aba0322,
0x6d07746e,
0xc1a64b7e,
0x9be674a8,
0x861ec977,
0x24c22f00,
0x9503d6a6,
0x7620743e,
0x80183296,
0xd003d3a5,
0xb771bcee,
0x14670240,
0x8af55694,
0x1463ea1f,
0xb1f8f37a,
0xef8b74fd,
0x76a876f6,
0xe9d173e4,
0x160d9d3e,
0xfd6d1d89,
0xf056e5be,
0x0a4f532a,
0xd09159a6,
0x9de24633,
0xe339ae09,
0x65a8d5d4,
0xf806d9bb,
0x681bd15d,
0x2d59a3a9,
0x1024aff3,
0x6f61337e,
0x84ed5866,
0x0968710d,
0xbcac33a0,
0xbc6622bd,
0x1baf403d,
0x9b7bff32,
0xed095b64,
0x77fbe81c,
0x699feb9f,
0xbd6b68e6,
0x61b2cf4c,
0x75f6df33,
0x51b216ea,
0xb581146d,
0xf62c0473,
0x5596bd54,
0x9e7ae3fe,
0x3911baf0,
0x0db7035b,
0x57352f5d,
0x3ac63911,
0xfa40cf50,
0x920c8bcf,
0x0ff8da2f,
0x450d1fad,
0x8bb653a6,
0x75cf1be5,
0xe352729d,
0x1201c9b7,
0xb6f22ac0
};


static u32 buf_a_128[4] = {
0xa1c579c5,
0x71899f06,
0x04e80c73,
0xa954c874
};

static u32 buf_b_128[4] = {
0x744642de,
0x0a3c773f,
0xf38d11fb,
0x9d8ef14d
};

static u32 buf_m_128[4] = {
0xc5b9235b,
0xdf3d7edc,
0x8e1fe09a,
0xf4f25f65
};

static u32 gold_s_128[4] = {
0x403c8f44,
0x6c623465,
0x44092e40,
0x2725eb28
};



const unsigned int p_A1_ctr[A1_sfr_cnt] = {
// 1'st vector
// PKA_SFR0: CHNK_SZ=0100(160b), PREC_ID=00(Single)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(0), B_SEG_ID=00001(1), M_SEG_ID=00010(2), S_SEG_ID=00011(3)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=10(64B), FUNC_ID=1
	0x00000020, 0x00000008, 0x00010203, 0x00000001, 0x00000041,

// 2'nd vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=00(Single)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(24), B_SEG_ID=00001(25), M_SEG_ID=00010(26), S_SEG_ID=00011(27)
// PKA_SFR3: A:positive , B:negative
// PKA_SFR4: SEG_SIZE=10(64B), FUNC_ID=1
	0x00000078, 0x00000008, 0x18191a1b, 0x02000000, 0x00000041,

// 3'rd vector
// PKA_SFR0: CHNK_SZ=0110(224b), PREC_ID=01(Double)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(5), B_SEG_ID=00001(6), M_SEG_ID=00010(7), S_SEG_ID=00011(8)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=1
	0x00000031, 0x00000008, 0x05060708, 0x00000020, 0x00000021,

// 4'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=01(Double)
// PKA_SFR1: PLDM_ON=1
// PKA_SFR2: A_SEG_ID=00000(10), B_SEG_ID=00001(11), M_SEG_ID=00010(12), S_SEG_ID=00011(13)
// PKA_SFR3: A:positive , B:positive
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=1
	0x00000079, 0x00000008, 0x0a0b0c0d, 0x00000000, 0x00000021, 

// 5'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=01(Double)
// PKA_SFR1: PLDM_ON=0
// PKA_SFR2: A_SEG_ID=00000(2), B_SEG_ID=00001(3), M_SEG_ID=00010(4), S_SEG_ID=00100(5)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=1
	0x00000079, 0x00000000, 0x02030405, 0x00000004, 0x00000021,

// 6'th vector
// PKA_SFR0: CHNK_SZ=1000(352b), PREC_ID=10(Triple)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(1), B_SEG_ID=00001(2), M_SEG_ID=00010(3), S_SEG_ID=00011(4)
// PKA_SFR3: A:positive , B:negative
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=1
	0x00000052, 0x00000008, 0x01020304, 0x00000004, 0x00000001,

// 7'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=10(Triple)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(0), B_SEG_ID=00001(1), M_SEG_ID=00010(2), S_SEG_ID=00011(3)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=1
	0x0000007a, 0x00000008, 0x00010203, 0x00000001, 0x00000001,

// 8'th vector
// PKA_SFR0: CHNK_SZ=1001(320b), PREC_ID=11(Quadruple)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(2), B_SEG_ID=00001(3), M_SEG_ID=00010(4), S_SEG_ID=00011(5)
// PKA_SFR3: A:negative , B:negative
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=1
	0x0000004b, 0x00000008, 0x02030405, 0x0000000c, 0x00000001,

// 9'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=11(Quadruple)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(4), B_SEG_ID=00001(5), M_SEG_ID=00010(1), S_SEG_ID=00011(2)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=1
	0x0000007b, 0x00000008, 0x04050102, 0x00000010, 0x00000001,

// 10'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=11(Quadruple)
// PKA_SFR1: PLDM_ON=0
// PKA_SFR2: A_SEG_ID=00000(5), B_SEG_ID=00001(0), M_SEG_ID=00010(1), S_SEG_ID=00011(3)
// PKA_SFR3: A:positive , B:negative
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=1
	0x0000007b, 0x00000000, 0x05000103, 0x00000001, 0x00000001
	};


static u32 p_A1_a[A1_data_cnt] = {	
//const unsigned int p_A1_a[A1_data_cnt] = {
// 1'st vector : key_size = 160-bit, CHNK_SZ = 160b, PREC_ID = Single
//    [MSB]					               [LSB]
	0xcb6b478c, 0xc0c716d3, 0xd6dae4e2,	0xc53c045a,
	0xc3280b65, 									// 5
	//0x1,0x2,0x3,0x4,0x5,
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0xac4a2e87, 0x87150987, 0x9fe20e1e, 0x184c3d14, 
	0x15c4d5d8, 0x40f57238, 0x53067269, 0x8fc72870, 
	0x0ebf3664, 0xf4d2e0c9, 0xecc699c2, 0x594225a2, 
	0x1d382216, 0x6fb87191, 0x44844401, 0x98279c65,	// 16 	

// 3'rd vector : key_size = 448-bit,  CHNK_SZ = 224b, PREC_ID = Double
	0x291710f3, 0x4f562506, 0xbf9258d8, 0x9f30e90c, 
	0xb96f89e4, 0x7b79c793, 0x3d0216e5, 0xa90954fc, 
 	0x39eaa29f, 0x774d1d3d, 0xac5fa454, 0x2f5c9b32, 
	0x6bcefc87, 0x49082817,							// 14 
	
// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xa74b9e1e, 0x3d254057, 0x3b0461db, 0xd438d47b, 
	0x44b9f02c, 0x71d9f178, 0xb50d55fc, 0xb1428826, 
	0xc2dba491, 0xe38ef638, 0x5ec198c1, 0xf2c27dc6, 
	0xb792e563, 0xa699caa1, 0x12f438b6, 0xa3b1bda3, 
	0x4c1ce19e, 0x0c58d1aa, 0xfefa92c5, 0x63a0f726,  
	0xe49b7276, 0xb457fea6, 0x70c525ac, 0x8cec0dd1, 
	0xb1527d13, 0x57332588, 0x5ef1e2eb, 0xbaed9fa2, 
	0x9990afbb, 0x0ef108a4, 0x0b045db8, 0x1fe797c7,	// 32

// 5'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0x58b461e1, 0xc2dabfa8, 0xc4fb9e24, 0x2bc72b84, 
	0xbb460fd3, 0x8e260e87, 0x4af2aa03, 0x4ebd77d9, 
	0x3d245b6e, 0x1c7109c7, 0xa13e673e, 0x0d3d8239, 
	0x486d1a9c, 0x5966355e, 0xed0bc749, 0x5c4e425c, 
	0xb3e31e61, 0xf3a72e55, 0x01056d3a, 0x9c5f08d9, 
	0x1b648d89, 0x4ba80159, 0x8f3ada53, 0x7313f22e, 
	0x4ead82ec, 0xa8ccda77, 0xa10e1d14, 0x4512605d, 
	0x666f5044, 0xf10ef75b, 0xf4fba247, 0xe0186839, // 32

// 6'th vector : key_size = 1056-bit,  CHNK_SZ = 352b, PREC_ID = Triple
	0x899eba3c, 0x3767fd9a, 0x437f9d26, 0x122e7948, 
	0xb03a6642, 0x962ed2e3, 0x491f27ea, 0x8081bda4, 
	0x748d7cc1, 0x3825f085, 0x0d7b86eb, 0xe16a4589, 
	0xc3e3448f, 0xe6f4b2a3, 0x8989336c, 0xe1d5c8d6, 
	0xf763f362, 0x3338f75e, 0xfe54973e, 0xe9891657, 
	0xd9eef378, 0x3af97384, 0xeb6ebcfa, 0x3514e8cb, 
	0xb7aff337, 0x54846ff1, 0x3b3c6be0, 0x6de3f24b, 
	0x058e1a84, 0xeab0740f, 0xee551eec, 0x23c3c52c,	// 33 
	0x259c0768, 

// 7'th vector : key_size = 1536-bit,  CHNK_SZ = 512b, PREC_ID = Triple
	0x6456d636, 0xc3a936c4, 0x53408744, 0xfa575f52, 
 	0xc9ab1872, 0xf5ecd7a6, 0x18104978, 0x52b41897, 
 	0xf461427f, 0xacb05f32, 0xce630401, 0xcb5200b7, 
 	0x52a46a92, 0xcd954c35, 0x98f818e2, 0xf05b642a, 
 	0xbf1eb3f0, 0xd0e198e9, 0xb625b358, 0x9510b342, 
 	0x53adfefa, 0x6c9c4b86, 0x14d833ac, 0x5834a23d, 
 	0x9e2c5790, 0x081c267f, 0x3f28aa46, 0xcbf21a9c, 
 	0x4fc6eabe, 0xbe1876b5, 0x8d2bc18c, 0x9ed49652, 
 	0x58254134, 0x686c6248, 0x5b55b466, 0x333c963c, 
 	0x8a449ff1, 0xfb13086a, 0x88819386, 0xbad7afb6, 
 	0x4cf80eb6, 0x807c1330, 0x5ae3fd42, 0x25bfd4ea, 
	0x0dd4f1e8, 0xb971dbbe, 0xdc757125, 0x114ec6af,	// 48  

// 8'th vector : key_size = 1280-bit,  CHNK_SZ = 320b, PREC_ID = Quadruple
	0x9992ccde, 0x0d554b69, 0x02feb463, 0x7d8d9865, 
    0x4db53482, 0x305f5134, 0x2fc57c13, 0x41d46747, 
    0xb56c0455, 0x32109b91, 0xc3530f98, 0x9fd9d631, 
    0x1ace8971, 0xc27d01d7, 0x5e515fcb, 0x1e617afa, 
    0x32c923e6, 0xad5bc530, 0x37b49cbf, 0x78ebf804, 
    0x642a3d61, 0x14e30e27, 0x39da04f5, 0x2abf961d, 
    0xded23066, 0x14617422, 0x2a1ccd14, 0x62f9ee99, 
    0x0c988de8, 0x2900ec35, 0xab1e212d, 0x77ede7cd, 
    0x0fc23cbc, 0x840eb627, 0x6b0aa947, 0x7f26ad64, 
    0x9cb76b8d, 0xd21ed47a, 0x055fcab3, 0x6454a409,	// 40 

// 9'th vector : key_size = 2048-bit,  CHNK_SZ = 512b, PREC_ID = Quadruple
	0x8ec003b7, 0x91c9bf3e, 0x72c9f338, 0xd2a1f035, 
 	0x1ba8df6c, 0x5702d446, 0x2d969363, 0x333070a9, 
 	0x3933cc13, 0xffa58c56, 0xf87e02c0, 0xf6249790, 
 	0x878dd90e, 0x40bf24eb, 0x5c0b1b05, 0x438c0530, 
 	0x5a584852, 0xe9551776, 0x5b6237ea, 0xdd60242e, 
	0xa0da4a8e, 0x662db052, 0xb0d8d696, 0xe9b8dde6, 
 	0x3a2caac9, 0x78819cc7, 0x0ed950ed, 0xf897545d, 
 	0x8c8a72c4, 0x8475c93a, 0x722ba69f, 0x82c6d70b, 
 	0xbef34621, 0xbb3198c5, 0x7f8daa76, 0x3c25cafe, 
 	0x56d1735d, 0xddc0b02f, 0x9c435046, 0xc695140e, 
 	0x70f0346f, 0x38a4bccf, 0xc33bf97c, 0xbb836862, 
 	0x8ce9e627, 0xdb05eade, 0x68e13276, 0x0f009973, 
 	0x82560b3b, 0xea243574, 0xe2ee5f00, 0xb9ea1a2c, 
 	0x403c3091, 0x35e525d1, 0xa22186c4, 0x552698c4, 
 	0xfffb8c39, 0x08d8f57b, 0x8bc1aa5b, 0xc4235f87, 
 	0x18d63dd0, 0xea2003f4, 0x073b94e3, 0x6c47da7d,	// 64 

// 10'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0x713ffc48, 0x6e3640c1, 0x8d360cc7, 0x2d5e0fca, 
 	0xe4572093, 0xa8fd2bb9, 0xd2696c9c, 0xcccf8f56, 
 	0xc6cc33ec, 0x005a73a9, 0x0781fd3f, 0x09db686f, 
 	0x787226f1, 0xbf40db14, 0xa3f4e4fa, 0xbc73facf, 
 	0xa5a7b7ad, 0x16aae889, 0xa49dc815, 0x229fdbd1, 
 	0x5f25b571, 0x99d24fad, 0x4f272969, 0x16472219, 
 	0xc5d35536, 0x877e6338, 0xf126af12, 0x0768aba2, 
 	0x73758d3b, 0x7b8a36c5, 0x8dd45960, 0x7d3928f4, 
 	0x410cb9de, 0x44ce673a, 0x80725589, 0xc3da3501, 
 	0xa92e8ca2, 0x223f4fd0, 0x63bcafb9, 0x396aebf1, 
 	0x8f0fcb90, 0xc75b4330, 0x3cc40683, 0x447c979d, 
 	0x731619d8, 0x24fa1521, 0x971ecd89, 0xf0ff668c, 
 	0x7da9f4c4, 0x15dbca8b, 0x1d11a0ff, 0x4615e5d3, 
 	0xbfc3cf6e, 0xca1ada2e, 0x5dde793b, 0xaad9673b, 
 	0x000473c6, 0xf7270a84, 0x743e55a4, 0x3bdca078, 
 	0xe729c22f, 0x15dffc0b, 0xf8c46b1c, 0x93b82583	// 64
	};

static u32	  p_A1_b[A1_data_cnt]= {
//const unsigned int p_A1_b[A1_data_cnt] = {
// 1'st vector : key_size = 160-bit, CHNK_SZ = 160b, PREC_ID = Single
//    [MSB]					               [LSB]
	0xb3edfd47,	0x08dedd17, 0xf7fc86b1,	0x41d1eb16,
	0xe7460a45,
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0xee9f6a47, 0x4a907e21, 0x8fdf751d, 0xcac6a770, 
	0x1d70d1e0, 0x22611a97, 0xdc545bd9, 0x8ea1eac1, 
	0xc378c388, 0x9ccd6f6c, 0x02fcb380, 0x3b5dde1d, 
	0x5f8ca04b, 0x8eb4545d, 0xd61430f9, 0x4f2efb00, 

// 3'rd vector : key_size = 448-bit,  CHNK_SZ = 224b, PREC_ID = Double
	0x1344bf55, 0xcb0845a1, 0x8c08be3c, 0x395789f1, 
 	0x82b3cd85, 0x1601110f, 0xdfa92a5c, 0xcd95e37f, 
 	0x4b0e7cbb, 0x165732af, 0x4214148f, 0x954fda87, 
 	0x8c2db8e9, 0xa6567044, 

// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xd20e166c, 0x678fe712, 0x6f297d57, 0xf8dac03a, 
	0x3766816c, 0x6eb89d1d, 0xaaf479c9, 0x6447b39d, 
	0x08273b18, 0x7635e154, 0x3c6fdf36, 0xc9bdc38d,  
	0xaaf4d407, 0x9abe5c3c, 0x377e32c3, 0xad5ebe7a, 
	0x3d126356, 0x82875a2b, 0x21e6f883, 0x66a4d57f, 
	0x8a7b4aab, 0x80b0c2a8, 0x20f858ff, 0xe882440a, 
	0xca3eda7c, 0xe06e228c, 0x703078ed, 0xf36ed004, 
	0x1476b420, 0xb62fc130, 0x0d9fbf2e, 0xb9527900, 

// 5'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xd20e166c, 0x678fe712, 0x6f297d57, 0xf8dac03a, 
	0x3766816c, 0x6eb89d1d, 0xaaf479c9, 0x6447b39d, 
	0x08273b18, 0x7635e154, 0x3c6fdf36, 0xc9bdc38d, 
	0xaaf4d407, 0x9abe5c3c, 0x377e32c3, 0xad5ebe7a, 
	0x3d126356, 0x82875a2b, 0x21e6f883, 0x66a4d57f, 
	0x8a7b4aab, 0x80b0c2a8, 0x20f858ff, 0xe882440a, 
	0xca3eda7c, 0xe06e228c, 0x703078ed, 0xf36ed004, 
	0x1476b420, 0xb62fc130, 0x0d9fbf2e, 0xb9527900, 

// 6'th vector : key_size = 1056-bit,  CHNK_SZ = 352b, PREC_ID = Triple
	0xea61cf3b, 0x30738687, 0xac2d7fe9, 0x3a50bd12,
	0x5dcf90b3, 0x627e34e1, 0x3d63d0d0, 0xfed4c00b, 
	0x0710bea4, 0xc249bc10, 0xb9965325, 0x711a8887, 
	0x853a6443, 0x9f5e9419, 0xfde7ecd4, 0x9036da98, 
	0x38e32339, 0xb4b4ccf6, 0xd8c03617, 0x1ccb8b4b, 
	0x4ffbe6e2, 0x1ed52f24, 0x502b8858, 0x1c8d7b79, 
	0x355b72a1, 0x1918c301, 0xa53d195d, 0xf75ed6f6, 
	0x806961d6, 0x5c190aee, 0x87b161de, 0xf0452016, 
	0xb29ea702, 

// 7'th vector : key_size = 1536-bit,  CHNK_SZ = 512b, PREC_ID = Triple
	0xaae2daa0, 0x478a01ec, 0x9da835f6, 0x4c6ad402, 
 	0x15604cdf, 0x892f67de, 0x352e9289, 0x7c1d44b7, 
 	0xd143ec79, 0xf422a4b6, 0x83e21e89, 0xb074e2e7, 
 	0x5372c4a8, 0x6baf0b8b, 0xbc0e41b7, 0x5436d601, 
 	0xe6e47128, 0x82646667, 0x0271f1c4, 0x69a23ca2, 
 	0x9f5583f5, 0x0f7019df, 0xf16d4451, 0x51c6e186, 
 	0x6cb52c69, 0x5417f187, 0x4d641fd2, 0x57b9a3e9, 
 	0x21ae686c, 0xb811fd44, 0xf0ad6170, 0xfa063a3e, 
 	0xa15d2b56, 0xd45d54e3, 0xd078ee52, 0x442e27f8, 
 	0x640e77ab, 0xa94d0c0e, 0xac04ef71, 0x81c59e59, 
 	0x5813aa75, 0x59a73ad0, 0x73cf6669, 0x822a4832, 
 	0x1e001307, 0x3be1401e, 0x29809fb6, 0xea665cba, 

// 8'th vector : key_size = 1280-bit,  CHNK_SZ = 320b, PREC_ID = Quadruple
	0x1b4e5304, 0x19916837, 0x9b9e440e, 0xcf0a5b35, 
	0x99d99ebd, 0xbbca095d, 0xcb99aa29, 0xa6db65e8, 
	0x401c178e, 0x27adfe10, 0xa8d45ec6, 0x2beee74a, 
	0x5a7f0855, 0xb8aebb99, 0x11224569, 0x06c92dc5, 
	0x4c0e043d, 0x5c2c00bb, 0xa5a92413, 0x148b2161, 
	0x950b3b34, 0xe32142f3, 0x2786a133, 0x6104af01, 
	0x72cd5913, 0x7ee90ac2, 0x416f97b0, 0xd595079b, 
	0xb1d4ac3e, 0xa39cd519, 0x8a7d82a8, 0x5dd29a35, 
	0x4d2ecb72, 0x3006ced1, 0x56e793a1, 0x313b7a97, 
	0xacf1c054, 0x5386d5f1, 0x5833b632, 0x5b485afe, 

// 9'th vector : key_size = 2048-bit,  CHNK_SZ = 512b, PREC_ID = Quadruple
	0x602902ac, 0x7b085900, 0x7ff5a67f, 0xef39366a, 
 	0x9f164aea, 0x0b07cbc8, 0xca7a4a89, 0xbe3a8b05, 
 	0xbb059940, 0xabcfc9c6, 0xa6e40deb, 0xa8e5fc2e, 
 	0xc9081728, 0x7f9b9962, 0x35f95628, 0xf3a220af, 
 	0xcc7a8e27, 0x99da1485, 0x28a0fae7, 0x9591be40, 
 	0x01633e74, 0x0468080d, 0xafc39232, 0xec0a8d4e, 
 	0x60396db6, 0x3a510597, 0x67993b05, 0xdf3a88c0, 
 	0x5b55714a, 0xb9ec0e53, 0xcbf2d07c, 0x1d2824e0, 
 	0x8165b65e, 0x78adc741, 0xd42acec2, 0xceaf4b0a, 
 	0x6c762032, 0x2f0d9989, 0x4b275554, 0x3a7f0bd4, 
 	0x1c119fa2, 0xd81cf83e, 0xfde0379e, 0x7678e1bb, 
 	0xea0ffb91, 0x6ec39c02, 0xd05ab367, 0x9e54e66d, 
 	0xfc54cc4f, 0xfa00b835, 0xece1aaf1, 0xf4cc64bf, 
 	0x5e517be1, 0xac27cb5d, 0x5f1c9b0e, 0x287d7e43, 
 	0x1ba49289, 0xacc4285a, 0xd43acf5c, 0x679f69aa, 
 	0x80057c62, 0x35112c16, 0xeeb7621d, 0x3a5fbb79, 

// 10'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0x9fd6fd53, 0x84f7a6ff, 0x800a5980, 0x10c6c995, 
 	0x60e9b515, 0xf4f83437, 0x3585b576, 0x41c574fa, 
 	0x44fa66bf, 0x54303639, 0x591bf214, 0x571a03d1, 
 	0x36f7e8d7, 0x8064669d, 0xca06a9d7, 0x0c5ddf50, 
 	0x338571d8, 0x6625eb7a, 0xd75f0518, 0x6a6e41bf, 
 	0xfe9cc18b, 0xfb97f7f2, 0x503c6dcd, 0x13f572b1, 
 	0x9fc69249, 0xc5aefa68, 0x9866c4fa, 0x20c5773f, 
 	0xa4aa8eb5, 0x4613f1ac, 0x340d2f83, 0xe2d7db1f, 
 	0x7e9a49a1, 0x875238be, 0x2bd5313d, 0x3150b4f5, 
 	0x9389dfcd, 0xd0f26676, 0xb4d8aaab, 0xc580f42b, 
 	0xe3ee605d, 0x27e307c1, 0x021fc861, 0x89871e44, 
 	0x15f0046e, 0x913c63fd, 0x2fa54c98, 0x61ab1992, 
 	0x03ab33b0, 0x05ff47ca, 0x131e550e, 0x0b339b40, 
 	0xa1ae841e, 0x53d834a2, 0xa0e364f1, 0xd78281bc, 
 	0xe45b6d76, 0x533bd7a5, 0x2bc530a3, 0x98609655, 
 	0x7ffa839d, 0xcaeed3e9, 0x11489de2, 0xc5a04487
	};

static u32 p_A1_m[A1_data_cnt] = {
//const unsigned int p_A1_m[A1_data_cnt] = {
// 1'st vector : key_size = 160-bit, CHNK_SZ = 160b, PREC_ID = Single
//    [MSB]					               [LSB]
	0xc31b3a47,	0xb26038bc, 0x152ccd6e,	0xa8d8665d,
	0x04a896e9, 
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0x92387229, 0xe688ccf2, 0xda4c55dc, 0xb1e37786, 
	0x2629193a, 0xd798a1de, 0x7902366a, 0xd457f1f7, 
	0x71b3d078, 0x70201abd, 0x2d19c4ba, 0xd355192d, 
	0x525ecca1, 0xc09c8c2d, 0x497b7f8f, 0xf1f21743,  

// 3'rd vector : key_size = 448-bit,  CHNK_SZ = 224b, PREC_ID = Double
	0xdee0a8ec, 0x84f5b9d0, 0x8311fa88, 0xa6255160, 
 	0xfffe005c, 0x347c7bd5, 0x1f5a32e9, 0xade1f52e, 
 	0xe1d529ef, 0x3f6209be, 0xb7b268db, 0xc4fd2447, 
 	0x8e368a34, 0x0c9da283, 

// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xdffff9bd, 0xf0370036, 0xaa3869f0, 0x25f303d5, 
	0x31c2515f, 0xbbdc4d71, 0x48d26067, 0xfc2d97ad, 
	0xa81fffa7, 0x4dfecb52, 0xb7a1bd97, 0xab626d9b, 
	0xa99e7c9a, 0xcd61c313, 0x9381cb9e, 0x6337e473, 
	0x7e799d80, 0x90d1d67d, 0xeebb4795, 0xdf34cbf3, 
	0x52a51d06, 0x32ce4856, 0x057e0223, 0x19bff3e2, 
	0xb7d8bea2, 0xa188fbf0, 0x77d907bb, 0xbd8b4db2, 
	0xa53adb36, 0x27e6d118, 0x52aa6396, 0xfd11cc21, 

// 5'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xdffff9bd, 0xf0370036, 0xaa3869f0, 0x25f303d5, 
	0x31c2515f, 0xbbdc4d71, 0x48d26067, 0xfc2d97ad, 
	0xa81fffa7, 0x4dfecb52, 0xb7a1bd97, 0xab626d9b, 
	0xa99e7c9a, 0xcd61c313, 0x9381cb9e, 0x6337e473, 
	0x7e799d80, 0x90d1d67d, 0xeebb4795, 0xdf34cbf3, 
	0x52a51d06, 0x32ce4856, 0x057e0223, 0x19bff3e2, 
	0xb7d8bea2, 0xa188fbf0, 0x77d907bb, 0xbd8b4db2, 
	0xa53adb36, 0x27e6d118, 0x52aa6396, 0xfd11cc21, 

// 6'th vector : key_size = 1056-bit,  CHNK_SZ = 352b, PREC_ID = Triple
	0xa302f1d3, 0xe178b8b6, 0xd5e47d74, 0x4934a1a0, 
	0xa90efc9d, 0x74fc0284, 0xf6b95bf3, 0xa9a9b3f7, 
	0xb81655dd, 0x98820f91, 0x901f4c3a, 0xf733234b, 
	0x0a0b31cd, 0x4b1449d5, 0x9d4a296d, 0xbb8b6c8e, 
	0xe54f2ead, 0x1b8fd649, 0x172d66c1, 0x2706d954, 
	0xd38764fc, 0x685bc00b, 0x4c260a5b, 0x4923fb11, 
	0x62ee88de, 0xf4046b26, 0xc8869610, 0x36a3c593, 
	0x0ec609d8, 0x2205257c, 0x1a96a5f3, 0x9898c24b, 
	0x57423327, 

// 7'th vector : key_size = 1536-bit,  CHNK_SZ = 512b, PREC_ID = Triple
	0xa8101969, 0x2e67292d, 0xdd9f900c, 0xf8f405f6, 
 	0xbd38c1a1, 0xb1406097, 0x956ccf0d, 0xb6782669, 
 	0x0331bc10, 0xa271e1cc, 0xe60185fe, 0x5fc448df, 
 	0xd55e2f4e, 0xc2b72353, 0xd4c6d444, 0x7e838733, 
 	0x38e9db12, 0x1b4a26a0, 0xc2d4d772, 0xe3a23be0, 
 	0x92bf8843, 0x1328c588, 0x8f99b9d7, 0x9da1075a, 
 	0x95b312ec, 0x36844398, 0x14fef6e3, 0x6bc57507, 
 	0xeea9dc64, 0x781d709f, 0x53145183, 0xf2bae4b2, 
 	0x4add0bbd, 0x7ddd9a4e, 0x36627191, 0x662a3969, 
 	0xa30e9e7f, 0xc075417d, 0x75a2f02e, 0x4d0570ad, 
 	0x18731c4d, 0x532b620f, 0x67819e29, 0x3a9f7bae, 
 	0x12e917c8, 0x4502af3c, 0x689b87bf, 0x86c9b581, 

// 8'th vector : key_size = 1280-bit,  CHNK_SZ = 320b, PREC_ID = Quadruple
	0xaaea3690, 0x0b2438ca, 0x6ffd10ee, 0x708a147e, 
    0xe9eea24e, 0x44ca37e6, 0x274b591b, 0x0c73f7e2, 
    0x94952c4d, 0x725717b5, 0x7ac03f50, 0xa538982d, 
    0xcb4cc962, 0x1c8a6711, 0x5670f1bf, 0x529f2b0d, 
    0xb865c149, 0xe183fe87, 0x9e58ea88, 0xd50039ce, 
    0xef601180, 0x88fa893c, 0x9063ab0d, 0x01f861dc, 
    0x63ae2557, 0x8612ddfb, 0xbf633932, 0x0682419a, 
    0xfcae1447, 0xa7914fd8, 0x0178145d, 0xe89d21ec, 
    0x035fe614, 0x4e8745d7, 0xea66cdaa, 0xe322cf58, 
    0xf4730df9, 0x3f1c787b, 0xc6dd3a58, 0x311267a1, 

// 9'th vector : key_size = 2048-bit,  CHNK_SZ = 512b, PREC_ID = Quadruple
	0xd666dab2, 0x46173c49, 0x833cfb97, 0x4bcf32a2, 
 	0xc8d08afa, 0x42b60afd, 0x3324386c, 0xddd2b0ff, 
 	0xb07e91f7, 0x21b05170, 0x5943525a, 0x556b6eb5, 
 	0x6f9162d0, 0x1882b9f7, 0x85347b74, 0x988124c9, 
 	0xdb52b36a, 0x668b2a03, 0x553e95b5, 0xdd387bcc, 
 	0x635e2052, 0xb5ea4817, 0x77b4a560, 0x27dfee48, 
 	0x21f9d054, 0x946b2ab2, 0x5ec92030, 0x1083ff7e, 
 	0xcd9d2ad3, 0x89015168, 0xfba9f8dd, 0xf03afca5, 
 	0xac1334fa, 0xce5dde14, 0x52538142, 0xeb86ee2a, 
 	0x379056ab, 0x7a0eada4, 0x77193336, 0xf7c4f64d, 
 	0x82373b86, 0x40020046, 0xb4dde316, 0x6a21210d, 
 	0x40f8e610, 0x8236dcfd, 0x4aa37df9, 0x34539a01, 
 	0x7c72f95d, 0x3c0152bb, 0x0dca6157, 0xf84d7af6, 
 	0xfd911183, 0x8128207f, 0x4324d8d1, 0x08a111cb, 
 	0x41e5e357, 0x3a07eb15, 0x9f09100c, 0x717fb09e, 
 	0xeeee723a, 0xdf1987e3, 0x5f84ed89, 0x9a6cc759, 

// 10'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0xd666dab2, 0x46173c49, 0x833cfb97, 0x4bcf32a2, 
 	0xc8d08afa, 0x42b60afd, 0x3324386c, 0xddd2b0ff, 
 	0xb07e91f7, 0x21b05170, 0x5943525a, 0x556b6eb5, 
 	0x6f9162d0, 0x1882b9f7, 0x85347b74, 0x988124c9, 
 	0xdb52b36a, 0x668b2a03, 0x553e95b5, 0xdd387bcc, 
 	0x635e2052, 0xb5ea4817, 0x77b4a560, 0x27dfee48, 
 	0x21f9d054, 0x946b2ab2, 0x5ec92030, 0x1083ff7e, 
 	0xcd9d2ad3, 0x89015168, 0xfba9f8dd, 0xf03afca5, 
 	0xac1334fa, 0xce5dde14, 0x52538142, 0xeb86ee2a, 
 	0x379056ab, 0x7a0eada4, 0x77193336, 0xf7c4f64d, 
 	0x82373b86, 0x40020046, 0xb4dde316, 0x6a21210d, 
 	0x40f8e610, 0x8236dcfd, 0x4aa37df9, 0x34539a01, 
 	0x7c72f95d, 0x3c0152bb, 0x0dca6157, 0xf84d7af6, 
 	0xfd911183, 0x8128207f, 0x4324d8d1, 0x08a111cb, 
 	0x41e5e357, 0x3a07eb15, 0x9f09100c, 0x717fb09e, 
 	0xeeee723a, 0xdf1987e3, 0x5f84ed89, 0x9a6cc759

	};

static u32  p_A1_s[A1_data_cnt] = {
//const unsigned int p_A1_s[A1_data_cnt] = {
// 1'st vector : key_size = 160-bit, CHNK_SZ = 160b, PREC_ID = Single (out_n_1_0_p.dat)
//    [MSB]					               [LSB]
	0x12425aa4, 0xe3a50d6c, 0x118f7856, 0x69539a60, 
    0x4dfc504b,  
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single (out_p_1_1_p.dat)
	0x2345bda3, 0x0211ca84, 0xd90df712, 0x6e8e717e, 
    0xe192314a, 0x8b6c0297, 0x65288068, 0xbdb6071e, 
    0xb8a7b700, 0x0ddb4549, 0x48c4b004, 0x7811e48e, 
    0x26887f0b, 0xad27fb2f, 0xd1a8bc74, 0x00feba2b, 

// 3'rd vector : key_size = 448-bit,  CHNK_SZ = 224b, PREC_ID = Double (out_n_1_1_p.dat)
	0x90d06bef, 0x55d077d2, 0xeabf87c5, 0x9b03344c, 
    0x86552e58, 0x71ae42b5, 0x00870ca8, 0xf1e201a9, 
    0x0136d823, 0x2b0d9463, 0x1788adcb, 0x304f0081, 
    0x28827514, 0x3edcee06, 

// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double (out_p_1_0_p.dat)
	0xd7ee8bf2, 0xcab32965, 0x0653388e, 0x4c7c1b93, 
    0x53055e08, 0xa00d7022, 0x87a7fcc8, 0x8db6d680, 
    0xcd7cd188, 0x0c5a6506, 0xefae59fd, 0x6a2483f3, 
    0x9b1c7efe, 0xb68de8aa, 0x084a35d0, 0x8aa82a57, 
    0x6af91c5c, 0x98fd7d47, 0xf49397cd, 0xea8c8b51, 
    0x3a305788, 0x33cf20d2, 0x4171ebc2, 0xbf01352b, 
    0x60425394, 0xd1d4d2fd, 0x004721bc, 0x81c9c677, 
    0xdbdb79d7, 0xe0747301, 0x71b2002b, 0xc0c70dd6, 

// 5'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double "pre-loading = NO" (out_n_1_0_p.dat)
	0x08116dcb, 0x2583d6d1, 0xa3e53161, 0xd976e841, 
    0xdebcf357, 0x1bcedd4e, 0xc12a639f, 0x6e76c12c, 
    0xdaa32e1f, 0x41a4664b, 0xc7f3639a, 0x413de9a8, 
    0x0e81fd9c, 0x16d3da69, 0x8b3795cd, 0xd88fba1c, 
    0x13808123, 0xf7d45935, 0xfa27afc7, 0xf4a840a2, 
    0x1874c57d, 0xfeff2783, 0xc40c1660, 0x5abebeb7, 
    0x57966b0d, 0xcfb428f3, 0x7791e5ff, 0x3bc1873a, 
    0xc95f615e, 0x47725e16, 0xe0f8636b, 0x3c4abe4b, 

// 6'th vector : key_size = 1056-bit,  CHNK_SZ = 352b, PREC_ID = Triple (out_p_1_1_p.dat)
	0x19ad1266, 0xd7f19242, 0x3ccec91a, 0x83d3bb25, 
    0xfad70dee, 0xfffb58c3, 0x95b44e84, 0x4755cb99, 
    0x4a176862, 0xc280bb36, 0xa1f686e6, 0xe6eb9625, 
    0x6045b0c8, 0x493e39c6, 0x9a26319a, 0xe7e649d7, 
    0x13e684a2, 0xc508becd, 0x625b732e, 0xcc87e2ed, 
    0xfade409a, 0xf93f5d45, 0x028cbfc9, 0x75f31cde, 
    0x5cbd68b5, 0x01ce6759, 0x570ca932, 0x3d5e98cf, 
    0x01867356, 0x110d2c41, 0xaf079664, 0xe1d0662c, 
    0x8860d3cc, 

// 7'th vector : key_size = 1536-bit,  CHNK_SZ = 512b, PREC_ID = Triple (out_n_1_0_p.dat)
	0x6e28d7d9, 0x68034d4a, 0x6826dc40, 0x31ff083e, 
    0xfa0472ff, 0x13b08b3c, 0x1a92db11, 0x1eda3389, 
    0x06ac8a00, 0x6d25751b, 0x26cb72a8, 0x49a7cf5b, 
    0x6898341e, 0x5fcbe66b, 0xb8d61eb5, 0x7d05d0b8, 
    0x8c3bac19, 0x61a5c43b, 0x85e951ad, 0x9a773489, 
    0x7864066f, 0x79589341, 0x749e99d1, 0x5b082840, 
    0x3ea874ae, 0x050bae41, 0x8afc746d, 0x7afbcd32, 
    0x29142a0d, 0xcd7e062d, 0xae1182d1, 0xda7dcc9a, 
    0x884364ed, 0x3fdd2d8e, 0x1ae3cba1, 0x3643b6eb, 
    0x22e160a4, 0x90e10111, 0x6c59f8d6, 0x89effeb7, 
    0x0aaf52be, 0x49275ec7, 0xb3c09d35, 0xba86bbb2, 
    0xe8295401, 0x05ef54f6, 0xf7542416, 0x197f8a25, 

// 8'th vector : key_size = 1280-bit,  CHNK_SZ = 320b, PREC_ID = Quadruple (out_n_1_0_p.dat)
	0xaa03b160, 0x4b71f7e0, 0xeb9d7885, 0x60a4894a, 
    0xd90e0d10, 0x65e21850, 0x05302335, 0xe52e6c78, 
    0xf6236482, 0x7c5e471d, 0xb2aa49ab, 0x12e50450, 
    0xd7fc638c, 0x60407cb0, 0x84ba45ca, 0x20d1ed5f, 
    0x122640c6, 0x98fbe559, 0x9ed9b816, 0x52ab668b, 
    0x579f2c27, 0xf973393a, 0x6c2354e0, 0x23b4e8f5, 
    0xccaae88e, 0x51a1895f, 0x5ef3590f, 0x4aa8b5db, 
    0x8a6f4e94, 0xfff0f1be, 0xf29a18bb, 0xb19ee2ea, 
    0xf5b4f775, 0x2a91633b, 0xbfb0a3dc, 0xdc35cf0a, 
    0x763a1d4c, 0xdc1e1ad1, 0xa5ba1a9d, 0x94b2cf0f, 

// 9'th vector : key_size = 2048-bit,  CHNK_SZ = 512b, PREC_ID = Quadruple (out_n_1_1_p.dat)
	0x7a789a85, 0xffc16630, 0x8c9f95fe, 0x2682dcc9, 
    0xbce51a30, 0x3c5b33e2, 0x1508cc65, 0xd6249af8, 
    0x7bc7a963, 0xef68993b, 0x9ea76337, 0x5ffac5ce, 
    0x25662c8d, 0x8a03d3b4, 0xb66714d9, 0xf4d77a24, 
    0xc4219105, 0xe117102c, 0x92d2a46a, 0xecd049a0, 
    0x5087d042, 0xfec74732, 0xb088ed88, 0xaa02eccc, 
    0x545c24f0, 0x917a0914, 0x5bb1c05b, 0x3730b7ef, 
    0x373b9069, 0xc01ce25a, 0xd9f431f9, 0x4fca5e76, 
    0xe82e3370, 0x7e496e91, 0xd010aa50, 0xf42024a1, 
    0xf71d3a45, 0x9a7f62d0, 0x49ee1710, 0x278499b9, 
    0x5a1904db, 0x01c6383f, 0xdd54e2cb, 0xc70daa97, 
    0xe15f55ce, 0x5118e1dd, 0xa7f272bb, 0x4f1c0a39, 
    0x03ccb678, 0x53d6edad, 0x11030fa4, 0xa47c0286, 
    0x4bc2649e, 0x04c8b849, 0xb0e29b63, 0x6ee65347, 
    0xbdb56f7c, 0x1695f696, 0xf2bfb897, 0xecc99430, 
    0x22669e9d, 0xbf228c3a, 0xc30dd0d2, 0x75cee7f2, 

// 10'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple "pre-loading = NO" (out_p_1_1_p.dat)
	0x5bee402c, 0x4655d618, 0xf69d6599, 0x254c55d9, 
    0x0beb70ca, 0x065ad71b, 0x1e1b6c07, 0x07ae1607, 
    0x34b6e893, 0x3247b834, 0xba9bef22, 0xf570a8e7, 
    0x4a2b3642, 0x8e7ee642, 0xcecd669a, 0xa3a9aaa5, 
    0x17312264, 0x857419d6, 0xc26bf14a, 0xf068322c, 
    0x12d6500f, 0xb72300e4, 0xc72bb7d7, 0x7ddd017b, 
    0xcd9dab64, 0x02f1219e, 0x03175fd4, 0xd953478f, 
    0x96619a69, 0xc8e46f0e, 0x21b5c6e4, 0xa0709e2e, 
    0xc3e5018a, 0x50146f82, 0x8242d6f1, 0xf766c988, 
    0x40731c65, 0xdf8f4ad4, 0x2d2b1c26, 0xd0405c94, 
    0x281e36ab, 0x3e3bc806, 0xd789004a, 0xa3137675, 
    0x5f999042, 0x311dfb1f, 0xa2b10b3d, 0xe5378fc8, 
    0x78a642e4, 0xe82a650d, 0xfcc751b3, 0x53d17870, 
    0xb1ceace5, 0x7c5f6835, 0x92423d6d, 0x99babe83, 
    0x843073db, 0x2371f47e, 0xac495774, 0x84b61c6e, 
    0xcc87d39d, 0x1ff6fba8, 0x9c771cb7, 0x249ddf67
	};

const u32 p_AB_a[AB_data_cnt] = {
//const unsigned int p_AB_a[AB_data_cnt] = {
// 1'st vector : key_size = 128-bit, CHNK_SZ = 128b, PREC_ID = Single
//    [MSB]					               [LSB]
	0xa1c579c5, 0x71899f06, 0x04e80c73, 0xa954c874, // 4
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0x53b5d178, 0x78eaf678, 0x601df1e1, 0xe7b3c2eb,
	0xea3b2a27, 0xbf0a8dc7, 0xacf98d96, 0x7038d78f,
	0xf140c99b, 0x0b2d1f36,	0x1339663d, 0xa6bdda5d,
	0xe2c7dde9, 0x90478e6e, 0xbb7bbbfe, 0x67d8639b,	// 16

// 3'rd vector : key_size = 832-bit,  CHNK_SZ = 416b, PREC_ID = Double
	0x17bd7763, 0x7d63d83a, 0xc1e0111d, 0xdbadb710,
	0x4770ade0, 0x96947a7e, 0x47333786, 0xd9ba689d,
	0x9ac4a182, 0xf1f22fe3, 0x1440325e, 0x1f32fe57,
	0xe68a3687, 0x48c4a07f, 0x87aceb43, 0x24687bf3,
	0x856d9d22, 0x1fd685b4, 0x950ab0d6, 0x6727a68c,
	0x84cc3109, 0xae1a03c2, 0x3043583d, 0x6d5e15e9,
	0x0211c7f3, 0x7f0d84d2,							// 26

// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xa74b9e1e, 0x3d254057, 0x3b0461db, 0xd438d47b,
	0x44b9f02c, 0x71d9f178, 0xb50d55fc, 0xb1428826,
	0xc2dba491, 0xe38ef638, 0x5ec198c1, 0xf2c27dc6,
	0xb792e563, 0xa699caa1, 0x12f438b6, 0xa3b1bda3,
	0x4c1ce19e, 0x0c58d1aa, 0xfefa92c5, 0x63a0f726,
	0xe49b7276, 0xb457fea6, 0x70c525ac, 0x8cec0dd1, 
	0xb1527d13, 0x57332588, 0x5ef1e2eb, 0xbaed9fa2,
	0x9990afbb, 0x0ef108a4, 0x0b045db8, 0x1fe797c7, // 32

// 5'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xa74b9e1e, 0x3d254057, 0x3b0461db, 0xd438d47b, 
	0x44b9f02c, 0x71d9f178, 0xb50d55fc, 0xb1428826,
	0xc2dba491, 0xe38ef638, 0x5ec198c1, 0xf2c27dc6,
	0xb792e563, 0xa699caa1, 0x12f438b6, 0xa3b1bda3,
	0x4c1ce19e, 0x0c58d1aa, 0xfefa92c5, 0x63a0f726,
	0xe49b7276, 0xb457fea6, 0x70c525ac, 0x8cec0dd1,
	0xb1527d13, 0x57332588, 0x5ef1e2eb, 0xbaed9fa2,
	0x9990afbb, 0x0ef108a4, 0x0b045db8, 0x1fe797c7, // 32

// 6'th vector : key_size = 864-bit,  CHNK_SZ = 288b, PREC_ID = Triple
	0x1427d33d, 0x27b2dfe5, 0xf6b1ca8b, 0x940c7c6c,
	0x47d11e04, 0x7d9407bc, 0x16039511, 0x4da54030,
	0x986ffe0e, 0xff28137f, 0xa537c5d1, 0xc2032321,
	0x91ffa586, 0x5752f07c, 0x6c3d4cc9, 0xb0553380,
	0x2e47bb53, 0x98a8841a, 0x8c7e4e57, 0x9350c3d9,
	0x6c798462, 0x3c6af5f4, 0xfed345f3, 0x3e482812, 
	0x605e3271, 0x76aa44b9, 0x59257fb7,				// 27

// 7'th vector : key_size = 1536-bit, CHNK_SZ = 512b, PREC_ID = Triple
	0x9ba929c9, 0x3c56c93b, 0xacbf78bb, 0x05a8a0ad,
 	0x3654e78d, 0x0a132859, 0xe7efb687, 0xad4be768,
 	0x0b9ebd80, 0x534fa0cd, 0x319cfbfe, 0x34adff48,
 	0xad5b956d, 0x326ab3ca, 0x6707e71d, 0x0fa49bd5,
 	0x40e14c0f, 0x2f1e6716, 0x49da4ca7, 0x6aef4cbd,
 	0xac520105, 0x9363b479, 0xeb27cc53, 0xa7cb5dc2,
 	0x61d3a86f, 0xf7e3d980, 0xc0d755b9, 0x340de563,
 	0xb0391541, 0x41e7894a, 0x72d43e73, 0x612b69ad,
 	0xa7dabecb, 0x97939db7, 0xa4aa4b99, 0xccc369c3,
 	0x75bb600e, 0x04ecf795, 0x777e6c79, 0x45285049,
 	0xb307f149, 0x7f83eccf, 0xa51c02bd, 0xda402b15,
	0xf22b0e17, 0x468e2441, 0x238a8eda, 0xeeb13951,	// 48

// 8'th vector : key_size = 1408-bit,  CHNK_SZ = 352b, PREC_ID = Quadruple
	0xab8ab107, 0xe712a8f8, 0x87b31505, 0xc13efa33,
	0x403870ef, 0x498a8382, 0x93b5b1d2, 0xf3a0f19a,
	0x5149d498, 0x6f993dcf, 0x9c8c6c29, 0x70670a37,
	0x529b8439, 0x156a8bf4, 0xd020725e, 0xcc0455d9,
	0x9d4f0c49, 0x46c127ea, 0xa7631029, 0x3a710ec9, 
	0x43bbc438, 0xc5adb6df, 0xb002c2a6, 0x395ffb02,
	0xca646546, 0x8ac6dc0c, 0x3d7d0fa3, 0x0a200ddb,
	0x5bd30389, 0x7d907209, 0x659d2e71, 0x86908708,
	0xa4cd2224, 0x57219bae, 0xe5f12a41, 0x84101b3e,
	0x5430efdb, 0xd6132825, 0xd7677ba6, 0x56bfaef0,
	0xad0a950a, 0xdba2d07a, 0xb3ef6776, 0xeb4f4f58,	// 44

// 9'th vector : key_size = 2048-bit,  CHNK_SZ = 512b, PREC_ID = Quadruple
	0x8ec003b7, 0x91c9bf3e, 0x72c9f338, 0xd2a1f035,
 	0x1ba8df6c, 0x5702d446, 0x2d969363, 0x333070a9,
 	0x3933cc13, 0xffa58c56, 0xf87e02c0, 0xf6249790,
 	0x878dd90e, 0x40bf24eb, 0x5c0b1b05, 0x438c0530,
 	0x5a584852, 0xe9551776, 0x5b6237ea, 0xdd60242e,
	0xa0da4a8e, 0x662db052, 0xb0d8d696, 0xe9b8dde6,
 	0x3a2caac9, 0x78819cc7, 0x0ed950ed, 0xf897545d,
 	0x8c8a72c4, 0x8475c93a, 0x722ba69f, 0x82c6d70b,
 	0xbef34621, 0xbb3198c5, 0x7f8daa76, 0x3c25cafe,
 	0x56d1735d, 0xddc0b02f, 0x9c435046, 0xc695140e,
 	0x70f0346f, 0x38a4bccf, 0xc33bf97c, 0xbb836862,
 	0x8ce9e627, 0xdb05eade, 0x68e13276, 0x0f009973,
 	0x82560b3b, 0xea243574, 0xe2ee5f00, 0xb9ea1a2c,
 	0x403c3091, 0x35e525d1, 0xa22186c4, 0x552698c4,
 	0xfffb8c39, 0x08d8f57b, 0x8bc1aa5b, 0xc4235f87,
 	0x18d63dd0, 0xea2003f4, 0x073b94e3, 0x6c47da7d,	// 64

// 10'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0x713ffc48, 0x6e3640c1, 0x8d360cc7, 0x2d5e0fca,
 	0xe4572093, 0xa8fd2bb9, 0xd2696c9c, 0xcccf8f56,
 	0xc6cc33ec, 0x005a73a9, 0x0781fd3f, 0x09db686f,
 	0x787226f1, 0xbf40db14, 0xa3f4e4fa, 0xbc73facf,
 	0xa5a7b7ad, 0x16aae889, 0xa49dc815, 0x229fdbd1,
 	0x5f25b571, 0x99d24fad, 0x4f272969, 0x16472219,
 	0xc5d35536, 0x877e6338, 0xf126af12, 0x0768aba2,
 	0x73758d3b, 0x7b8a36c5, 0x8dd45960, 0x7d3928f4,
 	0x410cb9de, 0x44ce673a, 0x80725589, 0xc3da3501,
 	0xa92e8ca2, 0x223f4fd0, 0x63bcafb9, 0x396aebf1,
 	0x8f0fcb90, 0xc75b4330, 0x3cc40683, 0x447c979d,
 	0x731619d8, 0x24fa1521, 0x971ecd89, 0xf0ff668c,
 	0x7da9f4c4, 0x15dbca8b, 0x1d11a0ff, 0x4615e5d3,
 	0xbfc3cf6e, 0xca1ada2e, 0x5dde793b, 0xaad9673b,
 	0x000473c6, 0xf7270a84, 0x743e55a4, 0x3bdca078,
 	0xe729c22f, 0x15dffc0b, 0xf8c46b1c, 0x93b82583	// 64
	};


const u32 p_AB_b[AB_data_cnt] = {
//const unsigned int p_AB_b[AB_data_cnt] = {
// 1'st vector : key_size = 128-bit, CHNK_SZ = 128b, PREC_ID = Single
//    [MSB]					               [LSB]
	0x744642de, 0x0a3c773f, 0xf38d11fb, 0x9d8ef14d, 
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0xee9f6a47, 0x4a907e21, 0x8fdf751d, 0xcac6a770,
	0x1d70d1e0, 0x22611a97, 0xdc545bd9, 0x8ea1eac1,
	0xc378c388, 0x9ccd6f6c, 0x02fcb380, 0x3b5dde1d,
	0x5f8ca04b, 0x8eb4545d, 0xd61430f9, 0x4f2efb00,	

// 3'rd vector : key_size = 832-bit,  CHNK_SZ = 416b, PREC_ID = Double
	0x12b25eb2, 0x17d1cd55, 0xa5d9daf7, 0xc60536ae,
	0x24c94ccb, 0x914457d3, 0xad9e5a4b, 0x1d864dec,
	0xd04b84e7, 0x71e6b3c1, 0x001e9dfb, 0xec9ce401,
	0x796ff842, 0x354ff419, 0xdd887d68, 0x196f3f3a,
	0xf28c1f18, 0x5acc54a9, 0x7be53b2c, 0xa68c4ed9,
	0x921a57ad, 0x13f00f4d, 0x2b692b46, 0x426e9a7f,
	0x01c0d596, 0xe8fb4c1a,

// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xd20e166c, 0x678fe712, 0x6f297d57, 0xf8dac03a,
	0x3766816c, 0x6eb89d1d, 0xaaf479c9, 0x6447b39d, 
	0x08273b18, 0x7635e154, 0x3c6fdf36, 0xc9bdc38d, 
	0xaaf4d407, 0x9abe5c3c, 0x377e32c3, 0xad5ebe7a, 
	0x3d126356, 0x82875a2b, 0x21e6f883, 0x66a4d57f, 
	0x8a7b4aab, 0x80b0c2a8, 0x20f858ff, 0xe882440a, 
	0xca3eda7c, 0xe06e228c, 0x703078ed, 0xf36ed004, 
	0x1476b420, 0xb62fc130, 0x0d9fbf2e, 0xb9527900, 

// 5'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xd20e166c, 0x678fe712, 0x6f297d57, 0xf8dac03a, 
	0x3766816c, 0x6eb89d1d, 0xaaf479c9, 0x6447b39d, 
	0x08273b18, 0x7635e154, 0x3c6fdf36, 0xc9bdc38d, 
	0xaaf4d407, 0x9abe5c3c, 0x377e32c3, 0xad5ebe7a, 
	0x3d126356, 0x82875a2b, 0x21e6f883, 0x66a4d57f, 
	0x8a7b4aab, 0x80b0c2a8, 0x20f858ff, 0xe882440a, 
	0xca3eda7c, 0xe06e228c, 0x703078ed, 0xf36ed004, 
	0x1476b420, 0xb62fc130, 0x0d9fbf2e, 0xb9527900, 

// 6'th vector : key_size = 864-bit,  CHNK_SZ = 288b, PREC_ID = Triple
	0x72b6403e, 0x4cec0e31, 0x23b4e67e, 0x5c08dd80, 
 	0x58b1dbc2, 0xffc8bcfa, 0x450ddbbe, 0x174df1c3, 
 	0x3d37c01d, 0x7262955a, 0xf5f54ac6, 0x40c6fcf7, 
 	0x2f875151, 0xd2acd466, 0x55fac8d1, 0x309584b8, 
 	0x22d06c77, 0x43683f30, 0xd4bb978a, 0xaaa5aa9d, 
 	0x289ca972, 0x610e5749, 0x73305c3a, 0x2c10b00b, 
 	0xc159d063, 0x2018b09e, 0x2fa027e8,

// 7'th vector : key_size = 1536-bit, CHNK_SZ = 512b, PREC_ID = Triple
	0xaae2daa0, 0x478a01ec, 0x9da835f6, 0x4c6ad402, 
 	0x15604cdf, 0x892f67de, 0x352e9289, 0x7c1d44b7, 
 	0xd143ec79, 0xf422a4b6, 0x83e21e89, 0xb074e2e7, 
 	0x5372c4a8, 0x6baf0b8b, 0xbc0e41b7, 0x5436d601, 
 	0xe6e47128, 0x82646667, 0x0271f1c4, 0x69a23ca2,  
 	0x9f5583f5, 0x0f7019df, 0xf16d4451, 0x51c6e186, 
 	0x6cb52c69, 0x5417f187, 0x4d641fd2, 0x57b9a3e9, 
 	0x21ae686c, 0xb811fd44, 0xf0ad6170, 0xfa063a3e, 
 	0xa15d2b56, 0xd45d54e3, 0xd078ee52, 0x442e27f8, 
 	0x640e77ab, 0xa94d0c0e, 0xac04ef71, 0x81c59e59, 
 	0x5813aa75, 0x59a73ad0, 0x73cf6669, 0x822a4832, 
 	0x1e001307, 0x3be1401e, 0x29809fb6, 0xea665cba, 

// 8'th vector : key_size = 1408-bit,  CHNK_SZ = 352b, PREC_ID = Quadruple
	0x5ca61feb, 0x22ee3d1d, 0xaa957e0d, 0x56cc808b, 
 	0x077dbd6c, 0xa8ca0892, 0x35dfb144, 0x3f43628d, 
 	0x83702dca, 0x1db02e99, 0x74c9fb25, 0x0ef6428f, 
 	0x61fbc7cf, 0x43da800c, 0x5ee991b7, 0x6df86483, 
 	0x2c250340, 0x59b43ce3, 0xf19887e9, 0x55a9bd4a, 
 	0x23151977, 0xb6e1e367, 0x49ed9f96, 0x4a8ae804, 
 	0xf6cb6840, 0x247defb6, 0x3988caa9, 0x2780c7ac, 
 	0x84d59f6d, 0xf8774862, 0xbcf8637c, 0xf349e7cf, 
 	0xc891322b, 0x702cb889, 0x8fa7df04, 0x884baf6e, 
 	0x1e192c19, 0xebd80868, 0x5c8a7188, 0xb22a8313, 
 	0xc62d08da, 0xf1d717e3, 0x9b08af9d, 0x850ba186, 

// 9'th vector : key_size = 2048-bit,  CHNK_SZ = 512b, PREC_ID = Quadruple
	0x602902ac, 0x7b085900, 0x7ff5a67f, 0xef39366a, 
 	0x9f164aea, 0x0b07cbc8, 0xca7a4a89, 0xbe3a8b05, 
 	0xbb059940, 0xabcfc9c6, 0xa6e40deb, 0xa8e5fc2e, 
 	0xc9081728, 0x7f9b9962, 0x35f95628, 0xf3a220af, 
 	0xcc7a8e27, 0x99da1485, 0x28a0fae7, 0x9591be40, 
 	0x01633e74, 0x0468080d, 0xafc39232, 0xec0a8d4e, 
 	0x60396db6, 0x3a510597, 0x67993b05, 0xdf3a88c0, 
 	0x5b55714a, 0xb9ec0e53, 0xcbf2d07c, 0x1d2824e0, 
 	0x8165b65e, 0x78adc741, 0xd42acec2, 0xceaf4b0a, 
 	0x6c762032, 0x2f0d9989, 0x4b275554, 0x3a7f0bd4, 
 	0x1c119fa2, 0xd81cf83e, 0xfde0379e, 0x7678e1bb, 
 	0xea0ffb91, 0x6ec39c02, 0xd05ab367, 0x9e54e66d, 
 	0xfc54cc4f, 0xfa00b835, 0xece1aaf1, 0xf4cc64bf, 
 	0x5e517be1, 0xac27cb5d, 0x5f1c9b0e, 0x287d7e43, 
 	0x1ba49289, 0xacc4285a, 0xd43acf5c, 0x679f69aa, 
 	0x80057c62, 0x35112c16, 0xeeb7621d, 0x3a5fbb79, 

// 10'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0x9fd6fd53, 0x84f7a6ff, 0x800a5980, 0x10c6c995, 
 	0x60e9b515, 0xf4f83437, 0x3585b576, 0x41c574fa, 
 	0x44fa66bf, 0x54303639, 0x591bf214, 0x571a03d1, 
 	0x36f7e8d7, 0x8064669d, 0xca06a9d7, 0x0c5ddf50, 
 	0x338571d8, 0x6625eb7a, 0xd75f0518, 0x6a6e41bf, 
 	0xfe9cc18b, 0xfb97f7f2, 0x503c6dcd, 0x13f572b1, 
 	0x9fc69249, 0xc5aefa68, 0x9866c4fa, 0x20c5773f, 
 	0xa4aa8eb5, 0x4613f1ac, 0x340d2f83, 0xe2d7db1f, 
 	0x7e9a49a1, 0x875238be, 0x2bd5313d, 0x3150b4f5, 
 	0x9389dfcd, 0xd0f26676, 0xb4d8aaab, 0xc580f42b, 
 	0xe3ee605d, 0x27e307c1, 0x021fc861, 0x89871e44, 
 	0x15f0046e, 0x913c63fd, 0x2fa54c98, 0x61ab1992, 
 	0x03ab33b0, 0x05ff47ca, 0x131e550e, 0x0b339b40, 
 	0xa1ae841e, 0x53d834a2, 0xa0e364f1, 0xd78281bc, 
 	0xe45b6d76, 0x533bd7a5, 0x2bc530a3, 0x98609655, 
 	0x7ffa839d, 0xcaeed3e9, 0x11489de2, 0xc5a04487
	};

const u32 p_AB_m[AB_data_cnt] = {
//const unsigned int p_AB_m[AB_data_cnt] = {
// 1'st vector : key_size = 128-bit, CHNK_SZ = 128b, PREC_ID = Single
//    [MSB]					               [LSB]
	0xc5b9235b, 0xdf3d7edc, 0x8e1fe09a, 0xf4f25f65, 
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0xddd71492, 0x9a74278c, 0x91f2f467, 0x5dd6c410, 
	0x49f192b6, 0xe1650565, 0x76297701, 0x5504a06c, 
	0x242f643b, 0xf38b34e9, 0x0752b3c5, 0xb9f2c663, 
	0x4e486cfa, 0xdd92a482, 0x85dd6d6f, 0x710ff529, 

// 3'rd vector : key_size = 832-bit,  CHNK_SZ = 416b, PREC_ID = Double
	0xc7158aa3, 0x861590a7, 0xbd6dd695, 0xec9efb52, 
 	0x7e415fc4, 0xf0717363, 0xe9e7c7b6, 0xc7eb8b81, 
 	0x2dd69479, 0xca59ec41, 0x4868455b, 0x8e7b8eea, 
 	0x3a51c6f5, 0x24c0a190, 0xb6097acc, 0x2c5ed2a2, 
 	0x6d94ac20, 0x59688071, 0xbe56d93f, 0x3ea2e7b0, 
 	0x6d3224bb, 0x3d2184dd, 0x7ecd192c, 0x9257d1eb, 
 	0xfa20caa3, 0x92883eef, 

// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xdffff9bd, 0xf0370036, 0xaa3869f0, 0x25f303d5, 
	0x31c2515f, 0xbbdc4d71, 0x48d26067, 0xfc2d97ad, 
	0xa81fffa7, 0x4dfecb52, 0xb7a1bd97, 0xab626d9b, 
	0xa99e7c9a, 0xcd61c313, 0x9381cb9e, 0x6337e473, 
	0x7e799d80, 0x90d1d67d, 0xeebb4795, 0xdf34cbf3, 
	0x52a51d06, 0x32ce4856, 0x057e0223, 0x19bff3e2, 
	0xb7d8bea2, 0xa188fbf0, 0x77d907bb, 0xbd8b4db2, 
	0xa53adb36, 0x27e6d118, 0x52aa6396, 0xfd11cc21, 

// 5'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xdffff9bd, 0xf0370036, 0xaa3869f0, 0x25f303d5, 
	0x31c2515f, 0xbbdc4d71, 0x48d26067, 0xfc2d97ad, 
	0xa81fffa7, 0x4dfecb52, 0xb7a1bd97, 0xab626d9b,  
	0xa99e7c9a, 0xcd61c313, 0x9381cb9e, 0x6337e473, 
	0x7e799d80, 0x90d1d67d, 0xeebb4795, 0xdf34cbf3, 
	0x52a51d06, 0x32ce4856, 0x057e0223, 0x19bff3e2, 
	0xb7d8bea2, 0xa188fbf0, 0x77d907bb, 0xbd8b4db2, 
	0xa53adb36, 0x27e6d118, 0x52aa6396, 0xfd11cc21, 

// 6'th vector : key_size = 864-bit,  CHNK_SZ = 288b, PREC_ID = Triple
	0xb4cdaf82, 0x799097ad, 0x9ffe8634, 0x4021482d, 
 	0x063944dc, 0xdbdfcdfc, 0x66c6920a, 0xe3507b20, 
 	0x8a48fa41, 0xff19e883, 0x5568678a, 0x0b410b9c, 
 	0x1557816f, 0x0c4dcc19, 0xd274bd86, 0xd1e0c8a7, 
 	0x10e1e415, 0xb3fa671f, 0x748e5c9d, 0xf9937d68, 
 	0x167a87a7, 0xa8fb96ac, 0xda4cc4de, 0x8f85f997, 
 	0xa7d3d20d, 0x34f84123, 0xb84a9e71,

// 7'th vector : key_size = 1536-bit, CHNK_SZ = 512b, PREC_ID = Triple
	0x9da7a343, 0x92923e0b, 0xb15497cc, 0x06c15205, 
 	0x112ac82a, 0x20238704, 0x30eaf5af, 0x35e38d2a, 
 	0x5e9b03fe, 0x6bf65590, 0xd58b53e1, 0x9dab5e42, 
 	0xfa24a173, 0x71ad30a0, 0x965851a8, 0x05232333, 
 	0xb751098b, 0x99acc3e6, 0x6c131be8, 0xd61cbf2e, 
 	0x6aba3489, 0x6f97bac2, 0xe8ad3f5b, 0xee5aa744, 
 	0xac8caf8f, 0xce50af6b, 0xdf46a2a3, 0x7254dbbc, 
 	0xa880c00c, 0x999e81bb, 0x3c50a2c4, 0xa2b6378f, 
 	0xff26027a, 0x62f37aff, 0xef674d42, 0x999b6cfc, 
 	0x09782d05, 0x42cc1c9b, 0xd934e7b9, 0x23ecc8ca, 
 	0x2975a8fd, 0x39602f75, 0x0fc3e141, 0x4a0fcbbd, 
 	0x97127fdb, 0x5d233051, 0xaa2310c1, 0x52c65117, 

// 8'th vector : key_size = 1408-bit,  CHNK_SZ = 352b, PREC_ID = Quadruple
	0xecf21df3, 0xcf5b0a95, 0x1b286456, 0x1bf8bc13, 
 	0xd2fd1c6a, 0x76d6f4a1, 0x5cad528c, 0x61c14222, 
 	0x95818047, 0x60f1a74b, 0x96750e14, 0xd870accd, 
 	0x528291ed, 0xecd0333b, 0xb067fd9d, 0xe54da0c0, 
 	0xd453ad89, 0xc0c6796a, 0x647299dc, 0x81b36aac, 
 	0xc9c49735, 0x1ee4aaa9, 0xda66dc3c, 0xa9b89141, 
 	0x170b0db2, 0xd2421e51, 0x6878c082, 0x48d1fc72, 
 	0xd234c015, 0x29470b21, 0x1358f0d2, 0x5195a96b, 
 	0x83e7fb3a, 0xf7707c54, 0x525d0a52, 0xc5d2ac4f, 
 	0x2862ca35, 0x76c1a287, 0x794ba10d, 0x70f69de3, 
 	0xc7ffbb8f, 0x8523b349, 0xd9f328d1, 0x6aaa4171, 

// 9'th vector : key_size = 2048-bit,  CHNK_SZ = 512b, PREC_ID = Quadruple
	0xe35f334e, 0xd6db2c87, 0x05ef00fd, 0xa3f8a40c, 
 	0xc931987e, 0x22df83ca, 0x04638644, 0xcb5a749c, 
 	0xb0a2902f, 0xd0dca5d7, 0xab8a1523, 0x7dc1f089, 
 	0x089847d4, 0x8c3b62c8, 0x028e614d, 0xd5465243, 
 	0x5835b7eb, 0xa6ef25cd, 0x5360cb1c, 0x835ef4f8, 
 	0x9a176cc9, 0x93cf9789, 0x2eef726c, 0xd8c4d5b9, 
 	0xa1fc157a, 0x37b5b318, 0x68f34739, 0x21a2b88d, 
 	0x4e43fd0a, 0x27c7baba, 0xc185d8fd, 0x8a9a486c, 
 	0x16506b24, 0x246a2f26, 0x1bdfe05d, 0xe48b1c40, 
 	0xc556886d, 0x2699a61a, 0x3bd6343b, 0x5f5456b6, 
 	0x72954ce7, 0xdf489c45, 0xad7905dd, 0xf6e570a9, 
 	0x0d39a416, 0x248bf33d, 0x5e5186a4, 0xfbe41334, 
 	0xb0f511e0, 0x114d87fa, 0x21ef5dcd, 0xc2402c70, 
 	0x0dc49813, 0x6fff7702, 0xff7353c2, 0xaabe2f69, 
 	0x478ab606, 0x608304ef, 0x60796e07, 0x97199525, 
 	0xa514045a, 0x6c3dce7f, 0xb512a87d, 0x682d0851, 

// 10'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0xe35f334e, 0xd6db2c87, 0x05ef00fd, 0xa3f8a40c, 
 	0xc931987e, 0x22df83ca, 0x04638644, 0xcb5a749c, 
 	0xb0a2902f, 0xd0dca5d7, 0xab8a1523, 0x7dc1f089, 
 	0x089847d4, 0x8c3b62c8, 0x028e614d, 0xd5465243, 
 	0x5835b7eb, 0xa6ef25cd, 0x5360cb1c, 0x835ef4f8, 
 	0x9a176cc9, 0x93cf9789, 0x2eef726c, 0xd8c4d5b9, 
 	0xa1fc157a, 0x37b5b318, 0x68f34739, 0x21a2b88d, 
 	0x4e43fd0a, 0x27c7baba, 0xc185d8fd, 0x8a9a486c, 
 	0x16506b24, 0x246a2f26, 0x1bdfe05d, 0xe48b1c40, 
 	0xc556886d, 0x2699a61a, 0x3bd6343b, 0x5f5456b6, 
 	0x72954ce7, 0xdf489c45, 0xad7905dd, 0xf6e570a9, 
 	0x0d39a416, 0x248bf33d, 0x5e5186a4, 0xfbe41334, 
 	0xb0f511e0, 0x114d87fa, 0x21ef5dcd, 0xc2402c70, 
 	0x0dc49813, 0x6fff7702, 0xff7353c2, 0xaabe2f69, 
 	0x478ab606, 0x608304ef, 0x60796e07, 0x97199525, 
 	0xa514045a, 0x6c3dce7f, 0xb512a87d, 0x682d0851
	};


const u32 p_AB_s[AB_data_cnt] = {
//const unsigned int p_AB_s[AB_data_cnt] = {
// 1'st vector : key_size = 128-bit, CHNK_SZ = 128b, PREC_ID = Single (out_p_p_0_p.dat)
//    [MSB]					               [LSB]
	0x403c8f44, 0x6c623465, 0x44092e40, 0x2725eb28,
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single (out_n_n_0_p.dat)
	0xd45adabb, 0x0991df8b, 0x80e97092, 0x6d12822a, 
 	0xf148b295, 0x80d3d394, 0x73b1d0af, 0x75f13157, 
 	0xfa8794e0, 0xd72b7122, 0xb2d9c87b, 0x96368c04, 
 	0xc8b223bd, 0x63dbbdb3, 0x6b0a382b, 0x931e1ad5, 

// 3'rd vector : key_size = 832-bit,  CHNK_SZ = 416b, PREC_ID = Double (out_n_p_1_p.dat)
	0x43b39914, 0x4cd07cea, 0x3f516a5a, 0x4a507b33, 
 	0x437cfd81, 0xa56776a9, 0xe9892815, 0x72d689ab, 
 	0xa4bdf41a, 0x1706e60e, 0x477c3906, 0xa2620606, 
 	0x884e3965, 0xa74b5a66, 0x0c38d8e2, 0xd890db01, 
 	0x4fc54922, 0x0c2a130c, 0xfefe1154, 0x2547176b, 
 	0x25b6992f, 0x9a4ee7a6, 0x046c9662, 0x9886e857, 
 	0x4e81e823, 0xfbcaeaca, 
 	
// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double (out_p_p_0_p.dat)
	0x1d1cfbf8, 0xf23d6903, 0x471323b5, 0xa95c9884, 
	0xcb09cd44, 0x6d5e3c55, 0x2143b3a2, 0xca0a001b, 
	0xbb09ebdf, 0x95dbe945, 0x2160ad4b, 0x7f71b47a, 
	0x20e156e2, 0x3fd4b434, 0xbedf8c96, 0xd95efe11, 
	0x8e9458c3, 0x4894f549, 0x1ae80966, 0x25bf364e, 
	0x7695b467, 0x1ae8e75e, 0x9c19b3c2, 0x9caffd16, 
	0xbc654536, 0x80783274, 0x30d31111, 0x735dd151, 
	0xdffbd551, 0xf1279dbc, 0x69a94cba, 0x65f2d362, 

// 5'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double "pre-loading = NO" (out_p_p_0_p.dat)
	0x1d1cfbf8, 0xf23d6903, 0x471323b5, 0xa95c9884, 
	0xcb09cd44, 0x6d5e3c55, 0x2143b3a2, 0xca0a001b, 
	0xbb09ebdf, 0x95dbe945, 0x2160ad4b, 0x7f71b47a, 
	0x20e156e2, 0x3fd4b434, 0xbedf8c96, 0xd95efe11, 
	0x8e9458c3, 0x4894f549, 0x1ae80966, 0x25bf364e, 
	0x7695b467, 0x1ae8e75e, 0x9c19b3c2, 0x9caffd16, 
	0xbc654536, 0x80783274, 0x30d31111, 0x735dd151, 
	0xdffbd551, 0xf1279dbc, 0x69a94cba, 0x65f2d362, 

// 6'th vector : key_size = 864-bit,  CHNK_SZ = 288b, PREC_ID = Triple (out_p_n_0_p.dat)
	0x45d0f4ce, 0x104f0f8d, 0xa59283c4, 0x046b10a7, 
 	0xba5fa1e1, 0x252181cf, 0x9ea20d7e, 0x4c9afe54, 
 	0x2bf7b49e, 0x6ba1ab92, 0xb4b00693, 0xf128d067, 
 	0xe1247720, 0x0ec29cdf, 0x92cdb304, 0x1db2ded9, 
 	0xf813052a, 0x5454e8c5, 0x1dbb7eb2, 0x68a680e3, 
 	0xada1ed88, 0xb38497db, 0x2aefb407, 0xe3d7a72d, 
 	0x10061752, 0x30bb3cd0, 0x7d6a9df2,

// 7'th vector : key_size = 1536-bit, CHNK_SZ = 512b, PREC_ID = Triple (out_p_p_1_p.dat)
	0x57642048, 0x4ae27e83, 0x1f91cce1, 0xdd22cae7, 
 	0x48569e11, 0x2181c368, 0x694d2d8b, 0xe5588b9b, 
 	0x84f8a24b, 0x92aa1188, 0x09267932, 0xeda38914, 
 	0x3e659c35, 0x7085570c, 0xc8e480ee, 0xb3db4fa9, 
 	0xa55d0d29, 0x19917093, 0xc0ab814e, 0x963e2851, 
 	0x634851f4, 0x0615cc26, 0x39668fae, 0xa05c62ba, 
 	0x225b9fba, 0xe28ebcf5, 0xc2f2ba1f, 0x2510ab3b, 
 	0xbcb6f7aa, 0x350e9e3d, 0xa58e0a8c, 0xb8e4231e, 
 	0x6c68e546, 0x250c82e2, 0xee443728, 0xc45c63ed, 
 	0xab7697ac, 0x94bc28d8, 0x938bdf26, 0x1ec40c2f, 
 	0x329dc08f, 0x4a7f5927, 0x62cc4474, 0x5bf0f7c4, 
 	0xaeb5a215, 0x710fcbc9, 0x6ab9365f, 0x5e0f778f, 

// 8'th vector : key_size = 1408-bit,  CHNK_SZ = 352b, PREC_ID = Quadruple (out_n_n_1_p.dat)
	0xd5d69669, 0x81082d60, 0x93c16379, 0x2d253302, 
 	0xf927bfdf, 0x8b481638, 0x70e3663a, 0xc183c486, 
 	0x66e5d0a6, 0x0321895f, 0x7c94e9c1, 0xcf4bc37b, 
 	0x6b671676, 0xb0610787, 0x2dd114f2, 0x8c738b3b, 
 	0x9c349b26, 0x1019794c, 0xf131f8dc, 0xa8cff1d3, 
 	0xe0e8b0b7, 0x88832981, 0x44ab01cc, 0x67a78fce, 
 	0x4d212f37, 0xa23ecca7, 0x2cab8192, 0x1d9e1ddc, 
 	0x5b5b76e0, 0x7c1e2f40, 0x502aeadd, 0x537cd321, 
 	0x963f0d60, 0x311a6b3a, 0x49488358, 0x8d66c2c5, 
 	0x10330901, 0x9ccbecd5, 0x32fe1f64, 0x0c0011d9, 
 	0xe9008c74, 0x83c3170b, 0xb675c598, 0xbb7fd27d, 

// 9'th vector : key_size = 2048-bit,  CHNK_SZ = 512b, PREC_ID = Quadruple (out_n_p_0_p.dat)
	0x08185587, 0xf65da743, 0x7c43416a, 0x193ea0ea, 
 	0x5c2a240f, 0x6139384b, 0x687d119c, 0x453bab25, 
 	0x8be0612f, 0x3bd8cf31, 0x3569a0e4, 0xfda9bdf2, 
 	0x3894742e, 0xd4c9a5d9, 0xee275f0d, 0x4a50fbaf, 
 	0x43d1cdcb, 0xf4f63252, 0x63d5561f, 0x0cb67e01, 
 	0xb045f8e5, 0x7dc1fa4a, 0x318254e2, 0xe86deffb, 
 	0x97acc24f, 0x67245971, 0xcb110105, 0x3e690a83, 
 	0xe89b2735, 0x2fc0e0ff, 0x596a07a0, 0x5d40a4c3, 
 	0x062bbb30, 0xb508fba7, 0x96f287f7, 0xdb22ab33, 
 	0x08aa54cc, 0x6a33835d, 0x2026f3fd, 0xc3d85783, 
 	0x858bf183, 0x674cb429, 0x43d91a3e, 0x397a07c2, 
 	0xab86d4c9, 0xae95140a, 0x0c9f6fba, 0x4662fec6, 
 	0xbac90d6c, 0xbbb6caa5, 0x837479cf, 0x892e7180, 
 	0x000d94b8, 0x18ca47a5, 0xc4ad1ab0, 0xb07d6018, 
 	0xb57e2a37, 0x508a2ac0, 0x1b6c4e5a, 0x0b63417f, 
 	0x2f44e874, 0x88eb5be2, 0xa310dec5, 0xb13add91, 

// 10'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple "pre-loading = NO" (out_p_n_0_p.dat)
	0x08185587, 0xf65da743, 0x7c43416a, 0x193ea0ea, 
 	0x5c2a240f, 0x6139384b, 0x687d119c, 0x453bab25, 
 	0x8be0612f, 0x3bd8cf31, 0x3569a0e4, 0xfda9bdf2, 
 	0x3894742e, 0xd4c9a5d9, 0xee275f0d, 0x4a50fbaf, 
 	0x43d1cdcb, 0xf4f63252, 0x63d5561f, 0x0cb67e01, 
 	0xb045f8e5, 0x7dc1fa4a, 0x318254e2, 0xe86deffb, 
 	0x97acc24f, 0x67245971, 0xcb110105, 0x3e690a83, 
 	0xe89b2735, 0x2fc0e0ff, 0x596a07a0, 0x5d40a4c3, 
 	0x062bbb30, 0xb508fba7, 0x96f287f7, 0xdb22ab33, 
 	0x08aa54cc, 0x6a33835d, 0x2026f3fd, 0xc3d85783, 
 	0x858bf183, 0x674cb429, 0x43d91a3e, 0x397a07c2, 
 	0xab86d4c9, 0xae95140a, 0x0c9f6fba, 0x4662fec6, 
 	0xbac90d6c, 0xbbb6caa5, 0x837479cf, 0x892e7180, 
 	0x000d94b8, 0x18ca47a5, 0xc4ad1ab0, 0xb07d6018, 
 	0xb57e2a37, 0x508a2ac0, 0x1b6c4e5a, 0x0b63417f, 
 	0x2f44e874, 0x88eb5be2, 0xa310dec5, 0xb13add91
	};

const unsigned int p_AB_ctr[AB_sfr_cnt] = {
// 1'st vector
// PKA_SFR0: CHNK_SZ=0011(128b), PREC_ID=00(Single)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(0), B_SEG_ID=00001(1), M_SEG_ID=00010(2), S_SEG_ID=00011(3)
// PKA_SFR3: A:positive , B:positive
// PKA_SFR4: SEG_SIZE=10(64B), FUNC_ID=0
	0x00000018, 0x00000008, 0x00010203, 0x00000000, 0x00000040,

// 2'nd vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=00(Single)
// PKA_SFR1: PLDM_ON= 
// PKA_SFR2: A_SEG_ID=00000(24), B_SEG_ID=00001(25), M_SEG_ID=00010(26), S_SEG_ID=00011(27)
// PKA_SFR3: A:negative , B:negative
// PKA_SFR4: SEG_SIZE=10(64B), FUNC_ID=0
	0x00000078, 0x00000008, 0x18191a1b, 0x03000000, 0x00000040,

// 3'rd vector
// PKA_SFR0: CHNK_SZ=1100(416b), PREC_ID=01(Double)
// PKA_SFR1: PLDM_ON=1
// PKA_SFR2: A_SEG_ID=00000(5), B_SEG_ID=00001(6), M_SEG_ID=00010(7), S_SEG_ID=00011(8)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=0
	0x00000061, 0x00000008, 0x05060708, 0x00000020, 0x00000020,

// 4'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=01(Double)
// PKA_SFR1: PLDM_ON=1
// PKA_SFR2: A_SEG_ID=00000(10), B_SEG_ID=00001(11), M_SEG_ID=00010(12), S_SEG_ID=00011(13)
// PKA_SFR3: A:positive , B:positive
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=0
	0x00000079, 0x00000008, 0x0a0b0c0d, 0x00000000, 0x00000020,

// 5'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=01(Double)
// PKA_SFR1: PLDM_ON=0 
// PKA_SFR2: A_SEG_ID=00000(2), B_SEG_ID=00001(3), M_SEG_ID=00010(4), S_SEG_ID=00100(5)
// PKA_SFR3: A:positive , B:positive
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=0
	0x00000079, 0x00000000, 0x02030405, 0x00000000, 0x00000020,

// 6'th vector
// PKA_SFR0: CHNK_SZ=1000(288b), PREC_ID=10(Triple)
// PKA_SFR1: PLDM_ON=1
// PKA_SFR2: A_SEG_ID=00000(1), B_SEG_ID=00001(2), M_SEG_ID=00010(3), S_SEG_ID=00011(4)
// PKA_SFR3: A:positive , B:negative
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=0
	0x00000042, 0x00000008, 0x01020304, 0x00000004, 0x00000020,

// 7'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=10(Triple)
// PKA_SFR1: PLDM_ON=1
// PKA_SFR2: A_SEG_ID=00000(0), B_SEG_ID=00001(1), M_SEG_ID=00010(2), S_SEG_ID=00011(3)
// PKA_SFR3: A:positive , B:positive
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=0
	0x0000007a, 0x00000008, 0x00010203, 0x00000000, 0x00000000,

// 8'th vector
// PKA_SFR0: CHNK_SZ=1010(352b), PREC_ID=11(Quadruple)
// PKA_SFR1: PLDM_ON=1
// PKA_SFR2: A_SEG_ID=00000(2), B_SEG_ID=00001(3), M_SEG_ID=00010(4), S_SEG_ID=00011(5)
// PKA_SFR3: A:negative , B:negative
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=0
	0x00000053, 0x00000008, 0x02030405, 0x0000000c, 0x00000000,

// 9'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=11(Quadruple)
// PKA_SFR1: PLDM_ON=1
// PKA_SFR2: A_SEG_ID=00000(4), B_SEG_ID=00001(5), M_SEG_ID=00010(1), S_SEG_ID=00011(2)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=0
	0x0000007b, 0x00000008, 0x04050102, 0x00000010, 0x00000000,

// 10'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=11(Quadruple)
// PKA_SFR1: PLDM_ON=0
// PKA_SFR2: A_SEG_ID=00000(5), B_SEG_ID=00001(0), M_SEG_ID=00010(1), S_SEG_ID=00011(3)
// PKA_SFR3: A:positive , B:negative
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=0
	0x0000007b, 0x00000000, 0x05000103, 0x00000001, 0x00000000
	};

static u32 p_Ovf_a[Ovf_data_cnt] = {
//const unsigned int p_Ovf_a[Ovf_data_cnt] = {
// 1'st vector : key_size = 128-bit, CHNK_SZ = 128b, PREC_ID = Single
//    [MSB]					               [LSB]
	0x91BF83F9, 0xF09285B6, 0x7E403F99, 0x98DA45AF,	// 4
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0x0D7218D7, 0x45876391, 0xC058B518, 0xE35591BF, 
	0x83F9F092, 0x85B67E40, 0x3F9998DA, 0x46588B85, 
	0x38A703E4, 0x8C8F1114, 0xDAA64F7B, 0xD716E57A, 
	0x9907096C, 0x5F360DB1, 0xCDDFFA4F, 0x544529D3,	// 16 	

// 3'rd vector : key_size = 256-bit,  CHNK_SZ = 128b, PREC_ID = Double
	0x337E89DA, 0x31090965, 0xB5E61929, 0x7D025512, 
	0x0DBE446D, 0x8CDFB409, 0xEE0DF583, 0x6349B613,	// 8	 						 
	
// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0x23EAADFC, 0x4611843E, 0xA6C7117F, 0xE896FCEE, 
	0x560AA97C, 0x40153112, 0xE34A3E00, 0x9F001AD4, 
	0xBB4C1C5B, 0xE0073E2E, 0x02D04A84, 0x08CB38BB, 
	0xAF31643C, 0xE89ED82D, 0xBEAF59A0, 0xA16506D2, 
	0xF20316E0, 0x1CB0B5BB, 0xC8F94225, 0x12DCF8D5, 
	0x1A7DCC1A, 0x5C2DED9A, 0x88588087, 0x0844F5D9, 
	0x481D27DF, 0xFB178992, 0xB0ACD48A, 0x15D10231, 
	0xDBA0EE6A, 0xEAE91F46, 0x18DC9D3A, 0x7E0994E5,	// 32 

// 5'th vector : key_size = 384-bit,  CHNK_SZ = 128b, PREC_ID = Triple
	0xED8B4C82, 0x70EEDFC0, 0x8333210B, 0x4FB6C8D5, 
	0x9534D329, 0xF584FAC2, 0x265892F3, 0x8A97C888, 
	0xF490B013, 0x6E3C2B19, 0xF1F0B4D0, 0xE18E644D,	// 12 

// 6'th vector : key_size = 1536-bit, CHNK_SZ = 512b, PREC_ID = Triple
	0xF96969F7, 0xDCA8B0B3, 0x2F68EF9E, 0x4CDA18FE, 
	0x676DBB2C, 0x023522DC, 0xFC5D4D45, 0xA33262DD, 
	0x319D75B5, 0x437380D9, 0xBC3C790C, 0xCA362154, 
	0x4605E249, 0xF8243CEA, 0x4A24E03E, 0x9FB11208, 
	0xCC188EA5, 0xDC263EC8, 0xF1C23220, 0xE26E91A3, 
	0xE5811B27, 0x22069743, 0x77DED1C4, 0xA90D5692, 
	0x44AFE427, 0xB706240B, 0x2671218B, 0x72AF2EFD, 
	0x4D5B8F9C, 0xC87BB24A, 0x41355FA7, 0x27AEEF44, 
	0xB84270AB, 0xF701FDC7, 0x91A9EB9C, 0xAE56D601, 
	0x6084E51E, 0x36DD196D, 0x7B241660, 0x9D7146C9, 
	0x1CF2E9A4, 0x2C597BA0, 0xD700BC6C, 0xD0C5F5B6, 
	0xBFFF6B5A, 0x8B7C81F1, 0x8F6CC7E5, 0x3EFD404B,	// 48  

// 7'th vector : key_size = 512-bit,  CHNK_SZ = 128b, PREC_ID = Quadruple
	0xF28DE728, 0xBA789C6E, 0x3FA74AE7, 0x1CAA6E40, 
	0x7C060F6D, 0x7A4981BF, 0xC0666725, 0xB9A7747A, 
	0xC758FC1B, 0x7370EEEB, 0x2559B084, 0x28E91A85, 
	0x66F8F693, 0xA0C9F24E, 0x322005B0, 0xABBAD62D,	// 16  

// 8'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0xE5048996, 0x456B6EA3, 0x62E5EFD9, 0x62071BE3, 
	0xD9DA9072, 0x96ADF9C0, 0x8E313831, 0x96A66095, 
	0xFE22FE61, 0xCE03F307, 0x1ED90D69, 0x822C488E, 
	0xAEB96D21, 0x5C410060, 0x9FA8DAE4, 0xAD2B9B46, 
	0x7A5FB43F, 0xB380D5B9, 0xCE596F85, 0x58C57CAA, 
	0x8ACD27F4, 0xD7255B8F, 0xE924C3ED, 0x6FF957EE, 
	0x7BE20081, 0xB8770162, 0x4B4C1F77, 0x0B5772DE, 
	0xD5779BE3, 0xACA9E306, 0xF1D4F885, 0xA8845A14, 
	0x4CD3F641, 0x029A5643, 0x47E0A169, 0xAC278A8C, 
	0xEB2A314E, 0x07AC9B21, 0x76D49428, 0x1C03C810, 
	0x20DD09BA, 0x0371D234, 0x38E09F22, 0xF7E856AF, 
	0x3C8A87B2, 0x12DD23BC, 0x4B3E66CB, 0x43BB4715, 
	0x59170DF8, 0x38CABD0A, 0x683CE11B, 0x0DE3AFFB, 
	0x8B40B3A5, 0x1D09390F, 0xC1A31732, 0x3131C466, 
	0x44BADABC, 0xC443A9CF, 0x2676B009, 0x1D27D4E7, 
	0xD23F1108, 0xD32021A3, 0x948ED3EA, 0x9D662929	// 64
	};

static u32 p_Ovf_b[Ovf_data_cnt] = {
//const unsigned int p_Ovf_b[Ovf_data_cnt] = {
// 1'st vector : key_size = 128-bit, CHNK_SZ = 128b, PREC_ID = Single
//    [MSB]					               [LSB]
	0x142FE88C, 0x764731F9, 0x89406663, 0x9984CEF3, 
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0x14A722D9, 0x4A7948F8, 0x90C79BC8, 0x7BE3C1F5, 
	0x8D00F143, 0x7D6E00E6, 0x388776E4, 0xCE5DAF38, 
	0xE0F75BAA, 0xD61D7097, 0xE1C5B2A6, 0x3FEB1960, 
	0xF03E92F2, 0x2EBAAB7F, 0x7A07F830, 0x40A4638D,	

// 3'rd vector : key_size = 256-bit,  CHNK_SZ = 128b, PREC_ID = Double
	0xB7C52C23, 0x9113DAC4, 0xD0F31BDC, 0x460882B6, 
	0xD98729A2, 0xBD800588, 0xECB19263, 0x5C776A25,	 						 
	
// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0x01AB09AA, 0x9F31483A, 0xF46E2380, 0x6430B99D, 
	0x92DC3146, 0x72922B42, 0xA18BC728, 0x0D80D73F, 
	0x83E48DF1, 0x8D40E383, 0xEACF7D67, 0xCFEFDEBD, 
	0x16DA4EAE, 0x0675E407, 0x345A93FE, 0xB2908EF5, 
	0x4F04E4F8, 0x3321B783, 0x38F54760, 0xF62A63B1, 
	0x8997ACBA, 0x90742DEE, 0xE4164219, 0x04E43F2A, 
	0xE2CF6576, 0xD717FD0E, 0x5AC11BB4, 0x7B76BD5C, 
	0xAABE2D2A, 0xA3F22524, 0xA0AE9C18, 0xDA119A2B, 

// 5'th vector : key_size = 384-bit,  CHNK_SZ = 128b, PREC_ID = Triple
	0xFCB1B1E0, 0xDEDDF4E4, 0x09022D64, 0x47444EC8, 
	0x9DBF563A, 0xD1842DB6, 0x8B52890B, 0xDEF76895, 
	0x87B47F68, 0xA9A96743, 0x3F0277B7, 0x2F3EDF77, 

// 6'th vector : key_size = 1536-bit, CHNK_SZ = 512b, PREC_ID = Triple
	0xE8E5462C, 0x55657F11, 0xD7A0ED3C, 0x2AF88900, 
	0xF4164875, 0xDABAFE39, 0xFE58CA19, 0x786CC0C3, 
	0xC7CA40B2, 0x7400C805, 0xCA8C782A, 0x0CB10E95, 
	0xF163B9B2, 0xDF4DF349, 0x3D1F870D, 0x7EC4B23A, 
	0x676AA3E5, 0xBC4B059C, 0x66731E3E, 0x0E2EA011, 
	0x40FB2BE3, 0xCAC118DE, 0xC3D8DE5D, 0xEEBBF1C7, 
	0x35C5AD46, 0x7B78561F, 0xDB9FC93D, 0xFE2DC575, 
	0xFD7ECB61, 0xE0807FA9, 0x8CB9862A, 0xF53943C9, 
	0x84BA5D48, 0xDD2EDBAF, 0x601A6333, 0xE8FCD5BF, 
	0x0757892A, 0x76DDEAC6, 0x47139469, 0xDD4E838E, 
	0x9BA1226A, 0x34F2BDD1, 0xBBDECEFF, 0x2CE715DE, 
	0xFD89632F, 0x4C935970, 0x9958DC82, 0x636B2751, 

// 7'th vector : key_size = 512-bit,  CHNK_SZ = 128b, PREC_ID = Quadruple
	0xEB58DD26, 0xB586B707, 0x6F386437, 0x841C3E0A, 
	0x72FF0EBC, 0x8291FF19, 0xC778891B, 0x31A250C7, 
	0x1F08A455, 0x29E28F68, 0x1E3A4D59, 0xC014E69F, 
	0x0FC16D0D, 0xD1455480, 0x85F807CF, 0xBF5B9C73,	  

// 8'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0x269508D8, 0x27F27589, 0xF8A9753B, 0xE7AC4569, 
	0xBCB05223, 0x97B0270B, 0xE3DF842F, 0x14B9D8E6, 
	0xB5888A33, 0x6DB0F111, 0x36967280, 0x8A8F6759, 
	0x361E6E91, 0x393C2ECD, 0xE78DEEBB, 0x55CDC914, 
	0x6E75AB0B, 0x0B1D8E82, 0x5752EC9F, 0x4FD57E29,  
	0x845C3096, 0x9D54DAF9, 0xA8E045DB, 0x67CEAC1F, 
	0x54381163, 0xE1A6B6DA, 0x93CC09F0, 0xAD2D788E, 
	0x15B2D812, 0x07CC5CF2, 0xBCAAECEF, 0xB2348256, 
	0xEFBDF157, 0xA9849EAB, 0x64C24AC3, 0xF458C67B, 
	0xF4750809, 0x08541608, 0xB48FDEA5, 0xFDE67236, 
	0x50F9F5B8, 0x3E581867, 0x9D1DFB7E, 0x21ECB1EA, 
	0xD566C034, 0x400D2587, 0x7B1408F7, 0xE20B7F6A, 
	0x1D5AEB46, 0xE0C6CE5C, 0xBD3A2514, 0xFC76A2CB, 
	0x435DB520, 0x07CD7A83, 0xF6D735F6, 0x6A86B150, 
	0xAB6D4F96, 0x08284FFD, 0x0A323E40, 0xAD279546, 
	0x45E977AC, 0xFB048A12, 0x1828EE1F, 0xD420AE79
	};

static u32 p_Ovf_m[Ovf_data_cnt] = {
//const unsigned int p_Ovf_m[Ovf_data_cnt] = {
// 1'st vector : key_size = 128-bit, CHNK_SZ = 128b, PREC_ID = Single
//    [MSB]					               [LSB]
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 	

// 3'rd vector : key_size = 256-bit,  CHNK_SZ = 128b, PREC_ID = Double
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,							 
	
// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 

// 5'th vector : key_size = 384-bit,  CHNK_SZ = 128b, PREC_ID = Triple
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 

// 6'th vector : key_size = 1536-bit, CHNK_SZ = 512b, PREC_ID = Triple
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 

// 7'th vector : key_size = 512-bit,  CHNK_SZ = 128b, PREC_ID = Quadruple
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,	  

// 8'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
	};

static u32 p_Ovf_s[Ovf_data_cnt] = {
//const unsigned int p_Ovf_s[Ovf_data_cnt] = {
// 1'st vector : key_size = 128-bit, CHNK_SZ = 128b, PREC_ID = Single
//    [MSB]					               [LSB]
	0xD8782FB2, 0x28A11F4D, 0xC018F1B3, 0x96E1013B, 
	
// 2'nd vector : key_size = 512-bit, CHNK_SZ = 512b, PREC_ID = Single
	0x01D8B389, 0x50AE2570, 0xA5BD9D12, 0xC31998C8, 
	0xEF9F0F86, 0x54EB74A4, 0x15A20CA8, 0x9065D0ED, 
	0x85203667, 0xF20BFF66, 0xF8F4C2E2, 0x89E678CF, 
	0x7403CDFB, 0xAFDB4C74, 0x1A75E504, 0xD3FF18D6, 	

// 3'rd vector : key_size = 256-bit,  CHNK_SZ = 128b, PREC_ID = Double
	0xA0F193D0, 0xF34A8034, 0xCBD28D5C, 0x95FAC59A, 
	0xE01ADB98, 0x249439DC, 0xD20A84B6, 0x896BF2AE,							 
	
// 4'th vector : key_size = 1024-bit, CHNK_SZ = 512b, PREC_ID = Double
	0x5710533A, 0xE33088C7, 0x55D2D7DF, 0xD10D3BD5, 
	0x9E70225B, 0xE2733AE4, 0xF1480813, 0x075F344B, 
	0xF589BC07, 0xD0AD6000, 0x665B3656, 0x72597D9F, 
	0xB2CFF331, 0x1E76D624, 0xB24ED317, 0x8034B916, 
	0x35B1CEF9, 0x981E3608, 0x6553FC57, 0x5983151B, 
	0x09103ECA, 0xFA616777, 0xF2ACA175, 0xDBF41D5B, 
	0x461DAC4C, 0x2CBC6DEE, 0x4494DB76, 0x042B8E74, 
	0x2AA72FD7, 0x3CC05961, 0x519FC7B1, 0xA0DDC58C, 

// 5'th vector : key_size = 384-bit,  CHNK_SZ = 128b, PREC_ID = Triple
	0xA920E4D3, 0x16E2D20D, 0xFE45E509, 0xC655EC58, 
	0x9BC111BA, 0x20919C2E, 0x52CEF12F, 0xE10323DB, 
	0x9FEC30EE, 0x94AD0DB1, 0x203712C7, 0xC2A3CED1, 

// 6'th vector : key_size = 1536-bit, CHNK_SZ = 512b, PREC_ID = Triple
	0x53F603A0, 0xA279AD95, 0xDC39C5C2, 0xAF4D57CB, 
	0xA78DCEE7, 0x5F5FD810, 0xFCBF610F, 0xA709AC79, 
	0xE2CB399F, 0x94B56B05, 0xB6769E58, 0x54D46FA6, 
	0xD23AFE9E, 0xFC6F976D, 0xDA866232, 0x3CBBD452, 
	0x1F1178F8, 0xAA6AE54E, 0x50295363, 0xCCD9AFB2, 
	0x30998FBD, 0x518317BF, 0x23C38788, 0x074EF19E, 
	0xE5AF8E75, 0xC8D30730, 0x7BDCFED2, 0x7CD42460, 
	0x114A9BC4, 0xAA486259, 0xAD22012D, 0x682AAB56, 
	0xE1A2D4BE, 0x9D5B105A, 0x4FA851D4, 0xABEC874E, 
	0x52618CDA, 0x78D77654, 0x16BF2AC3, 0x1AFCA30C, 
	0x55D6367C, 0xE76BE67D, 0x819121F8, 0x2C86B28E, 
	0x98C0AB17, 0x017CC2DF, 0xCCE84296, 0xF810893E, 

// 7'th vector : key_size = 512-bit,  CHNK_SZ = 128b, PREC_ID = Quadruple
	0xE504D3FF, 0x18D601D8, 0xB38950AE, 0x2570A5BD, 
	0x9D12C319, 0x98C8EF9F, 0x0F8654EB, 0x74A415A2, 
	0x0CA89065, 0xD0ED8520, 0x3667F20B, 0xFF66F8F4, 
	0xC2E289E6, 0x78CF7403, 0xCDFBAFDB, 0x4C741A75,	  

// 8'th vector : key_size = 2048-bit, CHNK_SZ = 512b, PREC_ID = Quadruple
	0xF0ED5819, 0xD4D27B93, 0x404F4323, 0x0C19980A, 
	0xCCFDBE94, 0x002133EF, 0x26CEDEC6, 0x69FAC243, 
	0xFA2A461E, 0xC9EA5EF7, 0x8EC879E2, 0xE5AB0C7F, 
	0xE2C740E5, 0xC5BEF6D5, 0xE8F4C238, 0x758DAB20, 
	0xF1C09797, 0xF5BEA983, 0x879C8817, 0x11A0FF59, 
	0xE0D9D86F, 0x7CDCCB7E, 0x668C77AB, 0x1D219449, 
	0x8B19BD2C, 0xD1CFA13A, 0xCE344C9D, 0x85FE73A2, 
	0x4943C6C7, 0x06DED8B2, 0xDEB77147, 0xB8F1FFD5, 
	0xB1D3BA89, 0x73440CBA, 0x59388C27, 0x30D66603, 
	0x80E8C82D, 0xBE504798, 0x91B1A29D, 0x464B58A6, 
	0x46480597, 0x6770DE58, 0xA1567ABA, 0x99B9A5FD, 
	0x70FEBE22, 0x4E273AE4, 0x228EF584, 0x5B869241, 
	0xBD8C2EE8, 0xE71A0BBB, 0xA763E143, 0xBC941712, 
	0x41DD8D25, 0x8015AD1C, 0xA5C6822F, 0xDF2FB56A, 
	0xBD263CE3, 0x20B75611, 0xA2BC237B, 0xF473941B, 
	0x91E686CA, 0x7D107D05, 0x61163C7A, 0x3CEF9FFB
	};

const unsigned int p_Ovf_ctr[Ovf_sfr_cnt] = {
// 1'st vector
// PKA_SFR0: CHNK_SZ=0011(128b), PREC_ID=00(Single)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=01111(15), B_SEG_ID=10001(17), M_SEG_ID=10100(20), S_SEG_ID=11010(26)
// PKA_SFR3: A:negative , B:negative
// PKA_SFR4: SEG_SIZE=10(64B), FUNC_ID=0
	0x00000018, 0x00000008, 0x0F11941A, 0x00028000, 0x00000040,

// 2'nd vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=00(Single)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=10101(21), B_SEG_ID=01111(15), M_SEG_ID=10111(23), S_SEG_ID=11101(29)
// PKA_SFR3: A:negative , B:negative
// PKA_SFR4: SEG_SIZE=10(64B), FUNC_ID=0
	0x00000078, 0x00000008, 0x150F171D, 0x00208000, 0x00000040,

// 3'rd vector
// PKA_SFR0: CHNK_SZ=0011(128b), PREC_ID=01(Double)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00111(7), B_SEG_ID=01001(9), M_SEG_ID=01100(12), S_SEG_ID=01010(10)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=0
	0x00000019, 0x00000008, 0x07090C0A, 0x00000080, 0x00000020, 

// 4'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=01(Double)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=01101(13), B_SEG_ID=01100(12), M_SEG_ID=01010(10), S_SEG_ID=01000(8)
// PKA_SFR3: A:negative , B:positive
// PKA_SFR4: SEG_SIZE=01(128B), FUNC_ID=0
	0x00000079, 0x00000008, 0x0D0C0A08, 0x00002000, 0x00000020,   

// 5'th vector
// PKA_SFR0: CHNK_SZ=0011(128b), PREC_ID=10(Triple)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00000(0), B_SEG_ID=00010(2), M_SEG_ID=00100(4), S_SEG_ID=00110(6)
// PKA_SFR3: A:positive , B:negative
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=0
	0x0000001A, 0x00000008, 0x00020406, 0x00000004, 0x00000000, 

// 6'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=10(Triple)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00110(6), B_SEG_ID=00101(5), M_SEG_ID=00011(3), S_SEG_ID=00001(1)
// PKA_SFR3: A:positive , B:negative
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=0
	0x0000007A, 0x00000008, 0x06050301, 0x00000020, 0x00000000, 

// 7'th vector
// PKA_SFR0: CHNK_SZ=0011(128b), PREC_ID=11(Quad)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00001(1), B_SEG_ID=00011(3), M_SEG_ID=00100(4), S_SEG_ID=00101(5)
// PKA_SFR3: A:positive , B:positive
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=0
	0x0000001B, 0x00000008, 0x01030405, 0x00000000, 0x00000000, 

// 8'th vector
// PKA_SFR0: CHNK_SZ=1111(512b), PREC_ID=11(Quad)
// PKA_SFR1: PLDM_ON=1 
// PKA_SFR2: A_SEG_ID=00110(6), B_SEG_ID=00100(4), M_SEG_ID=00010(2), S_SEG_ID=00000(0)
// PKA_SFR3: A:positive , B:positive
// PKA_SFR4: SEG_SIZE=00(256B), FUNC_ID=0
	0x0000007B, 0x00000008, 0x06040200, 0x00000000, 0x00000000
	};




#endif
