/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6410.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : sblock.h
*  
*	File Description : This file implements the API functons for Security subsystem.
*				    This Test code is oriented by SA Verification Code
*
*	Author : wonjoon.jang
*	Dept. : AP Development Team
*	Created Date : 2009/01/18
*	Version : 0.1 
* 
*	History
*	- Created(wonjoon.jang 2007/01/18)
*  
**************************************************************************************/

#ifndef __SBLOCK_H__
#define __SBLOCK_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "def.h"
//#include "sblock_para.h"
//#include "sblock_data.h"
#include "option.h" //jhy20090326 for define CODEC_MEM_ST
typedef unsigned long  word; 
typedef word *mpi;

#define INPUT_BUF			(CODEC_MEM_ST+0x00000000)
#define OUTPUT_BUF			(CODEC_MEM_ST+0x00400000)
#define GOLDEN_BUF			(CODEC_MEM_ST+0x00800000)

#define OUTPUT_BUF1		(CODEC_MEM_ST+0x00500000)
#define GOLDEN_BUF1		(CODEC_MEM_ST+0x00810000)
#define MID_BUF				(CODEC_MEM_ST+0x00C00000)

#define Sblock_INTMD		(true)
//#define Sblock_INTMD		(false)

typedef enum
{
	AES, DES, TDES, HASH, PKA
} SBLK_TYPE;

typedef enum
{
	ECB, CBC, CTR, 
	EDE, EEE, 
	SHA1_HASH, SHA1_HMAC, 
	MD5_HASH, MD5_HMAC, PRNG
} OPER_MODE;

typedef enum
{
   ALG_SHA1, ALG_MD5
} ALG_TYPE;


typedef enum
{
	ENC, DEC
} DIR_SEL;

typedef enum
{
	LASTBYTE_1ST,
	LASTBYTE_2ND,
	LASTBYTE_3RD,
	LASTBYTE_4TH
} LVALID_BYTE;

typedef enum
{
	Key128b,
	Key192b,
	Key256b
}AES_KEY;

typedef enum
{
	NChangeKey,
	ChangeKey
}AES_KEYMODE;

typedef enum
{
	SBLK_CPU,
	SBLK_FIFO,
	SBLK_BCPU
}SBLK_FIFOMD;

typedef enum
{
	BRDMA,
	BTDMA,
	HRDMA,
	PKDMA
}SBLK_DMA;

typedef enum
{
	SBLK_NoSwap,		// No Swap
	SBLK_Swap			//Swap
			
}SBLK_BSWAP;

typedef enum
{
	PKA_128b		= 0x3,			// 128bit
	PKA_160b		= 0x4,
	PKA_192b		= 0x5,
	PKA_224b		= 0x6,
	PKA_256b		= 0x7,
	PKA_288b		= 0x8,
	PKA_320b		= 0x9,
	PKA_352b		= 0xA,
	PKA_384b		= 0xB,
	PKA_416b		= 0xC,
	PKA_448b		= 0xD,
	PKA_480b		= 0xE,
	PKA_512b		= 0xF
			
}PKA_CHUNKSZ;

typedef enum
{
	PKA_SINGLE		= 1,		// Single Precision
	PKA_DOUBLE		= 2,		// Double Precision
	PKA_TRIPLE		= 3,			// Triple Precision
	PKA_QUAD		= 4			// Quadruple Precision
			
}PKA_PREC;

typedef enum
{
	PKA_PLDMON,		// Pre load Enable
	PKA_PLDMOFF		// Pre load disable
			
}PKA_PLDM;

typedef enum
{
	PKA_FULL		= 256,		 // Full Size 256Byte
	PKA_HALF		= 128,		// Half Size 128Byte
	PKA_QUARTER	= 64	// Quarter Size 64Byte
			
}PKA_SEGSZ;

typedef enum
{
	PKA_MulAX1,	 // Montgomery Multiplication (A by 1)
	PKA_MulAXB		// Montgomery Multiplication (A by B)
			
}PKA_FUNC;


typedef struct
{
	SBLK_TYPE	m_eSblkType;
	OPER_MODE	m_eOperMode;
	OPER_MODE	m_eOperMode1;		// for DES/3DES
	SBLK_BSWAP	m_eDISwap;
	SBLK_BSWAP	m_eDOSwap;
	SBLK_BSWAP	m_eRDMASwap;
	SBLK_BSWAP	m_eTDMASwap;

	DIR_SEL		m_eDir;
	SBLK_FIFOMD	m_eTestType;
	//temp
	SBLK_TYPE	m_SBLKTemp0;
	SBLK_TYPE	m_SBLKTemp1;
	SBLK_TYPE	m_SBLKTemp2;
	
} SBLK;

// 
typedef struct
{
	DIR_SEL			eDir;
	SBLK_FIFOMD		eFIFOMD;
	OPER_MODE 		eOperMode;
	AES_KEY			eKeySz;
	AES_KEYMODE	eKeyMD;
	SBLK_BSWAP		eDMASwap;
	SBLK_BSWAP		eKEYSwap;
	SBLK_BSWAP		eCNTSwap;
	SBLK_BSWAP		eIVSwap;
	SBLK_BSWAP		eDOSwap;
	SBLK_BSWAP		eDISwap;

	SBLK_BSWAP		eAESTemp;
	
} AESCtrl;

typedef struct
{
	SBLK_TYPE		eENG;
	DIR_SEL			eDir;
	SBLK_FIFOMD		eFIFOMD;
	OPER_MODE 		eOperMode;
	OPER_MODE		eEEEMode;
	SBLK_BSWAP		eDMASwap;
	SBLK_BSWAP		eKEYSwap;
	SBLK_BSWAP		eIVSwap;
	SBLK_BSWAP		eDOSwap;
	SBLK_BSWAP		eDISwap;

	SBLK_BSWAP		eDESTemp0;
	SBLK_BSWAP		eDESTemp1;
} DESCtrl;

typedef struct
{
	SBLK_FIFOMD		eFIFOMD;
	OPER_MODE 		eOperMode;
	SBLK_BSWAP		eDMASwap;	
	SBLK_BSWAP		eIVSwap;
	SBLK_BSWAP		eDOSwap;
	SBLK_BSWAP		eDISwap;
	
	SBLK_BSWAP		eHASHemp0;
	SBLK_BSWAP		eHASHemp1;
} HASHCtrl;

typedef struct
{
	SBLK_FIFOMD		eFIFOMD;
	PKA_PREC		ePREC;
	PKA_CHUNKSZ	eCHUNKSZ;
	PKA_PLDM		ePLDM;
	PKA_SEGSZ		eSEGSZ;
	PKA_FUNC		ePKAFUNC;

	SBLK_FIFOMD		ePKAtemp0;
	
	u32				uSEGID_A;
	u32				uSEGID_B;
	u32				uSEGID_M;
	u32				uSEGID_S;
	u32				uSIGN;
	
} PKACtrl;

// Define of the control bit
#define AES_ENC				(0)
#define AES_DEC				(1)
#define AES_ECB				(0<<1)
#define AES_CBC				(1<<1)
#define AES_CTR				(2<<1)
#define AES_CPU				(0<<3)
#define AES_DMA				(1<<3)
#define AES_128				(0<<4)
#define AES_192				(1<<4)
#define AES_256				(2<<4)
#define AES_nCHANGE		(0<<6)
#define AES_CHANGE			(1<<6)
#define AES_NOSWAP			(0<<7)
#define AES_SWAP			(0x1F<<7)
#define AES_NO_SWAP_KEY	(0 << 7)
#define AES_SWAP_KEY		(1 << 7)
#define AES_NO_SWAP_CNT	(0 << 8)
#define AES_SWAP_CNT		(1 << 8)
#define AES_NO_SWAP_IV		(0 << 9)
#define AES_SWAP_IV		(1 << 9)
#define AES_NO_SWAP_DO	(0 << 10)
#define AES_SWAP_DO		(1 << 10)
#define AES_NO_SWAP_DI		(0 << 11)
#define AES_SWAP_DI		(1 << 11)	


#define OUT_RDY				(1)
#define IN_RDY				(1<<1)
#define BUSY					(1<<2)

#define DES_ENC				(0)
#define DES_DEC				(1)
#define DES_ECB				(0<<1)
#define DES_CBC				(1<<1)
#define DES_DES				(0<<3)
#define DES_TDES			(1<<3)
#define DES_EDE				(0<<4)
#define DES_EEE				(1<<4)
#define DES_CPU				(0<<5)
#define DES_DMA				(1<<5)
#define DES_NOSWAP			(0<<6)
#define DES_SWAP			(0xF<<6)	
#define DES_NO_SWAP_KEY	(0 << 6)
#define DES_SWAP_KEY		(1 << 6)
#define DES_NO_SWAP_IV		(0 << 7)
#define DES_SWAP_IV		(1 << 7)
#define DES_NO_SWAP_DO	(0 << 8)
#define DES_SWAP_DO		(1 << 8)
#define DES_NO_SWAP_DI		(0 << 9)
#define DES_SWAP_DI		(1 << 9)	

//HASH_CONTROL_1
#define ENG_SHA1_HASH       (0x0)
#define ENG_SHA1_HMAC_INNER (0x1)
#define ENG_SHA1_HMAC_OUTER (0x9)
#define ENG_MD5_HASH        (0x2)
#define ENG_MD5_HMAC_INNER  (0x3)
#define ENG_MD5_HMAC_OUTER  (0xB)
#define ENG_PRNG            (0x4)

#define HASH_START_BIT             (1<<4)
#define HASH_USER_IV_EN           (1<<5)

//HASH_CONTROL_2
#define HASH_PAUSE          (1<<3)

//HASH_FIFO_MODE_EN
#define HASH_DMA			(1)
#define HASH_CPU			(0)

//HASH_BYTE_SWAP
#define HASH_NO_SWAP_DI		(0<<3)
#define HASH_SWAP_DI		(1<<3)
#define HASH_NO_SWAP_DO		(0<<2)
#define HASH_SWAP_DO		(1<<2)
#define HASH_NO_SWAP_IV		(0<<1)
#define	HASH_SWAP_IV		(1<<1)

//HASH_STATUS
#define BUFFER_READY        (1)
#define SEED_SETTING_DONE   (1<<1)
#define PRNG_BUSY           (1<<2)
#define JTAG_STATUS         (1<<3)
#define PARTIAL_DONE        (1<<4)
#define PRNG_DONE           (1<<5)
#define MSG_DONE            (1<<6)
#define PRNG_ERROR          (1<<7)

#define HRDMA_INT_BIT       (1<<1)

// Field Constants for FeedCtrl
#define	PKDMAINT			(1 << 0)
#define	FCFLUSH				(1 << 0)
#define	FCBYTESWAP			(1 << 1)
#define FCDESCEND           (1 << 2)
#define FCTRANSMIT          (1 << 1)
#define FCPKBYTESWAP        (1 << 3)
// Field Constants for PKA
// PKA_SFR0
#define	PREC_ID				(3 << 0)
#define	PREC_SINGLE			(0 << 0)
#define	PREC_DOUBLE			(1 << 0)
#define	PREC_TRIPLE			(2 << 0)
#define	PREC_QUADRUPLE		(3 << 0)
#define	CHNK_SZ(bits)		(((bits >> 5) - 1) << 3)  // 128b <= sz <= 512b

// PKA_SFR1
#define	EXEC_ON				(1 << 0)
#define	PLDM_ON				(1 << 3)

// PKA_SFR2
#define	A_SEG_ID(id)		(id	<< 24)
#define	B_SEG_ID(id)		(id	<< 16)
#define	M_SEG_ID(id)		(id	<< 8)
#define	S_SEG_ID(id)		(id	<< 0)

// PKA_SFR3
#define	SEG_NEG(id)			(1 << id)

// PKA_SFR4
#define	FUNC_ID				(1 << 0)
#define	AXB					(0 << 0)
#define	AX1					(1 << 0)
#define	SEG_SIZE			(3 << 5)
#define	SEG_FULL			(0 << 5)        // 256B = 2048b
#define	SEG_HALF			(1 << 5)        // 128B = 1024b
#define	SEG_QUARTER			(2 << 5)        // 64B = 512b

//*****************************************
// these #define SegX must exist in header file 
// for PKA2 device driver
#define	Seg0	0x00
#define	Seg1	0x01
#define	Seg2	0x02
#define	Seg3	0x03
#define	Seg4	0x04
#define	Seg5	0x05
#define	Seg6	0x06
#define	Seg7	0x07
#define	Seg8	0x08
#define	Seg9	0x09
#define	Seg10	0x0A
#define	Seg11	0x0B
#define	Seg12	0x0C
#define	Seg13	0x0D
#define	Seg14	0x0E
#define	Seg15	0x0F
#define	Seg16	0x10
#define	Seg17	0x11
#define	Seg18	0x12
#define	Seg19	0x13
#define	Seg20	0x14
#define	Seg21	0x15
#define	Seg22	0x16
#define	Seg23	0x17
#define	Seg24	0x18
#define	Seg25	0x19
#define	Seg26	0x1A
#define	Seg27	0x1B
#define	Seg28	0x1C
#define	Seg29	0x1D
#define	Seg30	0x1E
#define	Seg31	0x1F

///////////////////////////////////////
#define	BRINT			(1<<3)
#define	BTINT			(1<<2)
#define	HRINT			(1<<1)
#define	PKINT			(1<<0)

//DMA CPU select
#define PKA_DMA (1)
#define PKA_CPU (0)

//PKA test select
#define PKA_AX1 (0)
#define PKA_AXB (1)
#define PKA_OVF (2)




static u32 g_SDma1Done;
static u32 g_HASHDone;
static u32 g_Sblock_DEBUG;
static u32 g_AgingDis;
#define SBLK_DEBMSG		(g_Sblock_DEBUG&g_AgingDis)

void SBLK_AES(u32 control, u32 *key, u32 *iv, u32 *cnt,
			u32 *source_addr, u32 *dest_addr, u32 *golden_addr, u32 length);

void SBLK_DES(u32 control, u32 *key, u32 *iv, 
			u32 *source_addr, u32 *dest_addr, u32 *golden_addr, u32 length);


void SBLK_CalcBlocks_words(u32 msg_size, u32 * x, u32 * y);
void SBLK_DoPartial_Hash(ALG_TYPE alg, u32 *msg_addr, u32 msg_size);
void SBLK_DoPartial_Hmac(ALG_TYPE alg, u32 msg_size, u32 key_size, u32 *msg_addr, u32 *hmac_key);
void SBLK_DoConcur_HashnCipher(SBLK eBlkChipher, OPER_MODE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size);
void SBLK_DoSeri_HashnCipher(SBLK eBlkChipher, OPER_MODE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size);
//void SBLK_DoSeri_HashnCipher(SBLK_TYPE eBLK, ALG_TYPE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size);
//void SBLK_DoConcur_HashnCipher(SBLK_TYPE eBLK, ALG_TYPE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size);

void SBLK_HASH(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr);
void SBLK_HASH1(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr);
void HASH_SWAP(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr);
void HASH_NOSWAP(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr);
void SBLK_HMAC(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, u32 key_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr, u32 *hmac_key);
void SBLK_PRNG(u32 *prng_seed, u32 *result_addr);

u32 SBLK_InitPKA_(s32 seg_size, s32 chunk_bits, s32 prec_id);
u32 SBLK_PutPKA_(u32* input, s32 seg_id) ;
u32 SBLK_GetPKA_(u32* output, s32 seg_id, s32 m_id);
u32 SBLK_PKA_(s32 a_id, s32 b_id, s32 m_id, s32 s_id, s32 sign) ;
s32 SBLK_PutPKA_CPU_(u32* input, s32 seg_id) ;
s32 SBLK_GetPKA_CPU_(u32* output, s32 seg_id, s32 m_id) ;
void PKA_clear_segment(void);
void PKA_clear_sfr(void);
void PKA_run(int run_value);
void PKA_neg_pos(int Dest, mpi MSec_ptr);
void PKA_Init(u32 CTR0, u32 CTR1, u32 CTR2, u32 CTR3, u32 CTR4);
u32 PKA_Select_SegmentSize(u32 CTR4);
//mpi PKA_Load_Data(u32 CTR0, u32 CTR2, u32 seg_sz, int* w_cnt, int old_w_cnt, u32 test_sel, u32 dma_sel);
s32 PutPKA_DMA(u32* start_addr, u32 seg_id, u32 seg_sz, u32 real_num_sz );
//void PKA_Compare_Result(u32 CTR2, u32 seg_sz, int w_cnt, int old_w_cnt, int loop, u32 test_sel, u32 dma_sel);
s32 GetPKA_DMA(u32* dest_addr, u32 seg_id, u32 seg_sz, u32 real_num_sz );


u32 SBLK_InitPKA(PKACtrl  ePKACtrl );
void SBLK_RunPKA(void);
void SBLK_ClrSegmentPKA(void);
void SBLK_ClrSfrPKA(void);
s32 SBLK_PutPKADMA(u32* start_addr, u32 seg_id ); 
s32 SBLK_GetPKADMA(u32* dest_addr, u32 seg_id );
void SBLK_NegPosPKA(u32 uID_S, u32 uID_M);
s32 SBLK_GetPKA(u32* out_addr, u32 seg_id );
void SBLK_LoadDataPKA(PKACtrl ePKACtrl, u32 *p_input_a, u32 *p_input_b, u32 *p_input_m, u32* w_cnt, u32 old_w_cnt);
void SBLK_FlushDMA(SBLK_DMA eDMAType);
void SBLK_SetDMA(u32 uRxSrcAddr, u32 uRxSize, u32 uTxDstAddr, u32 uTxSize);
void SBLK_AESInit(AESCtrl eAESCtrl, u32 *key, u32 *iv, u32 *cnt);
void SBLK_AESCloseKey(void);
void SBLK_DESInit(DESCtrl eDESCtrl, u32 *key, u32 *iv);
void SBLK_CalBlkWords(u32 uMsgSize, u32 *x, u32 *y);
void SBLK_HASHInit(HASHCtrl eHASHCtrl);
void SBLK_GetPRNG(u32 *prng_seed, u32 *result_addr);
void SBLK_RunHASH(HASHCtrl eHashCtrl,   u32 msg_size, u32 *msg_addr, u32 result_addr);
void SBLK_RunHMAC(HASHCtrl eHashCtrl, u32 msg_size,   u32 *hmac_key, u32 *msg_addr, u32 result_addr );
void SBLK_PutDataToInReg(u32 uSrcAddr, u32 uSize);
void SBLK_GetDataFromOutReg(u32 uDstAddr, u32 uSize);
void SBLK_ValidZero(void);
u8 SBLK_IsOutputReady(void);
void SBLK_IsDMADone(void);
void SBLK_EnDMAINT(SBLK_DMA eDMAType);
void SBLK_DisDMAINT(SBLK_DMA eDMAType);
void SBLK_PendClearFeed(SBLK_DMA eDMAType);
void TestSSS_SFR(void);
void __irq Isr_SSSFeed(void);
void __irq Isr_HASH(void);

u32 SBLK_GetRand(void);
#if 0
void SBLK_Init(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel);
void SBLK_SetFifo(u32 uRxMsgLen, u32 uRxBlkSz,
	u32 uTxMsgLen, u32 uTxBlkSz, LVALID_BYTE eRxLValid);
void SBLK_StartFifo(void);
void SBLK_PutDataToRxFifo(u32 uSrcAddr, u32 uSize);
u8 SBLK_IsFifoTransDone(void);
void SBLK_GetDataFromTxFifo(u32 uDstAddr, u32 uSize);
void SBLK_ClearIntPending(u32 uTXnRX);
void SBLK_SetSDMA(u32 uRxSrcAddr, u32 uRxSize, u32 uTxDstAddr, u32 uTxSize);
void SBLK_StartSDMA(void);
void SBLK_PutDataToInReg(u32 uSrcAddr, u32 uSize, LVALID_BYTE eLValid);
void SBLK_StartByManual(void);
void SBLK_GetDataFromOutReg(u32 uDstAddr, u32 uSize);
u8 SBLK_IsOutputReady(void);

void SBLK_GetAvailableRxFifoSize(u32* uSize);
void SBLK_Reset(void);

 void SBLK_DispFifoRxCtrl(u32 uFRx_Ctrl);
 void SBLK_DispFifoTxCtrl(u32 uFTx_Ctrl);
void SBLK_Init_Test(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel);
void SBLK_Init_Test2(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel);
void SBLK_Init_Test3(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel);
void SBLK_Init_T(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel);
void SBLK_GetDataFromOutReg_Test(u32 uDstAddr, u32 uSize);
void SBLK_PutDataToInReg1(u32 uSrcAddr, u32 uSize, LVALID_BYTE eLValid);
#endif

#ifdef __cplusplus
}
#endif

#endif 


