/**************************************************************************************
* 
*	Project Name : S3C6410 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6410.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : sblock.c
*  
*	File Description : This file implements the API functons for Security subsystem.
*				    This Test code is oriented by SA Verification Code
*
*	Author : Wonjoon,Jang
*	Dept. : AP Development Team
*	Created Date : 2007/01/18
*	Version : 0.1 
* 
*	History
*	- Created(wonjoon.jang 2007/01/18)
*  
**************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "system.h"
#include "util.h"
#include "Library.h"
#include "v210_sfr.h"
#include "intc.h"
#include "gpio.h"

#include "sysc.h"
#include "sblock.h"




#if 0
#define SblkOutp32(addr, x) {Disp("Outp1w(32'h%x, 32'h%x);\n", addr, (x)); Outp32(addr, x);}
#define SblkInp32(addr, x) Inp32_(addr, x)
#else
#define SblkOutp32(addr, x) Outp32(addr, x)
#define SblkInp32(addr, x) Inp32_(addr, x)
#endif


// Define Base Address SFR
//#define	SSS_REG_BASE		(0x7D000000)
//#define	SSS_REG_BASE		(0xEA000000)
#define	FEED_REG_BASE		(SSS_REG_BASE + 0x0000)
#define	AES_REG_BASE		(SSS_REG_BASE + 0x4000)
#define	TDES_REG_BASE		(SSS_REG_BASE + 0x5000)
#define	HASH_REG_BASE		(SSS_REG_BASE + 0x6000)
#define	PKA_REG_BASE		(SSS_REG_BASE +	0x7000)
#define	PKA_SRAM_BASE		(SSS_REG_BASE +	0x8000)


///////////////////////////////////////////////////
//     Security Sub System (Crypto Engine) SFR Map
//	  rev 00 - 2009/01/19
///////////////////////////////////////////////////
//	FEED_REG_BASE	= 0x7d000000
#define	rFCINTSTAT	 			(FEED_REG_BASE + 0x0000)		//Interrupt Status of Feed Control
#define	rFCINTENSET	 		(FEED_REG_BASE + 0x0004)		//Interrupt Enable Set Register of Feed Control	
#define	rFCINTENCLR	 		(FEED_REG_BASE + 0x0008)		//Interrupt Enable Clear Register of Feed Control
#define	rFCINTPEND	 			(FEED_REG_BASE + 0x000C)		//Pending Interrupts of Feed Control
#define	rFCFIFOSTAT	 		(FEED_REG_BASE + 0x0010)		//FIFO Status of Feed Control
#define	rFCFIFOCTRL	 		(FEED_REG_BASE + 0x0014)		//FIFO Control of Feed Control
#define	rFCBRDMAS	 			(FEED_REG_BASE + 0x0020)		//Start address of Block cipher Receiving DMA 
#define	rFCBRDMAL	 			(FEED_REG_BASE + 0x0024)		//Length of Block cipher Receiving DMA
#define	rFCBRDMAC	 			(FEED_REG_BASE + 0x0028)		//Control of Block cipher Receiving DMA
#define	rFCBTDMAS	 			(FEED_REG_BASE + 0x0030)		//Start address of Block cipher Transmitting DMA 
#define	rFCBTDMAL	 			(FEED_REG_BASE + 0x0034)		//Length of Block cipher Transmitting DMA
#define	rFCBTDMAC	 			(FEED_REG_BASE + 0x0038)		//Control of Block cipher Transmitting DMA
#define	rFCHRDMAS	 			(FEED_REG_BASE + 0x0040)		//Start address of Hash Receiving DMA 
#define	rFCHRDMAL	 			(FEED_REG_BASE + 0x0044)		//Length of Hash Receiving DMA
#define	rFCHRDMAC	 			(FEED_REG_BASE + 0x0048)		//Control of Hash Receiving DMA
#define	rFCPKDMAS				(FEED_REG_BASE + 0x0050)
#define	rFCPKDMAL				(FEED_REG_BASE + 0x0054)
#define	rFCPKDMAC				(FEED_REG_BASE + 0x0058)
#define	rFCPKDMAO				(FEED_REG_BASE + 0x005c)
                                      
////////////////////////////////////////	
//	AES_BASE		= 0x7d004000
#define	rAES_CONTROL 			(AES_REG_BASE + 0x0000)		//AES control register
#define	rAES_STATUS 			(AES_REG_BASE + 0x0004)		//AES status register
#define	rAES_INDATA_01		(AES_REG_BASE + 0x0010)		//Input data to be used in encryption/decryption : [127:96]
#define	rAES_INDATA_02		(AES_REG_BASE + 0x0014)		//Input data to be used in encryption/decryption : [95:64]
#define	rAES_INDATA_03		(AES_REG_BASE + 0x0018)		//Input data to be used in encryption/decryption : [63:32]
#define	rAES_INDATA_04		(AES_REG_BASE + 0x001c)		//Input data to be used in encryption/decryption : [31:0]
#define	rAES_OUTDATA_01		(AES_REG_BASE + 0x0020)		//Output data to be used in encryption/decryption : [127:96]
#define	rAES_OUTDATA_02		(AES_REG_BASE + 0x0024)		//Output data to be used in encryption/decryption : [95:64]
#define	rAES_OUTDATA_03		(AES_REG_BASE + 0x0028)		//Output data to be used in encryption/decryption : [63:32]
#define	rAES_OUTDATA_04		(AES_REG_BASE + 0x002c)		//Output data to be used in encryption/decryption : [31:0]
#define	rAES_IVDATA_01		(AES_REG_BASE + 0x0030)		//Initialization Vector to be used in encryption/decryption : [127:96]
#define	rAES_IVDATA_02		(AES_REG_BASE + 0x0034)		//Initialization Vector to be used in encryption/decryption : [95:64]
#define	rAES_IVDATA_03		(AES_REG_BASE + 0x0038)		//Initialization Vector to be used in encryption/decryption : [63:32]
#define	rAES_IVDATA_04		(AES_REG_BASE + 0x003c)		//Initialization Vector to be used in encryption/decryption : [31:0]
#define	rAES_CNTDATA_01		(AES_REG_BASE + 0x0040)		//Counter Data to be used in encryption/decryption : [127:96]
#define	rAES_CNTDATA_02		(AES_REG_BASE + 0x0044)		//Counter Data to be used in encryption/decryption : [95:64]
#define	rAES_CNTDATA_03		(AES_REG_BASE + 0x0048)		//Counter Data to be used in encryption/decryption : [63:32]
#define	rAES_CNTDATA_04		(AES_REG_BASE + 0x004c)		//Counter Data to be used in encryption/decryption : [31:0]
#define	rAES_KEYDATA_01		(AES_REG_BASE + 0x0080)		//Key data to be used in encryption/decryption : [255:224]
#define	rAES_KEYDATA_02		(AES_REG_BASE + 0x0084)		//Key data to be used in encryption/decryption : [223:192]
#define	rAES_KEYDATA_03		(AES_REG_BASE + 0x0088)		//Key data to be used in encryption/decryption : [191:160]
#define	rAES_KEYDATA_04		(AES_REG_BASE + 0x008c)		//Key data to be used in encryption/decryption : [159:128]
#define	rAES_KEYDATA_05		(AES_REG_BASE + 0x0090)		//Key data to be used in encryption/decryption : [127:96]
#define	rAES_KEYDATA_06		(AES_REG_BASE + 0x0094)		//Key data to be used in encryption/decryption : [95:64]
#define	rAES_KEYDATA_07		(AES_REG_BASE + 0x0098)		//Key data to be used in encryption/decryption : [63:32]
#define	rAES_KEYDATA_08		(AES_REG_BASE + 0x009c)		//Key data to be used in encryption/decryption : [31:0]
                                        
////////////////////////////////////////	
//	DES_BASE		= 0x7d005000
#define	rTDES_CONF				(TDES_REG_BASE+0x00)	// TDES configuration  register
#define	rTDES_STAT				(TDES_REG_BASE+0x04)	// TDES status register
#define	rTDES_KEY1_0			(TDES_REG_BASE+0x10)	// TDES input key1 [63:32]
#define	rTDES_KEY1_1			(TDES_REG_BASE+0x14)	// TDES input key1 [31:0]
#define	rTDES_KEY2_0			(TDES_REG_BASE+0x18)	// TDES input key2 [63:32]
#define	rTDES_KEY2_1			(TDES_REG_BASE+0x1C)	// TDES input key2 [31:0]
#define	rTDES_KEY3_0			(TDES_REG_BASE+0x20)	// TDES input key3 [63:32]
#define	rTDES_KEY3_1			(TDES_REG_BASE+0x24)	// TDES input key3 [31:0]
#define	rTDES_IV_0				(TDES_REG_BASE+0x28)	// TDES initial vector [63:32]
#define	rTDES_IV_1				(TDES_REG_BASE+0x2C)	// TDES initial vector [31:0]
#define	rTDES_INPUT_0			(TDES_REG_BASE+0x30)	// TDES input data [63:32]
#define	rTDES_INPUT_1			(TDES_REG_BASE+0x34)	// TDES input data [31:0]
#define	rTDES_OUTPUT_0		(TDES_REG_BASE+0x38)	// TDES output data [63:32]
#define	rTDES_OUTPUT_1		(TDES_REG_BASE+0x3C)	// TDES output data [31:0]

////////////////////////////////////////
//	HASH_BASE		= 0x7d006000
#define rHASH_CONTROL_1    		(HASH_REG_BASE + 0x00)	// Hash control register
#define rHASH_CONTROL_2    		(HASH_REG_BASE + 0x04)	// Hash control register
#define rHASH_FIFO_MODE_EN 	(HASH_REG_BASE + 0x08)	// FIFO mode enable register
#define rHASH_BYTE_SWAP     		(HASH_REG_BASE + 0x0c)	// Byte swap configuration register
#define rHASH_STATUS       		(HASH_REG_BASE + 0x10)	// Hash status register
#define rHASH_MSG_SIZE_LOW 	(HASH_REG_BASE + 0x14)	// Message size in bytes (lower 32bits)
#define rHASH_MSG_SIZE_HIGH	(HASH_REG_BASE + 0x18)	// Message size in bytes (higher 32bits)
#define rHASH_DATA_IN_1    		(HASH_REG_BASE + 0x20)	// Key/Message input register 1
#define rHASH_DATA_IN_2    		(HASH_REG_BASE + 0x24)	// Key/Message input register 2
#define rHASH_DATA_IN_3    		(HASH_REG_BASE + 0x28)	// Key/Message input register 3
#define rHASH_DATA_IN_4    		(HASH_REG_BASE + 0x2c) 	// Key/Message input register 4
#define rHASH_DATA_IN_5    		(HASH_REG_BASE + 0x30)	// Key/Message input register 5
#define rHASH_DATA_IN_6    		(HASH_REG_BASE + 0x34)	// Key/Message input register 6
#define rHASH_DATA_IN_7    		(HASH_REG_BASE + 0x38)	// Key/Message input register 7
#define rHASH_DATA_IN_8    		(HASH_REG_BASE + 0x3c)	// Key/Message input register 8
#define rHASH_SEED_IN_1    		(HASH_REG_BASE + 0x40)	// Seed input 1
#define rHASH_SEED_IN_2    		(HASH_REG_BASE + 0x44)	// Seed input 2
#define rHASH_SEED_IN_3    		(HASH_REG_BASE + 0x48)	// Seed input 3
#define rHASH_SEED_IN_4    		(HASH_REG_BASE + 0x4c)	// Seed input 4
#define rHASH_SEED_IN_5    		(HASH_REG_BASE + 0x50)	// Seed input 5
#define rHASH_RESULT_1     		(HASH_REG_BASE + 0x60)	// Hash/HMAC/Partial result 1
#define rHASH_RESULT_2     		(HASH_REG_BASE + 0x64)	// Hash/HMAC/Partial result 2
#define rHASH_RESULT_3     		(HASH_REG_BASE + 0x68)	// Hash/HMAC/Partial result 3
#define rHASH_RESULT_4     		(HASH_REG_BASE + 0x6c)	// Hash/HMAC/Partial result 4
#define rHASH_RESULT_5     		(HASH_REG_BASE + 0x70)	// Hash/HMAC/Partial result 5
#define rHASH_PRNG_1       		(HASH_REG_BASE + 0x80)	// PRNG result 1
#define rHASH_PRNG_2       		(HASH_REG_BASE + 0x84)	// PRNG result 2
#define rHASH_PRNG_3       		(HASH_REG_BASE + 0x88)	// PRNG result 3
#define rHASH_PRNG_4       		(HASH_REG_BASE + 0x8c)	// PRNG result 4
#define rHASH_PRNG_5       		(HASH_REG_BASE + 0x90)	// PRNG result 5
#define rHASH_IV_1         			(HASH_REG_BASE + 0xa0)
#define rHASH_IV_2         			(HASH_REG_BASE + 0xa4)
#define rHASH_IV_3         			(HASH_REG_BASE + 0xa8)
#define rHASH_IV_4         			(HASH_REG_BASE + 0xac)
#define rHASH_IV_5         			(HASH_REG_BASE + 0xb0)
#define rHASH_PRE_MSG_LENG_HIGH 	(HASH_REG_BASE + 0xc0)	// Pre-message length [63:32]
#define rHASH_PRE_MSG_LENG_LOW  	(HASH_REG_BASE + 0xc4)	// Pre-message length [31:0]

// SFRs	of PKA
#define	rPKA_SFR0			(PKA_REG_BASE + 0x000)
#define	rPKA_SFR1			(PKA_REG_BASE + 0x004)
#define	rPKA_SFR2			(PKA_REG_BASE + 0x008)
#define	rPKA_SFR3			(PKA_REG_BASE + 0x00C)
#define	rPKA_SFR4			(PKA_REG_BASE + 0x010)




// Global variable
volatile u32 gPKANumSize;    	// real number size in bytes
volatile u32 gPKASegSize;    		// memory slot size in bytes
volatile u32 gPKASfr4;        		// contains seg_size excluding func_id
volatile u32 gDefault_m_id;    		// default id of segment having M


SBLK oSblk;


REGINFO		SSSRegInfo[] = 
{
	#if 0
	// Rotator
	{"rCTRLCFG			", ROTATOR_BASE+0x00, 25, RW, DPPB, 0x0100E0F0, 0x0},   	
	{"rSRCADDRREG0		", ROTATOR_BASE+0x04, 32, RW, DPDB, 0, 0x0},   	
	{"rSRCADDRREG1		", ROTATOR_BASE+0x08, 32, RW, DPDB, 0, 0x0},   	
	{"rSRCADDRREG2		", ROTATOR_BASE+0x0C, 32, RW, DPDB, 0, 0x0},   	
	{"rSRCSIZEREG		", ROTATOR_BASE+0x10, 32, RW, DPDB, 0, 0x0},   	
	{"rDESTADDRREG0	", ROTATOR_BASE+0x18, 32, RW, DPDB, 0, 0x0},   	
	{"rDESTADDRREG1	", ROTATOR_BASE+0x1c, 32, RW, DPDB, 0, 0x0},   	
	{"rDESTADDRREG2	", ROTATOR_BASE+0x20, 32, RW, DPDB, 0, 0x0}, 
	{"rSTATCFG			", ROTATOR_BASE+0x2c, 32, RO, DPDB, 0, 0x0}, 
	#endif
	//FEED
	{"rFCINTSTAT			", FEED_REG_BASE + 0x00, 4, RO, DPDB, 0, 0x0},  
	{"rFCINTENSET		", FEED_REG_BASE + 0x04, 4, RW, DPPB, 0, 0x0},
	{"rFCINTENCLR		", FEED_REG_BASE + 0x08, 4, RW, DPPB, 0, 0x0},
	{"rFCINTPEND			", FEED_REG_BASE + 0x0c, 4, RW, DPPB, 0, 0x0},		//It didn't read after write operaton
	{"rFCFIFOSTAT		", FEED_REG_BASE + 0x10, 7, RO, DPDB, 0, 0x0},
	{"rFCFIFOCTRL		", FEED_REG_BASE + 0x14, 3, RW, DPDB, 0, 0x0},
	{"rFCBRDMAS			", FEED_REG_BASE + 0x20, 32, RW, DPDB, 0, 0x0},
	{"rFCBRDMAL			", FEED_REG_BASE + 0x24, 32, RW, DPDB, 0, 0x0},
	{"rFCBRDMAC			", FEED_REG_BASE + 0x28, 2, RW, DPDB, 0, 0x0},
	{"rFCBTDMAS			", FEED_REG_BASE + 0x30, 32, RW, DPDB, 0, 0x0},
	{"rFCBTDMAL			", FEED_REG_BASE + 0x34, 32, RW, DPDB, 0, 0x0},
	{"rFCBTDMAC			", FEED_REG_BASE + 0x38, 2, RW, DPDB, 0, 0x0},
	{"rFCHRDMAS			", FEED_REG_BASE + 0x40, 32, RW, DPPB, 0, 0x0},
	{"rFCHRDMAL			", FEED_REG_BASE + 0x44, 32, RW, DPDB, 0, 0x0},
	{"rFCHRDMAC			", FEED_REG_BASE + 0x48, 2, RW, DPDB, 0, 0x0},
	{"rFCPKDMAS			", FEED_REG_BASE + 0x50, 32, RW, DPPB, 0, 0x0},
	{"rFCPKDMAC			", FEED_REG_BASE + 0x54, 4, RW, DPDB, 0, 0x0},
	{"rFCPKDMAO			", FEED_REG_BASE + 0x58, 12, RW, DPDB, 0, 0x0},	
	//AES
	{"rAES_Control		", AES_REG_BASE + 0x00, 12, RW, DPDB, 0, 0x0},  
	{"rAES_STATUS		", AES_REG_BASE + 0x04, 3, RW, DPPB, 0, 0x0},  	// It didn't read directly
	{"rAES_INDATA_01	", AES_REG_BASE + 0x10, 32, WO, DPDB, 0, 0x0},  
	{"rAES_INDATA_02	", AES_REG_BASE + 0x14, 32, WO, DPDB, 0, 0x0},  
	{"rAES_INDATA_03	", AES_REG_BASE + 0x18, 32, WO, DPDB, 0, 0x0},
	{"rAES_INDATA_04	", AES_REG_BASE + 0x1c, 32, WO, DPDB, 0, 0x0},
	{"rAES_OUTDATA_01	", AES_REG_BASE + 0x20, 32, RO, DPDB, 0, 0x0},  
	{"rAES_OUTDATA_02	", AES_REG_BASE + 0x24, 32, RO, DPDB, 0, 0x0},  
	{"rAES_OUTDATA_03	", AES_REG_BASE + 0x28, 32, RO, DPDB, 0, 0x0},
	{"rAES_OUTDATA_04	", AES_REG_BASE + 0x2c, 32, RO, DPDB, 0, 0x0},
	{"rAES_IVDATA_01	", AES_REG_BASE + 0x30, 32, WO, DPDB, 0, 0x0},  
	{"rAES_IVDATA_02	", AES_REG_BASE + 0x34, 32, WO, DPDB, 0, 0x0},  
	{"rAES_IVDATA_03	", AES_REG_BASE + 0x38, 32, WO, DPDB, 0, 0x0},
	{"rAES_IVDATA_04	", AES_REG_BASE + 0x3c, 32, WO, DPDB, 0, 0x0},
	{"rAES_CNTDATA_01	", AES_REG_BASE + 0x40, 32, WO, DPDB, 0, 0x0},  
	{"rAES_CNTDATA_02	", AES_REG_BASE + 0x44, 32, WO, DPDB, 0, 0x0},  
	{"rAES_CNTDATA_03	", AES_REG_BASE + 0x48, 32, WO, DPDB, 0, 0x0},
	{"rAES_CNTDATA_04	", AES_REG_BASE + 0x4c, 32, WO, DPDB, 0, 0x0},
	{"rAES_KEYDATA_01	", AES_REG_BASE + 0x80, 32, WO, DPDB, 0, 0x0},  
	{"rAES_KEYDATA_02	", AES_REG_BASE + 0x84, 32, WO, DPDB, 0, 0x0},  
	{"rAES_KEYDATA_03	", AES_REG_BASE + 0x88, 32, WO, DPDB, 0, 0x0},
	{"rAES_KEYDATA_04	", AES_REG_BASE + 0x8c, 32, WO, DPDB, 0, 0x0},
	{"rAES_KEYDATA_05	", AES_REG_BASE + 0x90, 32, WO, DPDB, 0, 0x0},  
	{"rAES_KEYDATA_06	", AES_REG_BASE + 0x94, 32, WO, DPDB, 0, 0x0},  
	{"rAES_KEYDATA_07	", AES_REG_BASE + 0x98, 32, WO, DPDB, 0, 0x0},
	{"rAES_KEYDATA_08	", AES_REG_BASE + 0x9c, 32, WO, DPDB, 0, 0x0},	
	//TDES
	{"rTDES_CONF		", TDES_REG_BASE + 0x00, 10, RW, DPPB, 0x3FB, 0x0},  
	{"rTDES_STAT		", TDES_REG_BASE + 0x04, 3, RW, DPPB, 0, 0x0},	// It didn't read directly
	{"rTDES_KEY1_0		", TDES_REG_BASE + 0x10, 32, WO, DPDB, 0, 0x0},  
	{"rTDES_KEY1_1		", TDES_REG_BASE + 0x14, 32, WO, DPDB, 0, 0x0},	
	{"rTDES_KEY2_0		", TDES_REG_BASE + 0x18, 32, WO, DPDB, 0, 0x0},  
	{"rTDES_KEY2_1		", TDES_REG_BASE + 0x1c, 32, WO, DPDB, 0, 0x0},	
	{"rTDES_KEY3_0		", TDES_REG_BASE + 0x20, 32, WO, DPDB, 0, 0x0},  
	{"rTDES_KEY4_1		", TDES_REG_BASE + 0x24, 32, WO, DPDB, 0, 0x0},		
	{"rTDES_IV_0			", TDES_REG_BASE + 0x28, 32, WO, DPDB, 0, 0x0},  
	{"rTDES_IV_1			", TDES_REG_BASE + 0x2c, 32, WO, DPDB, 0, 0x0},		
	{"rTDES_INPUT_0		", TDES_REG_BASE + 0x30, 32, WO, DPDB, 0, 0x0},  
	{"rTDES_INPUT_1		", TDES_REG_BASE + 0x34, 32, WO, DPDB, 0, 0x0},	
	{"rTDES_OUTPUT_0	", TDES_REG_BASE + 0x38, 32, RO, DPDB, 0, 0x0},  
	{"rTDES_OUTPUT_1	", TDES_REG_BASE + 0x3c, 32, RO, DPDB, 0, 0x0},		
	//HASH
	{"rHASH_CONTROL1	", HASH_REG_BASE + 0x00, 6, RW, DPPB, 0, 0x0},  
	{"rHASH_CONTROL2	", HASH_REG_BASE + 0x04, 4, WO, DPPB, 0, 0x0},
	{"rHASH_FIFO_MODE	", HASH_REG_BASE + 0x08, 1, RW, DPDB, 0, 0x0},  
	{"rHASH_BYTE_SWAP	", HASH_REG_BASE + 0x0c, 4, RW, DPPB, 0xE, 0x0},	
	{"rHASH_STATUS		", HASH_REG_BASE + 0x10, 32, RO, DPDB, 0, 0x0},  
	{"rHASH_MSG_SZ_LOW	", HASH_REG_BASE + 0x14, 32, RW, DPDB, 0, 0x0},	
	{"rHASH_MSG_SZ_HIGH", HASH_REG_BASE + 0x18, 32, RW, DPDB, 0, 0x0},  
	{"rHASH_DATA_IN1	", HASH_REG_BASE + 0x20, 32, WO, DPDB, 0, 0x0},		
	{"rHASH_DATA_IN2	", HASH_REG_BASE + 0x24, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_DATA_IN3	", HASH_REG_BASE + 0x28, 32, WO, DPDB, 0, 0x0},		
	{"rHASH_DATA_IN4	", HASH_REG_BASE + 0x2c, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_DATA_IN5	", HASH_REG_BASE + 0x30, 32, WO, DPDB, 0, 0x0},	
	{"rHASH_DATA_IN6	", HASH_REG_BASE + 0x34, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_DATA_IN7	", HASH_REG_BASE + 0x38, 32, WO, DPDB, 0, 0x0},		
	{"rHASH_DATA_IN8	", HASH_REG_BASE + 0x3c, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_SEED_IN1	", HASH_REG_BASE + 0x40, 32, WO, DPDB, 0, 0x0},
	{"rHASH_SEED_IN2	", HASH_REG_BASE + 0x44, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_SEED_IN3	", HASH_REG_BASE + 0x48, 32, WO, DPDB, 0, 0x0},	
	{"rHASH_SEED_IN4	", HASH_REG_BASE + 0x4c, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_SEED_IN5	", HASH_REG_BASE + 0x50, 32, WO, DPDB, 0, 0x0},	
	{"rHASH_RESULT_1	", HASH_REG_BASE + 0x60, 32, RO, DPDB, 0, 0x0},  
	{"rHASH_RESULT_2	", HASH_REG_BASE + 0x64, 32, RO, DPDB, 0, 0x0},		
	{"rHASH_RESULT_3	", HASH_REG_BASE + 0x68, 32, RO, DPDB, 0, 0x0},  
	{"rHASH_RESULT_4	", HASH_REG_BASE + 0x6c, 32, RO, DPDB, 0, 0x0},		
	{"rHASH_RESULT_5	", HASH_REG_BASE + 0x70, 32, RO, DPDB, 0, 0x0},  
	{"rHASH_PRNG_1		", HASH_REG_BASE + 0x80, 32, RO, DPDB, 0, 0x0},	
	{"rHASH_PRNG_2		", HASH_REG_BASE + 0x84, 32, RO, DPDB, 0, 0x0},  
	{"rHASH_PRNG_3		", HASH_REG_BASE + 0x88, 32, RO, DPDB, 0, 0x0},			
	{"rHASH_PRNG_4		", HASH_REG_BASE + 0x8c, 32, RO, DPDB, 0, 0x0},  
	{"rHASH_PRNG_5		", HASH_REG_BASE + 0x90, 32, RO, DPDB, 0, 0x0},		
	{"rHASH_IV_1			", HASH_REG_BASE + 0xa0, 32, WO, DPDB, 0, 0x0},		
	{"rHASH_IV_2			", HASH_REG_BASE + 0xa4, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_IV_3			", HASH_REG_BASE + 0xa8, 32, WO, DPDB, 0, 0x0},	
	{"rHASH_IV_4			", HASH_REG_BASE + 0xac, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_IV_5			", HASH_REG_BASE + 0xb0, 32, WO, DPDB, 0, 0x0},			
	{"rHASH_PREMSG_H	", HASH_REG_BASE + 0xc0, 32, WO, DPDB, 0, 0x0},  
	{"rHASH_PREMSG_L	", HASH_REG_BASE + 0xc4, 32, WO, DPDB, 0, 0x0},	
	//PKA
	{"rPKA_SFR0			", PKA_REG_BASE + 0x00, 7, RW, DPPB, 0x7b, 0x0},  
	{"rPKA_SFR1			", PKA_REG_BASE + 0x04, 4, RW, DPPB, 9, 0x0},
	{"rPKA_SFR2			", PKA_REG_BASE + 0x08, 32, RW, DPPB, 0x1f1f1f1f, 0x0},  
	{"rPKA_SFR3			", PKA_REG_BASE + 0x0c, 30, RW, DPDB, 0, 0x0},	
	{"rPKA_SFR4			", PKA_REG_BASE + 0x10, 7, RW, DPPB, 0x61, 0x0}, 
	
};

void TestSSS_SFR(void)
{
	volatile u32 *pAddr;	
	s32 i,j, count = sizeof(SSSRegInfo)/sizeof(REGINFO), nPattern;
	u32 uRegStatus, uWritePatternWithMask, uReadWithMask;	
	
	
	
	u32 uPatternShitfOneBit[] = 
	{
		0x00000001,		0x00000002,		0x00000004,		0x00000008,		0x00000010,		0x00000020,		0x00000040,		0x00000080,
		0x00000100,		0x00000200,		0x00000400,		0x00000800,		0x00001000,		0x00002000,		0x00004000,		0x00008000,
		0x00010000,		0x00020000,		0x00040000,		0x00080000,		0x00100000,		0x00200000,		0x00400000,		0x00800000,
		0x01000000,		0x02000000,		0x04000000,		0x08000000,		0x10000000,		0x20000000,		0x40000000,		0x80000000,
	};
	
	u32 uDefaultBitMask[] =
	{
		0x00000001,		0x00000003,		0x00000007,		0x0000000F,		0x0000001F,		0x0000003F,		0x0000007F,		0x000000FF,
		0x000001FF,		0x000003FF,		0x000007FF,		0x00000FFF,		0x00001FFF,		0x00003FFF,		0x00007FFF,		0x0000FFFF,
		0x0001FFFF,		0x0003FFFF,		0x0007FFFF,		0x000FFFFF,		0x001FFFFF,		0x003FFFFF,		0x007FFFFF,		0x00FFFFFF,
		0x01FFFFFF,		0x03FFFFFF,		0x07FFFFFF,		0x0FFFFFFF,		0x1FFFFFFF,		0x3FFFFFFF,		0x7FFFFFFF,		0xFFFFFFFF,
	};

	
	for(i=0; i<count; i++)
	{		
		pAddr = (u32*)SSSRegInfo[i].uAddr;		
		
		if(SSSRegInfo[i].uFlag == DPDB)
		{		
			if(SSSRegInfo[i].uRWType == RW)
			{
				for(j=0; j< SSSRegInfo[i].uBitLen ; j++)
				{			
					uWritePatternWithMask = (uPatternShitfOneBit[j] &uDefaultBitMask[j]);
					*pAddr = uWritePatternWithMask;					
					
					uReadWithMask = (*pAddr & uDefaultBitMask[j]);	
					SSSRegInfo[i].rValue = uReadWithMask;
					
					uRegStatus = (	uWritePatternWithMask !=uReadWithMask );					
					RPRINTF(SSSRegInfo[i], uPatternShitfOneBit[j], uRegStatus, j, 1);
				}
			}
		}		
		else if(SSSRegInfo[i].uFlag == DPPB)
		{		
			nPattern = (sizeof(uPatternShitfOneBit)/sizeof(uPatternShitfOneBit[0]));			
			if(SSSRegInfo[i].uRWType == RW)
			{
				for(j=0; j<nPattern; j++)
				{
					if(uPatternShitfOneBit[j] & SSSRegInfo[i].uPrivateBitMask)
					{
						uWritePatternWithMask = (uPatternShitfOneBit[j] & SSSRegInfo[i].uPrivateBitMask);
						*pAddr = uWritePatternWithMask;
						
						uReadWithMask = (*pAddr & SSSRegInfo[i].uPrivateBitMask);
						SSSRegInfo[i].rValue = uReadWithMask;
						
						uRegStatus = (	uWritePatternWithMask != uReadWithMask );												
						RPRINTF(SSSRegInfo[i], uPatternShitfOneBit[j], uRegStatus, j, 1);					
					}
				}
			}			
		}					
	}
	UART_Printf("\n\nTest Complete!\n\n");

	
}



// Added temperary.. It must be added system.c  or library.c
#if 1
void InvalidDataCache(void)
{
	register unsigned int temp;
	
	temp = 0;
	
	__asm {
		MCR p15, 0, temp, c7, c14, 0
	}
}

void InvalidDCacheAddrRange(u32 uStartAddr, u32 uEndAddr )
{
	__asm {
		MCRR p15, 0, uEndAddr, uStartAddr, c6
	}
}

u32 byteswap(u32 swap)
{
	return ((swap&0xff)<<24)|((swap&0xff00)<<8)|((swap&0xff0000)>>8)|(swap>>24);
}

void byteswaplen(u32 *source_addr, u32 *dest_addr, u32 length)
{
	u32 i;
	
	for(i=0; i<length; i++)
		*dest_addr++ = byteswap(*source_addr++);
}


//pka.c
u32 ReadWordFromBigBus(char* p) {       // Reads Unaligned Big Endian Words
	u32 buf;
	if ((u32)p & 3) {       // if unaligned
		buf = (buf << 8) | (u32)(*p++);
		buf = (buf << 8) | (u32)(*p++);
		buf = (buf << 8) | (u32)(*p++);
		buf = (buf << 8) | (u32)(*p++);
		return buf;
	} else {
		return *(u32*)p;
	}
}

u32 ReadWordFromLittleBus(char* p) {    // Reads Unaligned Little Endian Words
	u32 buf;
	if ((u32)p & 3) {       // if unaligned
		buf = (buf >> 8) | ((u32)(*p++) << 24);
		buf = (buf >> 8) | ((u32)(*p++) << 24);
		buf = (buf >> 8) | ((u32)(*p++) << 24);
		buf = (buf >> 8) | ((u32)(*p++) << 24);
		return buf;
	} else {
		return *(u32*)p;
	}
}

void WriteWordToBigBus(char* p, u32 i) {     // Writes Unaligned Big Endian Words
	if ((u32)p & 3) {       // if unaligned
		*p++ = (char)(i >> 24);
		*p++ = (char)(i >> 16);
		*p++ = (char)(i >> 8);
		*p++ = (char)(i);
	} else {
		*((u32*)p) = i;
	}
}

void WriteWordToLittleBus(char* p, u32 i) {   // Writes Unaligned Little Endian Words
	if ((u32)p & 3) {       // if unaligned
		*p++ = (char)(i);
		*p++ = (char)(i >> 8);
		*p++ = (char)(i >> 16);
		*p++ = (char)(i >> 24);
	} else {
		*((u32*)p) = i;
	}
}


u32 ReadWord(char* p) {           // Reads Unaligned Words
	return ReadWordFromLittleBus(p);

}

void WriteWord(char* p, u32 i) {   // Writes Unaligned Words

	WriteWordToLittleBus(p, i);

}

#endif





/////////////////////////////////////////////////////////////////////////
//				AES Function
////////////////////////////////////////////////////////////////////////

//////////
// Function Name : SBLK_AES
// Function Description : 
// 				
// 
// Input : 				
// Output : NONE
// Version : 
// (aes)

void SBLK_AES(u32 control, u32 *key, u32 *iv, u32 *cnt,
			u32 *source_addr, u32 *dest_addr, u32 *golden_addr, u32 length)
{
	u32 i,j;
	u32 *pDstAddr;
	
	Assert ((length & 3)==0);

	// modified by jwj
	if ((control >> 6)&0x1)				// Key Change Mode
	{
		SblkOutp32(rAES_CONTROL, control);
	}
	else									// Key Not Change Mode
	{
		SblkOutp32(rAES_CONTROL, control |(1<<6));		// for initial Key setting
	}

	
	if (control & AES_256)
	{
		pDstAddr = (u32 *)rAES_KEYDATA_01;
		for(i=0; i<8; i++)
			SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 
		key -= 8;
	}	
	else if (control & AES_192)
	{
		pDstAddr = (u32 *)rAES_KEYDATA_03;
		for(i=0; i<6; i++)
			SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 
		key -= 6;
	}	
	else
	{
		pDstAddr = (u32 *)rAES_KEYDATA_05;
		for(i=0; i<4; i++)
			SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 
		key -= 4;
	}	

	
	if (control & AES_CBC)
	{
		pDstAddr = (u32 *)rAES_IVDATA_01;
		for (i=0; i<4; i++)
			SblkOutp32(pDstAddr++, (control & AES_SWAP_IV)? *iv++:byteswap(*iv++));
	}	
	else if (control & AES_CTR)
	{
		pDstAddr = (u32 *)rAES_CNTDATA_01;	
		for (i=0; i<4; i++)
			SblkOutp32(pDstAddr++, (control & AES_SWAP_CNT)? *cnt++:byteswap(*cnt++));
	}
	
	if (control & AES_DMA)
	{
		// Interrupt Enable
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SblkOutp32(rFCINTPEND, 0xf);
		SBLK_EnDMAINT(BTDMA);
		g_SDma1Done =0;

	
		SblkOutp32(rFCBRDMAC, 0x1);		// Flush ??
		SblkOutp32(rFCBTDMAC, 0x1);		// Flush
		SblkOutp32(rFCBRDMAC, 0x0);
		SblkOutp32(rFCBTDMAC, 0x0);
	
		SblkOutp32(rFCFIFOCTRL, 0x0);
		
			
		if (!(control & AES_SWAP_DI))
		{
			byteswaplen(source_addr, (u32 *)INPUT_BUF, length);
			SblkOutp32(rFCBRDMAS, INPUT_BUF);
		}
		else 
			SblkOutp32(rFCBRDMAS, (u32)source_addr);

		SblkOutp32(rFCBTDMAS, (u32)dest_addr);
		SblkOutp32(rFCBTDMAL, 16);
		SblkOutp32(rFCBRDMAL, 16);

		while(g_SDma1Done ==0);
		g_SDma1Done=0;

		#if 0	// Polling
		while(!(Inp32(rFCINTPEND) & 0x4));
		SblkOutp32(rFCINTPEND, 0x4);
		#endif
		
		#if 0
		//SblkOutp32(rAES_CONTROL, control & ~AES_CHANGE);
		#endif
		#if 0 		// PASS
			if (((control >> 6)&0x1 == 0x0))	// Key is not changed option
				{SblkOutp32(rAES_CONTROL, control & ~AES_CHANGE);}
			else if (((control >> 6)&0x1 == 0x1))	// Key Change mode
				{
					//SblkOutp32(rAES_CONTROL, control);
					
				}
		#endif
		
		#if 1 		// Fail At KeyChange mode & AES192, 256
			if (((control >> 6)&0x1 == 0x0))	// Key is not changed option
				{SblkOutp32(rAES_CONTROL, control & ~AES_CHANGE);}
			else if (((control >> 6)&0x1 == 0x1))	// Key Change mode
				{
					// SblkOutp32(rAES_CONTROL, control);	// fail
				
					//SblkOutp32(rAES_CONTROL, control & ~AES_CHANGE);
					//SblkOutp32(rAES_CONTROL, control);					
					// Key values are re initialize for just test.
					if (control & AES_256)
					{
						pDstAddr = (u32 *)rAES_KEYDATA_01;
						for(j=0; j<8;j++)
						SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 
					}	
					else if (control & AES_192)
					{
						pDstAddr = (u32 *)rAES_KEYDATA_03;
						for(j=0; j<6; j++)
						SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 
					}	
					else
					{
						pDstAddr = (u32 *)rAES_KEYDATA_05;
						for(j=0; j<4; j++)
						SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 	
					}	
				}
		#endif
		
		SblkOutp32(rFCBTDMAL, (length<<2) - 16);
		SblkOutp32(rFCBRDMAL, (length<<2) - 16);
		
		#if 0
		while(!(Inp32(rFCINTPEND) & 0x4));
		SblkOutp32(rFCINTPEND, 0x4);
		#endif
		
		while(g_SDma1Done ==0);
		g_SDma1Done=0;
		
		if (!(Inp32(rAES_CONTROL) & AES_SWAP_DO))
			byteswaplen(dest_addr, dest_addr, length);
	}
	else
	{
		for(i=0; i<length; i+=4)
		{

			#if 0
			if(i==4)
				SblkOutp32(rAES_CONTROL, control & ~AES_CHANGE);

			#endif

			#if 1 //// Fail At KeyChange mode & AES192, 256
			if ((i==4)&& ((control >> 6)&0x1 == 0x0))	// Key is not changed option
				{SblkOutp32(rAES_CONTROL, control & ~AES_CHANGE);}
			else if ((i==4)&& ((control >> 6)&0x1 == 0x1))	// Key Change mode
				{
					//SblkOutp32(rAES_CONTROL, control);	//fail

					//SblkOutp32(rAES_CONTROL, control & ~AES_CHANGE);
					//SblkOutp32(rAES_CONTROL, control);	
					
					// Key values are re initialize for just test.
					if (control & AES_256)
					{
						pDstAddr = (u32 *)rAES_KEYDATA_01;
						for(j=0; j<8;j++)
						SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 
					}	
					else if (control & AES_192)
					{
						pDstAddr = (u32 *)rAES_KEYDATA_03;
						for(j=0; j<6; j++)
						SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 
					}	
					else
					{
						pDstAddr = (u32 *)rAES_KEYDATA_05;
						for(j=0; j<4; j++)
						SblkOutp32(pDstAddr++, (control & AES_SWAP_KEY)? *key++:byteswap(*key++)); 	
					}	
				}
			#endif		

			#if 0 	// PASS
			if ((i==4)&& ((control >> 6)&0x1 == 0x0))	// Key is not changed option
				{SblkOutp32(rAES_CONTROL, control & ~AES_CHANGE);}
			else if ((i==4)&& ((control >> 6)&0x1 == 0x1))	// Key Change mode
				{
					//SblkOutp32(rAES_CONTROL, control);
				}
			#endif		

			
		
			SblkOutp32(rAES_INDATA_01, (control & AES_SWAP_DI)? *source_addr++:byteswap(*source_addr++));
			SblkOutp32(rAES_INDATA_02, (control & AES_SWAP_DI)? *source_addr++:byteswap(*source_addr++));
			SblkOutp32(rAES_INDATA_03, (control & AES_SWAP_DI)? *source_addr++:byteswap(*source_addr++));
			SblkOutp32(rAES_INDATA_04, (control & AES_SWAP_DI)? *source_addr++:byteswap(*source_addr++));
			
					
			while(!(Inp32(rAES_STATUS)& OUT_RDY));
		
			*dest_addr++ =(control & AES_SWAP_DO)? Inp32(rAES_OUTDATA_01):byteswap(Inp32(rAES_OUTDATA_01));
			*dest_addr++ =(control & AES_SWAP_DO)? Inp32(rAES_OUTDATA_02):byteswap(Inp32(rAES_OUTDATA_02));
			*dest_addr++ =(control & AES_SWAP_DO)? Inp32(rAES_OUTDATA_03):byteswap(Inp32(rAES_OUTDATA_03));
			*dest_addr++ =(control & AES_SWAP_DO)? Inp32(rAES_OUTDATA_04):byteswap(Inp32(rAES_OUTDATA_04));

			SblkOutp32(rAES_STATUS, OUT_RDY);			
			
		}  
		dest_addr -= length;  
	}
	
	if (Compare((u32)dest_addr, (u32)golden_addr, length))
		Disp ("P A S S ! (AES_control = 0x%x)\n", Inp32(rAES_CONTROL));
	else
		Disp ("F A I L ! (AES_control = 0x%x)\n", Inp32(rAES_CONTROL));
}





/////////////////////////////////////////////////////////////////////////
//				TDES Function
////////////////////////////////////////////////////////////////////////

//////////
// Function Name : SBLK_DES
// Function Description : 
// 				
// 
// Input : 				
// Output : NONE
// Version : 
// (des)
void SBLK_DES(u32 control, u32 *key, u32 *iv, 
			u32 *source_addr, u32 *dest_addr, u32 *golden_addr, u32 length)
{
	u32 i,key_len;
	u32 *pDstAddr;
	
	Assert ((length & 1)==0);

	SblkOutp32(rTDES_CONF, control);
	
	key_len = (control & DES_TDES)? 6:2;

	pDstAddr = (u32 *)rTDES_KEY1_0;
	for (i=0; i<key_len; i++)
		SblkOutp32(pDstAddr++, (control & DES_SWAP_KEY)? *key++:byteswap(*key++));
		
	if (control & DES_CBC)
	{
		pDstAddr = (u32 *)rTDES_IV_0;
		for (i=0; i<2; i++)
			SblkOutp32(pDstAddr++, (control & DES_SWAP_IV)? *iv++:byteswap(*iv++));
	}		 
	
	if (control & DES_DMA)
	{

		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SblkOutp32(rFCINTPEND, 0xf);
		SBLK_EnDMAINT(BTDMA);
		g_SDma1Done =0;
	
		SblkOutp32(rFCBRDMAC, 0x1);		// Flush ??
		SblkOutp32(rFCBTDMAC, 0x1);		// Flush
		SblkOutp32(rFCBRDMAC, 0x0);
		SblkOutp32(rFCBTDMAC, 0x0);
	
		SblkOutp32(rFCFIFOCTRL, 0x4);	// DES Select
		
		if (!(control & DES_SWAP_DI))
		{
			byteswaplen(source_addr, (u32 *)INPUT_BUF, length);
			SblkOutp32(rFCBRDMAS, INPUT_BUF);
		}
		else 
			SblkOutp32(rFCBRDMAS, (u32)source_addr);

		SblkOutp32(rFCBTDMAS, (u32)dest_addr);
		SblkOutp32(rFCBTDMAL, length <<2);
		SblkOutp32(rFCBRDMAL, length <<2);

		#if 0
		while(!(Inp32(rFCINTPEND) & 0x4));
		SblkOutp32(rFCINTPEND, 0x4);
		#endif
		while(g_SDma1Done ==0);
		g_SDma1Done=0;
	
		if (!(control & DES_SWAP_DO))
			byteswaplen(dest_addr, dest_addr, length);
	}
	else
	{
		for(i=0; i<length; i+=2)
		{
			SblkOutp32(rTDES_INPUT_0, (control & DES_SWAP_DI)? *source_addr++:byteswap(*source_addr++));
			SblkOutp32(rTDES_INPUT_1, (control & DES_SWAP_DI)? *source_addr++:byteswap(*source_addr++));
			
			while(!(Inp32(rTDES_STAT) & OUT_RDY));
		
			*dest_addr++ =(control & DES_SWAP_DO)? Inp32(rTDES_OUTPUT_0):byteswap(Inp32(rTDES_OUTPUT_0));
			*dest_addr++ =(control & DES_SWAP_DO)? Inp32(rTDES_OUTPUT_1):byteswap(Inp32(rTDES_OUTPUT_1));
			
			SblkOutp32(rTDES_STAT, OUT_RDY);
		}  
		dest_addr -= length;  
	}
	
	if (Compare((u32)dest_addr, (u32)golden_addr, length))
		Disp ("P A S S ! (DES_ADDR_CONF = 0x%x)\n", Inp32(rTDES_CONF));
	else
		Disp ("F A I L ! (DES_ADDR_CONF = 0x%x)\n", Inp32(rTDES_CONF));
}


/////////////////////////////////////////////////////////////////////////
//				HASH Function
////////////////////////////////////////////////////////////////////////

//////////
// Function Name : SBLK_CalcBlocks_words
// Function Description : 
// 				Given the message size in bytes, this function calculates
// 				the number of full blocks (x) and the number of remaining 
// 				words that are smaller than a block (y).
// Partial words (1 ~ 3 bytes) are rounded up.
// Input : 				msg_size 
//						*x : number of blocks
//						*y :	remained word
// Output : NONE
// Version : 
// (calc_blocks_words)
void SBLK_CalcBlocks_words(u32 msg_size, u32 * x, u32 * y)
{
	u32 total_words;

    	total_words = (msg_size + 3) >> 2;
    
	*x = total_words >> 4;
	*y = total_words & 0xF;
    
	return;
}


//////////
// Function Name : SBLK_DoPartial_Hash
// Function Description : 
//			 Multi-part hashing
// 			Assume there are two parts.
// Partial words (1 ~ 3 bytes) are rounded up.
// Input : 				ALG_SHA1, ALG_MD5
//						*msg_addr : Address
//						msg_size:	Message Word
// Output : NONE
// Version : 
// (do_partial_hash)

void SBLK_DoPartial_Hash(ALG_TYPE alg, u32 *msg_addr, u32 msg_size)
{
	u32 uRegValue;
	u32 partial_result[5];
	u32 i;
	u32 num_blocks;
	u32 remain_words;
    
	Assert(msg_size!=0);
    
    //-----------------------------------------------------
    // Part 1: 64 bytes
    //-----------------------------------------------------
    
    // Set the engine and the start/init bit together
	if(alg==ALG_SHA1)
	{
       	 uRegValue = HASH_START_BIT | ENG_SHA1_HASH;
	}
	else
	{
       	 uRegValue = HASH_START_BIT | ENG_MD5_HASH;
	}
    
	SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);	// Hash engine is designed with big endian, so it must be setted    
	SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Disable the FIFO mode
	SblkOutp32(rHASH_FIFO_MODE_EN, 0x0);
    
    // Set the message size to a BIG value
	SblkOutp32(rHASH_MSG_SIZE_LOW, 0x0);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x80000000);  // BIG
    
    // Set pre_msg_leng to 0
	SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
	SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
    
    // Data input: 64 bytes = 16 words
	Copy((u32)msg_addr,    rHASH_DATA_IN_1, 8);
	Copy((u32)(msg_addr+8), rHASH_DATA_IN_1, 8);
    
    // set the "pause" signal	(?)						
	uRegValue = HASH_PAUSE;
	SblkOutp32(rHASH_CONTROL_2, uRegValue);
    
    // Poll the "partial_done" signal
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & PARTIAL_DONE));
    
   // SblkOutp32(rHASH_STATUS, (uRegValue & ~PARTIAL_DONE));		// (jwj) it must be checked!!!
    SblkOutp32(rHASH_STATUS, (uRegValue & PARTIAL_DONE));		// (jwj) it must be checked!!!
    
    // save the partial result
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, (u32)partial_result, 5);
    }
    else	// MD5
    {
        Copy(rHASH_RESULT_1, (u32)partial_result, 4);
    }
    
    
    // wait for some time    -> (jwj)why & It must be checked
    for(i=0; i<200; i++) ;
    
    
    //-------------------------------------------
    // Part 2 (last part): all the remaining bytes
    //-------------------------------------------
    
    // Restore parameters
    SblkOutp32(rHASH_MSG_SIZE_LOW, (msg_size-64) );
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0);

    SblkOutp32(rHASH_PRE_MSG_LENG_LOW,  64*8);	//(jwj) Byte Order??
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
    
    
    if(alg==ALG_SHA1)
    {
        Copy((u32)partial_result, rHASH_IV_1, 5);
    }
    else
    {
        Copy((u32)partial_result, rHASH_IV_1, 4);
    }
    
    // set the "user_iv_en" and the "start/init" bit together
    if(alg==ALG_SHA1)
    {
        uRegValue = HASH_USER_IV_EN | HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_USER_IV_EN | HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    
    // Data input of part 2 (should be 188-64=124 bytes)
    
    // Calculate the number of blocks and the number of remaining words
    SBLK_CalcBlocks_words((msg_size-64), &num_blocks, &remain_words);
      
    // Data input for the whole blocks
    for(i=0; i<num_blocks; i++)
    {
        if(i!=0)
        {
            // Poll "buf_ready"
            do
            {
                SblkInp32(rHASH_STATUS, uRegValue);
            }while(!(uRegValue & BUFFER_READY));
        }
        
        // Data input: 8-word burst x 2
        Copy((u32)(msg_addr + 16 + i*16),   rHASH_DATA_IN_1, 8);
        Copy((u32)(msg_addr + 16 + i*16+8), rHASH_DATA_IN_1, 8);
    }
    
    if(remain_words!=0)
    {
        // Poll "buf_ready"
        if(num_blocks!=0)
        {
            do
            {
                SblkInp32(rHASH_STATUS, uRegValue);
            }
            while(!(uRegValue & BUFFER_READY));
        }
    
        // Data input: <16 words
        if(remain_words>8)
        {
            Copy( (u32)(msg_addr+ 16 +num_blocks*16), rHASH_DATA_IN_1, 8);
            Copy( (u32)(msg_addr+ 16 +num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
        }
        else
        {
            Copy( (u32)(msg_addr+ 16 +num_blocks*16), rHASH_DATA_IN_1, remain_words);
        }
    }
    
    // Poll the "done" signal
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & MSG_DONE));
    
    // Read and save the result. SHA1 = 5 words, MD5 = 4 words
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, OUTPUT_BUF, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, OUTPUT_BUF, 4);
    }
    
    // clear pre_msg_leng (don't forget this step!!!)
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
}


//////////
// Function Name : SBLK_DoPartial_Hmac
// Function Description : 
// 				multi-part HMAC test
// 				just 2 parts:  part 1 = key(64 bytes)
//            		part 2 = message(XXX bytes)
// Partial words (1 ~ 3 bytes) are rounded up.
// Input : 				ALG_SHA1, ALG_MD5
//						msg_size,key_size,msg_addr,hmac_key
// Output : NONE
// Version : 
// (do_partial_hash)


void SBLK_DoPartial_Hmac(ALG_TYPE alg, u32 msg_size, u32 key_size, u32 *msg_addr, u32 *hmac_key)
{
    u32 uRegValue;
    u32 i;
    u32 inner_result[5];
    u32 partial_result[5];
    u32 num_blocks;
    u32 remain_words;
    
    Assert(key_size==64);

    //------------------------------------------------------
    // inner hash, part 1
    //------------------------------------------------------
    
    // Set the engine and the start/init bit together
    if(alg==ALG_SHA1)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HMAC_INNER;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HMAC_INNER;
    }
    SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Disable the FIFO mode
     SblkOutp32(rHASH_FIFO_MODE_EN, 0x0);
    
    // Set the message size to a BIG value
    SblkOutp32(rHASH_MSG_SIZE_LOW, 0x0 );
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x80000000);
    
    // set pre_msg_leng to 0
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0 );
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0 );
      
    // Input the key using 2 bursts
    Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
    Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8);
    
    // set the "pause" bit
    SblkOutp32(rHASH_CONTROL_2, HASH_PAUSE);
    
    // poll the "partial_done" signal
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    } while(!(uRegValue & PARTIAL_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & PARTIAL_DONE));
    
    // Save the partial result
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, (u32)partial_result, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, (u32)partial_result, 4);
    }
    
    // wait for some time
    for(i=0; i<200; i++) ;			 // wait for some time    -> (jwj)why & It must be checked
    
    
    //------------------------------------------------------
    // inner hash, part 2
    //------------------------------------------------------
    
    // Write IV_1 ~ IV_5
    if(alg==ALG_SHA1)
    {
        Copy((u32)partial_result, rHASH_IV_1, 5);
    }
    else
    {
        Copy((u32)partial_result, rHASH_IV_1, 4);
    }
    
    // set the message size to the correct value
    SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size );
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0);
    
    // set pre_msg_leng to the correct value
   SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
   SblkOutp32(rHASH_PRE_MSG_LENG_LOW,  64*8);
   
    // Change the engine to "HASH". set start/init and user_iv_en together.
    if(alg==ALG_SHA1)
    {
        uRegValue = HASH_USER_IV_EN |HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_USER_IV_EN | HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Calculate the number of blocks and the number of remaining words
    SBLK_CalcBlocks_words(msg_size, &num_blocks, &remain_words);
    
    // Data input for the whole blocks
    for(i=0; i<num_blocks; i++)
    {
        if(i!=0)
        {
            // Poll "buf_ready"
            do
            {
                SblkInp32(rHASH_STATUS, uRegValue);
            }while(!(uRegValue & BUFFER_READY));
        }
        
        // Data input: 8-word burst x 2
        Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
        Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    }
    
    if(remain_words!=0)
    {
        // Poll "buf_ready"
        if(num_blocks!=0)
        {
            do
            {
                SblkInp32(rHASH_STATUS, uRegValue);
            }
            while(!(uRegValue & BUFFER_READY));
        }
    
        // Data input: <16 words
        if(remain_words>8)
        {
            Copy( (u32)(msg_addr + num_blocks*16),     rHASH_DATA_IN_1, 8);
            Copy( (u32)(msg_addr + num_blocks*16 + 8), rHASH_DATA_IN_1, (remain_words-8));
        }
        else
        {
            Copy( (u32)(msg_addr + num_blocks*16), rHASH_DATA_IN_1, remain_words);
        }
    }
    
    // Poll the "done" signal
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & MSG_DONE));
    
    // Read and save the inner hash result. SHA1 = 5 words, MD5 = 4 words
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, (u32)inner_result, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, (u32)inner_result, 4);
    }
    
    // clear pre_msg_leng
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW,  0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
    
    
    //------------------------------------------------------
    // outer hash, done in one shot
    // the code is just copied from do_hmac_cpu().
    //------------------------------------------------------

    // Set the engine and the start/init bit together
    if(alg==ALG_SHA1)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HMAC_OUTER;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HMAC_OUTER;
    }
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue); 
        
    // Disable the FIFO mode
    SblkOutp32(rHASH_FIFO_MODE_EN, 0x0); 
    
    // Set the message size in bytes. SHA1: 84 bytes, MD5: 80 bytes
    if(alg==ALG_SHA1)
    {
        Outp32(rHASH_MSG_SIZE_LOW, 84 );
        Outp32(rHASH_MSG_SIZE_HIGH, 0x0);
    }
    else
    {
        Outp32(rHASH_MSG_SIZE_LOW, 80 );
        Outp32(rHASH_MSG_SIZE_HIGH, 0x0);
    }
    
    // Input the key using 2 bursts
    Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
    Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8);
        
    // Poll the "buf_ready" signal before writing the inner result.
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & BUFFER_READY));
    
    // Write the inner hash result
    if(alg==ALG_SHA1)
    {
        Copy((u32)inner_result, rHASH_DATA_IN_1, 5);
    }
    else
    {
        Copy((u32)inner_result, rHASH_DATA_IN_1, 4);
    }
    
    // Poll the "done" signal
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & MSG_DONE));
    
    // Save the final result
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, OUTPUT_BUF, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, OUTPUT_BUF, 4);
    }
}


//////////
// Function Name : SBLK_DoConcur_HashnCipher
// Function Description : 
//			concurrent enc/dec and hash
// 			The data at source_addr is sent to DES for encryption and the ciphertext is 
// 			saved at dest_addr. At the same time, the data is also sent to the hash engine
// 			and the hash result is saved at hash_addr.
// 			Partial words (1 ~ 3 bytes) are rounded up.
// Input : 	ALG_SHA1, ALG_MD5
//			source_addr: address of the plaintext
// 			dest_addr:   address to save the ciphertext
// 			hash_addr:   address to save the hash result
// 			size:        size of plaintext/ciphertext in bytes						
// Output : NONE
// Version : 
// (do_adv_case_1)

void SBLK_DoConcur_HashnCipher(SBLK eBlkChipher, OPER_MODE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size)
{
    u32 uRegValue;
    //u32 uDir;
  

    if(eBlkChipher.m_eSblkType == DES)
    {
    //-------------------------------------------------------
    // DES configuration
    //-------------------------------------------------------
	uRegValue = ((0xf<<6) |(1<<5)|(0<<4)|(0<<3)|					// Byte Swap, DMA 
		             ((eBlkChipher.m_eOperMode == ECB)? (0<<1):(1<<1))|
	          	      ((eBlkChipher.m_eDir == ENC)?0:1));
	SblkOutp32(rTDES_CONF, uRegValue);
      
	// DES key
	SblkOutp32(rTDES_KEY1_0, 0xf389d6c4);
	SblkOutp32(rTDES_KEY1_1, 0x088253e1);

	if(eBlkChipher.m_eOperMode == CBC)
	{
		SblkOutp32(rTDES_IV_0, 0xc74884a3);
		SblkOutp32(rTDES_IV_1, 0xbf185fd9);
	}
	
    }
   else if(eBlkChipher.m_eSblkType == TDES)
    {
    //-------------------------------------------------------
    // TDES configuration
    //-------------------------------------------------------
	uRegValue = ((0xf<<6) |(1<<5)|(1<<3)|						// Byte Swap, DMA 
			     ((eBlkChipher.m_eOperMode1 == EDE)? (0<<4):(1<<4))|					
		             ((eBlkChipher.m_eOperMode == ECB)? (0<<1):(1<<1))|
	          	      ((eBlkChipher.m_eDir == ENC)?0:1));
	SblkOutp32(rTDES_CONF, uRegValue);
      
	// DES key
	SblkOutp32(rTDES_KEY1_0, 0xf389d6c4);
	SblkOutp32(rTDES_KEY1_1, 0x088253e1);
	SblkOutp32(rTDES_KEY2_0, 0xd909da24);
	SblkOutp32(rTDES_KEY2_1, 0xe2cd5dd2);
	SblkOutp32(rTDES_KEY3_0, 0xae8d0cfb);
	SblkOutp32(rTDES_KEY3_1, 0x0179a778);

	if(eBlkChipher.m_eOperMode == CBC)
	{
		SblkOutp32(rTDES_IV_0, 0xc74884a3);
		SblkOutp32(rTDES_IV_1, 0xbf185fd9);
	}
    }  
    else if (eBlkChipher.m_eSblkType == AES)
    {
    //-------------------------------------------------------
    // AES configuration
    //-------------------------------------------------------

	if(eBlkChipher.m_eOperMode  == CTR)
	{
	uRegValue = ((0x1f<<7)|(1<<6)|(0x2<<4)|(1<<3)|					// Byte Swap, Key256, DMA		  
	           ((eBlkChipher.m_eOperMode== ECB)?(0<<1):(eBlkChipher.m_eOperMode==CBC)?(1<<1):(2<<1))|
	           (0<<0));
	}
	else
	{
	uRegValue = ((0x1f<<7)|(1<<6)|(0x2<<4)|(1<<3)|					// Byte Swap, Key256, DMA		  
	           ((eBlkChipher.m_eOperMode== ECB)?(0<<1):(eBlkChipher.m_eOperMode==CBC)?(1<<1):(2<<1))|
	           ((eBlkChipher.m_eDir == ENC)?0:1));
	}

    SblkOutp32(rAES_CONTROL, uRegValue);
      
    // AES key
    SblkOutp32(rAES_KEYDATA_01, 0x16157e2b);
    SblkOutp32(rAES_KEYDATA_02, 0xa6d2ae28);
    SblkOutp32(rAES_KEYDATA_03, 0x8815f7ab);
    SblkOutp32(rAES_KEYDATA_04, 0x3c4fcf09);
    SblkOutp32(rAES_KEYDATA_05, 0x16157e2b);
    SblkOutp32(rAES_KEYDATA_06, 0xa6d2ae28);
    SblkOutp32(rAES_KEYDATA_07, 0x8815f7ab);
    SblkOutp32(rAES_KEYDATA_08, 0x3c4fcf09);    

   // IV Data
   if(eBlkChipher.m_eOperMode == CBC)
   {
   	SblkOutp32(rAES_IVDATA_01, 0x03020100);
   	SblkOutp32(rAES_IVDATA_02, 0x07060504);
   	SblkOutp32(rAES_IVDATA_03, 0x0b0a0908);
   	SblkOutp32(rAES_IVDATA_04, 0x0f0e0d0c);
   }
   else if(eBlkChipher.m_eOperMode == CTR)
   {
	SblkOutp32(rAES_CNTDATA_01, 0xf3f2f1f0);
	SblkOutp32(rAES_CNTDATA_02, 0xf7f6f5f4);
	SblkOutp32(rAES_CNTDATA_03, 0xfbfaf9f8);
	SblkOutp32(rAES_CNTDATA_04, 0xfffefdfc);	
   } 
    
    }  

    
    //-------------------------------------------------------
    // hash configuration
    //-------------------------------------------------------
    
    // Set the engine and the start/init bit together
    if(alg==SHA1_HASH)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Enable the FIFO mode
    SblkOutp32(rHASH_FIFO_MODE_EN, 0x1);
    
    // Set the message size in bytes
    SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
    
    // set the pre_msg_leng
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);

    
    //-------------------------------------------------------
    // DMA configuration
    //-------------------------------------------------------
    
    // DESSEL=1 and HASHINSEL=2'b01
    if((eBlkChipher.m_eSblkType == DES)||(eBlkChipher.m_eSblkType == TDES))
    	SblkOutp32(rFCFIFOCTRL, (1<<2)|(1<<0));
    else if (eBlkChipher.m_eSblkType == AES)
    	SblkOutp32(rFCFIFOCTRL, (0<<2)|(1<<0));
    	
    // flush DMA
    SblkOutp32(rFCHRDMAC, 0x1);
    SblkOutp32(rFCHRDMAC, 0x0);
    SblkOutp32(rFCBRDMAC, 0x1);
    SblkOutp32(rFCBRDMAC, 0x0);
    SblkOutp32(rFCBTDMAC, 0x1);
    SblkOutp32(rFCBTDMAC, 0x0);
    
    // set BTDMA: addr, leng
    SblkOutp32(rFCBTDMAS, (u32)dest_addr);
    SblkOutp32(rFCBTDMAL, msg_size);
       
    // set BRDMA: addr, leng
    SblkOutp32(rFCBRDMAS, (u32)source_addr);
    SblkOutp32(rFCBRDMAL, msg_size);
    
    //-------------------------------------------------------
    // polling
    // make sure that both the ciphertext and the hash result are saved.
    //-------------------------------------------------------
    
    // Poll BTDMA PEND bit
    while(!(Inp32(rFCINTPEND) & 0x4));
    
    SblkInp32(rFCINTPEND, uRegValue);
    SblkOutp32(rFCINTPEND, uRegValue);  // clear the pend bit
        
    // Invalidate D-cache
    //InvalidDataCache();				// (JWJ) It must be check!!!
    
    // Poll hash
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & MSG_DONE));
    
    // copy the hash result to the specified address
    if(alg==SHA1_HASH)
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 4);
    }

    return;
}


//////////
// Function Name : SBLK_DoSeri_HashnCipher
// Function Description : 
// 				hash + block cipher case 2
// 				end/dec first, then hash
// 				The data at source_addr is sent to DES for decryption and the plaintext is 
// 				saved at dest_addr. The decryption result is also sent to the hash engine
// 				and the hash result is saved at hash_addr.
// Input : 	ALG_SHA1, ALG_MD5
// 				source_addr: address of the ciphertext
// 				dest_addr:   address to save the plaintext
// 				hash_addr:   address to save the hash result
// 				size:        size of plaintext/ciphertext in bytes					
// Output : NONE
// Version : 
// (do_adv_case_2)

void SBLK_DoSeri_HashnCipher(SBLK eBlkChipher, OPER_MODE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size)
{
    u32 uRegValue;

 if(eBlkChipher.m_eSblkType == DES)
    {
    //-------------------------------------------------------
    // DES configuration
    //-------------------------------------------------------
	uRegValue = ((0xf<<6) |(1<<5)|(0<<4)|(0<<3)|					// Byte Swap, DMA 
		             ((eBlkChipher.m_eOperMode == ECB)? (0<<1):(1<<1))|
	          	      ((eBlkChipher.m_eDir == ENC)?0:1));
	SblkOutp32(rTDES_CONF, uRegValue);
      
	// DES key
	SblkOutp32(rTDES_KEY1_0, 0xf389d6c4);
	SblkOutp32(rTDES_KEY1_1, 0x088253e1);

	if(eBlkChipher.m_eOperMode == CBC)
	{
		SblkOutp32(rTDES_IV_0, 0xc74884a3);
		SblkOutp32(rTDES_IV_1, 0xbf185fd9);
	}
	
    }
   else if(eBlkChipher.m_eSblkType == TDES)
    {
    //-------------------------------------------------------
    // TDES configuration
    //-------------------------------------------------------
	uRegValue = ((0xf<<6) |(1<<5)|(1<<3)|						// Byte Swap, DMA 
			     ((eBlkChipher.m_eOperMode1 == EDE)? (0<<4):(1<<4))|					
		             ((eBlkChipher.m_eOperMode == ECB)? (0<<1):(1<<1))|
	          	      ((eBlkChipher.m_eDir == ENC)?0:1));
	SblkOutp32(rTDES_CONF, uRegValue);
      
	// DES key
	SblkOutp32(rTDES_KEY1_0, 0xf389d6c4);
	SblkOutp32(rTDES_KEY1_1, 0x088253e1);
	SblkOutp32(rTDES_KEY2_0, 0xd909da24);
	SblkOutp32(rTDES_KEY2_1, 0xe2cd5dd2);
	SblkOutp32(rTDES_KEY3_0, 0xae8d0cfb);
	SblkOutp32(rTDES_KEY3_1, 0x0179a778);

	if(eBlkChipher.m_eOperMode == CBC)
	{
		SblkOutp32(rTDES_IV_0, 0xc74884a3);
		SblkOutp32(rTDES_IV_1, 0xbf185fd9);
	}
    }  
    else if (eBlkChipher.m_eSblkType == AES)
    {
    //-------------------------------------------------------
    // AES configuration
    //-------------------------------------------------------

	if(eBlkChipher.m_eOperMode  == CTR)
	{
	uRegValue = ((0x1f<<7)|(1<<6)|(0x2<<4)|(1<<3)|					// Byte Swap, Key256, DMA		  
	           ((eBlkChipher.m_eOperMode== ECB)?(0<<1):(eBlkChipher.m_eOperMode==CBC)?(1<<1):(2<<1))|
	           (0<<0));
	}
	else
	{
	uRegValue = ((0x1f<<7)|(1<<6)|(0x2<<4)|(1<<3)|					// Byte Swap, Key256, DMA		  
	           ((eBlkChipher.m_eOperMode== ECB)?(0<<1):(eBlkChipher.m_eOperMode==CBC)?(1<<1):(2<<1))|
	           ((eBlkChipher.m_eDir == ENC)?0:1));
	}

    SblkOutp32(rAES_CONTROL, uRegValue);
      
    // AES key
    SblkOutp32(rAES_KEYDATA_01, 0x16157e2b);
    SblkOutp32(rAES_KEYDATA_02, 0xa6d2ae28);
    SblkOutp32(rAES_KEYDATA_03, 0x8815f7ab);
    SblkOutp32(rAES_KEYDATA_04, 0x3c4fcf09);
    SblkOutp32(rAES_KEYDATA_05, 0x16157e2b);
    SblkOutp32(rAES_KEYDATA_06, 0xa6d2ae28);
    SblkOutp32(rAES_KEYDATA_07, 0x8815f7ab);
    SblkOutp32(rAES_KEYDATA_08, 0x3c4fcf09);    

   // IV Data
   if(eBlkChipher.m_eOperMode == CBC)
   {
   	SblkOutp32(rAES_IVDATA_01, 0x03020100);
   	SblkOutp32(rAES_IVDATA_02, 0x07060504);
   	SblkOutp32(rAES_IVDATA_03, 0x0b0a0908);
   	SblkOutp32(rAES_IVDATA_04, 0x0f0e0d0c);
   }
   else if(eBlkChipher.m_eOperMode == CTR)
   {
	SblkOutp32(rAES_CNTDATA_01, 0xf3f2f1f0);
	SblkOutp32(rAES_CNTDATA_02, 0xf7f6f5f4);
	SblkOutp32(rAES_CNTDATA_03, 0xfbfaf9f8);
	SblkOutp32(rAES_CNTDATA_04, 0xfffefdfc);	
   } 
    
    }  

    
    //-------------------------------------------------------
    // hash configuration
    //-------------------------------------------------------
    
    // Set the engine and the start/init bit together
    if(alg==SHA1_HASH)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Enable the FIFO mode
    SblkOutp32(rHASH_FIFO_MODE_EN, 0x1);
    
    // Set the message size in bytes
    SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
    
    // set the pre_msg_leng
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
        
    //-------------------------------------------------------
    // hash configuration
    //-------------------------------------------------------
    
    // Set the engine and the start/init bit together
    if(alg==SHA1_HASH)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Enable the FIFO mode
    SblkOutp32(rHASH_FIFO_MODE_EN, 0x1);
    
    // Set the message size in bytes
    SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
    
    // set the pre_msg_leng
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
    
    //-------------------------------------------------------
    // DMA configuration
    //-------------------------------------------------------

     // DESSEL=1 and HASHINSEL=2'b10
     if((eBlkChipher.m_eSblkType == DES)||(eBlkChipher.m_eSblkType == TDES))
    	SblkOutp32(rFCFIFOCTRL, (1<<2)|(2<<0));
    else if (eBlkChipher.m_eSblkType == AES)
    	SblkOutp32(rFCFIFOCTRL, (0<<2)|(2<<0));
    
  
    // flush DMA
    SblkOutp32(rFCHRDMAC, 0x1);
    SblkOutp32(rFCHRDMAC, 0x0);
    SblkOutp32(rFCBRDMAC, 0x1);
    SblkOutp32(rFCBRDMAC, 0x0);
    SblkOutp32(rFCBTDMAC, 0x1);
    SblkOutp32(rFCBTDMAC, 0x0);
    
    // set BTDMA: addr, leng
    SblkOutp32(rFCBTDMAS, (u32)dest_addr);
    SblkOutp32(rFCBTDMAL, msg_size);
       
    // set BRDMA: addr, leng
    SblkOutp32(rFCBRDMAS, (u32)source_addr);
    SblkOutp32(rFCBRDMAL, msg_size); 

    
    // Poll BTDMA PEND bit
    while(!(Inp32(rFCINTPEND) & 0x4));
    
    SblkInp32(rFCINTPEND, uRegValue);
    SblkOutp32(rFCINTPEND, uRegValue);  // clear the pend bit
        
    
    // Invalidate D-cache
    //InvalidDataCache();
    
    // Poll hash
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & MSG_DONE));
    
    // copy the hash result to the specified address
    if(alg==SHA1_HASH)
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 4);
    }

    return;
}

#if 0  // 2nd test code
//////////
// Function Name : SBLK_DoConcur_HashnCipher
// Function Description : 
//			concurrent enc/dec and hash
// 			The data at source_addr is sent to DES for encryption and the ciphertext is 
// 			saved at dest_addr. At the same time, the data is also sent to the hash engine
// 			and the hash result is saved at hash_addr.
// 			Partial words (1 ~ 3 bytes) are rounded up.
// Input : 	ALG_SHA1, ALG_MD5
//			source_addr: address of the plaintext
// 			dest_addr:   address to save the ciphertext
// 			hash_addr:   address to save the hash result
// 			size:        size of plaintext/ciphertext in bytes						
// Output : NONE
// Version : 
// (do_adv_case_1)

void SBLK_DoConcur_HashnCipher(SBLK_TYPE eBLK, ALG_TYPE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size)
{
    u32 uRegValue;

    if(eBLK == DES)
    {
    //-------------------------------------------------------
    // DES configuration
    //-------------------------------------------------------
    
    // configuration register: DES/ECB/ENC/FIFO/little
    uRegValue = DES_DES|DES_ECB|DES_ENC|DES_DMA|DES_SWAP_DI|DES_SWAP_DO;
    SblkOutp32(rTDES_CONF, uRegValue);
      
    // DES key
    SblkOutp32(rTDES_KEY1_0, 0xf389d6c4);
    SblkOutp32(rTDES_KEY1_1, 0x088253e1);
    }
    else if (eBLK == AES)
    {
    //-------------------------------------------------------
    // AES configuration
    //-------------------------------------------------------
    
    // configuration register: AES/ECB/ENC/FIFO/little
    uRegValue = AES_ENC|AES_ECB|AES_DMA|AES_256|AES_CHANGE|AES_SWAP;
    SblkOutp32(rAES_CONTROL, uRegValue);
      
    // AES key
    SblkOutp32(rAES_KEYDATA_01, 0x16157e2b);
    SblkOutp32(rAES_KEYDATA_02, 0xa6d2ae28);
    SblkOutp32(rAES_KEYDATA_03, 0x8815f7ab);
    SblkOutp32(rAES_KEYDATA_04, 0x3c4fcf09);
    SblkOutp32(rAES_KEYDATA_05, 0x16157e2b);
    SblkOutp32(rAES_KEYDATA_06, 0xa6d2ae28);
    SblkOutp32(rAES_KEYDATA_07, 0x8815f7ab);
    SblkOutp32(rAES_KEYDATA_08, 0x3c4fcf09);    
    
    }  

    
    //-------------------------------------------------------
    // hash configuration
    //-------------------------------------------------------
    
    // Set the engine and the start/init bit together
    if(alg==ALG_SHA1)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Enable the FIFO mode
    SblkOutp32(rHASH_FIFO_MODE_EN, 0x1);
    
    // Set the message size in bytes
    SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
    
    // set the pre_msg_leng
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);

    
    //-------------------------------------------------------
    // DMA configuration
    //-------------------------------------------------------
    
    // DESSEL=1 and HASHINSEL=2'b01
    if(eBLK == DES)
    	SblkOutp32(rFCFIFOCTRL, (1<<2)|(1<<0));
    else if (eBLK == AES)
    	SblkOutp32(rFCFIFOCTRL, (0<<2)|(1<<0));
    	
    // flush DMA
    SblkOutp32(rFCHRDMAC, 0x1);
    SblkOutp32(rFCHRDMAC, 0x0);
    SblkOutp32(rFCBRDMAC, 0x1);
    SblkOutp32(rFCBRDMAC, 0x0);
    SblkOutp32(rFCBTDMAC, 0x1);
    SblkOutp32(rFCBTDMAC, 0x0);
    
    // set BTDMA: addr, leng
    SblkOutp32(rFCBTDMAS, (u32)dest_addr);
    SblkOutp32(rFCBTDMAL, msg_size);
       
    // set BRDMA: addr, leng
    SblkOutp32(rFCBRDMAS, (u32)source_addr);
    SblkOutp32(rFCBRDMAL, msg_size);
    
    //-------------------------------------------------------
    // polling
    // make sure that both the ciphertext and the hash result are saved.
    //-------------------------------------------------------
    
    // Poll BTDMA PEND bit
    while(!(Inp32(rFCINTPEND) & 0x4));
    
    SblkInp32(rFCINTPEND, uRegValue);
    SblkOutp32(rFCINTPEND, uRegValue);  // clear the pend bit
        
    // Invalidate D-cache
    //InvalidDataCache();				// (JWJ) It must be check!!!
    
    // Poll hash
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & ~MSG_DONE));
    
    // copy the hash result to the specified address
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 4);
    }

    return;
}


//////////
// Function Name : SBLK_DoSeri_HashnCipher
// Function Description : 
// 				hash + block cipher case 2
// 				end/dec first, then hash
// 				The data at source_addr is sent to DES for decryption and the plaintext is 
// 				saved at dest_addr. The decryption result is also sent to the hash engine
// 				and the hash result is saved at hash_addr.
// Input : 	ALG_SHA1, ALG_MD5
// 				source_addr: address of the ciphertext
// 				dest_addr:   address to save the plaintext
// 				hash_addr:   address to save the hash result
// 				size:        size of plaintext/ciphertext in bytes					
// Output : NONE
// Version : 
// (do_adv_case_2)

void SBLK_DoSeri_HashnCipher(SBLK_TYPE eBLK, ALG_TYPE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size)
{
    u32 uRegValue;

    if(eBLK == DES)
    {
    //-------------------------------------------------------
    // DES configuration
    //-------------------------------------------------------

    // configuration register: DES/ECB/DEC/FIFO/little
    uRegValue = DES_DES|DES_ECB|DES_DEC|DES_DMA|DES_SWAP_DI|DES_SWAP_DO;
    SblkOutp32(rTDES_CONF, uRegValue);
      
    // DES key
    SblkOutp32(rTDES_KEY1_0, 0xf389d6c4);
    SblkOutp32(rTDES_KEY1_1, 0x088253e1);
    }
     else if (eBLK == AES)
    {
    //-------------------------------------------------------
    // AES configuration
    //-------------------------------------------------------
    
    // configuration register: AES/ECB/DEC/FIFO/little
    uRegValue = AES_DEC|AES_ECB|AES_DMA|AES_256|AES_CHANGE|AES_SWAP;
    SblkOutp32(rAES_CONTROL, uRegValue);
      
    // AES key
    SblkOutp32(rAES_KEYDATA_01, 0x16157e2b);
    SblkOutp32(rAES_KEYDATA_02, 0xa6d2ae28);
    SblkOutp32(rAES_KEYDATA_03, 0x8815f7ab);
    SblkOutp32(rAES_KEYDATA_04, 0x3c4fcf09);
    SblkOutp32(rAES_KEYDATA_05, 0x16157e2b);
    SblkOutp32(rAES_KEYDATA_06, 0xa6d2ae28);
    SblkOutp32(rAES_KEYDATA_07, 0x8815f7ab);
    SblkOutp32(rAES_KEYDATA_08, 0x3c4fcf09);    
    
    }     
        
    //-------------------------------------------------------
    // hash configuration
    //-------------------------------------------------------
    
    // Set the engine and the start/init bit together
    if(alg==ALG_SHA1)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Enable the FIFO mode
    SblkOutp32(rHASH_FIFO_MODE_EN, 0x1);
    
    // Set the message size in bytes
    SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
    
    // set the pre_msg_leng
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
    
    //-------------------------------------------------------
    // DMA configuration
    //-------------------------------------------------------

     // DESSEL=1 and HASHINSEL=2'b10
    if(eBLK == DES)
    	SblkOutp32(rFCFIFOCTRL, (1<<2)|(2<<0));
    else if (eBLK == AES)
    	SblkOutp32(rFCFIFOCTRL, (0<<2)|(2<<0));
    
  
    // flush DMA
    SblkOutp32(rFCHRDMAC, 0x1);
    SblkOutp32(rFCHRDMAC, 0x0);
    SblkOutp32(rFCBRDMAC, 0x1);
    SblkOutp32(rFCBRDMAC, 0x0);
    SblkOutp32(rFCBTDMAC, 0x1);
    SblkOutp32(rFCBTDMAC, 0x0);
    
    // set BTDMA: addr, leng
    SblkOutp32(rFCBTDMAS, (u32)dest_addr);
    SblkOutp32(rFCBTDMAL, msg_size);
       
    // set BRDMA: addr, leng
    SblkOutp32(rFCBRDMAS, (u32)source_addr);
    SblkOutp32(rFCBRDMAL, msg_size); 

    
    // Poll BTDMA PEND bit
    while(!(Inp32(rFCINTPEND) & 0x4));
    
    SblkInp32(rFCINTPEND, uRegValue);
    SblkOutp32(rFCINTPEND, uRegValue);  // clear the pend bit
        
    
    // Invalidate D-cache
    //InvalidDataCache();
    
    // Poll hash
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & ~MSG_DONE));
    
    // copy the hash result to the specified address
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 4);
    }

    return;
}
#endif
#if 0		// Original Test DES + HASH
//////////
// Function Name : SBLK_DoConcur_HashnCipher
// Function Description : 
//			concurrent enc/dec and hash
// 			The data at source_addr is sent to DES for encryption and the ciphertext is 
// 			saved at dest_addr. At the same time, the data is also sent to the hash engine
// 			and the hash result is saved at hash_addr.
// 			Partial words (1 ~ 3 bytes) are rounded up.
// Input : 	ALG_SHA1, ALG_MD5
//			source_addr: address of the plaintext
// 			dest_addr:   address to save the ciphertext
// 			hash_addr:   address to save the hash result
// 			size:        size of plaintext/ciphertext in bytes						
// Output : NONE
// Version : 
// (do_adv_case_1)

void SBLK_DoConcur_HashnCipher(ALG_TYPE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size)
{
    u32 uRegValue;

    //-------------------------------------------------------
    // DES configuration
    //-------------------------------------------------------
    
    // configuration register: DES/ECB/ENC/FIFO/little
    uRegValue = DES_DES|DES_ECB|DES_ENC|DES_DMA|DES_SWAP_DI|DES_SWAP_DO;
    SblkOutp32(rTDES_CONF, uRegValue);
      
    // DES key
    SblkOutp32(rTDES_KEY1_0, 0xf389d6c4);
    SblkOutp32(rTDES_KEY1_1, 0x088253e1);

    //-------------------------------------------------------
    // hash configuration
    //-------------------------------------------------------
    
    // Set the engine and the start/init bit together
    if(alg==ALG_SHA1)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Enable the FIFO mode
    SblkOutp32(rHASH_FIFO_MODE_EN, 0x1);
    
    // Set the message size in bytes
    SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
    
    // set the pre_msg_leng
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);

    
    //-------------------------------------------------------
    // DMA configuration
    //-------------------------------------------------------
    
    // DESSEL=1 and HASHINSEL=2'b01
    SblkOutp32(rFCFIFOCTRL, 0x5);
  
    // flush DMA
    SblkOutp32(rFCHRDMAC, 0x1);
    SblkOutp32(rFCHRDMAC, 0x0);
    SblkOutp32(rFCBRDMAC, 0x1);
    SblkOutp32(rFCBRDMAC, 0x0);
    SblkOutp32(rFCBTDMAC, 0x1);
    SblkOutp32(rFCBTDMAC, 0x0);
    
    // set BTDMA: addr, leng
    SblkOutp32(rFCBTDMAS, (u32)dest_addr);
    SblkOutp32(rFCBTDMAL, msg_size);
       
    // set BRDMA: addr, leng
    SblkOutp32(rFCBRDMAS, (u32)source_addr);
    SblkOutp32(rFCBRDMAL, msg_size);
    
    //-------------------------------------------------------
    // polling
    // make sure that both the ciphertext and the hash result are saved.
    //-------------------------------------------------------
    
    // Poll BTDMA PEND bit
    while(!(Inp32(rFCINTPEND) & 0x4));
    
    SblkInp32(rFCINTPEND, uRegValue);
    SblkOutp32(rFCINTPEND, uRegValue);  // clear the pend bit
        
    // Invalidate D-cache
    //InvalidDataCache();				// (JWJ) It must be check!!!
    
    // Poll hash
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & ~MSG_DONE));
    
    // copy the hash result to the specified address
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 4);
    }

    return;
}


//////////
// Function Name : SBLK_DoSeri_HashnCipher
// Function Description : 
// 				hash + block cipher case 2
// 				end/dec first, then hash
// 				The data at source_addr is sent to DES for decryption and the plaintext is 
// 				saved at dest_addr. The decryption result is also sent to the hash engine
// 				and the hash result is saved at hash_addr.
// Input : 	ALG_SHA1, ALG_MD5
// 				source_addr: address of the ciphertext
// 				dest_addr:   address to save the plaintext
// 				hash_addr:   address to save the hash result
// 				size:        size of plaintext/ciphertext in bytes					
// Output : NONE
// Version : 
// (do_adv_case_2)

void SBLK_DoSeri_HashnCipher(ALG_TYPE alg, u32 *source_addr, u32 *dest_addr, u32 *hash_addr, u32 msg_size)
{
    u32 uRegValue;
    
    //-------------------------------------------------------
    // DES configuration
    //-------------------------------------------------------

    // configuration register: DES/ECB/DEC/FIFO/little
    uRegValue = DES_DES|DES_ECB|DES_DEC|DES_DMA|DES_SWAP_DI|DES_SWAP_DO;
    SblkOutp32(rTDES_CONF, uRegValue);
      
    // DES key
    SblkOutp32(rTDES_KEY1_0, 0xf389d6c4);
    SblkOutp32(rTDES_KEY1_1, 0x088253e1);

        
    //-------------------------------------------------------
    // hash configuration
    //-------------------------------------------------------
    
    // Set the engine and the start/init bit together
    if(alg==ALG_SHA1)
    {
        uRegValue = HASH_START_BIT | ENG_SHA1_HASH;
    }
    else
    {
        uRegValue = HASH_START_BIT | ENG_MD5_HASH;
    }
    SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);
    
    SblkOutp32(rHASH_CONTROL_1, uRegValue);
    
    // Enable the FIFO mode
    SblkOutp32(rHASH_FIFO_MODE_EN, 0x1);
    
    // Set the message size in bytes
    SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
    SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
    
    // set the pre_msg_leng
    SblkOutp32(rHASH_PRE_MSG_LENG_LOW, 0x0);
    SblkOutp32(rHASH_PRE_MSG_LENG_HIGH, 0x0);
    
    //-------------------------------------------------------
    // DMA configuration
    //-------------------------------------------------------

    // DESSEL=1 and HASHINSEL=2'b10
    SblkOutp32(rFCFIFOCTRL, 0x6);
  
    // flush DMA
    SblkOutp32(rFCHRDMAC, 0x1);
    SblkOutp32(rFCHRDMAC, 0x0);
    SblkOutp32(rFCBRDMAC, 0x1);
    SblkOutp32(rFCBRDMAC, 0x0);
    SblkOutp32(rFCBTDMAC, 0x1);
    SblkOutp32(rFCBTDMAC, 0x0);
    
    // set BTDMA: addr, leng
    SblkOutp32(rFCBTDMAS, (u32)dest_addr);
    SblkOutp32(rFCBTDMAL, msg_size);
       
    // set BRDMA: addr, leng
    SblkOutp32(rFCBRDMAS, (u32)source_addr);
    SblkOutp32(rFCBRDMAL, msg_size); 

    
    // Poll BTDMA PEND bit
    while(!(Inp32(rFCINTPEND) & 0x4));
    
    SblkInp32(rFCINTPEND, uRegValue);
    SblkOutp32(rFCINTPEND, uRegValue);  // clear the pend bit
        
    
    // Invalidate D-cache
    //InvalidDataCache();
    
    // Poll hash
    do
    {
        SblkInp32(rHASH_STATUS, uRegValue);
    }while(!(uRegValue & MSG_DONE));
    
    SblkOutp32(rHASH_STATUS, (uRegValue & ~MSG_DONE));
    
    // copy the hash result to the specified address
    if(alg==ALG_SHA1)
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 5);
    }
    else
    {
        Copy(rHASH_RESULT_1, (u32)hash_addr, 4);
    }

    return;
}
#endif


void HASH_NOSWAP(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr)
{
	u32 total_words = (msg_size + 3) >> 2;
	u32 num_blocks = total_words >> 4; 
	u32 remain_words = total_words & 0xF;
	u32 result_length;
	u32 i;
	
	
	Assert(msg_size!=0);

	SblkOutp32(rHASH_BYTE_SWAP, byte_swap);
	SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|control);
	SblkOutp32(rHASH_FIFO_MODE_EN, fifo_con);
	SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);

	
	//if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(msg_addr, msg_addr, total_words);
	
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
		// Flush HRDMA to be safe
		SblkOutp32(rFCHRDMAC, 0x1);
		SblkOutp32(rFCHRDMAC, 0x0);
    	
	    	// Disable HRDMA interrupt. We don't need this signal for the hash operation.
		SblkOutp32(rFCINTENCLR, HRDMA_INT_BIT);
	        
   		// HASHINSEL = 2'b00 (independent source)
   		SblkOutp32(rFCFIFOCTRL, Inp32(rFCFIFOCTRL)&0x4);  // HASHINSEL: keep bit[2] and set bit[1:0] to 2'b00
    	
	    	// Setup the DMA: msg_addr, msg_size
		SblkOutp32(rFCHRDMAS, (u32)msg_addr);
	    	SblkOutp32(rFCHRDMAL, msg_size);				// DMA starts
	}
	else
	{
		// Data input for the whole blocks
    		for(i=0; i<num_blocks; i++)
    		{
    			while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
    	
    	    		// Data input: 8-word burst x 2
    	    		Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
    	    		Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    		}
	
    		if(remain_words!=0)
    		{
    	  	  while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
        
    	    	// Data input: <16 words
		    if(remain_words>8)
    		    {
    	      		Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, 8);
        	    	Copy( (u32)(msg_addr+num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
			 }
        		else
	    	        Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, remain_words);
    		}	
   	 }

    while(!(Inp32(rHASH_STATUS) & MSG_DONE));
	SblkOutp32(rHASH_STATUS, MSG_DONE);	
		
	// Read and save the result. SHA1 = 5 words, MD5 = 4 words
    if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HASH)
    	result_length = 5;
    else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HASH)
        result_length = 4;
    
    Copy(rHASH_RESULT_1, (u32)result_addr, result_length);
    
    //if(!(byte_swap & HASH_SWAP_DO))
 	//	byteswaplen(result_addr, result_addr, result_length);
	    
    if( Compare((u32)result_addr, (u32)golden_addr, result_length) )
    	Disp("P A S S! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
    else
    	Disp("F A I L! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
    
  // if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(msg_addr, msg_addr, total_words);
}

void HASH_SWAP(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr)
{
	u32 total_words = (msg_size + 3) >> 2;
	u32 num_blocks = total_words >> 4; 
	u32 remain_words = total_words & 0xF;
	u32 result_length;
	u32 i;
	
	
	Assert(msg_size!=0);

	SblkOutp32(rHASH_BYTE_SWAP, byte_swap);
	SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|control);
	SblkOutp32(rHASH_FIFO_MODE_EN, fifo_con);
	SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);

	
	//if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(msg_addr, msg_addr, total_words);
	
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
		// Flush HRDMA to be safe
		SblkOutp32(rFCHRDMAC, 0x1);
		SblkOutp32(rFCHRDMAC, 0x2);
    	
	    	// Disable HRDMA interrupt. We don't need this signal for the hash operation.
		SblkOutp32(rFCINTENCLR, HRDMA_INT_BIT);
	        
   		// HASHINSEL = 2'b00 (independent source)
   		SblkOutp32(rFCFIFOCTRL, Inp32(rFCFIFOCTRL)&0x4);  // HASHINSEL: keep bit[2] and set bit[1:0] to 2'b00
    	
	    	// Setup the DMA: msg_addr, msg_size
		SblkOutp32(rFCHRDMAS, (u32)msg_addr);
	    	SblkOutp32(rFCHRDMAL, msg_size);				// DMA starts
	}
	else
	{
		// Data input for the whole blocks
    		for(i=0; i<num_blocks; i++)
    		{
    			while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
    	
    	    		// Data input: 8-word burst x 2
    	    		Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
    	    		Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    		}
	
    		if(remain_words!=0)
    		{
    	  	  while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
        
    	    	// Data input: <16 words
		    if(remain_words>8)
    		    {
    	      		Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, 8);
        	    	Copy( (u32)(msg_addr+num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
			 }
        		else
	    	        Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, remain_words);
    		}	
   	 }

    while(!(Inp32(rHASH_STATUS) & MSG_DONE));
	SblkOutp32(rHASH_STATUS, MSG_DONE);	
		
	// Read and save the result. SHA1 = 5 words, MD5 = 4 words
    if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HASH)
    	result_length = 5;
    else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HASH)
        result_length = 4;
    
    Copy(rHASH_RESULT_1, (u32)result_addr, result_length);
    
   // if(!(byte_swap & HASH_SWAP_DO))
   //		byteswaplen(result_addr, result_addr, result_length);
	    
    if( Compare((u32)result_addr, (u32)golden_addr, result_length) )
    	Disp("P A S S! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
    else
    	Disp("F A I L! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
    
    //if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(msg_addr, msg_addr, total_words);
}


void SBLK_HMAC1(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, u32 key_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr, u32 *hmac_key)
{
	u32 inner_result[5];
	u32 total_words = (msg_size + 3) >> 2;
	u32 num_blocks = total_words >> 4; 
	u32 remain_words = total_words & 0xF;
	u32 result_length;
	u32 i;
	
	Assert(msg_size!=0);
	Assert(key_size==64);

	//---------------------------------------
	// Inner hash
	//---------------------------------------
	SblkOutp32(rHASH_BYTE_SWAP, byte_swap);
	SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|control);	
	SblkOutp32(rHASH_FIFO_MODE_EN, fifo_con);
	SblkOutp32(rHASH_MSG_SIZE_LOW, key_size+msg_size);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
	
	if(!(byte_swap & HASH_SWAP_DI))
	{
		byteswaplen(msg_addr, msg_addr, total_words);
		byteswaplen(hmac_key, hmac_key, (key_size>>2));
	}
		
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
		// Flush HRDMA to be safe
		SblkOutp32(rFCHRDMAC, 0x1);
		SblkOutp32(rFCHRDMAC, 0x0);
    	
		// Enable HRDMA interrupt
		SblkOutp32(rFCINTENSET, HRDMA_INT_BIT);
    
   		// Clear possible pending HRDMA interrupt to be safe
		SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    	
	    	// HASHINSEL = 2'b00 (independent source)
		SblkOutp32(rFCFIFOCTRL, Inp32(rFCFIFOCTRL)&0x4);	// HASHINSEL: keep bit[2] and set bit[1:0] to 2'b00
        
	        // Setup DMA for the key: (key_addr, 64 bytes)
	        SblkOutp32(rFCHRDMAS, (u32)hmac_key);	//	start address
	        SblkOutp32(rFCHRDMAL, key_size);		//	size in bytes --> DMA starts
    	
	    	// Poll DMA interrupt
	    	while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));
    
	    	// Clear interrupt pending bit.
	    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    	
	   	// Setup DMA for the message: (msg_addr, msg_size)
	   	SblkOutp32(rFCHRDMAS, (u32)msg_addr);	// start address
	   	SblkOutp32(rFCHRDMAL, msg_size);		// size in bytes --> DMA starts
	   	
	}
	else
	{
	
		Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
	    	Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8);  // key_addr is a pointer to u32, 
                                                       // so key_addr+8 means an offset of 8 words.
	
		// Data input for the whole blocks
	 	for(i=0; i<num_blocks; i++)
    		{
    			while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
    	
		 // Data input: 8-word burst x 2
	    	    Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
    		    Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    		}
	
    		if(remain_words!=0)
    		{
	    	    while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
        
    		    // Data input: <16 words
	    	    if(remain_words>8)
    		    {
    	       	 Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, 8);
	    	        Copy( (u32)(msg_addr+num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
    		    }
	    	    else
    		        Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, remain_words);
		}	
    	}
    
	while(!(Inp32(rHASH_STATUS) & MSG_DONE));
	SblkOutp32(rHASH_STATUS, MSG_DONE);

	// Read and save the result. SHA1 = 5 words, MD5 = 4 words
	if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HMAC_INNER)
	    	result_length = 5;
	else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HMAC_INNER)
		result_length = 4;
    
	Copy(rHASH_RESULT_1, (u32)inner_result, result_length);

    	if(!(byte_swap & HASH_SWAP_DO))
		byteswaplen(inner_result, inner_result, result_length);
	    
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	    	// Clear interrupt pending bit.
		SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    
	//---------------------------------------
	// Outer hash
	//---------------------------------------
	// Set the engine and the start/init bit together
	
	if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 84);
	}
	else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 80);
	}
		SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
		
	if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(inner_result, inner_result, result_length);
		
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
		// Setup DMA for the key: key_addr, 64 bytes
		SblkOutp32(rFCHRDMAS, (u32)hmac_key);	// start address
		SblkOutp32(rFCHRDMAL, key_size);			// size in bytes --> DMA starts
    
    	// Poll DMA interrupt
    	while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));
    
    	// Clear interrupt pending bit.
    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);

	SblkOutp32(rFCHRDMAS, (u32)inner_result);		// start address
	SblkOutp32(rFCHRDMAL, result_length<<2);		// size in bytes --> DMA starts  
	}
	else
	{
		Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
	    	Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8); 
	
		while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
	
		Copy((u32)inner_result, rHASH_DATA_IN_1, result_length);
	}
	
	while(!(Inp32(rHASH_STATUS) & MSG_DONE));
	SblkOutp32(rHASH_STATUS, MSG_DONE);
	
	Copy(rHASH_RESULT_1, (u32)result_addr, result_length);
	    
	//---------------------------------------
	// Compare
	//---------------------------------------
	if(!(byte_swap & HASH_SWAP_DO))
		byteswaplen(result_addr, result_addr, result_length);
    
	if( Compare((u32)result_addr, (u32)golden_addr, result_length) )
    		Disp("P A S S! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
	else
	    	Disp("F A I L! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
    
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
    	// Clear interrupt pending bit.
    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
	
	if(!(byte_swap & HASH_SWAP_DI))
	{
		byteswaplen(msg_addr, msg_addr, total_words);
		byteswaplen(hmac_key, hmac_key, (key_size>>2));
	} 
}



//////////
// Function Name : SBLK_HASH
// Function Description : 
// 				
// 
// Input : 				
// Output : NONE
// Version : 
// (hash)

void SBLK_HASH(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr)
{
	u32 total_words = (msg_size + 3) >> 2;
	u32 num_blocks = total_words >> 4; 
	u32 remain_words = total_words & 0xF;
	u32 result_length;
	u32 i;
	
	
	Assert(msg_size!=0);

	INTC_SetVectAddr(NUM_HASH, Isr_HASH);
	INTC_Enable(NUM_HASH);
	g_HASHDone =0;

	SblkOutp32(rHASH_BYTE_SWAP, byte_swap);
	SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|control);
	SblkOutp32(rHASH_FIFO_MODE_EN, fifo_con);
	SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);

	

	
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{

		if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(msg_addr, (u32 *)INPUT_BUF, total_words);
		
		// Flush HRDMA to be safe
		SblkOutp32(rFCHRDMAC, 0x1);
		SblkOutp32(rFCHRDMAC, 0x0);

	    	// Disable HRDMA interrupt. We don't need this signal for the hash operation.
		SblkOutp32(rFCINTENCLR, HRDMA_INT_BIT);
	        
   		// HASHINSEL = 2'b00 (independent source)
   		SblkOutp32(rFCFIFOCTRL, Inp32(rFCFIFOCTRL)&0x4);  // HASHINSEL: keep bit[2] and set bit[1:0] to 2'b00
    	
	    	// Setup the DMA: msg_addr, msg_size
	    	if(!(byte_swap & HASH_SWAP_DI))
	    		SblkOutp32(rFCHRDMAS, INPUT_BUF);
	    	else
			SblkOutp32(rFCHRDMAS, (u32)msg_addr);
	    	SblkOutp32(rFCHRDMAL, msg_size);				// DMA starts
	}
	else
	{

		if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(msg_addr, msg_addr, total_words);
	
		// Data input for the whole blocks
    		for(i=0; i<num_blocks; i++)
    		{
    			while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
    	
    	    		// Data input: 8-word burst x 2
    	    		Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
    	    		Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    		}
	
    		if(remain_words!=0)
    		{
    	  	  while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
        
    	    	// Data input: <16 words
		    if(remain_words>8)
    		    {
    	      		Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, 8);
        	    	Copy( (u32)(msg_addr+num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
			 }
        		else
	    	        Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, remain_words);
    		}	

		// return to golden data
	    if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(msg_addr, msg_addr, total_words);
    		
   	 }

   // Temp add

	while(g_HASHDone ==0);
	g_HASHDone = 0;
   
    //while(!(Inp32(rHASH_STATUS) & MSG_DONE));
	//SblkOutp32(rHASH_STATUS, MSG_DONE);	
		
	// Read and save the result. SHA1 = 5 words, MD5 = 4 words
    if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HASH)
    	result_length = 5;
    else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HASH)
        result_length = 4;
    
    Copy(rHASH_RESULT_1, (u32)result_addr, result_length);
    
    if(!(byte_swap & HASH_SWAP_DO))
		byteswaplen(result_addr, result_addr, result_length);
	    
    if( Compare((u32)result_addr, (u32)golden_addr, result_length) )
    	Disp("P A S S! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
    else
    	Disp("F A I L! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
    


    INTC_Disable(NUM_HASH);
}


//////////
// Function Name : SBLK_HMAC
// Function Description : 
// 				
// 
// Input : 				
// Output : NONE
// Version : 
// (hmac)

void SBLK_HMAC(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, u32 key_size, 
			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr, u32 *hmac_key)
{
	u32 inner_result[5];
	u32 total_words = (msg_size + 3) >> 2;
	u32 num_blocks = total_words >> 4; 
	u32 remain_words = total_words & 0xF;
	u32 result_length;
	u32 i;
	
	Assert(msg_size!=0);
	Assert(key_size==64);

	INTC_SetVectAddr(NUM_HASH, Isr_HASH);
	INTC_Enable(NUM_HASH);
	g_HASHDone =0;

	//---------------------------------------
	// Inner hash
	//---------------------------------------
	SblkOutp32(rHASH_BYTE_SWAP, byte_swap);
	SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|control);
	SblkOutp32(rHASH_FIFO_MODE_EN, fifo_con);
	SblkOutp32(rHASH_MSG_SIZE_LOW, key_size+msg_size);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);

	if(!(byte_swap & HASH_SWAP_DI))
		{
		byteswaplen(msg_addr, msg_addr, total_words);
		byteswaplen(hmac_key, hmac_key, (key_size>>2));
		}

		
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
		SBLK_EnDMAINT(HRDMA);
		g_SDma1Done =0;

		//Copy for Test to NCNB Area
		Copy((u32)msg_addr,  INPUT_BUF+key_size, total_words);
		Copy((u32)hmac_key,  INPUT_BUF, (key_size>>2));
	
		// Flush HRDMA to be safe
		SblkOutp32(rFCHRDMAC, 0x1);
		SblkOutp32(rFCHRDMAC, 0x0);
		#if 0
		if(byte_swap&HASH_SWAP_DI)
		{
			SblkOutp32(rFCHRDMAC,0x0);
		}
		else 
		{
			SblkOutp32(rFCHRDMAC,0x2);
		}
    		#endif
    		
		// Enable HRDMA interrupt
		SblkOutp32(rFCINTENSET, HRDMA_INT_BIT);
    
   		// Clear possible pending HRDMA interrupt to be safe
		SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    	
	    	// HASHINSEL = 2'b00 (independent source)
		SblkOutp32(rFCFIFOCTRL, Inp32(rFCFIFOCTRL)&0x4);	// HASHINSEL: keep bit[2] and set bit[1:0] to 2'b00
        
	        // Setup DMA for the key: (key_addr, 64 bytes)
	       // SblkOutp32(rFCHRDMAS, (u32)hmac_key);	//	start address
	        SblkOutp32(rFCHRDMAS, INPUT_BUF);	//	start address
	        SblkOutp32(rFCHRDMAL, key_size);		//	size in bytes --> DMA starts
    	
	    	// Poll DMA interrupt
	    	//while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));
		 while(g_SDma1Done ==0);
		 g_SDma1Done=0;
	    	
	    	// Clear interrupt pending bit.
	    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    	
	   	// Setup DMA for the message: (msg_addr, msg_size)
	   	//SblkOutp32(rFCHRDMAS, (u32)msg_addr);	// start address
	   	SblkOutp32(rFCHRDMAS, INPUT_BUF+key_size);	// start address
	   	SblkOutp32(rFCHRDMAL, msg_size);		// size in bytes --> DMA starts
	   	
	}
	else
	{
		
		Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
	    	Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8);  // key_addr is a pointer to u32, 
                                                       // so key_addr+8 means an offset of 8 words.
	
		// Data input for the whole blocks
	 	for(i=0; i<num_blocks; i++)
    		{
    			while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
    	
		 // Data input: 8-word burst x 2
	    	    Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
    		    Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    		}
	
    		if(remain_words!=0)
    		{
	    	    while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
        
    		    // Data input: <16 words
	    	    if(remain_words>8)
    		    {
    	       	 Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, 8);
	    	        Copy( (u32)(msg_addr+num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
    		    }
	    	    else
    		        Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, remain_words);
		}	
    	}

    	#if 0
	while(!(Inp32(rHASH_STATUS) & MSG_DONE));
	SblkOutp32(rHASH_STATUS, MSG_DONE);
	#endif
	while(g_HASHDone ==0);
	g_HASHDone =0;
	

	// Read and save the result. SHA1 = 5 words, MD5 = 4 words
	if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HMAC_INNER)
	    	result_length = 5;
	else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HMAC_INNER)
		result_length = 4;
    
	Copy(rHASH_RESULT_1, (u32)inner_result, result_length);

    	if(!(byte_swap & HASH_SWAP_DO))
		byteswaplen(inner_result, inner_result, result_length);
	    
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	    	// Clear interrupt pending bit.
		SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    
	//---------------------------------------
	// Outer hash
	//---------------------------------------
	// Set the engine and the start/init bit together
	
	if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 84);
	}
	else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 80);
	}
		SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
		
	if(!(byte_swap & HASH_SWAP_DI))
		byteswaplen(inner_result, inner_result, result_length);
		
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
		#if 0
		if(Inp32(rFCHRDMAC)>>1)
			byteswaplen(inner_result, inner_result, result_length);
		#endif
		// for test
		Copy((u32)inner_result, MID_BUF, result_length);
		
		// Setup DMA for the key: key_addr, 64 bytes
	      SblkOutp32(rFCHRDMAS, INPUT_BUF);	//	start address
		//SblkOutp32(rFCHRDMAS, (u32)hmac_key);	// start address
		SblkOutp32(rFCHRDMAL, key_size);			// size in bytes --> DMA starts
		
    
    	// Poll DMA interrupt
    	//while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));
    	   while(g_SDma1Done ==0);
	   g_SDma1Done=0;
    
    	// Clear interrupt pending bit.
    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);

	SblkOutp32(rFCHRDMAS, MID_BUF);		// start address
	SblkOutp32(rFCHRDMAL, result_length<<2);		// size in bytes --> DMA starts  
	}
	else
	{
		Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
	    	Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8); 
	
		while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
	
		Copy((u32)inner_result, rHASH_DATA_IN_1, result_length);
	}

	#if 0
	while(!(Inp32(rHASH_STATUS) & MSG_DONE));
	SblkOutp32(rHASH_STATUS, MSG_DONE);
	#endif
	while(g_HASHDone ==0);
	g_HASHDone =0;

	
	Copy(rHASH_RESULT_1, (u32)result_addr, result_length);
	    
	//---------------------------------------
	// Compare
	//---------------------------------------
	if(!(byte_swap & HASH_SWAP_DO))
		byteswaplen(result_addr, result_addr, result_length);
    
	if( Compare((u32)result_addr, (u32)golden_addr, result_length) )
    		Disp("P A S S! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
	else
	    	Disp("F A I L! (HASH_CONTROL_1 = 0x%x) \n", Inp32(rHASH_CONTROL_1));
    
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
    	// Clear interrupt pending bit.
    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
	
	if(!(byte_swap & HASH_SWAP_DI))
	{
		byteswaplen(msg_addr, msg_addr, total_words);
		byteswaplen(hmac_key, hmac_key, (key_size>>2));
	} 
	INTC_Disable(NUM_HASH);
	INTC_Disable(NUM_FEEDCTRL);
}

//////////
// Function Name : SBLK_PRNG
// Function Description : 
// 				
// 
// Input : 				
// Output : NONE
// Version : 
// (prng)
void SBLK_PRNG(u32 *prng_seed, u32 *result_addr)
{
	u32 i;
	u32 reg_value;
	u32 prng_result[5];

	INTC_SetVectAddr(NUM_HASH, Isr_HASH);
	INTC_Enable(NUM_HASH);
	g_HASHDone =0;
    
	//---------------------------------------
	// Seed setup
	//---------------------------------------
	SblkOutp32(rHASH_CONTROL_1, ENG_PRNG);
	
   
	// Write seed data (5 words)
	Copy((u32)prng_seed, rHASH_SEED_IN_1, 5);
    
	if(Inp32(rHASH_STATUS) & SEED_SETTING_DONE)
		Disp("\nSeed setup is OK!\n");
	else
	{
       	Disp("\nSeed setup is not OK! Stop...\n");
	       return;
	}
    
	// wait for some time
	for(i=0; i<100; i++) ;
    
	// set the engine and the start bit together
	SblkOutp32(rHASH_CONTROL_1, ENG_PRNG|HASH_START_BIT);
    
	// Poll the done signal
	#if 0
	while( !(Inp32(rHASH_STATUS) & PRNG_DONE) );
	Outp32(rHASH_STATUS, reg_value&~PRNG_DONE);		//??    
	//HASH_STATUS=reg_value & ~PRNG_DONE;
    	#endif
    	while(g_HASHDone ==0);
    	g_HASHDone=0;
	// Save the PRNG result
	Copy(rHASH_PRNG_1, (u32)prng_result, 5);
    
	// Print the PRNG result
	Disp("PRNG = %08x %08x %08x %08x %08x\n", prng_result[0], prng_result[1], prng_result[2], prng_result[3], prng_result[4] );

	INTC_Disable(NUM_HASH);
	return;
}



/////////////////////////////////////////////////////////////////////////
//				PKA Function
////////////////////////////////////////////////////////////////////////

#if 1	// 1st version
//////////
// Function Name : SBLK_InitPKA
// Function Description : 
// 				Initializes PKA with segment size, chunk size and precision id.
// Input :
//		seg_size : segment size. one of [SEG_FULL, SEG_HALF, SEG_QUARTER].
//           		 segment is a sector in PKSRAM. full size is 256 Byte or 2048 bits.
// 		chunk_bits : chunk is a unit of calculation. one of [128, 160, ... , 512].
//              		it can be any value from 128 bits to 512 bits in unit of 32bits.
// 		prec_id : precision id. one of [SINGLE_PREC, DOUBLE_PREC, TRIPLE_PREC, QUADRUPLE_PREC].
//          			 the number of bits of A, B, M, S is (prec_id + 1) * chunk_size.				
// Output : NONE
// Version : 
// (InitPKA)

u32 SBLK_InitPKA_(s32 seg_size, s32 chunk_bits, s32 prec_id)
{
	u32 uRegValue;

	Assert(seg_size == SEG_FULL || seg_size == SEG_HALF || seg_size == SEG_QUARTER);
	Assert((chunk_bits >> 5) >= 4 && (chunk_bits >> 5) <= 16);
	Assert(prec_id >= 0 && prec_id <= 3);

	uRegValue = (CHNK_SZ(chunk_bits) | prec_id);
	SblkOutp32(rPKA_SFR0, uRegValue);    			

	gPKANumSize = (chunk_bits >> 3) * (prec_id + 1); 	  // chunk_bits/8 * [1~4]
	gPKASegSize = 256 >> (seg_size >> 5);      		        // [256, 128, 64]
	gPKASfr4 = seg_size;                                // SEG_[FULL, HALF, QUARTER]

	return 0;
}

//////////
// Function Name : SBLK_PutPKA
// Function Description : 
// 				copies input number into the segment seg_id. (DRAM -> PKSRAM)
// Input :
//		word aligned unsigned integer pointer to source data
// 		dst_id : segment id of destination segment			
// Output : NONE
// Version : 
// (PutPKA)

u32 SBLK_PutPKA_(u32* input, s32 seg_id) 
{

	Assert(input);
	Assert(seg_id >= 0 && seg_id < 32);

	SblkOutp32(rFCPKDMAC, FCFLUSH);    	   
	SblkOutp32(rFCPKDMAC, FCDESCEND);	  // Little Endian FCFLUSH OFF, DESCEND, RX 	 
	SblkOutp32(rFCPKDMAS, (u32)input); 	  // DRAM start address
	SblkOutp32(rFCPKDMAO, gPKASegSize * seg_id + gPKANumSize - 4);	// SRAM top offset
	SblkOutp32(rFCPKDMAL, gPKANumSize);  // real number size

	while (!(Inp32(rFCINTPEND) & PKDMAINT));        // Waits for end of PKDMA
	SblkOutp32(rFCINTPEND, PKDMAINT);                   // clears the pending bit

    return 0;
}

//////////
// Function Name : SBLK_GetPKA
// Function Description : 
// 			copies output number from the segment seg_id. (PKSRAM -> DRAM)
// 			if the sign of src_id in PKA_SFR3 is negative,
// 			the output value is the sum of output and M.
// 			so the output value is always positive value.
// Input :
// 			src_id : segment id of source segment
// 			m_id : segment id having M value
// 			if m_id is in between 0 and 31, then m_id is normal segment id.
// 			if m_id is -1(all 1), m_id is invalid and default, prior m_id will be used.
// 			if m_id is over 31 than m_id may contains the address of M value in user space.
// Output : word aligned unsigned integer pointer to target buffer
// Version : 
// (GetPKA)

u32 SBLK_GetPKA_(u32* output, s32 seg_id, s32 m_id) 
{
    // register variables will be used in inline assembly code
    register u32 addr_m;
    register u32 addr_s;
    register u32 m, s, count, carry;
    // m should be transferred to stack to utilize cache,
    // for SFR(including PKSRAM) is in non-cachable area.
    // m is a public value, so this may not cause security issues.
    u32 buf_m[64];                          // 64word = 256byte = 2048bit

    Assert(output);
    Assert(seg_id >= 0 && seg_id < 32);

    // *output <- seg[seg_id]
	SblkOutp32(rFCPKDMAC, FCFLUSH);    	   
	SblkOutp32(rFCPKDMAC, FCDESCEND | FCTRANSMIT);	  // Little Endian FLUSH OFF, DESCEND, TX	 
	SblkOutp32(rFCPKDMAS, (u32)output); 	  // DRAM start address
	SblkOutp32(rFCPKDMAO, gPKASegSize * seg_id + gPKANumSize - 4);	// SRAM top offset
	SblkOutp32(rFCPKDMAL, gPKANumSize);  // real number size

	while (!(Inp32(rFCINTPEND) & PKDMAINT));        // Waits for end of PKDMA
	SblkOutp32(rFCINTPEND, PKDMAINT);                   // clears the pending bit


	if (!(Inp32(rPKA_SFR3) & SEG_NEG(seg_id)))      // if positive, OK
	    return 0;

    	// if negative, this value should be added with M

   	 if (m_id >= -1 && m_id <= 31)
   	 {         // if m_id is a reasonable id value
        	if (m_id == -1)                     // if m_id is all one value
            	m_id = gDefault_m_id;            // saved, default m_id is used

        	// *buf_m <- seg[m_id]
		SblkOutp32(rFCPKDMAS, (u32)buf_m);
	       SblkOutp32(rFCPKDMAO, gPKASegSize*m_id + gPKANumSize - 4);	// SRAM top offset
	       SblkOutp32(rFCPKDMAL, gPKANumSize);
       	
		while (!(Inp32(rFCINTPEND) & PKDMAINT));        // Waits for end of PKDMA
		SblkOutp32(rFCINTPEND, PKDMAINT);                   // clears the pending bit

	        // initializing registers for inline assembly code
	    	addr_m = (u32)buf_m + gPKANumSize;
   	 } 
   	 else 
   	 {                                // if m_id is too big number
        	addr_m = (u32)m_id + gPKANumSize;   // m_id may be a pointer to M value
   	 }

    	// initializing registers for inline assembly code
	addr_s = (u32)output + gPKANumSize;
    	carry = 0;                              // clears carry
    	count = gPKANumSize;                   // loop counter

    // S = S + M (Max 2048 bit addition, exactly count*32 bit addition)
    __asm {
loop:
        LDR m, [addr_m, #-4]!               // load m with pre -4
        LDR s, [addr_s, #-4]!               // load s with pre -4
        MSR CPSR_f, carry                   // load carry flag
        ADCS s, s, m                        // {carry, s} = s + m + carry
        MRS carry, CPSR                     // save carry flag
        STR s, [addr_s]                     // save s
        SUBS count, count, #4               // count = count - 4
        BNE loop                            // loop while count != 0
    }

    return 0;
}


//////////
// Function Name : SBLK_PKA
// Function Description : 
// 			calculates S = Montgomery Multipliation of A and B
// Input :
//		 a_id is the id of the segment where A value is stored.
//		 b_id is the id of the segment where B value is stored.
//		 if b_id is -1, the calculation is Montgomery Multipliation of A and 1
//		 m_id is the id of the segment where M value is stored.
//		 if m_id is -1, the m value stored in PKA is used again.
//		 s_id is the id of the segment where S value is stored.
//		 sign is the bits in which the i'th bit indicates the sign of i'th segment.
//		 if sign is -1, the sign value of the PKA_SFR3 is preserved.
// Output : word aligned unsigned integer pointer to target buffer
// Version : 
// (PKA)

u32 SBLK_PKA_(s32 a_id, s32 b_id, s32 m_id, s32 s_id, s32 sign) 
{

	u32 pka_sfr1 = EXEC_ON;

	Assert(a_id < 32);                      // negative value is OK
	Assert(b_id < 32);
	Assert(m_id < 32);
	Assert(s_id < 32);

	if (sign < 0)
	{                         // if sign is invalid
		     
	}
	else
	{                                // if sign is valid
		SblkOutp32(rPKA_SFR3, sign);	// sign value is updated
	}

	if (b_id < 0)
	{                         // if b_id is invalid
		SblkOutp32(rPKA_SFR4, gPKASfr4 | AX1);
	        b_id = 0;                           // b_id should be safe value
	}
	else
	{                                // if b_id is valid
		SblkOutp32(rPKA_SFR4, gPKASfr4 );	 // A x B       
	}

	if (m_id < 0)
	{                         // if m_id is invalid
       	m_id = gDefault_m_id;                // m_id should become a safe value
	}
	else
	{                                // if m_id is valid
       	gDefault_m_id = m_id;                // save m_id as default value
	       pka_sfr1 |= PLDM_ON;                // load new M
	}

	SblkOutp32(rPKA_SFR2, (A_SEG_ID(a_id) | B_SEG_ID(b_id)| M_SEG_ID(m_id) | S_SEG_ID(s_id)));
	SblkOutp32(rPKA_SFR1, pka_sfr1);	// starts calculation

	while ((Inp32(rPKA_SFR1) & EXEC_ON));
	return 0;
}


//////////
// Function Name : SBLK_PutPKA_CPU
// Function Description : 
// 			copies input number into the segment seg_id. (DRAM -> PKSRAM)
// Input :word aligned unsigned integer pointer to source data
//		dst_id : segment id of destination segment
//		 the same function as PutPKA except the CPU do copy instead of DMA
// Output :
// Version : 
// (PutPKA_CPU)

s32 SBLK_PutPKA_CPU_(u32* input, s32 seg_id) 
{

	u32 addr_src;
	u32 addr_dst;
	u32  count;
    
	Assert(input);
	Assert(seg_id >= 0 && seg_id < 32);

	addr_src = (u32)input;
	addr_dst = PKA_SRAM_BASE + gPKASegSize * seg_id + gPKANumSize - 4;
	count = gPKANumSize;

	for(;count>0;count-=4) 
		*((int*)addr_dst)-- = *((int*)addr_src)++;


    return 0;
}

//////////
// Function Name : SBLK_GetPKA_CPU
// Function Description : 
// 			copies output number from the segment seg_id. (PKSRAM -> DRAM)
//			if the sign of src_id in PKA_SFR3 is negative,
// 			the output value is the sum of output and M.
// 			so the output value is always positive value.
// Input :
// 			src_id : segment id of source segment
// 			m_id : segment id having M value
// 			if m_id is in between 0 and 31, then m_id is normal segment id.
// 			if m_id is -1(all 1), m_id is invalid and default, prior m_id will be used.
// 			if m_id is over 31 than m_id may contains the address of M value in user space.
// 			the same function as GetPKA except the CPU do copy instead of DMA
// Output :word aligned unsigned integer pointer to target buffer
// Version : 
// (GetPKA_CPU)


s32 SBLK_GetPKA_CPU_(u32* output, s32 seg_id, s32 m_id) 
{
	// register variables will be used in inline assembly code
	u32 addr_m;
	u32 addr_s;
	u32 m, s, count, carry;
	// m should be transferred to stack to utilize cache,
	// for SFR(including PKSRAM) is in non-cachable area.
	// m is a public value, so this may not cause security issues.
	u32 buf_m[64];                          // 64word = 256byte = 2048bit

	Assert(output);
	Assert(seg_id >= 0 && seg_id < 32);

	// *output <- seg[seg_id]

	addr_s = PKA_SRAM_BASE + gPKASegSize * seg_id + gPKANumSize - 4;	//src
	addr_m = (u32)output;												//dst
	count = gPKANumSize;


	for(;count>0;count-=4) 
		*((int*)addr_m)++ = *((int*)addr_s)--;


	if (!(Inp32(rPKA_SFR3) & SEG_NEG(seg_id)))      // if positive, OK
	    return 0;

    	// if negative, this value should be added with M

	if (m_id >= -1 && m_id <= 31)
	{         // if m_id is a reasonable id value
       	 if (m_id == -1)                     // if m_id is all one value
	            m_id = gDefault_m_id;            // saved, default m_id is used

       	 // *buf_m <- seg[m_id]
		addr_s = PKA_SRAM_BASE + gPKASegSize * m_id + gPKANumSize - 4;  //src
		addr_m = (u32)buf_m;												//dst
		count = gPKANumSize;


		for(;count>0;count-=4) 
			*((int*)addr_m)++ = *((int*)addr_s)--;



	        // initializing registers for inline assembly code
	    	addr_m = (u32)buf_m + gPKANumSize;
	} 
	else
	{                                // if m_id is too big number
       	 addr_m = (u32)m_id + gPKANumSize;   // m_id may be a pointer to M value
	}

    // initializing registers for inline assembly code
	addr_s = (u32)output + gPKANumSize;
	carry = 0;                              // clears carry
	count = gPKANumSize;                   // loop counter

	    // S = S + M (Max 2048 bit addition, exactly count*32 bit addition)
    __asm {
	loop3:
        LDR m, [addr_m, #-4]!               // load m with pre -4
        LDR s, [addr_s, #-4]!               // load s with pre -4
        MSR CPSR_f, carry                   // load carry flag
        ADCS s, s, m                        // {carry, s} = s + m + carry
        MRS carry, CPSR                     // save carry flag
        STR s, [addr_s]                     // save s
        SUBS count, count, #4               // count = count - 4
        BNE loop3                            // loop while count != 0
    }

    return 0;
}
#endif
/////////////////////////////////////////
///////    PKA Test - From Digital IP
/////////////////////////////////////////
 /*================================================  
 * Name : PKA_clear_segment(void)      
 * Function :
 *	- Clear all segment area (0x000~0x7FF)
 *	- Set PKA2 TCR_3 to zero.
 * Argument :
 *	There is no argumentint. 
 *================================================= SSS
 */
void PKA_clear_segment(void)  
{
	int loop;
	int* p_start = (int*)(PKA_SRAM_BASE);
	
	for (loop=128*(16/sizeof(word)); loop>0; loop--) {
		*(p_start++) = 0; 
	}
	
	// clear SEG_SIGN
	SblkOutp32(rPKA_SFR3, 0x00);
}

 /*================================================  
 * Name : PKA_clear_sfr(void)      
 * Function :
 *	- Clear all SFR (SFR0 ~ SFR4) 
 *================================================= SSS
 */
void PKA_clear_sfr(void)  
{
	SblkOutp32(rPKA_SFR0, 0x00);
	SblkOutp32(rPKA_SFR1, 0x00);
	SblkOutp32(rPKA_SFR2, 0x00);
	SblkOutp32(rPKA_SFR3, 0x00);
	SblkOutp32(rPKA_SFR4, 0x00);

}

/*================================================ SSS  
 * Name : PKA_run(int run_value)     
 * Function :
 *	- Control the start of the PKA2 operation.
 * Argument :
 * 	- int run_value : TCR_1 set up value
 *		run_value = 0x09 : Run PKA2 with PLDM_ON
 *		run_value = 0x01 : Run PKA2 without PLDM_ON  
 *================================================= SSS
 */
void PKA_run(int run_value) 
{
	int read_tcr1;
	int polling=1;
	
	SblkOutp32(rPKA_SFR1, run_value);
	
	// continue polling while TORNADO running for FPGA
	while(polling)  {
		read_tcr1 = Inp32(rPKA_SFR1);
		polling = read_tcr1 & 0x01;
		
	}	
}

/*================================================ SSS  
 * Name : PKA_neg_pos(int Dest, mpi MSec_ptr)     
 * Function :
 *	- checks TCR_3 SEG_SIGN value of Dest and 
 *   	  changes negative output segment value to positive value. 
 *	- This function uses Modulus value stored in Seg0
 * Argument :
 *  - int Dest : Number to the destination segment.(S_SEG_ID) 
 *	- int Src  : Number to the source segment.(A_SEG_ID)
 *=================================================	SSS
 */
void PKA_neg_pos(int Dest, mpi MSec_ptr) 
{
	int read_tcr3, write_tcr3;
	int read_tcr4;
	int read_tcr0;
	int read, mask, carry=0;
	

	// Mask Src SEG_SIGN value.
	mask = (0x00000001 << Dest);
	SblkInp32(rPKA_SFR3, read_tcr3);
	read = (read_tcr3 & mask);
	
	if (read)  {
		mpi p_Dest;
		mpi p_mod = MSec_ptr;
		
		// clear Dest sign bit in TCR_3
		write_tcr3 = read_tcr3 & ~mask; 
		SblkOutp32(rPKA_SFR3, write_tcr3);
		
		// read TCR_4 SEG_SIZE value
		SblkInp32(rPKA_SFR4, read_tcr4);
		read = (read_tcr4 & 0x060) >>5;
			
	 	// Change segment to pointer value.
	 	switch (read)	{
			case 0 : 
	   		p_Dest = (mpi)(PKA_SRAM_BASE+((int)Dest<<8));
	   		break;
	
	  		case 1 : 
	   		p_Dest = (mpi)(PKA_SRAM_BASE+((int)Dest<<7));
	   		break;
	  
		  	case 2 : 
	   		p_Dest = (mpi)(PKA_SRAM_BASE+((int)Dest<<6));
	   		break;
	   		
	  		default : 	
	 		p_Dest = (mpi)(PKA_SRAM_BASE+((int)Dest<<8));
	 	}
		
			
		SblkInp32(rPKA_SFR0, read_tcr0);
		read = (((read_tcr0 & 0x78) >>3)+1)* ((read_tcr0 & 0x03)+1);
		
		read = read*(4/sizeof(word));
		// add modulus + Dest 
		do {
    			word x,y,z;
    				x = *p_Dest;
				y = *p_mod++;
				z = x + y + carry;
				*p_Dest++ = z;
				if (z<x) carry=1;
				// if z==x preserve carry 
				if (z>x) carry=0;
			} while (--read);	
	}		
}


/*=========================================================   
 * Name 	: PKA_Init(Uint CTR0, Uint CTR1, Uint CTR2, Uint CTR3, Uint CTR4)     
 * Function : intialize & setting PKA_SFRs (SFR0 ~ SFR4) 
 *========================================================= 
 */
void PKA_Init(u32 CTR0, u32 CTR1, u32 CTR2, u32 CTR3, u32 CTR4) 
{
	int tcr0, tcr1, tcr2, tcr3, tcr4; 

	tcr0 = CTR0 & 0x7B;			
	tcr1 = CTR1 & 0x09; 	
	tcr2 = CTR2;	
	tcr3 = CTR3;	
	tcr4 = CTR4 & 0x61;


	// (1) PKA_SFR0 setting	
	SblkOutp32(rPKA_SFR0, tcr0);
		
	// (2) PKA_SFR1 setting (PLDM_ON)
	SblkOutp32(rPKA_SFR1, tcr1);
		
	// (3) PKA_SFR2 setting
	SblkOutp32(rPKA_SFR2, tcr2);
		
	// (4) PKA_SFR3 setting
	SblkOutp32(rPKA_SFR3, tcr3);
		
	// (5) PKA_SFR4 setting	
	SblkOutp32(rPKA_SFR4, tcr4);
					
}

/*=========================================================   
 * Name 	: PKA_Select_SegmentSize(Uint CTR4)     
 * Function : select Segment size (64Byte, 128Byte, 256Byte) 
 *========================================================= 
 */
u32 PKA_Select_SegmentSize(u32 CTR4) 
{
	u32 seg_sz;
	
	seg_sz = ( CTR4 & 0x60 ) >> 5;
		
		
	switch (seg_sz) {
		case 0 : seg_sz = 256;
			 break;
		case 1 : seg_sz = 128;
			 break;
		case 2 : seg_sz = 64;
			 break;
	}	
	
	return seg_sz;					
}


 
/*=========================================================   
 * Name 	: PutPKA_DMA(u32* start_addr, s32 seg_id, u32 seg_sz, u32 real_num_sz )     
 * Function : load input data by DMA	 
 *========================================================= 
 */
s32 PutPKA_DMA(u32* start_addr, u32 seg_id, u32 seg_sz, u32 real_num_sz ) 
{

    Assert(start_addr);
    Assert(seg_id < 32);

	SblkOutp32(rFCPKDMAC, FCFLUSH);    	   
	SblkOutp32(rFCPKDMAC, FCDESCEND);	  // Little Endian FCFLUSH OFF, DESCEND, RX 	 
	SblkOutp32(rFCPKDMAS, (u32)start_addr); 	  // DRAM start address
	SblkOutp32(rFCPKDMAO, seg_sz * seg_id + real_num_sz - 4);	// SRAM top offset
	SblkOutp32(rFCPKDMAL, real_num_sz);  // real number size

	while (!(Inp32(rFCINTPEND) & PKDMAINT));        // Waits for end of PKDMA
	SblkOutp32(rFCINTPEND, PKDMAINT);                   // clears the pending bit

    return 0;
	
}



/*=========================================================   
 * Name 	: GetPKA_DMA(u32* dest_addr, s32 seg_id, u32 seg_sz, u32 real_num_sz )     
 * Function : load input data by DMA	 
 *========================================================= 
 */
s32 GetPKA_DMA(u32* dest_addr, u32 seg_id, u32 seg_sz, u32 real_num_sz ) {

    Assert(dest_addr);
    Assert(seg_id < 32);

	SblkOutp32(rFCPKDMAC, FCFLUSH);    	   
	SblkOutp32(rFCPKDMAC,  FCTRANSMIT);	  // Little Endian FLUSH OFF, DESCEND, TX	 
	SblkOutp32(rFCPKDMAS, (u32)dest_addr); 	  // DRAM start address
	SblkOutp32(rFCPKDMAO, seg_sz * seg_id );	// SRAM top offset
	SblkOutp32(rFCPKDMAL, real_num_sz);  // real number size

	while (!(Inp32(rFCINTPEND) & PKDMAINT));        // Waits for end of PKDMA
	SblkOutp32(rFCINTPEND, PKDMAINT);                   // clears the pending bit
	
	return 0;
}


//////////
// Function Name : SBLK_InitPKA
// Function Description : 
// 				Initializes PKA with segment size, chunk size and precision id.
//				Initialize the SFR
// Input :
//		ePKACtrl :			
// Output : NONE
// Version : 
// (InitPKA)

u32 SBLK_InitPKA(PKACtrl  ePKACtrl )
{
	u32 uRegValue;

	//s32 seg_size, s32 chunk_bits, s32 prec_id

	// (1) PKA_SRF0 Setting : Precision ID, CHUCK Size
	uRegValue = ((ePKACtrl.eCHUNKSZ<<3)|
			      ((ePKACtrl.ePREC == PKA_SINGLE)?(0<<0):(ePKACtrl.ePREC == PKA_DOUBLE)?(1<<0):(ePKACtrl.ePREC == PKA_TRIPLE)?(2<<0):(3<<0)));
	SblkOutp32(rPKA_SFR0, uRegValue);
	
	// (2) PKA_SFR1 Setting : Preload M
	uRegValue = (((ePKACtrl.ePLDM == PKA_PLDMOFF)?(0<<3):(1<<3))|(0<<0));
	SblkOutp32(rPKA_SFR1, uRegValue);

	// (3) PKA_SFR2 Setting : Segment ID
	uRegValue = ((ePKACtrl.uSEGID_A<<24)|(ePKACtrl.uSEGID_B<<16)|(ePKACtrl.uSEGID_M<<8)|
				(ePKACtrl.uSEGID_S<<0));
	SblkOutp32(rPKA_SFR2, uRegValue);
	
	// (4) PKA_SFR3 Setting : Sign of the numbers in the segments
	SblkOutp32(rPKA_SFR3, ePKACtrl.uSIGN);


	// (5) PKA_SFR4 Setting : Segment Size & Function of the Multiplier
	uRegValue = (((ePKACtrl.eSEGSZ == PKA_FULL)?(0<<5):(ePKACtrl.eSEGSZ == PKA_HALF)?(1<<5):(2<<5))|
				((ePKACtrl.ePKAFUNC == PKA_MulAXB)?(0<<0):(1<<0)));
	SblkOutp32(rPKA_SFR4, uRegValue);

	// Setting of the Golbal Parameter
	gPKANumSize = ((ePKACtrl.eCHUNKSZ+1)<<2)*(ePKACtrl.ePREC);  // chunk_bits/8 * [1~4]
	gPKASegSize = ePKACtrl.eSEGSZ;      		        // [256, 128, 64]
	
	return 0;
}

void SBLK_RunPKA(void) 
{
	u32 uRegValue;
	u32 polling=1;

	SblkOutp32(rPKA_SFR1, Inp32(rPKA_SFR1)|(1<<0));	// EXEC ON

	// continue polling while TORNADO running for FPGA
	while(polling)  {
		uRegValue = Inp32(rPKA_SFR1);
		polling = uRegValue & 0x01;
		
	}	
}


void SBLK_ClrSegmentPKA(void)  
{
	u32 loop;
	u32* p_start = (u32*)(PKA_SRAM_BASE);
	
	for (loop=128*(16/sizeof(word)); loop>0; loop--) {
		*(p_start++) = 0; 
	}
	
	// clear SEG_SIGN
	SblkOutp32(rPKA_SFR3, 0x00);
}

 /*================================================  
 * Name : PKA_clear_sfr(void)      
 * Function :
 *	- Clear all SFR (SFR0 ~ SFR4) 
 *================================================= SSS
 */
void SBLK_ClrSfrPKA(void)  
{
	SblkOutp32(rPKA_SFR0, 0x00);
	SblkOutp32(rPKA_SFR1, 0x00);
	SblkOutp32(rPKA_SFR2, 0x00);
	SblkOutp32(rPKA_SFR3, 0x00);
	SblkOutp32(rPKA_SFR4, 0x00);

}

/*=========================================================   
 * Name 	: PutPKA_DMA(u32* start_addr, s32 seg_id, u32 seg_sz, u32 real_num_sz )     
 * Function : load input data by DMA	 
 *========================================================= 
 */
s32 SBLK_PutPKADMA(u32* start_addr, u32 seg_id ) 
{

	SblkOutp32(rFCPKDMAC, FCFLUSH);    	   
	SblkOutp32(rFCPKDMAC, FCDESCEND);	  // Little Endian FCFLUSH OFF, DESCEND, RX 	 
	SblkOutp32(rFCPKDMAS, (u32)start_addr); 	  // DRAM start address
	SblkOutp32(rFCPKDMAO, gPKASegSize * seg_id + gPKANumSize - 4);	// SRAM top offset
	SblkOutp32(rFCPKDMAL, gPKANumSize);  // real number size

	if(Sblock_INTMD)
	{
		while(!g_SDma1Done);
		g_SDma1Done = 0;
	}
	else
	{
		SBLK_IsDMADone();
	}	

	//while (!(Inp32(rFCINTPEND) & PKDMAINT));        // Waits for end of PKDMA
	//SblkOutp32(rFCINTPEND, PKDMAINT);                   // clears the pending bit

    return 0;
	
}

s32 SBLK_GetPKADMA(u32* dest_addr, u32 seg_id ) 
{

    Assert(dest_addr);
    Assert(seg_id < 32);

	SblkOutp32(rFCPKDMAC, FCFLUSH);    	   
	SblkOutp32(rFCPKDMAC, FCDESCEND|FCTRANSMIT);	  // Little Endian FLUSH OFF, DESCEND, TX	 
	SblkOutp32(rFCPKDMAS, (u32)dest_addr); 	  // DRAM start address
	SblkOutp32(rFCPKDMAO, gPKASegSize * seg_id + gPKANumSize - 4 );	// SRAM top offset
	SblkOutp32(rFCPKDMAL, gPKANumSize);  // real number size

	if(Sblock_INTMD)
	{
		while(!g_SDma1Done);
		g_SDma1Done = 0;
	}
	else
	{
		SBLK_IsDMADone();
	}	

	//while (!(Inp32(rFCINTPEND) & PKDMAINT));        // Waits for end of PKDMA
	//SblkOutp32(rFCINTPEND, PKDMAINT);                   // clears the pending bit
	
	return 0;
}

s32 SBLK_GetPKA(u32* out_addr, u32 seg_id ) 
{
	// register variables will be used in inline assembly code
	u32 addr_m;
	u32 addr_s;
	u32 count;

	// *output <- seg[seg_id]
	addr_s = PKA_SRAM_BASE + gPKASegSize * seg_id + gPKANumSize - 4;	//src
	//addr_s = (PKA_SRAM_BASE+(seg_id*gPKASegSize));
	addr_m = (u32)out_addr;											//dst

	count = gPKANumSize;


	for(;count>0;count-=4) 
		*((int*)addr_m)++ = *((int*)addr_s)--;
	
	return 0;
}


void SBLK_NegPosPKA(u32 uID_S, u32 uID_M) 
{
	u32 read_tcr3, write_tcr3;
	u32 read_tcr4;
	u32 read_tcr0;
	u32 read, mask, carry=0;
	volatile u32  *p_Dest, *p_mod;

	// Mask Src SEG_SIGN value.
	mask = (0x00000001 << uID_S);
	SblkInp32(rPKA_SFR3, read_tcr3);
	read = (read_tcr3 & mask);
	
	if (read)  {
		
		//p_mod = MSec_ptr;
		p_mod =  (u32 *)(PKA_SRAM_BASE+(uID_M*gPKASegSize));
		
		// clear Dest sign bit in TCR_3
		write_tcr3 = read_tcr3 & ~mask; 
		SblkOutp32(rPKA_SFR3, write_tcr3);
		
		// read TCR_4 SEG_SIZE value
		SblkInp32(rPKA_SFR4, read_tcr4);
		read = (read_tcr4 & 0x060) >>5;
			
	 	// Change segment to pointer value.
	 	switch (read)	{
			case 0 : 
	   		p_Dest = (u32 *)(PKA_SRAM_BASE+((u32)uID_S<<8));
	   		break;
	
	  		case 1 : 
	   		p_Dest =(u32 *)(PKA_SRAM_BASE+((u32)uID_S<<7));
	   		break;
	  
		  	case 2 : 
	   		p_Dest = (u32 *)(PKA_SRAM_BASE+((u32)uID_S<<6));
	   		break;
	   		
	  		default : 	
	 		p_Dest = (u32 *)(PKA_SRAM_BASE+((u32)uID_S<<8));
	 	}
		
			
		SblkInp32(rPKA_SFR0, read_tcr0);
		read = (((read_tcr0 & 0x78) >>3)+1)* ((read_tcr0 & 0x03)+1);
		
		read = read*(4/sizeof(word));
		// add modulus + Dest 
		do {
    			word x,y,z;
    				x = *p_Dest;
				y = *p_mod++;
				z = x + y + carry;
				*p_Dest++ = z;
				if (z<x) carry=1;
				// if z==x preserve carry 
				if (z>x) carry=0;
			} while (--read);	
	}		
}



//mpi SBLK_LoadDataPKA(u32 CTR0, u32 CTR2, u32 seg_sz, int* w_cnt, int old_w_cnt, u32 test_sel, u32 dma_sel)
void SBLK_LoadDataPKA(PKACtrl ePKACtrl, u32 *p_input_a, u32 *p_input_b, u32 *p_input_m,  u32* w_cnt, u32 old_w_cnt)
{
	
	u32 A_SEG_ID, B_SEG_ID, M_SEG_ID; 
	u32 chnk, prec;
	volatile u32 *ptr_p_a, *ptr_p_b, *ptr_p_m;
	u32 i, idx;
	//
	
	A_SEG_ID = ePKACtrl.uSEGID_A;
	B_SEG_ID = ePKACtrl.uSEGID_B;
	M_SEG_ID = ePKACtrl.uSEGID_M;
		
	*w_cnt = (ePKACtrl.eCHUNKSZ+ 1) * (ePKACtrl.ePREC);

	// Load input data (A, B, M)
	ptr_p_a = (u32 *)(PKA_SRAM_BASE+(A_SEG_ID*gPKASegSize));
	ptr_p_b = (u32 *)(PKA_SRAM_BASE+(B_SEG_ID*gPKASegSize));
	ptr_p_m = (u32 *)(PKA_SRAM_BASE+(M_SEG_ID*gPKASegSize));
		
	if (ePKACtrl.eFIFOMD	== SBLK_FIFO)	
	{
		#if 0
		SBLK_PutPKADMA((u32*)&p_input_a[old_w_cnt], A_SEG_ID);
		SBLK_PutPKADMA((u32*)&p_input_b[old_w_cnt], B_SEG_ID);
		SBLK_PutPKADMA((u32*)&p_input_m[old_w_cnt], M_SEG_ID);
		#endif
		#if 1
		SBLK_PutPKADMA((u32*)p_input_a, A_SEG_ID);
		SBLK_PutPKADMA((u32*)p_input_b, B_SEG_ID);
		SBLK_PutPKADMA((u32*)p_input_m, M_SEG_ID);
		#endif
	}
	else
	{
		#if 0	
		idx = *w_cnt -1 + old_w_cnt;
		//idx = 3;
		
		for(i=0; i<*w_cnt; i++) 
		{			
			*(ptr_p_a + i) = p_input_a[idx-i];
			*(ptr_p_b + i) = p_input_b[idx-i];
			*(ptr_p_m + i) = p_input_m[idx-i];
		}
		#endif

		idx = *w_cnt -1 ;
		
		for(i=0; i<*w_cnt; i++) 
		{			
			*(ptr_p_a + i) = p_input_a[idx-i];
			*(ptr_p_b + i) = p_input_b[idx-i];
			*(ptr_p_m + i) = p_input_m[idx-i];
		}
		
	}
  	
 }








/////////////////////////////////////////////////////
//////////
// Function Name : SBLK_FlushDMA
// Function Description : This function  initialize AES Engine 
// Input : 				SBLK_DMA
//						
// Output : NONE
// Version : 
void SBLK_FlushDMA(SBLK_DMA eDMAType)
{
	if(eDMAType == BRDMA)
	{
		SblkOutp32(rFCBRDMAC, 0x1);
		SblkOutp32(rFCBRDMAC, 0x0);
	}
	else if (eDMAType == BTDMA)
	{
		SblkOutp32(rFCBTDMAC, 0x1);
		SblkOutp32(rFCBRDMAC, 0x0);
	}
	else if (eDMAType == HRDMA)
	{
		SblkOutp32(rFCHRDMAC, 0x1);
		SblkOutp32(rFCHRDMAC, 0x0);
	}
	else if (eDMAType == PKDMA)
	{
		SblkOutp32(rFCPKDMAC, 0x1);
		SblkOutp32(rFCPKDMAC, 0x0);
	}
}

//////////
// Function Name : SBLK_ClearIntPending
// Function Description : This function  set SDMA1 
// Input :   uRxSrcAddr,uRxSize,uTxDstAddr,uTxSize	 (Size: byte)		
// Output : NONE
// Version : 
void SBLK_SetDMA(u32 uRxSrcAddr, u32 uRxSize, u32 uTxDstAddr, u32 uTxSize)
{
	u32 uRxByte, uTxByte;
	u32 uDISwap;
	
	uRxByte = uRxSize<<2;
	uTxByte = uTxSize<<2;

	if(((oSblk.m_eRDMASwap == SBLK_NoSwap)&&(oSblk.m_eDISwap == SBLK_NoSwap))||((oSblk.m_eRDMASwap == SBLK_Swap)&&(oSblk.m_eDISwap == SBLK_Swap)))
		byteswaplen((u32 *)uRxSrcAddr,(u32 *)INPUT_BUF ,uRxSize);


	if(oSblk.m_eSblkType == AES)
	{
		SBLK_FlushDMA(BRDMA);
		SBLK_FlushDMA(BTDMA);
		uDISwap = (Inp32(rAES_CONTROL)>>11)&0x1;

		if(oSblk.m_eRDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCBRDMAC, 0<<1);
		else
			SblkOutp32(rFCBRDMAC, 1<<1);

		if(oSblk.m_eTDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCBTDMAC, 0<<1);
		else
			SblkOutp32(rFCBTDMAC, 1<<1);
		
		
		SblkOutp32(rFCFIFOCTRL, (0<<2)|(0<<0));		// AES

		if(((oSblk.m_eRDMASwap == SBLK_NoSwap)&&(oSblk.m_eDISwap == SBLK_NoSwap))||((oSblk.m_eRDMASwap == SBLK_Swap)&&(oSblk.m_eDISwap == SBLK_Swap)))
			SblkOutp32(rFCBRDMAS, INPUT_BUF);
		else
			SblkOutp32(rFCBRDMAS, (u32)uRxSrcAddr);
		
		SblkOutp32(rFCBTDMAS, (u32)uTxDstAddr);
		while(uRxByte>0|uTxByte>0)
		{
			if(uRxByte<16|uTxByte<16)
				{
					SblkOutp32(rFCBTDMAL, uTxByte);
					SblkOutp32(rFCBRDMAL, uRxByte);
				}
		
			SblkOutp32(rFCBTDMAL, 16);
			SblkOutp32(rFCBRDMAL, 16);

			if(Sblock_INTMD)
			{
				while(!g_SDma1Done);
				g_SDma1Done = 0;
			}
			else
			{
				SBLK_IsDMADone();
			}	
			
			if(uRxByte<16|uTxByte<16)
			{	
				uRxByte = 0;
			       uTxByte = 0;
			}
			else 
			{
			uRxByte = uRxByte-16;
			uTxByte = uTxByte-16;
			}
		}
	}
	else if((oSblk.m_eSblkType == DES)|(oSblk.m_eSblkType == TDES))
	{

		uDISwap = (Inp32(rTDES_CONF)>>9)&0x1;

	
		SBLK_FlushDMA(BRDMA);
		SBLK_FlushDMA(BTDMA);

		if(oSblk.m_eRDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCBRDMAC, 0<<1);
		else
			SblkOutp32(rFCBRDMAC, 1<<1);

		if(oSblk.m_eTDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCBTDMAC, 0<<1);
		else
			SblkOutp32(rFCBTDMAC, 1<<1);

		#if 0
		if(uDISwap == 0)
		{
			SblkOutp32(rFCBRDMAC, 1<<1);		// for Little Endian System, It depend on Golden Data
			SblkOutp32(rFCBTDMAC, 1<<1);		// for Little Endian System
		}
		else
		{
			SblkOutp32(rFCBRDMAC, 0<<1);		// for Little Endian System
			SblkOutp32(rFCBTDMAC, 0<<1);		// for Little Endian System
		}
		#endif
		//SblkOutp32(rFCBRDMAC, 1<<1);		// for Little Endian System
		//SblkOutp32(rFCBRDMAC, 1<<1);		// for Little Endian System
		SblkOutp32(rFCFIFOCTRL, 1<<2);		// DES

		if(((oSblk.m_eRDMASwap == SBLK_NoSwap)&&(oSblk.m_eDISwap == SBLK_NoSwap))||((oSblk.m_eRDMASwap == SBLK_Swap)&&(oSblk.m_eDISwap == SBLK_Swap)))
			SblkOutp32(rFCBRDMAS, INPUT_BUF);
		else
			SblkOutp32(rFCBRDMAS, (u32)uRxSrcAddr);
		//SblkOutp32(rFCBRDMAS, (u32)uRxSrcAddr);
		SblkOutp32(rFCBTDMAS, (u32)uTxDstAddr);
		#if 0	
		while(uRxByte>0|uTxByte>0)
		{
			if(uRxByte<8|uTxByte<8)
				{
					SblkOutp32(rFCBTDMAL, uTxByte);
					SblkOutp32(rFCBRDMAL, uRxByte);
				}
		
			SblkOutp32(rFCBTDMAL, 8);
			SblkOutp32(rFCBRDMAL, 8);
			while(!(Inp32(rFCINTPEND) & 0x4));
			SblkOutp32(rFCINTPEND, 0x4);
			if(uRxByte<8|uTxByte<8)
			{	
				uRxByte = 0;
			       uTxByte = 0;
			}
			else 
			{
			uRxByte = uRxByte-8;
			uTxByte = uTxByte-8;
			}
		}
		#endif
		SblkOutp32(rFCBTDMAL, uTxByte);
		SblkOutp32(rFCBRDMAL, uRxByte);

		if(Sblock_INTMD)
		{
			while(!g_SDma1Done);
			g_SDma1Done = 0;
		}
		else
		{
			SBLK_IsDMADone();
		}	
		
	}


	if(((oSblk.m_eTDMASwap == SBLK_NoSwap)&&(oSblk.m_eDOSwap == SBLK_NoSwap))||((oSblk.m_eTDMASwap == SBLK_Swap)&&(oSblk.m_eDOSwap == SBLK_Swap)))
		byteswaplen((u32 *)uTxDstAddr,(u32 *)uTxDstAddr ,uTxSize);


}

void SBLK_SetDMAt(u32 uRxSrcAddr, u32 uRxSize, u32 uTxDstAddr, u32 uTxSize)
{
	u32 uRxByte, uTxByte;
	u32 uDISwap;
	
	uRxByte = uRxSize<<2;
	uTxByte = uTxSize<<2;

	
	if(oSblk.m_eSblkType == AES)
	{
		SBLK_FlushDMA(BRDMA);
		SBLK_FlushDMA(BTDMA);
		uDISwap = (Inp32(rAES_CONTROL)>>11)&0x1;

		if(oSblk.m_eRDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCBRDMAC, 0<<1);
		else
			SblkOutp32(rFCBRDMAC, 1<<1);

		if(oSblk.m_eTDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCBTDMAC, 0<<1);
		else
			SblkOutp32(rFCBTDMAC, 1<<1);
		
		
		SblkOutp32(rFCFIFOCTRL, (0<<2)|(0<<0));		// AES

		SblkOutp32(rFCBRDMAS, (u32)uRxSrcAddr);
		SblkOutp32(rFCBTDMAS, (u32)uTxDstAddr);
		
 
		SblkOutp32(rFCBTDMAL, uTxByte);
		SblkOutp32(rFCBRDMAL, uRxByte);
		 

			if(Sblock_INTMD)
			{
				while(!g_SDma1Done);
				g_SDma1Done = 0;
			}
			else
			{
				SBLK_IsDMADone();
			}	
			
		 
			}

	else if((oSblk.m_eSblkType == DES)|(oSblk.m_eSblkType == TDES))
	{

		//uDISwap = (Inp32(rTDES_CONF)>>9)&0x1;
	
		SBLK_FlushDMA(BRDMA);
		SBLK_FlushDMA(BTDMA);

		if(oSblk.m_eRDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCBRDMAC, 0<<1);
		else
			SblkOutp32(rFCBRDMAC, 1<<1);

		if(oSblk.m_eTDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCBTDMAC, 0<<1);
		else
			SblkOutp32(rFCBTDMAC, 1<<1);

		#if 0
		if(uDISwap == 0)
		{
			SblkOutp32(rFCBRDMAC, 1<<1);		// for Little Endian System, It depend on Golden Data
			SblkOutp32(rFCBTDMAC, 1<<1);		// for Little Endian System
		}
		else
		{
			SblkOutp32(rFCBRDMAC, 0<<1);		// for Little Endian System
			SblkOutp32(rFCBTDMAC, 0<<1);		// for Little Endian System
		}
		#endif
		//SblkOutp32(rFCBRDMAC, 1<<1);		// for Little Endian System
		//SblkOutp32(rFCBRDMAC, 1<<1);		// for Little Endian System
		SblkOutp32(rFCFIFOCTRL, 1<<2);		// DES

 
		SblkOutp32(rFCBRDMAS, (u32)uRxSrcAddr);
		//SblkOutp32(rFCBRDMAS, (u32)uRxSrcAddr);
		SblkOutp32(rFCBTDMAS, (u32)uTxDstAddr);
	 
		SblkOutp32(rFCBTDMAL, uTxByte);
		SblkOutp32(rFCBRDMAL, uRxByte);

		if(Sblock_INTMD)
		{
			while(!g_SDma1Done);
			g_SDma1Done = 0;
		}
		else
		{
			SBLK_IsDMADone();
		}	
		
	}


}

/////////////////////////////////////////////////////
//////////
// Function Name : SBLK_AESInit
// Function Description : This function  initialize AES Engine 
// Input : 				AESCtrl :  Control Parameter of AES engine
//						key,iv,cnt : Address of the Key, IV, Counter value
// Output : NONE
// Version : 
void SBLK_AESInit(AESCtrl eAESCtrl, u32 *key, u32 *iv, u32 *cnt)
{
	u32 uReg;
	u32 i;
	u32 *pDstAddr;

	oSblk.m_eSblkType = AES;
	oSblk.m_eOperMode = eAESCtrl.eOperMode;
	oSblk.m_eDir = eAESCtrl.eDir;
	

	//01. Set-up Control Register
	#if 0
	uReg = ((0<<7)|((eAESCtrl.eKeyMD == NChangeKey)?(0<<6):(1<<6))|			// No Byte Swap
		    ((eAESCtrl.eKeySz == Key128b)?(0<<4):(eAESCtrl.eKeySz==Key192b)?(1<<4):(2<<4))|
	           ((eAESCtrl.eFIFOMD == SBLK_CPU)? (0<<3):(1<<3))|
	           ((eAESCtrl.eOperMode== ECB)?(0<<1):(eAESCtrl.eOperMode==CBC)?(1<<1):(2<<1))|
	           ((eAESCtrl.eDir == ENC)?0:1));
	#endif
	uReg = (((eAESCtrl.eDISwap==SBLK_NoSwap)?(0<<11):(1<<11))|
		    ((eAESCtrl.eDOSwap==SBLK_NoSwap)?(0<<10):(1<<10))|
		    ((eAESCtrl.eIVSwap==SBLK_NoSwap)?(0<<9):(1<<9))|
		    ((eAESCtrl.eCNTSwap==SBLK_NoSwap)?(0<<8):(1<<8))|
		    ((eAESCtrl.eKEYSwap==SBLK_NoSwap)?(0<<7):(1<<7))|(1<<6)|			
		    ((eAESCtrl.eKeySz == Key128b)?(0<<4):(eAESCtrl.eKeySz==Key192b)?(1<<4):(2<<4))|
	           ((eAESCtrl.eFIFOMD == SBLK_CPU)? (0<<3):(1<<3))|
	           ((eAESCtrl.eOperMode== ECB)?(0<<1):(eAESCtrl.eOperMode==CBC)?(1<<1):(2<<1))|
	           ((eAESCtrl.eDir == ENC)?0:1));
	SblkOutp32(rAES_CONTROL, uReg);

	// Golden Data is made by Big Endian bsed
	if(eAESCtrl.eKEYSwap == SBLK_NoSwap)
		byteswaplen(key, key, 8);
	if(eAESCtrl.eIVSwap == SBLK_NoSwap)
		byteswaplen(iv, iv, 4);
	if(eAESCtrl.eCNTSwap == SBLK_NoSwap)
		byteswaplen(cnt, cnt, 4);
	oSblk.m_eDISwap = eAESCtrl.eDISwap;
	oSblk.m_eDOSwap = eAESCtrl.eDOSwap;
	oSblk.m_eRDMASwap = eAESCtrl.eDMASwap;
	oSblk.m_eTDMASwap = eAESCtrl.eDMASwap;
	
	//02. Set Key, IV and Counter value	
	if(eAESCtrl.eKeySz == Key128b)
	{
		Copy((u32)key, rAES_KEYDATA_05, 4);
		
	}
	else if (eAESCtrl.eKeySz == Key192b)
	{
		Copy((u32)key, rAES_KEYDATA_03, 6);
	
	}
	else if (eAESCtrl.eKeySz == Key256b)
	{
		Copy((u32)key, rAES_KEYDATA_01, 8);
		
	}

	if(eAESCtrl.eOperMode == CBC)
	{
		Copy((u32)iv, rAES_IVDATA_01, 4);
	}
	else if (eAESCtrl.eOperMode == CTR )
	{
		Copy((u32)cnt, rAES_CNTDATA_01, 4);
	}

	#if 0		// Fail
	if(eAESCtrl.eKeyMD == NChangeKey)
	{
		SblkOutp32(rAES_CONTROL, Inp32(rAES_CONTROL)&(~AES_CHANGE	));			
	}
	#endif

	// Return Golden Data
	if(eAESCtrl.eKEYSwap == SBLK_NoSwap)
		byteswaplen(key, key, 8);
	if(eAESCtrl.eIVSwap == SBLK_NoSwap)
		byteswaplen(iv, iv, 4);
	if(eAESCtrl.eCNTSwap == SBLK_NoSwap)
		byteswaplen(cnt, cnt, 4);

}

#if 0	// Temp. 
void SBLK_AESInit(AESCtrl eAESCtrl, u32 *key, u32 *iv, u32 *cnt)
{
	u32 uReg;
	u32 i;
	u32 *pDstAddr;

	oSblk.m_eSblkType = AES;
	oSblk.m_eOperMode = eAESCtrl.eOperMode;

	//01. Set-up Control Register
	#if 0
	uReg = ((0<<7)|((eAESCtrl.eKeyMD == NChangeKey)?(0<<6):(1<<6))|			// No Byte Swap
		    ((eAESCtrl.eKeySz == Key128b)?(0<<4):(eAESCtrl.eKeySz==Key192b)?(1<<4):(2<<4))|
	           ((eAESCtrl.eFIFOMD == SBLK_CPU)? (0<<3):(1<<3))|
	           ((eAESCtrl.eOperMode== ECB)?(0<<1):(eAESCtrl.eOperMode==CBC)?(1<<1):(2<<1))|
	           ((eAESCtrl.eDir == ENC)?0:1));
	#endif
	uReg = ((0x1f<<7)|(1<<6)|			//  Byte Swap,  Key Init
		    ((eAESCtrl.eKeySz == Key128b)?(0<<4):(eAESCtrl.eKeySz==Key192b)?(1<<4):(2<<4))|
	           ((eAESCtrl.eFIFOMD == SBLK_CPU)? (0<<3):(1<<3))|
	           ((eAESCtrl.eOperMode== ECB)?(0<<1):(eAESCtrl.eOperMode==CBC)?(1<<1):(2<<1))|
	           ((eAESCtrl.eDir == ENC)?0:1));
	SblkOutp32(rAES_CONTROL, uReg);


	
	//02. Set Key, IV and Counter value	
	if(eAESCtrl.eKeySz == Key128b)
	{
		Copy((u32)key, rAES_KEYDATA_05, 4);
		
	}
	else if (eAESCtrl.eKeySz == Key192b)
	{
		Copy((u32)key, rAES_KEYDATA_03, 6);
	
	}
	else if (eAESCtrl.eKeySz == Key256b)
	{
		Copy((u32)key, rAES_KEYDATA_01, 8);
		
	}


	if(eAESCtrl.eOperMode == CBC)
	{
		Copy((u32)iv, rAES_IVDATA_01, 4);
	}
	else if (eAESCtrl.eOperMode == CTR )
	{
		Copy((u32)cnt, rAES_CNTDATA_01, 4);
	}

	#if 0		// Fail
	if(eAESCtrl.eKeyMD == NChangeKey)
	{
		SblkOutp32(rAES_CONTROL, Inp32(rAES_CONTROL)&(~AES_CHANGE	));			
	}
	#endif

}
#endif


void SBLK_AESCloseKey(void)
{

	SblkOutp32(rAES_CONTROL, Inp32(rAES_CONTROL)&(~AES_CHANGE	));	

}




/////////////////////////////////////////////////////
//////////
// Function Name : SBLK_DESInit
// Function Description : This function  initialize DES/TDES Engine 
// Input : 				HashCtrl :  Control Parameter of AES engine
//						key,iv,cnt : Address of the Key, IV, Counter value
// Output : NONE
// Version : 
void SBLK_DESInit(DESCtrl eDESCtrl, u32 *key, u32 *iv)
{
	u32 uReg;
	u32 i;
	u32 *pDstAddr;

	oSblk.m_eSblkType = eDESCtrl.eENG;
	oSblk.m_eOperMode = eDESCtrl.eOperMode;
	oSblk.m_eOperMode1 = eDESCtrl.eEEEMode;
	oSblk.m_eDir = eDESCtrl.eDir;

	//01. Set-up Control Register
	#if 0
	uReg = ((0<<6)|((eDESCtrl.eFIFOMD == SBLK_CPU)?(0<<5):(1<<5))|			// No Byte Swap
		    ((eDESCtrl.eEEEMode == EDE)? (0<<4):(1<<4))|
		    ((eDESCtrl.eENG == DES)? (0<<3):(1<<3))|
		    ((eDESCtrl.eOperMode == ECB)? (0<<1):(1<<1))|
	           ((eDESCtrl.eDir == ENC)?0:1));
	#endif
	uReg = (((eDESCtrl.eDISwap==SBLK_NoSwap)?(0<<9):(1<<9))|
		    ((eDESCtrl.eDOSwap==SBLK_NoSwap)?(0<<8):(1<<8))|
		    ((eDESCtrl.eIVSwap==SBLK_NoSwap)?(0<<7):(1<<7))|
		     ((eDESCtrl.eKEYSwap==SBLK_NoSwap)?(0<<6):(1<<6))|
		    ((eDESCtrl.eFIFOMD == SBLK_CPU)?(0<<5):(1<<5))|			// No Byte Swap
		    ((eDESCtrl.eEEEMode == EDE)? (0<<4):(1<<4))|
		    ((eDESCtrl.eENG == DES)? (0<<3):(1<<3))|
		    ((eDESCtrl.eOperMode == ECB)? (0<<1):(1<<1))|
	           ((eDESCtrl.eDir == ENC)?0:1));
	
	SblkOutp32(rTDES_CONF, uReg);

	// Golden Data is made by Big Endian bsed
	if(eDESCtrl.eKEYSwap == SBLK_NoSwap)
		byteswaplen(key, key, 6);
	if(eDESCtrl.eIVSwap == SBLK_NoSwap)
		byteswaplen(iv, iv, 2);
	oSblk.m_eDISwap = eDESCtrl.eDISwap;
	oSblk.m_eDOSwap = eDESCtrl.eDOSwap;
	oSblk.m_eRDMASwap = eDESCtrl.eDMASwap;
	oSblk.m_eTDMASwap = eDESCtrl.eDMASwap;


	//02. Set Key, IV value
	if(eDESCtrl.eENG == DES)
	{
		Copy((u32)key, rTDES_KEY1_0, 2);
	}
	else if(eDESCtrl.eENG == TDES)
	{
		Copy((u32)key, rTDES_KEY1_0, 6);	
	}

	if(eDESCtrl.eOperMode == CBC)
	{
		Copy((u32)iv, rTDES_IV_0, 2);
	}


	// Return Golden Data
	if(eDESCtrl.eKEYSwap == SBLK_NoSwap)
		byteswaplen(key, key, 6);
	if(eDESCtrl.eIVSwap == SBLK_NoSwap)
		byteswaplen(iv, iv, 2);



}


void SBLK_CalBlkWords(u32 uMsgSize, u32 *x, u32 *y)
{
	u32 total_words;

	total_words = (uMsgSize+3)/4;

	*x = total_words/16;
	*y = total_words%16;
}


/////////////////////////////////////////////////////
//////////
// Function Name : SBLK_HASHInit
// Function Description : This function  initialize HASH Engine 
// Input : 				HashCtrl :  Control Parameter of HASH engine
//						key : Address of the Key or Seed data
// Output : NONE
// Version : 
void SBLK_HASHInit(HASHCtrl eHASHCtrl)
{
	u32 uReg;
	u32 i;


	oSblk.m_eSblkType = HASH;
	oSblk.m_eOperMode = eHASHCtrl.eOperMode;
	oSblk.m_eDISwap = eHASHCtrl.eDISwap;
	oSblk.m_eDOSwap = eHASHCtrl.eDOSwap;
	oSblk.m_eRDMASwap = eHASHCtrl.eDMASwap;


	//01.Set Engine & Start/Init bit together
	uReg = (((eHASHCtrl.eDISwap==SBLK_NoSwap)?(0<<3):(1<<3))|
		    ((eHASHCtrl.eDOSwap==SBLK_NoSwap)?(0<<2):(1<<2))|
		    ((eHASHCtrl.eIVSwap==SBLK_NoSwap)?(0<<1):(1<<1)));
	
	SblkOutp32(rHASH_BYTE_SWAP, uReg);
	//SblkOutp32(rHASH_BYTE_SWAP, HASH_SWAP_DI|HASH_SWAP_DO|HASH_SWAP_IV);

	if(eHASHCtrl.eOperMode == SHA1_HASH)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HASH);}
	else if(eHASHCtrl.eOperMode == SHA1_HMAC)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HMAC_INNER);}
	else if(eHASHCtrl.eOperMode == MD5_HASH)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HASH);}
	else if(eHASHCtrl.eOperMode == MD5_HMAC)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HMAC_INNER);}
	else if(eHASHCtrl.eOperMode == PRNG)
		{SblkOutp32(rHASH_CONTROL_1, ENG_PRNG);}		// PRNG -> set seed -> start PRNG

	//02.Configure the interconnection of the fifo
	if(eHASHCtrl.eFIFOMD == SBLK_CPU)
		{SblkOutp32(rHASH_FIFO_MODE_EN, HASH_CPU);}
	else
		{SblkOutp32(rHASH_FIFO_MODE_EN, HASH_DMA);}

}

void SBLK_OuterHASH (void)
{
	u32 uRegValue;

	//01. Init Outer Hash for HMAC Operation & Last Message Size (Key 8+8 word + Last Result)
	if((Inp32(rHASH_CONTROL_1)&0xF) == ENG_SHA1_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 84);
	}
	else if ((Inp32(rHASH_CONTROL_1)&0xF) == ENG_MD5_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 80);
	}

	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
	
	

}



void SBLK_GetPRNG(u32 *prng_seed, u32 *result_addr)
{
	u32 i;
	u32 reg_value;
	u32 prng_result[5];

	oSblk.m_eSblkType = HASH;
	oSblk.m_eOperMode = PRNG;

    
	//---------------------------------------
	// Seed setup
	//---------------------------------------
	SblkOutp32(rHASH_CONTROL_1, ENG_PRNG);
	
   
	// Write seed data (5 words)
	Copy((u32)prng_seed, rHASH_SEED_IN_1, 5); 
    
	// wait for some time
	for(i=0; i<100; i++) ;
    
	// set the engine and the start bit together
	SblkOutp32(rHASH_CONTROL_1, ENG_PRNG|HASH_START_BIT);
    

	if(Sblock_INTMD)
	{
		while(g_HASHDone ==0);
		g_HASHDone = 0;
	}
	else
	{
		  while(!(Inp32(rHASH_STATUS) & PRNG_DONE));
		SblkOutp32(rHASH_STATUS, PRNG_DONE);	
	}	
	//HASH_STATUS=reg_value & ~PRNG_DONE;
    
	// Save the PRNG result
	Copy(rHASH_PRNG_1, (u32)result_addr, 5);
       
}


//void SBLK_RunHASH(u32 control, u32 fifo_con, u32 byte_swap, u32 msg_size, 
//			 u32 *msg_addr, u32 *result_addr, u32 *golden_addr)
// Not Used FeedCtrl INT & 1 time DMA Start
void SBLK_RunHASH(HASHCtrl eHashCtrl,   u32 msg_size, u32 *msg_addr, u32 result_addr)			 
{
	u32 total_words = (msg_size + 3) >> 2;
	u32 num_blocks = total_words >> 4; 
	u32 remain_words = total_words & 0xF;
	u32 result_length;
	u32 i;
	u32 uRegValue;

	oSblk.m_eSblkType = HASH;
	oSblk.m_eOperMode = eHashCtrl.eOperMode;
	oSblk.m_eDISwap = eHashCtrl.eDISwap;
	oSblk.m_eDOSwap = eHashCtrl.eDOSwap;
	oSblk.m_eRDMASwap = eHashCtrl.eDMASwap;

	Assert(msg_size!=0);


	//01.Set Engine & Start/Init bit together
	uRegValue = (((eHashCtrl.eDISwap==SBLK_NoSwap)?(0<<3):(1<<3))|
		    ((eHashCtrl.eDOSwap==SBLK_NoSwap)?(0<<2):(1<<2))|
		    ((eHashCtrl.eIVSwap==SBLK_NoSwap)?(0<<1):(1<<1)));
	
	SblkOutp32(rHASH_BYTE_SWAP, uRegValue);
	
	if(eHashCtrl.eOperMode == SHA1_HASH)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HASH);}
	else if(eHashCtrl.eOperMode == MD5_HASH)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HASH);}
	
	if(eHashCtrl.eFIFOMD == SBLK_CPU)
		{SblkOutp32(rHASH_FIFO_MODE_EN, HASH_CPU);}
	else 
		{SblkOutp32(rHASH_FIFO_MODE_EN, HASH_DMA);}

	SblkOutp32(rHASH_MSG_SIZE_LOW, msg_size);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);
	
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
		// for test
		if(((oSblk.m_eRDMASwap == SBLK_NoSwap)&&(oSblk.m_eDISwap == SBLK_NoSwap))||((oSblk.m_eRDMASwap == SBLK_Swap)&&(oSblk.m_eDISwap == SBLK_Swap)))
			byteswaplen(msg_addr,(u32 *)INPUT_BUF ,total_words);
	
		// Flush HRDMA to be safe
		SblkOutp32(rFCHRDMAC, 0x1);

		if(oSblk.m_eRDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCHRDMAC, 0<<1);
		else
			SblkOutp32(rFCHRDMAC, 1<<1);
    	
	    	// Disable HRDMA interrupt. We don't need this signal for the hash operation.
		SblkOutp32(rFCINTENCLR, HRDMA_INT_BIT);
	        
   		// HASHINSEL = 2'b00 (independent source)
   		SblkOutp32(rFCFIFOCTRL, Inp32(rFCFIFOCTRL)&0x4);  // HASHINSEL: keep bit[2] and set bit[1:0] to 2'b00
    	
	    	// Setup the DMA: msg_addr, msg_size
		if(((oSblk.m_eRDMASwap == SBLK_NoSwap)&&(oSblk.m_eDISwap == SBLK_NoSwap))||((oSblk.m_eRDMASwap == SBLK_Swap)&&(oSblk.m_eDISwap == SBLK_Swap)))
			SblkOutp32(rFCHRDMAS, INPUT_BUF);
		else
			SblkOutp32(rFCHRDMAS, (u32)msg_addr);

	    	SblkOutp32(rFCHRDMAL, msg_size);				// DMA starts
	}
	else
	{

		if(oSblk.m_eDISwap == SBLK_NoSwap)
			byteswaplen(msg_addr,msg_addr,total_words);
	
		// Data input for the whole blocks
    		for(i=0; i<num_blocks; i++)
    		{
    			while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
    	
    	    		// Data input: 8-word burst x 2
    	    		Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
    	    		Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    		}
	
    		if(remain_words!=0)
    		{
    	  	  while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
        
    	    	// Data input: <16 words
		    if(remain_words>8)
    		    {
    	      		Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, 8);
        	    	Copy( (u32)(msg_addr+num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
			 }
        		else
	    	        Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, remain_words);
    		}	

    		//return golden data
		if(oSblk.m_eDISwap == SBLK_NoSwap)
		byteswaplen(msg_addr,msg_addr,total_words);
   	 }


	if(Sblock_INTMD)
	{
		while(g_HASHDone ==0);
		g_HASHDone = 0;
		 if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
		 	{
			while(!(Inp32(rFCINTPEND) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
	    		SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		 	}
	}
	else
	{
		  while(!(Inp32(rHASH_STATUS) & MSG_DONE));
		SblkOutp32(rHASH_STATUS, MSG_DONE);	
	}	

		
	// Read and save the result. SHA1 = 5 words, MD5 = 4 words
    if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HASH)
    	result_length = 5;
    else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HASH)
        result_length = 4;
    
    Copy(rHASH_RESULT_1, result_addr, result_length); 

	if(oSblk.m_eDOSwap == SBLK_NoSwap)
		byteswaplen((u32 *)result_addr,(u32 *)result_addr,result_length);

   

}
// Not Used FeedCtrl INT & 1 time DMA Start
void SBLK_RunHMAC(HASHCtrl eHashCtrl, u32 msg_size,   u32 *hmac_key, u32 *msg_addr, u32 result_addr )
{
	u32 inner_result[5];
	u32 total_words = (msg_size + 3) >> 2;
	u32 num_blocks = total_words >> 4; 
	u32 remain_words = total_words & 0xF;
	u32 result_length;
	u32 i;
	u32 key_size = 64;
	u32 uRegValue;



	oSblk.m_eSblkType = HASH;
	oSblk.m_eOperMode = eHashCtrl.eOperMode;
	oSblk.m_eDISwap = eHashCtrl.eDISwap;
	oSblk.m_eDOSwap = eHashCtrl.eDOSwap;
	oSblk.m_eRDMASwap = eHashCtrl.eDMASwap;
	
	Assert(msg_size!=0);

	
	//---------------------------------------
	// Inner hash
	//---------------------------------------
	//01.Set Engine & Start/Init bit together
	uRegValue = (((eHashCtrl.eDISwap==SBLK_NoSwap)?(0<<3):(1<<3))|
		    ((eHashCtrl.eDOSwap==SBLK_NoSwap)?(0<<2):(1<<2))|
		    ((eHashCtrl.eIVSwap==SBLK_NoSwap)?(0<<1):(1<<1)));
	
	SblkOutp32(rHASH_BYTE_SWAP, uRegValue);

	if(eHashCtrl.eOperMode == SHA1_HMAC)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HMAC_INNER);}
	else if(eHashCtrl.eOperMode == MD5_HMAC)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HMAC_INNER);}

	if(eHashCtrl.eFIFOMD == SBLK_CPU)
		{SblkOutp32(rHASH_FIFO_MODE_EN, HASH_CPU);}
	else 
		{SblkOutp32(rHASH_FIFO_MODE_EN, HASH_DMA);}

	SblkOutp32(rHASH_MSG_SIZE_LOW, key_size+msg_size);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);


	if(oSblk.m_eDISwap == SBLK_NoSwap)
	{
		byteswaplen(msg_addr, msg_addr, total_words);
		byteswaplen(hmac_key, hmac_key, (key_size>>2));		
	}

	
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
	

		//Copy for Test to NCNB Area	
		Copy((u32)hmac_key,  INPUT_BUF, (key_size>>2));
		Copy((u32)msg_addr,  INPUT_BUF+key_size, total_words);

		// for test
		if(oSblk.m_eRDMASwap== SBLK_Swap)
		{
			byteswaplen((u32 *)INPUT_BUF, (u32 *)INPUT_BUF, (key_size>>2));	
			byteswaplen((u32 *)(INPUT_BUF+key_size), (u32 *)(INPUT_BUF+key_size), total_words);
							
		}

		//add- jwj  Disable INTENCLR
		SblkOutp32(rFCINTENCLR, HRDMA_INT_BIT);
		
		// Flush HRDMA to be safe
		SblkOutp32(rFCHRDMAC, 0x1);

		if(oSblk.m_eRDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCHRDMAC, 0<<1);
		else
			SblkOutp32(rFCHRDMAC, 1<<1);
    	
		// Enable HRDMA interrupt
		//SblkOutp32(rFCINTENSET, HRDMA_INT_BIT);  
   		// Clear possible pending HRDMA interrupt to be safe
		//SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
		//add- jwj  Disable INTENCLR
		SblkOutp32(rFCINTENCLR, HRDMA_INT_BIT);
	    	// HASHINSEL = 2'b00 (independent source)
		SblkOutp32(rFCFIFOCTRL, Inp32(rFCFIFOCTRL)&0x4);	// HASHINSEL: keep bit[2] and set bit[1:0] to 2'b00
        
	        // Setup DMA for the key: (key_addr, 64 bytes)
      		SblkOutp32(rFCHRDMAS, INPUT_BUF); 
   	       //SblkOutp32(rFCHRDMAS, (u32)hmac_key);	//	start address
	       SblkOutp32(rFCHRDMAL, key_size+msg_size);		//	size in bytes --> DMA starts
    	
   	
	}
	else
	{

		Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
	    	Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8);  // key_addr is a pointer to u32, 
                                                       // so key_addr+8 means an offset of 8 words.
	
		// Data input for the whole blocks
	 	for(i=0; i<num_blocks; i++)
    		{
    			while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
    	
		 // Data input: 8-word burst x 2
	    	    Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
    		    Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    		}
	
    		if(remain_words!=0)
    		{
	    	    while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
        
    		    // Data input: <16 words
	    	    if(remain_words>8)
    		    {
    	       	 Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, 8);
	    	        Copy( (u32)(msg_addr+num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
    		    }
	    	    else
    		        Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, remain_words);
		}	

    		
    	}

    	// End of 1st Inner SHA
	if(Sblock_INTMD)
	{
		while(g_HASHDone ==0);
		g_HASHDone = 0;
		 if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
		 	{
			while(!(Inp32(rFCINTPEND) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
	    		SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		 	}
	}
	else
	{
		  while(!(Inp32(rHASH_STATUS) & MSG_DONE));
		SblkOutp32(rHASH_STATUS, MSG_DONE);	
	}	

	// Read and save the result. SHA1 = 5 words, MD5 = 4 words
	if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HMAC_INNER)
	    	result_length = 5;
	else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HMAC_INNER)
		result_length = 4;
    
	Copy(rHASH_RESULT_1, (u32)inner_result, result_length);

	if(oSblk.m_eDOSwap == SBLK_NoSwap)
		byteswaplen(inner_result, inner_result, result_length);
	
  
	//if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	    	// Clear interrupt pending bit.
	//	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    
	//---------------------------------------
	// Outer hash
	//---------------------------------------
	// Set the engine and the start/init bit together
	
	if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 84);
	}
	else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 80);
	}
		SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);

	if(oSblk.m_eDISwap == SBLK_NoSwap)
		byteswaplen(inner_result, inner_result, result_length);	

	// for test
	//	Copy((u32)inner_result, MID_BUF, result_length);
	
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{

		//Copy((u32)inner_result, MID_BUF, result_length);
		Copy((u32)inner_result, INPUT_BUF+key_size, result_length);

		if(oSblk.m_eRDMASwap == SBLK_Swap)
			byteswaplen((u32 *)(INPUT_BUF+key_size),(u32 *)(INPUT_BUF+key_size), result_length);
	
		// Setup DMA for the key: key_addr, 64 bytes
      		SblkOutp32(rFCHRDMAS, INPUT_BUF); 
      	       // SblkOutp32(rFCHRDMAS, (u32)hmac_key);	//	start address
		SblkOutp32(rFCHRDMAL, key_size+result_length*4);			// size in bytes --> DMA starts

		#if 0
		if(Sblock_INTMD)
		{
			 while(g_SDma1Done ==0);
			 g_SDma1Done=0;
		}
		else
		{
			while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
		    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		}	

		SblkOutp32(rFCHRDMAS, MID_BUF);		// start address
		SblkOutp32(rFCHRDMAL, result_length<<2);		// size in bytes --> DMA starts  

		// for safty-jwj
		if(Sblock_INTMD)
		{
			 while(g_SDma1Done ==0);
			 g_SDma1Done=0;
		}
		else
		{
			while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
		    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		}	
		#endif
	}
	else
	{
	
		Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
	    	Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8); 
	
		while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
	
		//Copy(MID_BUF, rHASH_DATA_IN_1, result_length);
		Copy((u32)inner_result, rHASH_DATA_IN_1, result_length);

	}
	
	if(Sblock_INTMD)
	{
		while(g_HASHDone ==0);
		g_HASHDone = 0;
		 if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
		 	{
			while(!(Inp32(rFCINTPEND) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
	    		SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		 	}
	}
	else
	{
		  while(!(Inp32(rHASH_STATUS) & MSG_DONE));
		SblkOutp32(rHASH_STATUS, MSG_DONE);	
	}	
	
	Copy(rHASH_RESULT_1, (u32)result_addr, result_length);

	if(oSblk.m_eDOSwap == SBLK_NoSwap)
		byteswaplen((u32 *)result_addr,(u32 *)result_addr,result_length);




	//return to Golden data
	if(oSblk.m_eDISwap == SBLK_NoSwap)
	{
		byteswaplen(msg_addr, msg_addr, total_words);
		byteswaplen(hmac_key, hmac_key, (key_size>>2));			
	}
	    
}


#if 0	// 1st Test  Case,  2DMA INT, 1HASH INT

void SBLK_RunHMAC(HASHCtrl eHashCtrl, u32 msg_size,   u32 *hmac_key, u32 *msg_addr, u32 result_addr )
{
	u32 inner_result[5];
	u32 total_words = (msg_size + 3) >> 2;
	u32 num_blocks = total_words >> 4; 
	u32 remain_words = total_words & 0xF;
	u32 result_length;
	u32 i;
	u32 key_size = 64;
	u32 uRegValue;



	oSblk.m_eSblkType = HASH;
	oSblk.m_eOperMode = eHashCtrl.eOperMode;
	oSblk.m_eDISwap = eHashCtrl.eDISwap;
	oSblk.m_eDOSwap = eHashCtrl.eDOSwap;
	oSblk.m_eRDMASwap = eHashCtrl.eDMASwap;
	
	Assert(msg_size!=0);

	
	//---------------------------------------
	// Inner hash
	//---------------------------------------
	//01.Set Engine & Start/Init bit together
	uRegValue = (((eHashCtrl.eDISwap==SBLK_NoSwap)?(0<<3):(1<<3))|
		    ((eHashCtrl.eDOSwap==SBLK_NoSwap)?(0<<2):(1<<2))|
		    ((eHashCtrl.eIVSwap==SBLK_NoSwap)?(0<<1):(1<<1)));
	
	SblkOutp32(rHASH_BYTE_SWAP, uRegValue);

	if(eHashCtrl.eOperMode == SHA1_HMAC)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HMAC_INNER);}
	else if(eHashCtrl.eOperMode == MD5_HMAC)
		{SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HMAC_INNER);}

	if(eHashCtrl.eFIFOMD == SBLK_CPU)
		{SblkOutp32(rHASH_FIFO_MODE_EN, HASH_CPU);}
	else 
		{SblkOutp32(rHASH_FIFO_MODE_EN, HASH_DMA);}

	SblkOutp32(rHASH_MSG_SIZE_LOW, key_size+msg_size);
	SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);


	if(oSblk.m_eDISwap == SBLK_NoSwap)
	{
		byteswaplen(msg_addr, msg_addr, total_words);
		byteswaplen(hmac_key, hmac_key, (key_size>>2));		
	}

	
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{
	

		//Copy for Test to NCNB Area	
		Copy((u32)hmac_key,  INPUT_BUF, (key_size>>2));
		Copy((u32)msg_addr,  INPUT_BUF+key_size, total_words);

		// for test
		if(oSblk.m_eRDMASwap== SBLK_Swap)
		{
			byteswaplen((u32 *)INPUT_BUF, (u32 *)INPUT_BUF, (key_size>>2));	
			byteswaplen((u32 *)(INPUT_BUF+key_size), (u32 *)(INPUT_BUF+key_size), total_words);
							
		}

	
		// Flush HRDMA to be safe
		SblkOutp32(rFCHRDMAC, 0x1);

		if(oSblk.m_eRDMASwap == SBLK_NoSwap)
			SblkOutp32(rFCHRDMAC, 0<<1);
		else
			SblkOutp32(rFCHRDMAC, 1<<1);
    	
		// Enable HRDMA interrupt
		//SblkOutp32(rFCINTENSET, HRDMA_INT_BIT);  
   		// Clear possible pending HRDMA interrupt to be safe
		//SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    	
	    	// HASHINSEL = 2'b00 (independent source)
		SblkOutp32(rFCFIFOCTRL, Inp32(rFCFIFOCTRL)&0x4);	// HASHINSEL: keep bit[2] and set bit[1:0] to 2'b00
        
	        // Setup DMA for the key: (key_addr, 64 bytes)
      		SblkOutp32(rFCHRDMAS, INPUT_BUF); 
   	       //SblkOutp32(rFCHRDMAS, (u32)hmac_key);	//	start address
	       SblkOutp32(rFCHRDMAL, key_size);		//	size in bytes --> DMA starts
    	
		if(Sblock_INTMD)
		{
			 while(g_SDma1Done ==0);
			 g_SDma1Done=0;
		}
		else
		{
			while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
		    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		}	

		//SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
	    	  	    	
	   	// Setup DMA for the message: (msg_addr, msg_size)
		SblkOutp32(rFCHRDMAS, INPUT_BUF+key_size); 
	   	//SblkOutp32(rFCHRDMAS, (u32)msg_addr);	// start address
	   	SblkOutp32(rFCHRDMAL, msg_size);		// size in bytes --> DMA starts

		// for safty-jwj
		if(Sblock_INTMD)
		{
			 while(g_SDma1Done ==0);
			 g_SDma1Done=0;
		}
		else
		{
			while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
		    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		}	


	   	
	}
	else
	{

		Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
	    	Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8);  // key_addr is a pointer to u32, 
                                                       // so key_addr+8 means an offset of 8 words.
	
		// Data input for the whole blocks
	 	for(i=0; i<num_blocks; i++)
    		{
    			while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
    	
		 // Data input: 8-word burst x 2
	    	    Copy((u32)(msg_addr + i*16),   rHASH_DATA_IN_1, 8);
    		    Copy((u32)(msg_addr + i*16+8), rHASH_DATA_IN_1, 8);
    		}
	
    		if(remain_words!=0)
    		{
	    	    while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
        
    		    // Data input: <16 words
	    	    if(remain_words>8)
    		    {
    	       	 Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, 8);
	    	        Copy( (u32)(msg_addr+num_blocks*16+8), rHASH_DATA_IN_1, (remain_words-8));
    		    }
	    	    else
    		        Copy( (u32)(msg_addr+num_blocks*16), rHASH_DATA_IN_1, remain_words);
		}	

    		
    	}

    	// End of 1st Inner SHA
	if(Sblock_INTMD)
	{
		while(g_HASHDone ==0);
		g_HASHDone = 0;
	}
	else
	{
		  while(!(Inp32(rHASH_STATUS) & MSG_DONE));
		SblkOutp32(rHASH_STATUS, MSG_DONE);	
	}	

	// Read and save the result. SHA1 = 5 words, MD5 = 4 words
	if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HMAC_INNER)
	    	result_length = 5;
	else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HMAC_INNER)
		result_length = 4;
    
	Copy(rHASH_RESULT_1, (u32)inner_result, result_length);

	if(oSblk.m_eDOSwap == SBLK_NoSwap)
		byteswaplen(inner_result, inner_result, result_length);
	
  
	//if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	    	// Clear interrupt pending bit.
	//	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);
    
	//---------------------------------------
	// Outer hash
	//---------------------------------------
	// Set the engine and the start/init bit together
	
	if(Inp32(rHASH_CONTROL_1)==ENG_SHA1_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_SHA1_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 84);
	}
	else if (Inp32(rHASH_CONTROL_1)==ENG_MD5_HMAC_INNER)
	{
		SblkOutp32(rHASH_CONTROL_1, HASH_START_BIT|ENG_MD5_HMAC_OUTER);
		SblkOutp32(rHASH_MSG_SIZE_LOW, 80);
	}
		SblkOutp32(rHASH_MSG_SIZE_HIGH, 0x0);

	if(oSblk.m_eDISwap == SBLK_NoSwap)
		byteswaplen(inner_result, inner_result, result_length);	

	// for test
	//	Copy((u32)inner_result, MID_BUF, result_length);
	
	if(Inp32(rHASH_FIFO_MODE_EN) & HASH_DMA)
	{

		Copy((u32)inner_result, MID_BUF, result_length);

		if(oSblk.m_eRDMASwap == SBLK_Swap)
			byteswaplen((u32 *)MID_BUF,(u32 *)MID_BUF, result_length);
	
		// Setup DMA for the key: key_addr, 64 bytes
      		SblkOutp32(rFCHRDMAS, INPUT_BUF); 
      	       // SblkOutp32(rFCHRDMAS, (u32)hmac_key);	//	start address
		SblkOutp32(rFCHRDMAL, key_size);			// size in bytes --> DMA starts

		if(Sblock_INTMD)
		{
			 while(g_SDma1Done ==0);
			 g_SDma1Done=0;
		}
		else
		{
			while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
		    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		}	

		SblkOutp32(rFCHRDMAS, MID_BUF);		// start address
		SblkOutp32(rFCHRDMAL, result_length<<2);		// size in bytes --> DMA starts  

		// for safty-jwj
		if(Sblock_INTMD)
		{
			 while(g_SDma1Done ==0);
			 g_SDma1Done=0;
		}
		else
		{
			while(!(Inp32(rFCINTSTAT) & HRDMA_INT_BIT));    
			// Clear interrupt pending bit.
		    	SblkOutp32(rFCINTPEND, HRDMA_INT_BIT);	
		}	

	}
	else
	{
	
		Copy((u32)hmac_key,     rHASH_DATA_IN_1, 8);
	    	Copy((u32)(hmac_key+8), rHASH_DATA_IN_1, 8); 
	
		while(!(Inp32(rHASH_STATUS) & BUFFER_READY));
	
		//Copy(MID_BUF, rHASH_DATA_IN_1, result_length);
		Copy((u32)inner_result, rHASH_DATA_IN_1, result_length);

	}
	
	if(Sblock_INTMD)
	{
		while(g_HASHDone ==0);
		g_HASHDone = 0;
	}
	else
	{
		  while(!(Inp32(rHASH_STATUS) & MSG_DONE));
		SblkOutp32(rHASH_STATUS, MSG_DONE);	
	}	
	
	Copy(rHASH_RESULT_1, (u32)result_addr, result_length);

	if(oSblk.m_eDOSwap == SBLK_NoSwap)
		byteswaplen((u32 *)result_addr,(u32 *)result_addr,result_length);




	//return to Golden data
	if(oSblk.m_eDISwap == SBLK_NoSwap)
	{
		byteswaplen(msg_addr, msg_addr, total_words);
		byteswaplen(hmac_key, hmac_key, (key_size>>2));			
	}
	    
}
#endif

//////////
// Function Name : SBLK_PutDataToInReg
// Function Description : This function  
// Input :   uSrcAddr,	uSize,	eType		
// Output : NONE
// Version : 
void SBLK_PutDataToInReg(u32 uSrcAddr, u32 uSize)
{
	u32 i, uReg;
	u32 *pSrcAddr, *pDstAddr;

	pSrcAddr = (u32 *)uSrcAddr;


	if (oSblk.m_eSblkType == AES)
	{
		if(oSblk.m_eDISwap == SBLK_NoSwap)
			byteswaplen(pSrcAddr,pSrcAddr ,uSize);
	
		pDstAddr = (u32 *)rAES_INDATA_01;
		for (i=uSize; i>0; i--)
			SblkOutp32(pDstAddr++, *pSrcAddr++);

		//return Golden
		if(oSblk.m_eDISwap == SBLK_NoSwap)
			byteswaplen((u32 *)uSrcAddr,(u32 *)uSrcAddr ,uSize);
	}
	else if ((oSblk.m_eSblkType == DES)|(oSblk.m_eSblkType==TDES))
	{
		if(oSblk.m_eDISwap == SBLK_NoSwap)
			byteswaplen(pSrcAddr,pSrcAddr ,uSize);
	
		pDstAddr = (u32 *)rTDES_INPUT_0;
		for(i=uSize;i>0;i--)
			SblkOutp32(pDstAddr++, *pSrcAddr++);	

		//return Golden
		if(oSblk.m_eDISwap == SBLK_NoSwap)
			byteswaplen((u32 *)uSrcAddr,(u32 *)uSrcAddr ,uSize);
		
	}
	else
	{

	}
}


//////////
// Function Name : SBLK_GetDataFromOutReg
// Function Description : This function  
// Input :   uDstAddr, 	uSize
// Output : NONE
// Version :
void SBLK_GetDataFromOutReg(u32 uDstAddr, u32 uSize)
{
	u32 i;
	u32 *pSrc, *pDst;

	pDst = (u32 *)uDstAddr;

	if (oSblk.m_eSblkType == AES)
		pSrc = (u32 *)rAES_OUTDATA_01;
	else if ((oSblk.m_eSblkType == DES)|(oSblk.m_eSblkType==TDES))
		pSrc = (u32 *)rTDES_OUTPUT_0;
	else if (oSblk.m_eSblkType == HASH)
	{

	}

	for(i=0; i<uSize; i++)
		*pDst++ = *pSrc++;

	
	if(oSblk.m_eDOSwap == SBLK_NoSwap)
		byteswaplen((u32 *)uDstAddr,(u32 *)uDstAddr ,uSize);
	
}




//////////
// Function Name : SBLK_IsOutputReady
// Function Description : This function  
// Input :   NONE
// Output : true, false
// Version :
u8 SBLK_IsOutputReady(void)
{
	u32 uRead, uRet;

	if (oSblk.m_eSblkType == AES)
	{
		uRead=Inp32(rAES_STATUS);
		uRet = (uRead>>0)&1;
	}
	else if ((oSblk.m_eSblkType == DES)|(oSblk.m_eSblkType))
	{
		uRead = Inp32(rTDES_STAT);
		uRet = (uRead>>0)&1;
	}
	else if (oSblk.m_eSblkType == HASH)
	{

	}

	if(uRet)
		return true;
	else
		return false;
}

void SBLK_IsDMADone(void)
{
	u32 uRead;
	
	do{
		uRead= Inp32(rFCINTPEND);
	//}while(!((uRead>>2)&0x1));
	}while(!(uRead));


	SblkOutp32(rFCINTPEND, uRead);

}


//////////
// Function Name : SBLK_ValidZero
// Function Description : This function  
// Input :   NONE
// Output : true, false
// Version :
void SBLK_ValidZero(void)
{
		
	if (oSblk.m_eSblkType == AES)
	{
		
		SblkOutp32(rAES_STATUS, Inp32(rAES_STATUS)|0x1);
	}
	else if ((oSblk.m_eSblkType == DES)|(oSblk.m_eSblkType == TDES))
	{
		SblkOutp32(rTDES_STAT, Inp32(rTDES_STAT)|0x1);
	}
	else if (oSblk.m_eSblkType == HASH)
	{

	}


}


//////////
// Function Name : SBLK_EnDMAINT
// Function Description : 
// Input : uINTEN 
// Output : NONE
// Version : 
void SBLK_EnDMAINT(SBLK_DMA eDMAType)
{
	if(eDMAType == BRDMA)
		{SblkOutp32(rFCINTENSET, Inp32(rFCINTENSET)|(1<<3));}
	else if (eDMAType == BTDMA)
		{SblkOutp32(rFCINTENSET, Inp32(rFCINTENSET)|(1<<2));}
	else if (eDMAType == HRDMA)
		{SblkOutp32(rFCINTENSET, Inp32(rFCINTENSET)|(1<<1));}
	else if (eDMAType == PKDMA)
		{SblkOutp32(rFCINTENSET, Inp32(rFCINTENSET)|(1<<0));}


}

void SBLK_DisDMAINT(SBLK_DMA eDMAType)
{
	if(eDMAType == BRDMA)
		{SblkOutp32(rFCINTENCLR, Inp32(rFCINTENCLR)|(1<<3));}
	else if (eDMAType == BTDMA)
		{SblkOutp32(rFCINTENCLR, Inp32(rFCINTENCLR)|(1<<2));}
	else if (eDMAType == HRDMA)
		{SblkOutp32(rFCINTENCLR, Inp32(rFCINTENCLR)|(1<<1));}
	else if (eDMAType == PKDMA)
		{SblkOutp32(rFCINTENCLR, Inp32(rFCINTENCLR)|(1<<0));}
  
}

void SBLK_PendClearFeed(SBLK_DMA eDMAType)
{
	if(eDMAType == BRDMA)
		{SblkOutp32(rFCINTPEND, (1<<3));}
	else if (eDMAType == BTDMA)
		{SblkOutp32(rFCINTPEND, (1<<2));}
	else if (eDMAType == HRDMA)
		{SblkOutp32(rFCINTPEND, (1<<1));}
	else if (eDMAType == PKDMA)
		{SblkOutp32(rFCINTPEND, (1<<0));}

}

// SBLK_ClrINTPend(u32 uINT);

void __irq Isr_SSSFeed(void)
{
	u32 uRegVal;

	uRegVal = Inp32(rFCINTSTAT);	

	 if(SBLK_DEBMSG)
		UART_Printf("Feed Ctrl Int : 0x%x\n", uRegVal);
	SblkOutp32(rFCINTPEND, uRegVal);
	g_SDma1Done++;
	
	INTC_ClearVectAddr();
}

void __irq Isr_HASH(void)
{
	u32 uRegVal;
	u32 utemp;
	utemp = Inp32(rFCINTPEND);	
	uRegVal = Inp32(rHASH_STATUS);	

	 if(SBLK_DEBMSG)
		UART_Printf("HASH STATUS: 0x%x(0x%x)\n", uRegVal,utemp);
	//SblkOutp32(rHASH_STATUS, MSG_DONE);
	SblkOutp32(rHASH_STATUS, uRegVal);
	g_HASHDone++;
	
	INTC_ClearVectAddr();
}


u32 SBLK_GetRand(void)
{
	u32 uResult;
	oSblk.m_eSblkType = HASH;
	oSblk.m_eOperMode = PRNG;
    
	//---------------------------------------
	// Seed setup
	//---------------------------------------
	SblkOutp32(rHASH_CONTROL_1, ENG_PRNG);
	   
	// Write seed data (5 words)
	SblkOutp32(rHASH_SEED_IN_1, 0x03020100);
	SblkOutp32(rHASH_SEED_IN_2, 0x07060504);
	SblkOutp32(rHASH_SEED_IN_3, 0x0b0a0908);
	SblkOutp32(rHASH_SEED_IN_4, 0x0f0e0d0c);	
	SblkOutp32(rHASH_SEED_IN_5, 0x13121110);
    
	// set the engine and the start bit together
	SblkOutp32(rHASH_CONTROL_1, ENG_PRNG|HASH_START_BIT);
      while(!(Inp32(rHASH_STATUS) & PRNG_DONE));
	SblkOutp32(rHASH_STATUS, PRNG_DONE);	

	uResult = Inp32(rHASH_PRNG_1);
    	return uResult;
       
}

#if 0

// rHASH_CONTROL
// [Data_Selection]
#define HASH_DATA_TEXT					(0<<2)
#define HASH_DATA_KEY					(1<<2)
// [USE_IV]
#define HASH_CONST_HASH				(0<<8)
#define HASH_CONST_IV					(1<<8)

#define DATA_SELECTION					(1<<2)
#define HASH_START						(1<<3)
#define HASH_INPUT_FINISHED			(1<<4)
#define SEED_SET_ENABLE				(1<<5)


SBLK oSblk;
DMAC oSdma1_RX;
DMAC oSdma1_TX;

//u32 g_pSrcAddr ;
#define g_SrcNCNBAddr 0x53000000 //NCNB
#define g_SrcCBAddr 0x51000000 //CB

extern u32 g_AES_Key;

/*
#define SDMA_TCOUT_INT_ENABLE		(1u<<31)

#define SDMA_DST_INC				(1<<27)
#define SDMA_SRC_INC				(1<<26)

#define SDMA_DST_TRANS_MASTER1		(0<<25)
#define SDMA_DST_TRANS_MASTER2		(1<<25)
#define SDMA_SRC_TRANS_MASTER1		(0<<24)
#define SDMA_SRC_TRANS_MASTER2		(1<<24)

#define SDMA_DST_TRANS_DWIDTH_9BIT	(0<<21)	
#define SDMA_DST_TRANS_DWIDTH_16BIT	(1<<21)	
#define SDMA_DST_TRANS_DWIDTH_32BIT	(2<<21)

#define SDMA_SRC_TRANS_DWIDTH_9BIT	(0<<18)	
#define SDMA_SRC_TRANS_DWIDTH_16BIT	(1<<18)	
#define SDMA_SRC_TRANS_DWIDTH_32BIT	(2<<18)

#define SDMA_DST_BURST_SIZE_1		(0<<15)	
#define SDMA_DST_BURST_SIZE_4		(1<<15)	
#define SDMA_DST_BURST_SIZE_8		(2<<15)	
#define SDMA_DST_BURST_SIZE_16		(3<<15)	
#define SDMA_DST_BURST_SIZE_32		(4<<15)	
#define SDMA_DST_BURST_SIZE_64		(5<<15)	
#define SDMA_DST_BURST_SIZE_128		(6<<15)	
#define SDMA_DST_BURST_SIZE_256		(7<<15)

#define SDMA_SRC_BURST_SIZE_1		(0<<12)	
#define SDMA_SRC_BURST_SIZE_4		(1<<12)	
#define SDMA_SRC_BURST_SIZE_8		(2<<12)	
#define SDMA_SRC_BURST_SIZE_16		(3<<12)	
#define SDMA_SRC_BURST_SIZE_32		(4<<12)	
#define SDMA_SRC_BURST_SIZE_64		(5<<12)	
#define SDMA_SRC_BURST_SIZE_128		(6<<12)	
#define SDMA_SRC_BURST_SIZE_256		(7<<12)

#define SDMA_TCOUT_INT_MASK			(1<<15)
#define SDMA_INT_ERROR_MASK			(1<<14)

#define SDMA_FLOW_MEM2MEM			(0<<11)
#define SDMA_FLOW_MEM2PERI			(1<<11)
#define SDMA_FLOW_PERI2MEM			(2<<11)
#define SDMA_FLOW_PERI2PERI			(3<<11)

#define SDMA_DST_PERI_SECURE_RX		(14<<6)
#define SDMA_SRC_PERI_SECURE_TX		(15<<1)
*/

#if 0

//////////
// Function Name : SBLK_Reset
// Function Description : This function  reset control register of the security sub blocks
// Input : NONE 
// Output : NONE
// Version : 
void SBLK_Reset(void)
{
  	Outp32(rAES_RX_CTRL, 0x0);
  	Outp32(rDES_RX_CTRL, 0x0);
  	Outp32(rHASH_RX_CTRL, 0x0);
  	Outp32(rFIFO_RX_CTRL, 0x4);
  	Outp32(rFIFO_TX_CTRL, 0x4);
}


//////////
// Function Name : SBLK_Init
// Function Description : This function  initialize security sub blocks
// Input : 				eSblkType :  AES, DES, HASH
//						eOperMode : ECB, CBC, CTR, HMAC, SHA1, PRNG
//						eDirSel	 :   ENC, DEC
// Output : NONE
// Version : 
void SBLK_Init(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel)
{
	u32 uReg;
	u32 *pSrc;
	int i;

	oSblk.m_eSblkType = eSblkType;
	oSblk.m_eOperMode = eOperMode;

	SBLK_Reset();

	if (oSblk.m_eSblkType == AES)
	{
		Copy((u32)uAesKey, rAES_RX_KEY1, 4); 			// install aes key
		Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
		Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 

		uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
		if (oSblk.m_eOperMode == ECB)
			uReg |= (1<<4);
		else if (oSblk.m_eOperMode == CBC)
			uReg |= (2<<4);
		else if (oSblk.m_eOperMode == CTR)
			uReg |= (3<<4);
		else
			Assert(0);
		Outp32(rAES_RX_CTRL, uReg);
	}
	else if (oSblk.m_eSblkType == DES)
	{
		Copy((u32)uDesKey, rDES_RX_KEY1_0, 6); 		// install des key
		Copy((u32)uDesIV, rDES_RX_IV0, 2); 			// install des iv

		uReg = ((eDirSel == ENC)? (0<<2) : (1<<2))|(0<<5)|(1<<1);
		if (oSblk.m_eOperMode == ECB)
			uReg |= (1<<3);
		else if (oSblk.m_eOperMode == CBC)
			uReg |= (2<<3);
		else
			Assert(0);
		Outp32(rDES_RX_CTRL, uReg);
	}
	else if (oSblk.m_eSblkType == HASH)
	{
		if (oSblk.m_eOperMode == HMAC)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<2)|(0<<0)); // start + key mode

			pSrc = (u32 *)uHmacKey;
			for(i=0; i<16; i++)
				*(u32 *)rHASH_RX_DAT = *pSrc++;

			Outp32(rHASH_RX_CTRL, (0<<2)); // text mode
		}
		else if (oSblk.m_eOperMode == SHA1)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<0));
		}
		else if(oSblk.m_eOperMode == PRNG)
		{
			Outp32(rHASH_RX_CTRL, SEED_SET_ENABLE|HASH_START|(2<<0));
			Copy((u32)uPrngSeed, rPRNG_SEED_DAT1, 10);
		}
		else
		{
			Assert(0);
		}
	}

	Outp32(rDNI_CFG, 0xFFFFFF00);
}

//////////
// Function Name : SBLK_SetFifo
// Function Description : This function  set Fifo information
// Input : 				uRxMsgLen : [31:0]
//						uRxBlkSz : [15:0]
//						uTxMsgLen : [31:0]
//						uTxBlkSz : [15:0]
//						eRxLValid : LASTBYTE_1ST, LASTBYTE_2ND, LASTBYTE_3RD, LASTBYTE_4TH ( SHA-1/PRNG)
// Output : NONE
// Version : 
void SBLK_SetFifo(u32 uRxMsgLen, u32 uRxBlkSz, u32 uTxMsgLen, u32 uTxBlkSz, LVALID_BYTE eRxLValid)
{
	u32 uReg;

	if (oSblk.m_eSblkType == AES)
	{
		Outp32(rFIFO_RX_MSG_LENGTH, uRxMsgLen);
		Outp32(rFIFO_RX_BLK_SIZE, uRxBlkSz);
		Outp32(rFIFO_RX_DST_ADDR, rAES_RX_DIN1);

		Outp32(rFIFO_TX_MSG_LENGTH, uTxMsgLen);
		Outp32(rFIFO_TX_BLK_SIZE, uTxBlkSz);
		Outp32(rFIFO_TX_SRC_ADDR, rAES_TX_DOUT1);
	}
	else if (oSblk.m_eSblkType == DES)
	{
		Outp32(rFIFO_RX_MSG_LENGTH, uRxMsgLen);
		Outp32(rFIFO_RX_BLK_SIZE, uRxBlkSz);
		Outp32(rFIFO_RX_DST_ADDR, rDES_RX_IN0);

		Outp32(rFIFO_TX_MSG_LENGTH, uTxMsgLen);
		Outp32(rFIFO_TX_BLK_SIZE, uTxBlkSz);
		Outp32(rFIFO_TX_SRC_ADDR, rDES_TX_OUT0);
	}
	else if (oSblk.m_eSblkType == HASH)
	{
		Outp32(rFIFO_RX_MSG_LENGTH, uRxMsgLen);
		uReg = 
			((eRxLValid == LASTBYTE_1ST) ? (0<<16) :
			(eRxLValid == LASTBYTE_2ND) ? (1<<16) :
			(eRxLValid == LASTBYTE_3RD) ? (2<<16) : (3<<16)) |
			(uRxBlkSz<<0);
	
		Outp32(rFIFO_RX_BLK_SIZE, uReg);
		Outp32(rFIFO_RX_DST_ADDR, rHASH_RX_DAT);

		Outp32(rFIFO_TX_MSG_LENGTH, uTxMsgLen);
		Outp32(rFIFO_TX_BLK_SIZE, uTxBlkSz);
		Outp32(rFIFO_TX_SRC_ADDR, rHASH_TX_OUT1);
	}
	else
		Assert(0);
}

//////////
// Function Name : SBLK_StartFifo
// Function Description : This function  FIFO Start
// Input :   NONE				
// Output : NONE
// Version : 
void SBLK_StartFifo(void)
{
	if (oSblk.m_eSblkType == AES)
	{
		Outp32(rFIFO_RX_CTRL, 0x39);		// FRx_Dest_Module= AES, FRx_Host_Rd_En, FRx_Host_Wr_En,  FRx_Sync_Tx, FRx_Start
		Outp32(rFIFO_TX_CTRL, 0x31);		//  FRx_Dest_Module= AES, FTx_Host_Rd_En, FTx_Host_Wr_En, FTx_Start
	}
	else if (oSblk.m_eSblkType == DES)
	{
		Outp32(rFIFO_RX_CTRL, 0x79);		// FRx_Dest_Module= DES, FRx_Host_Rd_En, FRx_Host_Wr_En,  FRx_Sync_Tx, FRx_Start
		Outp32(rFIFO_TX_CTRL, 0x71);		//  FRx_Dest_Module= AES, FTx_Host_Rd_En, FTx_Host_Wr_En, FTx_Start
	}
	else
	{
		Outp32(rFIFO_RX_CTRL, 0xb9);		// FRx_Dest_Module= SHA, FRx_Host_Rd_En, FRx_Host_Wr_En,  FRx_Sync_Tx, FRx_Start
		Outp32(rFIFO_TX_CTRL, 0xb1);		//  FRx_Dest_Module= SHA, FTx_Host_Rd_En, FTx_Host_Wr_En, FTx_Start
		
	}
}

//////////
// Function Name : SBLK_GetAvailableRxFifoSize
// Function Description : This function  read FRx_Wd2Write filed of the FIFO_RX_CTRL register.
// Input :   *uSize				
// Output : NONE
// Version : 
void SBLK_GetAvailableRxFifoSize(u32* uSize)
{
	u32 uRead;

	uRead = Inp32(rFIFO_RX_CTRL);

	//UART_Printf("rFIFO_RX_CTRL(GetAva):0x%x\n", uRead);
	uRead = (uRead>>16)&0xff;
	*uSize = uRead;
}

//////////
// Function Name : SBLK_PutDataToRxFifo
// Function Description : This function  put data to Rx FIFO from source address.
// Input :   uSrcAddr, uSize				
// Output : NONE
// Version : 
void SBLK_PutDataToRxFifo(u32 uSrcAddr, u32 uSize)
{	
	u32 i, uRemainedSize, uInputSize;
	u32 *pSrcAddr;

	
	pSrcAddr = (u32 *)uSrcAddr;
	uRemainedSize = uSize;

	while(uRemainedSize > 0)
	{
		SBLK_GetAvailableRxFifoSize(&uInputSize);

		if (uInputSize >= uRemainedSize)
		{
			uInputSize = uRemainedSize;
			uRemainedSize = 0;
		}
		else
		{
			uRemainedSize -= uInputSize;
		}

		for(i=0; i<uInputSize; i++)
			Outp32(rFIFO_RX_WR_BUF, *pSrcAddr++);
	}
}

//////////
// Function Name : SBLK_GetDataFromTxFifo
// Function Description : This function  get data from Tx FIFO to destination address.
// Input :   uDstAddr, uSize				
// Output : NONE
// Version : 
void SBLK_GetDataFromTxFifo(u32 uDstAddr, u32 uSize)
{
	u32 i;
	u32 *uPtrSrc, *uPtrDst;

	uPtrSrc = (u32 *)rFIFO_TX_RD_BUF;
	uPtrDst = (u32 *)uDstAddr;
	
	for(i=0; i<uSize; i++)
		*uPtrDst++ = *uPtrSrc++;
}

//////////
// Function Name : SBLK_IsFifoTransDone
// Function Description : This function   read "Done" field of the FIFO Tx Control Register.
// Input :   NONE			
// Output : true , false
// Version : 
u8 SBLK_IsFifoTransDone(void)
{
	u32 uRead;//, uRead0;

	//Delay(10);			// printf Խ ʿ .
	uRead=Inp32(rFIFO_TX_CTRL);
	//uRead0=Inp32(rFIFO_RX_CTRL); // For Test
	//UART_Printf("rFIFO_RX_CTRL : 0x%x\n", uRead);		// Test 3.17
	//UART_Printf("rDES_RX_CTRL : 0x%x\n", Inp32(0x7D200000));

	//For Test
	//SBLK_DispFifoRxCtrl(uRead0);
	//SBLK_DispFifoTxCtrl(uRead);
	
	if((uRead>>25)&1)
		return true;
	else
		return false;
}

//////////
// Function Name : SBLK_ClearIntPending
// Function Description : This function  clear int. pending of the SDMA1 Int.
// Input :   uTXnRX ( 1: Tx,  0: Rx)			
// Output : NONE
// Version : 
void SBLK_ClearIntPending(u32 uTXnRX)
{
	u32 uRead;
	
	if(uTXnRX == 1)
	{
		uRead = (1<<7);
		//DMACH_ClearIntPending(&oSdma1_TX);
	}
	else if (uTXnRX == 0)
	{
		uRead = (1<<6);
		//DMACH_ClearIntPending(&oSdma1_RX);
	}
	Outp32(0x7DC00008, uRead);

}

//////////
// Function Name : SBLK_ClearIntPending
// Function Description : This function  set SDMA1 
// Input :   uRxSrcAddr,uRxSize,uTxDstAddr,uTxSize			
// Output : NONE
// Version : 
void SBLK_SetSDMA(u32 uRxSrcAddr, u32 uRxSize, u32 uTxDstAddr, u32 uTxSize)
{
	u32 uReg;


	if (!(uRxSize%4)) uReg = 4<<1;
	else uReg = 0<<1;

	if (!(uTxSize%4)) uReg |= 4<<5;
	else uReg |= 0<<5;

 /*
	if (!(uRxSize%4)) uReg = 3<<1;
	else uReg = 0<<1;

	if (!(uTxSize%4)) uReg |= 3<<5;
	else uReg |= 0<<5;
*/

	Outp32(rDNI_CFG, 0xFFFFFF11|uReg);

	
	// Secure DMA input Selection
	SYSC_SelectDMA(eSEL_SECU_RX, 0);		// Secure Rx "SDMA1"
	SYSC_SelectDMA(eSEL_SECU_TX, 0);		// Secure Tx "SDMA1"
	DMAC_InitCh(SDMA1, DMA_G, &oSdma1_RX);	// SDMA1 Initialize
	DMAC_InitCh(SDMA1, DMA_H, &oSdma1_TX);

	Outp32(0x7DC00034, 0x0);					// SDMA1 DMA_SYNC


	// Rx Source Setting - using Channel 6 ( You can select any channel 0 to 7)
	// eChannel, LLI, SrcAddr, SrcFixed, DestAddr, DstFixed, eDataSize, DataCnt, eOpMode, eSrcReq, eDstReq, eBurstMode, DMAC
	//DMACH_Setup(DMA_G,  0x0,  uRxSrcAddr, 0, rSDMA1_RX_FIFO, 1, WORD, uRxSize, DEMAND, MEM, SDMA1_SECU_RX,  BURST8, &oSdma1_RX);
	DMACH_Setup(DMA_G,  0x0,  uRxSrcAddr, 0, rSDMA1_RX_FIFO, 1, WORD, uRxSize, DEMAND, MEM, SDMA1_SECU_RX,  BURST16, &oSdma1_RX);
	//DMACH_Setup(DMA_G,  0x0,  uRxSrcAddr, 0, rSDMA1_RX_FIFO, 1, WORD, uRxSize, DEMAND, MEM, SDMA1_SECU_RX,  BURST4, &oSdma1_RX);
	//DMACH_Setup(DMA_G,  0x0,  uRxSrcAddr, 0, rSDMA1_RX_FIFO, 1, WORD, uRxSize, DEMAND, MEM, SDMA1_SECU_RX,  SINGLE, &oSdma1_RX);
	
	// Tx Destination Setting - using Channel 7 (Tx)
	//DMACH_Setup(DMA_H,  0x0,  rSDMA1_TX_FIFO, 1, uTxDstAddr, 0, WORD, uTxSize, DEMAND, SDMA1_SECU_TX, MEM,  BURST8, &oSdma1_TX);	
	DMACH_Setup(DMA_H,  0x0,  rSDMA1_TX_FIFO, 1, uTxDstAddr, 0, WORD, uTxSize, DEMAND, SDMA1_SECU_TX, MEM,  BURST16, &oSdma1_TX);
	//DMACH_Setup(DMA_H,  0x0,  rSDMA1_TX_FIFO, 1, uTxDstAddr, 0, WORD, uTxSize, DEMAND, SDMA1_SECU_TX, MEM,  BURST4, &oSdma1_TX);	
	//DMACH_Setup(DMA_H,  0x0,  rSDMA1_TX_FIFO, 1, uTxDstAddr, 0, WORD, uTxSize, DEMAND, SDMA1_SECU_TX, MEM,  SINGLE, &oSdma1_TX);	

}

//////////
// Function Name : SBLK_StartSDMA
// Function Description : This function  start SDMA1
// Input :   NONE			
// Output : NONE
// Version : 
void SBLK_StartSDMA(void)
{

	DMACH_Start(&oSdma1_RX);
	DMACH_Start(&oSdma1_TX);

}

//////////
// Function Name : SBLK_PutDataToInReg
// Function Description : This function  
// Input :   uSrcAddr,	uSize,	eLValid		
// Output : NONE
// Version : 
void SBLK_PutDataToInReg(u32 uSrcAddr, u32 uSize, LVALID_BYTE eLValid)
{
	u32 i, uReg;
	u32 *pSrcAddr, *pDstAddr;

	pSrcAddr = (u32 *)uSrcAddr;

	if (oSblk.m_eSblkType == AES)
	{
		pDstAddr = (u32 *)rAES_RX_DIN1;
		for (i=uSize; i>0; i--)
			Outp32(pDstAddr++, *pSrcAddr++);
	}
	else if (oSblk.m_eSblkType == DES)
	{
		pDstAddr = (u32 *)rDES_RX_IN0;
		for (i=uSize; i>0; i--)
			Outp32(pDstAddr++, *pSrcAddr++);
	}
	else
	{
		for (i=uSize; i>0; i--)
		{
			if(i == 1)
			{
				uReg =
					((eLValid == LASTBYTE_1ST)? (0<<6) :
					(eLValid == LASTBYTE_2ND)? (1<<6) :
					(eLValid == LASTBYTE_3RD)? (2<<6) : (3<<6)) |
					HASH_INPUT_FINISHED |
					((oSblk.m_eOperMode == HMAC)? (0<<0) :
					(oSblk.m_eOperMode == SHA1)? (1<<0) : (2<<0));

				Outp32(rHASH_RX_CTRL, uReg); // inform hash of last data input
			}
			Outp32(rHASH_RX_DAT, *pSrcAddr++);
		}
	}
}

//////////
// Function Name : SBLK_StartByManual
// Function Description : This function  
// Input :   NONE	
// Output : NONE
// Version : 
void SBLK_StartByManual(void)
{
	u32 uRead;

	if (oSblk.m_eSblkType == AES)
	{
		uRead = Inp32(rAES_RX_CTRL);
		uRead |= (1<<0);
		Outp32(rAES_RX_CTRL, uRead);
	}
	else if (oSblk.m_eSblkType == DES)
	{
		uRead=Inp32(rDES_RX_CTRL);
		uRead |= (1<<0);
		Outp32(rDES_RX_CTRL, uRead);
	}
	else
	{
		uRead=Inp32(rHASH_RX_CTRL);
		uRead |= (1<<3);
		Outp32(rHASH_RX_CTRL, uRead);
	}
}


//////////
// Function Name : SBLK_GetDataFromOutReg
// Function Description : This function  
// Input :   uDstAddr, 	uSize
// Output : NONE
// Version :
void SBLK_GetDataFromOutReg(u32 uDstAddr, u32 uSize)
{
	u32 i;
	u32 *pSrc, *pDst;

	pDst = (u32 *)uDstAddr;

	if (oSblk.m_eSblkType == AES)
		pSrc = (u32 *)rAES_RX_DOUT1;
	else if (oSblk.m_eSblkType == DES)
		pSrc = (u32 *)rDES_RX_OUT0;
	else if (oSblk.m_eSblkType == HASH)
	{
		if (oSblk.m_eOperMode == PRNG)
			pSrc = (u32 *)rPRNG_TX_OUT1;
		else
			pSrc = (u32 *)rHASH_OUTPUT_01;
	}

	for(i=0; i<uSize; i++)
		*pDst++ = *pSrc++;
}

void SBLK_GetDataFromOutReg_Test(u32 uDstAddr, u32 uSize)
{
	u32 i;
	u32 *pSrc, *pDst;

	pDst = (u32 *)uDstAddr;

	if (oSblk.m_eSblkType == AES)
		pSrc = (u32 *)rAES_RX_DOUT1;
	else if (oSblk.m_eSblkType == DES)
		pSrc = (u32 *)rDES_RX_OUT0;
	else if (oSblk.m_eSblkType == HASH)
	{
		if (oSblk.m_eOperMode == PRNG)
			pSrc = (u32 *)rPRNG_TX_OUT1;
		else
			pSrc = (u32 *)rHASH_TX_OUT1;
	}

	for(i=0; i<uSize; i++)
		*pDst++ = *pSrc++;
}



//////////
// Function Name : SBLK_IsOutputReady
// Function Description : This function  
// Input :   NONE
// Output : true, false
// Version :
u8 SBLK_IsOutputReady(void)
{
	u32 uRead, uRet;

	if (oSblk.m_eSblkType == AES)
	{
		uRead=Inp32(rAES_RX_CTRL);
		uRet = (uRead>>10)&1;
	}
	else if (oSblk.m_eSblkType == DES)
	{
		uRead=Inp32(rDES_RX_CTRL);
		uRet = (uRead>>7)&1;
	}
	else if (oSblk.m_eSblkType == HASH)
	{
		uRead=Inp32(rHASH_RX_STAT);
		if (oSblk.m_eOperMode == PRNG)
			uRet = (uRead>>2)&1;
		else
			uRet = (uRead>>0)&1;
	}

	if(uRet)
		return true;
	else
		return false;
}

 void SBLK_DispFifoRxCtrl(u32 uFRx_Ctrl)

{

    //FIFO-RX

    UART_Printf("++++++++START FIFO-RX Ctrl Value++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");

    UART_Printf("FRx_Start = %d    => It should be zero when  FIFO starts Transfer.\n",(uFRx_Ctrl>>0) & 0x1);

    UART_Printf("FRx_ERROR_En  = %d    => Enables ERROR response via HRESP port when host tries to access FIFO-RX.\n",(uFRx_Ctrl>>1) & 0x1);

    UART_Printf("          And Access is not enabled by FRx_Ctrl[4] 0r [5].\n");

    UART_Printf("FRx_Reset = %d    => Enables ERROR response via HRESP port when host tries to access FIFO-RX.\n",(uFRx_Ctrl>>2) & 0x1);

    UART_Printf("FRx_Sync_Tx   = %d    => Waits for FIFO_TX Done.\n",(uFRx_Ctrl>>3) & 0x1);

    UART_Printf("FRx_Host_Wr_En    = %d    => Enables Host write to FRx_WrBuf.\n",(uFRx_Ctrl>>4) & 0x1);

    UART_Printf("FRx_Host_Rd_En    = %d    => Enables Host read from FRx_Ctrl[31:16] and FRx_MLenCnt.\n",(uFRx_Ctrl>>5) & 0x1);

    UART_Printf("FRx_Dest_Module   = %d    => Destination Module Selection 0:AES, 1:DES, 2:SHA-1/PRNG,3:NA.\n",(uFRx_Ctrl>>6) & 0x3);

    UART_Printf("FRx_Wd2Read   = %d    => Number of words that can be read from FIFO Memory(FRx_WrBuf\n",(uFRx_Ctrl>>8) & 0xff);

    UART_Printf("FRx_Wd2Write  = %d    => Number of words that can be written to FIFO Memory(FRx_WrBuf\n",(uFRx_Ctrl>>16) & 0xff);

    UART_Printf("FRx_Running   = %d    => Set to 1 if FIFO-RX is transfering data to the destination or waiting for destination input beffer ready\n",(uFRx_Ctrl>>24) & 0x1);

    UART_Printf("          Set to 1 when FRx_Start bit resets to 0. ReadONly\n");

    UART_Printf("FRx_Done  = %d    => Set to 1 if FIFO-RX finished transfering data to the destination\n",(uFRx_Ctrl>>25) & 0x1);

    UART_Printf("FRx_Empty = %d    => Set to 1 if FIFO Buffer(FRx_WrBuf) is Empty\n",(uFRx_Ctrl>>26) & 0x1);

    UART_Printf("FRx_Full  = %d    => Set to 1 if FIFO Buffer(FRx_WrBuf) is Full\n",(uFRx_Ctrl>>27) & 0x1);

    UART_Printf("++++++++END FIFO-RX Ctrl Value++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");

}

void SBLK_DispFifoTxCtrl(u32 uFTx_Ctrl)

{

    //FIFO-TX

    UART_Printf("++++++++START FIFO-TX Ctrl Value++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");

    UART_Printf("FTx_Start = %d    => It should be zero when  FIFO starts Transfer.\n",(uFTx_Ctrl>>0) & 0x1);

    UART_Printf("FTx_ERROR_En  = %d    => Enables ERROR response via HRESP port when host tries to access FIFO-TX.\n",(uFTx_Ctrl>>1) & 0x1);

    UART_Printf("          And Access is not enabled by FTx_Ctrl[4] 0r [5].\n");

    UART_Printf("FTx_Reset = %d    => Enables ERROR response via HRESP port when host tries to access FIFO-TX.\n",(uFTx_Ctrl>>2) & 0x1);

    UART_Printf("FTx_Reserved  = %d    => Reserved.\n",(uFTx_Ctrl>>3) & 0x1);

    UART_Printf("FTx_Host_Wr_En    = %d    => Enables Host write to FRx_WrBuf.\n",(uFTx_Ctrl>>4) & 0x1);

    UART_Printf("FTx_Host_Rd_En    = %d    => Enables Host read from FTx_Ctrl[31:16] and FTx_MLenCnt.\n",(uFTx_Ctrl>>5) & 0x1);

    UART_Printf("FTx_Src_Module    = %d    => Destination Module Selection 0:AES, 1:DES, 2:SHA-1/PRNG,3:NA.\n",(uFTx_Ctrl>>6) & 0x3);

    UART_Printf("FTx_Wd2Write  = %d    => Number of words that can be read from FIFO Memory(FTx_WrBuf\n",(uFTx_Ctrl>>8) & 0xff);

    UART_Printf("FTx_Wd2Read   = %d    => Number of words that can be written to FIFO Memory(FTx_WrBuf\n",(uFTx_Ctrl>>16) & 0xff);

    UART_Printf("FTx_Running   = %d    => Set to 1 if FIFO-TX is transfering data to the destination or waiting for destination input beffer ready\n",(uFTx_Ctrl>>24) & 0x1);

    UART_Printf("          Set to 1 when FRx_Start bit resets to 0. ReadONly\n");

    UART_Printf("FTx_Done  = %d    => Set to 1 if FIFO-TX finished transfering data to the destination\n",(uFTx_Ctrl>>25) & 0x1);

    UART_Printf("FTx_Empty = %d    => Set to 1 if FIFO Buffer(FTx_WrBuf) is Empty\n",(uFTx_Ctrl>>26) & 0x1);

    UART_Printf("FTx_Full  = %d    => Set to 1 if FIFO Buffer(FTx_WrBuf) is Full\n",(uFTx_Ctrl>>27) & 0x1);

    UART_Printf("++++++++END FIFO-TX Ctrl Value++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");

}

void SBLK_Init_Test(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel)
{
	u32 uReg;
	u32 *pSrc;
	int i;
	int uSel, uSel1;

	oSblk.m_eSblkType = eSblkType;
	oSblk.m_eOperMode = eOperMode;

	SBLK_Reset();

	if (oSblk.m_eSblkType == AES)
	{
	UART_Printf(" Choose AES Key Select :  0 : 128bit,  1:192bit,  2:256bits, 3: Counter  \n");
	uSel = UART_GetIntNum();

	 switch(uSel)
	 	{
		case 0:
	 		Copy((u32)uAesKey, rAES_RX_KEY1, 4); 			// install aes key
			Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);
			break;

		case 1:
	 		Copy((u32)uAesKey, rAES_RX_KEY1, 4); 			// install aes key
	 		Copy((u32)uAesKey, rAES_RX_KEY5, 2); 			// install aes key
			Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			uReg |= (1<<1);
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);
			break;
		
		case 2:
	 		Copy((u32)uAesKey, rAES_RX_KEY1, 4); 			// install aes key
	 		Copy((u32)uAesKey, rAES_RX_KEY5, 4); 			// install aes key
			Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			uReg |= (2<<1);
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);
			break;

		case 3:
	 		Copy((u32)uAesKey, rAES_RX_KEY1, 4); 			// install aes key
	 		Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 
			UART_Printf(" Choose Counter :  0 : 16bit,  1:32bit,  2:64bits  \n");
			uSel1 = UART_GetIntNum();

			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			uReg |= (uSel1<<6);
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);
			UART_Printf("rAES_RX_CRT 0x%x\n", Inp32(0x7D100000));
			break;



	 	}


		
	}
	else if (oSblk.m_eSblkType == DES)
	{
		Copy((u32)uDesKey, rDES_RX_KEY1_0, 6); 		// install des key
		Copy((u32)uDesIV, rDES_RX_IV0, 2); 			// install des iv

		uReg = ((eDirSel == ENC)? (0<<2) : (1<<2))|(1<<5)|(1<<1);		// TDES
		if (oSblk.m_eOperMode == ECB)
			uReg |= (1<<3);
		else if (oSblk.m_eOperMode == CBC)
			uReg |= (2<<3);
		else
			Assert(0);
		Outp32(rDES_RX_CTRL, uReg);
	}
	else if (oSblk.m_eSblkType == HASH)
	{
		if (oSblk.m_eOperMode == HMAC)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<2)|(0<<0)); // start + key mode

			pSrc = (u32 *)uHmacKey;
			for(i=0; i<16; i++)
				*(u32 *)rHASH_RX_DAT = *pSrc++;

			Outp32(rHASH_RX_CTRL, (0<<2)); // text mode
		}
		else if (oSblk.m_eOperMode == SHA1)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<0));
		}
		else if(oSblk.m_eOperMode == PRNG)
		{
			Outp32(rHASH_RX_CTRL, SEED_SET_ENABLE|HASH_START|(2<<0));
			Copy((u32)uPrngSeed, rPRNG_SEED_DAT1, 10);
		}
		else
		{
			Assert(0);
		}
	}

	Outp32(rDNI_CFG, 0xFFFFFF00);
}


void SBLK_Init_Test2(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel)
{
	u32 uReg;
	u32 *pSrc;
	int i;

	oSblk.m_eSblkType = eSblkType;
	oSblk.m_eOperMode = eOperMode;

	SBLK_Reset();

	if (oSblk.m_eSblkType == AES)
	{
		

	 switch(g_AES_Key)
	 	{
		case 0:
	 		Copy((u32)uAesKey, rAES_RX_KEY1, 4); 			// install aes key
			Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);

			//UART_Printf("Selected 128 Key Option \n");
			break;

		case 1:
	 		Copy((u32)uAesKey192, rAES_RX_KEY1, 6); 			// install aes key
	 		Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			uReg |= (1<<1);
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);
			//UART_Printf("Selected 196 Key Option \n");
			break;
		
		case 2:
	 		Copy((u32)uAesKey256, rAES_RX_KEY1, 8); 			// install aes key
	 		Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			uReg |= (2<<1);
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);
			//UART_Printf("Selected 256 Key Option \n");
			break;

	 	}


		
	}
	else if (oSblk.m_eSblkType == DES)
	{
		Copy((u32)uDesKey, rDES_RX_KEY1_0, 6); 		// install des key
		Copy((u32)uDesIV, rDES_RX_IV0, 2); 			// install des iv

		uReg = ((eDirSel == ENC)? (0<<2) : (1<<2))|(1<<5)|(1<<1);		// TDES
		if (oSblk.m_eOperMode == ECB)
			uReg |= (1<<3);
		else if (oSblk.m_eOperMode == CBC)
			uReg |= (2<<3);
		else
			Assert(0);
		Outp32(rDES_RX_CTRL, uReg);
	}
	else if (oSblk.m_eSblkType == HASH)
	{
		if (oSblk.m_eOperMode == HMAC)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<2)|(0<<0)); // start + key mode

			pSrc = (u32 *)uHmacKey;
			for(i=0; i<16; i++)
				*(u32 *)rHASH_RX_DAT = *pSrc++;

			Outp32(rHASH_RX_CTRL, (0<<2)); // text mode
		}
		else if (oSblk.m_eOperMode == SHA1)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<0));
		}
		else if(oSblk.m_eOperMode == PRNG)
		{
			Outp32(rHASH_RX_CTRL, SEED_SET_ENABLE|HASH_START|(2<<0));
			Copy((u32)uPrngSeed, rPRNG_SEED_DAT1, 10);
		}
		else
		{
			Assert(0);
		}
	}

	Outp32(rDNI_CFG, 0xFFFFFF00);
}

void SBLK_Init_Test3(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel)
{
	u32 uReg;
	u32 *pSrc;
	int i;

	oSblk.m_eSblkType = eSblkType;
	oSblk.m_eOperMode = eOperMode;

	SBLK_Reset();

	if (oSblk.m_eSblkType == AES)
	{
		

	 switch(g_AES_Key)
	 	{
		case 0:
	 		Copy((u32)uAesKey, rAES_RX_KEY1, 4); 			// install aes key
			Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter_, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);

			//UART_Printf("Selected 128 Key Option \n");
			break;

		case 1:
	 		Copy((u32)uAesKey192, rAES_RX_KEY1, 6); 			// install aes key
	 		Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter_+0x10, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			uReg |= (1<<1);
			uReg |= (1<<6);			// 32bit
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);
			
			//UART_Printf("Selected 196 Key Option \n");
			break;
		
		case 2:
	 		Copy((u32)uAesKey256, rAES_RX_KEY1, 8); 			// install aes key
	 		Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
			Copy((u32)uAesInitCounter_+0x30, rAES_RX_CTR1, 4); 	// install ctr data 


			uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
			uReg |= (2<<1);
			uReg |= (2<<6);			// 64bit
			if (oSblk.m_eOperMode == ECB)
				uReg |= (1<<4);
			else if (oSblk.m_eOperMode == CBC)
				uReg |= (2<<4);
			else if (oSblk.m_eOperMode == CTR)
				uReg |= (3<<4);
			else
				Assert(0);
			Outp32(rAES_RX_CTRL, uReg);
			//UART_Printf("Selected 256 Key Option \n");
			break;

	 	}


		
	}
	else if (oSblk.m_eSblkType == DES)
	{
		Copy((u32)uDesKey, rDES_RX_KEY1_0, 6); 		// install des key
		Copy((u32)uDesIV, rDES_RX_IV0, 2); 			// install des iv

		uReg = ((eDirSel == ENC)? (0<<2) : (1<<2))|(1<<5)|(1<<1);		// TDES
		if (oSblk.m_eOperMode == ECB)
			uReg |= (1<<3);
		else if (oSblk.m_eOperMode == CBC)
			uReg |= (2<<3);
		else
			Assert(0);
		Outp32(rDES_RX_CTRL, uReg);
	}
	else if (oSblk.m_eSblkType == HASH)
	{
		if (oSblk.m_eOperMode == HMAC)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<2)|(0<<0)); // start + key mode

			pSrc = (u32 *)uHmacKey;
			for(i=0; i<16; i++)
				*(u32 *)rHASH_RX_DAT = *pSrc++;

			Outp32(rHASH_RX_CTRL, (0<<2)); // text mode
		}
		else if (oSblk.m_eOperMode == SHA1)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<0));
		}
		else if(oSblk.m_eOperMode == PRNG)
		{
			Outp32(rHASH_RX_CTRL, SEED_SET_ENABLE|HASH_START|(2<<0));
			Copy((u32)uPrngSeed, rPRNG_SEED_DAT1, 10);
		}
		else
		{
			Assert(0);
		}
	}

	Outp32(rDNI_CFG, 0xFFFFFF00);
}

void SBLK_Init_T(SBLK_TYPE eSblkType, OPER_MODE eOperMode, DIR_SEL eDirSel)
{
	u32 uReg;
	u32 *pSrc;
	int i;

	oSblk.m_eSblkType = eSblkType;
	oSblk.m_eOperMode = eOperMode;

	SBLK_Reset();

	if (oSblk.m_eSblkType == AES)
	{
		Copy((u32)uAesKey, rAES_RX_KEY1, 4); 			// install aes key
		Copy((u32)uAesIV, rAES_RX_IV1, 4); 			// install aes iv
		Copy((u32)uAesInitCounter, rAES_RX_CTR1, 4); 	// install ctr data 

		uReg = (eDirSel == ENC)? (0<<3) : (1<<3);
		if (oSblk.m_eOperMode == ECB)
			uReg |= (1<<4);
		else if (oSblk.m_eOperMode == CBC)
			uReg |= (2<<4);
		else if (oSblk.m_eOperMode == CTR)
			uReg |= (3<<4);
		else
			Assert(0);
		Outp32(rAES_RX_CTRL, uReg);
	}
	else if (oSblk.m_eSblkType == DES)
	{
		Copy((u32)uDesKey, rDES_RX_KEY1_0, 6); 		// install des key
		Copy((u32)uDesIV, rDES_RX_IV0, 2); 			// install des iv

		uReg = ((eDirSel == ENC)? (0<<2) : (1<<2))|(0<<5)|(1<<1);
		if (oSblk.m_eOperMode == ECB)
			uReg |= (1<<3);
		else if (oSblk.m_eOperMode == CBC)
			uReg |= (2<<3);
		else
			Assert(0);
		Outp32(rDES_RX_CTRL, uReg);
	}
	else if (oSblk.m_eSblkType == HASH)
	{
		if (oSblk.m_eOperMode == HMAC)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<2)|(0<<0)); // start + key mode

			pSrc = (u32 *)uHmacKey;
			for(i=0; i<16; i++)
				*(u32 *)rHASH_RX_DAT = *pSrc++;

			Outp32(rHASH_RX_CTRL, (0<<2)); // text mode
		}
		else if (oSblk.m_eOperMode == SHA1)
		{
			Outp32(rHASH_RX_CTRL, HASH_START|(1<<8)|(1<<0));
		}
		else if(oSblk.m_eOperMode == PRNG)
		{
			Outp32(rHASH_RX_CTRL, SEED_SET_ENABLE|HASH_START|(2<<0));
			Copy((u32)uPrngSeed, rPRNG_SEED_DAT1, 10);
		}
		else
		{
			Assert(0);
		}
	}

	Outp32(rDNI_CFG, 0xFFFFFF00);
}


void SBLK_PutDataToInReg1(u32 uSrcAddr, u32 uSize, LVALID_BYTE eLValid)
{
	u32 i, uReg;
	u32 *pSrcAddr, *pDstAddr;

	pSrcAddr = (u32 *)uSrcAddr;

	if (oSblk.m_eSblkType == AES)
	{
		pDstAddr = (u32 *)rAES_RX_DIN1;
		for (i=uSize; i>0; i--)
			Outp32(pDstAddr++, *pSrcAddr++);
	}
	else if (oSblk.m_eSblkType == DES)
	{
		pDstAddr = (u32 *)rDES_RX_IN0;
		for (i=uSize; i>0; i--)
			Outp32(pDstAddr++, *pSrcAddr++);
	}
	else
	{
		UART_Printf("SHA1 Intermediate\n");
		Outp32(rHASH_RX_CTRL, 0x109);
		for (i=uSize; i>0; i--)
		{
		//Outp32(rHASH_RX_CTRL, 0x09);	
			if(i == 1)
			{
				uReg =
					((eLValid == LASTBYTE_1ST)? (0<<6) :
					(eLValid == LASTBYTE_2ND)? (1<<6) :
					(eLValid == LASTBYTE_3RD)? (2<<6) : (3<<6)) |
					HASH_INPUT_FINISHED |
					((oSblk.m_eOperMode == HMAC)? (0<<0) :
					(oSblk.m_eOperMode == SHA1)? (1<<0) : (2<<0));

				uReg |= (1<<8);	
				UART_Printf("RX_CTRL = 0x%x\n",uReg);
				
				Outp32(rHASH_RX_CTRL, 0xD1);
				//Outp32(rHASH_RX_CTRL, uReg); // inform hash of last data input
			}
			Outp32(rHASH_RX_DAT, *pSrcAddr++);
			
		}
	}
}

#endif
#endif
