/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6400.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : sblock_test.c
*  
*	File Description : This file implements the functons for security sub-system test.
*
*	Author : Wonjoon Jang
*	Dept. : AP Development Team
*	Created Date : 2009/01/21
*	Version : 0.1 
* 
*	History
*	- Created(wonjoon.jang 2009/01/21)
*  
**************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include "system.h"
#include "library.h"
#include "util.h"
#include "def.h"
#include "intc.h"
#include "gpio.h"
#include "sysc.h"
#include "timer.h"
#include "sblock.h"
#include "sblock_data.h"
#include "sblock_para.h"

//void SBLOCK_Test(void);



static AESCtrl eAesCtrl;
static DESCtrl eDesCtrl;
static HASHCtrl eHashCtrl;
static PKACtrl ePKACtrl;
static OPER_MODE eDesOperMode;
static OPER_MODE eHashOperMode;
volatile int g_sblock_err;
volatile int g_sblock_cnt;


extern SBLK oSblk;
extern volatile u32 gPKANumSize;    	// real number size in bytes
extern volatile u32 gPKASegSize;    		// memory slot size in bytes

// for PKA
volatile u32 aCompare_A_ID[30] = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
							      0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 	0x1, 0x1, 0x1, 0x1, 0x1, 0x1 };
volatile u32 aCompare_B_ID[30] = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
							      0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 	0x1, 0x1, 0x1, 0x1, 0x1, 0x1 };
volatile u32 aCompare_M_ID[30] = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
							      0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 	0x1, 0x1, 0x1, 0x1, 0x1, 0x1 };
volatile u32 aCompare_S_ID[30] = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
							      0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 	0x1, 0x1, 0x1, 0x1, 0x1, 0x1 };
volatile u32 aCompare_SIGN_ID[30] = { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
							      		0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 	0x1, 0x1, 0x1, 0x1, 0x1, 0x1 };
volatile u32 g_SEG_A_ID, g_SEG_B_ID, g_SEG_M_ID, g_SEG_S_ID;
volatile u32 g_SEGSUM;
volatile u32 g_MaxSEGID;
volatile u32 g_SBLKTestOpt;	//0: Normal,  1:Clock ON/OFF, 2:PWR Mode

void Init_BUF(u32 da, u32 words)
{
	u32 i;	
	for (i=0; i<words; i++)
		*(u32 *)(da+i*4) = 0;
}

void SBLK_ClockOnOFF(u32 uTestOpt)
{
	
	if(uTestOpt==1)
	{
		// IP Clock Off and On Before IP Running.....
		SYSC_SetClkOFF_IP(eCRYPTO);
		DelayfrTimer(milli, rand()%10);			// under 10ms
		SYSC_SetClkON_IP(eCRYPTO);
	}
}

void SBLK_PowerMode(u32 uTestOpt)
{
	
	if(uTestOpt==2)
	{
		DelayfrTimer(micro, rand()%1000);
		// Entering the random power mode(Idle, Deep Idle, Stop, Deep Stop, Sleep, & S/W reset)
		SYSCT_TestSimplePowerMode_Temp(rand()%6+1);	
	}
}

#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES");
				DispOperMode();
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("AES_");
				DispOperMode();
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_ENC Success..\n");
			}

	SBLK_TYPE	m_eSblkType;
	OPER_MODE	m_eOperMode;
	SBLK_BSWAP	m_eDISwap;
	SBLK_BSWAP	m_eDOSwap;
	SBLK_BSWAP	m_eRDMASwap;
	SBLK_BSWAP	m_eTDMASwap;

	DIR_SEL		m_eDir;
	SBLK_FIFOMD	m_eTestType;

		
#endif
//void DispOperMode(eFunction_Test eTest, u32 uRet)

void DispOperMode(void)
{
	if(SBLK_DEBMSG)
	{
		//Display Engine
		if(oSblk.m_eSblkType == AES ) UART_Printf("AES_");
		else if(oSblk.m_eSblkType == DES) UART_Printf("DES_");
		else if(oSblk.m_eSblkType == TDES)
		{
			UART_Printf("TDES_");
			if(oSblk.m_eOperMode1 == EDE)	UART_Printf("EDE_");
			else if(oSblk.m_eOperMode1 == EEE) UART_Printf("EEE_");
		}
		else if(oSblk.m_eSblkType == HASH) UART_Printf("HASH_");
		else if(oSblk.m_eSblkType == PKA)	UART_Printf("PKA_");

		// Display Operating Mode
		if (oSblk.m_eOperMode == ECB) UART_Printf("ECB_");
		else if (oSblk.m_eOperMode == CBC) UART_Printf("CBC_");
		else if (oSblk.m_eOperMode == CTR) UART_Printf("CTR_");
		else if (oSblk.m_eOperMode == SHA1_HASH) UART_Printf("HASH(SHA1)_");
		else if (oSblk.m_eOperMode == SHA1_HMAC) UART_Printf("HMAC(SHA1)_");
		else if (oSblk.m_eOperMode == MD5_HASH) UART_Printf("HASH(MD5)_");
		else if (oSblk.m_eOperMode == MD5_HMAC) UART_Printf("HMAC(MD5)_");
		else if (oSblk.m_eOperMode == PRNG) UART_Printf("PRNG_");

		// Display Operation2 Mode
		if(oSblk.m_eSblkType == AES)
		{
			if(eAesCtrl.eKeySz== Key128b)	UART_Printf("128Key_");
			else if(eAesCtrl.eKeySz== Key192b)	UART_Printf("192Key_");
			else if(eAesCtrl.eKeySz== Key256b)	UART_Printf("256Key_");
		}

		// Display ByteSwap
		if (oSblk.m_eDISwap == SBLK_Swap) UART_Printf("[S]");
		else if(oSblk.m_eDISwap == SBLK_NoSwap) UART_Printf("[NS]");
		if (oSblk.m_eRDMASwap == SBLK_Swap) UART_Printf("[S]_");
		else if(oSblk.m_eRDMASwap == SBLK_NoSwap) UART_Printf("[NS]_");	

		// Test Type
		if(oSblk.m_eTestType == SBLK_CPU)	UART_Printf("CPU_");
		else if(oSblk.m_eTestType == SBLK_FIFO) UART_Printf("DMA_");
		else if(oSblk.m_eTestType == SBLK_BCPU) UART_Printf("BufferCPU_");

		// Direction
		if(oSblk.m_eDir == ENC) UART_Printf("ENC_");
		else if(oSblk.m_eDir == DEC) UART_Printf("DEC_");

		UART_Printf("=====> 	");
		
	}
}

void SBLK_ResultDisp(eFunction_Test eTest, u32 uRet)
{

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
			DispOperMode();
			UART_Printf("PASS   !!!\n");
		}
		else
		{
			DispOperMode();
			UART_Printf("FAIL   !!!\n");
		}
	}
	else
	{
		if (uRet)
		{		
			if(SBLK_DEBMSG)
			{
				DispOperMode();
				UART_Printf("PASS   !!!\n");	
			}
		}
		else
		{
			if(SBLK_DEBMSG)	
			{
				DispOperMode();
				UART_Printf("FAIL   !!!\n");
				UART_Getc();
			}
			g_sblock_err =1;
		}
	}
}


// for Test
void Select_SEGID(u32 uSEGSIZE)
{
		
	if(uSEGSIZE == SEG_QUARTER) g_MaxSEGID = 30;		// 0~6
	else if (uSEGSIZE == SEG_HALF) g_MaxSEGID = 15;	// 0~14
	else if (uSEGSIZE == SEG_FULL) g_MaxSEGID = 7;	// 0~29


	while(1)
	{
		if(gPKASegSize>=gPKANumSize)
		{
			g_SEG_A_ID = (rand()%g_MaxSEGID);
			g_SEG_B_ID = (rand()%g_MaxSEGID);
			g_SEG_M_ID = (rand()%g_MaxSEGID);
			g_SEG_S_ID = (rand()%g_MaxSEGID);

			while(g_SEG_A_ID == g_SEG_B_ID)
			{
				g_SEG_B_ID = (rand()%g_MaxSEGID);
			}
			while((g_SEG_A_ID == g_SEG_M_ID)||(g_SEG_B_ID == g_SEG_M_ID))
			{
				g_SEG_M_ID = (rand()%g_MaxSEGID);
			}			
			while((g_SEG_A_ID == g_SEG_S_ID)||(g_SEG_B_ID == g_SEG_S_ID)||(g_SEG_M_ID == g_SEG_S_ID))
			{
				g_SEG_S_ID = (rand()%g_MaxSEGID);
			}				
		}
		if(SBLK_DEBMSG)
		UART_Printf("[%d][%d][%d][%d]\n", g_SEG_A_ID, g_SEG_B_ID, g_SEG_M_ID, g_SEG_S_ID);	
		break;
	}

}

void Compare_SEGID(u32 uSEGSIZE)
{
	u32 i;
		
	if(uSEGSIZE == SEG_QUARTER) g_MaxSEGID = 30;		// 0~6
	else if (uSEGSIZE == SEG_HALF) g_MaxSEGID = 15;	// 0~14
	else if (uSEGSIZE == SEG_FULL) g_MaxSEGID = 7;	// 0~29

	while(1)
	{
		g_SEGSUM =0;
		aCompare_A_ID[g_SEG_A_ID] = aCompare_A_ID[g_SEG_A_ID] & (~(1<<0));
		aCompare_B_ID[g_SEG_B_ID] = aCompare_B_ID[g_SEG_B_ID] & (~(1<<0));
		aCompare_M_ID[g_SEG_M_ID] = aCompare_M_ID[g_SEG_M_ID] & (~(1<<0));
		aCompare_S_ID[g_SEG_S_ID] = aCompare_S_ID[g_SEG_S_ID] & (~(1<<0));

		for(i=0;i<g_MaxSEGID;i++)
		{
			g_SEGSUM = g_SEGSUM+aCompare_A_ID[i]+aCompare_B_ID[i]+aCompare_M_ID[i]+aCompare_S_ID[i];
		}
		break;
	}

}

void Return_SEGID(void)
{
	u32 i;

	for(i=0;i<30;i++)
	{
		aCompare_A_ID[i] = 1;
		aCompare_A_ID[i] = 1;
		aCompare_A_ID[i]=1;
		aCompare_A_ID[i]=1;
	
	}

}

void SBLKT_PKA_CPU_temp(void)
{

    int a_id = 4;
    int b_id = 3;
    int m_id = 1;
    int s_id = 2;

#if 0
	SBLK_InitPKA_(SEG_FULL, 512, PREC_QUADRUPLE);
	Compare_SEGID(SEG_FULL);

   while(g_SEGSUM >0 )
   {
    Select_SEGID(SEG_FULL);
    
    SBLK_PutPKA_CPU_(buf_a, g_SEG_A_ID);
    SBLK_PutPKA_CPU_(buf_b, g_SEG_B_ID);
    SBLK_PutPKA_CPU_(buf_m, g_SEG_M_ID);

    SBLK_PKA_(g_SEG_A_ID, g_SEG_B_ID, g_SEG_M_ID, g_SEG_S_ID, 0);

    SBLK_GetPKA_CPU_((u32 *)OUTPUT_BUF, g_SEG_S_ID, g_SEG_M_ID);

	if (Compare(OUTPUT_BUF, (u32)gold_s, 64))
		Disp ("PKA CPU: P A S S !\n");
	else
		Disp ("PKA CPU: F A I L !\n");

  Compare_SEGID(SEG_FULL);

   }
   Return_SEGID();
#endif

#if 1
	SBLK_InitPKA_(SEG_QUARTER, 128, PREC_SINGLE);
	Compare_SEGID(SEG_QUARTER);

   while(g_SEGSUM >0 )
   {
    Select_SEGID(SEG_QUARTER);
    
    SBLK_PutPKA_CPU_(buf_a_128, g_SEG_A_ID);
    SBLK_PutPKA_CPU_(buf_b_128, g_SEG_B_ID);
    SBLK_PutPKA_CPU_(buf_m_128, g_SEG_M_ID);

    SBLK_PKA_(g_SEG_A_ID, g_SEG_B_ID, g_SEG_M_ID, g_SEG_S_ID, 0);

    SBLK_GetPKA_CPU_((u32 *)OUTPUT_BUF, g_SEG_S_ID, g_SEG_M_ID);

	if (Compare(OUTPUT_BUF, (u32)gold_s_128, 4))
		Disp ("PKA CPU: P A S S !\n");
	else
		Disp ("PKA CPU: F A I L !\n");

  Compare_SEGID(SEG_QUARTER);

   }
   Return_SEGID();
#endif
	
}




/////////////////////////////////////////////////////////////////////////////////

void Test_AES_CPU(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
//void Test_AES_CPU(void)
{
	u32 uRet, i, usel;
	u32 uTestLength;
	//u8 uError;
	//g_sblock_err=0;
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - AES CPU Mode Test]\n");

		UART_Printf("Select AES Operating Mode  : 1)ECB   2)CBC   3)CTR \n");
		usel=UART_GetIntNum();
		if (usel == 1) eAesCtrl.eOperMode = ECB;
		else if (usel == 2) eAesCtrl.eOperMode = CBC;
		else if (usel == 3) eAesCtrl.eOperMode = CTR;

		UART_Printf("Select Key Size : 1)128bit   2)192bit   3)256bit \n");
		usel=UART_GetIntNum();
		if (usel == 1) eAesCtrl.eKeySz = Key128b;
		else if (usel == 2) eAesCtrl.eKeySz = Key192b;
		else if (usel == 3) eAesCtrl.eKeySz = Key256b;

		UART_Printf("Select Byte Swap : 1)No Swap   2)Swap \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			eAesCtrl.eKEYSwap= SBLK_NoSwap;
			eAesCtrl.eCNTSwap= SBLK_NoSwap;
			eAesCtrl.eIVSwap= SBLK_NoSwap;
			eAesCtrl.eDOSwap= SBLK_NoSwap;
			eAesCtrl.eDISwap= SBLK_NoSwap;
		}
		else if (usel == 2)
		{
			eAesCtrl.eKEYSwap= SBLK_Swap;
			eAesCtrl.eCNTSwap= SBLK_Swap;
			eAesCtrl.eIVSwap= SBLK_Swap;
			eAesCtrl.eDOSwap= SBLK_Swap;
			eAesCtrl.eDISwap= SBLK_Swap;
		}
		
	}
	else
	{
		eAesCtrl.eOperMode = (OPER_MODE)oAutoVar.Test_Parameter[0];
		eAesCtrl.eKeySz     = (AES_KEY)oAutoVar.Test_Parameter[1];
		
		eAesCtrl.eKEYSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[2];
		eAesCtrl.eCNTSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[3];
		eAesCtrl.eIVSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[4];
		eAesCtrl.eDOSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[5];
		eAesCtrl.eDISwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[6];
		eAesCtrl.eDMASwap= (SBLK_BSWAP)oAutoVar.Test_Parameter[7];
		
	}
	
	//////////////////////////
	////// Encryption
	eAesCtrl.eFIFOMD   = SBLK_CPU;
	//eAesCtrl.eKeySz     = Key128b;
	eAesCtrl.eKeyMD  = NChangeKey;
	eAesCtrl.eDir   	= ENC;
	uTestLength = 16;

	oSblk.m_eTestType	= eAesCtrl.eFIFOMD;
	oSblk.m_eDir	=	eAesCtrl.eDir;


	SBLK_AESInit(eAesCtrl, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter);

	SBLK_ClockOnOFF(g_SBLKTestOpt);

	for(i=0; i<uTestLength;i+=4)
	{
			
		SBLK_PutDataToInReg((u32)u_Aes_PlainText+i*4, 4);
		//SBLK_StartByManual();

		while(!SBLK_IsOutputReady());

		SBLK_GetDataFromOutReg(OUTPUT_BUF+i*4, 4);
		SBLK_ValidZero();

		if(eAesCtrl.eKeyMD  == NChangeKey)
			SBLK_AESCloseKey();

	}

	if(eAesCtrl.eKeySz  == Key128b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[0][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[0][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[0][2], GOLDEN_BUF, 16);
	}
	else if (eAesCtrl.eKeySz == Key192b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[1][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[1][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[1][2], GOLDEN_BUF, 16);
	}
	else if (eAesCtrl.eKeySz == Key256b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[2][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[2][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[2][2], GOLDEN_BUF, 16);
	}	
	SBLK_PowerMode(g_SBLKTestOpt);
	

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 16);

	SBLK_ResultDisp(eTest, uRet);

	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES");
				DispOperMode();
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("AES_");
				DispOperMode();
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_ENC Success..\n");
			}
	}
	#endif
	
	/////////////////////////
	////// Decryption
	if (eAesCtrl.eOperMode == CTR)
		eAesCtrl.eDir   	= ENC;
	else
		eAesCtrl.eDir   	= DEC;

	oSblk.m_eDir	=	eAesCtrl.eDir;
		
	SBLK_AESInit(eAesCtrl, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter);	

	SBLK_ClockOnOFF(g_SBLKTestOpt);

	for(i=0; i<uTestLength;i+=4)
	{
			
		SBLK_PutDataToInReg(OUTPUT_BUF+i*4, 4);
		//SBLK_StartByManual();

		while(!SBLK_IsOutputReady());

		SBLK_GetDataFromOutReg(INPUT_BUF+i*4, 4);
		SBLK_ValidZero();

		if(eAesCtrl.eKeyMD  == NChangeKey)
			SBLK_AESCloseKey();

	}
	SBLK_PowerMode(g_SBLKTestOpt);
	
	Copy((u32)u_Aes_PlainText, GOLDEN_BUF, 16);
	uRet = Compare(INPUT_BUF, GOLDEN_BUF, 16);

	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_DEC Success..\n\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode( );
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_DEC Failed..\n\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES");
				DispOperMode( );
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("AES_");
				DispOperMode( );
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_DEC Success..\n");
			}
	}
	#endif
	
}

void Test_AES_CPU_TB(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
//void Test_AES_CPU(void)
{
	u32 uRet, i, usel;
	u32 uTestLength;
	//u8 uError;
	//g_sblock_err=0;
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - AES CPU Mode Test]\n");

		UART_Printf("Select AES Operating Mode  : 1)ECB   2)CBC   3)CTR \n");
		usel=UART_GetIntNum();
		if (usel == 1) eAesCtrl.eOperMode = ECB;
		else if (usel == 2) eAesCtrl.eOperMode = CBC;
		else if (usel == 3) eAesCtrl.eOperMode = CTR;

		UART_Printf("Select Key Size : 1)128bit   2)192bit   3)256bit \n");
		usel=UART_GetIntNum();
		if (usel == 1) eAesCtrl.eKeySz = Key128b;
		else if (usel == 2) eAesCtrl.eKeySz = Key192b;
		else if (usel == 3) eAesCtrl.eKeySz = Key256b;

		UART_Printf("Select Byte Swap : 1)No Swap   2)Swap \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			eAesCtrl.eKEYSwap= SBLK_NoSwap;
			eAesCtrl.eCNTSwap= SBLK_NoSwap;
			eAesCtrl.eIVSwap= SBLK_NoSwap;
			eAesCtrl.eDOSwap= SBLK_NoSwap;
			eAesCtrl.eDISwap= SBLK_NoSwap;
			eAesCtrl.eDMASwap=SBLK_NoSwap;
		}
		else if (usel == 2)
		{
			eAesCtrl.eKEYSwap= SBLK_Swap;
			eAesCtrl.eCNTSwap= SBLK_Swap;
			eAesCtrl.eIVSwap= SBLK_Swap;
			eAesCtrl.eDOSwap= SBLK_Swap;
			eAesCtrl.eDISwap= SBLK_Swap;
			eAesCtrl.eDMASwap=SBLK_Swap;
		}

		
	}
	else
	{
		eAesCtrl.eOperMode = (OPER_MODE)oAutoVar.Test_Parameter[0];
		eAesCtrl.eKeySz     = (AES_KEY)oAutoVar.Test_Parameter[1];
		
		eAesCtrl.eKEYSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[2];
		eAesCtrl.eCNTSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[3];
		eAesCtrl.eIVSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[4];
		eAesCtrl.eDOSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[5];
		eAesCtrl.eDISwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[6];
		eAesCtrl.eDMASwap= (SBLK_BSWAP)oAutoVar.Test_Parameter[7];
	}
	
	//////////////////////////
	////// Encryption

	eAesCtrl.eFIFOMD   = SBLK_CPU;
	//eAesCtrl.eKeySz= Key128b;
	eAesCtrl.eKeyMD  = NChangeKey;
	eAesCtrl.eDir   	= ENC;
	uTestLength = 16;

	oSblk.m_eTestType	= SBLK_BCPU;
	oSblk.m_eDir	=	eAesCtrl.eDir;

	SBLK_AESInit(eAesCtrl, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter);

#if 0
	SBLK_PutDataToInReg((u32)u_Aes_PlainText, 4);
	
	//if(eAesCtrl.eKeyMD  == NChangeKey)	// Fail
	//SBLK_AESCloseKey();

	for(i=4; i<uTestLength;i+=4)
	{
			
		SBLK_PutDataToInReg((u32)u_Aes_PlainText+i*4, 4);
		//SBLK_StartByManual();

		while(!SBLK_IsOutputReady());

		SBLK_GetDataFromOutReg(OUTPUT_BUF+(i-4)*4, 4);
		SBLK_ValidZero();
		if(eAesCtrl.eKeyMD  == NChangeKey)	//Fail  1Block, 4Block Pass
		SBLK_AESCloseKey();

		//while((Inp32(0xEA004004)&0x4) == 0x1);	//Fail  1Block, 4Block Pass
		//SBLK_AESCloseKey();
		

	}

	while(!SBLK_IsOutputReady());
	SBLK_GetDataFromOutReg(OUTPUT_BUF+(i-4)*4, 4);
	SBLK_ValidZero();
#endif
#if 1	// for test  PASS
	SBLK_PutDataToInReg((u32)u_Aes_PlainText, 4);
	while(!SBLK_IsOutputReady());
	if(eAesCtrl.eKeyMD  == NChangeKey)	// Fail
	SBLK_AESCloseKey();
	SBLK_GetDataFromOutReg(OUTPUT_BUF, 4);
	SBLK_ValidZero();
	

	// Double Buffer
	SBLK_PutDataToInReg((u32)u_Aes_PlainText+4*4, 4);
	SBLK_PutDataToInReg((u32)u_Aes_PlainText+8*4, 4);

	while(!SBLK_IsOutputReady());
	SBLK_GetDataFromOutReg(OUTPUT_BUF+4*4, 4);
	SBLK_ValidZero();
	SBLK_PutDataToInReg((u32)u_Aes_PlainText+12*4, 4);
	while(!SBLK_IsOutputReady());
	SBLK_GetDataFromOutReg(OUTPUT_BUF+8*4, 4);
	SBLK_ValidZero();
	while(!SBLK_IsOutputReady());
	SBLK_GetDataFromOutReg(OUTPUT_BUF+12*4, 4);
	SBLK_ValidZero();


#endif

	if(eAesCtrl.eKeySz  == Key128b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[0][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[0][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[0][2], GOLDEN_BUF, 16);
	}
	else if (eAesCtrl.eKeySz == Key192b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[1][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[1][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[1][2], GOLDEN_BUF, 16);
	}
	else if (eAesCtrl.eKeySz == Key256b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[2][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[2][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[2][2], GOLDEN_BUF, 16);
	}	

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 16);

	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_TB_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_TB_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES");
				DispOperMode();
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_TB_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("AES_");
				DispOperMode();
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_TB_ENC Success..\n");
			}
	}
	#endif
	
	/////////////////////////
	////// Decryption
	if (eAesCtrl.eOperMode == CTR)
		eAesCtrl.eDir   	= ENC;
	else
		eAesCtrl.eDir   	= DEC;

	oSblk.m_eDir	=	eAesCtrl.eDir;	
	SBLK_AESInit(eAesCtrl, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter);	

	#if 0
	SBLK_PutDataToInReg(OUTPUT_BUF, 4);

	//if(eAesCtrl.eKeyMD  == NChangeKey)	//Fail
	//SBLK_AESCloseKey();

	for(i=4; i<uTestLength;i+=4)
	{
			
		SBLK_PutDataToInReg(OUTPUT_BUF+i*4, 4);
		//SBLK_StartByManual();

		while(!SBLK_IsOutputReady());

		SBLK_GetDataFromOutReg(INPUT_BUF+(i-4)*4, 4);
		SBLK_ValidZero();
	//if(eAesCtrl.eKeyMD  == NChangeKey)	//Fail
	//SBLK_AESCloseKey();
	}

	while(!SBLK_IsOutputReady());

	SBLK_GetDataFromOutReg(INPUT_BUF+(i-4)*4, 4);
	SBLK_ValidZero();
	#endif
	#if 1 // 09.03.11 for test
	
	SBLK_PutDataToInReg(OUTPUT_BUF, 4);
	while(!SBLK_IsOutputReady());
	if(eAesCtrl.eKeyMD  == NChangeKey)	//Fail
	SBLK_AESCloseKey();
	SBLK_GetDataFromOutReg(INPUT_BUF, 4);
	SBLK_ValidZero();

	// Double Buffer
	SBLK_PutDataToInReg(OUTPUT_BUF+4*4, 4);
	SBLK_PutDataToInReg(OUTPUT_BUF+8*4, 4);

	while(!SBLK_IsOutputReady());
	SBLK_GetDataFromOutReg(INPUT_BUF+4*4, 4);
	SBLK_ValidZero();
	SBLK_PutDataToInReg(OUTPUT_BUF+12*4, 4);
	while(!SBLK_IsOutputReady());
	SBLK_GetDataFromOutReg(INPUT_BUF+8*4, 4);
	SBLK_ValidZero();
	while(!SBLK_IsOutputReady());
	SBLK_GetDataFromOutReg(INPUT_BUF+12*4, 4);
	SBLK_ValidZero();	

	#endif

	

	Copy((u32)u_Aes_PlainText, GOLDEN_BUF, 16);
	uRet = Compare(INPUT_BUF, GOLDEN_BUF, 16);

	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_TB_DEC Success..\n\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode( );
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_CPU_TB_DEC Failed..\n\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES");
				DispOperMode( );
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_TB_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("AES_");
				DispOperMode( );
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_CPU_TB_DEC Success..\n");
			}
	}
	#endif
	
}

void Test_AES_DMA(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet, usel,uTestLength;

	//g_sblock_err=0;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - AES DMA_FIFO Mode Test]\n");

		UART_Printf("Select AES Operating Mode  : 1)ECB   2)CBC   3)CTR \n");
		usel=UART_GetIntNum();
		if (usel == 1) eAesCtrl.eOperMode = ECB;
		else if (usel == 2) eAesCtrl.eOperMode = CBC;
		else if (usel == 3) eAesCtrl.eOperMode = CTR;



		UART_Printf("Select Key Size : 1)128bit   2)192bit   3)256bit \n");
		usel=UART_GetIntNum();
		if (usel == 1) eAesCtrl.eKeySz = Key128b;
		else if (usel == 2) eAesCtrl.eKeySz = Key192b;
		else if (usel == 3) eAesCtrl.eKeySz = Key256b;

		UART_Printf("Select Byte Swap : 1)No Swap   2)Swap \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			eAesCtrl.eKEYSwap= SBLK_NoSwap;
			eAesCtrl.eCNTSwap= SBLK_NoSwap;
			eAesCtrl.eIVSwap= SBLK_NoSwap;
			eAesCtrl.eDOSwap= SBLK_NoSwap;
			eAesCtrl.eDISwap= SBLK_NoSwap;
			eAesCtrl.eDMASwap=SBLK_NoSwap;
		}
		else if (usel == 2)
		{
			eAesCtrl.eKEYSwap= SBLK_Swap;
			eAesCtrl.eCNTSwap= SBLK_Swap;
			eAesCtrl.eIVSwap= SBLK_Swap;
			eAesCtrl.eDOSwap= SBLK_Swap;
			eAesCtrl.eDISwap= SBLK_Swap;
			eAesCtrl.eDMASwap=SBLK_Swap;
		}
		
	}
	else
	{
		eAesCtrl.eOperMode = (OPER_MODE)oAutoVar.Test_Parameter[0];
		eAesCtrl.eKeySz     = (AES_KEY)oAutoVar.Test_Parameter[1];
		
		eAesCtrl.eKEYSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[2];
		eAesCtrl.eCNTSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[3];
		eAesCtrl.eIVSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[4];
		eAesCtrl.eDOSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[5];
		eAesCtrl.eDISwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[6];
		eAesCtrl.eDMASwap= (SBLK_BSWAP)oAutoVar.Test_Parameter[7];
	}

	if(Sblock_INTMD)
	{
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SBLK_PendClearFeed(BTDMA);
		SBLK_EnDMAINT(BTDMA);
		g_SDma1Done =0;
	}
	
	//////////////////////////
	////// Encryption
	eAesCtrl.eFIFOMD   = SBLK_FIFO;
	//eAesCtrl.eKeySz	= Key128b;
	eAesCtrl.eKeyMD  = NChangeKey;
	eAesCtrl.eDir   	= ENC;
	uTestLength = 16;
	oSblk.m_eTestType	= eAesCtrl.eFIFOMD;
	oSblk.m_eDir	=	eAesCtrl.eDir;

	SBLK_AESInit(eAesCtrl, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter);
	Copy((u32)u_Aes_PlainText, INPUT_BUF, 16);

	SBLK_ClockOnOFF(g_SBLKTestOpt);
	
	SBLK_SetDMA(INPUT_BUF, 16, OUTPUT_BUF, 16);
	SBLK_PowerMode(g_SBLKTestOpt);
	
	//while(!g_SDma1Done);
	
	if(eAesCtrl.eKeySz  == Key128b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[0][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[0][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[0][2], GOLDEN_BUF, 16);
	}
	else if (eAesCtrl.eKeySz == Key192b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[1][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[1][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[1][2], GOLDEN_BUF, 16);
	}
	else if (eAesCtrl.eKeySz == Key256b)
	{
		if (eAesCtrl.eOperMode == ECB)  Copy((u32)u_Aes_CipherText[2][0], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CBC) Copy((u32)u_Aes_CipherText[2][1], GOLDEN_BUF, 16);
		else if (eAesCtrl.eOperMode == CTR) Copy((u32)u_Aes_CipherText[2][2], GOLDEN_BUF, 16);
	}	

	
	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 16);

	// add BUF init
	Init_BUF(INPUT_BUF, 16);
	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_DMA_FIFO_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_DMA_FIFO_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES");
				DispOperMode();
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_DMA_FIFO_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
			UART_Printf("AES_");
			DispOperMode();
			UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
			UART_Printf("_DMA_FIFO_ENC Success..\n");
			}
	}
	#endif

	/////////////////////////
	////// Decryption
	if (eAesCtrl.eOperMode == CTR)
		eAesCtrl.eDir   	= ENC;
	else
		eAesCtrl.eDir   	= DEC;

	oSblk.m_eDir	=	eAesCtrl.eDir;
		
	SBLK_AESInit(eAesCtrl, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter);
	g_SDma1Done = 0;	

	SBLK_ClockOnOFF(g_SBLKTestOpt);	
	SBLK_SetDMA(OUTPUT_BUF, 16, INPUT_BUF, 16);
	SBLK_PowerMode(g_SBLKTestOpt);
	//while(!g_SDma1Done);

	Copy((u32)u_Aes_PlainText, GOLDEN_BUF, 16);
	uRet = Compare(INPUT_BUF, GOLDEN_BUF, 16);
	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_DMA_FIFO_DEC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode();
		UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
		UART_Printf("_DMA_FIFO_DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES");
				DispOperMode();
				UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
				UART_Printf("_DMA_FIFO_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
			UART_Printf("AES_");
			DispOperMode();
			UART_Printf("[%d][%d]_[%d][%d]", eAesCtrl.eOperMode, eAesCtrl.eKeyMD, eAesCtrl.eDISwap, eAesCtrl.eDMASwap);
			UART_Printf("_DMA_FIFO_DEC Success..\n");
			}
	}
	#endif
	Init_BUF(INPUT_BUF, 16);
	Init_BUF(GOLDEN_BUF, 16);
	Init_BUF(OUTPUT_BUF, 16);

	SBLK_DisDMAINT(BTDMA);
	INTC_Disable(NUM_FEEDCTRL); 
	//INTC_Disable(NUM_SDMA1);
	
}

#if 0
// It just for test -> this vector is used on 6410
void Test_CTR_Counter(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet;
	u32 uSel;

	//g_sblock_err =0;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - AES(CTR) Counter Edge Test]\n");

		UART_Printf(" Choose AES Key Select :  0 : 128bit,  1:192bit,  2:256bits \n");
		uSel = UART_GetIntNum();
		
	}
	else
	{
		uSel = oAutoVar.Test_Parameter[0];
	}

	 switch(uSel)
	 	{
		case 0:
	 		Copy((u32)uAesCTRCipherText, GOLDEN_BUF, 16);
	 		Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
	 		eAesCtrl.eKeySz		= Key128b;		   
			 break;
		case 1:
			Copy((u32)uAesCTRCipherText+0x40, GOLDEN_BUF, 16);
			Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
			eAesCtrl.eKeySz		= Key192b;
			 break;
	
		case 2:
			Copy((u32)uAesCTRCipherText+0xc0, GOLDEN_BUF, 16);
			Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
			eAesCtrl.eKeySz		= Key256b;
			 break;
	 	}


	eAesCtrl.eKEYSwap= SBLK_Swap;
	eAesCtrl.eCNTSwap= SBLK_Swap;
	eAesCtrl.eIVSwap= SBLK_Swap;
	eAesCtrl.eDOSwap= SBLK_Swap;
	eAesCtrl.eDISwap= SBLK_Swap;
	eAesCtrl.eDMASwap=SBLK_NoSwap;


	if(Sblock_INTMD)
	{
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SBLK_PendClearFeed(BTDMA);
		SBLK_EnDMAINT(BTDMA);
		g_SDma1Done =0;
	}

	// Encryption
	eAesCtrl.eFIFOMD 	= SBLK_FIFO;
	//eAesCtrl.eKeySz		= Key128b;
	eAesCtrl.eKeyMD  	= NChangeKey;
	eAesCtrl.eDir   		= ENC;
	eAesCtrl.eOperMode	= CTR;

	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter_);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter_+0x10);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter_+0x30);
	
	Copy((u32)GOLDEN_BUF1, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 16, OUTPUT_BUF, 16);


	//Copy((u32)uAesCipherText[CBC], GOLDEN_BUF, 16);
	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 16);
	
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		UART_Printf("_CTR_Counter1_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		UART_Printf("_CTR_Counter1_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("_CTR_Counter1_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}

	// Decryption
	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter_);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter_+0x10);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter_+0x30);
	
	Copy((u32)GOLDEN_BUF, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 16, OUTPUT_BUF, 16);

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF1, 16);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		UART_Printf("_CTR_Counter_DEC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		UART_Printf("_CTR_Counter_DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("_CTR_Counter_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	
}
#endif
#if 0
void Test_AES_CONT_DEC(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet;

	//g_sblock_err=0;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - AES Continuos Decryption Test]\n");

	}
	else
	{
		
	}
	Copy((u32)uAesCipherText, GOLDEN_BUF, 16);
	Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
	
       ///////////////////////
	//ECB 128bit Decryption	
	eAesCtrl.eFIFOMD 	= SBLK_FIFO;
	eAesCtrl.eKeySz		= Key128b;
	eAesCtrl.eKeyMD  	= NChangeKey;
	eAesCtrl.eDir   		= DEC;
	eAesCtrl.eOperMode	= ECB;

	if(Sblock_INTMD)
	{
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SBLK_PendClearFeed(BTDMA);
		SBLK_EnDMAINT(BTDMA);
		g_SDma1Done =0;
	}


	SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	Copy((u32)GOLDEN_BUF, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 16, OUTPUT_BUF, 16);
	
	//while(!g_SDma1Done);
	
	Copy(0xEA004030, MID_BUF, 4);						// Intermedate IV Backup  -> This is write Operation	
 	SBLK_FlushDMA(BRDMA);
	SBLK_FlushDMA(BTDMA);

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF1, 4);
	
	
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("ECB 128bit DEC Success..\n");
		}
		else
		{
		
		UART_Printf("ECB 128bit DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("ECB 128bit DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	////////////////////////////////
	//ECB 128bit Continuous Decryption
	Outp32(0xEA004000, 0x49); 		// 128Bit ECB Continuous Decryption.
	Copy(MID_BUF, 0xEA004030, 4);		// Load IV 

	SBLK_SetDMA(INPUT_BUF+0x10, 12*4, OUTPUT_BUF+0x10, 12*4);
	
	uRet = Compare(OUTPUT_BUF+0x10, GOLDEN_BUF1+0x10, 12);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("ECB 128bit Cont. DEC Success..\n");
		}
		else
		{
		
		UART_Printf("ECB 128bit Cont. DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("ECB 128bit Cont. DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	
	

	//////////////////////////////////////////////

	Copy((u32)uAesCipherText+0x40, GOLDEN_BUF, 16);

	///////////////////////////////////////
	//CBC 128bit Decryption	
	eAesCtrl.eFIFOMD 	= SBLK_FIFO;
	eAesCtrl.eKeySz		= Key128b;
	eAesCtrl.eKeyMD  	= NChangeKey;
	eAesCtrl.eDir   		= DEC;
	eAesCtrl.eOperMode	= CBC;

	SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	Copy((u32)GOLDEN_BUF, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 16, OUTPUT_BUF, 16);

	Copy(0xEA004030, MID_BUF, 4);						// Intermedate IV Backup  	
 	SBLK_FlushDMA(BRDMA);
	SBLK_FlushDMA(BTDMA);

	
	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF1, 4);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("CBC 128bit DEC Success..\n");
		}
		else
		{
		
		UART_Printf("CBC 128bit DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("CBC 128bit DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}

	
	///////////////////////////////////////
	//CBC 128bit Continuous Decryption
	Outp32(0xEA004000, 0x4d); 		// 128Bit CBC Continuous Decryption.
	Copy(MID_BUF, 0xEA004030, 4);		// Load IV 

	SBLK_SetDMA(INPUT_BUF+0x10, 12*4, OUTPUT_BUF+0x10, 12*4);
	
	uRet = Compare(OUTPUT_BUF+0x10, GOLDEN_BUF1+0x10, 12);
	

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("CBC 128bit Cont. DEC Success..\n");
		}
		else
		{
		
		UART_Printf("CBC 128bit Cont. DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("CBC 128bit Cont. DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	

	//////////////////////////////////////////////

	Copy((u32)uAesCipherText+0x80, GOLDEN_BUF, 16);


	//CBC 128bit Decryption	
	eAesCtrl.eFIFOMD 	= SBLK_FIFO;
	eAesCtrl.eKeySz		= Key128b;
	eAesCtrl.eKeyMD  	= NChangeKey;
	eAesCtrl.eDir   		= ENC;
	eAesCtrl.eOperMode	= CTR;

	SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	Copy((u32)GOLDEN_BUF, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 16, OUTPUT_BUF, 16);

	Copy(0xEA004080, MID_BUF, 4);						// Intermedate CTR Backup  	
 	SBLK_FlushDMA(BRDMA);
	SBLK_FlushDMA(BTDMA);

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF1, 4);


	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("CTR 128bit DEC Success..\n");
		}
		else
		{
		
		UART_Printf("CTR 128bit DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("CTR 128bit DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	
	
	//ECB 128bit Continuous Decryption
	Outp32(0xEA100000, 0x4c); 		// 128Bit CBC Continuous Decryption.
	Copy(MID_BUF, 0xEA004080, 4);		// Load CTR

	SBLK_SetDMA(INPUT_BUF+0x10, 12*4, OUTPUT_BUF+0x10, 12*4);
	
	uRet = Compare(OUTPUT_BUF+0x10, GOLDEN_BUF1+0x10, 12);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("CTR 128bit Cont. DEC Success..\n");
		}
		else
		{
		
		UART_Printf("CTR 128bit Cont. DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("CTR 128bit Cont. DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	
}


void Test_CBC_IV_FIFO(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet;
	u32 uSel;
	
	//g_sblock_err =0;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - AES(CBC) IV FIFO Test]\n");

		UART_Printf(" Choose AES Key Select :  0 : 128bit,  1:192bit,  2:256bits \n");
		uSel = UART_GetIntNum();
		
	}
	else
	{
		uSel = oAutoVar.Test_Parameter[0];
	}

	 switch(uSel)
	 	{
		case 0:
	 		Copy((u32)uAesCipherText128, GOLDEN_BUF, 16);
	 		Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
	 		eAesCtrl.eKeySz		= Key128b;
		   
			 break;
		case 1:
			Copy((u32)uAesCipherText192, GOLDEN_BUF, 16);
			Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
			eAesCtrl.eKeySz		= Key192b;
			 break;
	
		case 2:
			Copy((u32)uAesCipherText256, GOLDEN_BUF, 16);
			Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
			eAesCtrl.eKeySz		= Key256b;
			 break;
	 	}

	if(Sblock_INTMD)
	{
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SBLK_PendClearFeed(BTDMA);
		SBLK_EnDMAINT(BTDMA);
		g_SDma1Done =0;
	}

	// Encryption
	///////////////////////	
	eAesCtrl.eFIFOMD 	= SBLK_FIFO;
	//eAesCtrl.eKeySz		= Key128b;
	eAesCtrl.eKeyMD  	= NChangeKey;
	eAesCtrl.eDir   		= ENC;
	eAesCtrl.eOperMode	= CBC;

	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter);
	
	Copy((u32)GOLDEN_BUF1, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 8, OUTPUT_BUF, 8);

	// Intermediate IV Back-up
	Copy(0xEA004030, MID_BUF, 4);
	SBLK_FlushDMA(BRDMA);
	SBLK_FlushDMA(BTDMA);

	//Copy((u32)uAesCipherText[CBC], GOLDEN_BUF, 16);
	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 8);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("_IV_1st_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode();
		UART_Printf("_IV_1st_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("_IV_1st_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	
	////////////////////////////
	// Decryption
	//SBLK_Init(AES, CBC, DEC);
	///////////////////////	
	eAesCtrl.eFIFOMD 	= SBLK_FIFO;
	//eAesCtrl.eKeySz		= Key128b;
	eAesCtrl.eKeyMD  	= NChangeKey;
	eAesCtrl.eDir   		= DEC;
	eAesCtrl.eOperMode	= CBC;

	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter);
	

	Copy((u32)GOLDEN_BUF, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 8, OUTPUT_BUF, 8);

	// Intermediate IV Back-up
	Copy(0xEA004030, MID_BUF+0x20, 4);
	SBLK_FlushDMA(BRDMA);
	SBLK_FlushDMA(BTDMA);
	
	// Intermediate IV Back-up
	Copy(0xEA004030, MID_BUF+0x20, 4);

	//Copy((u32)uAesPlainText, GOLDEN_BUF, 16);
	uRet = Compare(INPUT_BUF, GOLDEN_BUF1, 8);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("_IV_1st_DEC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode();
		UART_Printf("_IV_1st_DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("_IV_1st_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}

	// 2nd Encryption 
	eAesCtrl.eDir   		= ENC;

	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter);

	
	Copy(MID_BUF, 0xEA004030, 4);	// Intermediate IV
	Copy((u32)uAesPlainText+0x20, INPUT_BUF, 8);
	SBLK_SetDMA(INPUT_BUF, 8, OUTPUT_BUF+0x20, 8);


	//Copy((u32)uAesCipherText[CBC], GOLDEN_BUF, 16);
	uRet = Compare(OUTPUT_BUF+0x20, GOLDEN_BUF+0x20, 8);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("_IV_2nd_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode();
		UART_Printf("_IV_2nd_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("_IV_2nd_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}


	// 2nd Decryption
	// Decryption
	eAesCtrl.eDir   		= DEC;

	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter);


	Copy(MID_BUF+0x20, 0xEA004030, 4);	// Intermediate IV
	Copy((u32)GOLDEN_BUF+0x20, INPUT_BUF, 8);
	SBLK_SetDMA(INPUT_BUF, 8, OUTPUT_BUF+0x20, 8);
	
	uRet = Compare(OUTPUT_BUF+0x20, GOLDEN_BUF1+0x20, 8);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		DispOperMode();
		UART_Printf("_IV_2nd_DEC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		DispOperMode();
		UART_Printf("_IV_2nd_DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("_IV_2nd_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	
}



void Test_CTR_ICTR_FIFO(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	
	u32 uRet;
	u32 uSel;

	//g_sblock_err =0;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - AES(CTR) INCR FIFO Test]\n");

		UART_Printf(" Choose AES Key Select :  0 : 128bit,  1:192bit,  2:256bits \n");
		uSel = UART_GetIntNum();
		
	}
	else
	{
		uSel = oAutoVar.Test_Parameter[0];
	}
	 switch(uSel)
	 	{
		case 0:
	 		Copy((u32)uAesCTRCipherText_, GOLDEN_BUF, 16);
	 		Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
	 		eAesCtrl.eKeySz		= Key128b;
		   
			 break;
		case 1:
			Copy((u32)uAesCTRCipherText_+0x40, GOLDEN_BUF, 16);
			Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
			eAesCtrl.eKeySz		= Key192b;
			 break;
	
		case 2:
			Copy((u32)uAesCTRCipherText_+0x80, GOLDEN_BUF, 16);
			Copy((u32)uAesPlainText, GOLDEN_BUF1, 16);
			eAesCtrl.eKeySz		= Key256b;
			 break;
	 	}

	if(Sblock_INTMD)
	{
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SBLK_PendClearFeed(BTDMA);
		SBLK_EnDMAINT(BTDMA);
		g_SDma1Done =0;
	}


	// Encryption
	///////////////////////	
	eAesCtrl.eFIFOMD 	= SBLK_FIFO;
	//eAesCtrl.eKeySz		= Key128b;
	eAesCtrl.eKeyMD  	= NChangeKey;
	eAesCtrl.eDir   		= ENC;
	eAesCtrl.eOperMode	= CTR;

	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter);
	
	Copy((u32)GOLDEN_BUF1, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 8, OUTPUT_BUF, 8);
	

	// Intermediate CTR Back-up
	Copy(0xEA004030, MID_BUF, 4);
	
	//Copy((u32)uAesCipherText[CBC], GOLDEN_BUF, 16);
	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 8);
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		UART_Printf("_IV_1st_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		UART_Printf("_IV_1st_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES_CTR");
				UART_Printf("_IV_1st_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}
	
	// Decryption

	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter);
	
	Copy((u32)GOLDEN_BUF, INPUT_BUF, 16);
	SBLK_SetDMA(INPUT_BUF, 8, OUTPUT_BUF, 8);

	// Intermediate CTR Back-up
	Copy(0xEA004040, MID_BUF+0x20, 4);

	//Copy((u32)uAesPlainText, GOLDEN_BUF, 16);
	uRet = Compare(INPUT_BUF, GOLDEN_BUF1, 8);
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		UART_Printf("_IV_1st_DEC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		UART_Printf("_IV_1st_DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES_CTR");
				UART_Printf("_IV_1st_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}


	// 2nd Encryption 
	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter);

	Copy(MID_BUF, 0xEA004040, 4);	// Intermediate IV

	Copy((u32)uAesPlainText+0x20, INPUT_BUF,8);
	SBLK_SetDMA(INPUT_BUF, 8, OUTPUT_BUF+0x20, 8);
		
	//Copy((u32)uAesCipherText[CBC], GOLDEN_BUF, 16);
	uRet = Compare(OUTPUT_BUF+0x20, GOLDEN_BUF+0x20, 8);
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		UART_Printf("_IV_2nd_ENC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		UART_Printf("_IV_2nd_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES_CTR");
				UART_Printf("_IV_2nd_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}

	// 2nd Decryption
	// Decryption

	if(uSel == 0)
		SBLK_AESInit(eAesCtrl, uAesKey, uAesIV, uAesInitCounter);
	else if (uSel == 1)
		SBLK_AESInit(eAesCtrl, uAesKey192, uAesIV, uAesInitCounter);
	else if (uSel == 2)
		SBLK_AESInit(eAesCtrl, uAesKey256, uAesIV, uAesInitCounter);

	Copy(MID_BUF+0x20, 0xEA004040, 4);	// Intermediate IV
	Copy(GOLDEN_BUF+0x20, INPUT_BUF,8);
	SBLK_SetDMA(INPUT_BUF, 8, OUTPUT_BUF+0x20, 8);
	
	//Copy((u32)uAesPlainText, GOLDEN_BUF, 16);
	uRet = Compare(OUTPUT_BUF+0x20, GOLDEN_BUF1+0x20, 8);
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("AES_");
		UART_Printf("_IV_2nd_DEC Success..\n");
		}
		else
		{
		UART_Printf("AES");
		UART_Printf("_IV_2nd_DEC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("AES_CTR");
				UART_Printf("_IV_2nd_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
	}

	
}
#endif

void Test_DES_CPU(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet, i, usel;
	u32 uTestLength;
	//u8 uError;
	//g_sblock_err=0;
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - DES CPU Mode Test]\n");

		UART_Printf("Select DES Operating Mode  : \n");
		UART_Printf(" 1)DES_ECB            2)DES_CBC  3)TDES(EDE)_ECB 4)TDES(EDE)_CBC    \n");
		UART_Printf(" 5)TDES(EEE)_ECB   6)TDES(EEE)_CBC  \n");
		usel=UART_GetIntNum();
		if (usel == 1) 
			{ eDesCtrl.eENG = DES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
		else if (usel == 2) 
			{ 
			   eDesCtrl.eENG = DES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
 		else if (usel == 3) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
 		else if (usel == 4) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
  		else if (usel == 5) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EEE; 
			}		
  		 else if (usel == 6) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EEE; 
			}

		UART_Printf("Select Byte Swap : 1)No Swap   2)Swap \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			eDesCtrl.eKEYSwap= SBLK_NoSwap;
			eDesCtrl.eIVSwap= SBLK_NoSwap;
			eDesCtrl.eDOSwap= SBLK_NoSwap;
			eDesCtrl.eDISwap= SBLK_NoSwap;
		}
		else if (usel == 2)
		{
			eDesCtrl.eKEYSwap= SBLK_Swap;
			eDesCtrl.eIVSwap= SBLK_Swap;
			eDesCtrl.eDOSwap= SBLK_Swap;
			eDesCtrl.eDISwap= SBLK_Swap;
		}
	
	}
	else
	{
		eDesCtrl.eENG = (SBLK_TYPE)oAutoVar.Test_Parameter[0];
		eDesCtrl.eOperMode = (OPER_MODE)oAutoVar.Test_Parameter[1];
		if(eDesCtrl.eENG == DES) eDesCtrl.eEEEMode = EDE;
		else if (eDesCtrl.eENG == TDES)	
			eDesCtrl.eEEEMode = (OPER_MODE)oAutoVar.Test_Parameter[2];

		
		eDesCtrl.eKEYSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[3];
		eDesCtrl.eIVSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[4];
		eDesCtrl.eDOSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[5];
		eDesCtrl.eDISwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[6];
		eDesCtrl.eDMASwap= (SBLK_BSWAP)oAutoVar.Test_Parameter[7];
		
	}
	
	//////////////////////////
	////// Encryption
	eDesCtrl.eFIFOMD   = SBLK_CPU;
	eDesCtrl.eDir   	= ENC;
	uTestLength = 16;

	oSblk.m_eTestType	= eDesCtrl.eFIFOMD;
	oSblk.m_eDir	=	eDesCtrl.eDir;

	SBLK_DESInit(eDesCtrl, u_Des_Key, u_Des_IV);
	//SBLK_ClockOnOFF(g_SBLKTestOpt);
	
	for(i=0; i<uTestLength;i+=2)
	{
			
		SBLK_PutDataToInReg((u32)u_Des_PlainText+i*4, 2);
		//SBLK_StartByManual();

		while(!SBLK_IsOutputReady());

		SBLK_GetDataFromOutReg(OUTPUT_BUF+i*4, 2);
		SBLK_ValidZero();

	}

	if ((eDesCtrl.eENG == DES)&&(eDesCtrl.eOperMode == ECB))
		Copy((u32)u_Des_CipherText[0], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == DES)&&(eDesCtrl.eOperMode == CBC))
		Copy((u32)u_Des_CipherText[1], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == ECB)&&(eDesCtrl.eEEEMode==EDE))
		Copy((u32)u_Tdes_CipherText[0], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == CBC)&&(eDesCtrl.eEEEMode==EDE))
		Copy((u32)u_Tdes_CipherText[1], GOLDEN_BUF, 16);	
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == ECB)&&(eDesCtrl.eEEEMode==EEE))
		Copy((u32)u_Tdes_CipherText[2], GOLDEN_BUF, 16);	
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == CBC)&&(eDesCtrl.eEEEMode==EEE))
		Copy((u32)u_Tdes_CipherText[3], GOLDEN_BUF, 16);	

	//SBLK_PowerMode(g_SBLKTestOpt);
	
	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 16);
	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_CPU_ENC Success..\n");
		}
		else
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_CPU_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("DES_");
				DispOperMode();
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_CPU_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("DES_");
				DispOperMode();
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_CPU_ENC Success..\n");
			}
	}
	#endif
	/////////////////////////
	////// Decryption
	eDesCtrl.eDir   	= DEC;

	oSblk.m_eTestType	= eDesCtrl.eFIFOMD;
	oSblk.m_eDir	=	eDesCtrl.eDir;
		
	SBLK_DESInit(eDesCtrl, u_Des_Key, u_Des_IV);	
	SBLK_ClockOnOFF(g_SBLKTestOpt);
	
	for(i=0; i<uTestLength;i+=2)
	{
			
		SBLK_PutDataToInReg(OUTPUT_BUF+i*4, 2);
		//SBLK_StartByManual();

		while(!SBLK_IsOutputReady());

		SBLK_GetDataFromOutReg(INPUT_BUF+i*4, 2);
		SBLK_ValidZero();

	}
	SBLK_PowerMode(g_SBLKTestOpt);
	
	Copy((u32)u_Des_PlainText, GOLDEN_BUF, 16);
	uRet = Compare(INPUT_BUF, GOLDEN_BUF, 16);
	SBLK_ResultDisp(eTest, uRet);

	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_CPU_DEC Success..\n\n");
		}
		else
		{
		UART_Printf("DES_");
		DispOperMode( );
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_CPU_DEC Failed..\n\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("DES_");
				DispOperMode( );
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_CPU_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("DES_");
				DispOperMode( );
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_CPU_DEC Success..\n");
			}
	}
	#endif
}


void Test_DES_CPU_TB(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet, i, usel;
	u32 uTestLength;
	//u8 uError;
	//g_sblock_err=0;
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - DES CPU Mode Two Buffer]\n");

		UART_Printf("Select DES Operating Mode  : \n");
		UART_Printf(" 1)DES_ECB            2)DES_CBC  3)TDES(EDE)_ECB 4)TDES(EDE)_CBC    \n");
		UART_Printf(" 5)TDES(EEE)_ECB   6)TDES(EEE)_CBC  \n");
		usel=UART_GetIntNum();
		if (usel == 1) 
			{ eDesCtrl.eENG = DES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
		else if (usel == 2) 
			{ 
			   eDesCtrl.eENG = DES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
 		else if (usel == 3) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
 		else if (usel == 4) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
  		else if (usel == 5) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EEE; 
			}		
  		 else if (usel == 6) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EEE; 
			}

		UART_Printf("Select Byte Swap : 1)No Swap   2)Swap \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			eDesCtrl.eKEYSwap= SBLK_NoSwap;
			eDesCtrl.eIVSwap= SBLK_NoSwap;
			eDesCtrl.eDOSwap= SBLK_NoSwap;
			eDesCtrl.eDISwap= SBLK_NoSwap;
		}
		else if (usel == 2)
		{
			eDesCtrl.eKEYSwap= SBLK_Swap;
			eDesCtrl.eIVSwap= SBLK_Swap;
			eDesCtrl.eDOSwap= SBLK_Swap;
			eDesCtrl.eDISwap= SBLK_Swap;
		}


	}
	else
	{
		eDesCtrl.eENG = (SBLK_TYPE)oAutoVar.Test_Parameter[0];
		eDesCtrl.eOperMode = (OPER_MODE)oAutoVar.Test_Parameter[1];
		if(eDesCtrl.eENG == DES) eDesCtrl.eEEEMode = EDE;
		else if (eDesCtrl.eENG == TDES)	
			eDesCtrl.eEEEMode = (OPER_MODE)oAutoVar.Test_Parameter[2];

		eDesCtrl.eKEYSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[3];
		eDesCtrl.eIVSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[4];
		eDesCtrl.eDOSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[5];
		eDesCtrl.eDISwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[6];
		eDesCtrl.eDMASwap= (SBLK_BSWAP)oAutoVar.Test_Parameter[7];
	}
	
	//////////////////////////
	////// Encryption
	eDesCtrl.eFIFOMD   = SBLK_CPU;
	eDesCtrl.eDir   	= ENC;
	uTestLength = 16;
	oSblk.m_eTestType	= SBLK_BCPU;
	oSblk.m_eDir	=	eDesCtrl.eDir;

	SBLK_DESInit(eDesCtrl, u_Des_Key, u_Des_IV);
	
	SBLK_PutDataToInReg((u32)u_Des_PlainText, 2);

	for(i=2; i<uTestLength;i+=2)
	{
			
		SBLK_PutDataToInReg((u32)u_Des_PlainText+i*4, 2);
		//SBLK_StartByManual();

		while(!SBLK_IsOutputReady());

		SBLK_GetDataFromOutReg(OUTPUT_BUF+(i-2)*4, 2);
		SBLK_ValidZero();
	}

	while(!SBLK_IsOutputReady());

	SBLK_GetDataFromOutReg(OUTPUT_BUF+(i-2)*4, 2);
	SBLK_ValidZero();


	if ((eDesCtrl.eENG == DES)&&(eDesCtrl.eOperMode == ECB))
		Copy((u32)u_Des_CipherText[0], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == DES)&&(eDesCtrl.eOperMode == CBC))
		Copy((u32)u_Des_CipherText[1], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == ECB)&&(eDesCtrl.eEEEMode==EDE))
		Copy((u32)u_Tdes_CipherText[0], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == CBC)&&(eDesCtrl.eEEEMode==EDE))
		Copy((u32)u_Tdes_CipherText[1], GOLDEN_BUF, 16);	
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == ECB)&&(eDesCtrl.eEEEMode==EEE))
		Copy((u32)u_Tdes_CipherText[2], GOLDEN_BUF, 16);	
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == CBC)&&(eDesCtrl.eEEEMode==EEE))
		Copy((u32)u_Tdes_CipherText[3], GOLDEN_BUF, 16);	

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 16);
	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_CPU_ENC Success..\n");
		}
		else
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_CPU_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("DES_");
				DispOperMode();
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_CPU_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("DES_");
				DispOperMode();
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_CPU_ENC Success..\n");
			}
	}
	#endif
	
	/////////////////////////
	////// Decryption
	eDesCtrl.eDir   	= DEC;

	oSblk.m_eDir	=	eDesCtrl.eDir;
		
	SBLK_DESInit(eDesCtrl, u_Des_Key, u_Des_IV);	

	SBLK_PutDataToInReg(OUTPUT_BUF, 2);

	for(i=2; i<uTestLength;i+=2)
	{
			
		SBLK_PutDataToInReg(OUTPUT_BUF+i*4, 2);
		//SBLK_StartByManual();

		while(!SBLK_IsOutputReady());

		SBLK_GetDataFromOutReg(INPUT_BUF+(i-2)*4, 2);
		SBLK_ValidZero();

	}

	while(!SBLK_IsOutputReady());

	SBLK_GetDataFromOutReg(INPUT_BUF+(i-2)*4, 2);
	SBLK_ValidZero();

	Copy((u32)u_Des_PlainText, GOLDEN_BUF, 16);
	uRet = Compare(INPUT_BUF, GOLDEN_BUF, 16);
	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_CPU_DEC Success..\n\n");
		}
		else
		{
		UART_Printf("DES_");
		DispOperMode( );
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_CPU_DEC Failed..\n\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("DES_");
				DispOperMode( );
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_CPU_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("DES_");
				DispOperMode( );
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_CPU_DEC Success..\n");
			}
	}
	#endif
}

void Test_DES_DMA(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet, i, usel;
	u32 uTestLength;
	//u8 uError;
	//g_sblock_err=0;
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - DES DMA Mode Test]\n");

		UART_Printf("Select DES Operating Mode  : \n");
		UART_Printf(" 1)DES_ECB            2)DES_CBC  3)TDES(EDE)_ECB 4)TDES(EDE)_CBC    \n");
		UART_Printf(" 5)TDES(EEE)_ECB   6)TDES(EEE)_CBC  \n");
		usel=UART_GetIntNum();
		if (usel == 1) 
			{ eDesCtrl.eENG = DES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
		else if (usel == 2) 
			{ 
			   eDesCtrl.eENG = DES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
 		else if (usel == 3) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
 		else if (usel == 4) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EDE; 
			}
  		else if (usel == 5) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = ECB;			
			   eDesCtrl.eEEEMode	= EEE; 
			}		
  		 else if (usel == 6) 
			{ 
			   eDesCtrl.eENG = TDES;
			   eDesCtrl.eOperMode = CBC;			
			   eDesCtrl.eEEEMode	= EEE; 
			}
		UART_Printf("Select Byte Swap : 1)No Swap   2)Swap \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			eDesCtrl.eKEYSwap= SBLK_NoSwap;
			eDesCtrl.eIVSwap= SBLK_NoSwap;
			eDesCtrl.eDOSwap= SBLK_NoSwap;
			eDesCtrl.eDISwap= SBLK_NoSwap;
			eDesCtrl.eDMASwap= SBLK_NoSwap;
		}
		else if (usel == 2)
		{
			eDesCtrl.eKEYSwap= SBLK_Swap;
			eDesCtrl.eIVSwap= SBLK_Swap;
			eDesCtrl.eDOSwap= SBLK_Swap;
			eDesCtrl.eDISwap= SBLK_Swap;
			eDesCtrl.eDMASwap= SBLK_Swap;	
		}
  		 

	}
	else
	{
		eDesCtrl.eENG = (SBLK_TYPE)oAutoVar.Test_Parameter[0];
		eDesCtrl.eOperMode = (OPER_MODE)oAutoVar.Test_Parameter[1];
		if(eDesCtrl.eENG == DES) eDesCtrl.eEEEMode = EDE;
		else if (eDesCtrl.eENG == TDES)	
			eDesCtrl.eEEEMode = (OPER_MODE)oAutoVar.Test_Parameter[2];

		eDesCtrl.eKEYSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[3];
		eDesCtrl.eIVSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[4];
		eDesCtrl.eDOSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[5];
		eDesCtrl.eDISwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[6];
		eDesCtrl.eDMASwap= (SBLK_BSWAP)oAutoVar.Test_Parameter[7];
	}

	if(Sblock_INTMD)
	{
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		INTC_Enable(NUM_FEEDCTRL);
		SBLK_PendClearFeed(BTDMA);
		SBLK_EnDMAINT(BTDMA);
		g_SDma1Done =0;
	}
		
	//////////////////////////
	////// Encryption
	eDesCtrl.eFIFOMD   = SBLK_FIFO;
	eDesCtrl.eDir   	= ENC;
	uTestLength = 16;

	oSblk.m_eTestType	= eDesCtrl.eFIFOMD;
	oSblk.m_eDir	=	eDesCtrl.eDir;
	
	SBLK_DESInit(eDesCtrl, u_Des_Key, u_Des_IV);
	Copy((u32)u_Des_PlainText, INPUT_BUF, 16);

	SBLK_ClockOnOFF(g_SBLKTestOpt);
	SBLK_SetDMA(INPUT_BUF, 16, OUTPUT_BUF, 16);
	SBLK_PowerMode(g_SBLKTestOpt);
	//while(!g_SDma1Done);

	if ((eDesCtrl.eENG == DES)&&(eDesCtrl.eOperMode == ECB))
		Copy((u32)u_Des_CipherText[0], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == DES)&&(eDesCtrl.eOperMode == CBC))
		Copy((u32)u_Des_CipherText[1], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == ECB)&&(eDesCtrl.eEEEMode==EDE))
		Copy((u32)u_Tdes_CipherText[0], GOLDEN_BUF, 16);
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == CBC)&&(eDesCtrl.eEEEMode==EDE))
		Copy((u32)u_Tdes_CipherText[1], GOLDEN_BUF, 16);	
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == ECB)&&(eDesCtrl.eEEEMode==EEE))
		Copy((u32)u_Tdes_CipherText[2], GOLDEN_BUF, 16);	
	else if ((eDesCtrl.eENG == TDES)&&(eDesCtrl.eOperMode == CBC)&&(eDesCtrl.eEEEMode==EEE))
		Copy((u32)u_Tdes_CipherText[3], GOLDEN_BUF, 16);	

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 16);

	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_DMA_ENC Success..\n");
		}
		else
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_DMA_ENC Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("DES_");
				DispOperMode();
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_DMA_ENC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("DES_");
				DispOperMode();
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_DMA_ENC Success..\n");
			}
	}
	#endif
	
	/////////////////////////
	////// Decryption
	eDesCtrl.eDir   	= DEC;

	//g_SDma1Done =0;
	oSblk.m_eTestType	= eDesCtrl.eFIFOMD;
	oSblk.m_eDir	=	eDesCtrl.eDir;

	SBLK_DESInit(eDesCtrl, u_Des_Key, u_Des_IV);
	SBLK_ClockOnOFF(g_SBLKTestOpt);
	SBLK_SetDMA(OUTPUT_BUF, 16, INPUT_BUF, 16);
	SBLK_PowerMode(g_SBLKTestOpt);
	
	Copy((u32)u_Des_PlainText, GOLDEN_BUF, 16);
	uRet = Compare(INPUT_BUF, GOLDEN_BUF, 16);
	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("DES_");
		DispOperMode();
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_DMA_DEC Success..\n\n");
		}
		else
		{
		UART_Printf("DES_");
		DispOperMode( );
		UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
		UART_Printf("_DMA_DEC Failed..\n\n");
		}
	}
	else
	{
		if(uRet == false)
			{
				UART_Printf("DES_");
				DispOperMode( );
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_DMA_DEC Failed..\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
				UART_Printf("DES_");
				DispOperMode( );
				UART_Printf("[%d][%d][%d]_[%d][%d]", eDesCtrl.eENG, eDesCtrl.eOperMode, eDesCtrl.eEEEMode, eDesCtrl.eDISwap, eDesCtrl.eDMASwap);
				UART_Printf("_DMA_DEC Success..\n");
			}
	}
	#endif

	SBLK_DisDMAINT(BTDMA);
	INTC_Disable(NUM_FEEDCTRL); 
}


const u32 uSha1Temp[5*4*4];


void Test_HASH_CPUnDMA(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet, usel, uResult_length;

	//g_sblock_err=0;
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - HASH CPU Mode Test]\n");

		UART_Printf("Select HASH Operating Mode  : 1)SHA-1  2)MD5 \n");
		usel=UART_GetIntNum();

		if (usel == 1) eHashCtrl.eOperMode = SHA1_HASH;
		else if (usel == 2) eHashCtrl.eOperMode = MD5_HASH;

		UART_Printf("Select FIFO Mode  : 1)CPU  2)DMA \n");
		usel=UART_GetIntNum();

		if (usel == 1) eHashCtrl.eFIFOMD = SBLK_CPU;
		else if (usel == 2) eHashCtrl.eFIFOMD = 	SBLK_FIFO;

		UART_Printf("Select Byte Swap : 1)No Swap   2)Swap \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			eHashCtrl.eDOSwap= SBLK_NoSwap;
			eHashCtrl.eDISwap= SBLK_NoSwap;
			eHashCtrl.eDMASwap= SBLK_NoSwap;	
		}
		else if (usel == 2)
		{

			eHashCtrl.eDOSwap= SBLK_Swap;
			eHashCtrl.eDISwap= SBLK_Swap;
			eHashCtrl.eDMASwap= SBLK_Swap;
		}

	}
	else
	{
		eHashCtrl.eOperMode = (OPER_MODE)oAutoVar.Test_Parameter[0];
		eHashCtrl.eFIFOMD = (SBLK_FIFOMD)oAutoVar.Test_Parameter[1];

		eHashCtrl.eIVSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[2];
		eHashCtrl.eDOSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[3];
		eHashCtrl.eDISwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[4];
		eHashCtrl.eDMASwap= (SBLK_BSWAP)oAutoVar.Test_Parameter[5];	
	}

	//eHashCtrl.eFIFOMD     = SBLK_CPU;
	INTC_SetVectAddr(NUM_HASH, Isr_HASH);
	INTC_Enable(NUM_HASH);
	g_HASHDone =0;

	oSblk.m_eTestType	= eHashCtrl.eFIFOMD;
	

	// SBLK_RunHASH(HASHCtrl eHashCtrl,   u32 msg_size, u32 msg_addr, u32 result_addr)	
	SBLK_RunHASH(eHashCtrl,   64 , u_PlainText, OUTPUT_BUF);
	SBLK_ClockOnOFF(g_SBLKTestOpt);
	SBLK_PowerMode(g_SBLKTestOpt);
	
	if (eHashCtrl.eOperMode == SHA1_HASH)
	{
		Copy((u32)u_Sha1CipherText16, GOLDEN_BUF, 5);	
		uResult_length = 5;
	}
	else if (eHashCtrl.eOperMode == MD5_HASH)
	{
		Copy((u32)u_Md5CipherText16, GOLDEN_BUF, 4);
		uResult_length = 4;
	}

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, uResult_length);
	SBLK_ResultDisp(eTest, uRet);

	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("HASH_");
		DispOperMode();
		UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
		UART_Printf("_16 Success..\n");
		}
		else
		{
		UART_Printf("HASH_");
		DispOperMode();
		UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
		UART_Printf("_16 Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
			UART_Printf("HASH_");
			DispOperMode();
			UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
			UART_Printf("_16 Failed..\n");
			g_sblock_err =1;
			UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
			UART_Printf("HASH_");
			DispOperMode();
			UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
			UART_Printf("_16 Success..\n");
			}
	}
	#endif

	SBLK_RunHASH(eHashCtrl,   188 , u_PlainText, OUTPUT_BUF);	
	
	if (eHashCtrl.eOperMode == SHA1_HASH)
	{
		Copy((u32)u_Sha1CipherText47, GOLDEN_BUF, 5);	
		uResult_length = 5;
	}
	else if (eHashCtrl.eOperMode == MD5_HASH)
	{
		Copy((u32)u_Md5CipherText47, GOLDEN_BUF, 4);
		uResult_length = 4;
	}

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, uResult_length);
	 SBLK_ResultDisp(eTest, uRet);
	 #if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("HASH_");
		DispOperMode();
		UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
		UART_Printf("47 Success..\n");
		}
		else
		{
		UART_Printf("HASH_");
		DispOperMode();
		UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
		UART_Printf("47 Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
			UART_Printf("HASH_");
			DispOperMode();
			UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
			UART_Printf("47 Failed..\n");
			g_sblock_err =1;
			UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
			UART_Printf("HASH_");
			DispOperMode();
			UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
			UART_Printf("47 Success..\n");
			}
	}
	#endif

		INTC_Disable(NUM_HASH); 

}


void Test_HMAC_CPUnDMA(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet, usel, uResult_length;

	//g_sblock_err=0;
	
	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - HASH CPU Mode Test]\n");

		UART_Printf("Select HASH Operating Mode  : 1)SHA-1  2)MD5 \n");
		usel=UART_GetIntNum();

		if (usel == 1) eHashCtrl.eOperMode = SHA1_HMAC;
		else if (usel == 2) eHashCtrl.eOperMode = MD5_HMAC;

		UART_Printf("Select FIFO Mode  : 1)CPU  2)DMA \n");
		usel=UART_GetIntNum();

		if (usel == 1) eHashCtrl.eFIFOMD = SBLK_CPU;
		else if (usel == 2) eHashCtrl.eFIFOMD = 	SBLK_FIFO;

		UART_Printf("Select Byte Swap : 1)No Swap   2)Swap \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			eHashCtrl.eIVSwap= SBLK_NoSwap;
			eHashCtrl.eDOSwap= SBLK_NoSwap;
			eHashCtrl.eDISwap= SBLK_NoSwap;
			eHashCtrl.eDMASwap= SBLK_NoSwap;	
		}
		else if (usel == 2)
		{
			eHashCtrl.eIVSwap= SBLK_Swap;
			eHashCtrl.eDOSwap= SBLK_Swap;
			eHashCtrl.eDISwap= SBLK_Swap;
			eHashCtrl.eDMASwap= SBLK_Swap;
		}

	}
	else
	{
		eHashCtrl.eOperMode = (OPER_MODE)oAutoVar.Test_Parameter[0];
		eHashCtrl.eFIFOMD = (SBLK_FIFOMD)oAutoVar.Test_Parameter[1];

		eHashCtrl.eIVSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[2];
		eHashCtrl.eDOSwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[3];
		eHashCtrl.eDISwap     = (SBLK_BSWAP)oAutoVar.Test_Parameter[4];
		eHashCtrl.eDMASwap= (SBLK_BSWAP)oAutoVar.Test_Parameter[5];	
	}


	oSblk.m_eTestType	= eHashCtrl.eFIFOMD;

	//eHashCtrl.eFIFOMD     = SBLK_CPU;
	INTC_SetVectAddr(NUM_HASH, Isr_HASH);
	if(Sblock_INTMD)
		INTC_Enable(NUM_HASH);
	g_HASHDone =0;

	#if 0
	if(eHashCtrl.eFIFOMD == 	SBLK_FIFO)
		{
		INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
		if(Sblock_INTMD)
			INTC_Enable(NUM_FEEDCTRL);
		Outp32(0xEA00000C, HRDMA_INT_BIT);
		SBLK_EnDMAINT(HRDMA);
		g_SDma1Done =0;
		}
	#endif
	//SBLK_RunHMAC(HASHCtrl eHashCtrl, u32 msg_size,   u32 *hmac_key, u32 *msg_addr, u32 result_addr )	
	SBLK_RunHMAC(eHashCtrl,   73 , u_HmacKey, u_HmacPlainText19, OUTPUT_BUF);	
	SBLK_ClockOnOFF(g_SBLKTestOpt);
	SBLK_PowerMode(g_SBLKTestOpt);
	
	if (eHashCtrl.eOperMode == SHA1_HMAC)
	{
		Copy((u32)u_Sha1HmacCipherText19, GOLDEN_BUF, 5);	
		uResult_length = 5;
	}
	else if (eHashCtrl.eOperMode == MD5_HMAC)
	{
		Copy((u32)u_Md5HmacCipherText19, GOLDEN_BUF, 4);
		uResult_length = 4;
	}

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, uResult_length);
	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("HMAC_");
		DispOperMode();
		UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
		UART_Printf("_19 Success..\n");
		}
		else
		{
		UART_Printf("HMAC_");
		DispOperMode();
		UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
		UART_Printf("_19 Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
			UART_Printf("HMAC_");
			DispOperMode();
			UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
			UART_Printf("_19 Failed..\n");
			g_sblock_err =1;
			UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
			UART_Printf("HMAC_");
			DispOperMode();
			UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
			UART_Printf("_19 Success..\n");
			}
	}
	#endif 
	SBLK_RunHMAC(eHashCtrl,   188 , u_HmacKey, u_PlainText, OUTPUT_BUF);
	
	if (eHashCtrl.eOperMode == SHA1_HMAC)
	{
		Copy((u32)u_Sha1HmacCipherText47, GOLDEN_BUF, 5);	
		uResult_length = 5;
	}
	else if (eHashCtrl.eOperMode == MD5_HMAC)
	{
		Copy((u32)u_Md5HmacCipherText47, GOLDEN_BUF, 4);
		uResult_length = 4;
	}

	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, uResult_length);
	SBLK_ResultDisp(eTest, uRet);
	#if 0
	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("HMAC_");
		DispOperMode();
		UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
		UART_Printf("47 Success..\n");
		}
		else
		{
		UART_Printf("HMAC_");
		DispOperMode();
		UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
		UART_Printf("47 Failed..\n");
		}
	}
	else
	{
		if(uRet == false)
			{
			UART_Printf("HMAC_");
			DispOperMode();
			UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
			UART_Printf("47 Failed..\n");
			g_sblock_err =1;
			UART_Getc();
			}
		else if (Sblock_DEBUG)
			{
			UART_Printf("HMAC_");
			DispOperMode();
			UART_Printf("[%d][%]_[%d][%d]", eHashCtrl.eOperMode, eHashCtrl.eFIFOMD, eHashCtrl.eDISwap, eHashCtrl.eDMASwap);
			UART_Printf("47 Success..\n");
			}
	}
	#endif
		SBLK_DisDMAINT(HRDMA);
		INTC_Disable(NUM_HASH); 
		INTC_Disable(NUM_FEEDCTRL); 

}


u8 Compare_PRNG( u32 a0,  u32 uPattern)
{
	volatile u32 d0;
	volatile u32 *pD0, *pD1;
	u8 ret = true;
	u32  ecnt = 0;
	u32 i,j;
	u32 aResult[5];
	
	pD0 = (volatile u32 *)(a0);

	Copy(a0, (u32)aResult, 5);
	
	for(i=0; i<5; i++)
	for(j=0; j<5 ;j++)
	{
		if(i != j)	
		{
			if(aResult[i] == aResult[j])
				{
				UART_Printf("[%d][%d] = %08x\n", i,j, aResult[i]);
				ret = false;
				ecnt++;
				}
		}	
	}

	for(i=0;i<5;i++)
	{
		if(aResult[i] == uPattern)
		{
			UART_Printf("[%d] = %08x\n", i, aResult[i]);
			ret = false;
			ecnt++;
		}
	}
		
	return ret;
}


void Test_PRNG(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet, i,j;
	volatile u32 *Data, *Data_Base;
	u32 utest_time=1000;

	Data_Base = (u32 *)malloc(0x14);

	INTC_SetVectAddr(NUM_HASH, Isr_HASH);
	INTC_Enable(NUM_HASH);
	g_HASHDone =0;

	SBLK_GetPRNG(u_PrngSeed, (u32 *)OUTPUT_BUF);
	
	uRet = Compare_PRNG(OUTPUT_BUF, 0x0);

	if(eTest == eTest_Manual)
	{
		Dump32(OUTPUT_BUF, 5);
		if(uRet == false)UART_Printf("PRNG Fail\n");
		else UART_Printf("PRNG Success\n");
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
					UART_Printf("PRNG Fail\n");
				g_sblock_err =1;
				UART_Getc();
			}
		else if (SBLK_DEBMSG)
			{
				UART_Printf("PRNG Success\n");
				
			}
		
	}

	g_Sblock_DEBUG=0;
	
	for(j=0;j<utest_time;j++)
	{

		Data = Data_Base;

		for(i=0 ; i<5; i++)
		{
 			*Data = rand();
 			Data++;
		}

		SBLK_GetPRNG(Data, (u32 *)OUTPUT_BUF);
		uRet = Compare_PRNG(OUTPUT_BUF, 0x0);

		if(eTest == eTest_Manual)
		{
			//Dump32(OUTPUT_BUF, 10);
			if(uRet == false)UART_Printf("PRNG (Random Seed)Fail\n");
			else  UART_Printf("PRNG (Random Seed) Success\n");

		}
		else
		{
			if(uRet == false)
			{
				if(SBLK_DEBMSG)
					UART_Printf("PRNG(Random Seed) Fail\n");
				g_sblock_err =1;
				UART_Getc();
			}
			else if (g_Sblock_DEBUG)
			{
				UART_Printf("PRNG(Random Seed) Success\n");
				g_sblock_err =0;
			}
		
		}	
	}
	g_Sblock_DEBUG=1;
	free((void *)Data_Base);	
	INTC_Disable(NUM_HASH);

}

void Test_HASH_LastByte(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet, uLASTBYTE,uRep, i;
	

	eHashCtrl.eFIFOMD     = SBLK_CPU;
	eHashCtrl.eOperMode  = SHA1_HASH;
	eHashCtrl.eDOSwap	= SBLK_Swap;
	eHashCtrl.eDISwap	= SBLK_Swap;
	eHashCtrl.eDMASwap	= SBLK_NoSwap;
	
	
	INTC_SetVectAddr(NUM_HASH, Isr_HASH);
	INTC_Enable(NUM_HASH);
	g_HASHDone =0;

   for(i=1;i<16;i++)
   {
	for(uRep=0;uRep<4;uRep++)
	{
	
		SBLK_RunHASH(eHashCtrl,   (i-1)*4+uRep+1 , u_PlainText, OUTPUT_BUF1 );	
		Copy(OUTPUT_BUF1, OUTPUT_BUF+(uRep*5)*4, 5);
	}

				
		switch(i)
		{
			case 1: 
				Copy((u32)uSha1CipherText1, GOLDEN_BUF, 5*4);
			     	break;           
			case 2: 
				Copy((u32)uSha1CipherText2, GOLDEN_BUF, 5*4);
			     	break;     
			case 3: 
				Copy((u32)uSha1CipherText3, GOLDEN_BUF, 5*4);
			     	break;        
			case 4: 
				Copy((u32)uSha1CipherText4, GOLDEN_BUF, 5*4);
			     	break;   	     	
			case 5: 
				Copy((u32)uSha1CipherText5, GOLDEN_BUF, 5*4);
			     	break;   	     	
			case 6: 
				Copy((u32)uSha1CipherText6, GOLDEN_BUF, 5*4);
			     	break;   	      	
			case 7: 
				Copy((u32)uSha1CipherText7, GOLDEN_BUF, 5*4);
			     	break;   	       	
			case 8: 
				Copy((u32)uSha1CipherText8, GOLDEN_BUF, 5*4);
			     	break;   	   
			case 9: 
				Copy((u32)uSha1CipherText9, GOLDEN_BUF, 5*4);
			     	break;   	   	     	
			case 10: 
				Copy((u32)uSha1CipherText10, GOLDEN_BUF, 5*4);
			     	break;
			case 11: 
				Copy((u32)uSha1CipherText11, GOLDEN_BUF, 5*4);
			     	break;
 			case 12: 
				Copy((u32)uSha1CipherText12, GOLDEN_BUF, 5*4);
			     	break;    	
			case 13: 
				Copy((u32)uSha1CipherText13, GOLDEN_BUF, 5*4);
			     	break;     	
			case 14: 
				Copy((u32)uSha1CipherText14, GOLDEN_BUF, 5*4);
			     	break;
			case 15: 
				Copy((u32)uSha1CipherText15, GOLDEN_BUF, 5*4);
				break;     	
			     	
		}

	
	uRet = Compare(OUTPUT_BUF, GOLDEN_BUF, 5*4);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("HASH_SHA1_CPU %d,  Success \n", i);
		}
		else
		{
		UART_Printf("HASH_SHA1_CPU %d,  Failed \n", i );
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
					UART_Printf("HASH_SHA1_CPU %d,  Failed \n", i );
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("HASH_SHA1_CPU %d,  Sucess \n", i );
	
		}	

	}

  }



   
	INTC_Disable(NUM_HASH);
}

//------------------------------------------------------------
// partial result test:
//         Total: 4 tests
//         multi-part hash: sha1, md5
//         multi-part HMAC: sha1, md5
//------------------------------------------------------------
void SBLKT_HASH_partial(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	u32 uRet;
	// 1 sha1/188
	
	SBLK_DoPartial_Hash(ALG_SHA1, u_PlainText, 188);
	uRet = Compare(OUTPUT_BUF,  (u32)u_Sha1CipherText47, 5);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("do_partial_hash/sha1/188:  Success \n");
		}
		else
		{
		UART_Printf("do_partial_hash/sha1/188:  Failed \n" );
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
					UART_Printf("do_partial_hash/sha1/188:  Failed \n");
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("do_partial_hash/sha1/188:  Success \n");
	
		}		
	}

	// 2 md5/188
	SBLK_DoPartial_Hash(ALG_MD5, u_PlainText, 188);
	uRet = Compare(OUTPUT_BUF,  (u32)u_Md5CipherText47, 4);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("do_partial_hash/md5/188:  Success \n");
		}
		else
		{
		UART_Printf("do_partial_hash/md5/188:  Failed \n");
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
				UART_Printf("do_partial_hash/md5/188:  Failed \n");
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("do_partial_hash/md5/188:  Success \n");
		
		}			
	}

    // 3
	SBLK_DoPartial_Hmac(ALG_SHA1, 73, 64, u_HmacPlainText19, u_HmacKey);
 	uRet = Compare(OUTPUT_BUF,  (u32)u_Sha1HmacCipherText19, 5);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("do_partial_hmac/sha1/64/73:  Success \n");
		}
		else
		{
		UART_Printf("do_partial_hmac/sha1/64/73:  Failed \n" );
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
				UART_Printf("do_partial_hmac/sha1/64/73:  Failed \n" );
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("do_partial_hmac/sha1/64/73:  Success \n");
		
		}				
	}   
    
    // 4
	SBLK_DoPartial_Hmac(ALG_MD5, 73, 64, u_HmacPlainText19, u_HmacKey);
  	uRet = Compare(OUTPUT_BUF,  (u32)u_Md5HmacCipherText19, 4);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("do_partial_hmac/md5/64/73  Success \n");
		}
		else
		{
		UART_Printf("do_partial_hmac/md5/64/73  Failed \n");
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
				UART_Printf("do_partial_hmac/md5/64/73  Failed \n" );
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("do_partial_hmac/md5/64/73  Success \n");
		
		}		
	}   
    
}

void SBLKT_HASH_adv(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
    u32 plain1[40];
    u32 plain2[40];
    u32 cipher[40];
    u32 hash_result1[5];
    u32 hash_result2[5];
    u32 uRet;
    u32 usel, usel1;
    OPER_MODE eHashALG;
    //ALG_TYPE eHashALG;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - HASH Advanced Function Test]\n");

		UART_Printf("Select HASH Operating Mode  : 1)SHA-1  2)MD5 \n");
		usel=UART_GetIntNum();

		if (usel == 1) eHashALG = SHA1_HASH;
		else if (usel == 2) eHashALG = MD5_HASH;

		UART_Printf("Select Block Chipher Engine : 1)AES   2)DES  3)TDES  \n");
		usel=UART_GetIntNum();
		if (usel == 1)
		{	
			oSblk.m_eSblkType= AES;
			UART_Printf("Select Operation Mode for AES : 1)ECB   2)CBC  3)CTR  \n");
			usel1=UART_GetIntNum();

			if(usel1 == 1)	oSblk.m_eOperMode = ECB;
			else if(usel1 == 2) oSblk.m_eOperMode = CBC;
			else if(usel1 == 3) oSblk.m_eOperMode = CTR;
	
		}
		else if (usel == 2)
		{
			oSblk.m_eSblkType= DES;
			UART_Printf("Select Operation Mode for DES : 1)ECB   2)CBC   \n");
			usel1=UART_GetIntNum();

			if(usel1 == 1)	oSblk.m_eOperMode = ECB;
			else if(usel1 == 2) oSblk.m_eOperMode = CBC;

		}
		else if (usel == 3)
		{
			oSblk.m_eSblkType= TDES;

			UART_Printf("Select Operation Mode for TDES : 1)ECB(EDE)   2)ECB(EEE) 3)CBC(EDE) 4)CBC(EEE)   \n");
			usel1=UART_GetIntNum();

			if(usel1 == 1)	{oSblk.m_eOperMode = ECB; oSblk.m_eOperMode1 = EDE;}
			else if(usel1 == 2){oSblk.m_eOperMode = ECB; oSblk.m_eOperMode1 = EEE;}
			else if(usel1 == 3) {oSblk.m_eOperMode = CBC; oSblk.m_eOperMode1 = EDE;}
			else if(usel1 == 4) {oSblk.m_eOperMode = CBC; oSblk.m_eOperMode1 = EEE;}			
		}
		
		UART_Printf("Select Direction  : 1)ENC  2)DEC \n");
		usel=UART_GetIntNum();

		if (usel == 1) oSblk.m_eDir = ENC;
		else if (usel == 2) oSblk.m_eDir = DEC;
	}
	else
	{
		eHashALG			= (ALG_TYPE)oAutoVar.Test_Parameter[0];	// 2 type
		oSblk.m_eSblkType	= (SBLK_TYPE)oAutoVar.Test_Parameter[1];	// 3 type
		oSblk.m_eOperMode 	= (OPER_MODE)oAutoVar.Test_Parameter[2];	
		oSblk.m_eOperMode1	= (OPER_MODE)oAutoVar.Test_Parameter[3];	
		oSblk.m_eDir			= (DIR_SEL)oAutoVar.Test_Parameter[4];

	}

  
    Copy((u32)uAdvCasePlainText, INPUT_BUF, 40);
    
    // 1
	SBLK_DoConcur_HashnCipher(oSblk, eHashALG, (u32 *)INPUT_BUF, cipher, (u32 *)OUTPUT_BUF, 160);
	if(oSblk.m_eDir == ENC) oSblk.m_eDir = DEC;
	else oSblk.m_eDir = ENC;
	SBLK_DoSeri_HashnCipher(oSblk, eHashALG, cipher, plain2, (u32 *)OUTPUT_BUF1, 160);

	if(eHashALG == SHA1_HASH)
		uRet = Compare((u32)OUTPUT_BUF, (u32)OUTPUT_BUF1, 5);
	else if (eHashALG == MD5_HASH)
		uRet = Compare((u32)OUTPUT_BUF, (u32)OUTPUT_BUF1, 4);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("HASH_adv/Block[%d][%d][%d]_[%d]+HASH[%d]:  Success \n",oSblk.m_eSblkType, oSblk.m_eOperMode, oSblk.m_eOperMode1, oSblk.m_eDir,eHashALG  );
		}
		else
		{
		UART_Printf("HASH_adv/Block[%d][%d][%d]_[%d]+HASH[%d]:  Failed \n",oSblk.m_eSblkType, oSblk.m_eOperMode, oSblk.m_eOperMode1, oSblk.m_eDir,eHashALG  );
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
				UART_Printf("HASH_adv/Block[%d][%d][%d]_[%d]+HASH[%d]:  Failed \n",oSblk.m_eSblkType, oSblk.m_eOperMode, oSblk.m_eOperMode1, oSblk.m_eDir,eHashALG  );
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("HASH_adv/Block[%d][%d][%d]_[%d]+HASH[%d]:  Success \n",oSblk.m_eSblkType, oSblk.m_eOperMode, oSblk.m_eOperMode1, oSblk.m_eDir,eHashALG  );
		
		}				
	}   

        
  
    
}


void SBLKT_HASH_adv_Temp(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
    u32 plain1[40];
    u32 plain2[40];
    u32 cipher[40];
    u32 hash_result1[5];
    u32 hash_result2[5];
    u32 uRet;
    u32 usel, usel1;
    OPER_MODE eHashALG;

	
	eHashALG = SHA1_HASH;
	oSblk.m_eSblkType = AES;
	oSblk.m_eOperMode = CBC;
	oSblk.m_eDir = ENC;
  
    Copy((u32)u_Aes_PlainText, INPUT_BUF, 16);
    
    // 1
	SBLK_DoConcur_HashnCipher(oSblk, eHashALG, (u32 *)INPUT_BUF, (u32 *)MID_BUF, (u32 *)OUTPUT_BUF, 64);
	if(oSblk.m_eDir == ENC) oSblk.m_eDir = DEC;
	else oSblk.m_eDir = ENC;
	SBLK_DoSeri_HashnCipher(oSblk, eHashALG, (u32 *)MID_BUF, plain2, (u32 *)OUTPUT_BUF1, 64);

	uRet = Compare((u32)OUTPUT_BUF1, (u32)OUTPUT_BUF, 5);

	SBLK_AES(AES_ENC|AES_CBC|AES_CPU|AES_256|AES_nCHANGE|AES_SWAP, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter,
			(u32 *)INPUT_BUF, (u32 *)OUTPUT_BUF1, u_Aes_CipherText[2][1], 16);
	SBLK_AES(AES_ENC|AES_CBC|AES_DMA|AES_256|AES_nCHANGE|AES_SWAP, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter,
			(u32 *)INPUT_BUF, (u32 *)OUTPUT_BUF1, u_Aes_CipherText[2][1], 16);
	
	uRet = Compare((u32)OUTPUT_BUF1, (u32)MID_BUF, 16);


	   

        
  
    
}



#if 0		// first&2nd test
//----------------------------------------------------------
// Advanced cases test
// case 1 + case 2 together.
//----------------------------------------------------------
void SBLKT_HASH_adv(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
    u32 plain1[40];
    u32 plain2[40];
    u32 cipher[40];
    u32 hash_result1[5];
    u32 hash_result2[5];
    u32 uRet;
    
    Copy((u32)uAdvCasePlainText, (u32)plain1, 40);
    
    // 1
    SBLK_DoConcur_HashnCipher(DES, ALG_SHA1, plain1, cipher, hash_result1, 160);
    SBLK_DoSeri_HashnCipher(DES, ALG_SHA1, cipher, plain2, hash_result2, 160);

   uRet = Compare((u32)hash_result1, (u32)hash_result2, 5);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("Test_HASH_adv/DES+SHA1:  Success \n");
		}
		else
		{
		UART_Printf("Test_HASH_adv/DES+SHA1:  Failed \n" );
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
				UART_Printf("Test_HASH_adv/DES+SHA1:  Failed \n" );
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("Test_HASH_adv/DES+SHA1:  Success \n");
		
		}				
	}   

        
    // 2
    SBLK_DoConcur_HashnCipher(DES, ALG_MD5, plain1, cipher, hash_result1, 160);
    SBLK_DoSeri_HashnCipher(DES, ALG_MD5, cipher, plain2, hash_result2, 160);
    
   uRet = Compare((u32)hash_result1, (u32)hash_result2,4);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("Test_HASH_adv/DES+MD5:  Success \n");
		}
		else
		{
		UART_Printf("Test_HASH_adv/DES+MD5:  Failed \n");
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
				UART_Printf("Test_HASH_adv/DES+MD5:  Failed \n" );
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("Test_HASH_adv/DES+MD5:  Success \n");
	
		}			
	}   

   // 3
    SBLK_DoConcur_HashnCipher(AES, ALG_SHA1, plain1, cipher, hash_result1, 160);
    SBLK_DoSeri_HashnCipher(AES, ALG_SHA1, cipher, plain2, hash_result2, 160);

   uRet = Compare((u32)hash_result1, (u32)hash_result2, 5);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("Test_HASH_adv/AES+SHA1:  Success \n");
		}
		else
		{
		UART_Printf("Test_HASH_adv/AES+SHA1:  Failed \n" );
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
				UART_Printf("Test_HASH_adv/AES+SHA1:  Failed \n" );
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("Test_HASH_adv/AES+SHA1:  Success \n");
		
		}				
	}   

        
    // 4
    SBLK_DoConcur_HashnCipher(AES, ALG_MD5, plain1, cipher, hash_result1, 160);
    SBLK_DoSeri_HashnCipher(AES, ALG_MD5, cipher, plain2, hash_result2, 160);
    
   uRet = Compare((u32)hash_result1, (u32)hash_result2,4);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("Test_HASH_adv/AES+MD5:  Success \n");
		}
		else
		{
		UART_Printf("Test_HASH_adv/AES+MD5:  Failed \n");
		}
	}
	else
	{
		if(uRet == false)
			{
				if(SBLK_DEBMSG)
				UART_Printf("Test_HASH_adv/AES+MD5:  Failed \n" );
				g_sblock_err =1;
				UART_Getc();
			}
	     else if (SBLK_DEBMSG)
		{
		UART_Printf("Test_HASH_adv/AES+MD5:  Success \n");
	
		}			
	}   
    
}
#endif

void SBLKT_PKA_SRAM(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	// Test Size : 0x800
	volatile u32 *Pt_Base, *Pt;
	volatile u32 *Data_Base, *Data, *Read_Data, *Read_Data_Base;
	u32 i, test_size;
	u32 uErr=0;
	u32 uRet;

	test_size = 0x800;
	
	Pt_Base=(unsigned int *)(0xEA008000);
	Data_Base = (u32 *)malloc(0x800);
	Read_Data_Base = (u32 *)malloc(0x800);

	Data = Data_Base;
	Read_Data = Read_Data_Base;

	for(i=0 ; i<test_size/4 ; i++)
		{
 				*Data = rand();
 				Data++;
		}

		Data = Data_Base;
		Pt=Pt_Base;
	       // (dst, source, size)
		memcpy((void *)Pt, (void *)Data, test_size);
		
		Data = Data_Base;
		Pt= Pt_Base;
		Read_Data = Read_Data_Base;

		memcpy((void *)Read_Data, (void *)Pt, test_size);

		#if 0
		for(i=0 ; i<test_size/4 ; i++)
		{
			if(*Read_Data != *Data)
			{
				UART_Printf("Error [Addr : 0x%08x] [Data-2 : 0x%08x, Data-1 : 0x%08x, Data : 0x%08x, Data+1 : 0x%08x, RData : 0x%08x]\n", Pt, *(Data-2), *(Data-1), *(Data), *(Data+1), *Read_Data);
				UART_Printf("[Previous Data : 0x%02x, WData : 0x%02x, RData : 0x%02x]\n", (*(Data-2)&0xff000000)>>24, (*Data&0xff000000)>>24, (*Read_Data&0xff000000)>>24);
				UART_Getc();
				uErr++;
			}
			Read_Data++;
			Data++;
			Pt++;
		}
		if(uErr==0) UART_Printf("PKA SRAM Random R/W Test PASS\n\n");
		#endif
	uRet = Compare((u32)Read_Data_Base, (u32)Data_Base, test_size/4);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("PKA SRAM Random R/W Test PASS \n");
		}
		else
		{
		UART_Printf("PKA SRAM Random R/W Test failed \n" );
		}
	}
	else
	{
		if (uRet)
		{
			if(SBLK_DEBMSG)
				UART_Printf("PKA SRAM Random R/W Test PASS \n");
		}
		else
		{
			if(SBLK_DEBMSG)
			UART_Printf("PKA SRAM Random R/W Test failed \n" );
			g_sblock_err =1;
			UART_Getc();
		}
	}

	free((void *)Data_Base);	
	free((void *)Read_Data_Base);	

}


void SBLKT_PKA_CPU(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{

    u32 uRet;

   SBLK_InitPKA_(SEG_FULL, 512, PREC_QUADRUPLE);
   //Compare_SEGID(SEG_FULL);
   g_SEGSUM = 1;

   while(g_SEGSUM >0 )
   {
    Select_SEGID(SEG_FULL);
    
    SBLK_PutPKA_CPU_(buf_a, g_SEG_A_ID);
    SBLK_PutPKA_CPU_(buf_b, g_SEG_B_ID);
    SBLK_PutPKA_CPU_(buf_m, g_SEG_M_ID);

    SBLK_PKA_(g_SEG_A_ID, g_SEG_B_ID, g_SEG_M_ID, g_SEG_S_ID, 0);

    SBLK_GetPKA_CPU_((u32 *)OUTPUT_BUF, g_SEG_S_ID, g_SEG_M_ID);

	uRet = Compare(OUTPUT_BUF, (u32)gold_s, 64);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("PKA CPU(SEG_FULL) : Sucess \n");
		}
		else
		{
		UART_Printf("PKA CPU(SEG_FULL) failed \n" );
		}
	}
	else
	{
		if (uRet)
		{
			if(SBLK_DEBMSG)
				UART_Printf("PKA CPU(SEG_FULL): Success \n");
		}
		else
		{
			if(SBLK_DEBMSG)
			UART_Printf("PKA CPU(SEG_FULL):  failed \n" );
			g_sblock_err =1;
			UART_Getc();
		}
	}

	SBLK_ClrSegmentPKA();
SBLK_ClrSfrPKA();		

  Compare_SEGID(SEG_FULL);

   }
   Return_SEGID();
 
}

void SBLKT_PKA_DMA(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
    u32 uRet;
    int a_id = 3;
    int b_id = 5;
    int m_id = 6;
    int s_id = 1;
    

    SBLK_InitPKA_(SEG_FULL, 512, PREC_QUADRUPLE);

   Copy((u32)buf_a, INPUT_BUF, 128);
   Copy((u32)buf_b, OUTPUT_BUF, 128);
   Copy((u32)buf_m, GOLDEN_BUF, 128);
    SBLK_PutPKA_((u32 *)INPUT_BUF, a_id);
    SBLK_PutPKA_((u32 *)OUTPUT_BUF, b_id);
    SBLK_PutPKA_((u32 *)GOLDEN_BUF, m_id);

    SBLK_PKA_(a_id, b_id, m_id, s_id, 0);
    SBLK_GetPKA_((u32 *)GOLDEN_BUF1, s_id, m_id);
    
#if 0
    SBLK_PutPKA(buf_a, a_id);
    SBLK_PutPKA(buf_b, b_id);
    SBLK_PutPKA(buf_m, m_id);
    SBLK_PKA(a_id, b_id, m_id, s_id, 0);
    SBLK_GetPKA(buf_s, s_id, (int)buf_m);
#endif

	uRet = Compare(GOLDEN_BUF1, (u32)gold_s, 64);

	if(eTest == eTest_Manual)
	{
		if (uRet)
		{
		UART_Printf("PKA DMA(SEG_FULL) : Sucess \n");
		}
		else
		{
		UART_Printf("PKA DMA(SEG_FULL) failed \n" );
		}
	}
	else
	{
		if (uRet)
		{
			if(SBLK_DEBMSG)
				UART_Printf("PKA DMA(SEG_FULL): Success \n");
		}
		else
		{
			if(SBLK_DEBMSG)
			UART_Printf("PKA DMA(SEG_FULL):  failed \n" );
			g_sblock_err =1;
			UART_Getc();
		}
	}
}




void SBLKT_PKA_SEG(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	
    	u32 uRet;
	u32 usel;
	u32 w_cnt=0, old_w_cnt=0;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - PKA Simple Test & SEG ID Operation Check]\n");

		UART_Printf("Select PKA CPU or DMA Select  : 1)CPU   2)DMA  \n");
		usel=UART_GetIntNum();
		if (usel == 1) ePKACtrl.eFIFOMD = SBLK_CPU;
		else if (usel == 2) ePKACtrl.eFIFOMD = SBLK_FIFO;
		
	}
	else
	{
		ePKACtrl.eFIFOMD = (SBLK_FIFOMD)oAutoVar.Test_Parameter[0];
				
	}

	// Set-up condition
	ePKACtrl.ePREC 		= PKA_SINGLE;
	ePKACtrl.eCHUNKSZ	= PKA_128b;
	ePKACtrl.eSEGSZ		= PKA_QUARTER;
	ePKACtrl.ePKAFUNC	= PKA_MulAXB;
	ePKACtrl.ePLDM		= PKA_PLDMON;
	ePKACtrl.uSIGN		= 0x0;	

		Compare_SEGID(SEG_QUARTER);
		while(g_SEGSUM >0)
		{
			Select_SEGID(SEG_QUARTER);
			ePKACtrl.uSEGID_A = g_SEG_A_ID;
			ePKACtrl.uSEGID_B = g_SEG_B_ID;
			ePKACtrl.uSEGID_M = g_SEG_M_ID;
			ePKACtrl.uSEGID_S = g_SEG_S_ID;
			
			SBLK_InitPKA(ePKACtrl);

			if(ePKACtrl.eFIFOMD == SBLK_FIFO)
			{
				if(Sblock_INTMD)
				{
					INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
					INTC_Enable(NUM_FEEDCTRL);
					SBLK_PendClearFeed(PKDMA);
					SBLK_EnDMAINT(PKDMA);
					g_SDma1Done =0;
				}
			}

			SBLK_LoadDataPKA(ePKACtrl, buf_a_128, buf_b_128, buf_m_128,  &w_cnt, old_w_cnt);
			SBLK_RunPKA();
			SBLK_NegPosPKA(g_SEG_S_ID,  g_SEG_M_ID);
			if(ePKACtrl.eFIFOMD == SBLK_CPU)
				SBLK_GetPKA((u32 *)OUTPUT_BUF, g_SEG_S_ID);
			else if (ePKACtrl.eFIFOMD == SBLK_FIFO)
				SBLK_GetPKADMA((u32 *)OUTPUT_BUF, g_SEG_S_ID);
		
			uRet = Compare(OUTPUT_BUF, (u32)gold_s_128, 4); 

			if(eTest == eTest_Manual)
			{
				if (uRet)
				{
					UART_Printf("PKA [%d](SEG_ID) : Sucess \n", ePKACtrl.eFIFOMD);
				}
				else
				{
					UART_Printf("PKA [%d](SEG_ID) failed \n" , ePKACtrl.eFIFOMD);
				}
			}
			else
			{
				if (uRet)
				{
					if(SBLK_DEBMSG)
						UART_Printf("PKA [%d](SEG_ID): Success \n",ePKACtrl.eFIFOMD);
				}
				else
				{
					if(SBLK_DEBMSG)
					UART_Printf("PKA [%d](SEG_ID):  failed \n",ePKACtrl.eFIFOMD );
					g_sblock_err =1;
					UART_Getc();
				}
			}
			Compare_SEGID(SEG_QUARTER);
			
		}
		 Return_SEGID();


 
}


void SBLKT_PKA_AXB(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	
    	u32 uRet, i;
	u32 usel;
	u32 w_cnt=0, old_w_cnt=0;
	u32 c_cnt=0;
	// Test Case : ePREC, eCHUNKSZ, PLDM, SEGIDx4, SEGSIGN, SEGSZ
	u32 aCaseOfTest[][9] = { {PKA_SINGLE, PKA_128b, PKA_PLDMON, 0, 1,2,3, 0x00000000, PKA_QUARTER},
						     {PKA_SINGLE, PKA_512b, PKA_PLDMON, 24,25,26,27, 0x03000000, PKA_QUARTER},
					            {PKA_DOUBLE, PKA_416b, PKA_PLDMON, 5,6,7,8, 0x00000020, PKA_HALF},
						     {PKA_DOUBLE, PKA_512b, PKA_PLDMON, 10,11,12,13, 0x00000000, PKA_HALF},
						     {PKA_DOUBLE, PKA_512b, PKA_PLDMOFF, 2,3,4,5, 0x00000000, PKA_HALF},
		                                 {PKA_TRIPLE, PKA_288b, PKA_PLDMON, 1,2,3,4, 0x00000004, PKA_HALF},
						     {PKA_TRIPLE, PKA_512b, PKA_PLDMON, 0,1,2,3, 0x00000000, PKA_FULL},
						     {PKA_QUAD, PKA_352b, PKA_PLDMON, 2,3,4,5, 0x0000000C, PKA_FULL},
		                                 {PKA_QUAD, PKA_512b, PKA_PLDMON, 4,5,1,2, 0x00000010, PKA_FULL},
		                                 {PKA_QUAD, PKA_512b, PKA_PLDMOFF, 5,0,1,3, 0x00000001, PKA_FULL}
	                                      };	
	u32 counter = 10;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - PKA AXB Montgomery  Operation Check]\n");

		UART_Printf("Select PKA CPU or DMA Select  : 1)CPU   2)DMA  \n");
		usel=UART_GetIntNum();
		if (usel == 1) ePKACtrl.eFIFOMD = SBLK_CPU;
		else if (usel == 2) ePKACtrl.eFIFOMD = SBLK_FIFO;
		
	}
	else
	{
		ePKACtrl.eFIFOMD = (SBLK_FIFOMD)oAutoVar.Test_Parameter[0];
				
	}

	for(i=0; i<counter; i++)
	{
			// Set-up condition
			ePKACtrl.ePKAFUNC	= PKA_MulAXB;
			ePKACtrl.ePREC 		= aCaseOfTest[i][0];
			ePKACtrl.eCHUNKSZ	= aCaseOfTest[i][1];
			ePKACtrl.ePLDM		= aCaseOfTest[i][2];
			ePKACtrl.uSEGID_A 	= aCaseOfTest[i][3];
			ePKACtrl.uSEGID_B 	= aCaseOfTest[i][4];
			ePKACtrl.uSEGID_M 	= aCaseOfTest[i][5];
			ePKACtrl.uSEGID_S 	= aCaseOfTest[i][6];
			ePKACtrl.uSIGN		= aCaseOfTest[i][7];	
			ePKACtrl.eSEGSZ		= aCaseOfTest[i][8];	
			
			SBLK_InitPKA(ePKACtrl);

			if(ePKACtrl.eFIFOMD == SBLK_FIFO)
			{
				if(Sblock_INTMD)
				{
					INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
					INTC_Enable(NUM_FEEDCTRL);
					SBLK_PendClearFeed(PKDMA);
					SBLK_EnDMAINT(PKDMA);
					g_SDma1Done =0;
				}
			}

			
	
			SBLK_LoadDataPKA(ePKACtrl,(u32 *)&p_AB_a[old_w_cnt], (u32 *)&p_AB_b[old_w_cnt], (u32 *)&p_AB_m[old_w_cnt],  &w_cnt, old_w_cnt);
			SBLK_RunPKA();
			SBLK_NegPosPKA(ePKACtrl.uSEGID_S,  ePKACtrl.uSEGID_M);
			if(ePKACtrl.eFIFOMD == SBLK_CPU)
				SBLK_GetPKA((u32 *)OUTPUT_BUF, ePKACtrl.uSEGID_S);
			else if (ePKACtrl.eFIFOMD == SBLK_FIFO)
				SBLK_GetPKADMA((u32 *)OUTPUT_BUF, ePKACtrl.uSEGID_S);
		
			uRet = Compare(OUTPUT_BUF, (u32)&p_AB_s[old_w_cnt],  gPKANumSize/4); 
			old_w_cnt = old_w_cnt + w_cnt;

			if(eTest == eTest_Manual)
			{
				if (uRet)
				{
					UART_Printf("[%d][%d][%d][%d]_[%d] : Sucess \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
				else
				{
					UART_Printf("[%d][%d][%d][%d]_[%d] : Failed \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
			}
			else
			{
				if (uRet)
				{
					if(SBLK_DEBMSG)
						UART_Printf("[%d][%d][%d][%d]_[%d] : Sucess \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
				else
				{
					if(SBLK_DEBMSG)
					UART_Printf("[%d][%d][%d][%d]_[%d] : Failed \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
					g_sblock_err =1;
					UART_Getc();
				}
			}
			
			if(ePKACtrl.eFIFOMD == SBLK_FIFO)
			{
				if(Sblock_INTMD)
				{		
					INTC_Disable(NUM_FEEDCTRL);		
					SBLK_DisDMAINT(PKDMA);				
				}
			}

			SBLK_ClrSegmentPKA();
			SBLK_ClrSfrPKA();	

			
		}
 
}


void SBLKT_PKA_AX1(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	
    	u32 uRet, i;
	u32 usel;
	u32 w_cnt=0, old_w_cnt=0;
	u32 c_cnt=0;
	// Test Case : ePREC, eCHUNKSZ, PLDM, SEGIDx4, SEGSIGN, SEGSZ
	u32 aCaseOfTest[][9] = { {PKA_SINGLE, PKA_160b, PKA_PLDMON, 0, 1,2,3, 0x00000001, PKA_QUARTER},
						     {PKA_SINGLE, PKA_512b, PKA_PLDMON, 24,25,26,27, 0x02000000, PKA_QUARTER},
					            {PKA_DOUBLE, PKA_224b, PKA_PLDMON, 5,6,7,8, 0x00000020, PKA_HALF},
						     {PKA_DOUBLE, PKA_512b, PKA_PLDMON, 10,11,12,13, 0x00000000, PKA_HALF},
						     {PKA_DOUBLE, PKA_512b, PKA_PLDMOFF, 2,3,4,5, 0x00000004, PKA_HALF},
		                                 {PKA_TRIPLE, PKA_352b, PKA_PLDMON, 1,2,3,4, 0x00000004, PKA_FULL},
						     {PKA_TRIPLE, PKA_512b, PKA_PLDMON, 0,1,2,3, 0x00000001, PKA_FULL},
						     {PKA_QUAD, PKA_320b, PKA_PLDMON, 2,3,4,5, 0x0000000C, PKA_FULL},
		                                 {PKA_QUAD, PKA_512b, PKA_PLDMON, 4,5,1,2, 0x00000010, PKA_FULL},
		                                 {PKA_QUAD, PKA_512b, PKA_PLDMOFF, 5,0,1,3, 0x00000001, PKA_FULL}
	                                      };	
	u32 counter = 10;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - PKA AX1 Montgomery  Operation Check]\n");

		UART_Printf("Select PKA CPU or DMA Select  : 1)CPU   2)DMA  \n");
		usel=UART_GetIntNum();
		if (usel == 1) ePKACtrl.eFIFOMD = SBLK_CPU;
		else if (usel == 2) ePKACtrl.eFIFOMD = SBLK_FIFO;
		
	}
	else
	{
		ePKACtrl.eFIFOMD = (SBLK_FIFOMD)oAutoVar.Test_Parameter[0];
				
	}

	for(i=0; i<counter; i++)
	{
			// Set-up condition
			ePKACtrl.ePKAFUNC	= PKA_MulAX1;
			ePKACtrl.ePREC 		= aCaseOfTest[i][0];
			ePKACtrl.eCHUNKSZ	= aCaseOfTest[i][1];
			ePKACtrl.ePLDM		= aCaseOfTest[i][2];
			ePKACtrl.uSEGID_A 	= aCaseOfTest[i][3];
			ePKACtrl.uSEGID_B 	= aCaseOfTest[i][4];
			ePKACtrl.uSEGID_M 	= aCaseOfTest[i][5];
			ePKACtrl.uSEGID_S 	= aCaseOfTest[i][6];
			ePKACtrl.uSIGN		= aCaseOfTest[i][7];	
			ePKACtrl.eSEGSZ		= aCaseOfTest[i][8];	
			
			SBLK_InitPKA(ePKACtrl);

			if(ePKACtrl.eFIFOMD == SBLK_FIFO)
			{
				if(Sblock_INTMD)
				{
					INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
					INTC_Enable(NUM_FEEDCTRL);
					SBLK_PendClearFeed(PKDMA);
					SBLK_EnDMAINT(PKDMA);
					g_SDma1Done =0;
				}
			}

			SBLK_LoadDataPKA(ePKACtrl,(u32 *)&p_A1_a[old_w_cnt], (u32 *)&p_A1_b[old_w_cnt], (u32 *)&p_A1_m[old_w_cnt],  &w_cnt, old_w_cnt);
			SBLK_RunPKA();
			SBLK_NegPosPKA(ePKACtrl.uSEGID_S,  ePKACtrl.uSEGID_M);
			if(ePKACtrl.eFIFOMD == SBLK_CPU)
				SBLK_GetPKA((u32 *)OUTPUT_BUF, ePKACtrl.uSEGID_S);
			else if (ePKACtrl.eFIFOMD == SBLK_FIFO)
				SBLK_GetPKADMA((u32 *)OUTPUT_BUF, ePKACtrl.uSEGID_S);

			
		
			uRet = Compare(OUTPUT_BUF, (u32)&p_A1_s[old_w_cnt],  gPKANumSize/4); 
			old_w_cnt = old_w_cnt + w_cnt;

			if(eTest == eTest_Manual)
			{
				if (uRet)
				{
					UART_Printf("[%d][%d][%d][%d]_[%d] : Sucess \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
				else
				{
					UART_Printf("[%d][%d][%d][%d]_[%d] : Failed \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
			}
			else
			{
				if (uRet)
				{
					if(SBLK_DEBMSG)
						UART_Printf("[%d][%d][%d][%d]_[%d] : Sucess \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
				else
				{
					if(SBLK_DEBMSG)
					UART_Printf("[%d][%d][%d][%d]_[%d] : Failed \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
					g_sblock_err =1;
					UART_Getc();
				}
			}
			
			if(ePKACtrl.eFIFOMD == SBLK_FIFO)
			{
				if(Sblock_INTMD)
				{		
					INTC_Disable(NUM_FEEDCTRL);		
					SBLK_DisDMAINT(PKDMA);				
				}
			}

			SBLK_ClrSegmentPKA();
			SBLK_ClrSfrPKA();	
			
		}
 
}

void SBLKT_PKA_Ovf(eFunction_Test eTest, oFunctionT_AutoVar oAutoVar)
{
	
    	u32 uRet, i;
	u32 usel;
	u32 w_cnt=0, old_w_cnt=0;
	u32 c_cnt=0;
	// Test Case : ePREC, eCHUNKSZ, PLDM, SEGIDx4, SEGSIGN, SEGSZ
	u32 aCaseOfTest[][9] = { {PKA_SINGLE, PKA_128b, PKA_PLDMON, 15,17,20,26, 0x00028000, PKA_QUARTER},
						     {PKA_SINGLE, PKA_512b, PKA_PLDMON, 21,15,23,29, 0x00208000, PKA_QUARTER},
					            {PKA_DOUBLE, PKA_128b, PKA_PLDMON, 7,9,12,10, 0x00000080, PKA_HALF},
						     {PKA_DOUBLE, PKA_512b, PKA_PLDMON, 13,12,10,8, 0x00002000, PKA_HALF},
						     {PKA_TRIPLE, PKA_128b, PKA_PLDMON, 0,2,4,6, 0x00000004, PKA_FULL},
		                                 {PKA_TRIPLE, PKA_512b, PKA_PLDMON, 6,5,3,1, 0x00000020, PKA_FULL},
						     {PKA_QUAD, PKA_128b, PKA_PLDMON, 1,3,4,5, 0x00000000, PKA_FULL},
						     {PKA_QUAD, PKA_512b, PKA_PLDMON, 6,4,2,0, 0x00000000, PKA_FULL}		                                
	                                      };	
	u32 counter = 8;

	if(eTest == eTest_Manual)
	{
		UART_Printf("[SBLOCK - PKA Overflow  Check]\n");

		UART_Printf("Select PKA CPU or DMA Select  : 1)CPU   2)DMA  \n");
		usel=UART_GetIntNum();
		if (usel == 1) ePKACtrl.eFIFOMD = SBLK_CPU;
		else if (usel == 2) ePKACtrl.eFIFOMD = SBLK_FIFO;
		
	}
	else
	{
		ePKACtrl.eFIFOMD = (SBLK_FIFOMD)oAutoVar.Test_Parameter[0];
				
	}

	for(i=0; i<counter; i++)
	{
			// Set-up condition
			ePKACtrl.ePKAFUNC	= PKA_MulAXB;
			ePKACtrl.ePREC 		= aCaseOfTest[i][0];
			ePKACtrl.eCHUNKSZ	= aCaseOfTest[i][1];
			ePKACtrl.ePLDM		= aCaseOfTest[i][2];
			ePKACtrl.uSEGID_A 	= aCaseOfTest[i][3];
			ePKACtrl.uSEGID_B 	= aCaseOfTest[i][4];
			ePKACtrl.uSEGID_M 	= aCaseOfTest[i][5];
			ePKACtrl.uSEGID_S 	= aCaseOfTest[i][6];
			ePKACtrl.uSIGN		= aCaseOfTest[i][7];	
			ePKACtrl.eSEGSZ		= aCaseOfTest[i][8];	
			
			SBLK_InitPKA(ePKACtrl);

			if(ePKACtrl.eFIFOMD == SBLK_FIFO)
			{
				if(Sblock_INTMD)
				{
					INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
					INTC_Enable(NUM_FEEDCTRL);
					SBLK_PendClearFeed(PKDMA);
					SBLK_EnDMAINT(PKDMA);
					g_SDma1Done =0;
				}
			}

			
	
			SBLK_LoadDataPKA(ePKACtrl,(u32 *)&p_Ovf_a[old_w_cnt], (u32 *)&p_Ovf_b[old_w_cnt], (u32 *)&p_Ovf_m[old_w_cnt],  &w_cnt, old_w_cnt);
			SBLK_RunPKA();
			SBLK_NegPosPKA(ePKACtrl.uSEGID_S,  ePKACtrl.uSEGID_M);
			if(ePKACtrl.eFIFOMD == SBLK_CPU)
				SBLK_GetPKA((u32 *)OUTPUT_BUF, ePKACtrl.uSEGID_S);
			else if (ePKACtrl.eFIFOMD == SBLK_FIFO)
				SBLK_GetPKADMA((u32 *)OUTPUT_BUF, ePKACtrl.uSEGID_S);
		
			uRet = Compare(OUTPUT_BUF, (u32)&p_Ovf_s[old_w_cnt],  gPKANumSize/4); 
			old_w_cnt = old_w_cnt + w_cnt;

			if(eTest == eTest_Manual)
			{
				if (uRet)
				{
					UART_Printf("[%d][%d][%d][%d]_[%d] : Sucess \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
				else
				{
					UART_Printf("[%d][%d][%d][%d]_[%d] : Failed \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
			}
			else
			{
				if (uRet)
				{
					if(SBLK_DEBMSG)
						UART_Printf("[%d][%d][%d][%d]_[%d] : Sucess \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
				}
				else
				{
					if(SBLK_DEBMSG)
					UART_Printf("[%d][%d][%d][%d]_[%d] : Failed \n", ePKACtrl.ePREC,ePKACtrl.eCHUNKSZ,ePKACtrl.ePLDM, ePKACtrl.eSEGSZ,ePKACtrl.eFIFOMD);
					g_sblock_err =1;
					UART_Getc();
				}
			}
			
			if(ePKACtrl.eFIFOMD == SBLK_FIFO)
			{
				if(Sblock_INTMD)
				{		
					INTC_Disable(NUM_FEEDCTRL);		
					SBLK_DisDMAINT(PKDMA);				
				}
			}

			SBLK_ClrSegmentPKA();
			SBLK_ClrSfrPKA();	

			
		}
 
}

u8  Sblock_AES_autotest(void)
{
	u32 i, j,k, l, uNumMode, uNumKey, uRegValue;
	oFunctionT_AutoVar oAutoTest;	
	u32 aCaseOfAES[] = { ECB, CBC, CTR};  
	u32 aKeyOfAES[] = { Key128b, Key192b, Key256b};  
	u32 aSwapOfAES[] = {SBLK_Swap, SBLK_NoSwap};
	//int f = 0;
	g_Sblock_DEBUG =1;
	g_AgingDis=1;
	if(SBLK_DEBMSG)
	{
	UART_Printf("\n [ Sblock AES Auto Test ]\n");
	UART_Printf("============================================= \n");
	}
	//////////////////////////////////////////
	//////   AES Test
	g_sblock_err = 0;
	uNumMode = sizeof(aCaseOfAES)/sizeof(aCaseOfAES[0]);
	uNumKey = sizeof(aKeyOfAES)/sizeof(aKeyOfAES[0]);
	for(l=0;l<2;l++)
	{
	for(k=0; k<2;k++)
	{
	for(i=0; i<uNumMode;i++)
	{
		for(j=0; j<uNumKey;j++)
		{
		oAutoTest.Test_Parameter[0] = aCaseOfAES[i];
		oAutoTest.Test_Parameter[1] = aKeyOfAES[j];

		oAutoTest.Test_Parameter[2] = aSwapOfAES[k];
		oAutoTest.Test_Parameter[3] = aSwapOfAES[k];
		oAutoTest.Test_Parameter[4] = aSwapOfAES[k];
		oAutoTest.Test_Parameter[5] = aSwapOfAES[k];
		oAutoTest.Test_Parameter[6] = aSwapOfAES[k];
		oAutoTest.Test_Parameter[7] = aSwapOfAES[l];
		
	 	Test_AES_CPU(eTest_Auto, oAutoTest );
	 	Test_AES_CPU_TB(eTest_Auto, oAutoTest);
	 	Test_AES_DMA(eTest_Auto, oAutoTest);
		}
	}
	}
	}

	if(SBLK_DEBMSG)
	{
		if(g_sblock_err == 0)
		{
			UART_Printf("	AES Operation :			PASS \n");		
			return true;
		}
		else
		{
			UART_Printf("	AES Operation :			FAIL\n");
			g_sblock_cnt++;
			return false;
		}
	}

	
}


u8  Sblock_DES_autotest(void)
{
	u32 i, j, k,l, uNumMode, uNumMode1, uRegValue;
	oFunctionT_AutoVar oAutoTest;	
	u32 aCaseOfDES[][2] = { {DES,EDE}, {TDES,EDE}, {TDES, EEE}};  
	u32 aModeOfDES[] = {ECB, CBC};
	u32 aSwapOfDES[] = {SBLK_Swap, SBLK_NoSwap};

	//int f = 0;
	g_Sblock_DEBUG =1;
	g_AgingDis=1;
	if(SBLK_DEBMSG)
	{
	UART_Printf("\n [ Sblock DES Auto Test ]\n");
	UART_Printf("============================================= \n");
	}
	//////////////////////////////////////////
	//////   DES Test
	g_sblock_err = 0;
	uNumMode = 3;
	uNumMode1 = sizeof(aModeOfDES)/sizeof(aModeOfDES[0]);
	for(l=0;l<2;l++)
	{
	for(k=0;k<2;k++)
	{
	for(i=0; i<uNumMode;i++)
	{
		for(j=0; j<uNumMode1;j++)
		{
		oAutoTest.Test_Parameter[0] = aCaseOfDES[i][0];
		oAutoTest.Test_Parameter[1] = aModeOfDES[j];
		oAutoTest.Test_Parameter[2] = aCaseOfDES[i][1];

		oAutoTest.Test_Parameter[3] = aSwapOfDES[k];
		oAutoTest.Test_Parameter[4] = aSwapOfDES[k];
		oAutoTest.Test_Parameter[5] = aSwapOfDES[k];
		oAutoTest.Test_Parameter[6] = aSwapOfDES[k];
		oAutoTest.Test_Parameter[7] = aSwapOfDES[l];
	 	Test_DES_CPU(eTest_Auto, oAutoTest );
	 	Test_DES_CPU_TB(eTest_Auto, oAutoTest);
	 	Test_DES_DMA(eTest_Auto, oAutoTest);
		}
	}
	}
	}
	
	if(SBLK_DEBMSG)
	{
		if(g_sblock_err == 0)
		{
			UART_Printf("	DES Operation :			PASS \n");
			return true;
		}
		else
		{
			UART_Printf("	DES Operation :			FAIL\n");
			g_sblock_cnt++;
			return false;
		}
	}


	
}

u8  Sblock_Hash_autotest(void)
{
	u32 i, j,  k,l, uNumMode, uNumMode1, uRegValue;
	oFunctionT_AutoVar oAutoTest;	
	u32 aCaseOfHash[] = {SHA1_HASH, MD5_HASH};
	u32 aCaseOfHMAC[] = {SHA1_HMAC, MD5_HMAC};
	u32 aFIFOOfHash[] = {SBLK_CPU, SBLK_FIFO};
	u32 aSwapOfHash[]={SBLK_Swap, SBLK_NoSwap};
	// for Advanced Function
	u32 aCaseOfBlk[][3] = {{AES, ECB, }, {AES, CBC, }, {AES, CTR, }, {DES,ECB, EDE}, {DES,CBC,EDE},
						  {TDES, ECB, EDE},{TDES,ECB, EEE}, {TDES,CBC,EDE},{TDES,CBC,EEE}	};
	
	u32 aCaseOfDir[] = {ENC, DEC};
	//int f = 0;
	g_Sblock_DEBUG =1;
	g_AgingDis=1;
	if(SBLK_DEBMSG)
	{
	UART_Printf("\n [ Sblock Hash Auto Test ]\n");
	UART_Printf("============================================= \n");
	}
	//////////////////////////////////////////
	//////   Hash Test
	g_sblock_err = 0;
	uNumMode = sizeof(aCaseOfHash)/sizeof(aCaseOfHash[0]);
	uNumMode1 = sizeof(aFIFOOfHash)/sizeof(aFIFOOfHash[0]);
	for(l=0;l<2;l++)
	{
	for(k=0;k<2;k++)
	{
	for(i=0; i<uNumMode;i++)
	{
		for(j=0;j<uNumMode1;j++)
		{
		oAutoTest.Test_Parameter[0] = aCaseOfHash[i];
		oAutoTest.Test_Parameter[1] = aFIFOOfHash[i];
		
		oAutoTest.Test_Parameter[2] = aSwapOfHash[k];
		oAutoTest.Test_Parameter[3] = aSwapOfHash[k];
		oAutoTest.Test_Parameter[4] = aSwapOfHash[k];
		oAutoTest.Test_Parameter[5] = aSwapOfHash[l];
		
	 	Test_HASH_CPUnDMA(eTest_Auto, oAutoTest );
		oAutoTest.Test_Parameter[0] = aCaseOfHMAC[i];
	 	Test_HMAC_CPUnDMA(eTest_Auto, oAutoTest );
		}
	}
	}
	}

	//  Last Byte Operation
	Test_HASH_LastByte(eTest_Auto,oAutoTest);
	SBLKT_HASH_partial(eTest_Auto,oAutoTest);

	for(l=0;l<2;l++)		// Hash Engine
	{
	for(k=0;k<2;k++)		// 
	{
	for(i=0;i<9;i++)
		{
		oAutoTest.Test_Parameter[0] = aCaseOfHash[l];
		
		oAutoTest.Test_Parameter[1] = aCaseOfBlk[i][0];		
		oAutoTest.Test_Parameter[2] = aCaseOfBlk[i][1];
		oAutoTest.Test_Parameter[3] = aCaseOfBlk[i][2];
		
		oAutoTest.Test_Parameter[4] = aCaseOfDir[k];
		
		SBLKT_HASH_adv(eTest_Auto,oAutoTest);
		}
	}
	}

	
	Test_PRNG(eTest_Auto, oAutoTest);
	
	if(SBLK_DEBMSG)
	{
		if(g_sblock_err == 0)
		{
			UART_Printf("	HASH Operation :			PASS \n");
			return true;
		}
		else
		{
			UART_Printf("	HASH Operation :			FAIL\n");
			g_sblock_cnt++;
			return false;
		}
	}


	
}

u8  Sblock_PKA_autotest(void)
{
	u32 i, j,  k,l, uNumMode, uNumMode1, uRegValue;
	oFunctionT_AutoVar oAutoTest;	
	u32 aModeOfFIFO[] = {SBLK_CPU, SBLK_FIFO};
	//u32 aCaseOfHash[] = {SHA1_HASH, MD5_HASH};
	//u32 aFIFOOfHash[] = {SBLK_CPU, SBLK_FIFO};
	//u32 aSwapOfHash[]={SBLK_Swap, SBLK_NoSwap};

	//int f = 0;
	g_Sblock_DEBUG =1;
	g_AgingDis=1;
	if(SBLK_DEBMSG)
	{
	UART_Printf("\n [ Sblock PKA Auto Test ]\n");
	UART_Printf("============================================= \n");
	}
	//////////////////////////////////////////
	//////   PKA Test
	g_sblock_err = 0;

	for(i=0;i<10;i++)
	{
	// Random R/W Test for PKA SRAM
	 SBLKT_PKA_SRAM(eTest_Auto, oAutoTest );
	}

	for(i=0;i<2;i++)
	{
		oAutoTest.Test_Parameter[0] = aModeOfFIFO[i];
		SBLKT_PKA_SEG(eTest_Auto, oAutoTest );
	}

	for(i=0;i<2;i++)
	{
		oAutoTest.Test_Parameter[0] = aModeOfFIFO[i];
		SBLKT_PKA_AXB(eTest_Auto, oAutoTest );
		SBLKT_PKA_AX1(eTest_Auto, oAutoTest );
		SBLKT_PKA_Ovf(eTest_Auto, oAutoTest );
	}

	
	if(SBLK_DEBMSG)
	{
		if(g_sblock_err == 0)
		{
			UART_Printf("	PKA Operation :			PASS \n");
			return true;
		}
		else
		{
			UART_Printf("	PKA Operation :			FAIL\n");
			g_sblock_cnt++;	
			return false;
		}
	}

	
}


void SblockT_FullFunction(void)
{
	u32 i, usel, utestNum;

	UART_Printf("Select Test Case : 1)single   2)Aging  \n");
	usel=UART_GetIntNum();
	if(usel == 1) 
		{
			utestNum =1;
			g_AgingDis = 1;
		}
	else if(usel == 2) 
		{
			utestNum = 10000;
			g_AgingDis =0;
			g_sblock_cnt=0;
		}
	
	g_sblock_err =0;

	for(i=0; i<utestNum; i++)
	{
		
	      if(i%100 == 0)  UART_Printf("test no(Sblk_Err): %d(%d)\n", i, g_sblock_cnt);
	      
		Sblock_AES_autotest();
		Sblock_DES_autotest();
		Sblock_Hash_autotest();
		Sblock_PKA_autotest();
	}

	g_Sblock_DEBUG=1;
	
}

//////////////////////////////Temp Test
void SblockT_DES_(void)
{
	// CPU DES
	SBLK_DES(DES_ENC|DES_ECB|DES_DES|DES_EDE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Des_CipherText[0], 16);
	SBLK_DES(DES_ENC|DES_ECB|DES_DES|DES_EDE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Des_CipherText[0], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_DES|DES_EDE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Des_CipherText[1], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_DES|DES_EDE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Des_CipherText[1], 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_DES|DES_EDE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Des_CipherText[0], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_DES|DES_EDE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_CipherText[0], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_DES|DES_EDE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Des_CipherText[1], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_DES|DES_EDE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_CipherText[1], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	// CPU TDES EDE		
	SBLK_DES(DES_ENC|DES_ECB|DES_TDES|DES_EDE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[0], 16);
	SBLK_DES(DES_ENC|DES_ECB|DES_TDES|DES_EDE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[0], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_TDES|DES_EDE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[1], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_TDES|DES_EDE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[1], 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_TDES|DES_EDE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[0], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_TDES|DES_EDE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[0], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_TDES|DES_EDE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[1], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_TDES|DES_EDE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[1], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	// CPU TDES EEE
	SBLK_DES(DES_ENC|DES_ECB|DES_TDES|DES_EEE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[2], 16);
	SBLK_DES(DES_ENC|DES_ECB|DES_TDES|DES_EEE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[2], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_TDES|DES_EEE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[3], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_TDES|DES_EEE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[3], 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_TDES|DES_EEE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[2], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_TDES|DES_EEE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[2], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_TDES|DES_EEE|DES_CPU, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[3], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_TDES|DES_EEE|DES_CPU|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[3], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
			
	// DMA DES
	SBLK_DES(DES_ENC|DES_ECB|DES_DES|DES_EDE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Des_CipherText[0], 16);
	SBLK_DES(DES_ENC|DES_ECB|DES_DES|DES_EDE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Des_CipherText[0], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_DES|DES_EDE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Des_CipherText[1], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_DES|DES_EDE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Des_CipherText[1], 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_DES|DES_EDE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Des_CipherText[0], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_DES|DES_EDE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_CipherText[0], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_DES|DES_EDE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Des_CipherText[1], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_DES|DES_EDE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_CipherText[1], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	// DMA TDES EDE		
	SBLK_DES(DES_ENC|DES_ECB|DES_TDES|DES_EDE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[0], 16);
	SBLK_DES(DES_ENC|DES_ECB|DES_TDES|DES_EDE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[0], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_TDES|DES_EDE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[1], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_TDES|DES_EDE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[1], 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_TDES|DES_EDE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[0], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_TDES|DES_EDE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[0], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_TDES|DES_EDE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[1], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_TDES|DES_EDE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[1], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	// DMA TDES EEE
	SBLK_DES(DES_ENC|DES_ECB|DES_TDES|DES_EEE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[2], 16);
	SBLK_DES(DES_ENC|DES_ECB|DES_TDES|DES_EEE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[2], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_TDES|DES_EEE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[3], 16);
	SBLK_DES(DES_ENC|DES_CBC|DES_TDES|DES_EEE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Des_PlainText, (u32 *)OUTPUT_BUF, u_Tdes_CipherText[3], 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_TDES|DES_EEE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[2], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_ECB|DES_TDES|DES_EEE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[2], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_TDES|DES_EEE|DES_DMA, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[3], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
	SBLK_DES(DES_DEC|DES_CBC|DES_TDES|DES_EEE|DES_DMA|DES_SWAP_KEY|DES_SWAP_IV|DES_SWAP_DI|DES_SWAP_DO, u_Des_Key, u_Des_IV, 
			u_Tdes_CipherText[3], (u32 *)OUTPUT_BUF, u_Des_PlainText, 16);
		
}



//////////////////////// Sub Test Menu ////////////////////////////////////




const AutotestFuncMenu sblock_aes[] =
{
	Test_AES_CPU,             				"CPU Mode Test",
	Test_AES_CPU_TB,					"	Two Buffer - CPU Mode",
	Test_AES_DMA,						"DMA Mode Test",
	//Test_CTR_Counter,					"Test AES(CTR) Counter Edge Test-F",	// 6410
	

	0, 0
};


void SblockT_AES(void)
{
	u32 i;
	s32 uSel;
	oFunctionT_AutoVar oParameter;
	
	while(1)
	{
		for (i=0; (u32)(sblock_aes[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, sblock_aes[i].desc);

		UART_Printf("\nSelect the function to test : \n");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if(uSel == -1) 
			break;

		if (uSel>=0 && uSel<(sizeof(sblock_aes)/8-1))
			(sblock_aes[uSel].func) (eTest_Manual, oParameter);
	}

}



const AutotestFuncMenu sblock_des[] =
{
	SblockT_DES_,						"Temp Test",
	Test_DES_CPU,             				"CPU Mode Test",
	Test_DES_CPU_TB,					"	Two Buffer - CPU Mode",
	Test_DES_DMA,						"DMA Mode Test",

	0, 0
};


void SblockT_DES(void)
{
	u32 i;
	s32 uSel;
	oFunctionT_AutoVar oParameter;
	
	while(1)
	{
		for (i=0; (u32)(sblock_des[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, sblock_des[i].desc);

		UART_Printf("\nSelect the function to test : \n");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if(uSel == -1) 
			break;

		if (uSel>=0 && uSel<(sizeof(sblock_des)/8-1))
			(sblock_des[uSel].func) (eTest_Manual, oParameter);
	}

}



const AutotestFuncMenu sblock_hash[] =
{
	Test_HASH_CPUnDMA,						"Test_HASH CPU  & DMA",	
	Test_HASH_LastByte,             					"Test_HASH-Last Byte ",
	Test_HMAC_CPUnDMA,						"Test_HMAC CPU & DMA",
	Test_PRNG,									"Test PRNG",
	SBLKT_HASH_partial,							"Partial Hash operation",
	SBLKT_HASH_adv,							"Block Chipher Test ",
	SBLKT_HASH_adv_Temp,						"Temp for Debuggin",
	0, 0
};


void SblockT_HASH(void)
{
	u32 i;
	s32 uSel;
	oFunctionT_AutoVar oParameter;
	
	while(1)
	{
		for (i=0; (u32)(sblock_hash[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, sblock_hash[i].desc);

		UART_Printf("\nSelect the function to test : \n");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if(uSel == -1) 
			break;

		if (uSel>=0 && uSel<(sizeof(sblock_hash)/8-1))
			(sblock_hash[uSel].func) (eTest_Manual, oParameter);
	}

}


const AutotestFuncMenu sblock_pka[] =
{
	SBLKT_PKA_SRAM,		"PKA SRAM Test",
	SBLKT_PKA_SEG,			"PKA Basic Operation & SEG ID Test",
	SBLKT_PKA_AXB,			"PKA AXB Functional Test ",
	SBLKT_PKA_AX1, 		"PKA AX1 Functional Test",
	SBLKT_PKA_Ovf,			"PKA Overflow Check",

	0, 0
};


void SblockT_PKA(void)
{
	u32 i;
	s32 uSel;
	oFunctionT_AutoVar oParameter;
	
	while(1)
	{
		for (i=0; (u32)(sblock_pka[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, sblock_pka[i].desc);

		UART_Printf("\nSelect the function to test : \n");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if(uSel == -1) 
			break;

		if (uSel>=0 && uSel<(sizeof(sblock_pka)/8-1))
			(sblock_pka[uSel].func) (eTest_Manual, oParameter);
	}

}

u32 SblockT_ClockOnOff(void)
{
	s32 uRanOffset;
	u32 uCount=1;	
		
	UART_Printf("[Sblock_ClockOnOff]\n");

	g_AgingDis =0;
	g_sblock_cnt=0;
	g_sblock_err =0;

	g_SBLKTestOpt = 1; 		// Clock OFF
				
	while(!UART_GetKey())
	{
		if(uCount%100 == 0)  UART_Printf("test no(Sblk_Err): %d(%d)\n",uCount, g_sblock_cnt);
		Sblock_AES_autotest();
		Sblock_DES_autotest();
		Sblock_Hash_autotest();
		Sblock_PKA_autotest();
		uCount++;
		
	}

	return TRUE;
}

u32 SblockT_PowerMode(void)
{
	s32 uRanOffset;
	u32 uCount=1;	
		
	UART_Printf("[Sblock_PowerMode]\n");

	g_AgingDis =0;
	g_sblock_cnt=0;
	//g_sblock_err =0;

	g_SBLKTestOpt = 2; 		// Clock OFF
				
	while(!UART_GetKey())
	{
		//if(uCount%100 == 0)  UART_Printf("test no(Sblk_Err): %d(%d)\n",uCount, g_sblock_cnt);
		Sblock_AES_autotest();
		Sblock_DES_autotest();
		Sblock_Hash_autotest();
		Sblock_PKA_autotest();
		uCount++;
		
	}

	return TRUE;
}


void SblockT_Perf(void)
{
	u32 uResult;
	u32 i,j,k, num;
	u32 uTestTime;
	u32 uTestLength;
	
	u32 aCaseOfAES[] = { ECB, CBC, CTR};  
	u32 aKeyOfAES[] = { Key128b, Key192b, Key256b};  
	u32 aCaseOfDES[][2] = { {DES,EDE}, {TDES,EDE}, {TDES, EEE}};  
	u32 aModeOfDES[] = {ECB, CBC};
	u32 aCaseOfHash[] = {SHA1_HASH, MD5_HASH};
	u32 aCaseOfHMAC[] = {SHA1_HMAC, MD5_HMAC};
	u32 aFIFOOfHash[] = {SBLK_CPU, SBLK_FIFO};
	
	UART_Printf("[Sblock_Performance]\n");

	g_SBLKTestOpt=0;
	g_Sblock_DEBUG =1;
	g_AgingDis=1;
				
	GPIO_SetPullUpDownEach(eGPIO_G2, eGPIO_0,0);
	GPIO_SetFunctionEach(eGPIO_G2, eGPIO_0, 1);	//CPU B/D J2[4] Output
	GPIO_SetDataEach(eGPIO_G2, eGPIO_0, 1);

	#if 0
	StartTimer(0);
	uResult = SBLK_GetRand();	
	uTestTime=StopTimer(0);
	
	UART_Printf("[%d]: 0x%x :0x%d \n", i, uResult, uTestTime);
	#endif
	uTestLength = 0x100000;

	INTC_SetVectAddr(NUM_FEEDCTRL, Isr_SSSFeed);
	INTC_Enable(NUM_FEEDCTRL);
	SBLK_PendClearFeed(BTDMA);
	SBLK_EnDMAINT(BTDMA);
	g_SDma1Done =0;
	
#if 1
	//AES  CPU Test

	eAesCtrl.eFIFOMD   = SBLK_CPU;
	eAesCtrl.eKeyMD  = NChangeKey;
	eAesCtrl.eKEYSwap     = SBLK_Swap;
	eAesCtrl.eCNTSwap     = SBLK_Swap;
	eAesCtrl.eIVSwap     = SBLK_Swap;
	eAesCtrl.eDOSwap     = SBLK_Swap;
	eAesCtrl.eDISwap     = SBLK_Swap;
	eAesCtrl.eDMASwap=SBLK_Swap;
	
	// Encryption
	for(k=0;k<2;k++)
	{
		if (k ==0 ) eAesCtrl.eDir   	= ENC;
		else eAesCtrl.eDir   	= DEC;


	
	for(num=0;num<3;num++)
	{
	for(j=0;j<3;j++)
	{
		eAesCtrl.eOperMode= aCaseOfAES[num];
		eAesCtrl.eKeySz = aKeyOfAES[j];

		oSblk.m_eTestType	= eAesCtrl.eFIFOMD;
		oSblk.m_eDir	=	eAesCtrl.eDir;
	
		SBLK_AESInit(eAesCtrl, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter);
		GPIO_SetDataEach(eGPIO_G2, eGPIO_0, 1);
		StartTimer(0);
		for(i=0;i<uTestLength;i+=4)
		{
			
			SBLK_PutDataToInReg((u32)u_Aes_PlainText, 4);
			//SBLK_StartByManual();
			while(!SBLK_IsOutputReady());
			SBLK_GetDataFromOutReg(OUTPUT_BUF+i*4, 4);
			SBLK_ValidZero();
			if(eAesCtrl.eKeyMD  == NChangeKey)
			SBLK_AESCloseKey();
		}
		uTestTime=StopTimer(0);
		GPIO_SetDataEach(eGPIO_G2, eGPIO_0, 0);
		DispOperMode();
		UART_Printf(" uTestTime = [%d] \n", uTestTime);

	}
	}
	}

	// DMA
	UART_Printf("\n\n");
	eAesCtrl.eFIFOMD   = SBLK_FIFO;


	
	for(k=0;k<2;k++)
	{
		if (k ==0 ) eAesCtrl.eDir   	= ENC;
		else eAesCtrl.eDir   	= DEC;
	
	for(num=0;num<3;num++)
	{
	for(j=0;j<3;j++)
	{
		eAesCtrl.eOperMode= aCaseOfAES[num];
		eAesCtrl.eKeySz = aKeyOfAES[j];

		oSblk.m_eTestType	= eAesCtrl.eFIFOMD;
		oSblk.m_eDir	=	eAesCtrl.eDir;
	
		SBLK_AESInit(eAesCtrl, u_Aes_Key, u_Aes_IV, u_Aes_InitCounter);
		StartTimer(0);
		
		SBLK_SetDMAt(INPUT_BUF, uTestLength, OUTPUT_BUF, uTestLength);

		uTestTime=StopTimer(0);

		DispOperMode();
		UART_Printf(" uTestTime = [%d] \n", uTestTime);

	}
	}
	}
	UART_Printf("\n\n");
#endif
#if 1
	//DES CPU
	UART_Printf("\n\n");
	eDesCtrl.eFIFOMD   = SBLK_CPU;

	eDesCtrl.eDMASwap = SBLK_Swap;
	eDesCtrl.eKEYSwap= SBLK_Swap;
	eDesCtrl.eIVSwap= SBLK_Swap;
	eDesCtrl.eDOSwap= SBLK_Swap;
	eDesCtrl.eDISwap= SBLK_Swap;

	for(k=0;k<2;k++)
	{
		if (k ==0 ) eDesCtrl.eDir   	= ENC;
		else eDesCtrl.eDir   	= DEC;
	
	for(num=0;num<3;num++)
	{
	for(j=0;j<2;j++)
	{

		eDesCtrl.eENG = aCaseOfDES[num][0];
		eDesCtrl.eOperMode = aModeOfDES[j];
		eDesCtrl.eEEEMode = aCaseOfDES[num][1];

		oSblk.m_eTestType	= eDesCtrl.eFIFOMD;
		oSblk.m_eDir	=	eDesCtrl.eDir;
	
		SBLK_DESInit(eDesCtrl, u_Des_Key, u_Des_IV);
		StartTimer(0);
		for(i=0;i<uTestLength;i+=4)
		{
			
			SBLK_PutDataToInReg((u32)u_Des_PlainText, 2);
			//SBLK_StartByManual();
			while(!SBLK_IsOutputReady());
			SBLK_GetDataFromOutReg(OUTPUT_BUF+i*4, 2);
			SBLK_ValidZero();
		}
		uTestTime=StopTimer(0);
		DispOperMode();
		UART_Printf(" uTestTime = [%d] \n", uTestTime);

	}
	}
	}	

	UART_Printf("\n\n");
	eDesCtrl.eFIFOMD   = SBLK_FIFO;

	for(k=0;k<2;k++)
	{
		if (k ==0 ) eDesCtrl.eDir   	= ENC;
		else eDesCtrl.eDir   	= DEC;
	
	for(num=0;num<3;num++)
	{
	for(j=0;j<2;j++)
	{

		eDesCtrl.eENG = aCaseOfDES[num][0];
		eDesCtrl.eOperMode = aModeOfDES[j];
		eDesCtrl.eEEEMode = aCaseOfDES[num][1];

		oSblk.m_eTestType	= eDesCtrl.eFIFOMD;
		oSblk.m_eDir	=	eDesCtrl.eDir;
	
		SBLK_DESInit(eDesCtrl, u_Des_Key, u_Des_IV);
		StartTimer(0);
		SBLK_SetDMAt(INPUT_BUF, uTestLength, OUTPUT_BUF, uTestLength);
		uTestTime=StopTimer(0);
		DispOperMode();
		UART_Printf(" uTestTime = [%d] \n", uTestTime);

	}
	}
	}	
#endif
	UART_Printf("\n\n");

	eHashCtrl.eDOSwap= SBLK_Swap;
	eHashCtrl.eDISwap= SBLK_Swap;
	eHashCtrl.eDMASwap= SBLK_Swap;	
	eHashCtrl.eIVSwap = SBLK_Swap;

	INTC_SetVectAddr(NUM_HASH, Isr_HASH);
	INTC_Enable(NUM_HASH);
	g_HASHDone =0;


	for(i=0; i<2;i++)
	{
	for(j=0;j<2;j++)
	{

	eHashCtrl.eFIFOMD	= aFIFOOfHash[i];
	oSblk.m_eTestType =aFIFOOfHash[i];
	eHashCtrl.eOperMode  =  aCaseOfHash[j];

	StartTimer(0);
	SBLK_RunHASH(eHashCtrl,   uTestLength , u_PlainText, OUTPUT_BUF);	
	uTestTime=StopTimer(0);
	DispOperMode();
	UART_Printf(" uTestTime = [%d] \n", uTestTime);	
	}
	}
	
	UART_Printf("\n\n");
	for(i=0; i<2;i++)
	{
	for(j=0;j<2;j++)
	{

	eHashCtrl.eFIFOMD	= aFIFOOfHash[i];
	oSblk.m_eTestType =aFIFOOfHash[i];
	eHashCtrl.eOperMode  =  aCaseOfHMAC[j];

	StartTimer(0);
	SBLK_RunHMAC(eHashCtrl,   uTestLength , u_HmacKey, u_HmacPlainText19, OUTPUT_BUF);
	uTestTime=StopTimer(0);
	DispOperMode();
	UART_Printf(" uTestTime = [%d] \n", uTestTime);	
	}
	}

	//return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////
////////////////////                   Secure Block Main Test           /////////////////////////// 
///////////////////////////////////////////////////////////////////////////////////


const AutotestFuncMenu Sblock_ETC_menu[]=
{
	SblockT_ClockOnOff,						"Sblock Clock On/Off",
	SblockT_PowerMode,						"Sblock Power Mode",
	
	0,0
};

u32 SblockT_ETCTest(eFunction_Test eTest, oFunctionT_AutoVar oPara)
{
	u32 i;
	s32 sSel;
	
	while (true)
	{
		UART_Printf("\n");
		UART_Printf("\n");
		for ( i=0; (int)(Sblock_ETC_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, Sblock_ETC_menu[i].desc);
		UART_Printf("Select the function to test : ");
		sSel = UART_GetIntNum();
		UART_Printf("\n");

		if (sSel == -1)
			break;
		if (sSel>=0 && sSel<(sizeof(Sblock_ETC_menu)/8-1))
			(Sblock_ETC_menu[sSel].func) (eTest_Manual, oPara);
	}


	return OK;
}



const testFuncMenu secu_menu[] =
{

 		TestSSS_SFR,			"SFR R/W Test-Done",
		SblockT_AES,			"AES Mode Test-Done",
		SblockT_DES,			"DES Mode Test-Done",
		SblockT_HASH,			"HASH Mode Test",
		SblockT_PKA,			"PKA Test",
		

		SblockT_FullFunction,	"SBLK Full Function ",
		Sblock_AES_autotest,	"	AES_Full_Function",
		Sblock_DES_autotest,	"	DES_Full_Function",
		Sblock_Hash_autotest,	"	HASH_Full_Function",
		Sblock_PKA_autotest,	"	PKA_Full_Function",
		SblockT_ETCTest,		"ETC test",

 		SblockT_Perf,								"Sblock Performance Test",


	0, 0
};


void SBLOCK_Test(void)
{
	u32 i;
	s32 uSel;

	UART_Printf("[Security Sub System Test]\n\n");

	//eAesOperMode = ECB;
	//eDesOperMode = ECB;
	//eHashOperMode = HMAC;

	//Add Stop Mode Enter/Exit
	//SYSC_STOP();


	SYSC_InitClkForMM();
	
	// IP Clock Off and On
	SYSC_SetClkOFF_IP(eCRYPTO);
	DelayfrTimer(milli, 100);
	SYSC_SetClkON_IP(eCRYPTO);
	
	
	g_SBLKTestOpt=0;
	g_Sblock_DEBUG =1;
	g_AgingDis=1;
	
	while(1)
	{
		for (i=0; (u32)(secu_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, secu_menu[i].desc);

		UART_Printf("\nSelect the function to test : ");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if(uSel == -1) 
			break;

		if (uSel>=0 && uSel<(sizeof(secu_menu)/8-1))
			(secu_menu[uSel].func) ();
	}
}	







