/**                                                                
 * SGX540 Compatibility Test For S5PV210                           
 * Copyright (c) 2009 Computing Platform, Samsung Electronics, Inc.
 * All right reserved.                                             
 *                                                                 
 * This software is the confidential and proprietary information   
 * of Samsung Electronics Inc. ("Confidential Information"). You   
 * shall not disclose such Confidential Information and shall use  
 * it only in accordance with the terms of the license agreement   
 * you entered into with Samsung Electronics.                      
 */                                                                
                                                                   
/**                                                                
 * @file	sgx540.cpp                                                       
 * @brief	This is a vector for SGX540 compatibility test.          
 * @author	Cheolkyoo Kim                                        
 * @version	1.0                                                  
 */                                                                

#include <stdio.h>
#include <stdlib.h>

#include "option.h"
#include "lcd.h"
#include "glib.h"
#include "sgx540.h"
#include "SGX540VectorList.h"
#include "sysc.h"
#include "timer.h"

#define			ATEST_3D			

#ifdef		ATEST_3D
#include "dx_wireframe_8888_fpmn_lenna.h"				//cPrmLenna,LENNA_SIZE;
#endif

int	Execute3DVector(void);
int	PowerOnOff(void);
int	ClokcGatingOnOff(void);
int	RandPowerMode(void);



// TODO
#if (0)
	const testFuncMenu menu[]=
	{
		0,                                  		"Exit",
		sfr_test,		"Test Function",
		0,0
	};
#endif

// Test vector automation routine

//extern void SFRTestVector(void);

#define		REF_PATH	"E:\\works\\v210\\SW\\DaughterBD\\mp_framework\\Components\\multimedia\\sgx540\\vectors_cpp\\"

bool	SGX540_3D_Autotest(void);

void * SGX540_3D_func[][2]=
{  	
	(void *)Execute3DVector,				"Execute3DVector",
	(void *)PowerOnOff,			"PowerOnOff",  
	(void *)ClokcGatingOnOff,		"ClokcGatingOnOff Block     ",
	(void *)RandPowerMode,		"RandPowerMode Page       ",  
	(void *)SGX540_3D_Autotest,   "SGX540_3D_Autotest		",
	0,0
};


bool	SGX540_3D_Autotest(void)
{
	u32 i = 0;	
#ifdef		ATEST_3D
	unsigned int u3DCheckSum = 0;
	unsigned char *p_u3DFrameBuff;
#endif	
	
	char pMEMFileName[512]="";
	char pPRMFileName[512]="";
	char pSaveFileName[512]="";
	SGX_WRITEL(0xf3000D00, 0x00000400);//SLC off
	//SFRTestVector();

	
	p_u3DFrameBuff = (unsigned char *)0x20543000;
	memcpy((unsigned char*)ADDR_3D_PRM, cPrmLenna,LENNA_SIZE);
	dx_wireframe_8888_fpmn_lenna("lenna",0);
	UART_Printf("\n[1]");	
	for(i=0; i< 0x12c000; i++)
	{		
		u3DCheckSum += (unsigned int)(*p_u3DFrameBuff++);		
	}
	UART_Printf("\n[2]");
	if(u3DCheckSum !=LENNA_CHECKSUM)
	{
		UART_Printf("\nError - 3D Test CheckSum Error --> Fail !!!!!!!!!!!");
		return false;	
		UART_Printf("\n[3]");			
	}
	UART_Printf("\n[4]");
	return true;
	
}



static void PrintSubMessage(void)
{
	int i;
	
	i=0;	
	UART_Printf("\n\n");
	while(1)
	{   //display menu
	    UART_Printf("%2d:%s",i,SGX540_3D_func[i][1]);
	    i++;
	    if((int)(SGX540_3D_func[i][0])==0)
	    {
		 UART_Printf("\n");
		 break;
	    }
	    if((i%4)==0) UART_Printf("\n");
	}
}


void Test3D(void)
{
	int i;	

	//ReadID();
	SGX540_3D_Autotest();
//	Execute3DVector();
  	while(1) 
  	{
		PrintSubMessage();
		UART_Printf("\nSelect(-1 to exit): ");
		i = GetIntNum();
		
		if(i==-1) break;
		
		if(i>=0 && (i<(sizeof(SGX540_3D_func)/8)) ) 
	    	( (void (*)(void)) (SGX540_3D_func[i][0]) )();	// execute selected function.
	}

}



typedef		struct __SCR_SIZE
{
	u32	uWidth;
	u32 uHeight;
} DISP_SIZE;

	

int CovSGX540FB2LCD(u32 *pDestAddr, DISP_SIZE sSrcDispSize, u32 *pSrcAddr, DISP_SIZE sTargetDispSize, u32 uPixelSizeInBytes)
{
	u32 i, uOffsetX, uOffsetY, uTempSize[3];
	u32 *pDest = NULL, *pSrc = NULL;
	pDest = pDestAddr;
	pSrc = pSrcAddr;
	

	
	
	if((sTargetDispSize.uWidth < sSrcDispSize.uWidth) || (sTargetDispSize.uHeight < sSrcDispSize.uHeight))
	{
		UART_Printf("\nError : target display size is great than source display size");
		return -1;
	}
	
	uOffsetX = sTargetDispSize.uWidth - sSrcDispSize.uWidth;
	uOffsetY = sTargetDispSize.uHeight - sSrcDispSize.uHeight;
	uTempSize[0] = (sSrcDispSize.uWidth*uPixelSizeInBytes);
	uTempSize[1] = (uOffsetX*uPixelSizeInBytes);
	for(i=0; i<sSrcDispSize.uHeight; i++)
	{
		memcpy(pDest,pSrc,uTempSize[0]);	
		pSrc += uTempSize[0]>>2; 
		pDest += uTempSize[0]>>2;		
		
		memset(pDest,0x00,uTempSize[1]);	
		pDest += (uTempSize[1]>>2);		
	}
	if(uOffsetY)
		memset(pDest,0x00,sizeof(u32)*uOffsetY*sTargetDispSize.uWidth*uPixelSizeInBytes); //Fill residue space
	return 1;	
}



int PowerOnOffSGX540Block(void)
{
		// T-Block Power Off and On
		SYSC_SetBlockPowerOFF_IP(eSGX540);
		DelayfrTimer(milli, rand()%10);			// under 10ms
		AccessOtherRegsInClockPowerOff(CPTEST_G3D,1);
		SYSC_SetBlockPowerON_IP(eSGX540);
		return 1;
}


int ClockGatingOnOffSGX540(void)
{
	// IP Clock Off and On Before IP Running.....
		SYSC_SetClkOFF_IP(eSGX540);		
		DelayfrTimer(milli, rand()%10);			// under 10ms
		AccessOtherRegsInClockPowerOff(CPTEST_G3D,1);
		SYSC_SetClkON_IP(eSGX540);
}


int RandomPowerMode(void)
{
	DelayfrTimer(milli, rand()%1000);
	// Entering the random power mode(Idle, Deep Idle, Stop, Deep Stop, Sleep, & S/W reset)
	SYSCT_TestSimplePowerMode_Temp(rand()%6+1);	
}







int	Execute3DVector(void)
{
	u32 uSel, i = 0, counter;
	static u32 uLcdFbAddr, uLcdHSz, uLcdVSz;	
	DISP_SIZE	sSGXFB, sLCD;
	IMG_FMT eLcdBpp;	
#ifdef		ATEST_3D
	unsigned int u3DCheckSum = 0;
	unsigned char *p_u3DFrameBuff;
#endif	
	
	char pMEMFileName[512]="";
	char pPRMFileName[512]="";
	char pSaveFileName[512]="";
	uLcdFbAddr = CODEC_MEM_ST;

	counter = sizeof(stVectorList)/sizeof(SGXVectorList);	
	 
	
	sSGXFB.uWidth = 800;
	sSGXFB.uHeight = 480;
	
	sLCD.uWidth = 800;
	sLCD.uHeight = 480;
	
	eLcdBpp = RGB24; //eLcdBpp = RGB16;
	uLcdHSz = 800;
	uLcdVSz = 480;
	
	IEIP_Select(DISP_BYPASS);
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eLcdBpp, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, WIN0);

	LCDC_Start();
	memset((void*)CODEC_MEM_ST, 0xFF, sLCD.uWidth*sLCD.uHeight*sizeof(int));

	SGX_WRITEL(0xf3000D00, 0x00000400);//SLC off
	//SFRTestVector();
	

#ifdef		ATEST_3D				//AUTO TEST

	sSGXFB.uHeight = 480;
	sSGXFB.uWidth = 640;
	p_u3DFrameBuff = (unsigned char *)0x20543000;
	memcpy((unsigned char*)ADDR_3D_PRM, cPrmLenna,LENNA_SIZE);
	dx_wireframe_8888_fpmn_lenna("lenna",0);	
	for(i=0; i< LENNA_SIZE; i++)
	{		
		u3DCheckSum += (unsigned int)(p_u3DFrameBuff);		
	}
	if(u3DCheckSum !=LENNA_CHECKSUM)
	{
		UART_Printf("\nError - 3D Test CheckSum Error --> Fail !!!!!!!!!!!");
		return 1;				
	}	
#else	
	while(1)
	{ 
		UART_Printf("\n\n");
		UART_Printf("***************************************************\n");
		UART_Printf("*       S5PV210 - 3D(SGX540) Test                            *\n");
		UART_Printf("***************************************************\n");		
	
		for (i=0; i<counter; i++)
		{
			UART_Printf("%2d: %s  ", i, stVectorList[i].psVectorName);
			if(((i+1)%2)==0)
				Putc('\n');
		}
		
		UART_Printf("\n\nSelect the function to test : ");
		uSel =UART_GetIntNum();
		UART_Printf("\n");

INFINITE :
		if (uSel<=counter)		
		{
			
			//uSel = i;
			//if (uSel<=counter)
			for (i=uSel; i<counter; i++)
			{
				//Init Name Buffer
				memset(pMEMFileName,0x0,sizeof(pMEMFileName));
				memset(pPRMFileName,0x0,sizeof(pPRMFileName));
				memset(pSaveFileName,0x0,sizeof(pSaveFileName));
				strcpy(pMEMFileName,REF_PATH);
						
				strcat(pMEMFileName, stVectorList[i].psVectorName);
				strcpy(pPRMFileName, pMEMFileName);
				strcpy(pSaveFileName, pMEMFileName);
				
				strcat(pMEMFileName,".mem");
				strcat(pPRMFileName,".prm");
				strcat(pSaveFileName,".dmp");
				
				//LoadFromFile(pMEMFileName,ADDR_3D_MEM);
				UART_Printf("\nNow Loading %s file", pPRMFileName);			
				LoadFromFile(pPRMFileName,ADDR_3D_PRM);						
				UART_Printf("\nLoading is completed");	
				(stVectorList[i].fp) (stVectorList[i].psVectorName, 0);
				
				sSGXFB.uHeight = stVectorList[i].Height;
				sSGXFB.uWidth = stVectorList[i].Width;
				
				CovSGX540FB2LCD((u32*)CODEC_MEM_ST,sSGXFB,(u32*)stVectorList[i].FrameBufAddr ,sLCD,sizeof(int));
				
				remove(pSaveFileName);
				SaveToFile(pSaveFileName, sLCD.uHeight*sLCD.uWidth*4,(u32)stVectorList[i].FrameBufAddr);
				UART_Printf("\nComplete # %d test : %s is saved ", i,pSaveFileName);
			}
		}
		UART_Printf("\nAll Test is completed");
goto INFINITE;					


	}
#endif
	return 0;

}


int	PowerOnOff(void)
{
	u32 uSel, i = 0, counter;
	static u32 uLcdFbAddr, uLcdHSz, uLcdVSz;	
	DISP_SIZE	sSGXFB, sLCD;
	IMG_FMT eLcdBpp;	
#ifdef		ATEST_3D
	unsigned int u3DCheckSum = 0;
	unsigned char *p_u3DFrameBuff;
#endif	
	
	char pMEMFileName[512]="";
	char pPRMFileName[512]="";
	char pSaveFileName[512]="";
	uLcdFbAddr = CODEC_MEM_ST;

	counter = sizeof(stVectorList)/sizeof(SGXVectorList);	
	 
	
	sSGXFB.uWidth = 800;
	sSGXFB.uHeight = 480;
	
	sLCD.uWidth = 800;
	sLCD.uHeight = 480;
	
	eLcdBpp = RGB24; //eLcdBpp = RGB16;
	uLcdHSz = 800;
	uLcdVSz = 480;
	
	IEIP_Select(DISP_BYPASS);
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eLcdBpp, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, WIN0);

	LCDC_Start();
	memset((void*)CODEC_MEM_ST, 0xFF, sLCD.uWidth*sLCD.uHeight*sizeof(int));

	SGX_WRITEL(0xf3000D00, 0x00000400);//SLC off
	//SFRTestVector();
	
	
	PowerOnOffSGX540Block();



	

#ifdef		ATEST_3D				//AUTO TEST

	sSGXFB.uHeight = 480;
	sSGXFB.uWidth = 640;
	p_u3DFrameBuff = (unsigned char *)0x20543000;
	memcpy((unsigned char*)ADDR_3D_PRM, cPrmLenna,LENNA_SIZE);
	dx_wireframe_8888_fpmn_lenna("lenna",0);	
	for(i=0; i< LENNA_SIZE; i++)
	{		
		u3DCheckSum += (unsigned int)(p_u3DFrameBuff);		
	}
	if(u3DCheckSum !=LENNA_CHECKSUM)
	{
		UART_Printf("\nError - 3D Test CheckSum Error --> Fail !!!!!!!!!!!");
		return 1;				
	}	
#else	
	while(1)
	{ 
		UART_Printf("\n\n");
		UART_Printf("***************************************************\n");
		UART_Printf("*       S5PV210 - 3D(SGX540) Test                            *\n");
		UART_Printf("***************************************************\n");		
	
		for (i=0; i<counter; i++)
		{
			UART_Printf("%2d: %s  ", i, stVectorList[i].psVectorName);
			if(((i+1)%2)==0)
				Putc('\n');
		}
		
		UART_Printf("\n\nSelect the function to test : ");
		uSel =UART_GetIntNum();
		UART_Printf("\n");

INFINITE :
		if (uSel<=counter)		
		{
			
			//uSel = i;
			//if (uSel<=counter)
			for (i=uSel; i<counter; i++)
			{
				//Init Name Buffer
				memset(pMEMFileName,0x0,sizeof(pMEMFileName));
				memset(pPRMFileName,0x0,sizeof(pPRMFileName));
				memset(pSaveFileName,0x0,sizeof(pSaveFileName));
				strcpy(pMEMFileName,REF_PATH);
						
				strcat(pMEMFileName, stVectorList[i].psVectorName);
				strcpy(pPRMFileName, pMEMFileName);
				strcpy(pSaveFileName, pMEMFileName);
				
				strcat(pMEMFileName,".mem");
				strcat(pPRMFileName,".prm");
				strcat(pSaveFileName,".dmp");
				
				//LoadFromFile(pMEMFileName,ADDR_3D_MEM);
				UART_Printf("\nNow Loading %s file", pPRMFileName);			
				LoadFromFile(pPRMFileName,ADDR_3D_PRM);						
				UART_Printf("\nLoading is completed");	
				(stVectorList[i].fp) (stVectorList[i].psVectorName, 0);
				
				sSGXFB.uHeight = stVectorList[i].Height;
				sSGXFB.uWidth = stVectorList[i].Width;
				
				CovSGX540FB2LCD((u32*)CODEC_MEM_ST,sSGXFB,(u32*)stVectorList[i].FrameBufAddr ,sLCD,sizeof(int));
				
				remove(pSaveFileName);
				SaveToFile(pSaveFileName, sLCD.uHeight*sLCD.uWidth*4,(u32)stVectorList[i].FrameBufAddr);
				UART_Printf("\nComplete # %d test : %s is saved ", i,pSaveFileName);
			}
		}
		UART_Printf("\nAll Test is completed");
goto INFINITE;					


	}
#endif
	return 0;

}


int	ClokcGatingOnOff(void)
{
	u32 uSel, i = 0, counter;
	static u32 uLcdFbAddr, uLcdHSz, uLcdVSz;	
	DISP_SIZE	sSGXFB, sLCD;
	IMG_FMT eLcdBpp;	
#ifdef		ATEST_3D
	unsigned int u3DCheckSum = 0;
	unsigned char *p_u3DFrameBuff;
#endif	
	
	char pMEMFileName[512]="";
	char pPRMFileName[512]="";
	char pSaveFileName[512]="";
	uLcdFbAddr = CODEC_MEM_ST;

	counter = sizeof(stVectorList)/sizeof(SGXVectorList);	
	 
	
	sSGXFB.uWidth = 800;
	sSGXFB.uHeight = 480;
	
	sLCD.uWidth = 800;
	sLCD.uHeight = 480;
	
	eLcdBpp = RGB24; //eLcdBpp = RGB16;
	uLcdHSz = 800;
	uLcdVSz = 480;
	
	IEIP_Select(DISP_BYPASS);
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eLcdBpp, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, WIN0);

	LCDC_Start();
	memset((void*)CODEC_MEM_ST, 0xFF, sLCD.uWidth*sLCD.uHeight*sizeof(int));

	SGX_WRITEL(0xf3000D00, 0x00000400);//SLC off
	//SFRTestVector();
	
	ClockGatingOnOffSGX540();





#ifdef		ATEST_3D				//AUTO TEST

	sSGXFB.uHeight = 480;
	sSGXFB.uWidth = 640;
	p_u3DFrameBuff = (unsigned char *)0x20543000;
	memcpy((unsigned char*)ADDR_3D_PRM, cPrmLenna,LENNA_SIZE);
	dx_wireframe_8888_fpmn_lenna("lenna",0);	
	for(i=0; i< LENNA_SIZE; i++)
	{		
		u3DCheckSum += (unsigned int)(p_u3DFrameBuff);		
	}
	if(u3DCheckSum !=LENNA_CHECKSUM)
	{
		UART_Printf("\nError - 3D Test CheckSum Error --> Fail !!!!!!!!!!!");
		return 1;				
	}	
#else	
	while(1)
	{ 
		UART_Printf("\n\n");
		UART_Printf("***************************************************\n");
		UART_Printf("*       S5PV210 - 3D(SGX540) Test                            *\n");
		UART_Printf("***************************************************\n");		
	
		for (i=0; i<counter; i++)
		{
			UART_Printf("%2d: %s  ", i, stVectorList[i].psVectorName);
			if(((i+1)%2)==0)
				Putc('\n');
		}
		
		UART_Printf("\n\nSelect the function to test : ");
		uSel =UART_GetIntNum();
		UART_Printf("\n");

INFINITE :
		if (uSel<=counter)		
		{
			
			//uSel = i;
			//if (uSel<=counter)
			for (i=uSel; i<counter; i++)
			{
				//Init Name Buffer
				memset(pMEMFileName,0x0,sizeof(pMEMFileName));
				memset(pPRMFileName,0x0,sizeof(pPRMFileName));
				memset(pSaveFileName,0x0,sizeof(pSaveFileName));
				strcpy(pMEMFileName,REF_PATH);
						
				strcat(pMEMFileName, stVectorList[i].psVectorName);
				strcpy(pPRMFileName, pMEMFileName);
				strcpy(pSaveFileName, pMEMFileName);
				
				strcat(pMEMFileName,".mem");
				strcat(pPRMFileName,".prm");
				strcat(pSaveFileName,".dmp");
				
				//LoadFromFile(pMEMFileName,ADDR_3D_MEM);
				UART_Printf("\nNow Loading %s file", pPRMFileName);			
				LoadFromFile(pPRMFileName,ADDR_3D_PRM);						
				UART_Printf("\nLoading is completed");	
				(stVectorList[i].fp) (stVectorList[i].psVectorName, 0);
				
				sSGXFB.uHeight = stVectorList[i].Height;
				sSGXFB.uWidth = stVectorList[i].Width;
				
				CovSGX540FB2LCD((u32*)CODEC_MEM_ST,sSGXFB,(u32*)stVectorList[i].FrameBufAddr ,sLCD,sizeof(int));
				
				remove(pSaveFileName);
				SaveToFile(pSaveFileName, sLCD.uHeight*sLCD.uWidth*4,(u32)stVectorList[i].FrameBufAddr);
				UART_Printf("\nComplete # %d test : %s is saved ", i,pSaveFileName);
			}
		}
		UART_Printf("\nAll Test is completed");
goto INFINITE;					


	}
#endif
	return 0;

}


int	RandPowerMode(void)
{
	u32 uSel, i = 0, counter;
	static u32 uLcdFbAddr, uLcdHSz, uLcdVSz;	
	DISP_SIZE	sSGXFB, sLCD;
	IMG_FMT eLcdBpp;	
#ifdef		ATEST_3D
	unsigned int u3DCheckSum = 0;
	unsigned char *p_u3DFrameBuff;
#endif	
	
	char pMEMFileName[512]="";
	char pPRMFileName[512]="";
	char pSaveFileName[512]="";
	uLcdFbAddr = CODEC_MEM_ST;

	counter = sizeof(stVectorList)/sizeof(SGXVectorList);	
	 
	
	sSGXFB.uWidth = 800;
	sSGXFB.uHeight = 480;
	
	sLCD.uWidth = 800;
	sLCD.uHeight = 480;
	
	eLcdBpp = RGB24; //eLcdBpp = RGB16;
	uLcdHSz = 800;
	uLcdVSz = 480;
	
	IEIP_Select(DISP_BYPASS);
	LCDC_InitLdi(MAIN);
	LCDC_InitIp(eLcdBpp, uLcdFbAddr, WIN0, false);
	LCDC_SetWinOnOff(1, WIN0);
	LCDC_GetFrmSz(&uLcdHSz, &uLcdVSz, WIN0);

	LCDC_Start();
	memset((void*)CODEC_MEM_ST, 0xFF, sLCD.uWidth*sLCD.uHeight*sizeof(int));

	SGX_WRITEL(0xf3000D00, 0x00000400);//SLC off
	//SFRTestVector();
	RandomPowerMode();


#ifdef		ATEST_3D				//AUTO TEST

	sSGXFB.uHeight = 480;
	sSGXFB.uWidth = 640;
	p_u3DFrameBuff = (unsigned char *)0x20543000;
	memcpy((unsigned char*)ADDR_3D_PRM, cPrmLenna,LENNA_SIZE);
	dx_wireframe_8888_fpmn_lenna("lenna",0);	
	for(i=0; i< LENNA_SIZE; i++)
	{		
		u3DCheckSum += (unsigned int)(p_u3DFrameBuff);		
	}
	if(u3DCheckSum !=LENNA_CHECKSUM)
	{
		UART_Printf("\nError - 3D Test CheckSum Error --> Fail !!!!!!!!!!!");
		return 1;				
	}	
#else	
	while(1)
	{ 
		UART_Printf("\n\n");
		UART_Printf("***************************************************\n");
		UART_Printf("*       S5PV210 - 3D(SGX540) Test                            *\n");
		UART_Printf("***************************************************\n");		
	
		for (i=0; i<counter; i++)
		{
			UART_Printf("%2d: %s  ", i, stVectorList[i].psVectorName);
			if(((i+1)%2)==0)
				Putc('\n');
		}
		
		UART_Printf("\n\nSelect the function to test : ");
		uSel =UART_GetIntNum();
		UART_Printf("\n");

INFINITE :
		if (uSel<=counter)		
		{
			
			//uSel = i;
			//if (uSel<=counter)
			for (i=uSel; i<counter; i++)
			{
				//Init Name Buffer
				memset(pMEMFileName,0x0,sizeof(pMEMFileName));
				memset(pPRMFileName,0x0,sizeof(pPRMFileName));
				memset(pSaveFileName,0x0,sizeof(pSaveFileName));
				strcpy(pMEMFileName,REF_PATH);
						
				strcat(pMEMFileName, stVectorList[i].psVectorName);
				strcpy(pPRMFileName, pMEMFileName);
				strcpy(pSaveFileName, pMEMFileName);
				
				strcat(pMEMFileName,".mem");
				strcat(pPRMFileName,".prm");
				strcat(pSaveFileName,".dmp");
				
				//LoadFromFile(pMEMFileName,ADDR_3D_MEM);
				UART_Printf("\nNow Loading %s file", pPRMFileName);			
				LoadFromFile(pPRMFileName,ADDR_3D_PRM);						
				UART_Printf("\nLoading is completed");	
				(stVectorList[i].fp) (stVectorList[i].psVectorName, 0);
				
				sSGXFB.uHeight = stVectorList[i].Height;
				sSGXFB.uWidth = stVectorList[i].Width;
				
				CovSGX540FB2LCD((u32*)CODEC_MEM_ST,sSGXFB,(u32*)stVectorList[i].FrameBufAddr ,sLCD,sizeof(int));
				
				remove(pSaveFileName);
				SaveToFile(pSaveFileName, sLCD.uHeight*sLCD.uWidth*4,(u32)stVectorList[i].FrameBufAddr);
				UART_Printf("\nComplete # %d test : %s is saved ", i,pSaveFileName);
			}
		}
		UART_Printf("\nAll Test is completed");
goto INFINITE;					


	}
#endif
	return 0;

}


#if (0)
void DumpFrameBuffer(char * VectorName, unsigned int ByteCnt, unsigned int Address)
{
    static unsigned int uiFileCount = 0;
#if (SGX540_SEMIHOSTING)
    char asFileName[256];
    FILE * pf = NULL;

    memset(asFileName, 0, sizeof(asFileName));
    sprintf(asFileName, "%s%d%s", VectorName, uiFileCount, ".bin");
    
    pf = fopen(asFileName, "ab");
	SGX_WRITE_FILE(asFileName, ByteCnt, Address);
	fclose(pf);
	uiFileCount++;
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */      
}

void DumpTASignature(char * VectorName, int bWriteFile)
{
    static unsigned int uiTAFileCount = 0;
    static char asTAFile[256];
    unsigned int uiWriteSize;
    unsigned int auiSignature[5];
    int i = 0;
    FILE * pf = NULL;
    
    // Dump TA signature registers
    SGX_READ_REG(CLIP_SIG1,     auiSignature[0]);
    SGX_READ_REG(MTE_SIG1,      auiSignature[1]);
    SGX_READ_REG(MTE_SIG2,      auiSignature[2]);
    SGX_READ_REG(TE1,           auiSignature[3]);
    SGX_READ_REG(TE2,           auiSignature[4]);
    
    SGX_COM("\nTA Signature Register\n\t");
    for(i = 0; i < 5; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

#if (SGX540_SEMIHOSTING)
    if(strstr(asTAFile, VectorName) == NULL)
    {
        uiTAFileCount = 0;
    }

    if(bWriteFile)
    {
		//strcpy(asFileName, VectorName);
        //strcat(asFileName, "_ta.sig");
        memset(asTAFile, 0, sizeof(asTAFile));
        sprintf(asTAFile, "%s%s%d%s", VectorName, "_ta", uiTAFileCount, ".sig");
        
        pf = fopen(asTAFile, "ab");
		uiWriteSize = fwrite((unsigned char *)auiSignature, sizeof(unsigned char), (5 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0)
		{
		    SGX_COM("Error total size of file write is 0 byte.\n");
		}

		fclose(pf);
		uiTAFileCount++;
    }
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */  
  
}

void Dump3DSignature(char * VectorName, int bWriteFile)
{
    static unsigned int ui3DFileCount = 0;
    static char as3DSigFile[256];
    unsigned int uiWriteSize;
    unsigned int auiSignature[7];
    int i = 0;
    FILE * pf = NULL;
    
    // Dump 3D signature registers
    SGX_READ_REG(ISP_FPU,       auiSignature[0]);
    SGX_READ_REG(ISP_SIG1,      auiSignature[1]);
    SGX_READ_REG(ISP_SIG2,      auiSignature[2]);
    SGX_READ_REG(ISP_SIG3,      auiSignature[3]);
    SGX_READ_REG(ISP_SIG4,      auiSignature[4]);
    SGX_READ_REG(PIXELBE_SIG01, auiSignature[5]);
    SGX_READ_REG(PIXELBE_SIG02, auiSignature[6]);

    SGX_COM("3D Signature Register\n\t");
    for(i = 0; i < 7; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

#if (SGX540_SEMIHOSTING)
    if(strstr(as3DSigFile, VectorName) == NULL)
    {
        ui3DFileCount = 0;
    }

    if(bWriteFile)
    {
		//strcpy(asFileName, VectorName);
        //strcat(asFileName, "_3d.sig");
        memset(as3DSigFile, 0, sizeof(as3DSigFile));
        sprintf(as3DSigFile, "%s%s%d%s", VectorName, "_3d", ui3DFileCount, ".sig");
        
		pf = fopen(as3DSigFile, "ab");
		uiWriteSize = fwrite((unsigned char *)(auiSignature + 5), sizeof(unsigned char), (7 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0)
		{
		    SGX_COM("Error total size of file write is 0 byte.\n");
		}
		
		fclose(pf);
		ui3DFileCount++;
    }
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */  
}

void DumpPerfCounter(char * VectorName, int bWriteFile)
{
    static unsigned int uiPerfFileCount = 0;
    static char asPerfFile[256];
    unsigned int uiWriteSize;
    unsigned int auiSignature[22];
    int i = 0;
    FILE * pf = NULL;
    
    // Dump performance counter registers
    SGX_READ_REG(PERF,          auiSignature[12]);
    SGX_READ_REG(PERF_COUNTER0, auiSignature[13]);
    SGX_READ_REG(PERF_COUNTER1, auiSignature[14]);
    SGX_READ_REG(PERF_COUNTER2, auiSignature[15]);
    SGX_READ_REG(PERF_COUNTER3, auiSignature[16]);
    SGX_READ_REG(PERF_COUNTER4, auiSignature[17]);
    SGX_READ_REG(PERF_COUNTER5, auiSignature[18]);
    SGX_READ_REG(PERF_COUNTER6, auiSignature[19]);
    SGX_READ_REG(PERF_COUNTER7, auiSignature[20]);
    SGX_READ_REG(PERF_COUNTER8, auiSignature[21]);
    
    SGX_COM("Performance Counter Register\n\t");
    for(i = 0; i < 10; i++)
    {
        SGX_COM("%08X  ");
        if(i % 4 == 3) SGX_COM("\n\t");
    }

#if (SGX540_SEMIHOSTING)
    if(strstr(asPerfFile, VectorName) == NULL)
    {
        uiPerfFileCount = 0;
    }

    if(bWriteFile)
    {
		//strcpy(asFileName, VectorName);
        //strcat(asFileName, ".perf");
        memset(asPerfFile, 0, sizeof(asPerfFile));
        sprintf(asPerfFile, "%s%s%d%s", VectorName, "_3d", uiPerfFileCount, ".sig");

		pf = fopen(asPerfFile, "ab");
		uiWriteSize = fwrite((unsigned char *)(auiSignature + 12), sizeof(unsigned char), (10 * sizeof(unsigned int)), pf);
		if(uiWriteSize == 0) SGX_COM("Error total size of file write is 0 byte.\n");

		fclose(pf);
		uiPerfFileCount++;
    }
#else
    SGX_COM("Error due to unsupport semihosting file write fail.\n");
#endif /* End of SEMIHOSTING */  
}

#endif
